//================================================================
//
// CalculateTable.js   
//
// Implementation of the 'standard' toolpath now/later buttons
//
// ----------------------------------------------------------------------------
// COPYRIGHT 2004 DELCAM PLC., BIRMINGHAM, ENGLAND. 
// ----------------------------------------------------------------------------
//
// History.
// Who When     What   
// --- -------- ---------------------------------------------------------------
// pah 30/04/04 Added this header. Entry level does not have Later button
//-----------------------------------------------------------------------------

//=== CreateCalculateTable()==============================================

function CreateCalculateTable(image_path, include_preview)
{
   if( arguments.length == 1 )
      include_preview = false;

   var bRemoveLaterButton = false;
   if (!artcam.IsCommandLicensed(58227))  // Batch Calculate Toolpaths command
      bRemoveLaterButton = true;
   
   document.writeln("<table width='100%' border=0 cellspacing=0 style='TABLE-LAYOUT: fixed'>");
   document.writeln("<col width = 40px> <col width = '30%'> <col width = '35%'> <col width = '35%'>");
   //document.writeln("<tr><td></td><td colspan=3><HR></td></tr>");
   
   document.writeln("<tr><td></td><td colspan=3 height=2px></td></tr>");
   document.writeln("<tr><td></td><td colspan=3 bgcolor=buttonshadow></td></tr>");
   document.writeln("<tr><td></td><td colspan=3 bgcolor=buttonhighlight></td></tr>");
   document.writeln("<tr><td></td><td colspan=3 height=2px></td></tr>");
   
   if(include_preview)
   {
      document.writeln("<tr><td  valign=top><IMG align=top src = " + image_path + "></td>");
      document.writeln("<td colspan=3>");
      document.writeln("   <table><tr><td><b>" + gToolpathLabelText + "</b></td>");
      document.writeln("      <td><b><input id='KeepPreviewVectors' type=checkbox onclick='ToggleKeepPreviewVectors()'></b></td>");
      document.writeln("      <td>" + gCreatePreviewVectorsText + "</td></tr>");
      document.writeln("   </table>");
      document.writeln("</td></tr>");
      document.writeln("<tr><td>&nbsp;</td>");
      document.writeln("<td><b>" + gToolpathNameText + "</b></td>");
      document.writeln("<td colspan=2 align=middle><input id='ToolpathNameEdit' style='width:100%'></td></tr>");
   }
   else
   {
      document.writeln("<tr><td  valign=top><IMG align=top src = " + image_path + "></td>");
      document.writeln("<td><b>" + gToolpathNameText + "</b></td>");
      document.writeln("<td colspan=2 align=middle><input id='ToolpathNameEdit' style='width:100%'></td></tr>");
   }
            
   document.writeln("<tr HELPTAG style='display:none'><td></td><td colspan=3>"); 

   if(bRemoveLaterButton)
   {
      document.writeln("<script>w(gCalculateToolpathEntryHelp)</script></td></tr>");

      document.writeln("<tr><td></td>");
      document.writeln("<td><b>" + gCalculateText + "</b></td>");
      document.writeln("<td align=middle><input id='CalculateButton' type='button' style='width:100%' onClick='OnCalculate(true)'></td>");
      document.writeln("</tr></table>");

      CalculateButton.value=gNowText;
   }
   else
   {
      document.writeln("<script>w(gCalculateToolpathHelp)</script></td></tr>");

      document.writeln("<tr><td></td>");
      document.writeln("<td><b>" + gCalculateText + "</b></td>");
      document.writeln("<td align=middle><input id='ApplyButton' type='button' style='width:100%' onClick='OnCalculate(false)'></td>");
      document.writeln("<td align=middle><input id='CalculateButton' type='button' style='width:100%' onClick='OnCalculate(true)'></td>");
      document.writeln("</tr></table>");
      
      ApplyButton.value=gLaterText;
      ApplyButton.style.backgroundColor = 'indianred';    
      ApplyButton.style.borderColor = 'coral';   
      ApplyButton.style.color = 'white';   
      CalculateButton.value=gNowText;
   }   
}

function CreateReliefInfoRows()
{  
document.writeln("<tr><td valign=top><IMG src='../../SharedImages/TeddyBearRelief.gif' align=top></td>");
document.writeln("<td colspan=1 id=ReliefHeaderBar onclick=ToggleRelief()>");
document.writeln("<img id=reliefOpenCloseButton src='../../SharedImages/close_up_small_blue.gif' align=right>");
document.writeln("<span><b><script>w(gRelief)</script></b></span>");
document.writeln("<span id='spanReliefSummaryThickness'></span></td></tr>");
      
document.writeln("<tr><td></td><td colspan=3><div id = ReliefDiv>");
document.writeln("<table class=Dialog border=0>");

document.writeln("<tr><td align=right rowspan=3><IMG src='../../SharedImages/ReliefBlock.gif'></td>");
document.writeln("<td><script>w(gThickness)</script></td>");
document.writeln("<td><span id='spanReliefThickness'>0 mm</span></td></tr>");
            
document.writeln("<tr><td><script>w(gMaxZ)</script></td>");
document.writeln("<td><span id='spanReliefMaxZ'>-25 mm</span></td></tr>");
document.writeln("<tr><td><script>w(gMinZ)</script></td>");
document.writeln("<td><span id='spanReliefMinZ'>-25 mm</span></td></tr></table></div>");
document.writeln("</tr></td>");             
            
document.writeln("<tr HELPTAG style='display:none'><td></td><td colspan=3>"); 
document.writeln("<p><script>w(gReliefHelp)</script><BR><BR></p></td></tr>");

ReliefHeaderBar.bgColor=artcam.GetSystemColourShadeString(COLOR_BTNFACE,2,COLOR_BTNSHADOW,1);
}


// === ToggleRelief ==============================================================
//
//

function ToggleRelief()
{
   // Toggle the visibility of the span and the Div
   ToggleVisibility(ReliefDiv);

   // if relief is now invisible we set the 'button' to down arrow - else up
   if (ReliefDiv.style.display != "none")
      reliefOpenCloseButton.src = "../../SharedImages/close_up_small_blue.gif"
   else
      reliefOpenCloseButton.src = "../../SharedImages/open_down_small_blue.gif"

   // Update the text
   UpdateReliefText();
}

// === UpdateReliefText =========================================
//
//
function UpdateReliefText()    
{
   // Check that a relief exists

   if ( artcam.Relief.Exists)
      {

      var reliefMaxZ = Math.round( artcam.CompositeRelief.MaxZ * 1000 ) / 1000; // Round to 3dp.
      var reliefMinZ = Math.round( artcam.CompositeRelief.MinZ * 1000 ) / 1000; // Round to 3dp.
      var reliefThickness = Math.round((reliefMaxZ - reliefMinZ) * 1000 ) / 1000; // Round to 3dp.

      // Get our Units
      var units = "mm";
      if ( ! artcam.CompositeRelief.InMM )
       units = "inches";

      // Set text
      spanReliefThickness.innerText = reliefThickness + " " + units;
      spanReliefMaxZ.innerText = reliefMaxZ + " " + units;
      spanReliefMinZ.innerText = reliefMinZ + " " + units;
      
      if (ReliefDiv.style.display != "none")
         spanReliefSummaryThickness.innerHTML = "";
      else
         spanReliefSummaryThickness.innerHTML = "<b>" + gThickness + "</b> " + reliefThickness + " " + units;

      }
   else  // we have no relief
      {
      alert("No Relief Detected");
      // Set the example text to warn user that there is no relief
      spanReliefThickness.innerHTML = "<font color='firebrick'>&lt;Undefined&gt;</font>";
      spanReliefSummaryThickness.innerHTML = "<font color='firebrick'>&lt;Undefined&gt;</font>";
      spanReliefMinZ.innerHTML = "<font color='firebrick'>&lt;Undefined&gt;</font>";
      spanReliefMaxZ.innerHTML = "<font color='firebrick'>&lt;Undefined&gt;</font>";
      }
}




//=== CreateCalculateTableNoLater ==============================================
//
// added to stop the laser having a later button this overcomes a bug and should 
// be removed for 6.0 or when found next

// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sap 08/07/02 Written
//-----------------------------------------------------------------------

function CreateCalculateTableNoLater(image_path, include_preview)
{
   if( arguments.length == 1 )
      include_preview = false;
   
   document.writeln("<table width='100%' border=0 cellspacing=0 style='TABLE-LAYOUT: fixed'>");
   document.writeln("<col width = 40px> <col width = '30%'> <col width = '35%'> <col width = '35%'>");
   //document.writeln("<tr><td></td><td colspan=3><HR></td></tr>");
   
   document.writeln("<tr><td></td><td colspan=3 height=2px></td></tr>");
   document.writeln("<tr><td></td><td colspan=3 bgcolor=buttonshadow></td></tr>");
   document.writeln("<tr><td></td><td colspan=3 bgcolor=buttonhighlight></td></tr>");
   document.writeln("<tr><td></td><td colspan=3 height=2px></td></tr>");
   
   if(include_preview)
   {
      document.writeln("<tr><td  valign=top><IMG align=top src = " + image_path + "></td>");
      document.writeln("<td><b>" + gToolpathLabelText + "</b></td>");
      document.writeln("<td colspan=2><input id='KeepPreviewVectors' type=checkbox onclick='ToggleKeepPreviewVectors()'> " + gCreatePreviewVectorsText);
      document.writeln("</td></tr>");
      document.writeln("<tr><td>&nbsp;</td>");
      document.writeln("<td><b>" + gToolpathNameText + "</b></td>");
      document.writeln("<td colspan=2 align=middle><input id='ToolpathNameEdit' style='width:90%'></td></tr>");
   }
   else
   {
      document.writeln("<tr><td  valign=top><IMG align=top src = " + image_path + "></td>");
      document.writeln("<td><b>" + gToolpathNameText + "</b></td>");
      document.writeln("<td colspan=2 align=middle><input id='ToolpathNameEdit' style='width:90%'></td></tr>");
   }
            
   document.writeln("<tr HELPTAG style='display:none'><td></td><td colspan=3>"); 
   document.writeln("</td></tr>");

   document.writeln("<tr><td></td>");
   document.writeln("<td colspan=3 align=middle><input id='CalculateButton' type='button' style='width:60%' onClick='OnCalculate(true)'></td>");
   document.writeln("</tr></table>");
   CalculateButton.value=gCalculateText;
}
