function GetEventItem(ev)
{
   if(ev.srcElement.button_name != null)
      return ev.srcElement;
   if(ev.srcElement.parentElement.button_name != null)
      return ev.srcElement.parentElement;
   return null;
}

function OnItemMouseOver()
{
   var item = GetEventItem(event);
   if(item != null)
      item.className = "mouseOver";
}

function OnItemMouseOut()
{
   var item = GetEventItem(event);
   if(item != null)
      item.className = "mouseOut";
}

function OnItemMouseDown()
{
   var item = GetEventItem(event);
   if(item != null)
      item.className = "mouseDown";
}

function OnItemMouseUp()
{
   var item = GetEventItem(event);
   if(item == null)
   {
      //alert("Item is null");
      return;
   }
   
   var item = GetEventItem(event);
   if(item != null)
   {
      item.className = "mouseOver";
      // If the button_name contains a file path we need to sort out the slashes
      if(item.targetFunction==undefined)
      {
         alert("This button's target function is undefined");
         return;
      }
      var function_call;
      if(item.functionArgs!=undefined)
      {
      // If the functionArgs contains a file path we need to sort out the slashes
         var path = item.functionArgs.replace(/\\/g, "\\\\" );
         function_call = item.targetFunction + "('" + path + "')";
      }
      else
      {
         function_call = item.targetFunction +"()";
      }

      if(item.targetFunctionObj != null)
      {
         function_call = "item.targetFunctionObj." + function_call;
      }

      eval(function_call);
   }
}

function InitialiseButtonDivs()
{
  var tags = document.all.tags("div");
  var idx, tag;
  var count = tags.length;
  for( idx = 0; idx < count; idx ++ )
  {
    tag = tags[idx];
    if( tag.button_name != null && tag.disabled!=true)
    {
     tag.onmouseover=OnItemMouseOver;
     tag.onmouseout=OnItemMouseOut;
     tag.onmousedown=OnItemMouseDown;
     tag.onmouseup=OnItemMouseUp;
    }
  }
}

function ActivateButton(id)
{
   var tag = eval(id);
    if( tag.button_name != null)
    {
     tag.className = "mouseOut";
     tag.onmouseover=OnItemMouseOver;
     tag.onmouseout=OnItemMouseOut;
     tag.onmousedown=OnItemMouseDown;
     tag.onmouseup=OnItemMouseUp;
     tag.disabled=false;
    }
}

function DisableButton(id)
{
   var tag = eval(id);
    if( tag.button_name != null)
    {
     tag.onmouseover="";
     tag.onmouseout="";
     tag.onmousedown="";
     tag.onmouseup="";
     tag.className = "greyedOut";
     tag.disabled=true;
    }
}
