function Shank()
{
   this.Name = gShankDefaultName;
   this.Diameter = 20;
   this.Width = 5;
   this.Border = 5;
   this.ModelHeight = this.Width + this.Border*2;
   this.Thickness = 2;
   this.Resolution = 30;

   this.SizeStandardIndex = 0;
   this.SizeOptionIndex  = 0;

   this.Description = "";

   this.ShankIconPath = artcam.HtmlRootDir + "../SharedImages/JewelSmith/ShankIcon.gif";
   this.FilenameIconPath = artcam.HtmlRootDir + "../SharedImages/JewelSmith/Filename.gif";

   this.WriteParamsHTML = shank_WriteParamsHTML;
   this.UpdateHTML = shank_UpdateHTML;
   this.OnStandardSelect = shank_OnStandardSelect;
   this.OnSizeSelect = shank_OnSizeSelect;
   this.OnFinish = shank_OnFinish;
   this.OnBackButton = shank_OnBackButton;
   this.CallbackFunction = null;

   this.StoreSettings = shank_StoreSettings;
   this.RetrieveSettings = shank_RetrieveSettings;
   this.UseForwardButton = true;
   this.UseBackButton = true;
   this.UseAcceptButton = true;
   
   this.SetCustomDiameter = shank_SetCustomDiameter;
   this.SetCustomDiameterFromAssembly = shank_SetCustomDiameterFromAssembly;

   this.DefaultName = gShankDefaultName;

   this.WidthParamVisible = true;
   this.BorderParamVisible = true;
   this.ThicknessParamVisible = true;
   this.ResolutionParamVisible = true;
}

function shank_WriteParamsHTML(TargetDiv)
{
   var hArr = new Array();

   hArr.push("<table width='100%' border=0 cellspacing=0 style='table-layout:auto'>");
   hArr.push("<colgroup><col width=40px><col width=60%><col width=40%></colgroup>");
   hArr.push("<tr><td><img src='" + artcam.HtmlRootDir + "../SharedImages/JewelSmith/Filename.gif'></td><td>" + gShankName + ":</td>");
   hArr.push("<td><input style='margin-left:1px' type=edit id=NameEdit value='" + this.DefaultName +  "'></td></tr>");

   hArr.push("<tr><td rowspan=7 valign=top ><img valign=top src='"+ this.ShankIconPath + "'></td>");
   hArr.push("<td style='display:none' id=size_standard_row>" + gShankStandard + ":</td><td><div id=size_standard_select onselect='globalStore.ActiveShank.OnStandardSelect()' style='width:120px;display:none'></div></td></tr>");
   hArr.push("<tr><td style='display:none' id=size_options_row>" + gShankSize + ":</td><td><div id=size_options_select onselect='globalStore.ActiveShank.OnSizeSelect()' style='width:120px;display:none'></div></td></tr>");
   
   hArr.push("<tr><td>" + gShankDiameter + ":</td><td><input type=edit size=5 maxLength=6 number dp='3' value=20 id=DiameterEdit>mm</td></tr>");
   hArr.push("<tr id=WidthRow><td>" + gShankWidth + ":</td><td><input type=edit size=5 maxLength=6 number dp='3' value=20 id=WidthEdit>mm</td></tr>");
   hArr.push("<tr id=BorderRow><td>" + gShankBorder + ":</td><td><input type=edit size=5 maxLength=6 number dp='3' value=20 id=BorderEdit>mm</td></tr>");
   hArr.push("<tr id=ThicknessRow><td>" + gShankThickness + ":</td><td><input type=edit size=5 maxLength=6 number dp='3' value=2 id=ThicknessEdit>mm</td></tr>");
   hArr.push("<tr id=ResolutionRow><td>" + gShankResolution + ":</td><td><input type=edit size=5 maxLength=6 positive integer number value=30 id=ResolutionEdit>pix/mm</td></tr>");
   
   hArr.push("</table>");

   if(this.UseAcceptButton)
   {
      
      hArr.push("<div class='mouseOut' button_name='accept_button' targetFunction='globalStore.ActiveShank.OnFinish' style='width=30px;float:right;'>");
      
      if(this.UseForwardButton)
         hArr.push("<img alt =" + gForwardButtonAlt + " id=next_img src ='" + artcam.HtmlRootDir + "../SharedImages/forward.gif' align=absmiddle border=0 width=30 height=30>");
      else
         hArr.push("<img alt =" + gAcceptButtonAlt + " id=next_img src ='" + artcam.HtmlRootDir + "../SharedImages/accept.gif' align=absmiddle border=0 width=30 height=30>");
      
      hArr.push("</div>");
   }

   if(this.UseBackButton)
   {
      hArr.push("<div class='mouseOut' button_name='back_button' targetFunction='globalStore.ActiveShank.OnBackButton' style='width=30px;float:right;'>");
      hArr.push("<img alt =" + gBackButtonAlt + " id=back_img src ='" + artcam.HtmlRootDir + "../SharedImages/back.gif' align=absmiddle border=0 width=30 height=30>");
      hArr.push("</div>");
   }

   TargetDiv.innerHTML += hArr.join("\n");
   InitialiseButtonDivs();
   SubclassNumberEditControls();

   TargetDiv.style.display = "";

   PromoteDivToSelect(size_standard_select);
   PromoteDivToSelect(size_options_select);

   this.WidthParamVisible ? WidthRow.style.display="" : WidthRow.style.display="none";
   this.BorderParamVisible ? BorderRow.style.display="" : BorderRow.style.display="none";
   this.ThicknessParamVisible ? ThicknessRow.style.display="" : ThicknessRow.style.display="none";
   this.ResolutionParamVisible ? ResolutionRow.style.display="" : ResolutionRow.style.display="none";

   // Keep a global reference to the edit controls
   this.NameEdit = eval(NameEdit);
   this.WidthEdit = eval(WidthEdit);
   this.BorderEdit = eval(BorderEdit);
   this.DiameterEdit = eval(DiameterEdit);
   this.ThicknessEdit = eval(ThicknessEdit);
   this.ResolutionEdit = eval(ResolutionEdit);

   this.SizeStandardSelect = eval(size_standard_select);
   this.SizeOptionSelect = eval(size_options_select);

   var DirSelector = artcam.CreateFileSelector();

   // Set file in Custom directory by default...
   var dir_path = artcam.HtmlRootDir + "../SizeStandards";

   // ...but overule with translation file, if it exists
   if(DirSelector.DirectoryExists(artcam.HtmlLangDir + "JewelSmith/SizeStandards"))
   {
      dir_path = artcam.HtmlLangDir + "JewelSmith/SizeStandards";
   }

   if (DirSelector.DirectoryExists(dir_path))
   {
      size_standard_select.style.display="";
      size_options_select.style.display="";
      size_standard_row.style.display="";
      size_options_row.style.display="";
      FillSelectFromTextFileNames(this.SizeStandardSelect, dir_path, gCustom);

      this.SizeStandardSelect.SetSelectedIndex(this.SizeStandardSelect.GetRowCount()-1);
      this.SizeOptionSelect.SetDisabled(true);
   }
   this.RetrieveSettings();
   this.UpdateHTML();
}

function shank_OnStandardSelect()
{
   if(this.SizeStandardSelect.GetSelectedTitle()==gCustom)
   {
      this.SizeOptionSelect.SetDisabled(true);
    
      this.DiameterEdit.style.backgroundColor = 'window';
      this.DiameterEdit.disabled = false;
      return;
   }

   this.DiameterEdit.style.backgroundColor = 'buttonface';
   this.DiameterEdit.disabled = true;
   this.SizeOptionSelect.SetDisabled(false);

   FillSelectFromTextPairFile(this.SizeOptionSelect, this.SizeStandardSelect.GetSelectedData());
   this.SizeOptionSelect.SetSelectedIndex(0);
   this.OnSizeSelect();
}

function shank_OnSizeSelect()
{
   if(this.SizeStandardSelect.GetSelectedTitle()==gCustom)
   {
      this.DiameterEdit.setValue(0);
      return;
   }

   this.DiameterEdit.setValue(this.SizeOptionSelect.GetSelectedData())
}

function shank_OnBackButton()
{
   if(typeof(this.CallbackFunction)=='function')
      this.CallbackFunction(false);
}

function shank_OnFinish()
{
   this.Name = this.NameEdit.value;
   this.Width = this.WidthEdit.getValue();
   this.Border = this.BorderEdit.getValue();
   this.ModelHeight = this.Width + this.Border*2;

   this.Diameter = this.DiameterEdit.getValue();
   this.Thickness = this.ThicknessEdit.getValue();
   this.Resolution = this.ResolutionEdit.getValue();

   if(this.SizeStandardSelect.GetSelectedTitle()==gCustom)
   {
      this.Description = gCustom;
   }
   else
   {
      this.Description = this.SizeStandardSelect.GetSelectedTitle() + " " + gSize + " " + this.SizeOptionSelect.GetSelectedTitle();
   }

   this.StoreSettings();

   if(typeof(this.CallbackFunction)=='function')
      this.CallbackFunction(true);
}

function shank_StoreSettings()
{
   if(artcam.ProjectAssemblyExists)
   {
      artcam.ProjectAssembly.SetString("last_ringinfo_diameter",this.Diameter);
      artcam.ProjectAssembly.SetString("last_ringinfo_width",this.Width);
      artcam.ProjectAssembly.SetString("last_ringinfo_border",this.Border);
      artcam.ProjectAssembly.SetString("last_ringinfo_thickness",this.Thickness);
      artcam.ProjectAssembly.SetInteger("last_ringinfo_resolution",this.Resolution);
      
      artcam.StoreDouble("ShankSettings","last_ringinfo_diameter", this.Diameter);
      artcam.StoreDouble("ShankSettings","last_ringinfo_width",this.Width);
      artcam.StoreDouble("ShankSettings","last_ringinfo_border",this.Border);
      artcam.StoreDouble("ShankSettings","last_ringinfo_thickness",this.Thickness);
      artcam.StoreInt("ShankSettings","last_ringinfo_resolution",this.Resolution);

      artcam.StoreInt("ShankSettings","last_ringinfo_size_standard_index",this.SizeStandardSelect.GetSelectedIndex());
      artcam.ProjectAssembly.SetInteger("last_ringinfo_size_standard_index",this.SizeStandardSelect.GetSelectedIndex());

      if(this.SizeStandardSelect.GetSelectedTitle()!=gCustom)
      {
         artcam.ProjectAssembly.SetInteger("last_ringinfo_size_options_index",this.SizeOptionSelect.GetSelectedIndex());
         artcam.StoreInt("ShankSettings","last_ringinfo_size_options_index",this.SizeOptionSelect.GetSelectedIndex());
      }
      else
      {
         artcam.ProjectAssembly.SetInteger("last_ringinfo_size_options_index",0);
         artcam.StoreInt("ShankSettings","last_ringinfo_size_options_index",0);
      }
   }
}

function shank_RetrieveSettings()
{
   if(artcam.ProjectAssemblyExists && artcam.ProjectAssembly.StringExists("last_ringinfo_diameter"))
   {   
      this.Diameter = artcam.ProjectAssembly.GetString("last_ringinfo_diameter",20);
      this.Width = artcam.ProjectAssembly.GetString("last_ringinfo_width",5);
      this.Border = artcam.ProjectAssembly.GetString("last_ringinfo_border",5);
      this.Thickness = artcam.ProjectAssembly.GetString("last_ringinfo_thickness",2);
      this.Resolution = artcam.ProjectAssembly.GetInteger("last_ringinfo_resolution",30);
      this.SizeStandardIndex = artcam.ProjectAssembly.GetInteger("last_ringinfo_size_standard_index",0);
      this.SizeOptionIndex  = artcam.ProjectAssembly.GetInteger("last_ringinfo_size_options_index",0);
   }
   else
   {
      this.Diameter = artcam.RetrieveDouble("ShankSettings","last_ringinfo_diameter",20);
      this.Width = artcam.RetrieveDouble("ShankSettings","last_ringinfo_width",5);
      this.Border = artcam.RetrieveDouble("ShankSettings","last_ringinfo_border",5);
      this.Thickness = artcam.RetrieveDouble("ShankSettings","last_ringinfo_thickness",2);
      this.Resolution = artcam.RetrieveInt("ShankSettings","last_ringinfo_resolution",30);
      this.SizeStandardIndex = artcam.RetrieveInt("ShankSettings","last_ringinfo_size_standard_index",0);
      this.SizeOptionIndex  = artcam.RetrieveInt("ShankSettings","last_ringinfo_size_options_index",0);
   }

   return true;
}

function shank_UpdateHTML()
{
   this.WidthEdit.setValue(this.Width);
   this.BorderEdit.setValue(this.Border);
   this.ThicknessEdit.setValue(this.Thickness);
   this.ResolutionEdit.setValue(this.Resolution);
   this.SizeStandardSelect.SetSelectedIndex(this.SizeStandardIndex);
   this.OnStandardSelect();
   this.SizeOptionSelect.SetSelectedIndex(this.SizeOptionIndex);
   this.DiameterEdit.setValue(this.Diameter);
   return true;
}

function shank_SetCustomDiameter(diameter)
{
   this.Diameter = diameter;
   this.DiameterEdit.setValue(this.Diameter);
   this.SizeStandardSelect.SetSelectedIndex(this.SizeStandardSelect.GetRowCount()-1);
   this.OnStandardSelect();
}

function shank_SetCustomDiameterFromAssembly()
{
   // We work out the current diameter from project assembly if we can
   // and set it as a custom value
   var diameter = artcam.ProjectAssembly.FindHoleRadius(0,0,0,0,true)*2;
   if(diameter > 0.01)
   {
      this.SetCustomDiameter(diameter);
      return true;
   }

   return false;
}

