//=============================================================================
//
// CorrectVector.js - Transforms selected vectors to compensate for radial axis warping
//
//

//-----------------------------------------------------------------------------
// COPYRIGHT 2004 DELCAM PLC., BIRMINGHAM, ENGLAND. 
//-----------------------------------------------------------------------------
//
// History.
// Who When     What   
// --- -------- ---------------------------------------------------------------
// sgc 18/09/06 Added header
//-----------------------------------------------------------------------------

function plugin_main()
{
   HideAllLibraryDivs();
   Write_params(paramsDiv);
   paramsDiv.style.display = "";

   globalStore.CorrectForHeight = CorrectForHeight;
}

function Write_params(targetDiv)
{
   targetDiv.innerHTML = "";
   var hArr = new Array();
   // Add the back button HTML to the array

   hArr.push("<table width='100%' border=0 cellspacing=0 style='margin-left:3px'>");
   hArr.push("<col width=40px><col width=70%><col width=30%>");
 
   hArr.push("<tr align=right><td></td><td>" + gHeight + ":</td><td align=left><input type=edit number size=3 value=0.0 id=HeightEdit></td></tr>"); 
   hArr.push("<tr align=right><td></td><td>" + gFromRelief + ":</td><td align=left><input type=checkbox id=FromReliefCheck></td></tr>"); 
   hArr.push("<tr align=right><td></td><td>" + gPreserve + ":</td><td align=left><input type=checkbox id=PreserveCheck></td></tr>"); 
   hArr.push("</table>");
    
   hArr.push("<div class='mouseOut' button_name='forward_button' targetFunction='globalStore.CorrectForHeight' style='width=30px;float:right;'>");
   hArr.push("<img id=back_img src ='" + artcam.HtmlRootDir + "../SharedImages/Accept.gif' align=absmiddle border=0 width=30 height=30>");
   hArr.push("</div>");
  
      // Add the back button HTML to the array
   AddBackButtonHTML(hArr);

   targetDiv.innerHTML += hArr.join("\n");

   // Bung all our HTML into the div and display it
   InitialiseButtonDivs();
   SubclassNumberEditControls();

   globalStore.HeightEdit = eval(HeightEdit);
   globalStore.FromReliefCheck = eval(FromReliefCheck);
   globalStore.PreserveCheck = eval(PreserveCheck);
}


//=== CorrectForHeight ==============================================
//
// Transforms selected vectors to compensate for radial axis warping
//
 
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sgc 18/09/06 Allow this to work with more than one selected vector
//-----------------------------------------------------------------------

function CorrectForHeight()
{
   var ring_designer = artcam.CreateRingDesigner();
   if(ring_designer == null)
   {
      artcam.MessageBox(gUnlicensed);
      return;
   }
   
   if(artcam.VectorSelection.Count < 1)
   {
      artcam.MessageBox(gNoVectorsSelected);
      return;
   }
   
   SetRingDesignerInfoFromModel(ring_designer);
   
   if(globalStore.PreserveCheck.checked)  
   {
      artcam.EditCopy();
      artcam.EditPaste();
   }

   var vector_selection = artcam.VectorSelection.Selection;
   var vector_array = vector_selection.split(",");

   var height = 0;
   var index=0;

   // Get the layer index for the corrected vectors
   var layer_index = GetCorrectedVectorLayer();

   // Now loop through the vectors
   if(globalStore.FromReliefCheck.checked)
   {
      for(index=0;index<vector_array.length;index++)
      {
         artcam.VectorSelection.Selection = vector_array[index];
         var centre_x = (artcam.SelectionMaxX() + artcam.SelectionMinX()) / 2.0;
         var centre_y = (artcam.SelectionMaxY() + artcam.SelectionMinY()) / 2.0;
         height = artcam.Relief.GetZHeight(centre_x,centre_y);
         ring_designer.CorrectVectorSelectionForHeight(height);

         // Put this vector on the corrected vector layer
         artcam.VectorSelection.Item(0).Layer = layer_index;
      }
   }
   else
   {
      height = globalStore.HeightEdit.getValue();
      for(index=0;index<vector_array.length;index++)
      {
         ring_designer.CorrectVectorSelectionForHeight(height);

         // Put this vector on the corrected vector layer
         artcam.VectorSelection.Item(0).Layer = layer_index;
      }
   }

   // Now press the back button which will return us to the previous page and restore states
   OnBackButton();
}

