//=============================================================================
//
// combinemode.js   | For making a div behave as a tool selector.
//
//

//-----------------------------------------------------------------------------
// COPYRIGHT 2003 DELCAM PLC., BIRMINGHAM, ENGLAND. 
//-----------------------------------------------------------------------------
//
// History.
// Who When     What   
// --- -------- ---------------------------------------------------------------
// sic 07/03/06 Written (based in toolselect.js)
//-----------------------------------------------------------------------------


// TODO: Implement keyboard control.
//       Handle the "no selected tool" scenario.


//=== PromoteDivToToolSelect ============================================
//
// This function transforms a span/div into a tool select control.
//
// The "sharedImagePath" argument is a path to the shared images.
// It defaults to (artcam.HtmlRootDir + "../SharedImages/") but you might
// not be in the right place so you can override this if you pass a path
// string in.
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sic 07/03/06 Written
//-----------------------------------------------------------------------

function PromoteToCombineModeSelect(select, imageFolder, mode)
{
   tsInitCombineModeSelectMembers(select);

   select.AddItem(imageFolder + "cm0.gif", 0, gAddText);
   select.AddItem(imageFolder + "cm1.gif", 1, gSubtractText);
   select.AddItem(imageFolder + "cm2.gif", 2, gMergeHighText);
   select.AddItem(imageFolder + "cm3.gif", 3, gMergeLowText);
   select.AddItem(imageFolder + "cm4.gif", 4, gMultiplyText);

   select._ConfigureElement();
   
   select.SetSelectedIndex(mode);
}


//=== tsInitCombineModeSelectMembers ====================================
//
// Add/configured all the required members.
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sic 07/03/06 Written
//-----------------------------------------------------------------------

function tsInitCombineModeSelectMembers(select)
{
   /////////////////////////////////////////////////////////////////////////
   //
   // Private data members.
   //
   /////////////////////////////////////////////////////////////////////////


   select._popup = null;
   select._mapTitleToIndex = new Object();
   select._mapDataToIndex = new Object();

   select._rows = new Array();

   select._selectedIndex = -1; // Nothing selected to begin with
   select._mouseOver = false;
   select._mouseOverButton = false;
   
   select._sharedImagePath = artcam.HtmlRootDir + "../SharedImages/";


   /////////////////////////////////////////////////////////////////////////
   //
   // Public methods.
   //
   /////////////////////////////////////////////////////////////////////////


   //=== GetItemData =======================================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select.GetItemData = function(idx)
   {
      if (idx < 0 || idx >= this._rows.length)
         return;

      return this._rows[idx].data;
   }


   //=== AddItem ===========================================================
   //
   // For adding in a row to the menus html and an data marker
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select.AddItem = function(src, data, title, state_data)
   {
      // Put the information into a new object
      var obj  = new Object();
      obj.title = title;
      obj.src = src;
      obj.data = data;

      // Store the new object in the maps and *then* in the rows array.
      this._mapTitleToIndex[obj.title] = this._rows.length;
      this._mapDataToIndex[obj.data] = this._rows.length;
      this._rows.push(obj);

      this._DestroyPopup();

      // If there is now a choice of tools,
      // reconfigure to include the flyout arrow.
      if (2 == this._rows.length)
      {
         this._ConfigureElement();
      }
   }


   //=== IsOpen ============================================================
   //
   // This function overrides the default isOpen on _popup to get around
   // a problem we have when we click the drop box while the popup is open.
   // The popup loses focus, dissappears and then we get a mousedown to
   // the drop box which would see that the popup was closed and open it again!
   // So this function relies on the monitoring interval to tell us when it
   // has closed. We only think we have closed once the monitoring interval
   // has seen it. This interval is also used for auto scrolling.
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select.IsOpen = function()
   {
      if( this._popup == null )
         return false;
      if( this._popupOpenInterval != null ) // If our popup open interval is running still, we assume we are open
         return true;
      return this._popup.isOpen;
   }


   //=== PreLoad ===========================================================
   //
   // This will cause the popup to preload by actually creating it and trying to open it briefly.
   // This is used as a speedup for fuller lists and is performed in the background on a timeout
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select.PreLoad = function()
   {
      if( this._PreloadTimeout == null )
      {
         // Call the preload after an instant timeout
         this._PreloadTimeout = setTimeout(this.id + ".PreLoad()", 0);
      }
      else
      {
         this._PreloadTimeout = null;
         this._CreatePopup();
         this._popup.show(0, 0, 0, 0);
         this._popup.hide();

         // Now put the focus on the document body
         document.body.focus();
      }
   }


   //=== GetSelectedIndex ==================================================
   //
   // 
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select.GetSelectedIndex = function()
   {
      return this._selectedIndex;
   }


   //=== SetSelectedIndex ==================================================
   //
   // 
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select.SetSelectedIndex = function(idx)
   {
      this._selectedIndex = idx;
      this._displayButton.innerHTML = this._GetItemHtml(idx);
   }


   //=== GetItem ============================================================
   //
   // 
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select.GetItem = function(idx)
   {
      // if we are out of range, return null
      if( idx < 0 || idx >= this._rows.length )
         return null;

      // Now return the row object
      return this._rows[idx];
   }


   //=== GetItemCount =======================================================
   //
   // 
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select.GetItemCount = function()
   {
      return this._rows.length;
   }


   //=== FindIndexWithData =================================================
   //
   // Returns the index of the item in the list with the passed data else
   // returns -1.
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select.FindIndexWithData = function(data)
   {
      var idx = this._mapDataToIndex[data];

      if (null == idx) idx = -1;
      return idx;
   }


   //=== FindIndexWithTitle ================================================
   //
   // Returns the index of the item in the list with the passed title else
   // returns -1.
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select.FindIndexWithTitle = function(title)
   {
      var idx = this._mapTitleToIndex[title];

      if (null == idx) idx = -1;
      return idx;
   }


   //=== Refresh ===========================================================
   //
   // for refreshing the control when it is shown
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select.Refresh = function()
   {
      this._DestroyPopup();

      // This will cause a resize of everything and refresh the control
      this.SetSelectedIndex(this.GetSelectedIndex());
      this._SetButtonAppearance();
   }


   //=== select_GetSelected...==============================================
   //
   // Series of direct return functions for the currently selected object
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select.GetSelectedItem = function()
   {
      return this._rows[this._selectedIndex];
   }

   select.GetSelectedData = function()
   {
      return this._rows[this._selectedIndex].data
   }

   select.GetSelectedHtml = function()
   {
      return this._GetItemHtml(this._selectedIndex);
   }

   select.GetSelectedTitle = function()
   {
      return this._rows[this._selectedIndex].title;
   }


   /////////////////////////////////////////////////////////////////////////
   //
   // Private methods.
   //
   /////////////////////////////////////////////////////////////////////////


   //=== _ConfigureElement =================================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._ConfigureElement = function()
   {
      var html = new Array();
      var width = 22;

      html.push("<table id='" + this.id + "Table' tabindex='0' cellspacing='0' cellpadding='0' border='0' height='100%' width='100%'>");
      html.push(  "<tr align='center' valign='center' ");
      html.push(    "onmouseenter='" + this.id + "._OnMouseEnterTable()' ");
      html.push(    "onmouseleave='" + this.id + "._OnMouseLeaveTable()' ");
      html.push(  ">");
      html.push(    "<td width='100%' id='" + this.id + "Button' ");
      html.push(      "style='border:none; padding:1px; overflow:hidden;' ");
      html.push(      "onmouseenter='" + this.id + "._OnMouseEnterButton()' ");
      html.push(      "onmouseleave='" + this.id + "._OnMouseLeaveButton()' ");
      html.push(      "onmousedown='" + this.id + "._OnMouseDown()' ");
      html.push(      "onmouseup='" + this.id + "._OnMouseUp()' ");
      html.push(      "onmousemove='" + this.id + "._OnMouseMove()'>");
      html.push(    "</td>");

      if (this._rows.length > 1)
      {
         width += 17;

         html.push( "<td id='" + this.id + "Arrow' style='border:none; padding:1px;' ");
         html.push(   "onmousedown='" + this.id + "._ShowPopup()'>");
         html.push(   "<img src='" + this._sharedImagePath + "rightarrow.gif'>");
         html.push( "</td>");
      }

      html.push(  "</tr>");
      html.push("</table>");

      this.style.width = width + "px";
      this.style.height = "26px";

      this.innerHTML = html.join("");

      this._displayTable = eval(this.id + "Table");
      this._displayButton = eval(this.id + "Button");
      this._displayArrow = eval("typeof(" + this.id + "Arrow) != 'undefined' ? " + this.id + "Arrow : null");

      this.SetSelectedIndex(this.GetSelectedIndex());
   }


   //=== _SetArrowBorder ===================================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._SetArrowBorder = function(borderFn)
   {
      if (this._displayArrow) borderFn(this._displayArrow);
   }


   //=== _GetItemCell ======================================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._GetItemCell = function(idx)
   {
      return this._popup.document.getElementById(this.id + "Cell" + idx);
   }


   //=== _OnPopupOpen ======================================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._OnPopupOpen = function()
   {
      this._mouseButtonDown = false;
      this._SetArrowBorder(this._Inset);
   }


   //=== _OnPopupClose =====================================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._OnPopupClose = function()
   {
      this._SetButtonAppearance();

      if (true == this._mouseOver)
      {
         this._SetArrowBorder(this._Outset);
      }
      else
      {
         this._SetArrowBorder(this._Flatten);
      }
   }


   //=== _OnPopupItemMouseEnter ============================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._OnPopupItemMouseEnter = function(idx)
   {
      if (idx < 0 || idx >= this._rows.length)
         return;

      this._Outset(this._GetItemCell(idx));
   }


   //=== _OnPopupItemMouseLeave=============================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._OnPopupItemMouseLeave = function(idx)
   {
      if (idx < 0 || idx >= this._rows.length)
         return;

      this._Flatten(this._GetItemCell(idx));
   }


   //=== _OnPopupItemSelect ================================================
   //
   // Called when a row from the popup has been selected
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._OnPopupItemSelect = function(idx)
   {
      var item = this._rows[idx];

      this._Flatten(this._GetItemCell(idx));
      this._popup.hide();
      this.SetSelectedIndex(idx);

      // Inform the callback if one has been specified
      this._FireOnSelect();
   }


   //=== _SetButtonAppearance ==============================================
   //
   // Set the appropriate button appearance given our current state.
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._SetButtonAppearance = function()
   {
      var item = this._rows[this._selectedIndex];

      if (true == this._mouseOver)
      {
         if (true == this._mouseOverButton && true == this._mouseButtonDown)
         {
            this._Inset(this._displayButton);
         }
         else
         {
            this._Outset(this._displayButton);
         }
      }
      else
      {
         this._Flatten(this._displayButton);
      }
   }


   //=== _CreatePopup ======================================================
   //
   // 
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._CreatePopup = function()
   {
      this._popup = window.createPopup();
      this._popup.document.ondragstart   = function() {return false}; // Make sure we can't drag
      this._popup.document.onselectstart = function() {return false}; // or select anything

      // Store the popup window in our object and set a _select object
      // on it for the popup's events to refer to.
      this._popupWindow = this._popup.document.parentWindow;
      this._popupWindow._select = this;

      // Build up the Popup body
      var html = new Array();

      html.push(
         "<div id='popupdiv' style='padding-bottom:1px; padding-right:1px; " + 
           "border-top:buttonhighlight solid 1px; border-left:buttonhighlight solid 1px; " +
           "border-bottom:buttonshadow solid 1px; border-right:buttonshadow solid 1px; " +
           "overflow:visible;'>");

      html.push(
         "<span id='popupspan' style='position:relative; top:2px; left:1px; " + 
           "cursor:default; overflow:auto;'>");

      for(var idx=0; idx < this._rows.length; idx++)
      {
         html.push(
            "<span style='border:none; padding:1px;' id='" + this.id + "Cell" + idx + "' " +
              "onmouseenter='_select._OnPopupItemMouseEnter(" + idx + ")' " +
              "onmouseleave='_select._OnPopupItemMouseLeave(" + idx + ")' " +
              "onmouseup='_select._OnPopupItemSelect(" + idx + ")' " + 
            ">" + this._GetItemHtml(idx) + "</span>");
      }

      html.push("</span>");
      html.push("<div>");

      // Now set this as the document body
      this._popup.document.body.innerHTML = html.join("");

      // Now figure out it's dimensions for when we show it
      // We have to show and hide it once with a zero height to get it to render so we can retrieve the rendered dimensions   

      this._popup.show(this.offsetWidth + 1, 0, screen.width / 2, 0, this);   // Create popup with zero height
      this._popupHeight = this._popupWindow.popupdiv.offsetHeight - 1;      // Grab the html width from the popup table
      this._popupWidth  = this._popupWindow.popupspan.offsetWidth + 4;       // Grab the html height from the popup table
      this._popup.hide();

      // Now that the popup is ready, install the event handlers we want
      // called when the popup is used.

      this._popupWindow.document.body.onload = function()
      {
         this._select._OnPopupOpen();
      };

      this._popupWindow.document.body.onunload = function()
      {
         this._select._OnPopupClose();
      };
   }


   //=== _ShowPopup ========================================================
   //
   // 
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._ShowPopup = function()
   {
      // If we are diabled, go no further
      if( this.disabled )
         return;

      // If the popup has never been created, create it.
      if( this._popup == null )
         this._CreatePopup();

      // If the popup is open, hide it. Otherwise we show it.
      if( this.IsOpen() )
         this._popup.hide();
      else
      {
         this._SetArrowBorder(this._Inset);
         // Show the popup. The width and height are worked out in the CreatePopup function
         var w = this._popupHeight > this.offsetHeight ? this._popupHeight : this.offsetHeight; // Allow it to get bigger if the main drop box has resized
         this._popup.show(this.offsetWidth + 1, 0, this._popupWidth, w, this);

         // Start the monitoring interval so we can have a close event.
         // There seems to be no other way around this as I can't catch a close event
         // on the window. IsOpen checks whether this interval is still running
         this._popupOpenInterval = setInterval(this.id + "._OpenIntervalCheck()", 100);
      }
   }


   //=== _Flatten ==========================================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._Flatten = function(obj)
   {
      obj.style.border = "none";
      obj.style.padding = "1px";
   }


   //=== _Inset ============================================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._Inset = function(obj)
   {
      obj.style.padding = "0px"
      obj.style.borderBottom = obj.style.borderRight = "buttonhighlight solid 1px";
      obj.style.borderTop =    obj.style.borderLeft  = "buttonshadow solid 1px";
   }


   //=== _Outset ===========================================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._Outset = function(obj)
   {
      obj.style.padding = "0px"
      obj.style.borderBottom = obj.style.borderRight = "buttonshadow solid 1px";
      obj.style.borderTop =    obj.style.borderLeft  = "buttonhighlight solid 1px";
   }


   //=== _OpenIntervalCheck ================================================
   //
   // 
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._OpenIntervalCheck = function()
   {
      if(!this._popup || !this._popup.isOpen)
      {
         clearInterval(this._popupOpenInterval);
         this._popupOpenInterval = null;
      }
   }


   //=== _OnMouseMove ======================================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._OnMouseMove = function()
   {
      if (0 == (event.button & 1)) this._mouseButtonDown = false;
   }

   //=== _OnMouseEnterTable ================================================
   //
   // 
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._OnMouseEnterTable = function()
   {
      this._mouseOver = true;

      if (!this.IsOpen())
      {
         this._SetButtonAppearance();
         this._SetArrowBorder(this._Outset);
      }
   }


   //=== _OnMouseEnterButton ===============================================
   //
   // 
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._OnMouseEnterButton = function()
   {
      this._mouseOverButton = true;

      if (!this.IsOpen())
      {
         this._SetButtonAppearance();
      }
   }


   //=== _OnMouseLeaveTable ================================================
   //
   // 
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._OnMouseLeaveTable = function()
   {
      this._mouseOver = false;

      if (!this.IsOpen())
      {
         this._SetButtonAppearance();
         this._SetArrowBorder(this._Flatten);
      }
   }


   //=== _OnMouseLeaveButton ===============================================
   //
   // 
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._OnMouseLeaveButton = function()
   {
      this._mouseOverButton = false;
      this._SetButtonAppearance();
   }


   //=== _OnMouseDown ======================================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._OnMouseDown = function()
   {
      // Which button was pressed?
      if (event.button == 1)
      {
         // Left mouse button
         this._mouseButtonDown = true;
         this._SetButtonAppearance();
      }
      else if (event.button == 2 && this._rows.length > 1)
      {
         // Right mouse button AND we have more than one item - fire off the popup.
         this._ShowPopup();
      }
   }


   //=== _OnMouseUp ========================================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._OnMouseUp = function()
   {
      if (this._mouseButtonDown)
      {
         this._mouseButtonDown = false;
         this._SetButtonAppearance();
         this.SetSelectedIndex((this.GetSelectedIndex() + 1) % this._rows.length);
         this._FireOnSelect();
      }
   }


   //=== _GetItemHtml ======================================================
   //
   // 
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._GetItemHtml = function(idx)
   {
      if (idx >= 0 && idx < this._rows.length && null != this._rows[idx])
      {
         var item = this._rows[idx];
         var src = " src='" + item.src + "' ";
         var alt = " alt='" + item.title + "' ";

         return "<img width='20px' height='20px'" + src + alt + ">";
      }
      else
      {
         return "";
      }
   }


   //=== _FireOnSelect =====================================================
   //
   // 
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._FireOnSelect = function()
   {
      if(this.onselect == null)
         return; // Nothing to fire

      if( this._FireOnSelectTimeout == null )
      {
         // Fire the onselect event after an instant timeout
         // This allows the page to update and other events to pass through first
         // It also means that we don't fire one on top of another.
         // If the timeout already exists, we don't make another call.
         this._FireOnSelectTimeout = setTimeout(this.id + "._FireOnSelectEval()", 0);
      }
   }


   //=== _FireOnSelectEval =================================================
   //
   //
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._FireOnSelectEval = function()
   {
      if(this.onselect == null)
         return; // Nothing to fire
      this._FireOnSelectTimeout = null; // Cancel this timeout, it will allow another to fire
      eval(this.onselect);
   }


   //=== _DestroyPopup =====================================================
   //
   // Destroys the popup window.
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // sic 07/03/06 Written
   //-----------------------------------------------------------------------

   select._DestroyPopup = function()
   {
      if (null != this._popup)
      {
         if (this._popup.isOpen) this._popup.hide();
         this._popup = null;
      }
   }

} // END.