
//=== FillSelectFromTextPairFile ==============================================
//
// Fills a PromoteDivToSelect object with first of element of " = " paired 
// values in a text file. The associated value (i.e. the second value)
// is placed into the value array at the equivalent index.
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// ejp 18/12/03 Written
//-----------------------------------------------------------------------

function FillSelectFromTextPairFile
   (
   select_object,          // Object that will hold the labels from the file
   filepath,               // path to text file holding paired list
   create_custom_option    // string for the last entry in the list with 
                           // an associated value of "" - e.g. 'Custom' or 'Default';
   ) 
{
   select_object.Empty();
   var file_browser = artcam.CreateFileSelector();
   var file_text = file_browser.ReadTextFile(filepath);
   if( file_text == "" )
      return false;

   // Loop through the lines of the text file and find the first line that contains a paf description using a regexp
   var lines = file_text.split("\n");
   var line;
   for(line in lines)
   {

      // . Match Any character
      // + 1 or more times
      // ? Match as little as possible
      // () Grab out to $1
      // \s Match any space character
      // * 0 or more times
      // = Match '=' character

      if( /^\s*(.+?)\s*=\s*(.+?)\s*$/.test( lines[line] ) )
      {
         select_object.AddRow(RegExp.$1,RegExp.$2,RegExp.$1);
      }
   }
   if(typeof(create_custom_option)!='undefined')
   {
      select_object.AddRow(create_custom_option,"",create_custom_option);
   }
   // If we get here we didn't find a matching line
   return false;
}


function FillSelectFromTextFileNames
   (
   select_object,         // Object that will hold the names of the files
   dir_path,              // path to directory containing text files
   create_custom_option   // string for the last entry in the list with 
                          // an associated value of "" - e.g. 'Custom' or 'Default';
   ) 
{
      // We need our filesystem object to check directories
   var fs = artcam.CreateFileSelector();
   if(fs == null)
   {
      artcam.Alert("FillSelectFromTextFileNames::Unable to create FileSelector",0);
      return;
   }
   if(!fs.DirectoryExists(dir_path))
   {
      artcam.Alert("FillSelectFromTextFileNames::The Folder '" + dir_path + "' does not exist",0);
      return;
   }

   var splitpath = artcam.CreateSplitPath(dir_path);
   if( splitpath == null )
      return; // If we can't create it we ignore this directory

   // Now loop through all the files in this directory
   var dirList = artcam.CreateDirectoryList(dir_path);
   dirList.StartList("*"); // Enumerate ALL items. '*' wild card matches everything

   while( dirList.ItemIsValid() )
   {
      // Ignore directories we just examine the files
      if( !dirList.ItemIsDirectory() )
      {
         splitpath.Path = dirList.ItemPath;
         var extension = splitpath.Extension;
         switch(extension.toLowerCase())
         {
         case "txt":
            select_object.AddRow(splitpath.File, splitpath.Path, splitpath.File);
            break;
         default:
            break;
         }
      }
      // Move onto the next file
      dirList.NextItem();
   }

   if(typeof(create_custom_option)!='undefined')
   {
      select_object.AddRow(create_custom_option,"",create_custom_option);
   }
}