<?php
// local template functions
require_once(SITE_TEMPLATES_PATH . '/partial/_template_functions.inc.php');

// top navigation
require_once(SITE_TEMPLATES_PATH . '/partial/_navigation_header.inc.php');
?>
<!DOCTYPE html>
<html lang="en" dir="<?php echo SITE_LANGUAGE_DIRECTION == 'RTL' ? 'RTL' : 'LTR'; ?>">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <title><?php echo validation::safeOutputToScreen(PAGE_NAME); ?> - <?php echo validation::safeOutputToScreen(SITE_CONFIG_SITE_NAME); ?></title>
        <meta name="description" content="<?php echo validation::safeOutputToScreen(PAGE_DESCRIPTION); ?>" />
        <meta name="keywords" content="<?php echo validation::safeOutputToScreen(PAGE_KEYWORDS); ?>" />
        <meta name="copyright" content="Copyright &copy; <?php echo date("Y"); ?> - <?php echo validation::safeOutputToScreen(SITE_CONFIG_SITE_NAME); ?>" />
        <meta name="robots" content="all" />
        <meta http-equiv="Cache-Control" content="no-cache" />
        <meta http-equiv="Expires" content="-1" />
        <meta http-equiv="Pragma" content="no-cache" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0;">
        <?php pluginHelper::includeAppends('main_page_header.php', array('file' => (isset($file) ? $file : null), 'Auth' => $Auth)); ?>

<!-- ================================ -->
<!-- ========== CSS INCLUDES ========== -->
<!-- ================================ -->
<?php
        // add css files, use the htmlHelper::addCssFile() function so files can be joined/minified
		pluginHelper::addCssFile(SITE_CSS_PATH . '/fonts.css');
        pluginHelper::addCssFile(SITE_CSS_PATH . '/font-icons/entypo/css/entypo.css');
        
        //pluginHelper::addCssFile(SITE_CSS_PATH . '/skins/white.css'); // comment out to use different skins
        pluginHelper::addCssFile(SITE_CSS_PATH . '/berta.css');
		
        pluginHelper::addCssFile(SITE_CSS_PATH . '/flow-theme.css');
        pluginHelper::addCssFile(SITE_CSS_PATH . '/flow-forms.css');
        pluginHelper::addCssFile(SITE_CSS_PATH . '/responsive.css');
        if (SITE_LANGUAGE_DIRECTION == 'RTL')
        {
            // include RTL styles
            pluginHelper::addCssFile(SITE_CSS_PATH . '/flow-rtl.css');
        }
        pluginHelper::addCssFile(SITE_CSS_PATH . '/daterangepicker-bs3.css');
        pluginHelper::addCssFile(SITE_CSS_PATH . '/custom.css');
        pluginHelper::addCssFile(SITE_CSS_PATH . '/file-upload.css');

        // output css
        pluginHelper::outputCss();
        ?>
<link href="<?php echo SITE_CSS_PATH; ?>/font-icons/entypo/css/entypo.css" rel="stylesheet">
<link href="<?php echo SITE_THEME_PATH; ?>/css/bootstrap.css" media="screen" rel="stylesheet" type="text/css">
<link href="<?php echo SITE_THEME_PATH; ?>/css/buttons.css" media="screen" rel="stylesheet" type="text/css">
<link href="<?php echo SITE_THEME_PATH; ?>/css/font-awesome.css" media="screen" rel="stylesheet" type="text/css">
<link href="<?php echo SITE_THEME_PATH; ?>/css/icomoon.css" media="screen" rel="stylesheet" type="text/css">
<link href="<?php echo SITE_THEME_PATH; ?>/css/parallax-slider.css" media="screen" rel="stylesheet" type="text/css">
<link href="<?php echo SITE_THEME_PATH; ?>/css/prettyPhoto.css" media="screen" rel="stylesheet" type="text/css">
<link id="header-switch" href="<?php echo SITE_THEME_PATH; ?>/css/headers/dark.css" media="screen" rel="stylesheet" type="text/css">
<link href="<?php echo SITE_THEME_PATH; ?>/css/animate.css" media="screen" rel="stylesheet" type="text/css">
<link href="<?php echo SITE_THEME_PATH; ?>/css/astonish.css" media="screen" rel="stylesheet" type="text/css">
<link id="style-switch" href="<?php echo SITE_THEME_PATH; ?>/css/color-schemes/default.css" media="screen" rel="stylesheet" type="text/css">
<link href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/css/custom.css" rel="stylesheet">
 
        <script type="text/javascript">
            var WEB_ROOT = "<?php echo WEB_ROOT; ?>";
<?php echo translate::generateJSLanguageCode(); ?>
        </script>
        <?php
        // add js files, use the htmlHelper::addJsFile() function so files can be joined/minified
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery-1.11.0.min.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery-ui.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.dataTables.min.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.tmpl.min.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/load-image.min.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/canvas-to-blob.min.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.iframe-transport.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-process.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-resize.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-validate.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-ui.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/zeroClipboard/ZeroClipboard.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/global.js');

        // output js
        pluginHelper::outputJs();
        ?>
    </head>
<body data-offset="62" data-spy="scroll" data-target=".navbar" >
<!-- ===== PAGE LOADER GRAPHIC ===== -->

<!-- ======================================== -->
<!-- ============ START TOP STICKY MENU ========== -->
<!-- ======================================== -->
<nav class="navbar navbar-default navbar-fixed-top nav-fadein" role="navigation">
  <div class="container">
    <!-- Brand and toggle get grouped for better mobile display -->
    <div class="navbar-header">
      <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#main-menu">
      <i class="fa fa-bars fa-fw"></i>
      </button>
      <a class="navbar-brand weight-900" href="<?php echo coreFunctions::getCoreSitePath(); ?>" class="external"><img src="<?php echo SITE_IMAGE_PATH; ?>/main_logo_inverted.png" alt="<?php echo SITE_CONFIG_SITE_NAME; ?>"/></a>
    </div>

    <!-- Collect the nav links, forms, and other content for toggling -->
    <div class="collapse navbar-collapse" id="main-menu">
      <ul class="nav navbar-nav navbar-right">
       <?php
                            // add any other navigation items
                            $headerNavigation = pluginHelper::generateHeaderNavStructure($headerNavigation, $Auth->level_id);

                            // format nagivation for template
                            $navigationHtmlItems = array();
                            foreach ($headerNavigation AS $headerNavigationItem)
                            {
                                // skip settings menu option
                                if($headerNavigationItem['link_key'] == 'settings')
                                {
                                    continue;
                                }
                                
                                $navHtml = '<li';
                                if (defined('CURRENT_PAGE_KEY') && isset($headerNavigationItem['link_key']) && CURRENT_PAGE_KEY == $headerNavigationItem['link_key'])
                                {
                                    $navHtml .= ' class="current"';
                                }
                                $navHtml .= '><a role="menuitem" tabindex="-1" class="external" href="' . $headerNavigationItem['link_url'] . '"';
                                if (isset($headerNavigationItem['element_id']))
                                {
                                    $navHtml .= ' id="' . validation::safeOutputToScreen($headerNavigationItem['element_id']) . '"';
                                }
                                $navHtml .= '>' . validation::safeOutputToScreen(strtoupper($headerNavigationItem['link_text'])) . '</a></li>';

                                if (isset($headerNavigationItem['wrap_html']))
                                {
                                    $navHtml = str_replace('[[[NAV_ITEM_HTML]]]', $navHtml, $headerNavigationItem['wrap_html']);
                                }

                                $navigationHtmlItems[] = $navHtml;
                            }

// output nav
                            echo implode('', $navigationHtmlItems);
                            ?>
							
		<li><div class="social-icons"><a href="#"><i class="im-twitter"></i></a><a href="#"><i class="im-facebook"></i></a><a href="#"><i class="im-google-plus"></i></a></div></li>
      </ul>
    </div><!-- /.navbar-collapse -->
  </div><!-- /.container-fluid -->
</nav>

<!-- ======================================== -->
<!-- ============ END TOP STICKY MENU =========== -->
<!-- ======================================== -->

       
        <?php
        // if we're on the index page, show the uploader and slider
        if (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'index')
        {
            if (UserPeer::getAllowedToUpload() == true)
            {
                if (isset($_REQUEST['upload']))
                {
                    // auto show uploader
                    echo "<script>\n";
                    echo "$(document).ready(function() {\n";
                    echo "  showUploaderPopup();\n";
                    echo "});";
                    echo "</script>\n";
                }
                ?>
				
                <!-- Modal -->
<div class="modal fade" id="Upload" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
     <?php
                            // uploader code
                            require_once(SITE_TEMPLATES_PATH . '/partial/_uploader.inc.php');
                            ?>
    </div>
  </div>
</div>
                <?php
            }
            ?>
            <!-- SLIDER STARTS --> 

                <section id="home">
<!-- ======================================= -->
<!-- ========== START PARALLAX SLIDER ========== -->
<!-- ======================================== -->
 <!-- SlidesJS Required: Start Slides -->
  <!-- The container is used to define the width of the slideshow -->

    <div id="slides">
	<div class="slides-container">
      <div class="parallax img-overlay3" style="background-image:url(<?php echo SITE_THEME_PATH; ?>/img/pictures/photo.jpg)" data-stellar-background-ratio="0.2">
	  <div class="img-overlay-solid" style="background-color:rgba(60,62,71,0.3);"></div>
	  <div class="caption text-center">
	  <div class="color-white text-center weight-300 large-caption" style="margin-top: -150px">Free File Hosting</div>
	  <div class="color-white text-center weight-800 super-large-caption">UPLOAD!</div>
	  <h4 class="color-white text-center weight-600 uppercase" style="margin-top: 10px; letter-spacing: 1px;">Free File Hosting</h4>
	  <!-- Button trigger modal -->
<button class="btn btn-primary btn-lg" data-toggle="modal" data-target="#Upload">
  UPLOAD!
</button>


	  </div>
	  </div>
	     <div class="parallax img-overlay3" style="background-image:url(<?php echo SITE_THEME_PATH; ?>/img/pictures/photo1.jpg)" data-stellar-background-ratio="0.2">
		   <div class="img-overlay-solid" style="background-color:rgba(60,62,71,0.3);"></div>
		     <div class="caption text-center">
	  <div class="color-white text-center weight-300 large-caption" style="margin-top: -150px">Free File Hosting</div>
	  <div class="color-white text-center weight-800 super-large-caption">UPLOAD!</div>
	  <h4 class="color-white text-center weight-600 uppercase" style="margin-top: 10px; letter-spacing: 1px;">Free File Hosting</h4>
	  <!-- Button trigger modal -->
<button class="btn btn-primary btn-lg" data-toggle="modal" data-target="#Upload">
  UPLOAD!
</button>


	  </div></div>
    </div>
	      <nav class="slides-navigation">
        <a href="#" class="next"><i class="fa-angle-right"></i></a>
        <a href="#" class="prev"><i class="fa-angle-left"></i></a>
      </nav>
    </div>
  <!-- End SlidesJS Required: Start Slides -->
<!-- ======================================= -->
<!-- ========== END PARALLAX SLIDER ========== -->
<!-- ======================================== -->
</section>
           
            <!-- /. SLIDER END -->
            <?php
        }
        ?>
        