<?php
// initial constants
define('ADMIN_SELECTED_PAGE', 'plugins');

// includes and security
include_once('../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

// load plugin details
$pluginId = (int) $_REQUEST['id'];
$plugin   = $db->getRow("SELECT * FROM plugin WHERE id = " . (int) $pluginId . " LIMIT 1");
if (!$plugin)
{
    adminFunctions::redirect(ADMIN_WEB_ROOT . '/plugin_manage.php?error=' . urlencode('There was a problem loading the plugin details.'));
}
define('ADMIN_PAGE_TITLE', $plugin['plugin_name'] . ' Plugin Settings');

// plugin object for functions
$pluginObj = pluginHelper::getInstance('torrentdownload');

// prepare variables
$plugin_enabled = (int) $plugin['plugin_enabled'];
$utorrent_host  = _CONFIG_SITE_HOST_URL;
// remove port from host, if exists
$url_parts      = parse_url($utorrent_host);
if (!isset($url_parts['host']))
{
    $utorrent_host = $url_parts['path'];
}
else
{
    $utorrent_host = $url_parts['host'];
}

$utorrent_port        = '8080';
$utorrent_username    = 'admin';
$utorrent_password    = '';
$show_torrent_tab_paid = 1;
$show_torrent_tab     = 0;
$max_torrents_per_day_free = 5;
$max_concurrent_free = 1;
$max_torrents_per_day_paid = 10;
$max_concurrent_paid = 3;

// load existing settings
if (strlen($plugin['plugin_settings']))
{
    $plugin_settings = json_decode($plugin['plugin_settings'], true);
    if ($plugin_settings)
    {
        $utorrent_host        = $plugin_settings['utorrent_host'];
        $utorrent_port        = $plugin_settings['utorrent_port'];
        $utorrent_username    = $plugin_settings['utorrent_username'];
        $utorrent_password    = $plugin_settings['utorrent_password'];
        $show_torrent_tab_paid = $plugin_settings['show_torrent_tab_paid'];
        $show_torrent_tab     = $plugin_settings['show_torrent_tab'];
		$max_torrents_per_day_free     = $plugin_settings['max_torrents_per_day_free'];
		$max_concurrent_free     = $plugin_settings['max_concurrent_free'];
		$max_torrents_per_day_paid  = $plugin_settings['max_torrents_per_day_paid'];
		$max_concurrent_paid     = $plugin_settings['max_concurrent_paid'];
    }
}

// handle page submissions
if (isset($_REQUEST['submitted']))
{
    // get variables
    $plugin_enabled = (int) $_REQUEST['plugin_enabled'];
    $utorrent_host  = strtolower(trim($_REQUEST['utorrent_host']));
    $url_parts      = parse_url($utorrent_host);
    if (!isset($url_parts['host']))
    {
        $utorrent_host = $url_parts['path'];
    }
    else
    {
        $utorrent_host = $url_parts['host'];
    }

    $utorrent_port        = (int) $_REQUEST['utorrent_port'];
    $utorrent_username    = trim($_REQUEST['utorrent_username']);
    $utorrent_password    = trim($_REQUEST['utorrent_password']);
    $show_torrent_tab_paid = isset($_REQUEST['show_torrent_tab_paid']) ? (int) $_REQUEST['show_torrent_tab_paid'] : 0;
    $show_torrent_tab     = isset($_REQUEST['show_torrent_tab']) ? (int) $_REQUEST['show_torrent_tab'] : 0;
	$max_torrents_per_day_free  = (int) $_REQUEST['max_torrents_per_day_free'];
	$max_concurrent_free        = (int) $_REQUEST['max_concurrent_free'];
	$max_torrents_per_day_paid  = (int) $_REQUEST['max_torrents_per_day_paid'];
	$max_concurrent_paid        = (int) $_REQUEST['max_concurrent_paid'];

    // validate submission
    if (_CONFIG_DEMO_MODE == true)
    {
        adminFunctions::setError(adminFunctions::t("no_changes_in_demo_mode"));
    }

    // update the settings
    if (adminFunctions::isErrors() == false)
    {
        // compile new settings
        $settingsArr                         = array();
        $settingsArr['utorrent_host']        = $utorrent_host;
        $settingsArr['utorrent_port']        = $utorrent_port;
        $settingsArr['utorrent_username']    = $utorrent_username;
        $settingsArr['utorrent_password']    = $utorrent_password;
        $settingsArr['show_torrent_tab_paid'] = $show_torrent_tab_paid;
        $settingsArr['show_torrent_tab']     = $show_torrent_tab;
		$settingsArr['max_torrents_per_day_free']     = $max_torrents_per_day_free;
		$settingsArr['max_concurrent_free']     = $max_concurrent_free;
		$settingsArr['max_torrents_per_day_paid']     = $max_torrents_per_day_paid;
		$settingsArr['max_concurrent_paid']     = $max_concurrent_paid;
        $settings                            = json_encode($settingsArr);

        // update the user
        $dbUpdate                  = new DBObject("plugin", array("plugin_enabled", "plugin_settings"), 'id');
        $dbUpdate->plugin_enabled  = $plugin_enabled;
        $dbUpdate->plugin_settings = $settings;
        $dbUpdate->id              = $pluginId;
        $dbUpdate->update();

        adminFunctions::redirect(ADMIN_WEB_ROOT . '/plugin_manage.php?se=1');
    }
}

if (_CONFIG_DEMO_MODE == true)
{
    $utorrent_password = '****************';
}

// page header
include_once(ADMIN_ROOT . '/_header.inc.php');
?>

<script>
    $(function() {
        // formvalidator
        $("#pluginForm").validationEngine();
    });
</script>

<div class="row clearfix">
    <div class="col_12">
        <div class="sectionLargeIcon" style="background: url(../assets/img/icons/128px.png) no-repeat;"></div>
        <div class="widget clearfix">
            <h2>Plugin Settings</h2>
            <div class="widget_inside">
                <?php echo adminFunctions::compileNotifications(); ?>
                <form method="POST" action="settings.php" name="pluginForm" id="pluginForm" autocomplete="off">
                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Plugin State</h3>
                            <p>Whether the torrent download plugin is available.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Plugin Enabled:</label>
                                    <div class="input">
                                        <select name="plugin_enabled" id="plugin_enabled" class="medium validate[required]">
                                            <?php
                                            $enabledOptions = array(0 => 'No', 1 => 'Yes');
                                            foreach ($enabledOptions AS $k => $enabledOption)
                                            {
                                                echo '<option value="' . $k . '"';
                                                if ($plugin_enabled == $k)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $enabledOption . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
					
					<div class="clearfix col_12">
                        <div class="col_4">
                            <h3>uTorrent Installation</h3>
                            <p>How to install uTorrent and configure it correctly.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <div style="margin: 8px;">
                                        uTorrent can be found via the following url.<br/><br/>
										- <a href="http://www.utorrent.com/downloads/linux" target="_blank">http://www.utorrent.com/downloads/linux</a>
										<br/><br/>
										It needs to be installed on a server which has the full script installed on it. To install uTorrent on Ubuntu via SSH (replace the wget url with the correct download):
										<pre>cd /root
wget http://download.utorrent.com/linux/utorrent-server-3.0-25053.tar.gz
sudo cp utorrent-server-3.0-25053.tar.gz /opt/
cd /opt/
sudo tar -xvf utorrent-server-3.0-25053.tar.gz
sudo rm -rf utorrent-server-3.0-25053.tar.gz
sudo chmod 777 -R utorrent-server-v3_0/
sudo ln -s /opt/utorrent-server-v3_0/utserver /usr/bin/utserver
utserver -settingspath /opt/utorrent-server-v3_0/ &</pre>
                                        Once installed, via the web interface (http://yourdomain.com:8080/gui/, username: admin, password: [blank]), settings icon, ensure you update the "Put new downloads in" setting to:<br/><br/>
                                        <code>
                                            <?php echo DOC_ROOT; ?>/files/_tmp
                                        </code>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>uTorrent Connection Details</h3>
                            <p>Host, port, username and password for the uTorrent interface.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>uTorrent Host/IP:</label>
                                    <div class="input"><input id="utorrent_host" name="utorrent_host" type="text" class="large validate[required]" value="<?php echo adminFunctions::makeSafe($utorrent_host); ?>"/>&nbsp;&nbsp;Exclude http:// and any forward slashes</div>
                                </div>
                                <div class="clearfix">
                                    <label>uTorrent Port:</label>
                                    <div class="input"><input id="utorrent_port" name="utorrent_port" type="text" class="large validate[required]" value="<?php echo adminFunctions::makeSafe($utorrent_port); ?>"/></div>
                                </div>
                                <div class="clearfix alt-highlight">
                                    <label>uTorrent Username:</label>
                                    <div class="input"><input id="utorrent_username" name="utorrent_username" type="text" class="large validate[required]" value="<?php echo adminFunctions::makeSafe($utorrent_username); ?>"/></div>
                                </div>
                                <div class="clearfix">
                                    <label>uTorrent Password:</label>
                                    <div class="input"><input id="utorrent_password" name="utorrent_password" type="password" class="large" value="<?php echo adminFunctions::makeSafe($utorrent_password); ?>"/></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Display Settings</h3>
                            <p>How to show the tab on the homepage.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Paid Only:</label>
                                    <div class="input"><input id="show_torrent_tab_paid" name="show_torrent_tab_paid" type="checkbox" value="1" <?php echo($show_torrent_tab_paid == 1) ? 'CHECKED' : ''; ?>/>&nbsp;&nbsp;only paid users will have access to use the torrent download</div>
                                </div>
                                <div class="clearfix">
                                    <label>Always Show Torrent Tab:</label>
                                    <div class="input"><input id="show_torrent_tab" name="show_torrent_tab" type="checkbox" value="1" <?php echo($show_torrent_tab == 1) ? 'CHECKED' : ''; ?>/>&nbsp;&nbsp;non/free-users will see the torrent tab on the homepage (prompt to register/upgrade<br/>on click)</div>
                                </div>
                            </div>
                        </div>
                    </div>
					
					<div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Other Settings</h3>
                            <p>Limitations for free and paid users.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Free Max Per Day:</label>
                                    <div class="input"><input id="max_torrents_per_day_free" name="max_torrents_per_day_free" type="text" class="small" value="<?php echo adminFunctions::makeSafe($max_torrents_per_day_free); ?>"/>&nbsp;&nbsp;Free (registered) users max torrent downloads permitted per day.</div>
                                </div>
                                <div class="clearfix">
                                    <label>Free Max Concurrent:</label>
                                    <div class="input"><input id="max_concurrent_free" name="max_concurrent_free" type="text" class="small" value="<?php echo adminFunctions::makeSafe($max_concurrent_free); ?>"/>&nbsp;&nbsp;Free (registered) users max concurrent torrents.</div>
                                </div>
								<div class="clearfix alt-highlight">
                                    <label>Paid Max Per Day:</label>
                                    <div class="input"><input id="max_torrents_per_day_paid" name="max_torrents_per_day_paid" type="text" class="small" value="<?php echo adminFunctions::makeSafe($max_torrents_per_day_paid); ?>"/>&nbsp;&nbsp;Paid users max torrent downloads permitted per day.</div>
                                </div>
                                <div class="clearfix">
                                    <label>Paid Max Concurrent:</label>
                                    <div class="input"><input id="max_concurrent_paid" name="max_concurrent_paid" type="text" class="small" value="<?php echo adminFunctions::makeSafe($max_concurrent_paid); ?>"/>&nbsp;&nbsp;Paid users max concurrent torrents.</div>
                                </div>
                            </div>
                        </div>
                    </div>
					
                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Cron Task</h3>
                            <p>How to setup the background cron task to sync YetiShare with uTorrent.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <div style="margin: 8px;">
                                        The cron task is needed to update any current torrent download progress and to also import any torrents which have finished. It should be run every minute.<br/><br/>
                                        The cron script is located here:<br/><br/>
                                        <code>
                                            <?php echo PLUGIN_WEB_ROOT; ?>/torrentdownload/site/track_torrents.cron.php
                                        </code>
                                        <br/><br/><br/>
                                        To execute it call it on the command line like this (this is also the cron command):<br/><br/>
                                        <code>
                                            wget -O- <?php echo PLUGIN_WEB_ROOT; ?>/torrentdownload/site/track_torrents.cron.php > /dev/null
                                        </code>
                                        <br/><br/><br/>
                                        See <a href="http://www.cyberciti.biz/faq/how-do-i-add-jobs-to-cron-under-linux-or-unix-oses/" target="_blank">here for more information</a> on executing the script via a cron task.<br/><br/>
                                        The script must be run on the same server as uTorrent so it can copy the files when finished. Replace the domain path above if you are not running this on your main site.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
					
					<div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Useful Resources</h3>
                            <p>Other useful commands, sites etc.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <div style="margin: 8px;">
                                        uTorrent Site: <a href="http://www.utorrent.com/downloads/linux" target="_blank">http://www.utorrent.com/downloads/linux</a><br/><br/>
										Change uTorrent Port: <a href="http://askubuntu.com/a/202436" target="_blank">http://askubuntu.com/a/202436</a><br/><br/>
										Start Server From Command Line:<br/>
										<pre>utserver -settingspath /opt/utorrent-server-v3_0/ &</pre>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix col_12">
                        <div class="col_4">&nbsp;</div>
                        <div class="col_8 last">
                            <div class="clearfix">
                                <div class="input no-label">
                                    <input type="submit" value="Submit" class="button blue">
                                    <input type="reset" value="Reset" class="button grey">
									<input type="reset" value="Trigger Torrent Cron" class="button grey" onClick="window.open('../site/track_torrents.cron.php');"/>
									<input type="reset" value="uTorrent GUI" class="button grey" onClick="window.open('http://<?php echo adminFunctions::makeSafe($utorrent_host); ?>:<?php echo adminFunctions::makeSafe($utorrent_port); ?>/gui/');"/>
                                </div>
                            </div>
                        </div>
                    </div>

                    <input name="submitted" type="hidden" value="1"/>
                    <input name="id" type="hidden" value="<?php echo $pluginId; ?>"/>
                </form>
            </div>
        </div>   
    </div>
</div>

<?php
include_once(ADMIN_ROOT . '/_footer.inc.php');
?>