<?php

/*
 * API endpoint class
 */

class apiAccount extends apiv2
{
    public function __construct($request, $origin)
    {
        parent::__construct($request);

        // all api requests require the access_token and account_id (apart from the initial authorize
        if(!array_key_exists('access_token', $this->request) || (strlen($this->request['access_token']) == 0))
        {
            throw new Exception('Please provide the access_token param.');
        }
        elseif(!array_key_exists('account_id', $this->request) || (strlen($this->request['account_id']) == 0))
        {
            throw new Exception('Please provide the account_id param.');
        }
        
        // validate access_token and account_id
        $rs = $this->_validateAccessToken($this->request['access_token'], $this->request['account_id']);
        if(!$rs)
        {
            throw new Exception('Could not validate access_token and account_id, please reauthenticate or try again.');
        }
    }

    /**
     * endpoint action
     */
    protected function info()
    {
        $db = Database::getDatabase();
        
        // load account details
        $accountDetails = $db->getRow('SELECT id, username, level_id, email, lastlogindate, lastloginip, status, title, '
                . 'firstname, lastname, languageId, datecreated, lastPayment, paidExpiryDate, storageLimitOverride FROM users '
                . 'WHERE id = :user_id LIMIT 1', array('user_id' => (int)$this->request['account_id']), PDO::FETCH_ASSOC);
        
        return array('data' => $accountDetails);
    }
    
    /**
     * endpoint action
     */
    protected function package()
    {
        $db = Database::getDatabase();
        
        // load account details
        $accountPackage = $db->getRow('SELECT user_level.id, label, max_upload_size, '
                . 'can_upload, wait_between_downloads, download_speed, max_storage_bytes, '
                . 'show_site_adverts, show_upgrade_screen, days_to_keep_inactive_files, concurrent_uploads, '
                . 'concurrent_downloads, downloads_per_24_hours, max_download_filesize_allowed, max_remote_download_urls, '
                . 'level_type, on_upgrade_page FROM user_level '
                . 'LEFT JOIN users ON user_level.id = users.level_id '
                . 'WHERE users.id = :user_id LIMIT 1', array('user_id' => (int)$this->request['account_id']), PDO::FETCH_ASSOC);
        
        return array('data' => $accountPackage);
    }

}
