<?php
// pickup params
$file = $params['file'];
$Auth = $params['Auth'];

if ($file->statusId == 1)
{
	// for includes
	$childFileObj = $file;
	$originalFileObj = $file;
	
    // load plugin details
    $pluginDetails  = pluginHelper::pluginSpecificConfiguration('mediaplayer');
    $pluginConfig   = $pluginDetails['config'];
    $pluginSettings = json_decode($pluginDetails['data']['plugin_settings'], true);

    // load available extensions for this user
    $extType = 'non_media_types';
    if ($Auth->level_id == 1)
    {
        $extType = 'free_media_types';
    }
    elseif ($Auth->level_id > 1)
    {
        $extType = 'paid_media_types';
    }

    $ext = explode("|", $pluginSettings[$extType]);

    // check this is a video or audio, only 'mp4', 'webm', 'mp3', 'ogg' supported in this tab view
    if ((in_array(strtolower($file->extension), $ext) && (in_array(strtolower($file->extension), array('mp4', 'webm', 'mp3', 'ogg')))))
    {
        // get plugin object for subtitles later
        $pluginObj = pluginHelper::getInstance('mediaplayer');
        
        // get player
        $mediaPlayer = $pluginConfig['players'][strtolower($file->extension)];
        if ($mediaPlayer == 'jplayer_video')
        {
            $mediaPlayer = 'html5_video';
        }
        elseif ($mediaPlayer == 'jplayer_audio')
        {
            $mediaPlayer = 'html5_audio';
        }

        // which html5 player to use
        $html5Player = $pluginSettings['html5_player'];
        if (strlen($html5Player) == 0)
        {
            $html5Player = 'jplayer';
        }
        ?>
        <?php if ($file->extension == 'webm'): ?>
            <!-- for testing IE support with webm files -->
            <script type="text/javascript">
                function videoFail(vid)
                {
                    var ua = window.navigator.userAgent;
                    var msie = ua.indexOf("MSIE ");
                    if (msie > 0 || !!navigator.userAgent.match(/Trident.*rv\:11\./))
                    {
                        //	some complications so that in IE9 we offer to install WebM
                        $('#videoFailIECheck').show();
                        $('#iEWebmSupport').show();
                        $('#jwPlayerContainer').remove();
                        $('#jplayer_container').remove();
                        $('#videoFailText').html(getMediaErrorString(vid));
                    }
                }

                function getMediaErrorString(vid)
                {
                    try {
                        switch (vid.error.code) {
                            case vid.error.MEDIA_ERR_ABORTED:
                                $('#iEWebmSupport').hide();
                                return 'You aborted the video playback.';
                            case vid.error.MEDIA_ERR_NETWORK:
                                $('#iEWebmSupport').hide();
                                return 'A network error caused the video download to fail part-way.';
                            case vid.error.MEDIA_ERR_DECODE:
                                return 'The video playback was aborted due to a corruption problem or because the video used features your browser did not support.';
                            case vid.error.MEDIA_ERR_SRC_NOT_SUPPORTED:
                                return 'The video could not be loaded, either because the server or network failed or because the format is not supported.';
                            default:
                                return 'An unknown error occurred.';
                        }
                    }
                    catch (exp) {
                        return 'Your browser does not fully implement the HTML5 video element.';
                    }
                }
            </script>
            <div style="display: none;">
                <video src="<?php echo $file->generateDirectDownloadUrlForMedia(); ?>" controls preload="metadata" onerror="videoFail(this)"></video>
            </div>
        <?php endif; ?>
        
        <?php if (in_array($mediaPlayer, array('html5_video', 'html5_audio'))): ?>
            <?php
            $jPlayerCat = $file->extension;
            $jwPlayerCat = $file->extension;
            switch ($file->extension)
            {
                case 'mp4':
                    $jPlayerCat = 'm4v';
                    break;
                case 'm4v':
                    $jwPlayerCat = 'mp4';
                    break;
                case 'ogg':
                    $jwPlayerCat = 'webm';
                case 'webm':
                    $jPlayerCat = 'webmv';
                    break;
            }
            ?>

            <?php if ($html5Player == 'jplayer'): ?>
                <!-- jplayer -->
                <link href="<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jplayer/skin/blue.monday/jplayer.blue.monday.css" rel="stylesheet" type="text/css" />
                <script type="text/javascript" src="<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jplayer/jquery.jplayer.min.js"></script>
                <!-- end jplayer -->

                <script type="text/javascript">
                //<![CDATA[
                $(document).ready(function() {
                $("#jplayer_container").jPlayer({
                    ready: function() {
                        $(this).jPlayer("setMedia", {
                <?php echo $jPlayerCat; ?>: "<?php echo $file->generateDirectDownloadUrlForMedia(); ?>"
                        });
                                $('body').keyup(function(e) {
                            if (e.keyCode == 27)
                            {
                                $('#jplayer_container').data("jPlayer").restoreScreen();
                            }
                        });
                    },
                    swfPath: "<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jplayer/Jplayer.swf",
                    supplied: "<?php echo $jPlayerCat; ?>",
                    solution: "html,flash",
                    size: {
                        width: "100%",
                        height: "<?php echo $mediaPlayer == 'html5_video' ? '530px' : ''; ?>",
                        cssClass: "<?php echo $mediaPlayer == 'html5_video' ? 'jp-video-360p' : 'jp-audio'; ?>"
                    }
                });
                });
                //]]>
                </script>
            <?php endif; ?>

            <?php if ($html5Player == 'jwplayer'): ?>
                <!-- jwplayer -->
                <script type="text/javascript" src="<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jwplayer/jwplayer.js"></script>
                <?php
                if (isset($pluginSettings['html5_player_license_key']) && strlen($pluginSettings['html5_player_license_key']))
                {
                    echo '<script type="text/javascript">jwplayer.key="' . validation::safeOutputToScreen($pluginSettings['html5_player_license_key']) . '";</script>';
                    echo "\n";
                }
                ?>
                <!-- end jwplayer -->
            <?php endif; ?>
                
            <?php if ($html5Player == 'jwplayer7'): ?>
                <!-- jwplayer7 -->
                <script type="text/javascript" src="<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jwplayer7/jwplayer.js"></script>
                <?php
                if (isset($pluginSettings['html5_player_license_key']) && strlen($pluginSettings['html5_player_license_key']))
                {
                    echo '<script type="text/javascript">jwplayer.key="' . validation::safeOutputToScreen($pluginSettings['html5_player_license_key']) . '";</script>';
                    echo "\n";
                }
                ?>
                <!-- end jwplayer7 -->
            <?php endif; ?>

        <?php endif; ?>
        
        <div class="tab-pane" id="mediaplayer-preview" style="text-align: center;">
            <script>
                // remove any existing callbacks
                $('#fileDetailsModal').off('hidden.bs.modal');
                // stop any video and audio on close of the modal
                $('#fileDetailsModal').on('hidden.bs.modal', function () {
                    <?php if ($html5Player == 'jwplayer'): ?>
                    if(typeof($('#jwPlayerContainer')) != 'undefined')
                    {
                        jwplayer('jwPlayerContainer').stop();
                    }
                    <?php endif; ?>
                    <?php if ($html5Player == 'jwplayer7'): ?>
                    if(typeof($('#jwPlayerContainer')) != 'undefined')
                    {
                        jwplayer('jwPlayerContainer').stop();
                    }
                    <?php endif; ?>
                    <?php if ($html5Player == 'jplayer'): ?>
                    if(typeof($('#jplayer_container')) != 'undefined')
                    {
                        $('#jplayer_container').jPlayer("stop");
                    }
                    <?php endif; ?>
					<?php if ($html5Player == 'videojs'): ?>
                    if(typeof($('#videoJSContainer')) != 'undefined')
                    {
						$(".video-js")[0].player.pause();
                    }
                    <?php endif; ?>
                });
            </script>

        <?php
        // append any plugin includes
        //pluginHelper::includeAppends('media_player_file_download_bottom_header.php', array('file' => $file, 'Auth' => $Auth));
        ?>

        <?php if ($mediaPlayer == 'html5_video'): ?>

            <div id="videoFailIECheck" style="display: none; vertical-align: middle; text-align: center; background-color: #dedede; padding: 30px;">
                <a id="iEWebmSupport" href="https://tools.google.com/dlpage/webmmf/" target="_blank">
                    <img style="border: none" alt="Install WebM support from webmproject.org" src="<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/img/Install-WebM-Support.png" />
                </a>
                <br/><br/><span id="videoFailText">WebM Support Required</span>
            </div>

            <?php
			// disable any ads since we're within the admin area
			define('FROM_USER_ACCOUNT', true);
			$playerIncludePath = PLUGIN_DIRECTORY_ROOT.'mediaplayer/includes/_player_'.$mediaPlayer.'_'.$html5Player.'.inc.php';
			if(!file_exists($playerIncludePath))
			{
				echo "Error: ".$mediaPlayer." player for ".$html5Player." not found!";
			}
			else
			{
				include_once($playerIncludePath);
			}
			?>

        <?php endif; ?>

        <?php if ($mediaPlayer == 'html5_audio'): ?>

            <?php
			// disable any ads since we're within the admin area
			define('FROM_USER_ACCOUNT', true);
			$playerIncludePath = PLUGIN_DIRECTORY_ROOT.'mediaplayer/includes/_player_'.$mediaPlayer.'_'.$html5Player.'.inc.php';
			if(!file_exists($playerIncludePath))
			{
				echo "Error: ".$mediaPlayer." player for ".$html5Player." not found!";
			}
			else
			{
				include_once($playerIncludePath);
			}
			?>

        <?php endif; ?>
    </div>
    <?php
    }
}
?>