<?php
// try to load the file object
$file = null;
if (isset($_REQUEST['_page_url']))
{
    // only keep the initial part if there's a forward slash
    $shortUrl = current(explode("/", $_REQUEST['_page_url']));
    $file = file::loadByShortUrl($shortUrl);
}

/* load file details */
if (!$file)
{
    /* if no file found, redirect to home page */
    coreFunctions::redirect(WEB_ROOT . "/index." . SITE_CONFIG_PAGE_EXTENSION);
}

// for page footer link
if (!defined('REPORT_URL'))
{
    define('REPORT_URL', $file->getFullShortUrl());
}

// check for linked files
$originalFileObj = null;
$childFileObj = null;
if(property_exists($file, 'linkedFileId'))
{
	// get parent file object if this is the linked child, used for later download links
	if($file->linkedFileId != null)
	{
		$currentFileObj = file::loadById((int)$file->linkedFileId);
		if($currentFileObj)
		{
			$originalFileObj = $currentFileObj;
		}
	}
	else
	{
		// setup database
        $db = Database::getDatabase();
		
		// get child file object if this is a 'parent'
		$childFile = (int)$db->getValue('SELECT id FROM file WHERE linkedFileId = '.(int)$file->id.' AND statusId = 1 LIMIT 1');
		if($childFile)
		{
			$currentFileObj = file::loadById((int)$childFile);
			if($currentFileObj)
			{
				$childFileObj = $currentFileObj;
			}
		}
	}
}
if($originalFileObj === null)
{
	$originalFileObj = $file;
}
if($childFileObj === null)
{
	$childFileObj = $file;
}

// load plugin details
$pluginDetails = pluginHelper::pluginSpecificConfiguration('mediaplayer');
$pluginConfig = $pluginDetails['config'];
$pluginSettings = json_decode($pluginDetails['data']['plugin_settings'], true);

// Initialize current user
$Auth = Auth::getAuth();
define("CONTROLS_HEIGHT", 40);

// load available extensions for this user
$extType = 'non_media_types';
if (($Auth->level == 'free user') && ($Auth->loggedIn == true))
{
    $extType = 'free_media_types';
}
elseif (($Auth->level == 'paid user') || ($Auth->level == 'admin'))
{
    $extType = 'paid_media_types';
}
$ext = explode("|", $pluginSettings[$extType]);

// if this is a download request
if ((!isset($_REQUEST['dt'])) && (in_array(strtolower($originalFileObj->extension), $ext)) && (Stats::isDownloadManager($_SERVER['HTTP_USER_AGENT']) == false))
{
    // get plugin object for subtitles later
    $pluginObj = pluginHelper::getInstance('mediaplayer');

    // setup database
    $db = Database::getDatabase();

    // get player
    $mediaPlayer = $pluginConfig['players'][strtolower($childFileObj->extension)];
    if ($mediaPlayer == 'jplayer_video')
    {
        $mediaPlayer = 'html5_video';
    }
    elseif ($mediaPlayer == 'jplayer_audio')
    {
        $mediaPlayer = 'html5_audio';
    }

    // which html5 player to use
    $html5Player = $pluginSettings['html5_player'];
    if (strlen($html5Player) == 0)
    {
        $html5Player = 'jplayer';
    }

    // prepare trimmed header
    $headerTitle = $originalFileObj->originalFilename;
    if (strlen($headerTitle) > 60)
    {
        $headerTitle = substr($headerTitle, 0, 55) . '...' . end(explode(".", $headerTitle));
    }

    // setup page
    define("PAGE_NAME", $originalFileObj->originalFilename . ' ' . t("media_player_plugin_watch_page_name", "Watch"));
    define("PAGE_DESCRIPTION", t("media_player_plugin_page_description", "Watch or listen to ") . ' ' . $originalFileObj->originalFilename);
    define("PAGE_KEYWORDS", strtolower($originalFileObj->originalFilename) . t("media_player_plugin_meta_keywords", ", watch, listen, file, upload, download, site"));

    // include header
    require_once(SITE_TEMPLATES_PATH . '/partial/_header.inc.php');
    ?>
    
	<?php if ((strlen($pluginSettings['html5_player_license_key']) == 0) && ($mediaPlayer == 'html5_audio')): ?>
    <style>
    .jwlogo
	{
		display: none; /* hidden as sits over volume on mp3s */
	}
    </style>
	<?php endif; ?>
    
    <?php if ($childFileObj->extension == 'webm'): ?>
        <!-- for testing IE support with webm files -->
        <script type="text/javascript">
            function videoFail(vid)
            {
                var ua = window.navigator.userAgent;
                var msie = ua.indexOf("MSIE ");
                if (msie > 0 || !!navigator.userAgent.match(/Trident.*rv\:11\./))
                {
                    //	some complications so that in IE9 we offer to install WebM
                    $('#videoFailIECheck').show();
                    $('#iEWebmSupport').show();
                    $('#jwPlayerContainer').remove();
                    $('#jplayer_container').remove();
                    $('#videoFailText').html(getMediaErrorString(vid));
                }
            }

            function getMediaErrorString(vid)
            {
                try {
                    switch (vid.error.code) {
                        case vid.error.MEDIA_ERR_ABORTED:
                            $('#iEWebmSupport').hide();
                            return 'You aborted the video playback.';
                        case vid.error.MEDIA_ERR_NETWORK:
                            $('#iEWebmSupport').hide();
                            return 'A network error caused the video download to fail part-way.';
                        case vid.error.MEDIA_ERR_DECODE:
                            return 'The video playback was aborted due to a corruption problem or because the video used features your browser did not support.';
                        case vid.error.MEDIA_ERR_SRC_NOT_SUPPORTED:
                            return 'The video could not be loaded, either because the server or network failed or because the format is not supported.';
                        default:
                            return 'An unknown error occurred.';
                    }
                }
                catch (exp) {
                    return 'Your browser does not fully implement the HTML5 video element.';
                }
            }
        </script>
        <div style="display: none;">
            <video src="<?php echo $childFileObj->generateDirectDownloadUrlForMedia(); ?>" controls preload="metadata" onerror="videoFail(this)"></video>
        </div>
    <?php endif; ?>

    <?php if (in_array($mediaPlayer, array('html5_video', 'html5_audio'))): ?>
        <?php
        $jPlayerCat = $childFileObj->extension;
        $jwPlayerCat = $childFileObj->extension;
        switch ($childFileObj->extension)
        {
            case 'mp4':
                $jPlayerCat = 'm4v';
                break;
            case 'm4v':
                $jwPlayerCat = 'mp4';
                break;
            case 'ogg':
                $jwPlayerCat = 'webm';
            case 'webm':
                $jPlayerCat = 'webmv';
                break;
        }
        ?>

        <?php if ($html5Player == 'jplayer'): ?>
            <!-- jplayer -->
            <link href="<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jplayer/skin/blue.monday/jplayer.blue.monday.css" rel="stylesheet" type="text/css" />
            <script type="text/javascript" src="<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jplayer/jquery.jplayer.min.js"></script>
            <!-- end jplayer -->

            <script type="text/javascript">
            //<![CDATA[
            $(document).ready(function() {
            $("#jplayer_container").jPlayer({
                ready: function() {
                    $(this).jPlayer("setMedia", {
            <?php echo $jPlayerCat; ?>: "<?php echo $childFileObj->generateDirectDownloadUrlForMedia(); ?>"
                    })<?php echo $pluginSettings['auto_play'] == 1 ? '.jPlayer("play")' : ''; ?>;
                            $('body').keyup(function(e) {
                        if (e.keyCode == 27)
                        {
                            $('#jplayer_container').data("jPlayer").restoreScreen();
                        }
                    });
                },
                swfPath: "<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jplayer/Jplayer.swf",
                supplied: "<?php echo $jPlayerCat; ?>",
                solution: "html,flash",
                size: {
                    width: "100%",
                    height: "<?php echo $mediaPlayer == 'html5_video' ? '530px' : ''; ?>",
                    cssClass: "<?php echo $mediaPlayer == 'html5_video' ? 'jp-video-360p' : 'jp-audio'; ?>"
                }
            });
            });
            //]]>
            </script>
        <?php endif; ?>

        <?php if ($html5Player == 'jwplayer'): ?>
            <!-- jwplayer -->
            <script type="text/javascript" src="<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jwplayer/jwplayer.js"></script>
            <?php
            if (isset($pluginSettings['html5_player_license_key']) && strlen($pluginSettings['html5_player_license_key']))
            {
                echo '<script type="text/javascript">jwplayer.key="' . validation::safeOutputToScreen($pluginSettings['html5_player_license_key']) . '";</script>';
                echo "\n";
            }
            ?>
			
			<script>
			var trackJWTime = false;
			var jwTimer = null;
			var timerPeriod = 5; // after how many seconds to check for the video state again
			var totalPlayedTime = 0;
			var mediaTotalDuration = -1;
			<?php
			if(pluginHelper::pluginEnabled('rewards'))
			{
				$rewardObj = pluginHelper::getInstance('rewards');
				$ackPercentage = (int)$rewardObj->settings['ppd_media_percentage'];
				if(($ackPercentage >= 1) && ($ackPercentage <= 99))
				{
					echo "var ackPercentage = ".$ackPercentage.";\n";
					echo "var trackJWTime = true;\n";
				}
			}
			?>
			</script>
			
            <!-- end jwplayer -->
        <?php endif; ?>
            
        <?php if ($html5Player == 'jwplayer7'): ?>
            <!-- jwplayer7 -->
            <script type="text/javascript" src="<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jwplayer7/jwplayer.js"></script>
            <?php
            if (isset($pluginSettings['html5_player_license_key']) && strlen($pluginSettings['html5_player_license_key']))
            {
                echo '<script type="text/javascript">jwplayer.key="' . validation::safeOutputToScreen($pluginSettings['html5_player_license_key']) . '";</script>';
                echo "\n";
            }
            ?>
			
			<script>
			var trackJWTime = false;
			var jwTimer = null;
			var timerPeriod = 5; // after how many seconds to check for the video state again
			var totalPlayedTime = 0;
			var mediaTotalDuration = -1;
			<?php
			if(pluginHelper::pluginEnabled('rewards'))
			{
				$rewardObj = pluginHelper::getInstance('rewards');
				$ackPercentage = (int)$rewardObj->settings['ppd_media_percentage'];
				if(($ackPercentage >= 1) && ($ackPercentage <= 99))
				{
					echo "var ackPercentage = ".$ackPercentage.";\n";
					echo "var trackJWTime = true;\n";
				}
			}
			?>
			</script>
			
            <!-- end jwplayer7 -->
        <?php endif; ?>

    <?php endif; ?>

    <?php
    // append any plugin includes
    pluginHelper::includeAppends('media_player_file_download_bottom_header.php', array('file' => $originalFileObj, 'Auth' => $Auth));
    ?>

        <div class="contentPageWrapper">
            <div class="pageSectionMainFull ui-corner-all">
                <div class="pageSectionMainInternal">
                    <div id="pageHeader" class="first-header">
                        <h2><?php echo validation::safeOutputToScreen($headerTitle); ?></h2>
                    </div>
                    <div>

                        <?php if ($mediaPlayer == 'html5_video'): ?>

                            <div id="videoFailIECheck" style="display: none; vertical-align: middle; text-align: center; background-color: #dedede; padding: 30px;">
                                <a id="iEWebmSupport" href="https://tools.google.com/dlpage/webmmf/" target="_blank">
                                    <img style="border: none" alt="Install WebM support from webmproject.org" src="<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/img/Install-WebM-Support.png" />
                                </a>
                                <br/><br/><span id="videoFailText">WebM Support Required</span>
                            </div>

							<?php
							$playerIncludePath = PLUGIN_DIRECTORY_ROOT.'mediaplayer/includes/_player_'.$mediaPlayer.'_'.$html5Player.'.inc.php';
							if(!file_exists($playerIncludePath))
							{
								echo "Error: ".$mediaPlayer." player for ".$html5Player." not found!";
							}
							else
							{
								include_once($playerIncludePath);
							}
							?>

                        <?php endif; ?>

                        <?php if ($mediaPlayer == 'html5_audio'): ?>

                            <?php
							$playerIncludePath = PLUGIN_DIRECTORY_ROOT.'mediaplayer/includes/_player_'.$mediaPlayer.'_'.$html5Player.'.inc.php';
							if(!file_exists($playerIncludePath))
							{
								echo "Error: ".$mediaPlayer." player for ".$html5Player." not found!";
							}
							else
							{
								include_once($playerIncludePath);
							}
							?>

                        <?php endif; ?>

                        <?php if ($mediaPlayer == 'divx_web_player'): ?>
                            <object classid="clsid:67DABFBF-D0AB-41fa-9C46-CC0F21721616"
                                    width="100%" height="530"
                                    codebase="http://go.divx.com/plugin/DivXBrowserPlugin.cab">
                                <param name="src" value="<?php echo $childFileObj->generateDirectDownloadUrlForMedia(); ?>"/>
                                <param name="autoPlay" value="<?php echo $pluginSettings['auto_play'] == 1 ? 'true' : 'false'; ?>"/>

                                <embed
                                    type="video/divx"
                                    src="<?php echo $childFileObj->generateDirectDownloadUrl(); ?>"
                                    width="100%" height="530"
                                    autoPlay="<?php echo $pluginSettings['auto_play'] == 1 ? 'true' : 'false'; ?>"
                                    pluginspage="http://go.divx.com/plugin/download/">
                                </embed>
                            </object>
                        <?php endif; ?>

                        <?php if ($mediaPlayer == 'windows_media_player'): ?>
                            <object classid="CLSID:6BF52A52-394A-11d3-B153-00C04F79FAA6" id="player" width="100%" height="530">
                                <param name="url" value="<?php echo $childFileObj->generateDirectDownloadUrlForMedia(); ?>" />
                                <param name="src" value="<?php echo $childFileObj->generateDirectDownloadUrlForMedia(); ?>" />
                                <param name="showcontrols" value="true" />
                                <param name="autostart" value="<?php echo $pluginSettings['auto_play'] == 1 ? 'true' : 'false'; ?>" />
                                <!--[if !IE]>-->
                                <object type="video/x-ms-wmv" data="<?php echo $childFileObj->generateDirectDownloadUrlForMedia(); ?>" width="100%" height="530">
                                    <param name="src" value="<?php echo $childFileObj->generateDirectDownloadUrlForMedia(); ?>" />
                                    <param name="controller" value="true" />
                                    <param name="autostart" value="<?php echo $pluginSettings['auto_play'] == 1 ? 'true' : 'false'; ?>" />
                                </object>
                                <!--<![endif]-->
                            </object>

                        <?php endif; ?>

                    </div>
                    <div class="clear"><!-- --></div>

                    <div id="pageHeader" style="padding-top: 12px;">
                        <h2><?php echo UCWords(t('file_details', 'file details')); ?></h2>
                    </div>
                    <div>
                        <table class="accountStateTable table table-bordered table-striped">
                            <tbody>
                                <tr>
                                    <td class="first share-file-table-header">
                                        <?php echo UCWords(t('filename', 'filename')); ?>:
                                    </td>
                                    <td>
                                        <?php echo validation::safeOutputToScreen($originalFileObj->originalFilename); ?>&nbsp;&nbsp;
                                        <?php if ((int) $pluginSettings['show_download_link'] == 1): ?>
                                            <a href="<?php echo $originalFileObj->generateDirectDownloadUrl(); ?>" target="_blank">(<?php echo t('download', 'download'); ?>)</a>
                                        <?php endif; ?>
                                        <?php if ($Auth->id != $originalFileObj->userId): ?>
                                            &nbsp;&nbsp;<a href="<?php echo CORE_PAGE_WEB_ROOT . '/account_copy_file.php?f=' . $originalFileObj->shortUrl; ?>">(<?php echo t('copy_into_your_account', 'copy file'); ?>)</a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="first share-file-table-header">
                                        <?php echo UCWords(t('filesize', 'filesize')); ?>:
                                    </td>
                                    <td>
                                        <?php echo coreFunctions::formatSize($originalFileObj->fileSize); ?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="clear"><!-- --></div>

                    <?php if ((int) $pluginSettings['show_embed'] == 1): ?>
                        <div id="pageHeader" style="padding-top: 12px;">
                            <h2><?php echo t("embed_code", "embed code"); ?></h2>
                        </div>
                        <div>
                            <table class="accountStateTable table table-bordered table-striped">
                                <tbody>
                                    <tr>
                                        <td class="first share-file-table-header">
                                            <?php echo t('embed_video', 'Embed Video'); ?>:
                                        </td>
                                        <td class="htmlCode ltrOverride">
                                            <?php
                                            // embed size
                                            $embedWidth = (int) $pluginSettings['embed_video_size_w'];
                                            $embedHeight = (int) $pluginSettings['embed_video_size_h'] + (int) CONTROLS_HEIGHT;
                                            if ($mediaPlayer == 'html5_audio')
                                            {
                                                $embedHeight = '109';
                                            }
                                            echo htmlentities('<iframe src="' . PLUGIN_WEB_ROOT . '/mediaplayer/site/_embed.php?u=' . $childFileObj->shortUrl . '&w=' . $pluginSettings['embed_video_size_w'] . '&h=' . $pluginSettings['embed_video_size_h'] . '" frameborder="0" scrolling="no" style="width: ' . $embedWidth . 'px; height: ' . $embedHeight . 'px; overflow: hidden;" webkitAllowFullScreen="true" mozallowfullscreen="true" allowFullScreen="true"></iframe>');
                                            ?>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="clear"><!-- --></div>
                    <?php endif; ?>

                    <div id="pageHeader" style="padding-top: 12px;">
                        <h2><?php echo t("download_urls", "download urls"); ?></h2>
                    </div>
                    <div>
                        <table class="accountStateTable table table-bordered table-striped">
                            <tbody>
                                <tr>
                                    <td class="first share-file-table-header">
                                        <?php echo t('html_code', 'HTML Code'); ?>:
                                    </td>
                                    <td class="htmlCode ltrOverride">
                                        <?php echo $originalFileObj->getHtmlLinkCode(); ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="first share-file-table-header">
                                        <?php echo UCWords(t('forum_code', 'forum code')); ?>
                                    </td>
                                    <td class="htmlCode ltrOverride">
                                        <?php echo $originalFileObj->getForumLinkCode(); ?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="clear"><!-- --></div>

                    <div id="pageHeader" style="padding-top: 12px;">
                        <h2><?php echo t("share", "share"); ?></h2>
                    </div>
                    <div>
                        <table class="accountStateTable table table-bordered table-striped">
                            <tbody>
                                <tr>
                                    <td class="first share-file-table-header">
                                        <?php echo UCWords(t('share_file', 'share file')); ?>:
                                    </td>
                                    <td>
                                        <!-- AddThis Button BEGIN -->
                                        <div class="addthis_toolbox addthis_default_style addthis_32x32_style">
                                            <a class="addthis_button_preferred_1" addthis:url="<?php echo $originalFileObj->getFullShortUrl(); ?>" addthis:title="<?php echo str_replace("\"", "", $originalFileObj->originalFilename); ?>"></a>
                                            <a class="addthis_button_preferred_2" addthis:url="<?php echo $originalFileObj->getFullShortUrl(); ?>" addthis:title="<?php echo str_replace("\"", "", $originalFileObj->originalFilename); ?>"></a>
                                            <a class="addthis_button_preferred_3" addthis:url="<?php echo $originalFileObj->getFullShortUrl(); ?>" addthis:title="<?php echo str_replace("\"", "", $originalFileObj->originalFilename); ?>"></a>
                                            <a class="addthis_button_preferred_4" addthis:url="<?php echo $originalFileObj->getFullShortUrl(); ?>" addthis:title="<?php echo str_replace("\"", "", $originalFileObj->originalFilename); ?>"></a>
                                            <a class="addthis_button_compact" addthis:url="<?php echo $originalFileObj->getFullShortUrl(); ?>" addthis:title="<?php echo str_replace("\"", "", $originalFileObj->originalFilename); ?>"></a>
                                            <a class="addthis_counter addthis_bubble_style" addthis:url="<?php echo $originalFileObj->getFullShortUrl(); ?>" addthis:title="<?php echo str_replace("\"", "", $originalFileObj->originalFilename); ?>"></a>
                                        </div>
                                        <script type="text/javascript" src="<?php echo _CONFIG_SITE_PROTOCOL; ?>://s7.addthis.com/js/250/addthis_widget.js#pubid=xa-4f10918d56581527"></script>
                                        <!-- AddThis Button END -->
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="clear"><!-- --></div>
					<?php pluginHelper::includeAppends('file_download_bottom_extra.php', array('file' => $file)); ?>
            </div>
        </div>
    </div>
    <div class="clear"></div>

    <?php
    // include footer
    require_once(SITE_TEMPLATES_PATH . '/partial/_footer.inc.php');
    exit;
}
elseif ((isset($_REQUEST['dt'])) && (in_array(strtolower($originalFileObj->extension), $ext)))
{
    $directDownloadUrl = $originalFileObj->generateDirectDownloadUrl();
    coreFunctions::redirect($directDownloadUrl);
}
