<?php

// initial constants
define('ADMIN_SELECTED_PAGE', 'plugins');

// includes and security
include_once('/home/admin/web/uploadbox.co/public_html/core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');
include_once('../includes/functions.php');
// load plugin details
$pluginId = (int) $_REQUEST['id'];
$plugin   = $db->getRow("SELECT * FROM plugin WHERE id = " . (int) $pluginId . " LIMIT 1");
if (!$plugin)
{
	adminFunctions::redirect(ADMIN_WEB_ROOT . '/plugin_manage.php?error=' . urlencode('There was a problem loading the plugin details.'));
}
define('ADMIN_PAGE_TITLE', $plugin['plugin_name'] . ' Plugin Settings');

// prepare variables
$plugin_enabled = (int) $plugin['plugin_enabled'];
if (strlen($plugin['plugin_settings']))
{
	$plugin_settings = json_decode($plugin['plugin_settings'], true);
	if ($plugin_settings)
	{
		$linksAccess	= $plugin_settings['linksAccess'];
		$linksMessage	= $plugin_settings['linksMessage'];
		$linksMax		= $plugin_settings['linksMax'];
	}
}
// handle page submissions
if (isset($_REQUEST['submitted']))
{
	$plugin_enabled = (int) $_REQUEST['plugin_enabled'];
	$linksAccess	= $_REQUEST['linksAccess'];
	$linksMessage	= $_REQUEST['linksMessage'];
	$linksMax		= $_REQUEST['linksMax'];
	if(empty($linksMessage))
	{
		$linksMessage = 'Sorry, you do not have access to the link checker.';
	}

	if (_CONFIG_DEMO_MODE == true)
	{
		adminFunctions::setError(adminFunctions::t("no_changes_in_demo_mode"));
	}
	$settingsArr = array();
	$settingsArr['linksAccess']		= $linksAccess;
	$settingsArr['linksMessage']	= $linksMessage;
	$settingsArr['linksMax']		= $linksMax;
	$settings						= json_encode($settingsArr);

	// update the settings
	if (adminFunctions::isErrors() == false)
	{
		// update the user
		$dbUpdate = new DBObject("plugin", array("plugin_enabled", "plugin_settings"), 'id');
		$dbUpdate->plugin_enabled = $plugin_enabled;
		$dbUpdate->plugin_settings = $settings;
		$dbUpdate->id = $pluginId;
		$dbUpdate->update();
		adminFunctions::redirect(ADMIN_WEB_ROOT . '/plugin_manage.php?se=1');
	}
}

// page header
include_once(ADMIN_ROOT . '/_header.inc.php');
?>
<script>
	$(function() {
		// formvalidator
		$("#userForm").validationEngine();
	});
</script>
<div class="row clearfix">
	<div class="col_12">
		<div class="sectionLargeIcon" style="background: url(../assets/img/icons/128px.png) no-repeat;"></div>
		<div class="widget clearfix">
			<h2><?php echo adminFunctions::t('plugin_settings', 'Plugin Settings'); ?></h2>
			<div class="widget_inside">
				<?php echo adminFunctions::compileNotifications(); ?>
				<form method="POST" action="settings.php" name="pluginForm" id="pluginForm" autocomplete="off">
					<div class="clearfix col_12">
						<div class="col_4">
							<h3><?php echo adminFunctions::t('plugin_state', 'Plugin State'); ?></h3>
							<p><?php echo adminFunctions::t('link_enabled', 'Whether the Link Checker is enabled'); ?>.</p>
						</div>
						<div class="col_8 last">
							<div class="form">
								<div class="clearfix alt-highlight">
									<label><?php echo adminFunctions::t('plugin_enabled', 'Plugin Enabled'); ?>:</label>
									<div class="input">
										<select name="plugin_enabled" id="plugin_enabled" class="medium validate[required]">
											<?php
											$enabledOptions = array(0 => 'No', 1 => 'Yes');
											foreach ($enabledOptions AS $k => $enabledOption)
											{
												echo '<option value="' . $k . '"';
												if ($plugin_enabled == $k)
												{
													echo ' SELECTED';
												}
												echo '>' . $enabledOption . '</option>';
											}
											?>
										</select>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="clearfix col_12">
						<div class="col_4">
							<h3><?php echo adminFunctions::t('plugin_access', 'Plugin Access'); ?></h3>
							<p><?php echo adminFunctions::t('plugin_access_desc', 'Which user groups have access to the link checker'); ?></p>
						</div>
						<div class="col_8 last">
							<div class="form">
								<div class="clearfix alt-highlight">
									<label>Access:</label>
									<div class="input">
										<select name="linksAccess" id="linksAccess" class="medium validate[required]">
											<?php
											$enabledOptions = array('10' => 'Admin &amp; Mods Only', '2' => 'Admin, Mods &amp; Paid Users', '1' => 'Logged In Users', '0' => 'All Users');
											foreach ($enabledOptions AS $k => $enabledOption)
											{
												echo '<option value="' . $k . '"';
												if ($linksAccess == $k)
												{
													echo ' SELECTED';
												}
												echo '>' . $enabledOption . '</option>';
											}
											?>
										</select>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="clearfix col_12">
						<div class="col_4">
							<h3><?php echo adminFunctions::t('lc_maximum_links', 'Maximum Links'); ?></h3>
							<p><?php echo adminFunctions::t('lc_maximum_links_desc', 'The maximum number of links that a user can check each time they submit the form'); ?>.</p>
						</div>
						<div class="col_8 last">
							<div class="form">
								<div class="clearfix alt-highlight">
									<label><?php echo adminFunctions::t('lc_max_links', 'Max Links'); ?>:</label>
									<div class="input">
										<select name="linksMax" id="linksMax" class="medium validate[required]">
											<?php
											$enabledOptions = array('5' => '5', '10' => '10', '15' => '15', '20' => '20', '25' => '25', '30' => '30', '35' => '35', '45' => '45', '50' => '50', '75' => '75', '100' => '100');
											foreach ($enabledOptions AS $k => $enabledOption)
											{
												echo '<option value="' . $k . '"';
												if ($linksMax == $k)
												{
													echo ' SELECTED';
												}
												echo '>' . $enabledOption . '</option>';
											}
											?>
										</select>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="clearfix col_12">
						<div class="col_4">
							<h3><?php echo adminFunctions::t('lc_err_mess', 'Error Message'); ?></h3>
							<p><?php echo adminFunctions::t('lc_err_mess_desc', 'The error that the user will see if they do not have access to the link checker'); ?>.</p>
						</div>
						<div class="col_8 last">
							<div class="form">
								<div class="clearfix alt-highlight">
									<label><?php echo adminFunctions::t('lc_err_mess', 'Error Message'); ?>:</label>
									<div class="input">
									<input type="text" name="linksMessage" style="width:400px;" id="linksMessage" class="medium validate[required]" value="<?php echo $linksMessage; ?>" />
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="clearfix col_12">
						<div class="col_4">&nbsp;</div>
						<div class="col_8 last">
							<div class="clearfix">
								<div class="input no-label">
									<input type="submit" value="Submit" class="button blue">
									<input type="reset" value="Reset" class="button grey">
								</div>
							</div>
						</div>
					</div>
					<input name="submitted" type="hidden" value="1"/>
					<input name="id" type="hidden" value="<?php echo $pluginId; ?>"/>
				</form>
			</div>
		</div> 
	</div>
</div>
<?php

include_once(ADMIN_ROOT . '/_footer.inc.php');
?>