<?php

// setup result array
$rs = array();

// do login
$password             = $_POST["password"];
$confirmPassword      = $_POST["confirmPassword"];
$userId               = $_POST["u"];
$passwordHash         = $_POST["h"];
$rs['forgot_password_status'] = 'invalid';
$rs['error'] = '';

// check for pending hash
$user = UserPeer::loadUserByPasswordResetHash($passwordHash);
if (!$user)
{
    $rs['error'] = t("general_error", "General error");
    echo json_encode($rs);
    exit;
}

// check user id passed is valid
if ($user->id != $userId)
{
    $rs['error'] = t("general_error", "General error");
    echo json_encode($rs);
    exit;
}

// initial validation
if (!strlen($password))
{
    // log failure
    $rs['error'] = t("please_enter_your_password", "Please enter your new password");
}
elseif ((strlen($password) < 6) || (strlen($password) > 20))
{
    $rs['error'] = t("password_length_incorrect", "Password should be between 6 - 20 characters in length");
}
elseif (validation::containsInvalidCharacters(strtolower($password), 'abcdefghijklmnopqrstuvwxyz1234567890@~#!-_£$&*()^%}{()'))
{
    $rs['error'] = t("password_contains_illegal_characters", "Password contains invalid characters, please choose another.");
}
elseif ($password != $confirmPassword)
{
    $rs['error'] = t("password_confirmation_does_not_match", "Your password confirmation does not match");
}

$redirectUrl = '';
if (strlen($rs['error']) == 0)
{
    // update password
    $db = Database::getDatabase(true);
    $db->query('UPDATE users SET passwordResetHash = "", password = :password WHERE id = :id', array('password' => Password::createHash($password), 'id'       => $userId));

    // success
    $success = true;

    $redirectUrl          = WEB_ROOT . "/login." . SITE_CONFIG_PAGE_EXTENSION . "?s=1";
    $rs['forgot_password_status'] = 'success';
}

// login success
if ($rs['forgot_password_status'] == 'success')
{
    // Set the redirect url after successful login
    $rs['redirect_url'] = $redirectUrl;
}

echo json_encode($rs);