//================================================================
//
// toolObject.js   |
//
//

// ----------------------------------------------------------------------------
// COPYRIGHT 2000 DELCAM PLC., BIRMINGHAM, ENGLAND. 
// ----------------------------------------------------------------------------

                                 
//=== Tool Constructor ==============================================
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// tpb 11/02/00 Written - name of global variable used is passed in
//              I can eventually change this so that it is not necessary,
//              but it is too much work at the moment.
// bem 06/03/00 Added editing stepdown option
// bem 11/04/00 Moved stepdown option to end to keep backwards compatibility
// bem 04/07/00 Store ArtCAM object so we can pass it back
// tpb 06/07/00 Added optional hide_select_button argument to hide the select button
//              for when this tool control is used by the tool control list.
// bem 09/08/00 Added GetEffectiveDiameterAtDepth method
// bem 21/08/00 Hold all values in tool object rater than duplicating diameter etc
// bem 08/09/00 Check if callback actually specified
// bem 06/06/01 If tool selection cancel return to undefined state
//              Move all translatable strings into seperate variables
// bem 27/07/01 Call user callback if user selects 'null' tool
// bem 29/03/02 Changed tool number from drop down list to edit field to allow
//              larger range of numbers
// bem 18/11/03 Modifed to ensure fields remained numeric after selection of tool
// pah 30/10/06 Added default arguments for hide tool details and for tool summary
//              These allow just tool parameters to be displayed
// pah 08/11/06 Added support for final pass feed rate
//-----------------------------------------------------------------------------


// shortcut to write variable names into the document
var w=document.write;

function Tool
   (
   name, 
   title, 
   edit_stepover, 
   changed_callback, 
   edit_stepdown,
   hide_select_button,
   hide_tool_details,					// Hides icon and tool details. Only parameters are visible
   tool_summary	                        // Only used if hide_tool_details is true, otherwise
                                        // use 'Undefined' or OA_Tool description
   )
{
   // Check the default arguments
   hide_select_button = hide_select_button == null ? false : hide_select_button;
   hide_tool_details = hide_tool_details == null ? false : hide_tool_details;
   tool_summary = tool_summary == null ? "" : tool_summary;

   // Assign Members
   this.name = name;
   this.title = title;
   this.edit_stepover = edit_stepover;
   this.edit_stepdown = edit_stepdown;
   this.hide_select_button = hide_select_button;
//   this.show_rollup = this.hide_select_button;
   this.show_rollup = true;
   this.hide_tool_details = hide_tool_details;
   this.tool_summary = tool_summary;
   this.allow_final_pass = false;               // This flag allows final pass data
   this.gray_final_pass = true;                 // ...which is grayed by default

   this.parameters = null;

   // image name
   this.tool_image = null;

   // Assign Functions
   this.writeDiv     = Tool_WriteDiv;
   this.initialise   = Tool_Initialise;
   this.writeTerse   = Tool_WriteTerse;
   this.onSelect     = Tool_OnSelect;
   this.onTerseClick = Tool_OnTerseClick;
   this.onTypeChange = Tool_OnTypeChange;
   this.onApply      = Tool_OnApply;
   this.updateTool   = Tool_UpdateToolDescription;
   this.UpdateData   = Tool_UpdateData;
   this.showDetails  = Tool_ShowDetails;
   this.hideDetails  = Tool_HideDetails;
   this.allowFinalPassDetails = Tool_AllowFinalPassDetails;
   this.grayFinalPassDetails  = Tool_GrayFinalPassDetails;

   this.GetEffectiveDiameterAtDepth   = Tool_GetEffectiveDiameterAtDepth;

   // is there a callback ?
   if (changed_callback == null)
      {
      this.doCallback = false;
      }
   else
      {
      this.updateCallback = changed_callback
      this.doCallback = true;
      }

   // get path to the root of our html - we use this to build
   // addresses to our images
   this.image_dir = artcam.HtmlRootDir();
   this.image_dir += "..\\SharedImages\\Tools\\"

   // tool object created within ArtCAM
   this.tool = null;
}


//=== Tool_AllowFinalPassDetails ==============================================
//
// Call this immediatly after construction to allow final pass feed rate box
// to be drawn. 
//
// This method prevents yet another meaningless argument in the HTML script
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 pah 08/11/06 Written
//-----------------------------------------------------------------------------
function Tool_AllowFinalPassDetails()
{
   this.allow_final_pass = true;
}



//=== Tool_WriteDiv ===========================================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 tpb 11/02/00 Written - writes the Div into the page.
// 00000 bem 14/02/00 Simplified and removed edit fields for non-editable fields
// 00000 tpb 06/07/00 Added conditional hide_select_button part
//-----------------------------------------------------------------------------
function Tool_WriteDiv()
{
//alert("function Tool_WriteDiv()")

   // This is a bit like create. We write all our document objects into the page
   // then show and hide them as we wish.

   // create string for toolpath image
   var image_path = "   <td valign=top><IMG src=\"";
   image_path += this.image_dir;
   image_path += "SingleTool40.gif\" align = top></td>";

   // alert(image_path)

   document.writeln("<table border=0 cellspacing=0 width=100%>");

   document.writeln("<tr><td colspan=2 height=2px></td></tr>");
   document.writeln("<tr><td colspan=2 bgcolor=buttonshadow></td></tr>");
   document.writeln("<tr><td colspan=2 bgcolor=buttonhighlight></td></tr>");
   document.writeln("<tr><td colspan=2 height=2px></td></tr>");

   //document.writeln("<td><nobr><span class = BemHeading>" + this.title + "</span></td>")
   if (!this.hide_select_button )
      {
      document.writeln("<tr>");
      //document.writeln("<td><span class = BemHeading>" + this.title + "</span></td>")
      document.writeln("<td><b><span>" + this.title + "</span></b></td>")
      document.writeln("<td align=right><input width=50% type=button id='" + this.name + "SelectButton' onClick='javascript:" + this.name + ".onSelect()'>");
      document.writeln("<script>" + this.name + "SelectButton.value=gstSelectButtonText</script>");
      document.writeln("</td>"); 
      document.writeln("</tr>");
      }
   
   document.writeln("<tr height=4px>");
   document.writeln("</tr>");

   //document.writeln("</nobr></tr>");
   // row for terse description   - blank first column for icon
   document.writeln("<tr style=" + "background-color:" + artcam.GetSystemColourShadeString(COLOR_BTNFACE,2,COLOR_BTNSHADOW,1) + ">");
   document.writeln("<td colspan=2 onclick='javascript:" + this.name + ".onTerseClick()'>");
   
   if (this.show_rollup)
      {
      document.writeln("<img align = 'right' id='" + this.name + "OpenCloseButton'");
      document.writeln(" src='" + this.image_dir + "..\\open_down_small_blue.gif'>");
      document.writeln("<span id='" + this.name + "ToggleTextSpan'></span>");
      }
   
   document.writeln("<span id='" + this.name + "TerseSpan'>Terse Description</span> </td>");
   document.writeln("</tr>");

   // new table to hold detailed description - blank first column for icon
   
   document.writeln("<tr>");
   document.writeln("<td colspan=2>"); // create table in remaining columns

   // write detailed section
   var feed_units = "";
   var units = "";


   document.writeln("     <div id='" + this.name + "SettingsDiv' style='display:none'>\n");
   //document.writeln("     <table class=Dialog border=1  cellspacing=0>");
   document.writeln("     <table border=1 cellspacing=0 width=100% bgcolor=red>");
if (this.edit_stepover)
   {
   document.writeln("        <tr><td>" + gstStepoverText + "</td>");
   document.writeln("            <td><input id='" + this.name + "StepoverEdit' type=text size=8 maxLength=6 number>" + units +      "</td></tr>");
   }
if (this.edit_stepdown)
   {
   document.writeln("        <tr><td>" + gstMaxDepthText + "</td>");
   document.writeln("            <td><input id='" + this.name + "StepdownEdit' type=text size=8 maxLength=6 number>" + units +      "</td></tr>");
   }

   document.writeln("        <tr><td>" + gstFeedRateText + "</td>");
   document.writeln("            <td><input id='" + this.name + "FeedRateEdit'     type=text size=8 maxLength=6 number >" + feed_units + "</td></tr>");  

if (this.allow_final_pass) {
   document.writeln("        <tr><td><span id='" + this.name + "FinalPassFeedRateLabel'>" + gstFinalPassFeedRateText + "</span></td>");                       
   document.writeln("            <td><input id='" + this.name + "FinalPassFeedRateEdit'     type=text size=8 maxLength=6 number >" + feed_units + "</td></tr>");
}
   document.writeln("        <tr><td>" + gstFeedRateText + "</td>");
   document.writeln("             <td><input id='" + this.name + "PlungeRateEdit'   type=text size=8 maxLength=6 number>" + feed_units + "</td></tr>");
   document.writeln("        <tr><td>" + gstSpindleText  + "</td>");
   document.writeln("             <td><input id='" + this.name + "SpindleSpeedEdit' type=text size=8 maxLength=6 number dp=0 positive></td></tr>");
   document.writeln("        <tr><td><b>" + gstToolNumber + ":</b></td>");
   document.writeln("             <td>");
   document.writeln("             <input id='" + this.name + "ToolNumberEdit' type=text size=3 maxlength=4 number dp=0>");
   document.writeln("             </td></tr>");
   document.writeln("     </table>\n");
   document.writeln("     </div>");
   document.writeln("  </td>\n");
   document.writeln("</tr>\n");
   document.writeln("</table>\n");
}



//=== Tool_Initialise ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 tpb 11/02/00 Written - Assigns object events to this object
// 00000 bem 10/08/00 Update display of terse button
//-----------------------------------------------------------------------------

function Tool_Initialise()
{
   // Create members attached to the objects in our Div on the page.
   // This is done by evaluating the name that we called it when we wrote it in writeDiv
   // Since the object has this global name the evaluation returns the object
   // which we store in our object for convenience.
   // A bit like do data exchange in CDialog!

   this.terseSpan        = eval( this.name + "TerseSpan" );
   if (this.show_rollup )
      {
      this.toggleSpan       = eval( this.name + "ToggleTextSpan" );
      this.OpenCloseButton  = eval( this.name + "OpenCloseButton");
      }
   if (!this.hide_select_button)
      this.selectButton     = eval( this.name + "SelectButton" );

   this.settingsDiv      = eval( this.name + "SettingsDiv" );

   if (this.edit_stepover) 
      this.stepoverEdit     = eval( this.name + "StepoverEdit" );
   
   if (this.edit_stepdown)    
      this.stepdownEdit     = eval( this.name + "StepdownEdit" );

   this.spindleSpeedEdit = eval( this.name + "SpindleSpeedEdit" );
   this.feedRateEdit     = eval( this.name + "FeedRateEdit" );

   if (this.allow_final_pass) {
      this.finalPassFeedRateEdit = eval( this.name + "FinalPassFeedRateEdit" );
      this.finalPassFeedRateLabel = eval( this.name + "FinalPassFeedRateLabel" );
   }

   this.plungeRateEdit   = eval( this.name + "PlungeRateEdit" );
   this.toolNumberEdit   = eval( this.name + "ToolNumberEdit" );
   // write the terse description
   this.writeTerse();

   if (this.show_rollup)
      {
      this.OpenCloseButton.style.display = "none";
      this.toggleSpan.style.display = "none";
      }

   if (this.tool != null) {
	   this.toolNumberEdit.value = this.tool.ToolNumber;
   }

   if (this.allow_final_pass) {
      this.finalPassFeedRateLabel.style.color= this.gray_final_pass ? 'graytext' : 'windowtext';
      this.finalPassFeedRateEdit.disabled = this.gray_final_pass;
      this.finalPassFeedRateEdit.readOnly = this.gray_final_pass;	

      if (this.tool) {
         if (this.finalPassFeedRateEdit.value == "undefined")
            this.finalPassFeedRateEdit.value = this.tool.FeedRate;
      }
   }
} 


//=== Tool_WriteTerse ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 tpb 11/02/00 Written
//       pah 30/10/06 If hiding tool details, display the generic summary
//-----------------------------------------------------------------------------

function Tool_WriteTerse()
{
   // Write the terse description in.
   if (this.tool == null) {
     
	 this.terseSpan.innerHTML = '<span style=\"COLOR: #FF0000\">' + gstUndefinedText + '</span>';

   } else if (this.hide_tool_details) {

	 this.terseSpan.innerHTML = "<b>" + this.tool_summary + "</b>";

   } else {

     this.terseSpan.innerHTML = "<b>" + this.tool.Description + "</b>";
   }
}

//=== Tool_OnSelect ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 tpb 11/02/00 Written - Performs the selection
// 00000 tpb 06/07/00 Added optional argument for control by the ToolListCtrl
// 00000 bem 10/08/00 Change check for being controlled externally
//-----------------------------------------------------------------------------

function Tool_OnSelect(newtool)
{
// If the variable passed in null AND we are controlling selection externally
// a null tool means change to undefined
if ( this.hide_select_button &&  newtool == null )
   {
   this.settingsDiv.innerHTML = "";
   this.terseSpan.innerHTML = '<span style=\"COLOR: #FF0000\">' + gstUndefinedText + '</span>';
   if (this.show_rollup)
      {
      this.OpenCloseButton.style.display = "none";
      this.toggleSpan.style.display = "none";
      }
   this.tool = null;
   return;
   }

// If no tool was passed in get the tool from ArtCAM   
if (newtool == null)
{
   newtool = artcam.SelectTool(); 
   if(newtool == null)
      return;
   else
      this.tool = newtool;
}
else
   this.tool = newtool;

// fill in tool type name
this.tool_type_name = gstUndefinedText;

if (this.tool == null)
   {
   this.settingsDiv.innerHTML = "";
   this.terseSpan.innerHTML = '<span style=\"COLOR: #FF0000\">' + gstUndefinedText + '</span>';
   if (this.show_rollup)
      {
      this.OpenCloseButton.style.display = "none";
      this.toggleSpan.style.display = "none";
      }
   // update form this tool is in
   if (this.doCallback)
      this.updateCallback();
      return;
   }


switch (this.tool.ToolType)
   {
   case 0:
        this.tool_type_name = gstBallNose
        this.tool_image = this.image_dir + "BallNoseTool.gif";
        break;
   case 1:
        this.tool_type_name = gstSlotDrill
        this.tool_image = this.image_dir + "SlotDrillTool.gif";
        break;
   case 2:
        this.tool_type_name = gstRadSlotDrill
        this.tool_image = this.image_dir + "RadiusedSlotDrillTool.gif";
        break;
   case 3:
        this.tool_type_name = gstConical
        this.tool_image = this.image_dir + "PointedConicalTool.gif";
        break;
   case 4:
        if (this.tip_radius > 0.0)
           {
           this.tool_type_name = gstRadConical
           this.tool_image = this.image_dir + "ConicalTool.gif";
           }
        else
           {
           this.tool_type_name = gstConical
           this.tool_image = this.image_dir + "PointedConicalTool.gif";
           }
        break;
   case 5:
        this.tool_type_name = gstFlatConical
        this.tool_image = this.image_dir + "FlatConicalTool.gif";
        break;
   case 6:
        this.tool_type_name = gstFlatRadConical
        this.tool_image = this.image_dir + "FlatRadiusedConicalTool.gif";
        break;
   case 7:
        this.tool_type_name = gstVBit
        this.tool_image = this.image_dir + "VBitTool.gif";
        break;
   case 10:       // Ogee
        this.tool_type_name = gstOgee;
        this.tool_image = this.image_dir + "VBitTool.gif";
        break;

   case 11:       // Roman Ogee
        this.tool_type_name = gstRomanOgee;
        this.tool_image = this.image_dir + "VBitTool.gif";
        break;

   case 12:       // Roundover
        this.tool_type_name = gstRoundover;
        this.tool_image = this.image_dir + "VBitTool.gif";
        break;

   case 13:       // Raised Ogee
        this.tool_type_name = gstRaisedOgee;
        this.tool_image = this.image_dir + "VBitTool.gif";
        break;

   case 14:       // Raised Cove
        this.tool_type_name = gstRaisedCove;
        this.tool_image = this.image_dir + "VBitTool.gif";
        break;

   case 15:       // Raised Straight
        this.tool_type_name = gstRaisedStraight;
        this.tool_image = this.image_dir + "VBitTool.gif";
        break;
   };

this.updateTool();

//if (!this.show_rollup)
//   showDetails();

// update form this tool is in
if (this.doCallback)
   this.updateCallback();


}


//=== Tool_UpdateToolDescription ==============================================
//
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 14/02/00 Written
//       pah 30/10/06 Can hide tool details
//       pah 09/11/06 Prevent crash if no tool
//-----------------------------------------------------------------------------
function Tool_UpdateToolDescription()
{

if (this.tool == null)
   return;

// output the description for this tool
var units = "&nbsp;inches";
if (artcam.InMM)
   units = "&nbsp;mm";

// if tool was in inches but user in mm (or vice-versa) convert
var conv_factor = 1.0;
if (this.tool.InMM != artcam.InMM)
   {
   // swap values 
   if (this.tool.InMM)
      conv_factor = 1.0 / 25.4; // tool in mm - artcam in inches
   else
      conv_factor = 25.4;       // tool in inches artcam in mm
   }


var value = this.tool.Diameter * conv_factor;
value = RoundUnits(value);
this.new_description =
   " <table class = Dialog  border=0  cellspacing=0> \n";
   
if (!this.hide_tool_details) {			// Should we hide the tool details?
   this.new_description += 
	   " <tr> <td width=22 valign=top> <IMG src='" + this.tool_image + "'></td><td>"+
	   " <table class = Dialog  border=0  cellspacing=0> \n" +
	   "      <tr><td>" + gstToolTypeText + ":</td><td>" + this.tool_type_name + "</td></tr>\n" +
	   "      <tr><td>" + gstDiameterText + ":</td><td>" + value + units + "</td></tr>\n";
}

// output data specific for selected tool type
switch (this.tool.ToolType)
   {
   //case 0:
   //   this.tool_type_name = gstBallNose
   //    break;
   //case 1:
   //     this.tool_type_name = gstSlotDrill
   //   break;
   case 2:
      //this.tool_type_name = gstRadSlotDrill
      this.new_description = this.new_description + 
               "      <tr><td>" + gstTipRadius + ":    </td><td>" + RoundUnits(this.tool.TipRadius * conv_factor)+ units +"</td></tr>\n";
        break;
   case 3:
        // this.tool_type_name = gstConical
      this.new_description = this.new_description + 
              "      <tr><td>" + gstSideAngle + ":    </td>" +
           "          <td>" + this.tool.SideAngle + " " + gstDegreesText + "</td></tr>\n";
        break;
   case 4:
        // this.tool_type_name = gstRadConical
      this.new_description = this.new_description + 
              "      <tr><td>" + gstSideAngle + "</td>" + 
           "          <td>" + this.tool.SideAngle + " " + gstDegreesText + "</td></tr>\n";
      if (this.tool.TipRadius > 0.0)
         {
         this.new_description = this.new_description + 
              "      <tr><td>" + gstTipRadius + ":    </td>" + 
           "          <td>" + RoundUnits(this.tool.TipRadius * conv_factor)+ units + "</td></tr>\n";
         }
        break;
   case 5:
        // this.tool_type_name = gstFlatConical
      this.new_description = this.new_description + 
              "      <tr><td>" + gstSideAngle + ":    </td>" + 
           "          <td>" + this.tool.SideAngle + " " + gstDegreesText + "</td></tr>\n" +
              "      <tr><td>" + gstFlatRadius + ":   </td>" + 
           "          <td>" + RoundUnits(this.tool.FlatRadius * conv_factor) +  units +"</td></tr>\n";
        break;
   case 6:
        //this.tool_type_name = gstFlatRadConical
      this.new_description = this.new_description + 
              "      <tr><td>" + gstSideAngle + ":    </td>" +
           "          <td>" + this.tool.SideAngle + " " + gstDegreesText + "</td></tr>\n" +
              "      <tr><td>" + gstFlatRadius + ":   </td>" + 
           "          <td>" + RoundUnits(this.tool.FlatRadius * conv_factor) + units + "</td></tr>\n"+
              "      <tr><td>" + gstTipRadius + ":   </td>" +
           "          <td>" + RoundUnits(this.tool.TipRadius * conv_factor) + units + "</td></tr>\n";
        break;


   };

this.new_description = this.new_description + "</table></tr><tr><table border=0  cellspacing=0>"; 

// and finally the editable fields

var feed_units = gstUnknownText;

switch (this.tool.FeedRateUnits)
   {
   case 0:      // TPM_MM_SEC
        feed_units = gstMM_Sec;
        break;
   case 1:      // TPM_MM_MIN
        feed_units = gstMM_Min;
        break;
   case 2:      // TPM_M_MIN
        feed_units = gstM_Min;
        break;
   case 3:      // TPM_INCH_SEC
        feed_units = gstINCH_Sec;
        break;  
   case 4:      // TPM_INCH_MIN
        feed_units = gstINCH_Min;
        break;  
   case 5:
        feed_units = gstFEET_Min;
        break;  // TPM_FEET_MIN
   }

feed_units = "&nbsp;" + feed_units;

var units = Units();

// tool may be in different units to model - display stepover and cut depth
// in current model units


if (this.edit_stepover)
   {
   var value = this.tool.Stepover;
   if (this.tool.InMM != artcam.InMM)
      {
      // swap values 
      if (this.tool.InMM)
         value = value / 25.4; // tool in mm - artcam in inches
      else
         value = value * 25.4; // tool in inches artcam in mm
      value = RoundUnits(value);
      }
   this.new_description = this.new_description +
   "<tr><td><b>" + gstStepoverText + ":</b>      </td><td><input id='" + this.name + "StepoverEdit' type=text size=6 maxLength=6 value="+ value + " number positive></input> " + units + "</td></tr>\n";
   }

if (this.edit_stepdown)
   {
   var value = this.tool.CuttingLength;
   if (this.tool.InMM != artcam.InMM)
      {
      // swap values 
      if (this.tool.InMM)
         value = value / 25.4; // tool in mm - artcam in inches
      else
         value = value * 25.4; // tool in inches artcam in mm
      value = RoundUnits(value);
      }

   this.new_description = this.new_description +
   "<tr><td><b>" + gstMaxDepthText + ":</b>      </td><td><input id='" + this.name + "StepdownEdit' type=text size=6 maxLength=6 value=" + value + " number></input> " + units + "</td></tr>\n";
   }

this.new_description = this.new_description +
   "<tr><td><b>" + gstFeedRateText   + ":</b></td><td><input  id='" + this.name + "FeedRateEdit'     type=text size=6 maxLength=6 value=" + this.tool.FeedRate     + " number positive></input>" + feed_units + "</td></tr>\n";

if (this.allow_final_pass) {
   this.new_description = this.new_description +
   "<tr><td><b><span id='" + this.name + "FinalPassFeedRateLabel'>" + gstFinalPassFeedRateText + "</span></b></td>" +
       "<td><input  id='" + this.name + "FinalPassFeedRateEdit'     type=text size=6 maxLength=6 value=" + this.finalFeedRate     + " number positive></input>" + feed_units + "</td></tr>\n";
}

this.new_description = this.new_description +
   "<tr><td><b>" + gstPlungeRateText + ":</b></td><td><input  id='" + this.name + "PlungeRateEdit'   type=text size=6 maxLength=6 value=" + this.tool.PlungeRate   + " number positive></input>" + feed_units + "</td></tr>\n" +
   "<tr><td><b>" + gstSpindleText    + ":</b></td><td><input  id='" + this.name + "SpindleSpeedEdit' type=text size=6 maxLength=6 value=" + this.tool.SpindleSpeed + " number dp=0 positive></input>" + gstRPM + "</td></tr>\n" +
   "<tr><td><b>" + gstToolNumber     + ":</b></td><td><input  id='" + this.name + "ToolNumberEdit'  type=text size=3 maxlength=4 number dp=0>" +
   "               </td></tr>";

// finish off the table
this.new_description = this.new_description + "    </table>";
this.new_description = this.new_description + "    </td></tr></table>";

this.settingsDiv.innerHTML = this.new_description;

this.toolNumberEdit.value = this.tool.ToolNumber;


// update the terse setting as well - we need to call tool initialise method to re-bind
// the edit fields as they have changed when we rewrote the div
this.initialise();

// and display our full settings
// ensure that toggle terse button is visible
if (this.show_rollup )
   {
   this.OpenCloseButton.style.display = "";
   this.toggleSpan.style.display = "";
   }                           
else
   {
   this.settingsDiv.style.display = "";
   }

// bem 18/11/03 Update number edit status as we have written HTML
  SubclassNumberEditControls();
}


//=== Tool_OnApply ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 tpb 11/02/00 Written
//-----------------------------------------------------------------------------

function Tool_OnApply
   (
   ) 
{
}


//=== Tool_OnTerseClick ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 tpb 11/02/00 Written
//-----------------------------------------------------------------------------

function Tool_OnTerseClick()
   {
   // if the current tool is 'undefined' we cant display details
   if (this.tool == null)
      {
      this.settingsDiv.style.display = "none";
      // hide the up/down button and text as well
      this.OpenCloseButton.style.display = "none";
      this.toggleSpan.style.display = "none";
      return;
      }
   // if we reach here we have a tool
   if (this.show_rollup)
      {
      this.OpenCloseButton.style.display = "";
      this.toggleSpan.style.display = "";

      // Toggle the visibility!
      if(this.settingsDiv.style.display == "none" )
         {
         this.settingsDiv.style.display = "";
         this.OpenCloseButton.src = this.image_dir + "..\\close_up_small_blue.gif";
         this.OpenCloseButton.border = 0;
         // this.toggleSpan.innerText="Hide"
         this.toggleSpan.innerText=""
         }
      else
         {
         this.settingsDiv.style.display = "none";
         this.OpenCloseButton.src = this.image_dir + "..\\open_down_small_blue.gif";
         this.OpenCloseButton.border = 0;
         // this.toggleSpan.innerText="Details"
         this.toggleSpan.innerText=""
         }
      }
   }


//=== Tool_OnTypeChange ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 tpb 11/02/00 Written
//-----------------------------------------------------------------------------

function Tool_OnTypeChange()
{
   // Just write out the terse version for now...
   this.writeTerse();

}

//=== Tool_UpdateData ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 tpb 24/02/00 Written
// 00000 bem 04/07/00 Update ArtCAM tool object as well
//-----------------------------------------------------------------------------

function Tool_UpdateData
   (
   ) 
{

// If the tool has not been selected then we can't do this.
if (this.tool == null)
   {
   // alert("Tool_UpdateData - no tool selected");
   return true;
   }
// update tool parameters in ArtCAM - NOTE: can only change
// speeds, feeds and cutting length of tool not any geometry


// Updates all the variables that have associated edit boxes.
if (this.edit_stepover)
   {
   var value = parseFloat(this.stepoverEdit.value);
   if (this.tool.InMM != artcam.InMM)
      {
      // swap values 
      if (this.tool.InMM)
         value = value * 25.4; // tool in mm - artcam in inches
      else
         value = value / 25.4; // tool in inches artcam in mm
      }
   this.tool.StepOver = value;
   }

if (this.edit_stepdown)
   {
   var value = parseFloat(this.stepdownEdit.value);
   if (this.tool.InMM != artcam.InMM)
      {
      // swap values 
      if (this.tool.InMM)
         value = value * 25.4; // tool in mm - artcam in inches
      else
         value = value / 25.4; // tool in inches artcam in mm
      }
   this.tool.CuttingLength = value;
   }

this.tool.SpindleSpeed     = parseFloat(this.spindleSpeedEdit.value);
this.tool.FeedRate         = parseFloat(this.feedRateEdit.value);
this.tool.PlungeRate       = parseFloat(this.plungeRateEdit.value);
this.tool.ToolNumber       = parseInt(this.toolNumberEdit.value);

//alert("Spindle: " + this.tool.SpindleSpeed + "\r\n" + "FeedRate: " + this.tool.FeedRate + "\r\n" + "PlungeRate: " + this.tool.PlungeRate);

return true;
}



//=== Tool_GetEffectiveDiameterAtDepth ==============================================
//
// Return effective diameter for tool at passed depth
//

//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 09/08/2000 Written
//-----------------------------------------------------------------------------

function Tool_GetEffectiveDiameterAtDepth
   (
   depth,
   in_mm
   ) 
{
return this.tool.GetEffectiveDiameterAtDepth(depth,in_mm);
}


//=== Tool_ShowDetails ==============================================
//
// Show full tool details
//

// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 10/08/00  Written
//-----------------------------------------------------------------------------

function Tool_ShowDetails()
   {
   // if the current tool is 'undefined' we cant display details
   if (this.tool == null)
      {
      this.settingsDiv.style.display = "none";
      // hide the up/down button and text as well
      if (this.show_rollup)
         {
         this.OpenCloseButton.style.display = "none";
         this.toggleSpan.style.display = "none";
         }
      return;
      }
   this.settingsDiv.style.display = "";
   if (this.show_rollup)
      {
      this.OpenCloseButton.src = this.image_dir + "..\\close_up_small_blue.gif";
      this.OpenCloseButton.border = 0;
      //this.toggleSpan.innerText="Hide"
      this.toggleSpan.innerText=""
      }
   }


//=== Tool_HideDetails ==============================================
//
// Hide full tool details
//

// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 10/08/00  Written
//-----------------------------------------------------------------------------

function Tool_HideDetails()
   {
   // if the current tool is 'undefined' we cant display details
   if (this.tool == null)
      {
      this.settingsDiv.style.display = "none";
      // hide the up/down button and text as well
      if (this.show_rollup)
         {
         this.OpenCloseButton.style.display = "none";
         this.toggleSpan.style.display = "none";
         }
      return;
      }
   if (this.show_rollup)
      {
      this.settingsDiv.style.display = "none";
      this.OpenCloseButton.src = "../../SharedImages/open_down_small_blue.gif";
      this.OpenCloseButton.border = 0;
      // this.toggleSpan.innerText="Details"
      this.toggleSpan.innerText=""
      }
   }



//=== Tool_GrayFinalPassDetails ===============================================
//
// Gray final pass details. Has no effect if AllowFinalPassDetails() was not
// called.
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------------
// pah 08/11/06 Written
//-----------------------------------------------------------------------------
function Tool_GrayFinalPassDetails( flag )
{
   if (this.allow_final_pass) {
      this.gray_final_pass = flag;
   }
}