function ProjectInfo(assembly)
{
   this.name = "";
   this.diameter = 0;
   this.shank_width = 0;
   this.shank_thickness = 0;
   this.resolution = 0;
   this.sizing_system = 0;
   this.size = 0;
   this.size_description = "";
   this.project_dir = "";

   this.RetrieveRingInfoFromAssembly = project_RetrieveRingInfoFromAssembly;
   this.RetrieveInfoFromFile = project_RetrieveInfoFromFile;
   this.StoreRingInfoInAssembly = project_StoreRingInfoInAssembly;
   
   this.WriteDiv = project_WriteDiv;
   
   if(typeof(assembly)!='undefined')
   {
      this.StoreRingInfoInAssembly(assembly);
   }
}

function project_RetrieveRingInfoFromAssembly(assembly)
{
   if(typeof(assembly)=='undefined')
   {
      artcam.Alert("project_RetrieveRingInfoFromAssembly: Assembly Undefined",0);
      return false;
   }

   if(assembly == null)
      return false;

   for (var props in this)
   {
      var label = "ringinfo_" + props;
      if(typeof(this[props]) == "string")
      {
         if(assembly.StringExists(label))
         {
            //alert("Found " + label);
            this[props] = assembly.GetString(label, "Unspecified");
         }
         
      }
      if(typeof(this[props]) == "number")
      {
         if(assembly.DoubleExists(label))
         {
            //alert("Found " + label);
            this[props] = assembly.GetDouble(label, 0);
         }
      }
   }
}

function project_StoreRingInfoInAssembly(assembly)
{
   if(typeof(assembly)=='undefined')
      return false;

   assembly.Name = this.name;
   
   for (var props in this)
   {
      var label = "ringinfo_" + props;
      if(typeof(this[props]) == "string")
      {
         assembly.SetString(label, this[props]);
      }
      if(typeof(this[props]) == "number")
      {
         //alert(label + " = " + this[props]);
         assembly.SetDouble(label, this[props]);
      }
   }
   assembly.UpdateAssemblyMonitor();
}

function project_WriteDiv(target_div, write_file_options)
{
  // Firstly we empty the target_div
  target_div.innerHTML = "";
     // Create an Array for keeping all the strings for our HTML that we will write.
  var hArr = new Array();

  var root = artcam.HtmlRootDir();
  var images_directory = root + "../../Custom/HTML/images/";
  hArr.push("<table>");
  hArr.push("<tr id='RingInfoIconRow'><td valign=top><img src='" + images_directory + "RingInfo.gif' width =30 height =30></td>");
  hArr.push("<td><table width='100%' border=0 cellspacing=0 id='RingInfoTable'>");
  hArr.push("<tr><td style='background-color:" + artcam.GetSystemColourShadeString(COLOR_BTNFACE,2,COLOR_BTNSHADOW,1) + "'");
  hArr.push("onclick='ToggleRingInfoDiv()'>");
  hArr.push("<img src='" + root + "../SharedImages/open_down_small_grey.gif' id=RingInfoImg align='right'>");
  hArr.push(gJobInformation);
  hArr.push(": <b><span id = 'RingInfo_HeadingSpan'></b></td></tr>");
  hArr.push("</table></td></tr>");
  hArr.push("<tr><td></td>");
  hArr.push("<td><table id=RingInfoDiv width='100%' border=0 cellspacing=0>");
  hArr.push("<col width = 60%> <col width = 40%>");
  hArr.push("<tr id=RingInfo_RingSizeRow><td colspan=2><b><span id = 'RingInfo_RingSizeSpan'></span></b></td></tr>");
  hArr.push("<tr id=RingInfo_RingDiameterRow><td>");
  hArr.push(gDiameter);
  hArr.push(":</td><td><span id = 'RingInfo_RingDiameterSpan'></span>");
  hArr.push(gMmUnit);
  hArr.push("</td></tr>");
  hArr.push("<tr id=RingInfo_RingRadiusRow><td>");
  hArr.push(gRadius);
  hArr.push(":</td><td><span id = 'RingInfo_RingRadiusSpan'></span>");
  hArr.push(gMmUnit);
  hArr.push("</td></tr>");
  hArr.push("<tr id=RingInfo_RingShankThicknessRow><td>");
  hArr.push(gThickness);
  hArr.push(":</td><td><span id = 'RingInfo_RingThicknessSpan'></span>");
  hArr.push(gMmUnit);
  hArr.push("</td></tr>");
  hArr.push("<tr id=RingInfo_JobLocationRow><td colspan=2>Location: <span id = 'RingInfo_JobLocationSpan'></span></td></tr>");
  if(write_file_options)
  {
     hArr.push("<tr id=RingInfo_FileIconsRow><td colspan=2>");
     
     hArr.push("<IMG class=tbButton height=32 src='" + images_directory + "NewJob.gif'");
     hArr.push("id=CreateNewJobButton toggle=0 width=32 button='CreateNewJob' tab='File'>");
     CreateNewJobButton.alt = gCreateNewProject;
     
     hArr.push("<IMG class=tbButton height=32 src='" + images_directory + "OpenJob.gif'"); 
     hArr.push("id=OpenJobButton toggle=0 width=32 button='OpenJob' tab='File'>");   
     OpenJobButton.alt = gOpenExistingProject;

     hArr.push("<IMG class=tbButton height=32 src='" + images_directory + "CloseJob.gif'"); 
     hArr.push("id=CloseJobButton toggle=0 width=32 button='CloseJob' tab='File'></td></tr>");
     CloseJobButton.alt = gCloseCurrentProject;
  }
  hArr.push("</table>");
  target_div.innerHTML = hArr.join("\n");
}

function project_RetrieveInfoFromFile(filepath)
{
   var file_browser = artcam.CreateFileSelector();
   var file_text = file_browser.ReadTextFile(filepath);
   if( file_text == "" )
      return false;

   // Loop through the lines of the text file and find the first line that contains a paf description using a regexp
   var lines = file_text.split("\n");
   var line;
   for(line in lines)
   {

      // . Match Any character
      // + 1 or more times
      // ? Match as little as possible
      // () Grab out to $1
      // \s Match any space character
      // * 0 or more times
      // = Match '=' character

      if( /^\s*(.+?)\s*=\s*(.+?)\s*$/.test( lines[line] ) )
      {
         switch(RegExp.$1)
         {
         case "diameter":
            this.diameter = parseFloat(RegExp.$2);
            break;
         case "shank_width":
            this.shank_width = parseFloat(RegExp.$2);
            break;
         case "shank_thickness":
            this.shank_thickness = parseFloat(RegExp.$2);
            break;
         case "resolution":
            this.resolution= parseInt(RegExp.$2);
            break;
         case "sizing_system":
            this.sizing_system = parseInt(RegExp.$2);
            break;
         case "size":
            this.size = parseInt(RegExp.$2);
            break;
         case "size_description":
            this.size_description = RegExp.$2;
            break;
         }
      }
   }
   // If we get here we didn't find a matching line
   return false;
}