function plugin_main()
{
   if(artcam.VectorSelection.Count!=4)
      return;

   var ring_designer = artcam.CreateRingDesigner();
   var vector_selection = artcam.VectorSelection.Selection;
   var vector_array = vector_selection.split(",");

   var temp_relief = artcam.CreateEmptyRelief();
   temp_relief.CopyFromCurrent();
   temp_relief.BaseHeight = 0;
   temp_relief.Reset();

   var sweep_info = artcam.CreateTwoRailSweepData();
   sweep_info.SetRail1(vector_array[0]);
   sweep_info.SetRail2(vector_array[1]);
   sweep_info.SetZModCurve(vector_array[3]);
   sweep_info.AddCrossSection(vector_array[2],0,0,0.3,0.3,true);
   var min_x= artcam.Relief.MinX;
   var max_x= artcam.Relief.MaxX;
   var min_y= artcam.Relief.MinY;
   var max_y= artcam.Relief.MaxY;
   var cen_y = (min_y + max_y) / 2.0;
   sweep_info.UseLinearZModulation(min_x, cen_y, max_x, cen_y);
   sweep_info.ZModCurveIsAbsolute = true;
   sweep_info.ZModCurveIsWrapped = true;

   artcam.TwoRailSweep(sweep_info, temp_relief);
   temp_relief.MergeHighestWithCurrent();

   var RingDesigner = artcam.CreateRingDesigner();
   RingDesigner.PatchSweepRoundingError();
}