//=============================================================================
//
// orderObject.js   |
//
//

//-----------------------------------------------------------------------------
// COPYRIGHT 2001 DELCAM PLC., BIRMINGHAM, ENGLAND. 
//-----------------------------------------------------------------------------
//
// History.
// Who When     What   
// --- -------- ---------------------------------------------------------------
// sap 20/02/03 Written
//-----------------------------------------------------------------------------


//=== Order ==============================================
//
// 
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sap 20/02/03 Written
//-----------------------------------------------------------------------

function Order
   (
   name,
   changed_callback 
   )
{
   // Assign Page Members
   this.name = name;

   this.doTextOrdering = false; 

   // Assign Functions
   this.writeDiv		         = Order_WriteDiv;
   this.initialise		      = Order_Initialise;
   this.onOrder_OnOff         = Order_OnOff;
   this.toggleHelp            = Order_ToggleHelp;
   this.DoTextOrdering        = Order_DoTextOrdering;


   this.updateParametersFromToolpath = Order_UpdateParametersFromToolpath;
   this.saveParametersToToolpath     = Order_SaveParametersToToolpath;

   // is there a callback ?
   if (changed_callback == null)
   {
      this.doCallback = false;
   }
   else
   {
      this.updateCallback = changed_callback
      this.doCallback = true;
   }

   // get path to the root of our html - we use this to build
   // addresses to our images
   this.image_dir = artcam.HtmlRootDir();
   this.image_dir += "..\\SharedImages\\Ramp\\";

}


//=== Order_WriteDiv ==============================================
//
// 
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sap 20/02/03 Written
//-----------------------------------------------------------------------

function Order_WriteDiv()
{
   // This is a bit like create. We write all our document objects into the page
   // then show and hide them as we wish.
   
   document.writeln("<table cellspacing=0 border=0 width=100%>");
   document.writeln("<tr><td height=2px></td></tr>");
   document.writeln("<tr><td bgcolor=buttonshadow></td></tr>");
   document.writeln("<tr><td bgcolor=buttonhighlight></td></tr>");
   document.writeln("<tr><td height=2px></td></tr>");

   // this is the not ramping div
   document.writeln("<tr><td>");
   document.writeln("   <INPUT type='checkbox' id='" + this.name + "do_textOrderingCheck' onClick='" + this.name + ".onOrder_OnOff()' name=start_check>");
   document.writeln("   <nobr><span><b>" + gsoPreserveTextOrder + "&nbsp;&nbsp;</b></span>");
   document.writeln("   </nobr>");
   document.writeln("   </td>");
   document.writeln("</tr>");   

   document.writeln("<tr HELPTAG style='display:none'>");
   document.writeln("   <td colspan=1>");
   document.writeln("      <div id='div" + this.name + "Help'>");
   document.writeln("      <p>" + gsoOrderHelpText);
   document.writeln("      <BR><BR>");
   document.writeln("      </div>");
   document.writeln("   </td>");
   document.writeln("</tr>");
   document.writeln("</table>");


}


//=== Order_Initialise ==============================================
//
// 
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sap 20/02/03 Written
//-----------------------------------------------------------------------

function Order_Initialise()
{
   // Create members attached to the objects in our Div on the page.
   // This is done by evaluating the name that we called it when we wrote it in writeDiv
   // Since the object has this global name the evaluation returns the object
   // which we store in our object for convenience.
   // A bit like do data exchange in CDialog!

   
   // Set up members for the data controls
   this.use_orderCheck	      = eval( this.name + "do_textOrderingCheck" );
   

   // write the terse description
   //this.writeDiv();

   this.orderHelpDiv   = eval( "div" + this.name + "Help" ); 

}


//=== Ramp_OnOff ==============================================
//
// 
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sap 20/02/03 Written
//-----------------------------------------------------------------------

function Order_OnOff()
{
   // work out which ones are to be displayed and which hidden
   if ( this.use_orderCheck.checked == true )
   {
   }
   else
   {
   }
}


//=== Ramp_UpdateParametersFromToolpath ==============================================
//
// 
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sap 20/02/03 Written
//-----------------------------------------------------------------------

function Order_UpdateParametersFromToolpath(toolpath)
{
   if (toolpath == null)
      return;
       
   this.use_orderCheck.checked    = toolpath.GetFlag('DoTextOrder',this.use_orderCheck.checked);
}


//=== Order_SaveParametersToToolpath ==============================================
//
// 
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sap 20/02/03 Written
//-----------------------------------------------------------------------

function Order_SaveParametersToToolpath(toolpath)
{
   if (toolpath == null)
      return;
       
   toolpath.SetFlag('DoTextOrder',this.use_orderCheck.checked);
}


//=== Order_ToggleHelp ==============================================
//
// 
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sap 20/02/03 Written
//-----------------------------------------------------------------------

function Order_ToggleHelp()
{
   ToggleVisibility(this.orderHelpDiv);
}


//=== Order_DoTextOrdering ==============================================
//
// 
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sap 20/02/03 Written
//-----------------------------------------------------------------------

function Order_DoTextOrdering()
{
   return this.use_orderCheck.checked;
}
