-- mysqldump-php https://github.com/ifsnop/mysqldump-php
--
-- Host: localhost	Database: unloadco
-- ------------------------------------------------------
-- Server version 	5.6.47-cll-lve
-- Date: Sun, 23 Feb 2020 05:37:54 +0000

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `apiv2_access_token`
--

DROP TABLE IF EXISTS `apiv2_access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `apiv2_access_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `access_token` varchar(128) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `date_last_used` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_token` (`access_token`),
  KEY `date_last_used` (`date_last_used`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `apiv2_access_token`
--

LOCK TABLES `apiv2_access_token` WRITE;
/*!40000 ALTER TABLE `apiv2_access_token` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `apiv2_access_token` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

--
-- Table structure for table `apiv2_api_key`
--

DROP TABLE IF EXISTS `apiv2_api_key`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `apiv2_api_key` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key_public` varchar(64) NOT NULL,
  `key_secret` varchar(64) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `keys_public_secret` (`key_public`,`key_secret`) USING BTREE,
  KEY `date_created` (`date_created`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `apiv2_api_key`
--

LOCK TABLES `apiv2_api_key` WRITE;
/*!40000 ALTER TABLE `apiv2_api_key` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `apiv2_api_key` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

--
-- Table structure for table `background_task`
--

DROP TABLE IF EXISTS `background_task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `background_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task` varchar(255) COLLATE utf8_bin NOT NULL,
  `last_update` datetime DEFAULT NULL,
  `status` enum('running','finished','not_run') COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `task` (`task`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `background_task`
--

LOCK TABLES `background_task` WRITE;
/*!40000 ALTER TABLE `background_task` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `background_task` VALUES (1,'auto_prune.cron.php',NULL,'not_run'),(3,'create_internal_notifications.cron.php',NULL,'not_run'),(4,'downgrade_accounts.cron.php',NULL,'not_run'),(5,'plugin_tasks.cron.php',NULL,'not_run'),(6,'delete_redundant_files.cron.php',NULL,'not_run'),(7,'create_email_notifications.cron.php',NULL,'not_run'),(8,'process_remote_file_downloads.cron.php','2018-05-11 00:07:01','finished');
/*!40000 ALTER TABLE `background_task` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

--
-- Table structure for table `background_task_log`
--

DROP TABLE IF EXISTS `background_task_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `background_task_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `status` enum('started','finished') COLLATE utf8_bin NOT NULL DEFAULT 'started',
  `server_name` varchar(255) COLLATE utf8_bin NOT NULL,
  `log_message` text COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`),
  KEY `task_id` (`task_id`),
  KEY `start_time` (`start_time`),
  KEY `end_time` (`end_time`),
  KEY `server_name` (`server_name`)
) ENGINE=MyISAM AUTO_INCREMENT=484431 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `background_task_log`
--

LOCK TABLES `background_task_log` WRITE;
/*!40000 ALTER TABLE `background_task_log` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `background_task_log` VALUES (1,8,'2017-05-27 21:45:01','2017-05-27 21:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2,8,'2017-05-27 21:46:01','2017-05-27 21:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3,8,'2017-05-27 21:47:01','2017-05-27 21:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4,8,'2017-05-27 21:48:01','2017-05-27 21:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5,8,'2017-05-27 21:49:01','2017-05-27 21:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6,8,'2017-05-27 21:50:01','2017-05-27 21:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7,8,'2017-05-27 21:51:01','2017-05-27 21:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8,8,'2017-05-27 21:52:01','2017-05-27 21:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9,8,'2017-05-27 21:53:02','2017-05-27 21:53:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(10,8,'2017-05-27 21:54:01','2017-05-27 21:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(11,8,'2017-05-27 21:55:01','2017-05-27 21:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(12,8,'2017-05-27 21:56:01','2017-05-27 21:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(13,8,'2017-05-27 21:57:01','2017-05-27 21:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(14,8,'2017-05-27 21:58:01','2017-05-27 21:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(15,8,'2017-05-27 21:59:01','2017-05-27 21:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(16,8,'2017-05-27 22:00:01','2017-05-27 22:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(17,8,'2017-05-27 22:01:01','2017-05-27 22:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(18,8,'2017-05-27 22:02:01','2017-05-27 22:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(19,8,'2017-05-27 22:03:01','2017-05-27 22:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(20,8,'2017-05-27 22:04:01','2017-05-27 22:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(21,8,'2017-05-27 22:05:01','2017-05-27 22:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(22,8,'2017-05-27 22:06:01','2017-05-27 22:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(23,8,'2017-05-27 22:07:01','2017-05-27 22:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(24,8,'2017-05-27 22:08:01','2017-05-27 22:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(25,8,'2017-05-27 22:09:01','2017-05-27 22:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(26,8,'2017-05-27 22:10:02','2017-05-27 22:10:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(27,8,'2017-05-27 22:11:01','2017-05-27 22:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(28,8,'2017-05-27 22:12:01','2017-05-27 22:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(29,8,'2017-05-27 22:13:01','2017-05-27 22:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(30,8,'2017-05-27 22:14:01','2017-05-27 22:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(31,8,'2017-05-27 22:15:01','2017-05-27 22:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(32,8,'2017-05-27 22:16:01','2017-05-27 22:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(33,8,'2017-05-27 22:17:01','2017-05-27 22:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(34,8,'2017-05-27 22:18:01','2017-05-27 22:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(35,8,'2017-05-27 22:19:01','2017-05-27 22:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(36,8,'2017-05-27 22:20:01','2017-05-27 22:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(37,8,'2017-05-27 22:21:01','2017-05-27 22:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(38,8,'2017-05-27 22:22:01','2017-05-27 22:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(39,8,'2017-05-27 22:23:01','2017-05-27 22:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(40,8,'2017-05-27 22:24:01','2017-05-27 22:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(41,8,'2017-05-27 22:25:01','2017-05-27 22:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(42,8,'2017-05-27 22:26:01','2017-05-27 22:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(43,8,'2017-05-27 22:27:01','2017-05-27 22:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(44,8,'2017-05-27 22:28:01','2017-05-27 22:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(45,8,'2017-05-27 22:29:01','2017-05-27 22:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(46,8,'2017-05-27 22:30:01','2017-05-27 22:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(47,8,'2017-05-27 22:31:01','2017-05-27 22:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(48,8,'2017-05-27 22:32:01','2017-05-27 22:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(49,8,'2017-05-27 22:33:01','2017-05-27 22:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(50,8,'2017-05-27 22:34:01','2017-05-27 22:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(51,8,'2017-05-27 22:35:01','2017-05-27 22:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(52,8,'2017-05-27 22:36:01','2017-05-27 22:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(53,8,'2017-05-27 22:37:01','2017-05-27 22:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(54,8,'2017-05-27 22:38:01','2017-05-27 22:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(55,8,'2017-05-27 22:39:01','2017-05-27 22:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(56,8,'2017-05-27 22:40:01','2017-05-27 22:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(57,8,'2017-05-27 22:41:01','2017-05-27 22:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(58,8,'2017-05-27 22:42:01','2017-05-27 22:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(59,8,'2017-05-27 22:43:01','2017-05-27 22:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(60,8,'2017-05-27 22:44:01','2017-05-27 22:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(61,8,'2017-05-27 22:45:01','2017-05-27 22:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(62,8,'2017-05-27 22:46:01','2017-05-27 22:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(63,8,'2017-05-27 22:47:01','2017-05-27 22:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(64,8,'2017-05-27 22:48:02','2017-05-27 22:48:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(65,8,'2017-05-27 22:49:01','2017-05-27 22:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(66,8,'2017-05-27 22:50:01','2017-05-27 22:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(67,8,'2017-05-27 22:51:01','2017-05-27 22:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(68,8,'2017-05-27 22:52:01','2017-05-27 22:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(69,8,'2017-05-27 22:53:02','2017-05-27 22:53:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(70,8,'2017-05-27 22:54:01','2017-05-27 22:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(71,8,'2017-05-27 22:55:01','2017-05-27 22:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(72,8,'2017-05-27 22:56:01','2017-05-27 22:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(73,8,'2017-05-27 22:57:02','2017-05-27 22:57:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(74,8,'2017-05-27 22:58:01','2017-05-27 22:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(75,8,'2017-05-27 22:59:01','2017-05-27 22:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(76,8,'2017-05-27 23:00:01','2017-05-27 23:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(77,8,'2017-05-27 23:01:01','2017-05-27 23:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(78,8,'2017-05-27 23:02:01','2017-05-27 23:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(79,8,'2017-05-27 23:03:01','2017-05-27 23:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(80,8,'2017-05-27 23:04:01','2017-05-27 23:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(81,8,'2017-05-27 23:05:01','2017-05-27 23:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(82,8,'2017-05-27 23:06:01','2017-05-27 23:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(83,8,'2017-05-27 23:07:02','2017-05-27 23:07:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(84,8,'2017-05-27 23:08:01','2017-05-27 23:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(85,8,'2017-05-27 23:09:01','2017-05-27 23:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(86,8,'2017-05-27 23:10:01','2017-05-27 23:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(87,8,'2017-05-27 23:11:01','2017-05-27 23:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(88,8,'2017-05-27 23:12:01','2017-05-27 23:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(89,8,'2017-05-27 23:13:02','2017-05-27 23:13:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(90,8,'2017-05-27 23:14:01','2017-05-27 23:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(91,8,'2017-05-27 23:15:01','2017-05-27 23:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(92,8,'2017-05-27 23:16:01','2017-05-27 23:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(93,8,'2017-05-27 23:17:01','2017-05-27 23:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(94,8,'2017-05-27 23:18:06','2017-05-27 23:18:06','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(95,8,'2017-05-27 23:19:02','2017-05-27 23:19:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(96,8,'2017-05-27 23:20:01','2017-05-27 23:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(97,8,'2017-05-27 23:21:02','2017-05-27 23:21:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(98,8,'2017-05-27 23:22:01','2017-05-27 23:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(99,8,'2017-05-27 23:23:01','2017-05-27 23:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(100,8,'2017-05-27 23:24:01','2017-05-27 23:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(101,8,'2017-05-27 23:25:01','2017-05-27 23:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(102,8,'2017-05-27 23:26:01','2017-05-27 23:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(103,8,'2017-05-27 23:27:01','2017-05-27 23:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(104,8,'2017-05-27 23:28:01','2017-05-27 23:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(105,8,'2017-05-27 23:29:01','2017-05-27 23:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(106,8,'2017-05-27 23:30:01','2017-05-27 23:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(107,8,'2017-05-27 23:31:01','2017-05-27 23:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(108,8,'2017-05-27 23:32:01','2017-05-27 23:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(109,8,'2017-05-27 23:33:01','2017-05-27 23:33:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(110,8,'2017-05-27 23:34:01','2017-05-27 23:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(111,8,'2017-05-27 23:35:01','2017-05-27 23:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(112,8,'2017-05-27 23:36:01','2017-05-27 23:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(113,8,'2017-05-27 23:37:02','2017-05-27 23:37:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(114,8,'2017-05-27 23:38:01','2017-05-27 23:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(115,8,'2017-05-27 23:39:01','2017-05-27 23:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(116,8,'2017-05-27 23:40:01','2017-05-27 23:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(117,8,'2017-05-27 23:41:02','2017-05-27 23:41:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(118,8,'2017-05-27 23:42:01','2017-05-27 23:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(119,8,'2017-05-27 23:43:01','2017-05-27 23:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(120,8,'2017-05-27 23:44:01','2017-05-27 23:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(121,8,'2017-05-27 23:45:01','2017-05-27 23:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(122,8,'2017-05-27 23:46:01','2017-05-27 23:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(123,8,'2017-05-27 23:47:01','2017-05-27 23:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(124,8,'2017-05-27 23:48:02','2017-05-27 23:48:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(125,8,'2017-05-27 23:49:01','2017-05-27 23:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(126,8,'2017-05-27 23:50:01','2017-05-27 23:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(127,8,'2017-05-27 23:51:01','2017-05-27 23:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(128,8,'2017-05-27 23:52:01','2017-05-27 23:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(129,8,'2017-05-27 23:53:01','2017-05-27 23:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(130,8,'2017-05-27 23:54:01','2017-05-27 23:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(131,8,'2017-05-27 23:55:01','2017-05-27 23:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(132,8,'2017-05-27 23:56:01','2017-05-27 23:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(133,8,'2017-05-27 23:57:01','2017-05-27 23:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(134,8,'2017-05-27 23:58:01','2017-05-27 23:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(135,8,'2017-05-27 23:59:01','2017-05-27 23:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(136,8,'2017-05-28 00:00:01','2017-05-28 00:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(137,8,'2017-05-28 00:01:02','2017-05-28 00:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(138,8,'2017-05-28 00:02:01','2017-05-28 00:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(139,8,'2017-05-28 00:03:01','2017-05-28 00:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(140,8,'2017-05-28 00:04:01','2017-05-28 00:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(141,8,'2017-05-28 00:05:02','2017-05-28 00:05:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(142,8,'2017-05-28 00:06:01','2017-05-28 00:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(143,8,'2017-05-28 00:07:01','2017-05-28 00:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(144,8,'2017-05-28 00:08:01','2017-05-28 00:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(145,8,'2017-05-28 00:09:01','2017-05-28 00:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(146,8,'2017-05-28 00:10:01','2017-05-28 00:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(147,8,'2017-05-28 00:11:01','2017-05-28 00:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(148,8,'2017-05-28 00:12:01','2017-05-28 00:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(149,8,'2017-05-28 00:13:01','2017-05-28 00:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(150,8,'2017-05-28 00:14:01','2017-05-28 00:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(151,8,'2017-05-28 00:15:01','2017-05-28 00:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(152,8,'2017-05-28 00:16:01','2017-05-28 00:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(153,8,'2017-05-28 00:17:01','2017-05-28 00:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(154,8,'2017-05-28 00:18:01','2017-05-28 00:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(155,8,'2017-05-28 00:19:01','2017-05-28 00:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(156,8,'2017-05-28 00:20:01','2017-05-28 00:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(157,8,'2017-05-28 00:21:01','2017-05-28 00:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(158,8,'2017-05-28 00:22:01','2017-05-28 00:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(159,8,'2017-05-28 00:23:01','2017-05-28 00:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(160,8,'2017-05-28 00:24:01','2017-05-28 00:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(161,8,'2017-05-28 00:25:01','2017-05-28 00:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(162,8,'2017-05-28 00:26:01','2017-05-28 00:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(163,8,'2017-05-28 00:27:02','2017-05-28 00:27:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(164,8,'2017-05-28 00:28:01','2017-05-28 00:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(165,8,'2017-05-28 00:29:01','2017-05-28 00:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(166,8,'2017-05-28 00:30:02','2017-05-28 00:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(167,8,'2017-05-28 00:31:01','2017-05-28 00:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(168,8,'2017-05-28 00:32:02','2017-05-28 00:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(169,8,'2017-05-28 00:33:01','2017-05-28 00:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(170,8,'2017-05-28 00:34:01','2017-05-28 00:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(171,8,'2017-05-28 00:35:01','2017-05-28 00:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(172,8,'2017-05-28 00:36:01','2017-05-28 00:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(173,8,'2017-05-28 00:37:01','2017-05-28 00:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(174,8,'2017-05-28 00:38:01','2017-05-28 00:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(175,8,'2017-05-28 00:39:01','2017-05-28 00:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(176,8,'2017-05-28 00:40:01','2017-05-28 00:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(177,8,'2017-05-28 00:41:01','2017-05-28 00:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(178,8,'2017-05-28 00:42:02','2017-05-28 00:42:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(179,8,'2017-05-28 00:43:01','2017-05-28 00:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(180,8,'2017-05-28 00:44:01','2017-05-28 00:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(181,8,'2017-05-28 00:45:01','2017-05-28 00:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(182,8,'2017-05-28 00:46:01','2017-05-28 00:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(183,8,'2017-05-28 00:47:01','2017-05-28 00:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(184,8,'2017-05-28 00:48:01','2017-05-28 00:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(185,8,'2017-05-28 00:49:01','2017-05-28 00:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(186,8,'2017-05-28 00:50:01','2017-05-28 00:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(187,8,'2017-05-28 00:51:01','2017-05-28 00:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(188,8,'2017-05-28 00:52:01','2017-05-28 00:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(189,8,'2017-05-28 00:53:01','2017-05-28 00:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(190,8,'2017-05-28 00:54:01','2017-05-28 00:54:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(191,8,'2017-05-28 00:55:01','2017-05-28 00:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(192,8,'2017-05-28 00:56:01','2017-05-28 00:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(193,8,'2017-05-28 00:57:01','2017-05-28 00:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(194,8,'2017-05-28 00:58:01','2017-05-28 00:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(195,8,'2017-05-28 00:59:01','2017-05-28 00:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(196,8,'2017-05-28 01:00:01','2017-05-28 01:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(197,8,'2017-05-28 01:01:01','2017-05-28 01:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(198,8,'2017-05-28 01:02:02','2017-05-28 01:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(199,8,'2017-05-28 01:03:01','2017-05-28 01:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(200,8,'2017-05-28 01:04:01','2017-05-28 01:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(201,8,'2017-05-28 01:05:01','2017-05-28 01:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(202,8,'2017-05-28 01:06:01','2017-05-28 01:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(203,8,'2017-05-28 01:07:02','2017-05-28 01:07:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(204,8,'2017-05-28 01:08:01','2017-05-28 01:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(205,8,'2017-05-28 01:09:01','2017-05-28 01:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(206,8,'2017-05-28 01:10:01','2017-05-28 01:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(207,8,'2017-05-28 01:11:01','2017-05-28 01:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(208,8,'2017-05-28 01:12:01','2017-05-28 01:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(209,8,'2017-05-28 01:13:01','2017-05-28 01:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(210,8,'2017-05-28 01:14:01','2017-05-28 01:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(211,8,'2017-05-28 01:15:01','2017-05-28 01:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(212,8,'2017-05-28 01:16:01','2017-05-28 01:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(213,8,'2017-05-28 01:17:01','2017-05-28 01:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(214,8,'2017-05-28 01:18:01','2017-05-28 01:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(215,8,'2017-05-28 01:19:01','2017-05-28 01:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(216,8,'2017-05-28 01:20:01','2017-05-28 01:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(217,8,'2017-05-28 01:21:01','2017-05-28 01:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(218,8,'2017-05-28 01:22:01','2017-05-28 01:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(219,8,'2017-05-28 01:23:01','2017-05-28 01:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(220,8,'2017-05-28 01:24:01','2017-05-28 01:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(221,8,'2017-05-28 01:25:01','2017-05-28 01:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(222,8,'2017-05-28 01:26:01','2017-05-28 01:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(223,8,'2017-05-28 01:27:01','2017-05-28 01:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(224,8,'2017-05-28 01:28:01','2017-05-28 01:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(225,8,'2017-05-28 01:29:01','2017-05-28 01:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(226,8,'2017-05-28 01:30:01','2017-05-28 01:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(227,8,'2017-05-28 01:31:01','2017-05-28 01:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(228,8,'2017-05-28 01:32:01','2017-05-28 01:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(229,8,'2017-05-28 01:33:01','2017-05-28 01:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(230,8,'2017-05-28 01:34:01','2017-05-28 01:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(231,8,'2017-05-28 01:35:01','2017-05-28 01:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(232,8,'2017-05-28 01:36:01','2017-05-28 01:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(233,8,'2017-05-28 01:37:01','2017-05-28 01:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(234,8,'2017-05-28 01:38:01','2017-05-28 01:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(235,8,'2017-05-28 01:39:01','2017-05-28 01:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(236,8,'2017-05-28 01:40:01','2017-05-28 01:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(237,8,'2017-05-28 01:41:01','2017-05-28 01:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(238,8,'2017-05-28 01:42:01','2017-05-28 01:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(239,8,'2017-05-28 01:43:01','2017-05-28 01:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(240,8,'2017-05-28 01:44:01','2017-05-28 01:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(241,8,'2017-05-28 01:45:01','2017-05-28 01:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(242,8,'2017-05-28 01:46:01','2017-05-28 01:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(243,8,'2017-05-28 01:47:01','2017-05-28 01:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(244,8,'2017-05-28 01:48:01','2017-05-28 01:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(245,8,'2017-05-28 01:49:02','2017-05-28 01:49:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(246,8,'2017-05-28 01:50:01','2017-05-28 01:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(247,8,'2017-05-28 01:51:01','2017-05-28 01:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(248,8,'2017-05-28 01:52:01','2017-05-28 01:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(249,8,'2017-05-28 01:53:01','2017-05-28 01:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(250,8,'2017-05-28 01:54:01','2017-05-28 01:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(251,8,'2017-05-28 01:55:01','2017-05-28 01:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(252,8,'2017-05-28 01:56:01','2017-05-28 01:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(253,8,'2017-05-28 01:57:01','2017-05-28 01:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(254,8,'2017-05-28 01:58:01','2017-05-28 01:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(255,8,'2017-05-28 01:59:01','2017-05-28 01:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(256,8,'2017-05-28 02:00:01','2017-05-28 02:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(257,8,'2017-05-28 02:01:01','2017-05-28 02:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(258,8,'2017-05-28 02:02:01','2017-05-28 02:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(259,8,'2017-05-28 02:03:01','2017-05-28 02:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(260,8,'2017-05-28 02:04:01','2017-05-28 02:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(261,8,'2017-05-28 02:05:01','2017-05-28 02:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(262,8,'2017-05-28 02:06:01','2017-05-28 02:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(263,8,'2017-05-28 02:07:01','2017-05-28 02:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(264,8,'2017-05-28 02:08:01','2017-05-28 02:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(265,8,'2017-05-28 02:09:01','2017-05-28 02:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(266,8,'2017-05-28 02:10:01','2017-05-28 02:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(267,8,'2017-05-28 02:11:01','2017-05-28 02:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(268,8,'2017-05-28 02:12:01','2017-05-28 02:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(269,8,'2017-05-28 02:13:01','2017-05-28 02:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(270,8,'2017-05-28 02:14:01','2017-05-28 02:14:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(271,8,'2017-05-28 02:15:01','2017-05-28 02:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(272,8,'2017-05-28 02:16:01','2017-05-28 02:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(273,8,'2017-05-28 02:17:01','2017-05-28 02:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(274,8,'2017-05-28 02:18:01','2017-05-28 02:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(275,8,'2017-05-28 02:19:01','2017-05-28 02:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(276,8,'2017-05-28 02:20:01','2017-05-28 02:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(277,8,'2017-05-28 02:21:01','2017-05-28 02:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(278,8,'2017-05-28 02:22:01','2017-05-28 02:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(279,8,'2017-05-28 02:23:01','2017-05-28 02:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(280,8,'2017-05-28 02:24:01','2017-05-28 02:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(281,8,'2017-05-28 02:25:01','2017-05-28 02:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(282,8,'2017-05-28 02:26:01','2017-05-28 02:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(283,8,'2017-05-28 02:27:01','2017-05-28 02:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(284,8,'2017-05-28 02:28:01','2017-05-28 02:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(285,8,'2017-05-28 02:29:01','2017-05-28 02:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(286,8,'2017-05-28 02:30:01','2017-05-28 02:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(287,8,'2017-05-28 02:31:01','2017-05-28 02:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(288,8,'2017-05-28 02:32:01','2017-05-28 02:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(289,8,'2017-05-28 02:33:01','2017-05-28 02:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(290,8,'2017-05-28 02:34:01','2017-05-28 02:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(291,8,'2017-05-28 02:35:01','2017-05-28 02:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(292,8,'2017-05-28 02:36:01','2017-05-28 02:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(293,8,'2017-05-28 02:37:01','2017-05-28 02:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(294,8,'2017-05-28 02:38:01','2017-05-28 02:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(295,8,'2017-05-28 02:39:01','2017-05-28 02:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(296,8,'2017-05-28 02:40:01','2017-05-28 02:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(297,8,'2017-05-28 02:41:01','2017-05-28 02:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(298,8,'2017-05-28 02:42:01','2017-05-28 02:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(299,8,'2017-05-28 02:43:02','2017-05-28 02:43:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(300,8,'2017-05-28 02:44:01','2017-05-28 02:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(301,8,'2017-05-28 02:45:01','2017-05-28 02:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(302,8,'2017-05-28 02:46:01','2017-05-28 02:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(303,8,'2017-05-28 02:47:01','2017-05-28 02:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(304,8,'2017-05-28 02:48:01','2017-05-28 02:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(305,8,'2017-05-28 02:49:02','2017-05-28 02:49:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(306,8,'2017-05-28 02:50:01','2017-05-28 02:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(307,8,'2017-05-28 02:51:01','2017-05-28 02:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(308,8,'2017-05-28 02:52:01','2017-05-28 02:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(309,8,'2017-05-28 02:53:01','2017-05-28 02:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(310,8,'2017-05-28 02:54:01','2017-05-28 02:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(311,8,'2017-05-28 02:55:01','2017-05-28 02:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(312,8,'2017-05-28 02:56:01','2017-05-28 02:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(313,8,'2017-05-28 02:57:01','2017-05-28 02:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(314,8,'2017-05-28 02:58:02','2017-05-28 02:58:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(315,8,'2017-05-28 02:59:01','2017-05-28 02:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(316,8,'2017-05-28 03:00:01','2017-05-28 03:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(317,8,'2017-05-28 03:01:01','2017-05-28 03:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(318,8,'2017-05-28 03:02:02','2017-05-28 03:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(319,8,'2017-05-28 03:03:01','2017-05-28 03:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(320,8,'2017-05-28 03:04:01','2017-05-28 03:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(321,8,'2017-05-28 03:05:01','2017-05-28 03:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(322,8,'2017-05-28 03:06:01','2017-05-28 03:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(323,8,'2017-05-28 03:07:01','2017-05-28 03:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(324,8,'2017-05-28 03:08:01','2017-05-28 03:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(325,8,'2017-05-28 03:09:01','2017-05-28 03:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(326,8,'2017-05-28 03:10:01','2017-05-28 03:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(327,8,'2017-05-28 03:11:01','2017-05-28 03:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(328,8,'2017-05-28 03:12:01','2017-05-28 03:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(329,8,'2017-05-28 03:13:01','2017-05-28 03:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(330,8,'2017-05-28 03:14:01','2017-05-28 03:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(331,8,'2017-05-28 03:15:01','2017-05-28 03:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(332,8,'2017-05-28 03:16:01','2017-05-28 03:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(333,8,'2017-05-28 03:17:01','2017-05-28 03:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(334,8,'2017-05-28 03:18:01','2017-05-28 03:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(335,8,'2017-05-28 03:19:01','2017-05-28 03:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(336,8,'2017-05-28 03:20:01','2017-05-28 03:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(337,8,'2017-05-28 03:21:01','2017-05-28 03:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(338,8,'2017-05-28 03:22:01','2017-05-28 03:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(339,8,'2017-05-28 03:23:01','2017-05-28 03:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(340,8,'2017-05-28 03:24:01','2017-05-28 03:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(341,8,'2017-05-28 03:25:01','2017-05-28 03:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(342,8,'2017-05-28 03:26:01','2017-05-28 03:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(343,8,'2017-05-28 03:27:01','2017-05-28 03:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(344,8,'2017-05-28 03:28:01','2017-05-28 03:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(345,8,'2017-05-28 03:29:01','2017-05-28 03:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(346,8,'2017-05-28 03:30:01','2017-05-28 03:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(347,8,'2017-05-28 03:31:01','2017-05-28 03:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(348,8,'2017-05-28 03:32:01','2017-05-28 03:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(349,8,'2017-05-28 03:33:01','2017-05-28 03:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(350,8,'2017-05-28 03:34:01','2017-05-28 03:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(351,8,'2017-05-28 03:35:01','2017-05-28 03:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(352,8,'2017-05-28 03:36:01','2017-05-28 03:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(353,8,'2017-05-28 03:37:01','2017-05-28 03:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(354,8,'2017-05-28 03:38:01','2017-05-28 03:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(355,8,'2017-05-28 03:39:01','2017-05-28 03:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(356,8,'2017-05-28 03:40:01','2017-05-28 03:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(357,8,'2017-05-28 03:41:01','2017-05-28 03:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(358,8,'2017-05-28 03:42:01','2017-05-28 03:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(359,8,'2017-05-28 03:43:01','2017-05-28 03:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(360,8,'2017-05-28 03:44:01','2017-05-28 03:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(361,8,'2017-05-28 03:45:01','2017-05-28 03:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(362,8,'2017-05-28 03:46:01','2017-05-28 03:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(363,8,'2017-05-28 03:47:02','2017-05-28 03:47:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(364,8,'2017-05-28 03:48:01','2017-05-28 03:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(365,8,'2017-05-28 03:49:01','2017-05-28 03:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(366,8,'2017-05-28 03:50:01','2017-05-28 03:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(367,8,'2017-05-28 03:51:01','2017-05-28 03:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(368,8,'2017-05-28 03:52:01','2017-05-28 03:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(369,8,'2017-05-28 03:53:02','2017-05-28 03:53:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(370,8,'2017-05-28 03:54:01','2017-05-28 03:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(371,8,'2017-05-28 03:55:01','2017-05-28 03:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(372,8,'2017-05-28 03:56:01','2017-05-28 03:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(373,8,'2017-05-28 03:57:01','2017-05-28 03:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(374,8,'2017-05-28 03:58:01','2017-05-28 03:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(375,8,'2017-05-28 03:59:01','2017-05-28 03:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(376,8,'2017-05-28 04:00:01','2017-05-28 04:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(377,8,'2017-05-28 04:01:01','2017-05-28 04:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(378,8,'2017-05-28 04:02:01','2017-05-28 04:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(379,8,'2017-05-28 04:03:01','2017-05-28 04:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(380,8,'2017-05-28 04:04:01','2017-05-28 04:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(381,8,'2017-05-28 04:05:01','2017-05-28 04:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(382,8,'2017-05-28 04:06:01','2017-05-28 04:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(383,8,'2017-05-28 04:07:01','2017-05-28 04:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(384,8,'2017-05-28 04:08:01','2017-05-28 04:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(385,8,'2017-05-28 04:09:01','2017-05-28 04:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(386,8,'2017-05-28 04:10:01','2017-05-28 04:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(387,8,'2017-05-28 04:11:02','2017-05-28 04:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(388,8,'2017-05-28 04:12:01','2017-05-28 04:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(389,8,'2017-05-28 04:13:01','2017-05-28 04:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(390,8,'2017-05-28 04:14:01','2017-05-28 04:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(391,8,'2017-05-28 04:15:01','2017-05-28 04:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(392,8,'2017-05-28 04:16:01','2017-05-28 04:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(393,8,'2017-05-28 04:17:01','2017-05-28 04:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(394,8,'2017-05-28 04:18:01','2017-05-28 04:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(395,8,'2017-05-28 04:19:01','2017-05-28 04:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(396,8,'2017-05-28 04:20:01','2017-05-28 04:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(397,8,'2017-05-28 04:21:01','2017-05-28 04:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(398,8,'2017-05-28 04:22:01','2017-05-28 04:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(399,8,'2017-05-28 04:23:01','2017-05-28 04:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(400,8,'2017-05-28 04:24:01','2017-05-28 04:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(401,8,'2017-05-28 04:25:01','2017-05-28 04:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(402,8,'2017-05-28 04:26:01','2017-05-28 04:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(403,8,'2017-05-28 04:27:01','2017-05-28 04:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(404,8,'2017-05-28 04:28:01','2017-05-28 04:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(405,8,'2017-05-28 04:29:01','2017-05-28 04:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(406,8,'2017-05-28 04:30:01','2017-05-28 04:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(407,8,'2017-05-28 04:31:01','2017-05-28 04:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(408,8,'2017-05-28 04:32:01','2017-05-28 04:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(409,8,'2017-05-28 04:33:01','2017-05-28 04:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(410,8,'2017-05-28 04:34:01','2017-05-28 04:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(411,8,'2017-05-28 04:35:01','2017-05-28 04:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(412,8,'2017-05-28 04:36:02','2017-05-28 04:36:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(413,8,'2017-05-28 04:37:01','2017-05-28 04:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(414,8,'2017-05-28 04:38:01','2017-05-28 04:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(415,8,'2017-05-28 04:39:01','2017-05-28 04:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(416,8,'2017-05-28 04:40:01','2017-05-28 04:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(417,8,'2017-05-28 04:41:01','2017-05-28 04:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(418,8,'2017-05-28 04:42:01','2017-05-28 04:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(419,8,'2017-05-28 04:43:01','2017-05-28 04:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(420,8,'2017-05-28 04:44:01','2017-05-28 04:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(421,8,'2017-05-28 04:45:01','2017-05-28 04:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(422,8,'2017-05-28 04:46:01','2017-05-28 04:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(423,8,'2017-05-28 04:47:01','2017-05-28 04:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(424,8,'2017-05-28 04:48:01','2017-05-28 04:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(425,8,'2017-05-28 04:49:01','2017-05-28 04:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(426,8,'2017-05-28 04:50:02','2017-05-28 04:50:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(427,8,'2017-05-28 04:51:01','2017-05-28 04:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(428,8,'2017-05-28 04:52:01','2017-05-28 04:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(429,8,'2017-05-28 04:53:01','2017-05-28 04:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(430,8,'2017-05-28 04:54:01','2017-05-28 04:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(431,8,'2017-05-28 04:55:01','2017-05-28 04:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(432,8,'2017-05-28 04:56:02','2017-05-28 04:56:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(433,8,'2017-05-28 04:57:01','2017-05-28 04:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(434,8,'2017-05-28 04:58:01','2017-05-28 04:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(435,8,'2017-05-28 04:59:01','2017-05-28 04:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(436,8,'2017-05-28 05:00:01','2017-05-28 05:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(437,8,'2017-05-28 05:01:01','2017-05-28 05:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(438,8,'2017-05-28 05:02:01','2017-05-28 05:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(439,8,'2017-05-28 05:03:01','2017-05-28 05:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(440,8,'2017-05-28 05:04:02','2017-05-28 05:04:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(441,8,'2017-05-28 05:05:01','2017-05-28 05:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(442,8,'2017-05-28 05:06:01','2017-05-28 05:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(443,8,'2017-05-28 05:07:01','2017-05-28 05:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(444,8,'2017-05-28 05:08:01','2017-05-28 05:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(445,8,'2017-05-28 05:09:02','2017-05-28 05:09:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(446,8,'2017-05-28 05:10:01','2017-05-28 05:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(447,8,'2017-05-28 05:11:01','2017-05-28 05:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(448,8,'2017-05-28 05:12:01','2017-05-28 05:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(449,8,'2017-05-28 05:13:01','2017-05-28 05:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(450,8,'2017-05-28 05:14:01','2017-05-28 05:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(451,8,'2017-05-28 05:15:02','2017-05-28 05:15:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(452,8,'2017-05-28 05:16:01','2017-05-28 05:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(453,8,'2017-05-28 05:17:01','2017-05-28 05:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(454,8,'2017-05-28 05:18:01','2017-05-28 05:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(455,8,'2017-05-28 05:19:01','2017-05-28 05:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(456,8,'2017-05-28 05:20:01','2017-05-28 05:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(457,8,'2017-05-28 05:21:01','2017-05-28 05:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(458,8,'2017-05-28 05:22:01','2017-05-28 05:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(459,8,'2017-05-28 05:23:01','2017-05-28 05:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(460,8,'2017-05-28 05:24:01','2017-05-28 05:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(461,8,'2017-05-28 05:25:01','2017-05-28 05:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(462,8,'2017-05-28 05:26:01','2017-05-28 05:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(463,8,'2017-05-28 05:27:01','2017-05-28 05:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(464,8,'2017-05-28 05:28:01','2017-05-28 05:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(465,8,'2017-05-28 05:29:01','2017-05-28 05:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(466,8,'2017-05-28 05:30:01','2017-05-28 05:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(467,8,'2017-05-28 05:31:01','2017-05-28 05:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(468,8,'2017-05-28 05:32:02','2017-05-28 05:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(469,8,'2017-05-28 05:33:01','2017-05-28 05:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(470,8,'2017-05-28 05:34:01','2017-05-28 05:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(471,8,'2017-05-28 05:35:01','2017-05-28 05:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(472,8,'2017-05-28 05:36:01','2017-05-28 05:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(473,8,'2017-05-28 05:37:01','2017-05-28 05:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(474,8,'2017-05-28 05:38:01','2017-05-28 05:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(475,8,'2017-05-28 05:39:01','2017-05-28 05:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(476,8,'2017-05-28 05:40:01','2017-05-28 05:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(477,8,'2017-05-28 05:41:01','2017-05-28 05:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(478,8,'2017-05-28 05:42:01','2017-05-28 05:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(479,8,'2017-05-28 05:43:01','2017-05-28 05:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(480,8,'2017-05-28 05:44:01','2017-05-28 05:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(481,8,'2017-05-28 05:45:01','2017-05-28 05:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(482,8,'2017-05-28 05:46:01','2017-05-28 05:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(483,8,'2017-05-28 05:47:02','2017-05-28 05:47:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(484,8,'2017-05-28 05:48:01','2017-05-28 05:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(485,8,'2017-05-28 05:49:01','2017-05-28 05:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(486,8,'2017-05-28 05:50:01','2017-05-28 05:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(487,8,'2017-05-28 05:51:01','2017-05-28 05:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(488,8,'2017-05-28 05:52:02','2017-05-28 05:52:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(489,8,'2017-05-28 05:53:01','2017-05-28 05:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(490,8,'2017-05-28 05:54:01','2017-05-28 05:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(491,8,'2017-05-28 05:55:01','2017-05-28 05:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(492,8,'2017-05-28 05:56:01','2017-05-28 05:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(493,8,'2017-05-28 05:57:01','2017-05-28 05:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(494,8,'2017-05-28 05:58:01','2017-05-28 05:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(495,8,'2017-05-28 05:59:01','2017-05-28 05:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(496,8,'2017-05-28 06:00:01','2017-05-28 06:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(497,8,'2017-05-28 06:01:01','2017-05-28 06:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(498,8,'2017-05-28 06:02:01','2017-05-28 06:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(499,8,'2017-05-28 06:03:01','2017-05-28 06:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(500,8,'2017-05-28 06:04:01','2017-05-28 06:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(501,8,'2017-05-28 06:05:01','2017-05-28 06:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(502,8,'2017-05-28 06:06:01','2017-05-28 06:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(503,8,'2017-05-28 06:07:02','2017-05-28 06:07:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(504,8,'2017-05-28 06:08:01','2017-05-28 06:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(505,8,'2017-05-28 06:09:01','2017-05-28 06:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(506,8,'2017-05-28 06:10:01','2017-05-28 06:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(507,8,'2017-05-28 06:11:01','2017-05-28 06:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(508,8,'2017-05-28 06:12:01','2017-05-28 06:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(509,8,'2017-05-28 06:13:01','2017-05-28 06:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(510,8,'2017-05-28 06:14:01','2017-05-28 06:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(511,8,'2017-05-28 06:15:01','2017-05-28 06:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(512,8,'2017-05-28 06:16:01','2017-05-28 06:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(513,8,'2017-05-28 06:17:01','2017-05-28 06:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(514,8,'2017-05-28 06:18:01','2017-05-28 06:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(515,8,'2017-05-28 06:19:01','2017-05-28 06:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(516,8,'2017-05-28 06:20:01','2017-05-28 06:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(517,8,'2017-05-28 06:21:01','2017-05-28 06:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(518,8,'2017-05-28 06:22:01','2017-05-28 06:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(519,8,'2017-05-28 06:23:02','2017-05-28 06:23:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(520,8,'2017-05-28 06:24:01','2017-05-28 06:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(521,8,'2017-05-28 06:25:01','2017-05-28 06:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(522,8,'2017-05-28 06:26:01','2017-05-28 06:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(523,8,'2017-05-28 06:27:01','2017-05-28 06:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(524,8,'2017-05-28 06:28:01','2017-05-28 06:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(525,8,'2017-05-28 06:29:02','2017-05-28 06:29:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(526,8,'2017-05-28 06:30:01','2017-05-28 06:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(527,8,'2017-05-28 06:31:01','2017-05-28 06:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(528,8,'2017-05-28 06:32:01','2017-05-28 06:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(529,8,'2017-05-28 06:33:01','2017-05-28 06:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(530,8,'2017-05-28 06:34:01','2017-05-28 06:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(531,8,'2017-05-28 06:35:01','2017-05-28 06:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(532,8,'2017-05-28 06:36:01','2017-05-28 06:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(533,8,'2017-05-28 06:37:01','2017-05-28 06:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(534,8,'2017-05-28 06:38:02','2017-05-28 06:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(535,8,'2017-05-28 06:39:01','2017-05-28 06:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(536,8,'2017-05-28 06:40:01','2017-05-28 06:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(537,8,'2017-05-28 06:41:02','2017-05-28 06:41:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(538,8,'2017-05-28 06:42:01','2017-05-28 06:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(539,8,'2017-05-28 06:43:01','2017-05-28 06:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(540,8,'2017-05-28 06:44:01','2017-05-28 06:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(541,8,'2017-05-28 06:45:01','2017-05-28 06:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(542,8,'2017-05-28 06:46:01','2017-05-28 06:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(543,8,'2017-05-28 06:47:01','2017-05-28 06:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(544,8,'2017-05-28 06:48:01','2017-05-28 06:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(545,8,'2017-05-28 06:49:01','2017-05-28 06:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(546,8,'2017-05-28 06:50:02','2017-05-28 06:50:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(547,8,'2017-05-28 06:51:01','2017-05-28 06:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(548,8,'2017-05-28 06:52:01','2017-05-28 06:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(549,8,'2017-05-28 06:53:01','2017-05-28 06:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(550,8,'2017-05-28 06:54:01','2017-05-28 06:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(551,8,'2017-05-28 06:55:01','2017-05-28 06:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(552,8,'2017-05-28 06:56:01','2017-05-28 06:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(553,8,'2017-05-28 06:57:02','2017-05-28 06:57:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(554,8,'2017-05-28 06:58:01','2017-05-28 06:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(555,8,'2017-05-28 06:59:01','2017-05-28 06:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(556,8,'2017-05-28 07:00:01','2017-05-28 07:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(557,8,'2017-05-28 07:01:01','2017-05-28 07:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(558,8,'2017-05-28 07:02:01','2017-05-28 07:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(559,8,'2017-05-28 07:03:01','2017-05-28 07:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(560,8,'2017-05-28 07:04:02','2017-05-28 07:04:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(561,8,'2017-05-28 07:05:01','2017-05-28 07:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(562,8,'2017-05-28 07:06:01','2017-05-28 07:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(563,8,'2017-05-28 07:07:01','2017-05-28 07:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(564,8,'2017-05-28 07:08:02','2017-05-28 07:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(565,8,'2017-05-28 07:09:01','2017-05-28 07:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(566,8,'2017-05-28 07:10:01','2017-05-28 07:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(567,8,'2017-05-28 07:11:01','2017-05-28 07:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(568,8,'2017-05-28 07:12:01','2017-05-28 07:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(569,8,'2017-05-28 07:13:01','2017-05-28 07:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(570,8,'2017-05-28 07:14:01','2017-05-28 07:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(571,8,'2017-05-28 07:15:01','2017-05-28 07:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(572,8,'2017-05-28 07:16:01','2017-05-28 07:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(573,8,'2017-05-28 07:17:01','2017-05-28 07:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(574,8,'2017-05-28 07:18:01','2017-05-28 07:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(575,8,'2017-05-28 07:19:01','2017-05-28 07:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(576,8,'2017-05-28 07:20:01','2017-05-28 07:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(577,8,'2017-05-28 07:21:02','2017-05-28 07:21:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(578,8,'2017-05-28 07:22:01','2017-05-28 07:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(579,8,'2017-05-28 07:23:01','2017-05-28 07:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(580,8,'2017-05-28 07:24:01','2017-05-28 07:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(581,8,'2017-05-28 07:25:01','2017-05-28 07:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(582,8,'2017-05-28 07:26:01','2017-05-28 07:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(583,8,'2017-05-28 07:27:01','2017-05-28 07:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(584,8,'2017-05-28 07:28:01','2017-05-28 07:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(585,8,'2017-05-28 07:29:01','2017-05-28 07:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(586,8,'2017-05-28 07:30:01','2017-05-28 07:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(587,8,'2017-05-28 07:31:01','2017-05-28 07:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(588,8,'2017-05-28 07:32:01','2017-05-28 07:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(589,8,'2017-05-28 07:33:01','2017-05-28 07:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(590,8,'2017-05-28 07:34:01','2017-05-28 07:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(591,8,'2017-05-28 07:35:01','2017-05-28 07:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(592,8,'2017-05-28 07:36:01','2017-05-28 07:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(593,8,'2017-05-28 07:37:01','2017-05-28 07:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(594,8,'2017-05-28 07:38:01','2017-05-28 07:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(595,8,'2017-05-28 07:39:01','2017-05-28 07:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(596,8,'2017-05-28 07:40:01','2017-05-28 07:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(597,8,'2017-05-28 07:41:01','2017-05-28 07:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(598,8,'2017-05-28 07:42:01','2017-05-28 07:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(599,8,'2017-05-28 07:43:01','2017-05-28 07:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(600,8,'2017-05-28 07:44:01','2017-05-28 07:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(601,8,'2017-05-28 07:45:01','2017-05-28 07:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(602,8,'2017-05-28 07:46:01','2017-05-28 07:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(603,8,'2017-05-28 07:47:01','2017-05-28 07:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(604,8,'2017-05-28 07:48:01','2017-05-28 07:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(605,8,'2017-05-28 07:49:01','2017-05-28 07:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(606,8,'2017-05-28 07:50:01','2017-05-28 07:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(607,8,'2017-05-28 07:51:01','2017-05-28 07:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(608,8,'2017-05-28 07:52:01','2017-05-28 07:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(609,8,'2017-05-28 07:53:01','2017-05-28 07:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(610,8,'2017-05-28 07:54:01','2017-05-28 07:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(611,8,'2017-05-28 07:55:01','2017-05-28 07:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(612,8,'2017-05-28 07:56:01','2017-05-28 07:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(613,8,'2017-05-28 07:57:01','2017-05-28 07:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(614,8,'2017-05-28 07:58:01','2017-05-28 07:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(615,8,'2017-05-28 07:59:01','2017-05-28 07:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(616,8,'2017-05-28 08:00:02','2017-05-28 08:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(617,8,'2017-05-28 08:01:01','2017-05-28 08:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(618,8,'2017-05-28 08:02:01','2017-05-28 08:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(619,8,'2017-05-28 08:03:01','2017-05-28 08:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(620,8,'2017-05-28 08:04:01','2017-05-28 08:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(621,8,'2017-05-28 08:05:01','2017-05-28 08:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(622,8,'2017-05-28 08:06:01','2017-05-28 08:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(623,8,'2017-05-28 08:07:02','2017-05-28 08:07:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(624,8,'2017-05-28 08:08:01','2017-05-28 08:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(625,8,'2017-05-28 08:09:01','2017-05-28 08:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(626,8,'2017-05-28 08:10:01','2017-05-28 08:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(627,8,'2017-05-28 08:11:01','2017-05-28 08:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(628,8,'2017-05-28 08:12:01','2017-05-28 08:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(629,8,'2017-05-28 08:13:01','2017-05-28 08:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(630,8,'2017-05-28 08:14:01','2017-05-28 08:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(631,8,'2017-05-28 08:15:01','2017-05-28 08:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(632,8,'2017-05-28 08:16:01','2017-05-28 08:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(633,8,'2017-05-28 08:17:01','2017-05-28 08:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(634,8,'2017-05-28 08:18:01','2017-05-28 08:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(635,8,'2017-05-28 08:19:01','2017-05-28 08:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(636,8,'2017-05-28 08:20:01','2017-05-28 08:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(637,8,'2017-05-28 08:21:01','2017-05-28 08:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(638,8,'2017-05-28 08:22:01','2017-05-28 08:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(639,8,'2017-05-28 08:23:01','2017-05-28 08:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(640,8,'2017-05-28 08:24:01','2017-05-28 08:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(641,8,'2017-05-28 08:25:01','2017-05-28 08:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(642,8,'2017-05-28 08:26:01','2017-05-28 08:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(643,8,'2017-05-28 08:27:01','2017-05-28 08:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(644,8,'2017-05-28 08:28:01','2017-05-28 08:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(645,8,'2017-05-28 08:29:01','2017-05-28 08:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(646,8,'2017-05-28 08:30:01','2017-05-28 08:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(647,8,'2017-05-28 08:31:01','2017-05-28 08:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(648,8,'2017-05-28 08:32:01','2017-05-28 08:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(649,8,'2017-05-28 08:33:01','2017-05-28 08:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(650,8,'2017-05-28 08:34:01','2017-05-28 08:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(651,8,'2017-05-28 08:35:01','2017-05-28 08:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(652,8,'2017-05-28 08:36:01','2017-05-28 08:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(653,8,'2017-05-28 08:37:01','2017-05-28 08:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(654,8,'2017-05-28 08:38:01','2017-05-28 08:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(655,8,'2017-05-28 08:39:01','2017-05-28 08:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(656,8,'2017-05-28 08:40:01','2017-05-28 08:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(657,8,'2017-05-28 08:41:01','2017-05-28 08:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(658,8,'2017-05-28 08:42:01','2017-05-28 08:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(659,8,'2017-05-28 08:43:01','2017-05-28 08:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(660,8,'2017-05-28 08:44:01','2017-05-28 08:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(661,8,'2017-05-28 08:45:01','2017-05-28 08:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(662,8,'2017-05-28 08:46:01','2017-05-28 08:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(663,8,'2017-05-28 08:47:01','2017-05-28 08:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(664,8,'2017-05-28 08:48:01','2017-05-28 08:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(665,8,'2017-05-28 08:49:01','2017-05-28 08:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(666,8,'2017-05-28 08:50:01','2017-05-28 08:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(667,8,'2017-05-28 08:51:02','2017-05-28 08:51:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(668,8,'2017-05-28 08:52:01','2017-05-28 08:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(669,8,'2017-05-28 08:53:01','2017-05-28 08:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(670,8,'2017-05-28 08:54:01','2017-05-28 08:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(671,8,'2017-05-28 08:55:01','2017-05-28 08:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(672,8,'2017-05-28 08:56:01','2017-05-28 08:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(673,8,'2017-05-28 08:57:01','2017-05-28 08:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(674,8,'2017-05-28 08:58:01','2017-05-28 08:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(675,8,'2017-05-28 08:59:01','2017-05-28 08:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(676,8,'2017-05-28 09:00:01','2017-05-28 09:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(677,8,'2017-05-28 09:01:01','2017-05-28 09:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(678,8,'2017-05-28 09:02:01','2017-05-28 09:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(679,8,'2017-05-28 09:03:01','2017-05-28 09:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(680,8,'2017-05-28 09:04:01','2017-05-28 09:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(681,8,'2017-05-28 09:05:01','2017-05-28 09:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(682,8,'2017-05-28 09:06:01','2017-05-28 09:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(683,8,'2017-05-28 09:07:01','2017-05-28 09:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(684,8,'2017-05-28 09:08:01','2017-05-28 09:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(685,8,'2017-05-28 09:09:01','2017-05-28 09:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(686,8,'2017-05-28 09:10:01','2017-05-28 09:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(687,8,'2017-05-28 09:11:01','2017-05-28 09:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(688,8,'2017-05-28 09:12:02','2017-05-28 09:12:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(689,8,'2017-05-28 09:13:01','2017-05-28 09:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(690,8,'2017-05-28 09:14:02','2017-05-28 09:14:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(691,8,'2017-05-28 09:15:01','2017-05-28 09:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(692,8,'2017-05-28 09:16:01','2017-05-28 09:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(693,8,'2017-05-28 09:17:01','2017-05-28 09:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(694,8,'2017-05-28 09:18:01','2017-05-28 09:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(695,8,'2017-05-28 09:19:01','2017-05-28 09:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(696,8,'2017-05-28 09:20:01','2017-05-28 09:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(697,8,'2017-05-28 09:21:01','2017-05-28 09:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(698,8,'2017-05-28 09:22:01','2017-05-28 09:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(699,8,'2017-05-28 09:23:01','2017-05-28 09:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(700,8,'2017-05-28 09:24:01','2017-05-28 09:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(701,8,'2017-05-28 09:25:02','2017-05-28 09:25:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(702,8,'2017-05-28 09:26:01','2017-05-28 09:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(703,8,'2017-05-28 09:27:01','2017-05-28 09:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(704,8,'2017-05-28 09:28:01','2017-05-28 09:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(705,8,'2017-05-28 09:29:01','2017-05-28 09:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(706,8,'2017-05-28 09:30:02','2017-05-28 09:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(707,8,'2017-05-28 09:31:01','2017-05-28 09:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(708,8,'2017-05-28 09:32:01','2017-05-28 09:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(709,8,'2017-05-28 09:33:01','2017-05-28 09:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(710,8,'2017-05-28 09:34:01','2017-05-28 09:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(711,8,'2017-05-28 09:35:01','2017-05-28 09:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(712,8,'2017-05-28 09:36:01','2017-05-28 09:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(713,8,'2017-05-28 09:37:01','2017-05-28 09:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(714,8,'2017-05-28 09:38:01','2017-05-28 09:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(715,8,'2017-05-28 09:39:01','2017-05-28 09:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(716,8,'2017-05-28 09:40:01','2017-05-28 09:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(717,8,'2017-05-28 09:41:01','2017-05-28 09:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(718,8,'2017-05-28 09:42:01','2017-05-28 09:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(719,8,'2017-05-28 09:43:01','2017-05-28 09:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(720,8,'2017-05-28 09:44:01','2017-05-28 09:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(721,8,'2017-05-28 09:45:01','2017-05-28 09:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(722,8,'2017-05-28 09:46:01','2017-05-28 09:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(723,8,'2017-05-28 09:47:01','2017-05-28 09:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(724,8,'2017-05-28 09:48:01','2017-05-28 09:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(725,8,'2017-05-28 09:49:01','2017-05-28 09:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(726,8,'2017-05-28 09:50:01','2017-05-28 09:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(727,8,'2017-05-28 09:51:01','2017-05-28 09:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(728,8,'2017-05-28 09:52:01','2017-05-28 09:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(729,8,'2017-05-28 09:53:01','2017-05-28 09:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(730,8,'2017-05-28 09:54:02','2017-05-28 09:54:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(731,8,'2017-05-28 09:55:01','2017-05-28 09:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(732,8,'2017-05-28 09:56:01','2017-05-28 09:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(733,8,'2017-05-28 09:57:01','2017-05-28 09:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(734,8,'2017-05-28 09:58:01','2017-05-28 09:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(735,8,'2017-05-28 09:59:01','2017-05-28 09:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(736,8,'2017-05-28 10:00:01','2017-05-28 10:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(737,8,'2017-05-28 10:01:01','2017-05-28 10:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(738,8,'2017-05-28 10:02:01','2017-05-28 10:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(739,8,'2017-05-28 10:03:01','2017-05-28 10:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(740,8,'2017-05-28 10:04:01','2017-05-28 10:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(741,8,'2017-05-28 10:05:01','2017-05-28 10:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(742,8,'2017-05-28 10:06:01','2017-05-28 10:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(743,8,'2017-05-28 10:07:01','2017-05-28 10:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(744,8,'2017-05-28 10:08:01','2017-05-28 10:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(745,8,'2017-05-28 10:09:01','2017-05-28 10:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(746,8,'2017-05-28 10:10:01','2017-05-28 10:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(747,8,'2017-05-28 10:11:01','2017-05-28 10:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(748,8,'2017-05-28 10:12:01','2017-05-28 10:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(749,8,'2017-05-28 10:13:01','2017-05-28 10:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(750,8,'2017-05-28 10:14:01','2017-05-28 10:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(751,8,'2017-05-28 10:15:01','2017-05-28 10:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(752,8,'2017-05-28 10:16:01','2017-05-28 10:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(753,8,'2017-05-28 10:17:01','2017-05-28 10:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(754,8,'2017-05-28 10:18:01','2017-05-28 10:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(755,8,'2017-05-28 10:19:01','2017-05-28 10:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(756,8,'2017-05-28 10:20:01','2017-05-28 10:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(757,8,'2017-05-28 10:21:02','2017-05-28 10:21:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(758,8,'2017-05-28 10:22:01','2017-05-28 10:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(759,8,'2017-05-28 10:23:01','2017-05-28 10:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(760,8,'2017-05-28 10:24:01','2017-05-28 10:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(761,8,'2017-05-28 10:25:01','2017-05-28 10:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(762,8,'2017-05-28 10:26:01','2017-05-28 10:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(763,8,'2017-05-28 10:27:01','2017-05-28 10:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(764,8,'2017-05-28 10:28:01','2017-05-28 10:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(765,8,'2017-05-28 10:29:01','2017-05-28 10:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(766,8,'2017-05-28 10:30:01','2017-05-28 10:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(767,8,'2017-05-28 10:31:01','2017-05-28 10:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(768,8,'2017-05-28 10:32:02','2017-05-28 10:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(769,8,'2017-05-28 10:33:01','2017-05-28 10:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(770,8,'2017-05-28 10:34:01','2017-05-28 10:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(771,8,'2017-05-28 10:35:02','2017-05-28 10:35:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(772,8,'2017-05-28 10:36:01','2017-05-28 10:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(773,8,'2017-05-28 10:37:01','2017-05-28 10:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(774,8,'2017-05-28 10:38:01','2017-05-28 10:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(775,8,'2017-05-28 10:39:01','2017-05-28 10:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(776,8,'2017-05-28 10:40:09','2017-05-28 10:40:09','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(777,8,'2017-05-28 10:41:02','2017-05-28 10:41:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(778,8,'2017-05-28 10:42:01','2017-05-28 10:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(779,8,'2017-05-28 10:43:01','2017-05-28 10:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(780,8,'2017-05-28 10:44:01','2017-05-28 10:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(781,8,'2017-05-28 10:45:02','2017-05-28 10:45:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(782,8,'2017-05-28 10:46:01','2017-05-28 10:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(783,8,'2017-05-28 10:47:01','2017-05-28 10:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(784,8,'2017-05-28 10:48:01','2017-05-28 10:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(785,8,'2017-05-28 10:49:01','2017-05-28 10:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(786,8,'2017-05-28 10:50:01','2017-05-28 10:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(787,8,'2017-05-28 10:51:01','2017-05-28 10:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(788,8,'2017-05-28 10:52:01','2017-05-28 10:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(789,8,'2017-05-28 10:53:01','2017-05-28 10:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(790,8,'2017-05-28 10:54:01','2017-05-28 10:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(791,8,'2017-05-28 10:55:01','2017-05-28 10:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(792,8,'2017-05-28 10:56:01','2017-05-28 10:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(793,8,'2017-05-28 10:57:01','2017-05-28 10:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(794,8,'2017-05-28 10:58:01','2017-05-28 10:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(795,8,'2017-05-28 10:59:01','2017-05-28 10:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(796,8,'2017-05-28 11:00:01','2017-05-28 11:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(797,8,'2017-05-28 11:01:01','2017-05-28 11:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(798,8,'2017-05-28 11:02:01','2017-05-28 11:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(799,8,'2017-05-28 11:03:01','2017-05-28 11:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(800,8,'2017-05-28 11:04:01','2017-05-28 11:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(801,8,'2017-05-28 11:05:01','2017-05-28 11:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(802,8,'2017-05-28 11:06:01','2017-05-28 11:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(803,8,'2017-05-28 11:07:01','2017-05-28 11:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(804,8,'2017-05-28 11:08:02','2017-05-28 11:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(805,8,'2017-05-28 11:09:01','2017-05-28 11:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(806,8,'2017-05-28 11:10:01','2017-05-28 11:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(807,8,'2017-05-28 11:11:01','2017-05-28 11:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(808,8,'2017-05-28 11:12:01','2017-05-28 11:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(809,8,'2017-05-28 11:13:01','2017-05-28 11:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(810,8,'2017-05-28 11:14:01','2017-05-28 11:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(811,8,'2017-05-28 11:15:01','2017-05-28 11:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(812,8,'2017-05-28 11:16:01','2017-05-28 11:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(813,8,'2017-05-28 11:17:01','2017-05-28 11:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(814,8,'2017-05-28 11:18:01','2017-05-28 11:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(815,8,'2017-05-28 11:19:01','2017-05-28 11:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(816,8,'2017-05-28 11:20:01','2017-05-28 11:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(817,8,'2017-05-28 11:21:01','2017-05-28 11:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(818,8,'2017-05-28 11:22:01','2017-05-28 11:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(819,8,'2017-05-28 11:23:01','2017-05-28 11:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(820,8,'2017-05-28 11:24:01','2017-05-28 11:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(821,8,'2017-05-28 11:25:01','2017-05-28 11:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(822,8,'2017-05-28 11:26:01','2017-05-28 11:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(823,8,'2017-05-28 11:27:01','2017-05-28 11:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(824,8,'2017-05-28 11:28:01','2017-05-28 11:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(825,8,'2017-05-28 11:29:01','2017-05-28 11:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(826,8,'2017-05-28 11:30:01','2017-05-28 11:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(827,8,'2017-05-28 11:31:01','2017-05-28 11:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(828,8,'2017-05-28 11:32:01','2017-05-28 11:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(829,8,'2017-05-28 11:33:01','2017-05-28 11:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(830,8,'2017-05-28 11:34:01','2017-05-28 11:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(831,8,'2017-05-28 11:35:01','2017-05-28 11:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(832,8,'2017-05-28 11:36:01','2017-05-28 11:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(833,8,'2017-05-28 11:37:01','2017-05-28 11:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(834,8,'2017-05-28 11:38:01','2017-05-28 11:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(835,8,'2017-05-28 11:39:01','2017-05-28 11:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(836,8,'2017-05-28 11:40:01','2017-05-28 11:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(837,8,'2017-05-28 11:41:01','2017-05-28 11:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(838,8,'2017-05-28 11:42:01','2017-05-28 11:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(839,8,'2017-05-28 11:43:01','2017-05-28 11:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(840,8,'2017-05-28 11:44:01','2017-05-28 11:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(841,8,'2017-05-28 11:45:01','2017-05-28 11:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(842,8,'2017-05-28 11:46:01','2017-05-28 11:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(843,8,'2017-05-28 11:47:02','2017-05-28 11:47:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(844,8,'2017-05-28 11:48:01','2017-05-28 11:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(845,8,'2017-05-28 11:49:01','2017-05-28 11:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(846,8,'2017-05-28 11:50:01','2017-05-28 11:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(847,8,'2017-05-28 11:51:02','2017-05-28 11:51:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(848,8,'2017-05-28 11:52:01','2017-05-28 11:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(849,8,'2017-05-28 11:53:01','2017-05-28 11:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(850,8,'2017-05-28 11:54:01','2017-05-28 11:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(851,8,'2017-05-28 11:55:01','2017-05-28 11:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(852,8,'2017-05-28 11:56:01','2017-05-28 11:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(853,8,'2017-05-28 11:57:01','2017-05-28 11:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(854,8,'2017-05-28 11:58:01','2017-05-28 11:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(855,8,'2017-05-28 11:59:01','2017-05-28 11:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(856,8,'2017-05-28 12:00:02','2017-05-28 12:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(857,8,'2017-05-28 12:01:01','2017-05-28 12:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(858,8,'2017-05-28 12:02:01','2017-05-28 12:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(859,8,'2017-05-28 12:03:01','2017-05-28 12:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(860,8,'2017-05-28 12:04:01','2017-05-28 12:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(861,8,'2017-05-28 12:05:01','2017-05-28 12:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(862,8,'2017-05-28 12:06:01','2017-05-28 12:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(863,8,'2017-05-28 12:07:01','2017-05-28 12:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(864,8,'2017-05-28 12:08:01','2017-05-28 12:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(865,8,'2017-05-28 12:09:01','2017-05-28 12:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(866,8,'2017-05-28 12:10:01','2017-05-28 12:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(867,8,'2017-05-28 12:11:01','2017-05-28 12:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(868,8,'2017-05-28 12:12:01','2017-05-28 12:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(869,8,'2017-05-28 12:13:01','2017-05-28 12:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(870,8,'2017-05-28 12:14:01','2017-05-28 12:14:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(871,8,'2017-05-28 12:15:01','2017-05-28 12:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(872,8,'2017-05-28 12:16:01','2017-05-28 12:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(873,8,'2017-05-28 12:17:01','2017-05-28 12:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(874,8,'2017-05-28 12:18:01','2017-05-28 12:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(875,8,'2017-05-28 12:19:01','2017-05-28 12:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(876,8,'2017-05-28 12:20:01','2017-05-28 12:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(877,8,'2017-05-28 12:21:01','2017-05-28 12:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(878,8,'2017-05-28 12:22:01','2017-05-28 12:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(879,8,'2017-05-28 12:23:01','2017-05-28 12:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(880,8,'2017-05-28 12:24:01','2017-05-28 12:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(881,8,'2017-05-28 12:25:01','2017-05-28 12:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(882,8,'2017-05-28 12:26:01','2017-05-28 12:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(883,8,'2017-05-28 12:27:01','2017-05-28 12:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(884,8,'2017-05-28 12:28:01','2017-05-28 12:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(885,8,'2017-05-28 12:29:02','2017-05-28 12:29:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(886,8,'2017-05-28 12:30:01','2017-05-28 12:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(887,8,'2017-05-28 12:31:01','2017-05-28 12:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(888,8,'2017-05-28 12:32:01','2017-05-28 12:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(889,8,'2017-05-28 12:33:01','2017-05-28 12:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(890,8,'2017-05-28 12:34:01','2017-05-28 12:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(891,8,'2017-05-28 12:35:01','2017-05-28 12:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(892,8,'2017-05-28 12:36:01','2017-05-28 12:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(893,8,'2017-05-28 12:37:02','2017-05-28 12:37:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(894,8,'2017-05-28 12:38:01','2017-05-28 12:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(895,8,'2017-05-28 12:39:01','2017-05-28 12:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(896,8,'2017-05-28 12:40:01','2017-05-28 12:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(897,8,'2017-05-28 12:41:01','2017-05-28 12:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(898,8,'2017-05-28 12:42:01','2017-05-28 12:42:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(899,8,'2017-05-28 12:43:01','2017-05-28 12:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(900,8,'2017-05-28 12:44:01','2017-05-28 12:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(901,8,'2017-05-28 12:45:01','2017-05-28 12:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(902,8,'2017-05-28 12:46:01','2017-05-28 12:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(903,8,'2017-05-28 12:47:01','2017-05-28 12:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(904,8,'2017-05-28 12:48:01','2017-05-28 12:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(905,8,'2017-05-28 12:49:01','2017-05-28 12:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(906,8,'2017-05-28 12:50:01','2017-05-28 12:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(907,8,'2017-05-28 12:51:01','2017-05-28 12:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(908,8,'2017-05-28 12:52:01','2017-05-28 12:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(909,8,'2017-05-28 12:53:01','2017-05-28 12:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(910,8,'2017-05-28 12:54:01','2017-05-28 12:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(911,8,'2017-05-28 12:55:01','2017-05-28 12:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(912,8,'2017-05-28 12:56:01','2017-05-28 12:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(913,8,'2017-05-28 12:57:01','2017-05-28 12:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(914,8,'2017-05-28 12:58:02','2017-05-28 12:58:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(915,8,'2017-05-28 12:59:01','2017-05-28 12:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(916,8,'2017-05-28 13:00:01','2017-05-28 13:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(917,8,'2017-05-28 13:01:01','2017-05-28 13:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(918,8,'2017-05-28 13:02:01','2017-05-28 13:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(919,8,'2017-05-28 13:03:01','2017-05-28 13:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(920,8,'2017-05-28 13:04:01','2017-05-28 13:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(921,8,'2017-05-28 13:05:01','2017-05-28 13:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(922,8,'2017-05-28 13:06:01','2017-05-28 13:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(923,8,'2017-05-28 13:07:01','2017-05-28 13:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(924,8,'2017-05-28 13:08:01','2017-05-28 13:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(925,8,'2017-05-28 13:09:01','2017-05-28 13:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(926,8,'2017-05-28 13:10:02','2017-05-28 13:10:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(927,8,'2017-05-28 13:11:01','2017-05-28 13:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(928,8,'2017-05-28 13:12:01','2017-05-28 13:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(929,8,'2017-05-28 13:13:01','2017-05-28 13:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(930,8,'2017-05-28 13:14:01','2017-05-28 13:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(931,8,'2017-05-28 13:15:01','2017-05-28 13:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(932,8,'2017-05-28 13:16:01','2017-05-28 13:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(933,8,'2017-05-28 13:17:01','2017-05-28 13:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(934,8,'2017-05-28 13:18:01','2017-05-28 13:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(935,8,'2017-05-28 13:19:01','2017-05-28 13:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(936,8,'2017-05-28 13:20:01','2017-05-28 13:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(937,8,'2017-05-28 13:21:01','2017-05-28 13:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(938,8,'2017-05-28 13:22:01','2017-05-28 13:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(939,8,'2017-05-28 13:23:01','2017-05-28 13:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(940,8,'2017-05-28 13:24:01','2017-05-28 13:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(941,8,'2017-05-28 13:25:01','2017-05-28 13:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(942,8,'2017-05-28 13:26:01','2017-05-28 13:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(943,8,'2017-05-28 13:27:01','2017-05-28 13:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(944,8,'2017-05-28 13:28:01','2017-05-28 13:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(945,8,'2017-05-28 13:29:01','2017-05-28 13:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(946,8,'2017-05-28 13:30:01','2017-05-28 13:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(947,8,'2017-05-28 13:31:01','2017-05-28 13:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(948,8,'2017-05-28 13:32:01','2017-05-28 13:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(949,8,'2017-05-28 13:33:01','2017-05-28 13:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(950,8,'2017-05-28 13:34:01','2017-05-28 13:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(951,8,'2017-05-28 13:35:01','2017-05-28 13:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(952,8,'2017-05-28 13:36:01','2017-05-28 13:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(953,8,'2017-05-28 13:37:01','2017-05-28 13:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(954,8,'2017-05-28 13:38:01','2017-05-28 13:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(955,8,'2017-05-28 13:39:01','2017-05-28 13:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(956,8,'2017-05-28 13:40:01','2017-05-28 13:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(957,8,'2017-05-28 13:41:01','2017-05-28 13:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(958,8,'2017-05-28 13:42:01','2017-05-28 13:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(959,8,'2017-05-28 13:43:01','2017-05-28 13:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(960,8,'2017-05-28 13:44:01','2017-05-28 13:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(961,8,'2017-05-28 13:45:01','2017-05-28 13:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(962,8,'2017-05-28 13:46:01','2017-05-28 13:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(963,8,'2017-05-28 13:47:01','2017-05-28 13:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(964,8,'2017-05-28 13:48:01','2017-05-28 13:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(965,8,'2017-05-28 13:49:01','2017-05-28 13:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(966,8,'2017-05-28 13:50:01','2017-05-28 13:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(967,8,'2017-05-28 13:51:01','2017-05-28 13:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(968,8,'2017-05-28 13:52:01','2017-05-28 13:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(969,8,'2017-05-28 13:53:01','2017-05-28 13:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(970,8,'2017-05-28 13:54:01','2017-05-28 13:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(971,8,'2017-05-28 13:55:01','2017-05-28 13:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(972,8,'2017-05-28 13:56:01','2017-05-28 13:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(973,8,'2017-05-28 13:57:01','2017-05-28 13:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(974,8,'2017-05-28 13:58:01','2017-05-28 13:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(975,8,'2017-05-28 13:59:01','2017-05-28 13:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(976,8,'2017-05-28 14:00:01','2017-05-28 14:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(977,8,'2017-05-28 14:01:01','2017-05-28 14:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(978,8,'2017-05-28 14:02:01','2017-05-28 14:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(979,8,'2017-05-28 14:03:01','2017-05-28 14:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(980,8,'2017-05-28 14:04:01','2017-05-28 14:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(981,8,'2017-05-28 14:05:01','2017-05-28 14:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(982,8,'2017-05-28 14:06:01','2017-05-28 14:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(983,8,'2017-05-28 14:07:01','2017-05-28 14:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(984,8,'2017-05-28 14:08:01','2017-05-28 14:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(985,8,'2017-05-28 14:09:01','2017-05-28 14:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(986,8,'2017-05-28 14:10:02','2017-05-28 14:10:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(987,8,'2017-05-28 14:11:01','2017-05-28 14:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(988,8,'2017-05-28 14:12:01','2017-05-28 14:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(989,8,'2017-05-28 14:13:01','2017-05-28 14:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(990,8,'2017-05-28 14:14:01','2017-05-28 14:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(991,8,'2017-05-28 14:15:01','2017-05-28 14:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(992,8,'2017-05-28 14:16:01','2017-05-28 14:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(993,8,'2017-05-28 14:17:01','2017-05-28 14:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(994,8,'2017-05-28 14:18:01','2017-05-28 14:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(995,8,'2017-05-28 14:19:01','2017-05-28 14:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(996,8,'2017-05-28 14:20:01','2017-05-28 14:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(997,8,'2017-05-28 14:21:01','2017-05-28 14:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(998,8,'2017-05-28 14:22:01','2017-05-28 14:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(999,8,'2017-05-28 14:23:01','2017-05-28 14:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1000,8,'2017-05-28 14:24:01','2017-05-28 14:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1001,8,'2017-05-28 14:25:02','2017-05-28 14:25:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1002,8,'2017-05-28 14:26:01','2017-05-28 14:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1003,8,'2017-05-28 14:27:01','2017-05-28 14:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1004,8,'2017-05-28 14:28:01','2017-05-28 14:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1005,8,'2017-05-28 14:29:01','2017-05-28 14:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1006,8,'2017-05-28 14:30:01','2017-05-28 14:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1007,8,'2017-05-28 14:31:01','2017-05-28 14:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1008,8,'2017-05-28 14:32:01','2017-05-28 14:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1009,8,'2017-05-28 14:33:01','2017-05-28 14:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1010,8,'2017-05-28 14:34:01','2017-05-28 14:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1011,8,'2017-05-28 14:35:01','2017-05-28 14:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1012,8,'2017-05-28 14:36:01','2017-05-28 14:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1013,8,'2017-05-28 14:37:01','2017-05-28 14:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1014,8,'2017-05-28 14:38:01','2017-05-28 14:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1015,8,'2017-05-28 14:39:01','2017-05-28 14:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1016,8,'2017-05-28 14:40:01','2017-05-28 14:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1017,8,'2017-05-28 14:41:01','2017-05-28 14:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1018,8,'2017-05-28 14:42:01','2017-05-28 14:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1019,8,'2017-05-28 14:43:01','2017-05-28 14:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1020,8,'2017-05-28 14:44:02','2017-05-28 14:44:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1021,8,'2017-05-28 14:45:01','2017-05-28 14:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1022,8,'2017-05-28 14:46:01','2017-05-28 14:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1023,8,'2017-05-28 14:47:01','2017-05-28 14:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1024,8,'2017-05-28 14:48:02','2017-05-28 14:48:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1025,8,'2017-05-28 14:49:01','2017-05-28 14:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1026,8,'2017-05-28 14:50:01','2017-05-28 14:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1027,8,'2017-05-28 14:51:01','2017-05-28 14:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1028,8,'2017-05-28 14:52:02','2017-05-28 14:52:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1029,8,'2017-05-28 14:53:01','2017-05-28 14:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1030,8,'2017-05-28 14:54:01','2017-05-28 14:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1031,8,'2017-05-28 14:55:01','2017-05-28 14:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1032,8,'2017-05-28 14:56:02','2017-05-28 14:56:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1033,8,'2017-05-28 14:57:01','2017-05-28 14:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1034,8,'2017-05-28 14:58:01','2017-05-28 14:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1035,8,'2017-05-28 14:59:01','2017-05-28 14:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1036,8,'2017-05-28 15:00:01','2017-05-28 15:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1037,8,'2017-05-28 15:01:01','2017-05-28 15:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1038,8,'2017-05-28 15:02:01','2017-05-28 15:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1039,8,'2017-05-28 15:03:02','2017-05-28 15:03:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1040,8,'2017-05-28 15:04:01','2017-05-28 15:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1041,8,'2017-05-28 15:05:01','2017-05-28 15:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1042,8,'2017-05-28 15:06:01','2017-05-28 15:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1043,8,'2017-05-28 15:07:01','2017-05-28 15:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1044,8,'2017-05-28 15:08:02','2017-05-28 15:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1045,8,'2017-05-28 15:09:01','2017-05-28 15:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1046,8,'2017-05-28 15:10:01','2017-05-28 15:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1047,8,'2017-05-28 15:11:01','2017-05-28 15:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1048,8,'2017-05-28 15:12:01','2017-05-28 15:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1049,8,'2017-05-28 15:13:01','2017-05-28 15:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1050,8,'2017-05-28 15:14:02','2017-05-28 15:14:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1051,8,'2017-05-28 15:15:01','2017-05-28 15:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1052,8,'2017-05-28 15:16:01','2017-05-28 15:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1053,8,'2017-05-28 15:17:01','2017-05-28 15:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1054,8,'2017-05-28 15:18:01','2017-05-28 15:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1055,8,'2017-05-28 15:19:01','2017-05-28 15:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1056,8,'2017-05-28 15:20:01','2017-05-28 15:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1057,8,'2017-05-28 15:21:01','2017-05-28 15:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1058,8,'2017-05-28 15:22:01','2017-05-28 15:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1059,8,'2017-05-28 15:23:02','2017-05-28 15:23:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1060,8,'2017-05-28 15:24:01','2017-05-28 15:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1061,8,'2017-05-28 15:25:01','2017-05-28 15:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1062,8,'2017-05-28 15:26:01','2017-05-28 15:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1063,8,'2017-05-28 15:27:01','2017-05-28 15:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1064,8,'2017-05-28 15:28:01','2017-05-28 15:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1065,8,'2017-05-28 15:29:01','2017-05-28 15:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1066,8,'2017-05-28 15:30:01','2017-05-28 15:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1067,8,'2017-05-28 15:31:01','2017-05-28 15:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1068,8,'2017-05-28 15:32:01','2017-05-28 15:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1069,8,'2017-05-28 15:33:01','2017-05-28 15:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1070,8,'2017-05-28 15:34:01','2017-05-28 15:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1071,8,'2017-05-28 15:35:01','2017-05-28 15:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1072,8,'2017-05-28 15:36:01','2017-05-28 15:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1073,8,'2017-05-28 15:37:01','2017-05-28 15:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1074,8,'2017-05-28 15:38:01','2017-05-28 15:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1075,8,'2017-05-28 15:39:01','2017-05-28 15:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1076,8,'2017-05-28 15:40:01','2017-05-28 15:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1077,8,'2017-05-28 15:41:01','2017-05-28 15:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1078,8,'2017-05-28 15:42:01','2017-05-28 15:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1079,8,'2017-05-28 15:43:01','2017-05-28 15:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1080,8,'2017-05-28 15:44:01','2017-05-28 15:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1081,8,'2017-05-28 15:45:01','2017-05-28 15:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1082,8,'2017-05-28 15:46:01','2017-05-28 15:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1083,8,'2017-05-28 15:47:01','2017-05-28 15:47:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1084,8,'2017-05-28 15:48:01','2017-05-28 15:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1085,8,'2017-05-28 15:49:01','2017-05-28 15:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1086,8,'2017-05-28 15:50:01','2017-05-28 15:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1087,8,'2017-05-28 15:51:01','2017-05-28 15:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1088,8,'2017-05-28 15:52:01','2017-05-28 15:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1089,8,'2017-05-28 15:53:01','2017-05-28 15:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1090,8,'2017-05-28 15:54:01','2017-05-28 15:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1091,8,'2017-05-28 15:55:01','2017-05-28 15:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1092,8,'2017-05-28 15:56:01','2017-05-28 15:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1093,8,'2017-05-28 15:57:01','2017-05-28 15:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1094,8,'2017-05-28 15:58:01','2017-05-28 15:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1095,8,'2017-05-28 15:59:01','2017-05-28 15:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1096,8,'2017-05-28 16:00:01','2017-05-28 16:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1097,8,'2017-05-28 16:01:01','2017-05-28 16:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1098,8,'2017-05-28 16:02:01','2017-05-28 16:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1099,8,'2017-05-28 16:03:01','2017-05-28 16:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1100,8,'2017-05-28 16:04:01','2017-05-28 16:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1101,8,'2017-05-28 16:05:01','2017-05-28 16:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1102,8,'2017-05-28 16:06:01','2017-05-28 16:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1103,8,'2017-05-28 16:07:01','2017-05-28 16:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1104,8,'2017-05-28 16:08:02','2017-05-28 16:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1105,8,'2017-05-28 16:09:01','2017-05-28 16:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1106,8,'2017-05-28 16:10:01','2017-05-28 16:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1107,8,'2017-05-28 16:11:01','2017-05-28 16:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1108,8,'2017-05-28 16:12:01','2017-05-28 16:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1109,8,'2017-05-28 16:13:01','2017-05-28 16:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1110,8,'2017-05-28 16:14:01','2017-05-28 16:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1111,8,'2017-05-28 16:15:01','2017-05-28 16:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1112,8,'2017-05-28 16:16:01','2017-05-28 16:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1113,8,'2017-05-28 16:17:01','2017-05-28 16:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1114,8,'2017-05-28 16:18:01','2017-05-28 16:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1115,8,'2017-05-28 16:19:01','2017-05-28 16:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1116,8,'2017-05-28 16:20:01','2017-05-28 16:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1117,8,'2017-05-28 16:21:01','2017-05-28 16:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1118,8,'2017-05-28 16:22:01','2017-05-28 16:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1119,8,'2017-05-28 16:23:01','2017-05-28 16:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1120,8,'2017-05-28 16:24:01','2017-05-28 16:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1121,8,'2017-05-28 16:25:01','2017-05-28 16:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1122,8,'2017-05-28 16:26:01','2017-05-28 16:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1123,8,'2017-05-28 16:27:01','2017-05-28 16:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1124,8,'2017-05-28 16:28:01','2017-05-28 16:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1125,8,'2017-05-28 16:29:01','2017-05-28 16:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1126,8,'2017-05-28 16:30:01','2017-05-28 16:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1127,8,'2017-05-28 16:31:01','2017-05-28 16:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1128,8,'2017-05-28 16:32:01','2017-05-28 16:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1129,8,'2017-05-28 16:33:01','2017-05-28 16:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1130,8,'2017-05-28 16:34:02','2017-05-28 16:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1131,8,'2017-05-28 16:35:01','2017-05-28 16:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1132,8,'2017-05-28 16:36:01','2017-05-28 16:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1133,8,'2017-05-28 16:37:01','2017-05-28 16:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1134,8,'2017-05-28 16:38:02','2017-05-28 16:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1135,8,'2017-05-28 16:39:01','2017-05-28 16:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1136,8,'2017-05-28 16:40:01','2017-05-28 16:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1137,8,'2017-05-28 16:41:01','2017-05-28 16:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1138,8,'2017-05-28 16:42:01','2017-05-28 16:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1139,8,'2017-05-28 16:43:01','2017-05-28 16:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1140,8,'2017-05-28 16:44:01','2017-05-28 16:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1141,8,'2017-05-28 16:45:01','2017-05-28 16:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1142,8,'2017-05-28 16:46:01','2017-05-28 16:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1143,8,'2017-05-28 16:47:01','2017-05-28 16:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1144,8,'2017-05-28 16:48:01','2017-05-28 16:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1145,8,'2017-05-28 16:49:01','2017-05-28 16:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1146,8,'2017-05-28 16:50:01','2017-05-28 16:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1147,8,'2017-05-28 16:51:01','2017-05-28 16:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1148,8,'2017-05-28 16:52:01','2017-05-28 16:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1149,8,'2017-05-28 16:53:01','2017-05-28 16:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1150,8,'2017-05-28 16:54:01','2017-05-28 16:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1151,8,'2017-05-28 16:55:01','2017-05-28 16:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1152,8,'2017-05-28 16:56:02','2017-05-28 16:56:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1153,8,'2017-05-28 16:57:01','2017-05-28 16:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1154,8,'2017-05-28 16:58:01','2017-05-28 16:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1155,8,'2017-05-28 16:59:01','2017-05-28 16:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1156,8,'2017-05-28 17:00:01','2017-05-28 17:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1157,8,'2017-05-28 17:01:01','2017-05-28 17:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1158,8,'2017-05-28 17:02:01','2017-05-28 17:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1159,8,'2017-05-28 17:03:01','2017-05-28 17:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1160,8,'2017-05-28 17:04:01','2017-05-28 17:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1161,8,'2017-05-28 17:05:02','2017-05-28 17:05:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1162,8,'2017-05-28 17:06:01','2017-05-28 17:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1163,8,'2017-05-28 17:07:01','2017-05-28 17:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1164,8,'2017-05-28 17:08:02','2017-05-28 17:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1165,8,'2017-05-28 17:09:01','2017-05-28 17:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1166,8,'2017-05-28 17:10:01','2017-05-28 17:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1167,8,'2017-05-28 17:11:01','2017-05-28 17:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1168,8,'2017-05-28 17:12:01','2017-05-28 17:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1169,8,'2017-05-28 17:13:01','2017-05-28 17:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1170,8,'2017-05-28 17:14:02','2017-05-28 17:14:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1171,8,'2017-05-28 17:15:01','2017-05-28 17:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1172,8,'2017-05-28 17:16:01','2017-05-28 17:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1173,8,'2017-05-28 17:17:02','2017-05-28 17:17:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1174,8,'2017-05-28 17:18:01','2017-05-28 17:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1175,8,'2017-05-28 17:19:01','2017-05-28 17:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1176,8,'2017-05-28 17:20:01','2017-05-28 17:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1177,8,'2017-05-28 17:21:01','2017-05-28 17:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1178,8,'2017-05-28 17:22:01','2017-05-28 17:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1179,8,'2017-05-28 17:23:01','2017-05-28 17:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1180,8,'2017-05-28 17:24:01','2017-05-28 17:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1181,8,'2017-05-28 17:25:02','2017-05-28 17:25:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1182,8,'2017-05-28 17:26:01','2017-05-28 17:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1183,8,'2017-05-28 17:27:01','2017-05-28 17:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1184,8,'2017-05-28 17:28:01','2017-05-28 17:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1185,8,'2017-05-28 17:29:01','2017-05-28 17:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1186,8,'2017-05-28 17:30:01','2017-05-28 17:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1187,8,'2017-05-28 17:31:01','2017-05-28 17:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1188,8,'2017-05-28 17:32:01','2017-05-28 17:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1189,8,'2017-05-28 17:33:01','2017-05-28 17:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1190,8,'2017-05-28 17:34:01','2017-05-28 17:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1191,8,'2017-05-28 17:35:01','2017-05-28 17:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1192,8,'2017-05-28 17:36:01','2017-05-28 17:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1193,8,'2017-05-28 17:37:01','2017-05-28 17:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1194,8,'2017-05-28 17:38:01','2017-05-28 17:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1195,8,'2017-05-28 17:39:01','2017-05-28 17:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1196,8,'2017-05-28 17:40:01','2017-05-28 17:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1197,8,'2017-05-28 17:41:01','2017-05-28 17:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1198,8,'2017-05-28 17:42:01','2017-05-28 17:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1199,8,'2017-05-28 17:43:01','2017-05-28 17:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1200,8,'2017-05-28 17:44:01','2017-05-28 17:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1201,8,'2017-05-28 17:45:01','2017-05-28 17:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1202,8,'2017-05-28 17:46:02','2017-05-28 17:46:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1203,8,'2017-05-28 17:47:01','2017-05-28 17:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1204,8,'2017-05-28 17:48:01','2017-05-28 17:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1205,8,'2017-05-28 17:49:01','2017-05-28 17:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1206,8,'2017-05-28 17:50:01','2017-05-28 17:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1207,8,'2017-05-28 17:51:01','2017-05-28 17:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1208,8,'2017-05-28 17:52:01','2017-05-28 17:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1209,8,'2017-05-28 17:53:01','2017-05-28 17:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1210,8,'2017-05-28 17:54:01','2017-05-28 17:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1211,8,'2017-05-28 17:55:02','2017-05-28 17:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1212,8,'2017-05-28 17:56:01','2017-05-28 17:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1213,8,'2017-05-28 17:57:01','2017-05-28 17:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1214,8,'2017-05-28 17:58:01','2017-05-28 17:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1215,8,'2017-05-28 17:59:01','2017-05-28 17:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1216,8,'2017-05-28 18:00:01','2017-05-28 18:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1217,8,'2017-05-28 18:01:01','2017-05-28 18:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1218,8,'2017-05-28 18:02:01','2017-05-28 18:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1219,8,'2017-05-28 18:03:01','2017-05-28 18:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1220,8,'2017-05-28 18:04:01','2017-05-28 18:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1221,8,'2017-05-28 18:05:01','2017-05-28 18:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1222,8,'2017-05-28 18:06:01','2017-05-28 18:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1223,8,'2017-05-28 18:07:01','2017-05-28 18:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1224,8,'2017-05-28 18:08:01','2017-05-28 18:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1225,8,'2017-05-28 18:09:01','2017-05-28 18:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1226,8,'2017-05-28 18:10:01','2017-05-28 18:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1227,8,'2017-05-28 18:11:01','2017-05-28 18:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1228,8,'2017-05-28 18:12:01','2017-05-28 18:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1229,8,'2017-05-28 18:13:01','2017-05-28 18:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1230,8,'2017-05-28 18:14:01','2017-05-28 18:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1231,8,'2017-05-28 18:15:01','2017-05-28 18:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1232,8,'2017-05-28 18:16:01','2017-05-28 18:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1233,8,'2017-05-28 18:17:01','2017-05-28 18:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1234,8,'2017-05-28 18:18:01','2017-05-28 18:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1235,8,'2017-05-28 18:19:01','2017-05-28 18:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1236,8,'2017-05-28 18:20:01','2017-05-28 18:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1237,8,'2017-05-28 18:21:01','2017-05-28 18:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1238,8,'2017-05-28 18:22:01','2017-05-28 18:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1239,8,'2017-05-28 18:23:01','2017-05-28 18:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1240,8,'2017-05-28 18:24:01','2017-05-28 18:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1241,8,'2017-05-28 18:25:01','2017-05-28 18:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1242,8,'2017-05-28 18:26:01','2017-05-28 18:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1243,8,'2017-05-28 18:27:01','2017-05-28 18:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1244,8,'2017-05-28 18:28:01','2017-05-28 18:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1245,8,'2017-05-28 18:29:01','2017-05-28 18:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1246,8,'2017-05-28 18:30:01','2017-05-28 18:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1247,8,'2017-05-28 18:31:01','2017-05-28 18:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1248,8,'2017-05-28 18:32:01','2017-05-28 18:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1249,8,'2017-05-28 18:33:01','2017-05-28 18:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1250,8,'2017-05-28 18:34:01','2017-05-28 18:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1251,8,'2017-05-28 18:35:01','2017-05-28 18:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1252,8,'2017-05-28 18:36:01','2017-05-28 18:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1253,8,'2017-05-28 18:37:01','2017-05-28 18:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1254,8,'2017-05-28 18:38:01','2017-05-28 18:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1255,8,'2017-05-28 18:39:01','2017-05-28 18:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1256,8,'2017-05-28 18:40:01','2017-05-28 18:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1257,8,'2017-05-28 18:41:01','2017-05-28 18:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1258,8,'2017-05-28 18:42:02','2017-05-28 18:42:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1259,8,'2017-05-28 18:43:01','2017-05-28 18:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1260,8,'2017-05-28 18:44:01','2017-05-28 18:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1261,8,'2017-05-28 18:45:01','2017-05-28 18:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1262,8,'2017-05-28 18:46:01','2017-05-28 18:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1263,8,'2017-05-28 18:47:02','2017-05-28 18:47:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1264,8,'2017-05-28 18:48:01','2017-05-28 18:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1265,8,'2017-05-28 18:49:01','2017-05-28 18:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1266,8,'2017-05-28 18:50:02','2017-05-28 18:50:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1267,8,'2017-05-28 18:51:01','2017-05-28 18:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1268,8,'2017-05-28 18:52:01','2017-05-28 18:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1269,8,'2017-05-28 18:53:01','2017-05-28 18:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1270,8,'2017-05-28 18:54:02','2017-05-28 18:54:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1271,8,'2017-05-28 18:55:01','2017-05-28 18:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1272,8,'2017-05-28 18:56:01','2017-05-28 18:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1273,8,'2017-05-28 18:57:01','2017-05-28 18:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1274,8,'2017-05-28 18:58:01','2017-05-28 18:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1275,8,'2017-05-28 18:59:01','2017-05-28 18:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1276,8,'2017-05-28 19:00:01','2017-05-28 19:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1277,8,'2017-05-28 19:01:01','2017-05-28 19:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1278,8,'2017-05-28 19:02:02','2017-05-28 19:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1279,8,'2017-05-28 19:03:01','2017-05-28 19:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1280,8,'2017-05-28 19:04:01','2017-05-28 19:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1281,8,'2017-05-28 19:05:01','2017-05-28 19:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1282,8,'2017-05-28 19:06:01','2017-05-28 19:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1283,8,'2017-05-28 19:07:01','2017-05-28 19:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1284,8,'2017-05-28 19:08:01','2017-05-28 19:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1285,8,'2017-05-28 19:09:01','2017-05-28 19:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1286,8,'2017-05-28 19:10:01','2017-05-28 19:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1287,8,'2017-05-28 19:11:01','2017-05-28 19:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1288,8,'2017-05-28 19:12:01','2017-05-28 19:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1289,8,'2017-05-28 19:13:01','2017-05-28 19:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1290,8,'2017-05-28 19:14:01','2017-05-28 19:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1291,8,'2017-05-28 19:15:01','2017-05-28 19:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1292,8,'2017-05-28 19:16:02','2017-05-28 19:16:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1293,8,'2017-05-28 19:17:01','2017-05-28 19:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1294,8,'2017-05-28 19:18:01','2017-05-28 19:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1295,8,'2017-05-28 19:19:01','2017-05-28 19:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1296,8,'2017-05-28 19:20:02','2017-05-28 19:20:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1297,8,'2017-05-28 19:21:01','2017-05-28 19:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1298,8,'2017-05-28 19:22:01','2017-05-28 19:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1299,8,'2017-05-28 19:23:01','2017-05-28 19:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1300,8,'2017-05-28 19:24:01','2017-05-28 19:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1301,8,'2017-05-28 19:25:01','2017-05-28 19:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1302,8,'2017-05-28 19:26:01','2017-05-28 19:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1303,8,'2017-05-28 19:27:01','2017-05-28 19:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1304,8,'2017-05-28 19:28:01','2017-05-28 19:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1305,8,'2017-05-28 19:29:01','2017-05-28 19:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1306,8,'2017-05-28 19:30:01','2017-05-28 19:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1307,8,'2017-05-28 19:31:01','2017-05-28 19:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1308,8,'2017-05-28 19:32:01','2017-05-28 19:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1309,8,'2017-05-28 19:33:01','2017-05-28 19:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1310,8,'2017-05-28 19:34:01','2017-05-28 19:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1311,8,'2017-05-28 19:35:01','2017-05-28 19:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1312,8,'2017-05-28 19:36:01','2017-05-28 19:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1313,8,'2017-05-28 19:37:01','2017-05-28 19:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1314,8,'2017-05-28 19:38:01','2017-05-28 19:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1315,8,'2017-05-28 19:39:01','2017-05-28 19:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1316,8,'2017-05-28 19:40:01','2017-05-28 19:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1317,8,'2017-05-28 19:41:01','2017-05-28 19:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1318,8,'2017-05-28 19:42:01','2017-05-28 19:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1319,8,'2017-05-28 19:43:01','2017-05-28 19:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1320,8,'2017-05-28 19:44:01','2017-05-28 19:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1321,8,'2017-05-28 19:45:01','2017-05-28 19:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1322,8,'2017-05-28 19:46:01','2017-05-28 19:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1323,8,'2017-05-28 19:47:01','2017-05-28 19:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1324,8,'2017-05-28 19:48:01','2017-05-28 19:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1325,8,'2017-05-28 19:49:01','2017-05-28 19:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1326,8,'2017-05-28 19:50:01','2017-05-28 19:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1327,8,'2017-05-28 19:51:01','2017-05-28 19:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1328,8,'2017-05-28 19:52:01','2017-05-28 19:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1329,8,'2017-05-28 19:53:01','2017-05-28 19:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1330,8,'2017-05-28 19:54:01','2017-05-28 19:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1331,8,'2017-05-28 19:55:01','2017-05-28 19:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1332,8,'2017-05-28 19:56:01','2017-05-28 19:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1333,8,'2017-05-28 19:57:02','2017-05-28 19:57:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1334,8,'2017-05-28 19:58:01','2017-05-28 19:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1335,8,'2017-05-28 19:59:01','2017-05-28 19:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1336,8,'2017-05-28 20:00:01','2017-05-28 20:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1337,8,'2017-05-28 20:01:02','2017-05-28 20:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1338,8,'2017-05-28 20:02:01','2017-05-28 20:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1339,8,'2017-05-28 20:03:01','2017-05-28 20:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1340,8,'2017-05-28 20:04:02','2017-05-28 20:04:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1341,8,'2017-05-28 20:05:01','2017-05-28 20:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1342,8,'2017-05-28 20:06:01','2017-05-28 20:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1343,8,'2017-05-28 20:07:01','2017-05-28 20:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1344,8,'2017-05-28 20:08:01','2017-05-28 20:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1345,8,'2017-05-28 20:09:01','2017-05-28 20:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1346,8,'2017-05-28 20:10:01','2017-05-28 20:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1347,8,'2017-05-28 20:11:01','2017-05-28 20:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1348,8,'2017-05-28 20:12:01','2017-05-28 20:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1349,8,'2017-05-28 20:13:01','2017-05-28 20:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1350,8,'2017-05-28 20:14:02','2017-05-28 20:14:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1351,8,'2017-05-28 20:15:01','2017-05-28 20:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1352,8,'2017-05-28 20:16:01','2017-05-28 20:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1353,8,'2017-05-28 20:17:02','2017-05-28 20:17:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1354,8,'2017-05-28 20:18:01','2017-05-28 20:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1355,8,'2017-05-28 20:19:01','2017-05-28 20:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1356,8,'2017-05-28 20:20:01','2017-05-28 20:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1357,8,'2017-05-28 20:21:01','2017-05-28 20:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1358,8,'2017-05-28 20:22:02','2017-05-28 20:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1359,8,'2017-05-28 20:23:01','2017-05-28 20:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1360,8,'2017-05-28 20:24:01','2017-05-28 20:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1361,8,'2017-05-28 20:25:01','2017-05-28 20:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1362,8,'2017-05-28 20:26:01','2017-05-28 20:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1363,8,'2017-05-28 20:27:01','2017-05-28 20:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1364,8,'2017-05-28 20:28:01','2017-05-28 20:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1365,8,'2017-05-28 20:29:01','2017-05-28 20:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1366,8,'2017-05-28 20:30:01','2017-05-28 20:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1367,8,'2017-05-28 20:31:01','2017-05-28 20:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1368,8,'2017-05-28 20:32:02','2017-05-28 20:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1369,8,'2017-05-28 20:33:01','2017-05-28 20:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1370,8,'2017-05-28 20:34:01','2017-05-28 20:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1371,8,'2017-05-28 20:35:01','2017-05-28 20:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1372,8,'2017-05-28 20:36:01','2017-05-28 20:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1373,8,'2017-05-28 20:37:01','2017-05-28 20:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1374,8,'2017-05-28 20:38:01','2017-05-28 20:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1375,8,'2017-05-28 20:39:01','2017-05-28 20:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1376,8,'2017-05-28 20:40:01','2017-05-28 20:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1377,8,'2017-05-28 20:41:01','2017-05-28 20:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1378,8,'2017-05-28 20:42:01','2017-05-28 20:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1379,8,'2017-05-28 20:43:01','2017-05-28 20:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1380,8,'2017-05-28 20:44:01','2017-05-28 20:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1381,8,'2017-05-28 20:45:01','2017-05-28 20:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1382,8,'2017-05-28 20:46:01','2017-05-28 20:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1383,8,'2017-05-28 20:47:01','2017-05-28 20:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1384,8,'2017-05-28 20:48:01','2017-05-28 20:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1385,8,'2017-05-28 20:49:01','2017-05-28 20:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1386,8,'2017-05-28 20:50:01','2017-05-28 20:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1387,8,'2017-05-28 20:51:01','2017-05-28 20:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1388,8,'2017-05-28 20:52:01','2017-05-28 20:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1389,8,'2017-05-28 20:53:01','2017-05-28 20:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1390,8,'2017-05-28 20:54:01','2017-05-28 20:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1391,8,'2017-05-28 20:55:01','2017-05-28 20:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1392,8,'2017-05-28 20:56:01','2017-05-28 20:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1393,8,'2017-05-28 20:57:01','2017-05-28 20:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1394,8,'2017-05-28 20:58:01','2017-05-28 20:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1395,8,'2017-05-28 20:59:01','2017-05-28 20:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1396,8,'2017-05-28 21:00:01','2017-05-28 21:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1397,8,'2017-05-28 21:01:02','2017-05-28 21:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1398,8,'2017-05-28 21:02:01','2017-05-28 21:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1399,8,'2017-05-28 21:03:01','2017-05-28 21:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1400,8,'2017-05-28 21:04:01','2017-05-28 21:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1401,8,'2017-05-28 21:05:01','2017-05-28 21:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1402,8,'2017-05-28 21:06:01','2017-05-28 21:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1403,8,'2017-05-28 21:07:01','2017-05-28 21:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1404,8,'2017-05-28 21:08:01','2017-05-28 21:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1405,8,'2017-05-28 21:09:01','2017-05-28 21:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1406,8,'2017-05-28 21:10:01','2017-05-28 21:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1407,8,'2017-05-28 21:11:01','2017-05-28 21:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1408,8,'2017-05-28 21:12:01','2017-05-28 21:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1409,8,'2017-05-28 21:13:01','2017-05-28 21:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1410,8,'2017-05-28 21:14:01','2017-05-28 21:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1411,8,'2017-05-28 21:15:01','2017-05-28 21:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1412,8,'2017-05-28 21:16:01','2017-05-28 21:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1413,8,'2017-05-28 21:17:01','2017-05-28 21:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1414,8,'2017-05-28 21:18:01','2017-05-28 21:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1415,8,'2017-05-28 21:19:01','2017-05-28 21:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1416,8,'2017-05-28 21:20:02','2017-05-28 21:20:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1417,8,'2017-05-28 21:21:01','2017-05-28 21:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1418,8,'2017-05-28 21:22:01','2017-05-28 21:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1419,8,'2017-05-28 21:23:01','2017-05-28 21:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1420,8,'2017-05-28 21:24:01','2017-05-28 21:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1421,8,'2017-05-28 21:25:01','2017-05-28 21:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1422,8,'2017-05-28 21:26:01','2017-05-28 21:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1423,8,'2017-05-28 21:27:01','2017-05-28 21:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1424,8,'2017-05-28 21:28:01','2017-05-28 21:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1425,8,'2017-05-28 21:29:01','2017-05-28 21:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1426,8,'2017-05-28 21:30:01','2017-05-28 21:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1427,8,'2017-05-28 21:31:01','2017-05-28 21:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1428,8,'2017-05-28 21:32:01','2017-05-28 21:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1429,8,'2017-05-28 21:33:01','2017-05-28 21:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1430,8,'2017-05-28 21:34:02','2017-05-28 21:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1431,8,'2017-05-28 21:35:01','2017-05-28 21:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1432,8,'2017-05-28 21:36:01','2017-05-28 21:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1433,8,'2017-05-28 21:37:01','2017-05-28 21:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1434,8,'2017-05-28 21:38:01','2017-05-28 21:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1435,8,'2017-05-28 21:39:01','2017-05-28 21:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1436,8,'2017-05-28 21:40:01','2017-05-28 21:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1437,8,'2017-05-28 21:41:01','2017-05-28 21:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1438,8,'2017-05-28 21:42:02','2017-05-28 21:42:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1439,8,'2017-05-28 21:43:01','2017-05-28 21:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1440,8,'2017-05-28 21:44:01','2017-05-28 21:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1441,8,'2017-05-28 21:45:01','2017-05-28 21:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1442,8,'2017-05-28 21:46:01','2017-05-28 21:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1443,8,'2017-05-28 21:47:01','2017-05-28 21:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1444,8,'2017-05-28 21:48:01','2017-05-28 21:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1445,8,'2017-05-28 21:49:01','2017-05-28 21:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1446,8,'2017-05-28 21:50:01','2017-05-28 21:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1447,8,'2017-05-28 21:51:01','2017-05-28 21:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1448,8,'2017-05-28 21:52:01','2017-05-28 21:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1449,8,'2017-05-28 21:53:01','2017-05-28 21:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1450,8,'2017-05-28 21:54:01','2017-05-28 21:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1451,8,'2017-05-28 21:55:01','2017-05-28 21:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1452,8,'2017-05-28 21:56:01','2017-05-28 21:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1453,8,'2017-05-28 21:57:01','2017-05-28 21:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1454,8,'2017-05-28 21:58:01','2017-05-28 21:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1455,8,'2017-05-28 21:59:01','2017-05-28 21:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1456,8,'2017-05-28 22:00:01','2017-05-28 22:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1457,8,'2017-05-28 22:01:01','2017-05-28 22:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1458,8,'2017-05-28 22:02:01','2017-05-28 22:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1459,8,'2017-05-28 22:03:01','2017-05-28 22:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1460,8,'2017-05-28 22:04:01','2017-05-28 22:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1461,8,'2017-05-28 22:05:01','2017-05-28 22:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1462,8,'2017-05-28 22:06:01','2017-05-28 22:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1463,8,'2017-05-28 22:07:01','2017-05-28 22:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1464,8,'2017-05-28 22:08:01','2017-05-28 22:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1465,8,'2017-05-28 22:09:01','2017-05-28 22:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1466,8,'2017-05-28 22:10:01','2017-05-28 22:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1467,8,'2017-05-28 22:11:02','2017-05-28 22:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1468,8,'2017-05-28 22:12:01','2017-05-28 22:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1469,8,'2017-05-28 22:13:01','2017-05-28 22:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1470,8,'2017-05-28 22:14:01','2017-05-28 22:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1471,8,'2017-05-28 22:15:01','2017-05-28 22:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1472,8,'2017-05-28 22:16:01','2017-05-28 22:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1473,8,'2017-05-28 22:17:01','2017-05-28 22:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1474,8,'2017-05-28 22:18:01','2017-05-28 22:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1475,8,'2017-05-28 22:19:01','2017-05-28 22:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1476,8,'2017-05-28 22:20:01','2017-05-28 22:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1477,8,'2017-05-28 22:21:02','2017-05-28 22:21:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1478,8,'2017-05-28 22:22:01','2017-05-28 22:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1479,8,'2017-05-28 22:23:01','2017-05-28 22:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1480,8,'2017-05-28 22:24:01','2017-05-28 22:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1481,8,'2017-05-28 22:25:02','2017-05-28 22:25:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1482,8,'2017-05-28 22:26:01','2017-05-28 22:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1483,8,'2017-05-28 22:27:01','2017-05-28 22:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1484,8,'2017-05-28 22:28:02','2017-05-28 22:28:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1485,8,'2017-05-28 22:29:01','2017-05-28 22:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1486,8,'2017-05-28 22:30:02','2017-05-28 22:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1487,8,'2017-05-28 22:31:01','2017-05-28 22:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1488,8,'2017-05-28 22:32:01','2017-05-28 22:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1489,8,'2017-05-28 22:33:01','2017-05-28 22:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1490,8,'2017-05-28 22:34:01','2017-05-28 22:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1491,8,'2017-05-28 22:35:01','2017-05-28 22:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1492,8,'2017-05-28 22:36:01','2017-05-28 22:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1493,8,'2017-05-28 22:37:01','2017-05-28 22:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1494,8,'2017-05-28 22:38:01','2017-05-28 22:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1495,8,'2017-05-28 22:39:01','2017-05-28 22:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1496,8,'2017-05-28 22:40:02','2017-05-28 22:40:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1497,8,'2017-05-28 22:41:01','2017-05-28 22:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1498,8,'2017-05-28 22:42:01','2017-05-28 22:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1499,8,'2017-05-28 22:43:01','2017-05-28 22:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1500,8,'2017-05-28 22:44:01','2017-05-28 22:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1501,8,'2017-05-28 22:45:01','2017-05-28 22:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1502,8,'2017-05-28 22:46:01','2017-05-28 22:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1503,8,'2017-05-28 22:47:01','2017-05-28 22:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1504,8,'2017-05-28 22:48:01','2017-05-28 22:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1505,8,'2017-05-28 22:49:01','2017-05-28 22:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1506,8,'2017-05-28 22:50:01','2017-05-28 22:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1507,8,'2017-05-28 22:51:01','2017-05-28 22:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1508,8,'2017-05-28 22:52:01','2017-05-28 22:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1509,8,'2017-05-28 22:53:01','2017-05-28 22:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1510,8,'2017-05-28 22:54:01','2017-05-28 22:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1511,8,'2017-05-28 22:55:01','2017-05-28 22:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1512,8,'2017-05-28 22:56:02','2017-05-28 22:56:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1513,8,'2017-05-28 22:57:01','2017-05-28 22:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1514,8,'2017-05-28 22:58:01','2017-05-28 22:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1515,8,'2017-05-28 22:59:01','2017-05-28 22:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1516,8,'2017-05-28 23:00:02','2017-05-28 23:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1517,8,'2017-05-28 23:01:01','2017-05-28 23:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1518,8,'2017-05-28 23:02:02','2017-05-28 23:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1519,8,'2017-05-28 23:03:01','2017-05-28 23:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1520,8,'2017-05-28 23:04:01','2017-05-28 23:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1521,8,'2017-05-28 23:05:01','2017-05-28 23:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1522,8,'2017-05-28 23:06:01','2017-05-28 23:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1523,8,'2017-05-28 23:07:01','2017-05-28 23:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1524,8,'2017-05-28 23:08:01','2017-05-28 23:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1525,8,'2017-05-28 23:09:01','2017-05-28 23:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1526,8,'2017-05-28 23:10:01','2017-05-28 23:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1527,8,'2017-05-28 23:11:01','2017-05-28 23:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1528,8,'2017-05-28 23:12:01','2017-05-28 23:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1529,8,'2017-05-28 23:13:01','2017-05-28 23:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1530,8,'2017-05-28 23:14:01','2017-05-28 23:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1531,8,'2017-05-28 23:15:01','2017-05-28 23:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1532,8,'2017-05-28 23:16:01','2017-05-28 23:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1533,8,'2017-05-28 23:17:01','2017-05-28 23:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1534,8,'2017-05-28 23:18:01','2017-05-28 23:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1535,8,'2017-05-28 23:19:01','2017-05-28 23:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1536,8,'2017-05-28 23:20:01','2017-05-28 23:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1537,8,'2017-05-28 23:21:01','2017-05-28 23:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1538,8,'2017-05-28 23:22:02','2017-05-28 23:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1539,8,'2017-05-28 23:23:01','2017-05-28 23:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1540,8,'2017-05-28 23:24:01','2017-05-28 23:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1541,8,'2017-05-28 23:25:01','2017-05-28 23:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1542,8,'2017-05-28 23:26:01','2017-05-28 23:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1543,8,'2017-05-28 23:27:01','2017-05-28 23:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1544,8,'2017-05-28 23:28:01','2017-05-28 23:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1545,8,'2017-05-28 23:29:01','2017-05-28 23:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1546,8,'2017-05-28 23:30:01','2017-05-28 23:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1547,8,'2017-05-28 23:31:01','2017-05-28 23:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1548,8,'2017-05-28 23:32:02','2017-05-28 23:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1549,8,'2017-05-28 23:33:02','2017-05-28 23:33:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1550,8,'2017-05-28 23:34:01','2017-05-28 23:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1551,8,'2017-05-28 23:35:01','2017-05-28 23:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1552,8,'2017-05-28 23:36:01','2017-05-28 23:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1553,8,'2017-05-28 23:37:01','2017-05-28 23:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1554,8,'2017-05-28 23:38:01','2017-05-28 23:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1555,8,'2017-05-28 23:39:01','2017-05-28 23:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1556,8,'2017-05-28 23:40:01','2017-05-28 23:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1557,8,'2017-05-28 23:41:01','2017-05-28 23:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1558,8,'2017-05-28 23:42:01','2017-05-28 23:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1559,8,'2017-05-28 23:43:01','2017-05-28 23:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1560,8,'2017-05-28 23:44:01','2017-05-28 23:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1561,8,'2017-05-28 23:45:01','2017-05-28 23:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1562,8,'2017-05-28 23:46:01','2017-05-28 23:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1563,8,'2017-05-28 23:47:01','2017-05-28 23:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1564,8,'2017-05-28 23:48:01','2017-05-28 23:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1565,8,'2017-05-28 23:49:01','2017-05-28 23:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1566,8,'2017-05-28 23:50:02','2017-05-28 23:50:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1567,8,'2017-05-28 23:51:01','2017-05-28 23:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1568,8,'2017-05-28 23:52:01','2017-05-28 23:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1569,8,'2017-05-28 23:53:01','2017-05-28 23:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1570,8,'2017-05-28 23:54:01','2017-05-28 23:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1571,8,'2017-05-28 23:55:01','2017-05-28 23:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1572,8,'2017-05-28 23:56:02','2017-05-28 23:56:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1573,8,'2017-05-28 23:57:01','2017-05-28 23:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1574,8,'2017-05-28 23:58:01','2017-05-28 23:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1575,8,'2017-05-28 23:59:01','2017-05-28 23:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1576,8,'2017-05-29 00:00:01','2017-05-29 00:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1577,8,'2017-05-29 00:01:01','2017-05-29 00:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1578,8,'2017-05-29 00:02:01','2017-05-29 00:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1579,8,'2017-05-29 00:03:02','2017-05-29 00:03:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1580,8,'2017-05-29 00:04:01','2017-05-29 00:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1581,8,'2017-05-29 00:05:01','2017-05-29 00:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1582,8,'2017-05-29 00:06:01','2017-05-29 00:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1583,8,'2017-05-29 00:07:01','2017-05-29 00:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1584,8,'2017-05-29 00:08:01','2017-05-29 00:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1585,8,'2017-05-29 00:09:01','2017-05-29 00:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1586,8,'2017-05-29 00:10:01','2017-05-29 00:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1587,8,'2017-05-29 00:11:01','2017-05-29 00:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1588,8,'2017-05-29 00:12:01','2017-05-29 00:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1589,8,'2017-05-29 00:13:01','2017-05-29 00:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1590,8,'2017-05-29 00:14:01','2017-05-29 00:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1591,8,'2017-05-29 00:15:02','2017-05-29 00:15:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1592,8,'2017-05-29 00:16:01','2017-05-29 00:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1593,8,'2017-05-29 00:17:01','2017-05-29 00:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1594,8,'2017-05-29 00:18:01','2017-05-29 00:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1595,8,'2017-05-29 00:19:01','2017-05-29 00:19:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1596,8,'2017-05-29 00:20:01','2017-05-29 00:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1597,8,'2017-05-29 00:21:01','2017-05-29 00:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1598,8,'2017-05-29 00:22:01','2017-05-29 00:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1599,8,'2017-05-29 00:23:01','2017-05-29 00:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1600,8,'2017-05-29 00:24:01','2017-05-29 00:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1601,8,'2017-05-29 00:25:01','2017-05-29 00:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1602,8,'2017-05-29 00:26:01','2017-05-29 00:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1603,8,'2017-05-29 00:27:01','2017-05-29 00:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1604,8,'2017-05-29 00:28:01','2017-05-29 00:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1605,8,'2017-05-29 00:29:01','2017-05-29 00:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1606,8,'2017-05-29 00:30:02','2017-05-29 00:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1607,8,'2017-05-29 00:31:04','2017-05-29 00:31:04','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1608,8,'2017-05-29 00:32:01','2017-05-29 00:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1609,8,'2017-05-29 00:33:01','2017-05-29 00:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1610,8,'2017-05-29 00:34:01','2017-05-29 00:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1611,8,'2017-05-29 00:35:01','2017-05-29 00:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1612,8,'2017-05-29 00:36:01','2017-05-29 00:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1613,8,'2017-05-29 00:37:01','2017-05-29 00:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1614,8,'2017-05-29 00:38:01','2017-05-29 00:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1615,8,'2017-05-29 00:39:02','2017-05-29 00:39:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1616,8,'2017-05-29 00:40:01','2017-05-29 00:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1617,8,'2017-05-29 00:41:01','2017-05-29 00:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1618,8,'2017-05-29 00:42:01','2017-05-29 00:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1619,8,'2017-05-29 00:43:01','2017-05-29 00:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1620,8,'2017-05-29 00:44:01','2017-05-29 00:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1621,8,'2017-05-29 00:45:01','2017-05-29 00:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1622,8,'2017-05-29 00:46:01','2017-05-29 00:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1623,8,'2017-05-29 00:47:01','2017-05-29 00:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1624,8,'2017-05-29 00:48:01','2017-05-29 00:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1625,8,'2017-05-29 00:49:01','2017-05-29 00:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1626,8,'2017-05-29 00:50:01','2017-05-29 00:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1627,8,'2017-05-29 00:51:02','2017-05-29 00:51:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1628,8,'2017-05-29 00:52:01','2017-05-29 00:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1629,8,'2017-05-29 00:53:01','2017-05-29 00:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1630,8,'2017-05-29 00:54:01','2017-05-29 00:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1631,8,'2017-05-29 00:55:01','2017-05-29 00:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1632,8,'2017-05-29 00:56:01','2017-05-29 00:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1633,8,'2017-05-29 00:57:01','2017-05-29 00:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1634,8,'2017-05-29 00:58:01','2017-05-29 00:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1635,8,'2017-05-29 00:59:01','2017-05-29 00:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1636,8,'2017-05-29 01:00:01','2017-05-29 01:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1637,8,'2017-05-29 01:01:01','2017-05-29 01:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1638,8,'2017-05-29 01:02:01','2017-05-29 01:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1639,8,'2017-05-29 01:03:01','2017-05-29 01:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1640,8,'2017-05-29 01:04:01','2017-05-29 01:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1641,8,'2017-05-29 01:05:01','2017-05-29 01:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1642,8,'2017-05-29 01:06:01','2017-05-29 01:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1643,8,'2017-05-29 01:07:01','2017-05-29 01:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1644,8,'2017-05-29 01:08:02','2017-05-29 01:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1645,8,'2017-05-29 01:09:01','2017-05-29 01:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1646,8,'2017-05-29 01:10:01','2017-05-29 01:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1647,8,'2017-05-29 01:11:01','2017-05-29 01:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1648,8,'2017-05-29 01:12:01','2017-05-29 01:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1649,8,'2017-05-29 01:13:01','2017-05-29 01:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1650,8,'2017-05-29 01:14:01','2017-05-29 01:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1651,8,'2017-05-29 01:15:01','2017-05-29 01:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1652,8,'2017-05-29 01:16:01','2017-05-29 01:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1653,8,'2017-05-29 01:17:01','2017-05-29 01:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1654,8,'2017-05-29 01:18:02','2017-05-29 01:18:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1655,8,'2017-05-29 01:19:01','2017-05-29 01:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1656,8,'2017-05-29 01:20:01','2017-05-29 01:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1657,8,'2017-05-29 01:21:01','2017-05-29 01:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1658,8,'2017-05-29 01:22:01','2017-05-29 01:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1659,8,'2017-05-29 01:23:01','2017-05-29 01:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1660,8,'2017-05-29 01:24:01','2017-05-29 01:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1661,8,'2017-05-29 01:25:01','2017-05-29 01:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1662,8,'2017-05-29 01:26:01','2017-05-29 01:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1663,8,'2017-05-29 01:27:01','2017-05-29 01:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1664,8,'2017-05-29 01:28:01','2017-05-29 01:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1665,8,'2017-05-29 01:29:01','2017-05-29 01:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1666,8,'2017-05-29 01:30:01','2017-05-29 01:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1667,8,'2017-05-29 01:31:01','2017-05-29 01:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1668,8,'2017-05-29 01:32:01','2017-05-29 01:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1669,8,'2017-05-29 01:33:01','2017-05-29 01:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1670,8,'2017-05-29 01:34:01','2017-05-29 01:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1671,8,'2017-05-29 01:35:01','2017-05-29 01:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1672,8,'2017-05-29 01:36:01','2017-05-29 01:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1673,8,'2017-05-29 01:37:01','2017-05-29 01:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1674,8,'2017-05-29 01:38:02','2017-05-29 01:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1675,8,'2017-05-29 01:39:01','2017-05-29 01:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1676,8,'2017-05-29 01:40:01','2017-05-29 01:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1677,8,'2017-05-29 01:41:01','2017-05-29 01:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1678,8,'2017-05-29 01:42:01','2017-05-29 01:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1679,8,'2017-05-29 01:43:01','2017-05-29 01:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1680,8,'2017-05-29 01:44:01','2017-05-29 01:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1681,8,'2017-05-29 01:45:01','2017-05-29 01:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1682,8,'2017-05-29 01:46:01','2017-05-29 01:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1683,8,'2017-05-29 01:47:01','2017-05-29 01:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1684,8,'2017-05-29 01:48:01','2017-05-29 01:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1685,8,'2017-05-29 01:49:01','2017-05-29 01:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1686,8,'2017-05-29 01:50:01','2017-05-29 01:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1687,8,'2017-05-29 01:51:01','2017-05-29 01:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1688,8,'2017-05-29 01:52:01','2017-05-29 01:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1689,8,'2017-05-29 01:53:01','2017-05-29 01:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1690,8,'2017-05-29 01:54:01','2017-05-29 01:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1691,8,'2017-05-29 01:55:01','2017-05-29 01:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1692,8,'2017-05-29 01:56:01','2017-05-29 01:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1693,8,'2017-05-29 01:57:01','2017-05-29 01:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1694,8,'2017-05-29 01:58:01','2017-05-29 01:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1695,8,'2017-05-29 01:59:01','2017-05-29 01:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1696,8,'2017-05-29 02:00:01','2017-05-29 02:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1697,8,'2017-05-29 02:01:01','2017-05-29 02:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1698,8,'2017-05-29 02:02:01','2017-05-29 02:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1699,8,'2017-05-29 02:03:02','2017-05-29 02:03:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1700,8,'2017-05-29 02:04:01','2017-05-29 02:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1701,8,'2017-05-29 02:05:01','2017-05-29 02:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1702,8,'2017-05-29 02:06:01','2017-05-29 02:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1703,8,'2017-05-29 02:07:01','2017-05-29 02:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1704,8,'2017-05-29 02:08:02','2017-05-29 02:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1705,8,'2017-05-29 02:09:01','2017-05-29 02:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1706,8,'2017-05-29 02:10:01','2017-05-29 02:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1707,8,'2017-05-29 02:11:01','2017-05-29 02:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1708,8,'2017-05-29 02:12:01','2017-05-29 02:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1709,8,'2017-05-29 02:13:01','2017-05-29 02:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1710,8,'2017-05-29 02:14:01','2017-05-29 02:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1711,8,'2017-05-29 02:15:02','2017-05-29 02:15:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1712,8,'2017-05-29 02:16:01','2017-05-29 02:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1713,8,'2017-05-29 02:17:01','2017-05-29 02:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1714,8,'2017-05-29 02:18:01','2017-05-29 02:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1715,8,'2017-05-29 02:19:01','2017-05-29 02:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1716,8,'2017-05-29 02:20:02','2017-05-29 02:20:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1717,8,'2017-05-29 02:21:01','2017-05-29 02:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1718,8,'2017-05-29 02:22:01','2017-05-29 02:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1719,8,'2017-05-29 02:23:02','2017-05-29 02:23:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1720,8,'2017-05-29 02:24:01','2017-05-29 02:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1721,8,'2017-05-29 02:25:01','2017-05-29 02:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1722,8,'2017-05-29 02:26:01','2017-05-29 02:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1723,8,'2017-05-29 02:27:01','2017-05-29 02:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1724,8,'2017-05-29 02:28:01','2017-05-29 02:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1725,8,'2017-05-29 02:29:01','2017-05-29 02:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1726,8,'2017-05-29 02:30:01','2017-05-29 02:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1727,8,'2017-05-29 02:31:01','2017-05-29 02:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1728,8,'2017-05-29 02:32:01','2017-05-29 02:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1729,8,'2017-05-29 02:33:01','2017-05-29 02:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1730,8,'2017-05-29 02:34:01','2017-05-29 02:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1731,8,'2017-05-29 02:35:01','2017-05-29 02:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1732,8,'2017-05-29 02:36:01','2017-05-29 02:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1733,8,'2017-05-29 02:37:01','2017-05-29 02:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1734,8,'2017-05-29 02:38:01','2017-05-29 02:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1735,8,'2017-05-29 02:39:01','2017-05-29 02:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1736,8,'2017-05-29 02:40:01','2017-05-29 02:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1737,8,'2017-05-29 02:41:01','2017-05-29 02:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1738,8,'2017-05-29 02:42:01','2017-05-29 02:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1739,8,'2017-05-29 02:43:01','2017-05-29 02:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1740,8,'2017-05-29 02:44:01','2017-05-29 02:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1741,8,'2017-05-29 02:45:01','2017-05-29 02:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1742,8,'2017-05-29 02:46:01','2017-05-29 02:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1743,8,'2017-05-29 02:47:02','2017-05-29 02:47:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1744,8,'2017-05-29 02:48:01','2017-05-29 02:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1745,8,'2017-05-29 02:49:01','2017-05-29 02:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1746,8,'2017-05-29 02:50:01','2017-05-29 02:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1747,8,'2017-05-29 02:51:01','2017-05-29 02:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1748,8,'2017-05-29 02:52:01','2017-05-29 02:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1749,8,'2017-05-29 02:53:01','2017-05-29 02:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1750,8,'2017-05-29 02:54:01','2017-05-29 02:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1751,8,'2017-05-29 02:55:01','2017-05-29 02:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1752,8,'2017-05-29 02:56:01','2017-05-29 02:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1753,8,'2017-05-29 02:57:01','2017-05-29 02:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1754,8,'2017-05-29 02:58:01','2017-05-29 02:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1755,8,'2017-05-29 02:59:01','2017-05-29 02:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1756,8,'2017-05-29 03:00:01','2017-05-29 03:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1757,8,'2017-05-29 03:01:01','2017-05-29 03:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1758,8,'2017-05-29 03:02:01','2017-05-29 03:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1759,8,'2017-05-29 03:03:02','2017-05-29 03:03:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1760,8,'2017-05-29 03:04:01','2017-05-29 03:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1761,8,'2017-05-29 03:05:01','2017-05-29 03:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1762,8,'2017-05-29 03:06:01','2017-05-29 03:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1763,8,'2017-05-29 03:07:01','2017-05-29 03:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1764,8,'2017-05-29 03:08:01','2017-05-29 03:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1765,8,'2017-05-29 03:09:01','2017-05-29 03:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1766,8,'2017-05-29 03:10:01','2017-05-29 03:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1767,8,'2017-05-29 03:11:01','2017-05-29 03:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1768,8,'2017-05-29 03:12:01','2017-05-29 03:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1769,8,'2017-05-29 03:13:01','2017-05-29 03:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1770,8,'2017-05-29 03:14:01','2017-05-29 03:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1771,8,'2017-05-29 03:15:01','2017-05-29 03:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1772,8,'2017-05-29 03:16:01','2017-05-29 03:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1773,8,'2017-05-29 03:17:01','2017-05-29 03:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1774,8,'2017-05-29 03:18:01','2017-05-29 03:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1775,8,'2017-05-29 03:19:01','2017-05-29 03:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1776,8,'2017-05-29 03:20:01','2017-05-29 03:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1777,8,'2017-05-29 03:21:02','2017-05-29 03:21:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1778,8,'2017-05-29 03:22:01','2017-05-29 03:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1779,8,'2017-05-29 03:23:01','2017-05-29 03:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1780,8,'2017-05-29 03:24:02','2017-05-29 03:24:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1781,8,'2017-05-29 03:25:01','2017-05-29 03:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1782,8,'2017-05-29 03:26:01','2017-05-29 03:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1783,8,'2017-05-29 03:27:01','2017-05-29 03:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1784,8,'2017-05-29 03:28:01','2017-05-29 03:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1785,8,'2017-05-29 03:29:01','2017-05-29 03:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1786,8,'2017-05-29 03:30:01','2017-05-29 03:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1787,8,'2017-05-29 03:31:01','2017-05-29 03:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1788,8,'2017-05-29 03:32:01','2017-05-29 03:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1789,8,'2017-05-29 03:33:01','2017-05-29 03:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1790,8,'2017-05-29 03:34:01','2017-05-29 03:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1791,8,'2017-05-29 03:35:01','2017-05-29 03:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1792,8,'2017-05-29 03:36:01','2017-05-29 03:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1793,8,'2017-05-29 03:37:01','2017-05-29 03:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1794,8,'2017-05-29 03:38:01','2017-05-29 03:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1795,8,'2017-05-29 03:39:01','2017-05-29 03:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1796,8,'2017-05-29 03:40:01','2017-05-29 03:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1797,8,'2017-05-29 03:41:01','2017-05-29 03:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1798,8,'2017-05-29 03:42:01','2017-05-29 03:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1799,8,'2017-05-29 03:43:01','2017-05-29 03:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1800,8,'2017-05-29 03:44:01','2017-05-29 03:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1801,8,'2017-05-29 03:45:01','2017-05-29 03:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1802,8,'2017-05-29 03:46:01','2017-05-29 03:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1803,8,'2017-05-29 03:47:01','2017-05-29 03:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1804,8,'2017-05-29 03:48:01','2017-05-29 03:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1805,8,'2017-05-29 03:49:02','2017-05-29 03:49:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1806,8,'2017-05-29 03:50:01','2017-05-29 03:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1807,8,'2017-05-29 03:51:01','2017-05-29 03:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1808,8,'2017-05-29 03:52:01','2017-05-29 03:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1809,8,'2017-05-29 03:53:02','2017-05-29 03:53:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1810,8,'2017-05-29 03:54:01','2017-05-29 03:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1811,8,'2017-05-29 03:55:01','2017-05-29 03:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1812,8,'2017-05-29 03:56:01','2017-05-29 03:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1813,8,'2017-05-29 03:57:01','2017-05-29 03:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1814,8,'2017-05-29 03:58:01','2017-05-29 03:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1815,8,'2017-05-29 03:59:01','2017-05-29 03:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1816,8,'2017-05-29 04:00:01','2017-05-29 04:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1817,8,'2017-05-29 04:01:01','2017-05-29 04:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1818,8,'2017-05-29 04:02:01','2017-05-29 04:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1819,8,'2017-05-29 04:03:01','2017-05-29 04:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1820,8,'2017-05-29 04:04:01','2017-05-29 04:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1821,8,'2017-05-29 04:05:01','2017-05-29 04:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1822,8,'2017-05-29 04:06:01','2017-05-29 04:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1823,8,'2017-05-29 04:07:01','2017-05-29 04:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1824,8,'2017-05-29 04:08:01','2017-05-29 04:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1825,8,'2017-05-29 04:09:01','2017-05-29 04:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1826,8,'2017-05-29 04:10:01','2017-05-29 04:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1827,8,'2017-05-29 04:11:01','2017-05-29 04:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1828,8,'2017-05-29 04:12:01','2017-05-29 04:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1829,8,'2017-05-29 04:13:01','2017-05-29 04:13:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1830,8,'2017-05-29 04:14:01','2017-05-29 04:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1831,8,'2017-05-29 04:15:01','2017-05-29 04:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1832,8,'2017-05-29 04:16:01','2017-05-29 04:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1833,8,'2017-05-29 04:17:01','2017-05-29 04:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1834,8,'2017-05-29 04:18:01','2017-05-29 04:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1835,8,'2017-05-29 04:19:01','2017-05-29 04:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1836,8,'2017-05-29 04:20:01','2017-05-29 04:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1837,8,'2017-05-29 04:21:02','2017-05-29 04:21:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1838,8,'2017-05-29 04:22:01','2017-05-29 04:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1839,8,'2017-05-29 04:23:01','2017-05-29 04:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1840,8,'2017-05-29 04:24:01','2017-05-29 04:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1841,8,'2017-05-29 04:25:01','2017-05-29 04:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1842,8,'2017-05-29 04:26:01','2017-05-29 04:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1843,8,'2017-05-29 04:27:01','2017-05-29 04:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1844,8,'2017-05-29 04:28:01','2017-05-29 04:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1845,8,'2017-05-29 04:29:01','2017-05-29 04:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1846,8,'2017-05-29 04:30:02','2017-05-29 04:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1847,8,'2017-05-29 04:31:01','2017-05-29 04:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1848,8,'2017-05-29 04:32:01','2017-05-29 04:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1849,8,'2017-05-29 04:33:01','2017-05-29 04:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1850,8,'2017-05-29 04:34:01','2017-05-29 04:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1851,8,'2017-05-29 04:35:01','2017-05-29 04:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1852,8,'2017-05-29 04:36:01','2017-05-29 04:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1853,8,'2017-05-29 04:37:01','2017-05-29 04:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1854,8,'2017-05-29 04:38:01','2017-05-29 04:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1855,8,'2017-05-29 04:39:01','2017-05-29 04:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1856,8,'2017-05-29 04:40:01','2017-05-29 04:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1857,8,'2017-05-29 04:41:01','2017-05-29 04:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1858,8,'2017-05-29 04:42:01','2017-05-29 04:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1859,8,'2017-05-29 04:43:01','2017-05-29 04:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1860,8,'2017-05-29 04:44:01','2017-05-29 04:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1861,8,'2017-05-29 04:45:01','2017-05-29 04:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1862,8,'2017-05-29 04:46:01','2017-05-29 04:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1863,8,'2017-05-29 04:47:01','2017-05-29 04:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1864,8,'2017-05-29 04:48:01','2017-05-29 04:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1865,8,'2017-05-29 04:49:02','2017-05-29 04:49:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1866,8,'2017-05-29 04:50:01','2017-05-29 04:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1867,8,'2017-05-29 04:51:01','2017-05-29 04:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1868,8,'2017-05-29 04:52:01','2017-05-29 04:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1869,8,'2017-05-29 04:53:01','2017-05-29 04:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1870,8,'2017-05-29 04:54:01','2017-05-29 04:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1871,8,'2017-05-29 04:55:02','2017-05-29 04:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1872,8,'2017-05-29 04:56:01','2017-05-29 04:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1873,8,'2017-05-29 04:57:01','2017-05-29 04:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1874,8,'2017-05-29 04:58:01','2017-05-29 04:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1875,8,'2017-05-29 04:59:01','2017-05-29 04:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1876,8,'2017-05-29 05:00:01','2017-05-29 05:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1877,8,'2017-05-29 05:01:01','2017-05-29 05:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1878,8,'2017-05-29 05:02:01','2017-05-29 05:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1879,8,'2017-05-29 05:03:02','2017-05-29 05:03:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1880,8,'2017-05-29 05:04:01','2017-05-29 05:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1881,8,'2017-05-29 05:05:01','2017-05-29 05:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1882,8,'2017-05-29 05:06:01','2017-05-29 05:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1883,8,'2017-05-29 05:07:01','2017-05-29 05:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1884,8,'2017-05-29 05:08:01','2017-05-29 05:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1885,8,'2017-05-29 05:09:01','2017-05-29 05:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1886,8,'2017-05-29 05:10:01','2017-05-29 05:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1887,8,'2017-05-29 05:11:01','2017-05-29 05:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1888,8,'2017-05-29 05:12:01','2017-05-29 05:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1889,8,'2017-05-29 05:13:01','2017-05-29 05:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1890,8,'2017-05-29 05:14:01','2017-05-29 05:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1891,8,'2017-05-29 05:15:01','2017-05-29 05:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1892,8,'2017-05-29 05:16:01','2017-05-29 05:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1893,8,'2017-05-29 05:17:01','2017-05-29 05:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1894,8,'2017-05-29 05:18:01','2017-05-29 05:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1895,8,'2017-05-29 05:19:01','2017-05-29 05:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1896,8,'2017-05-29 05:20:01','2017-05-29 05:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1897,8,'2017-05-29 05:21:01','2017-05-29 05:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1898,8,'2017-05-29 05:22:01','2017-05-29 05:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1899,8,'2017-05-29 05:23:01','2017-05-29 05:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1900,8,'2017-05-29 05:24:01','2017-05-29 05:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1901,8,'2017-05-29 05:25:01','2017-05-29 05:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1902,8,'2017-05-29 05:26:01','2017-05-29 05:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1903,8,'2017-05-29 05:27:01','2017-05-29 05:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1904,8,'2017-05-29 05:28:01','2017-05-29 05:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1905,8,'2017-05-29 05:29:01','2017-05-29 05:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1906,8,'2017-05-29 05:30:01','2017-05-29 05:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1907,8,'2017-05-29 05:31:01','2017-05-29 05:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1908,8,'2017-05-29 05:32:01','2017-05-29 05:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1909,8,'2017-05-29 05:33:01','2017-05-29 05:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1910,8,'2017-05-29 05:34:01','2017-05-29 05:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1911,8,'2017-05-29 05:35:01','2017-05-29 05:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1912,8,'2017-05-29 05:36:01','2017-05-29 05:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1913,8,'2017-05-29 05:37:01','2017-05-29 05:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1914,8,'2017-05-29 05:38:01','2017-05-29 05:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1915,8,'2017-05-29 05:39:01','2017-05-29 05:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1916,8,'2017-05-29 05:40:01','2017-05-29 05:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1917,8,'2017-05-29 05:41:01','2017-05-29 05:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1918,8,'2017-05-29 05:42:01','2017-05-29 05:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1919,8,'2017-05-29 05:43:01','2017-05-29 05:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1920,8,'2017-05-29 05:44:02','2017-05-29 05:44:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1921,8,'2017-05-29 05:45:01','2017-05-29 05:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1922,8,'2017-05-29 05:46:01','2017-05-29 05:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1923,8,'2017-05-29 05:47:01','2017-05-29 05:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1924,8,'2017-05-29 05:48:01','2017-05-29 05:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1925,8,'2017-05-29 05:49:01','2017-05-29 05:49:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1926,8,'2017-05-29 05:50:01','2017-05-29 05:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1927,8,'2017-05-29 05:51:01','2017-05-29 05:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1928,8,'2017-05-29 05:52:01','2017-05-29 05:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1929,8,'2017-05-29 05:53:01','2017-05-29 05:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1930,8,'2017-05-29 05:54:01','2017-05-29 05:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1931,8,'2017-05-29 05:55:01','2017-05-29 05:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1932,8,'2017-05-29 05:56:01','2017-05-29 05:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1933,8,'2017-05-29 05:57:01','2017-05-29 05:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1934,8,'2017-05-29 05:58:01','2017-05-29 05:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1935,8,'2017-05-29 05:59:01','2017-05-29 05:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1936,8,'2017-05-29 06:00:02','2017-05-29 06:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1937,8,'2017-05-29 06:01:01','2017-05-29 06:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1938,8,'2017-05-29 06:02:01','2017-05-29 06:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1939,8,'2017-05-29 06:03:01','2017-05-29 06:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1940,8,'2017-05-29 06:04:01','2017-05-29 06:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1941,8,'2017-05-29 06:05:01','2017-05-29 06:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1942,8,'2017-05-29 06:06:01','2017-05-29 06:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1943,8,'2017-05-29 06:07:01','2017-05-29 06:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1944,8,'2017-05-29 06:08:01','2017-05-29 06:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1945,8,'2017-05-29 06:09:01','2017-05-29 06:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1946,8,'2017-05-29 06:10:01','2017-05-29 06:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1947,8,'2017-05-29 06:11:01','2017-05-29 06:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1948,8,'2017-05-29 06:12:01','2017-05-29 06:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1949,8,'2017-05-29 06:13:01','2017-05-29 06:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1950,8,'2017-05-29 06:14:01','2017-05-29 06:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1951,8,'2017-05-29 06:15:01','2017-05-29 06:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1952,8,'2017-05-29 06:16:01','2017-05-29 06:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1953,8,'2017-05-29 06:17:01','2017-05-29 06:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1954,8,'2017-05-29 06:18:02','2017-05-29 06:18:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1955,8,'2017-05-29 06:19:01','2017-05-29 06:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1956,8,'2017-05-29 06:20:01','2017-05-29 06:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1957,8,'2017-05-29 06:21:01','2017-05-29 06:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1958,8,'2017-05-29 06:22:01','2017-05-29 06:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1959,8,'2017-05-29 06:23:01','2017-05-29 06:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1960,8,'2017-05-29 06:24:01','2017-05-29 06:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1961,8,'2017-05-29 06:25:01','2017-05-29 06:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1962,8,'2017-05-29 06:26:01','2017-05-29 06:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1963,8,'2017-05-29 06:27:01','2017-05-29 06:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1964,8,'2017-05-29 06:28:01','2017-05-29 06:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1965,8,'2017-05-29 06:29:01','2017-05-29 06:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1966,8,'2017-05-29 06:30:01','2017-05-29 06:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1967,8,'2017-05-29 06:31:02','2017-05-29 06:31:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1968,8,'2017-05-29 06:32:01','2017-05-29 06:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1969,8,'2017-05-29 06:33:01','2017-05-29 06:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1970,8,'2017-05-29 06:34:01','2017-05-29 06:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1971,8,'2017-05-29 06:35:01','2017-05-29 06:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1972,8,'2017-05-29 06:36:01','2017-05-29 06:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1973,8,'2017-05-29 06:37:01','2017-05-29 06:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1974,8,'2017-05-29 06:38:01','2017-05-29 06:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1975,8,'2017-05-29 06:39:01','2017-05-29 06:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1976,8,'2017-05-29 06:40:01','2017-05-29 06:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1977,8,'2017-05-29 06:41:01','2017-05-29 06:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1978,8,'2017-05-29 06:42:01','2017-05-29 06:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1979,8,'2017-05-29 06:43:01','2017-05-29 06:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1980,8,'2017-05-29 06:44:01','2017-05-29 06:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1981,8,'2017-05-29 06:45:01','2017-05-29 06:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1982,8,'2017-05-29 06:46:01','2017-05-29 06:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1983,8,'2017-05-29 06:47:01','2017-05-29 06:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1984,8,'2017-05-29 06:48:01','2017-05-29 06:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1985,8,'2017-05-29 06:49:01','2017-05-29 06:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1986,8,'2017-05-29 06:50:01','2017-05-29 06:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1987,8,'2017-05-29 06:51:01','2017-05-29 06:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1988,8,'2017-05-29 06:52:01','2017-05-29 06:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1989,8,'2017-05-29 06:53:01','2017-05-29 06:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1990,8,'2017-05-29 06:54:01','2017-05-29 06:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1991,8,'2017-05-29 06:55:01','2017-05-29 06:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1992,8,'2017-05-29 06:56:01','2017-05-29 06:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1993,8,'2017-05-29 06:57:01','2017-05-29 06:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1994,8,'2017-05-29 06:58:01','2017-05-29 06:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1995,8,'2017-05-29 06:59:01','2017-05-29 06:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1996,8,'2017-05-29 07:00:02','2017-05-29 07:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1997,8,'2017-05-29 07:01:01','2017-05-29 07:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1998,8,'2017-05-29 07:02:01','2017-05-29 07:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(1999,8,'2017-05-29 07:03:01','2017-05-29 07:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2000,8,'2017-05-29 07:04:01','2017-05-29 07:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2001,8,'2017-05-29 07:05:01','2017-05-29 07:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2002,8,'2017-05-29 07:06:01','2017-05-29 07:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2003,8,'2017-05-29 07:07:01','2017-05-29 07:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2004,8,'2017-05-29 07:08:01','2017-05-29 07:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2005,8,'2017-05-29 07:09:01','2017-05-29 07:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2006,8,'2017-05-29 07:10:01','2017-05-29 07:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2007,8,'2017-05-29 07:11:01','2017-05-29 07:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2008,8,'2017-05-29 07:12:01','2017-05-29 07:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2009,8,'2017-05-29 07:13:02','2017-05-29 07:13:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2010,8,'2017-05-29 07:14:01','2017-05-29 07:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2011,8,'2017-05-29 07:15:01','2017-05-29 07:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2012,8,'2017-05-29 07:16:01','2017-05-29 07:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2013,8,'2017-05-29 07:17:01','2017-05-29 07:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2014,8,'2017-05-29 07:18:01','2017-05-29 07:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2015,8,'2017-05-29 07:19:01','2017-05-29 07:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2016,8,'2017-05-29 07:20:01','2017-05-29 07:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2017,8,'2017-05-29 07:21:01','2017-05-29 07:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2018,8,'2017-05-29 07:22:01','2017-05-29 07:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2019,8,'2017-05-29 07:23:01','2017-05-29 07:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2020,8,'2017-05-29 07:24:01','2017-05-29 07:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2021,8,'2017-05-29 07:25:01','2017-05-29 07:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2022,8,'2017-05-29 07:26:01','2017-05-29 07:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2023,8,'2017-05-29 07:27:01','2017-05-29 07:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2024,8,'2017-05-29 07:28:01','2017-05-29 07:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2025,8,'2017-05-29 07:29:01','2017-05-29 07:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2026,8,'2017-05-29 07:30:01','2017-05-29 07:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2027,8,'2017-05-29 07:31:01','2017-05-29 07:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2028,8,'2017-05-29 07:32:01','2017-05-29 07:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2029,8,'2017-05-29 07:33:01','2017-05-29 07:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2030,8,'2017-05-29 07:34:01','2017-05-29 07:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2031,8,'2017-05-29 07:35:01','2017-05-29 07:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2032,8,'2017-05-29 07:36:01','2017-05-29 07:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2033,8,'2017-05-29 07:37:01','2017-05-29 07:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2034,8,'2017-05-29 07:38:01','2017-05-29 07:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2035,8,'2017-05-29 07:39:01','2017-05-29 07:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2036,8,'2017-05-29 07:40:01','2017-05-29 07:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2037,8,'2017-05-29 07:41:01','2017-05-29 07:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2038,8,'2017-05-29 07:42:01','2017-05-29 07:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2039,8,'2017-05-29 07:43:01','2017-05-29 07:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2040,8,'2017-05-29 07:44:01','2017-05-29 07:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2041,8,'2017-05-29 07:45:01','2017-05-29 07:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2042,8,'2017-05-29 07:46:01','2017-05-29 07:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2043,8,'2017-05-29 07:47:01','2017-05-29 07:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2044,8,'2017-05-29 07:48:01','2017-05-29 07:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2045,8,'2017-05-29 07:49:01','2017-05-29 07:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2046,8,'2017-05-29 07:50:02','2017-05-29 07:50:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2047,8,'2017-05-29 07:51:01','2017-05-29 07:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2048,8,'2017-05-29 07:52:01','2017-05-29 07:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2049,8,'2017-05-29 07:53:01','2017-05-29 07:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2050,8,'2017-05-29 07:54:01','2017-05-29 07:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2051,8,'2017-05-29 07:55:01','2017-05-29 07:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2052,8,'2017-05-29 07:56:01','2017-05-29 07:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2053,8,'2017-05-29 07:57:01','2017-05-29 07:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2054,8,'2017-05-29 07:58:01','2017-05-29 07:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2055,8,'2017-05-29 07:59:01','2017-05-29 07:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2056,8,'2017-05-29 08:00:01','2017-05-29 08:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2057,8,'2017-05-29 08:01:01','2017-05-29 08:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2058,8,'2017-05-29 08:02:01','2017-05-29 08:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2059,8,'2017-05-29 08:03:01','2017-05-29 08:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2060,8,'2017-05-29 08:04:01','2017-05-29 08:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2061,8,'2017-05-29 08:05:01','2017-05-29 08:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2062,8,'2017-05-29 08:06:01','2017-05-29 08:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2063,8,'2017-05-29 08:07:01','2017-05-29 08:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2064,8,'2017-05-29 08:08:01','2017-05-29 08:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2065,8,'2017-05-29 08:09:01','2017-05-29 08:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2066,8,'2017-05-29 08:10:01','2017-05-29 08:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2067,8,'2017-05-29 08:11:01','2017-05-29 08:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2068,8,'2017-05-29 08:12:01','2017-05-29 08:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2069,8,'2017-05-29 08:13:02','2017-05-29 08:13:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2070,8,'2017-05-29 08:14:01','2017-05-29 08:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2071,8,'2017-05-29 08:15:01','2017-05-29 08:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2072,8,'2017-05-29 08:16:01','2017-05-29 08:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2073,8,'2017-05-29 08:17:01','2017-05-29 08:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2074,8,'2017-05-29 08:18:01','2017-05-29 08:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2075,8,'2017-05-29 08:19:02','2017-05-29 08:19:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2076,8,'2017-05-29 08:20:01','2017-05-29 08:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2077,8,'2017-05-29 08:21:01','2017-05-29 08:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2078,8,'2017-05-29 08:22:01','2017-05-29 08:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2079,8,'2017-05-29 08:23:01','2017-05-29 08:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2080,8,'2017-05-29 08:24:01','2017-05-29 08:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2081,8,'2017-05-29 08:25:01','2017-05-29 08:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2082,8,'2017-05-29 08:26:01','2017-05-29 08:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2083,8,'2017-05-29 08:27:01','2017-05-29 08:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2084,8,'2017-05-29 08:28:01','2017-05-29 08:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2085,8,'2017-05-29 08:29:01','2017-05-29 08:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2086,8,'2017-05-29 08:30:01','2017-05-29 08:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2087,8,'2017-05-29 08:31:01','2017-05-29 08:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2088,8,'2017-05-29 08:32:01','2017-05-29 08:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2089,8,'2017-05-29 08:33:01','2017-05-29 08:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2090,8,'2017-05-29 08:34:01','2017-05-29 08:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2091,8,'2017-05-29 08:35:01','2017-05-29 08:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2092,8,'2017-05-29 08:36:02','2017-05-29 08:36:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2093,8,'2017-05-29 08:37:01','2017-05-29 08:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2094,8,'2017-05-29 08:38:01','2017-05-29 08:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2095,8,'2017-05-29 08:39:01','2017-05-29 08:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2096,8,'2017-05-29 08:40:01','2017-05-29 08:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2097,8,'2017-05-29 08:41:01','2017-05-29 08:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2098,8,'2017-05-29 08:42:01','2017-05-29 08:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2099,8,'2017-05-29 08:43:01','2017-05-29 08:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2100,8,'2017-05-29 08:44:01','2017-05-29 08:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2101,8,'2017-05-29 08:45:01','2017-05-29 08:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2102,8,'2017-05-29 08:46:01','2017-05-29 08:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2103,8,'2017-05-29 08:47:01','2017-05-29 08:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2104,8,'2017-05-29 08:48:01','2017-05-29 08:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2105,8,'2017-05-29 08:49:01','2017-05-29 08:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2106,8,'2017-05-29 08:50:01','2017-05-29 08:50:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2107,8,'2017-05-29 08:51:01','2017-05-29 08:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2108,8,'2017-05-29 08:52:01','2017-05-29 08:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2109,8,'2017-05-29 08:53:01','2017-05-29 08:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2110,8,'2017-05-29 08:54:01','2017-05-29 08:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2111,8,'2017-05-29 08:55:01','2017-05-29 08:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2112,8,'2017-05-29 08:56:01','2017-05-29 08:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2113,8,'2017-05-29 08:57:01','2017-05-29 08:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2114,8,'2017-05-29 08:58:01','2017-05-29 08:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2115,8,'2017-05-29 08:59:01','2017-05-29 08:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2116,8,'2017-05-29 09:00:02','2017-05-29 09:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2117,8,'2017-05-29 09:01:01','2017-05-29 09:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2118,8,'2017-05-29 09:02:01','2017-05-29 09:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2119,8,'2017-05-29 09:03:01','2017-05-29 09:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2120,8,'2017-05-29 09:04:01','2017-05-29 09:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2121,8,'2017-05-29 09:05:01','2017-05-29 09:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2122,8,'2017-05-29 09:06:01','2017-05-29 09:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2123,8,'2017-05-29 09:07:01','2017-05-29 09:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2124,8,'2017-05-29 09:08:01','2017-05-29 09:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2125,8,'2017-05-29 09:09:01','2017-05-29 09:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2126,8,'2017-05-29 09:10:01','2017-05-29 09:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2127,8,'2017-05-29 09:11:01','2017-05-29 09:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2128,8,'2017-05-29 09:12:01','2017-05-29 09:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2129,8,'2017-05-29 09:13:01','2017-05-29 09:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2130,8,'2017-05-29 09:14:01','2017-05-29 09:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2131,8,'2017-05-29 09:15:01','2017-05-29 09:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2132,8,'2017-05-29 09:16:01','2017-05-29 09:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2133,8,'2017-05-29 09:17:01','2017-05-29 09:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2134,8,'2017-05-29 09:18:01','2017-05-29 09:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2135,8,'2017-05-29 09:19:01','2017-05-29 09:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2136,8,'2017-05-29 09:20:01','2017-05-29 09:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2137,8,'2017-05-29 09:21:01','2017-05-29 09:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2138,8,'2017-05-29 09:22:01','2017-05-29 09:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2139,8,'2017-05-29 09:23:01','2017-05-29 09:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2140,8,'2017-05-29 09:24:01','2017-05-29 09:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2141,8,'2017-05-29 09:25:01','2017-05-29 09:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2142,8,'2017-05-29 09:26:01','2017-05-29 09:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2143,8,'2017-05-29 09:27:01','2017-05-29 09:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2144,8,'2017-05-29 09:28:01','2017-05-29 09:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2145,8,'2017-05-29 09:29:01','2017-05-29 09:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2146,8,'2017-05-29 09:30:01','2017-05-29 09:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2147,8,'2017-05-29 09:31:01','2017-05-29 09:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2148,8,'2017-05-29 09:32:01','2017-05-29 09:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2149,8,'2017-05-29 09:33:01','2017-05-29 09:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2150,8,'2017-05-29 09:34:01','2017-05-29 09:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2151,8,'2017-05-29 09:35:01','2017-05-29 09:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2152,8,'2017-05-29 09:36:01','2017-05-29 09:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2153,8,'2017-05-29 09:37:01','2017-05-29 09:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2154,8,'2017-05-29 09:38:01','2017-05-29 09:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2155,8,'2017-05-29 09:39:02','2017-05-29 09:39:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2156,8,'2017-05-29 09:40:01','2017-05-29 09:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2157,8,'2017-05-29 09:41:01','2017-05-29 09:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2158,8,'2017-05-29 09:42:01','2017-05-29 09:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2159,8,'2017-05-29 09:43:01','2017-05-29 09:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2160,8,'2017-05-29 09:44:01','2017-05-29 09:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2161,8,'2017-05-29 09:45:01','2017-05-29 09:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2162,8,'2017-05-29 09:46:01','2017-05-29 09:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2163,8,'2017-05-29 09:47:01','2017-05-29 09:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2164,8,'2017-05-29 09:48:01','2017-05-29 09:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2165,8,'2017-05-29 09:49:01','2017-05-29 09:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2166,8,'2017-05-29 09:50:01','2017-05-29 09:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2167,8,'2017-05-29 09:51:01','2017-05-29 09:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2168,8,'2017-05-29 09:52:01','2017-05-29 09:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2169,8,'2017-05-29 09:53:01','2017-05-29 09:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2170,8,'2017-05-29 09:54:01','2017-05-29 09:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2171,8,'2017-05-29 09:55:01','2017-05-29 09:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2172,8,'2017-05-29 09:56:01','2017-05-29 09:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2173,8,'2017-05-29 09:57:01','2017-05-29 09:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2174,8,'2017-05-29 09:58:01','2017-05-29 09:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2175,8,'2017-05-29 09:59:01','2017-05-29 09:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2176,8,'2017-05-29 10:00:01','2017-05-29 10:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2177,8,'2017-05-29 10:01:01','2017-05-29 10:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2178,8,'2017-05-29 10:02:01','2017-05-29 10:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2179,8,'2017-05-29 10:03:01','2017-05-29 10:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2180,8,'2017-05-29 10:04:01','2017-05-29 10:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2181,8,'2017-05-29 10:05:01','2017-05-29 10:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2182,8,'2017-05-29 10:06:02','2017-05-29 10:06:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2183,8,'2017-05-29 10:07:01','2017-05-29 10:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2184,8,'2017-05-29 10:08:01','2017-05-29 10:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2185,8,'2017-05-29 10:09:01','2017-05-29 10:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2186,8,'2017-05-29 10:10:01','2017-05-29 10:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2187,8,'2017-05-29 10:11:01','2017-05-29 10:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2188,8,'2017-05-29 10:12:01','2017-05-29 10:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2189,8,'2017-05-29 10:13:01','2017-05-29 10:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2190,8,'2017-05-29 10:14:01','2017-05-29 10:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2191,8,'2017-05-29 10:15:01','2017-05-29 10:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2192,8,'2017-05-29 10:16:01','2017-05-29 10:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2193,8,'2017-05-29 10:17:01','2017-05-29 10:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2194,8,'2017-05-29 10:18:01','2017-05-29 10:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2195,8,'2017-05-29 10:19:01','2017-05-29 10:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2196,8,'2017-05-29 10:20:01','2017-05-29 10:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2197,8,'2017-05-29 10:21:01','2017-05-29 10:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2198,8,'2017-05-29 10:22:01','2017-05-29 10:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2199,8,'2017-05-29 10:23:01','2017-05-29 10:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2200,8,'2017-05-29 10:24:01','2017-05-29 10:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2201,8,'2017-05-29 10:25:01','2017-05-29 10:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2202,8,'2017-05-29 10:26:01','2017-05-29 10:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2203,8,'2017-05-29 10:27:01','2017-05-29 10:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2204,8,'2017-05-29 10:28:01','2017-05-29 10:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2205,8,'2017-05-29 10:29:01','2017-05-29 10:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2206,8,'2017-05-29 10:30:01','2017-05-29 10:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2207,8,'2017-05-29 10:31:01','2017-05-29 10:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2208,8,'2017-05-29 10:32:01','2017-05-29 10:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2209,8,'2017-05-29 10:33:01','2017-05-29 10:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2210,8,'2017-05-29 10:34:01','2017-05-29 10:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2211,8,'2017-05-29 10:35:01','2017-05-29 10:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2212,8,'2017-05-29 10:36:01','2017-05-29 10:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2213,8,'2017-05-29 10:37:01','2017-05-29 10:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2214,8,'2017-05-29 10:38:01','2017-05-29 10:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2215,8,'2017-05-29 10:39:02','2017-05-29 10:39:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2216,8,'2017-05-29 10:40:01','2017-05-29 10:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2217,8,'2017-05-29 10:41:01','2017-05-29 10:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2218,8,'2017-05-29 10:42:01','2017-05-29 10:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2219,8,'2017-05-29 10:43:01','2017-05-29 10:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2220,8,'2017-05-29 10:44:01','2017-05-29 10:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2221,8,'2017-05-29 10:45:01','2017-05-29 10:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2222,8,'2017-05-29 10:46:01','2017-05-29 10:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2223,8,'2017-05-29 10:47:01','2017-05-29 10:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2224,8,'2017-05-29 10:48:01','2017-05-29 10:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2225,8,'2017-05-29 10:49:01','2017-05-29 10:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2226,8,'2017-05-29 10:50:01','2017-05-29 10:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2227,8,'2017-05-29 10:51:01','2017-05-29 10:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2228,8,'2017-05-29 10:52:01','2017-05-29 10:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2229,8,'2017-05-29 10:53:01','2017-05-29 10:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2230,8,'2017-05-29 10:54:01','2017-05-29 10:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2231,8,'2017-05-29 10:55:01','2017-05-29 10:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2232,8,'2017-05-29 10:56:01','2017-05-29 10:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2233,8,'2017-05-29 10:57:01','2017-05-29 10:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2234,8,'2017-05-29 10:58:01','2017-05-29 10:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2235,8,'2017-05-29 10:59:01','2017-05-29 10:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2236,8,'2017-05-29 11:00:01','2017-05-29 11:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2237,8,'2017-05-29 11:01:01','2017-05-29 11:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2238,8,'2017-05-29 11:02:01','2017-05-29 11:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2239,8,'2017-05-29 11:03:01','2017-05-29 11:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2240,8,'2017-05-29 11:04:01','2017-05-29 11:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2241,8,'2017-05-29 11:05:01','2017-05-29 11:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2242,8,'2017-05-29 11:06:01','2017-05-29 11:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2243,8,'2017-05-29 11:07:01','2017-05-29 11:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2244,8,'2017-05-29 11:08:01','2017-05-29 11:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2245,8,'2017-05-29 11:09:01','2017-05-29 11:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2246,8,'2017-05-29 11:10:01','2017-05-29 11:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2247,8,'2017-05-29 11:11:01','2017-05-29 11:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2248,8,'2017-05-29 11:12:01','2017-05-29 11:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2249,8,'2017-05-29 11:13:01','2017-05-29 11:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2250,8,'2017-05-29 11:14:01','2017-05-29 11:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2251,8,'2017-05-29 11:15:01','2017-05-29 11:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2252,8,'2017-05-29 11:16:02','2017-05-29 11:16:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2253,8,'2017-05-29 11:17:01','2017-05-29 11:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2254,8,'2017-05-29 11:18:01','2017-05-29 11:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2255,8,'2017-05-29 11:19:01','2017-05-29 11:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2256,8,'2017-05-29 11:20:01','2017-05-29 11:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2257,8,'2017-05-29 11:21:01','2017-05-29 11:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2258,8,'2017-05-29 11:22:01','2017-05-29 11:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2259,8,'2017-05-29 11:23:01','2017-05-29 11:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2260,8,'2017-05-29 11:24:01','2017-05-29 11:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2261,8,'2017-05-29 11:25:01','2017-05-29 11:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2262,8,'2017-05-29 11:26:01','2017-05-29 11:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2263,8,'2017-05-29 11:27:01','2017-05-29 11:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2264,8,'2017-05-29 11:28:01','2017-05-29 11:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2265,8,'2017-05-29 11:29:01','2017-05-29 11:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2266,8,'2017-05-29 11:30:01','2017-05-29 11:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2267,8,'2017-05-29 11:31:01','2017-05-29 11:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2268,8,'2017-05-29 11:32:01','2017-05-29 11:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2269,8,'2017-05-29 11:33:01','2017-05-29 11:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2270,8,'2017-05-29 11:34:02','2017-05-29 11:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2271,8,'2017-05-29 11:35:01','2017-05-29 11:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2272,8,'2017-05-29 11:36:01','2017-05-29 11:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2273,8,'2017-05-29 11:37:01','2017-05-29 11:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2274,8,'2017-05-29 11:38:01','2017-05-29 11:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2275,8,'2017-05-29 11:39:01','2017-05-29 11:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2276,8,'2017-05-29 11:40:01','2017-05-29 11:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2277,8,'2017-05-29 11:41:01','2017-05-29 11:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2278,8,'2017-05-29 11:42:01','2017-05-29 11:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2279,8,'2017-05-29 11:43:01','2017-05-29 11:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2280,8,'2017-05-29 11:44:02','2017-05-29 11:44:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2281,8,'2017-05-29 11:45:01','2017-05-29 11:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2282,8,'2017-05-29 11:46:01','2017-05-29 11:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2283,8,'2017-05-29 11:47:01','2017-05-29 11:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2284,8,'2017-05-29 11:48:01','2017-05-29 11:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2285,8,'2017-05-29 11:49:01','2017-05-29 11:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2286,8,'2017-05-29 11:50:01','2017-05-29 11:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2287,8,'2017-05-29 11:51:01','2017-05-29 11:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2288,8,'2017-05-29 11:52:02','2017-05-29 11:52:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2289,8,'2017-05-29 11:53:01','2017-05-29 11:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2290,8,'2017-05-29 11:54:01','2017-05-29 11:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2291,8,'2017-05-29 11:55:01','2017-05-29 11:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2292,8,'2017-05-29 11:56:01','2017-05-29 11:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2293,8,'2017-05-29 11:57:01','2017-05-29 11:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2294,8,'2017-05-29 11:58:01','2017-05-29 11:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2295,8,'2017-05-29 11:59:01','2017-05-29 11:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2296,8,'2017-05-29 12:00:01','2017-05-29 12:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2297,8,'2017-05-29 12:01:01','2017-05-29 12:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2298,8,'2017-05-29 12:02:01','2017-05-29 12:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2299,8,'2017-05-29 12:03:01','2017-05-29 12:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2300,8,'2017-05-29 12:04:01','2017-05-29 12:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2301,8,'2017-05-29 12:05:01','2017-05-29 12:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2302,8,'2017-05-29 12:06:01','2017-05-29 12:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2303,8,'2017-05-29 12:07:01','2017-05-29 12:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2304,8,'2017-05-29 12:08:01','2017-05-29 12:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2305,8,'2017-05-29 12:09:01','2017-05-29 12:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2306,8,'2017-05-29 12:10:01','2017-05-29 12:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2307,8,'2017-05-29 12:11:01','2017-05-29 12:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2308,8,'2017-05-29 12:12:01','2017-05-29 12:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2309,8,'2017-05-29 12:13:01','2017-05-29 12:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2310,8,'2017-05-29 12:14:01','2017-05-29 12:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2311,8,'2017-05-29 12:15:01','2017-05-29 12:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2312,8,'2017-05-29 12:16:01','2017-05-29 12:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2313,8,'2017-05-29 12:17:01','2017-05-29 12:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2314,8,'2017-05-29 12:18:01','2017-05-29 12:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2315,8,'2017-05-29 12:19:01','2017-05-29 12:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2316,8,'2017-05-29 12:20:02','2017-05-29 12:20:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2317,8,'2017-05-29 12:21:01','2017-05-29 12:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2318,8,'2017-05-29 12:22:01','2017-05-29 12:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2319,8,'2017-05-29 12:23:01','2017-05-29 12:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2320,8,'2017-05-29 12:24:01','2017-05-29 12:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2321,8,'2017-05-29 12:25:01','2017-05-29 12:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2322,8,'2017-05-29 12:26:01','2017-05-29 12:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2323,8,'2017-05-29 12:27:01','2017-05-29 12:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2324,8,'2017-05-29 12:28:01','2017-05-29 12:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2325,8,'2017-05-29 12:29:01','2017-05-29 12:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2326,8,'2017-05-29 12:30:01','2017-05-29 12:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2327,8,'2017-05-29 12:31:01','2017-05-29 12:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2328,8,'2017-05-29 12:32:01','2017-05-29 12:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2329,8,'2017-05-29 12:33:01','2017-05-29 12:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2330,8,'2017-05-29 12:34:01','2017-05-29 12:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2331,8,'2017-05-29 12:35:01','2017-05-29 12:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2332,8,'2017-05-29 12:36:01','2017-05-29 12:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2333,8,'2017-05-29 12:37:01','2017-05-29 12:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2334,8,'2017-05-29 12:38:01','2017-05-29 12:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2335,8,'2017-05-29 12:39:01','2017-05-29 12:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2336,8,'2017-05-29 12:40:01','2017-05-29 12:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2337,8,'2017-05-29 12:41:01','2017-05-29 12:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2338,8,'2017-05-29 12:42:01','2017-05-29 12:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2339,8,'2017-05-29 12:43:02','2017-05-29 12:43:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2340,8,'2017-05-29 12:44:01','2017-05-29 12:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2341,8,'2017-05-29 12:45:01','2017-05-29 12:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2342,8,'2017-05-29 12:46:02','2017-05-29 12:46:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2343,8,'2017-05-29 12:47:01','2017-05-29 12:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2344,8,'2017-05-29 12:48:01','2017-05-29 12:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2345,8,'2017-05-29 12:49:01','2017-05-29 12:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2346,8,'2017-05-29 12:50:01','2017-05-29 12:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2347,8,'2017-05-29 12:51:01','2017-05-29 12:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2348,8,'2017-05-29 12:52:01','2017-05-29 12:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2349,8,'2017-05-29 12:53:01','2017-05-29 12:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2350,8,'2017-05-29 12:54:01','2017-05-29 12:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2351,8,'2017-05-29 12:55:01','2017-05-29 12:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2352,8,'2017-05-29 12:56:01','2017-05-29 12:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2353,8,'2017-05-29 12:57:01','2017-05-29 12:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2354,8,'2017-05-29 12:58:01','2017-05-29 12:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2355,8,'2017-05-29 12:59:02','2017-05-29 12:59:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2356,8,'2017-05-29 13:00:01','2017-05-29 13:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2357,8,'2017-05-29 13:01:01','2017-05-29 13:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2358,8,'2017-05-29 13:02:02','2017-05-29 13:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2359,8,'2017-05-29 13:03:01','2017-05-29 13:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2360,8,'2017-05-29 13:04:01','2017-05-29 13:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2361,8,'2017-05-29 13:05:01','2017-05-29 13:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2362,8,'2017-05-29 13:06:02','2017-05-29 13:06:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2363,8,'2017-05-29 13:07:01','2017-05-29 13:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2364,8,'2017-05-29 13:08:01','2017-05-29 13:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2365,8,'2017-05-29 13:09:01','2017-05-29 13:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2366,8,'2017-05-29 13:10:01','2017-05-29 13:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2367,8,'2017-05-29 13:11:02','2017-05-29 13:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2368,8,'2017-05-29 13:12:01','2017-05-29 13:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2369,8,'2017-05-29 13:13:01','2017-05-29 13:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2370,8,'2017-05-29 13:14:01','2017-05-29 13:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2371,8,'2017-05-29 13:15:01','2017-05-29 13:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2372,8,'2017-05-29 13:16:01','2017-05-29 13:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2373,8,'2017-05-29 13:17:01','2017-05-29 13:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2374,8,'2017-05-29 13:18:01','2017-05-29 13:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2375,8,'2017-05-29 13:19:01','2017-05-29 13:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2376,8,'2017-05-29 13:20:01','2017-05-29 13:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2377,8,'2017-05-29 13:21:01','2017-05-29 13:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2378,8,'2017-05-29 13:22:01','2017-05-29 13:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2379,8,'2017-05-29 13:23:01','2017-05-29 13:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2380,8,'2017-05-29 13:24:01','2017-05-29 13:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2381,8,'2017-05-29 13:25:01','2017-05-29 13:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2382,8,'2017-05-29 13:26:01','2017-05-29 13:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2383,8,'2017-05-29 13:27:01','2017-05-29 13:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2384,8,'2017-05-29 13:28:01','2017-05-29 13:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2385,8,'2017-05-29 13:29:01','2017-05-29 13:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2386,8,'2017-05-29 13:30:01','2017-05-29 13:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2387,8,'2017-05-29 13:31:01','2017-05-29 13:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2388,8,'2017-05-29 13:32:01','2017-05-29 13:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2389,8,'2017-05-29 13:33:01','2017-05-29 13:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2390,8,'2017-05-29 13:34:01','2017-05-29 13:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2391,8,'2017-05-29 13:35:01','2017-05-29 13:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2392,8,'2017-05-29 13:36:01','2017-05-29 13:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2393,8,'2017-05-29 13:37:01','2017-05-29 13:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2394,8,'2017-05-29 13:38:01','2017-05-29 13:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2395,8,'2017-05-29 13:39:01','2017-05-29 13:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2396,8,'2017-05-29 13:40:02','2017-05-29 13:40:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2397,8,'2017-05-29 13:41:01','2017-05-29 13:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2398,8,'2017-05-29 13:42:01','2017-05-29 13:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2399,8,'2017-05-29 13:43:02','2017-05-29 13:43:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2400,8,'2017-05-29 13:44:01','2017-05-29 13:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2401,8,'2017-05-29 13:45:01','2017-05-29 13:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2402,8,'2017-05-29 13:46:01','2017-05-29 13:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2403,8,'2017-05-29 13:47:02','2017-05-29 13:47:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2404,8,'2017-05-29 13:48:01','2017-05-29 13:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2405,8,'2017-05-29 13:49:01','2017-05-29 13:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2406,8,'2017-05-29 13:50:01','2017-05-29 13:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2407,8,'2017-05-29 13:51:01','2017-05-29 13:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2408,8,'2017-05-29 13:52:01','2017-05-29 13:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2409,8,'2017-05-29 13:53:01','2017-05-29 13:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2410,8,'2017-05-29 13:54:01','2017-05-29 13:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2411,8,'2017-05-29 13:55:01','2017-05-29 13:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2412,8,'2017-05-29 13:56:01','2017-05-29 13:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2413,8,'2017-05-29 13:57:01','2017-05-29 13:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2414,8,'2017-05-29 13:58:01','2017-05-29 13:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2415,8,'2017-05-29 13:59:01','2017-05-29 13:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2416,8,'2017-05-29 14:00:01','2017-05-29 14:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2417,8,'2017-05-29 14:01:01','2017-05-29 14:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2418,8,'2017-05-29 14:02:01','2017-05-29 14:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2419,8,'2017-05-29 14:03:01','2017-05-29 14:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2420,8,'2017-05-29 14:04:01','2017-05-29 14:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2421,8,'2017-05-29 14:05:02','2017-05-29 14:05:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2422,8,'2017-05-29 14:06:01','2017-05-29 14:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2423,8,'2017-05-29 14:07:01','2017-05-29 14:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2424,8,'2017-05-29 14:08:01','2017-05-29 14:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2425,8,'2017-05-29 14:09:01','2017-05-29 14:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2426,8,'2017-05-29 14:10:01','2017-05-29 14:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2427,8,'2017-05-29 14:11:01','2017-05-29 14:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2428,8,'2017-05-29 14:12:01','2017-05-29 14:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2429,8,'2017-05-29 14:13:01','2017-05-29 14:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2430,8,'2017-05-29 14:14:01','2017-05-29 14:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2431,8,'2017-05-29 14:15:01','2017-05-29 14:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2432,8,'2017-05-29 14:16:01','2017-05-29 14:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2433,8,'2017-05-29 14:17:01','2017-05-29 14:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2434,8,'2017-05-29 14:18:01','2017-05-29 14:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2435,8,'2017-05-29 14:19:01','2017-05-29 14:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2436,8,'2017-05-29 14:20:01','2017-05-29 14:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2437,8,'2017-05-29 14:21:01','2017-05-29 14:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2438,8,'2017-05-29 14:22:01','2017-05-29 14:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2439,8,'2017-05-29 14:23:01','2017-05-29 14:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2440,8,'2017-05-29 14:24:01','2017-05-29 14:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2441,8,'2017-05-29 14:25:01','2017-05-29 14:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2442,8,'2017-05-29 14:26:01','2017-05-29 14:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2443,8,'2017-05-29 14:27:01','2017-05-29 14:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2444,8,'2017-05-29 14:28:01','2017-05-29 14:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2445,8,'2017-05-29 14:29:01','2017-05-29 14:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2446,8,'2017-05-29 14:30:01','2017-05-29 14:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2447,8,'2017-05-29 14:31:01','2017-05-29 14:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2448,8,'2017-05-29 14:32:01','2017-05-29 14:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2449,8,'2017-05-29 14:33:01','2017-05-29 14:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2450,8,'2017-05-29 14:34:01','2017-05-29 14:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2451,8,'2017-05-29 14:35:01','2017-05-29 14:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2452,8,'2017-05-29 14:36:01','2017-05-29 14:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2453,8,'2017-05-29 14:37:01','2017-05-29 14:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2454,8,'2017-05-29 14:38:01','2017-05-29 14:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2455,8,'2017-05-29 14:39:01','2017-05-29 14:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2456,8,'2017-05-29 14:40:01','2017-05-29 14:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2457,8,'2017-05-29 14:41:01','2017-05-29 14:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2458,8,'2017-05-29 14:42:01','2017-05-29 14:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2459,8,'2017-05-29 14:43:01','2017-05-29 14:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2460,8,'2017-05-29 14:44:01','2017-05-29 14:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2461,8,'2017-05-29 14:45:01','2017-05-29 14:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2462,8,'2017-05-29 14:46:01','2017-05-29 14:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2463,8,'2017-05-29 14:47:01','2017-05-29 14:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2464,8,'2017-05-29 14:48:01','2017-05-29 14:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2465,8,'2017-05-29 14:49:01','2017-05-29 14:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2466,8,'2017-05-29 14:50:01','2017-05-29 14:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2467,8,'2017-05-29 14:51:01','2017-05-29 14:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2468,8,'2017-05-29 14:52:01','2017-05-29 14:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2469,8,'2017-05-29 14:53:01','2017-05-29 14:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2470,8,'2017-05-29 14:54:01','2017-05-29 14:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2471,8,'2017-05-29 14:55:01','2017-05-29 14:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2472,8,'2017-05-29 14:56:01','2017-05-29 14:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2473,8,'2017-05-29 14:57:01','2017-05-29 14:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2474,8,'2017-05-29 14:58:01','2017-05-29 14:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2475,8,'2017-05-29 14:59:01','2017-05-29 14:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2476,8,'2017-05-29 15:00:01','2017-05-29 15:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2477,8,'2017-05-29 15:01:01','2017-05-29 15:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2478,8,'2017-05-29 15:02:01','2017-05-29 15:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2479,8,'2017-05-29 15:03:01','2017-05-29 15:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2480,8,'2017-05-29 15:04:01','2017-05-29 15:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2481,8,'2017-05-29 15:05:01','2017-05-29 15:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2482,8,'2017-05-29 15:06:01','2017-05-29 15:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2483,8,'2017-05-29 15:07:01','2017-05-29 15:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2484,8,'2017-05-29 15:08:02','2017-05-29 15:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2485,8,'2017-05-29 15:09:01','2017-05-29 15:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2486,8,'2017-05-29 15:10:01','2017-05-29 15:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2487,8,'2017-05-29 15:11:01','2017-05-29 15:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2488,8,'2017-05-29 15:12:01','2017-05-29 15:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2489,8,'2017-05-29 15:13:01','2017-05-29 15:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2490,8,'2017-05-29 15:14:01','2017-05-29 15:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2491,8,'2017-05-29 15:15:01','2017-05-29 15:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2492,8,'2017-05-29 15:16:01','2017-05-29 15:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2493,8,'2017-05-29 15:17:01','2017-05-29 15:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2494,8,'2017-05-29 15:18:01','2017-05-29 15:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2495,8,'2017-05-29 15:19:01','2017-05-29 15:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2496,8,'2017-05-29 15:20:01','2017-05-29 15:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2497,8,'2017-05-29 15:21:01','2017-05-29 15:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2498,8,'2017-05-29 15:22:01','2017-05-29 15:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2499,8,'2017-05-29 15:23:01','2017-05-29 15:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2500,8,'2017-05-29 15:24:01','2017-05-29 15:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2501,8,'2017-05-29 15:25:01','2017-05-29 15:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2502,8,'2017-05-29 15:26:01','2017-05-29 15:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2503,8,'2017-05-29 15:27:01','2017-05-29 15:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2504,8,'2017-05-29 15:28:01','2017-05-29 15:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2505,8,'2017-05-29 15:29:01','2017-05-29 15:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2506,8,'2017-05-29 15:30:01','2017-05-29 15:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2507,8,'2017-05-29 15:31:01','2017-05-29 15:31:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2508,8,'2017-05-29 15:32:01','2017-05-29 15:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2509,8,'2017-05-29 15:33:01','2017-05-29 15:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2510,8,'2017-05-29 15:34:01','2017-05-29 15:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2511,8,'2017-05-29 15:35:02','2017-05-29 15:35:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2512,8,'2017-05-29 15:36:01','2017-05-29 15:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2513,8,'2017-05-29 15:37:01','2017-05-29 15:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2514,8,'2017-05-29 15:38:01','2017-05-29 15:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2515,8,'2017-05-29 15:39:01','2017-05-29 15:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2516,8,'2017-05-29 15:40:01','2017-05-29 15:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2517,8,'2017-05-29 15:41:01','2017-05-29 15:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2518,8,'2017-05-29 15:42:01','2017-05-29 15:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2519,8,'2017-05-29 15:43:01','2017-05-29 15:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2520,8,'2017-05-29 15:44:01','2017-05-29 15:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2521,8,'2017-05-29 15:45:01','2017-05-29 15:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2522,8,'2017-05-29 15:46:01','2017-05-29 15:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2523,8,'2017-05-29 15:47:01','2017-05-29 15:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2524,8,'2017-05-29 15:48:01','2017-05-29 15:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2525,8,'2017-05-29 15:49:01','2017-05-29 15:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2526,8,'2017-05-29 15:50:01','2017-05-29 15:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2527,8,'2017-05-29 15:51:01','2017-05-29 15:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2528,8,'2017-05-29 15:52:01','2017-05-29 15:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2529,8,'2017-05-29 15:53:01','2017-05-29 15:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2530,8,'2017-05-29 15:54:01','2017-05-29 15:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2531,8,'2017-05-29 15:55:01','2017-05-29 15:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2532,8,'2017-05-29 15:56:01','2017-05-29 15:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2533,8,'2017-05-29 15:57:01','2017-05-29 15:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2534,8,'2017-05-29 15:58:01','2017-05-29 15:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2535,8,'2017-05-29 15:59:02','2017-05-29 15:59:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2536,8,'2017-05-29 16:00:01','2017-05-29 16:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2537,8,'2017-05-29 16:01:01','2017-05-29 16:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2538,8,'2017-05-29 16:02:01','2017-05-29 16:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2539,8,'2017-05-29 16:03:01','2017-05-29 16:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2540,8,'2017-05-29 16:04:01','2017-05-29 16:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2541,8,'2017-05-29 16:05:01','2017-05-29 16:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2542,8,'2017-05-29 16:06:01','2017-05-29 16:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2543,8,'2017-05-29 16:07:01','2017-05-29 16:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2544,8,'2017-05-29 16:08:01','2017-05-29 16:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2545,8,'2017-05-29 16:09:01','2017-05-29 16:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2546,8,'2017-05-29 16:10:01','2017-05-29 16:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2547,8,'2017-05-29 16:11:01','2017-05-29 16:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2548,8,'2017-05-29 16:12:01','2017-05-29 16:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2549,8,'2017-05-29 16:13:01','2017-05-29 16:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2550,8,'2017-05-29 16:14:01','2017-05-29 16:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2551,8,'2017-05-29 16:15:01','2017-05-29 16:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2552,8,'2017-05-29 16:16:01','2017-05-29 16:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2553,8,'2017-05-29 16:17:01','2017-05-29 16:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2554,8,'2017-05-29 16:18:01','2017-05-29 16:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2555,8,'2017-05-29 16:19:01','2017-05-29 16:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2556,8,'2017-05-29 16:20:01','2017-05-29 16:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2557,8,'2017-05-29 16:21:01','2017-05-29 16:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2558,8,'2017-05-29 16:22:01','2017-05-29 16:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2559,8,'2017-05-29 16:23:01','2017-05-29 16:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2560,8,'2017-05-29 16:24:01','2017-05-29 16:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2561,8,'2017-05-29 16:25:01','2017-05-29 16:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2562,8,'2017-05-29 16:26:01','2017-05-29 16:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2563,8,'2017-05-29 16:27:01','2017-05-29 16:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2564,8,'2017-05-29 16:28:01','2017-05-29 16:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2565,8,'2017-05-29 16:29:01','2017-05-29 16:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2566,8,'2017-05-29 16:30:01','2017-05-29 16:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2567,8,'2017-05-29 16:31:01','2017-05-29 16:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2568,8,'2017-05-29 16:32:01','2017-05-29 16:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2569,8,'2017-05-29 16:33:01','2017-05-29 16:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2570,8,'2017-05-29 16:34:01','2017-05-29 16:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2571,8,'2017-05-29 16:35:01','2017-05-29 16:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2572,8,'2017-05-29 16:36:01','2017-05-29 16:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2573,8,'2017-05-29 16:37:01','2017-05-29 16:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2574,8,'2017-05-29 16:38:01','2017-05-29 16:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2575,8,'2017-05-29 16:39:01','2017-05-29 16:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2576,8,'2017-05-29 16:40:01','2017-05-29 16:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2577,8,'2017-05-29 16:41:01','2017-05-29 16:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2578,8,'2017-05-29 16:42:01','2017-05-29 16:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2579,8,'2017-05-29 16:43:01','2017-05-29 16:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2580,8,'2017-05-29 16:44:01','2017-05-29 16:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2581,8,'2017-05-29 16:45:01','2017-05-29 16:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2582,8,'2017-05-29 16:46:01','2017-05-29 16:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2583,8,'2017-05-29 16:47:01','2017-05-29 16:47:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2584,8,'2017-05-29 16:48:01','2017-05-29 16:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2585,8,'2017-05-29 16:49:01','2017-05-29 16:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2586,8,'2017-05-29 16:50:01','2017-05-29 16:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2587,8,'2017-05-29 16:51:01','2017-05-29 16:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2588,8,'2017-05-29 16:52:01','2017-05-29 16:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2589,8,'2017-05-29 16:53:01','2017-05-29 16:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2590,8,'2017-05-29 16:54:01','2017-05-29 16:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2591,8,'2017-05-29 16:55:01','2017-05-29 16:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2592,8,'2017-05-29 16:56:01','2017-05-29 16:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2593,8,'2017-05-29 16:57:01','2017-05-29 16:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2594,8,'2017-05-29 16:58:01','2017-05-29 16:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2595,8,'2017-05-29 16:59:01','2017-05-29 16:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2596,8,'2017-05-29 17:00:01','2017-05-29 17:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2597,8,'2017-05-29 17:01:01','2017-05-29 17:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2598,8,'2017-05-29 17:02:01','2017-05-29 17:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2599,8,'2017-05-29 17:03:01','2017-05-29 17:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2600,8,'2017-05-29 17:04:02','2017-05-29 17:04:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2601,8,'2017-05-29 17:05:01','2017-05-29 17:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2602,8,'2017-05-29 17:06:01','2017-05-29 17:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2603,8,'2017-05-29 17:07:02','2017-05-29 17:07:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2604,8,'2017-05-29 17:08:01','2017-05-29 17:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2605,8,'2017-05-29 17:09:01','2017-05-29 17:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2606,8,'2017-05-29 17:10:01','2017-05-29 17:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2607,8,'2017-05-29 17:11:01','2017-05-29 17:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2608,8,'2017-05-29 17:12:01','2017-05-29 17:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2609,8,'2017-05-29 17:13:01','2017-05-29 17:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2610,8,'2017-05-29 17:14:01','2017-05-29 17:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2611,8,'2017-05-29 17:15:01','2017-05-29 17:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2612,8,'2017-05-29 17:16:01','2017-05-29 17:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2613,8,'2017-05-29 17:17:01','2017-05-29 17:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2614,8,'2017-05-29 17:18:01','2017-05-29 17:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2615,8,'2017-05-29 17:19:01','2017-05-29 17:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2616,8,'2017-05-29 17:20:01','2017-05-29 17:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2617,8,'2017-05-29 17:21:01','2017-05-29 17:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2618,8,'2017-05-29 17:22:01','2017-05-29 17:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2619,8,'2017-05-29 17:23:01','2017-05-29 17:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2620,8,'2017-05-29 17:24:01','2017-05-29 17:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2621,8,'2017-05-29 17:25:01','2017-05-29 17:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2622,8,'2017-05-29 17:26:01','2017-05-29 17:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2623,8,'2017-05-29 17:27:01','2017-05-29 17:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2624,8,'2017-05-29 17:28:01','2017-05-29 17:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2625,8,'2017-05-29 17:29:01','2017-05-29 17:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2626,8,'2017-05-29 17:30:01','2017-05-29 17:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2627,8,'2017-05-29 17:31:01','2017-05-29 17:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2628,8,'2017-05-29 17:32:01','2017-05-29 17:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2629,8,'2017-05-29 17:33:01','2017-05-29 17:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2630,8,'2017-05-29 17:34:01','2017-05-29 17:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2631,8,'2017-05-29 17:35:01','2017-05-29 17:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2632,8,'2017-05-29 17:36:02','2017-05-29 17:36:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2633,8,'2017-05-29 17:37:01','2017-05-29 17:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2634,8,'2017-05-29 17:38:01','2017-05-29 17:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2635,8,'2017-05-29 17:39:01','2017-05-29 17:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2636,8,'2017-05-29 17:40:01','2017-05-29 17:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2637,8,'2017-05-29 17:41:01','2017-05-29 17:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2638,8,'2017-05-29 17:42:01','2017-05-29 17:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2639,8,'2017-05-29 17:43:01','2017-05-29 17:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2640,8,'2017-05-29 17:44:01','2017-05-29 17:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2641,8,'2017-05-29 17:45:01','2017-05-29 17:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2642,8,'2017-05-29 17:46:01','2017-05-29 17:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2643,8,'2017-05-29 17:47:01','2017-05-29 17:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2644,8,'2017-05-29 17:48:02','2017-05-29 17:48:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2645,8,'2017-05-29 17:49:01','2017-05-29 17:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2646,8,'2017-05-29 17:50:01','2017-05-29 17:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2647,8,'2017-05-29 17:51:01','2017-05-29 17:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2648,8,'2017-05-29 17:52:01','2017-05-29 17:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2649,8,'2017-05-29 17:53:01','2017-05-29 17:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2650,8,'2017-05-29 17:54:01','2017-05-29 17:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2651,8,'2017-05-29 17:55:02','2017-05-29 17:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2652,8,'2017-05-29 17:56:01','2017-05-29 17:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2653,8,'2017-05-29 17:57:01','2017-05-29 17:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2654,8,'2017-05-29 17:58:01','2017-05-29 17:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2655,8,'2017-05-29 17:59:01','2017-05-29 17:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2656,8,'2017-05-29 18:00:01','2017-05-29 18:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2657,8,'2017-05-29 18:01:01','2017-05-29 18:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2658,8,'2017-05-29 18:02:01','2017-05-29 18:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2659,8,'2017-05-29 18:03:01','2017-05-29 18:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2660,8,'2017-05-29 18:04:01','2017-05-29 18:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2661,8,'2017-05-29 18:05:01','2017-05-29 18:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2662,8,'2017-05-29 18:06:01','2017-05-29 18:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2663,8,'2017-05-29 18:07:01','2017-05-29 18:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2664,8,'2017-05-29 18:08:01','2017-05-29 18:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2665,8,'2017-05-29 18:09:01','2017-05-29 18:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2666,8,'2017-05-29 18:10:01','2017-05-29 18:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2667,8,'2017-05-29 18:11:01','2017-05-29 18:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2668,8,'2017-05-29 18:12:01','2017-05-29 18:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2669,8,'2017-05-29 18:13:01','2017-05-29 18:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2670,8,'2017-05-29 18:14:01','2017-05-29 18:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2671,8,'2017-05-29 18:15:01','2017-05-29 18:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2672,8,'2017-05-29 18:16:01','2017-05-29 18:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2673,8,'2017-05-29 18:17:01','2017-05-29 18:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2674,8,'2017-05-29 18:18:01','2017-05-29 18:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2675,8,'2017-05-29 18:19:01','2017-05-29 18:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2676,8,'2017-05-29 18:20:01','2017-05-29 18:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2677,8,'2017-05-29 18:21:01','2017-05-29 18:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2678,8,'2017-05-29 18:22:01','2017-05-29 18:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2679,8,'2017-05-29 18:23:01','2017-05-29 18:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2680,8,'2017-05-29 18:24:01','2017-05-29 18:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2681,8,'2017-05-29 18:25:02','2017-05-29 18:25:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2682,8,'2017-05-29 18:26:01','2017-05-29 18:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2683,8,'2017-05-29 18:27:01','2017-05-29 18:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2684,8,'2017-05-29 18:28:01','2017-05-29 18:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2685,8,'2017-05-29 18:29:01','2017-05-29 18:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2686,8,'2017-05-29 18:30:01','2017-05-29 18:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2687,8,'2017-05-29 18:31:01','2017-05-29 18:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2688,8,'2017-05-29 18:32:01','2017-05-29 18:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2689,8,'2017-05-29 18:33:01','2017-05-29 18:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2690,8,'2017-05-29 18:34:02','2017-05-29 18:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2691,8,'2017-05-29 18:35:01','2017-05-29 18:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2692,8,'2017-05-29 18:36:01','2017-05-29 18:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2693,8,'2017-05-29 18:37:01','2017-05-29 18:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2694,8,'2017-05-29 18:38:02','2017-05-29 18:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2695,8,'2017-05-29 18:39:01','2017-05-29 18:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2696,8,'2017-05-29 18:40:01','2017-05-29 18:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2697,8,'2017-05-29 18:41:01','2017-05-29 18:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2698,8,'2017-05-29 18:42:02','2017-05-29 18:42:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2699,8,'2017-05-29 18:43:01','2017-05-29 18:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2700,8,'2017-05-29 18:44:01','2017-05-29 18:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2701,8,'2017-05-29 18:45:01','2017-05-29 18:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2702,8,'2017-05-29 18:46:01','2017-05-29 18:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2703,8,'2017-05-29 18:47:01','2017-05-29 18:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2704,8,'2017-05-29 18:48:01','2017-05-29 18:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2705,8,'2017-05-29 18:49:01','2017-05-29 18:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2706,8,'2017-05-29 18:50:01','2017-05-29 18:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2707,8,'2017-05-29 18:51:01','2017-05-29 18:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2708,8,'2017-05-29 18:52:01','2017-05-29 18:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2709,8,'2017-05-29 18:53:01','2017-05-29 18:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2710,8,'2017-05-29 18:54:01','2017-05-29 18:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2711,8,'2017-05-29 18:55:01','2017-05-29 18:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2712,8,'2017-05-29 18:56:01','2017-05-29 18:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2713,8,'2017-05-29 18:57:01','2017-05-29 18:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2714,8,'2017-05-29 18:58:01','2017-05-29 18:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2715,8,'2017-05-29 18:59:01','2017-05-29 18:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2716,8,'2017-05-29 19:00:01','2017-05-29 19:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2717,8,'2017-05-29 19:01:01','2017-05-29 19:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2718,8,'2017-05-29 19:02:01','2017-05-29 19:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2719,8,'2017-05-29 19:03:01','2017-05-29 19:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2720,8,'2017-05-29 19:04:01','2017-05-29 19:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2721,8,'2017-05-29 19:05:01','2017-05-29 19:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2722,8,'2017-05-29 19:06:01','2017-05-29 19:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2723,8,'2017-05-29 19:07:01','2017-05-29 19:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2724,8,'2017-05-29 19:08:01','2017-05-29 19:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2725,8,'2017-05-29 19:09:01','2017-05-29 19:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2726,8,'2017-05-29 19:10:01','2017-05-29 19:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2727,8,'2017-05-29 19:11:02','2017-05-29 19:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2728,8,'2017-05-29 19:12:01','2017-05-29 19:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2729,8,'2017-05-29 19:13:01','2017-05-29 19:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2730,8,'2017-05-29 19:14:01','2017-05-29 19:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2731,8,'2017-05-29 19:15:01','2017-05-29 19:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2732,8,'2017-05-29 19:16:01','2017-05-29 19:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2733,8,'2017-05-29 19:17:01','2017-05-29 19:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2734,8,'2017-05-29 19:18:01','2017-05-29 19:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2735,8,'2017-05-29 19:19:01','2017-05-29 19:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2736,8,'2017-05-29 19:20:01','2017-05-29 19:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2737,8,'2017-05-29 19:21:01','2017-05-29 19:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2738,8,'2017-05-29 19:22:01','2017-05-29 19:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2739,8,'2017-05-29 19:23:01','2017-05-29 19:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2740,8,'2017-05-29 19:24:01','2017-05-29 19:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2741,8,'2017-05-29 19:25:01','2017-05-29 19:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2742,8,'2017-05-29 19:26:01','2017-05-29 19:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2743,8,'2017-05-29 19:27:01','2017-05-29 19:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2744,8,'2017-05-29 19:28:01','2017-05-29 19:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2745,8,'2017-05-29 19:29:01','2017-05-29 19:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2746,8,'2017-05-29 19:30:01','2017-05-29 19:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2747,8,'2017-05-29 19:31:01','2017-05-29 19:31:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2748,8,'2017-05-29 19:32:01','2017-05-29 19:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2749,8,'2017-05-29 19:33:01','2017-05-29 19:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2750,8,'2017-05-29 19:34:01','2017-05-29 19:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2751,8,'2017-05-29 19:35:01','2017-05-29 19:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2752,8,'2017-05-29 19:36:01','2017-05-29 19:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2753,8,'2017-05-29 19:37:01','2017-05-29 19:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2754,8,'2017-05-29 19:38:01','2017-05-29 19:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2755,8,'2017-05-29 19:39:01','2017-05-29 19:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2756,8,'2017-05-29 19:40:01','2017-05-29 19:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2757,8,'2017-05-29 19:41:01','2017-05-29 19:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2758,8,'2017-05-29 19:42:01','2017-05-29 19:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2759,8,'2017-05-29 19:43:01','2017-05-29 19:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2760,8,'2017-05-29 19:44:01','2017-05-29 19:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2761,8,'2017-05-29 19:45:01','2017-05-29 19:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2762,8,'2017-05-29 19:46:01','2017-05-29 19:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2763,8,'2017-05-29 19:47:01','2017-05-29 19:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2764,8,'2017-05-29 19:48:01','2017-05-29 19:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2765,8,'2017-05-29 19:49:01','2017-05-29 19:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2766,8,'2017-05-29 19:50:01','2017-05-29 19:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2767,8,'2017-05-29 19:51:01','2017-05-29 19:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2768,8,'2017-05-29 19:52:01','2017-05-29 19:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2769,8,'2017-05-29 19:53:01','2017-05-29 19:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2770,8,'2017-05-29 19:54:01','2017-05-29 19:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2771,8,'2017-05-29 19:55:01','2017-05-29 19:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2772,8,'2017-05-29 19:56:01','2017-05-29 19:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2773,8,'2017-05-29 19:57:01','2017-05-29 19:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2774,8,'2017-05-29 19:58:01','2017-05-29 19:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2775,8,'2017-05-29 19:59:01','2017-05-29 19:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2776,8,'2017-05-29 20:00:01','2017-05-29 20:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2777,8,'2017-05-29 20:01:01','2017-05-29 20:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2778,8,'2017-05-29 20:02:02','2017-05-29 20:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2779,8,'2017-05-29 20:03:01','2017-05-29 20:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2780,8,'2017-05-29 20:04:01','2017-05-29 20:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2781,8,'2017-05-29 20:05:01','2017-05-29 20:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2782,8,'2017-05-29 20:06:01','2017-05-29 20:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2783,8,'2017-05-29 20:07:01','2017-05-29 20:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2784,8,'2017-05-29 20:08:01','2017-05-29 20:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2785,8,'2017-05-29 20:09:01','2017-05-29 20:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2786,8,'2017-05-29 20:10:01','2017-05-29 20:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2787,8,'2017-05-29 20:11:01','2017-05-29 20:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2788,8,'2017-05-29 20:12:01','2017-05-29 20:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2789,8,'2017-05-29 20:13:01','2017-05-29 20:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2790,8,'2017-05-29 20:14:01','2017-05-29 20:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2791,8,'2017-05-29 20:15:01','2017-05-29 20:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2792,8,'2017-05-29 20:16:01','2017-05-29 20:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2793,8,'2017-05-29 20:17:02','2017-05-29 20:17:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2794,8,'2017-05-29 20:18:01','2017-05-29 20:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2795,8,'2017-05-29 20:19:02','2017-05-29 20:19:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2796,8,'2017-05-29 20:20:01','2017-05-29 20:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2797,8,'2017-05-29 20:21:01','2017-05-29 20:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2798,8,'2017-05-29 20:22:01','2017-05-29 20:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2799,8,'2017-05-29 20:23:01','2017-05-29 20:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2800,8,'2017-05-29 20:24:02','2017-05-29 20:24:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2801,8,'2017-05-29 20:25:01','2017-05-29 20:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2802,8,'2017-05-29 20:26:01','2017-05-29 20:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2803,8,'2017-05-29 20:27:01','2017-05-29 20:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2804,8,'2017-05-29 20:28:01','2017-05-29 20:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2805,8,'2017-05-29 20:29:01','2017-05-29 20:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2806,8,'2017-05-29 20:30:02','2017-05-29 20:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2807,8,'2017-05-29 20:31:01','2017-05-29 20:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2808,8,'2017-05-29 20:32:01','2017-05-29 20:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2809,8,'2017-05-29 20:33:01','2017-05-29 20:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2810,8,'2017-05-29 20:34:01','2017-05-29 20:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2811,8,'2017-05-29 20:35:01','2017-05-29 20:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2812,8,'2017-05-29 20:36:01','2017-05-29 20:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2813,8,'2017-05-29 20:37:01','2017-05-29 20:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2814,8,'2017-05-29 20:38:01','2017-05-29 20:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2815,8,'2017-05-29 20:39:01','2017-05-29 20:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2816,8,'2017-05-29 20:40:01','2017-05-29 20:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2817,8,'2017-05-29 20:41:01','2017-05-29 20:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2818,8,'2017-05-29 20:42:01','2017-05-29 20:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2819,8,'2017-05-29 20:43:01','2017-05-29 20:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2820,8,'2017-05-29 20:44:01','2017-05-29 20:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2821,8,'2017-05-29 20:45:02','2017-05-29 20:45:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2822,8,'2017-05-29 20:46:01','2017-05-29 20:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2823,8,'2017-05-29 20:47:01','2017-05-29 20:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2824,8,'2017-05-29 20:48:01','2017-05-29 20:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2825,8,'2017-05-29 20:49:01','2017-05-29 20:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2826,8,'2017-05-29 20:50:01','2017-05-29 20:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2827,8,'2017-05-29 20:51:01','2017-05-29 20:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2828,8,'2017-05-29 20:52:01','2017-05-29 20:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2829,8,'2017-05-29 20:53:01','2017-05-29 20:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2830,8,'2017-05-29 20:54:01','2017-05-29 20:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2831,8,'2017-05-29 20:55:01','2017-05-29 20:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2832,8,'2017-05-29 20:56:01','2017-05-29 20:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2833,8,'2017-05-29 20:57:01','2017-05-29 20:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2834,8,'2017-05-29 20:58:02','2017-05-29 20:58:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2835,8,'2017-05-29 20:59:01','2017-05-29 20:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2836,8,'2017-05-29 21:00:01','2017-05-29 21:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2837,8,'2017-05-29 21:01:01','2017-05-29 21:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2838,8,'2017-05-29 21:02:01','2017-05-29 21:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2839,8,'2017-05-29 21:03:01','2017-05-29 21:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2840,8,'2017-05-29 21:04:01','2017-05-29 21:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2841,8,'2017-05-29 21:05:01','2017-05-29 21:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2842,8,'2017-05-29 21:06:01','2017-05-29 21:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2843,8,'2017-05-29 21:07:01','2017-05-29 21:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2844,8,'2017-05-29 21:08:01','2017-05-29 21:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2845,8,'2017-05-29 21:09:01','2017-05-29 21:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2846,8,'2017-05-29 21:10:01','2017-05-29 21:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2847,8,'2017-05-29 21:11:01','2017-05-29 21:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2848,8,'2017-05-29 21:12:01','2017-05-29 21:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2849,8,'2017-05-29 21:13:01','2017-05-29 21:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2850,8,'2017-05-29 21:14:01','2017-05-29 21:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2851,8,'2017-05-29 21:15:01','2017-05-29 21:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2852,8,'2017-05-29 21:16:01','2017-05-29 21:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2853,8,'2017-05-29 21:17:01','2017-05-29 21:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2854,8,'2017-05-29 21:18:01','2017-05-29 21:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2855,8,'2017-05-29 21:19:01','2017-05-29 21:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2856,8,'2017-05-29 21:20:01','2017-05-29 21:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2857,8,'2017-05-29 21:21:01','2017-05-29 21:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2858,8,'2017-05-29 21:22:02','2017-05-29 21:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2859,8,'2017-05-29 21:23:01','2017-05-29 21:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2860,8,'2017-05-29 21:24:01','2017-05-29 21:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2861,8,'2017-05-29 21:25:01','2017-05-29 21:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2862,8,'2017-05-29 21:26:01','2017-05-29 21:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2863,8,'2017-05-29 21:27:01','2017-05-29 21:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2864,8,'2017-05-29 21:28:01','2017-05-29 21:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2865,8,'2017-05-29 21:29:01','2017-05-29 21:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2866,8,'2017-05-29 21:30:01','2017-05-29 21:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2867,8,'2017-05-29 21:31:01','2017-05-29 21:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2868,8,'2017-05-29 21:32:01','2017-05-29 21:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2869,8,'2017-05-29 21:33:01','2017-05-29 21:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2870,8,'2017-05-29 21:34:01','2017-05-29 21:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2871,8,'2017-05-29 21:35:01','2017-05-29 21:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2872,8,'2017-05-29 21:36:01','2017-05-29 21:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2873,8,'2017-05-29 21:37:01','2017-05-29 21:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2874,8,'2017-05-29 21:38:01','2017-05-29 21:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2875,8,'2017-05-29 21:39:01','2017-05-29 21:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2876,8,'2017-05-29 21:40:01','2017-05-29 21:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2877,8,'2017-05-29 21:41:01','2017-05-29 21:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2878,8,'2017-05-29 21:42:01','2017-05-29 21:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2879,8,'2017-05-29 21:43:01','2017-05-29 21:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2880,8,'2017-05-29 21:44:02','2017-05-29 21:44:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2881,8,'2017-05-29 21:45:01','2017-05-29 21:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2882,8,'2017-05-29 21:46:01','2017-05-29 21:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2883,8,'2017-05-29 21:47:01','2017-05-29 21:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2884,8,'2017-05-29 21:48:01','2017-05-29 21:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2885,8,'2017-05-29 21:49:01','2017-05-29 21:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2886,8,'2017-05-29 21:50:01','2017-05-29 21:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2887,8,'2017-05-29 21:51:01','2017-05-29 21:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2888,8,'2017-05-29 21:52:01','2017-05-29 21:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2889,8,'2017-05-29 21:53:01','2017-05-29 21:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2890,8,'2017-05-29 21:54:01','2017-05-29 21:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2891,8,'2017-05-29 21:55:01','2017-05-29 21:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2892,8,'2017-05-29 21:56:01','2017-05-29 21:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2893,8,'2017-05-29 21:57:01','2017-05-29 21:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2894,8,'2017-05-29 21:58:01','2017-05-29 21:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2895,8,'2017-05-29 21:59:01','2017-05-29 21:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2896,8,'2017-05-29 22:00:01','2017-05-29 22:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2897,8,'2017-05-29 22:01:02','2017-05-29 22:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2898,8,'2017-05-29 22:02:01','2017-05-29 22:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2899,8,'2017-05-29 22:03:01','2017-05-29 22:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2900,8,'2017-05-29 22:04:01','2017-05-29 22:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2901,8,'2017-05-29 22:05:01','2017-05-29 22:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2902,8,'2017-05-29 22:06:01','2017-05-29 22:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2903,8,'2017-05-29 22:07:01','2017-05-29 22:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2904,8,'2017-05-29 22:08:01','2017-05-29 22:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2905,8,'2017-05-29 22:09:01','2017-05-29 22:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2906,8,'2017-05-29 22:10:01','2017-05-29 22:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2907,8,'2017-05-29 22:11:01','2017-05-29 22:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2908,8,'2017-05-29 22:12:01','2017-05-29 22:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2909,8,'2017-05-29 22:13:01','2017-05-29 22:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2910,8,'2017-05-29 22:14:01','2017-05-29 22:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2911,8,'2017-05-29 22:15:01','2017-05-29 22:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2912,8,'2017-05-29 22:16:01','2017-05-29 22:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2913,8,'2017-05-29 22:17:01','2017-05-29 22:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2914,8,'2017-05-29 22:18:01','2017-05-29 22:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2915,8,'2017-05-29 22:19:01','2017-05-29 22:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2916,8,'2017-05-29 22:20:01','2017-05-29 22:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2917,8,'2017-05-29 22:21:01','2017-05-29 22:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2918,8,'2017-05-29 22:22:01','2017-05-29 22:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2919,8,'2017-05-29 22:23:01','2017-05-29 22:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2920,8,'2017-05-29 22:24:01','2017-05-29 22:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2921,8,'2017-05-29 22:25:01','2017-05-29 22:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2922,8,'2017-05-29 22:26:01','2017-05-29 22:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2923,8,'2017-05-29 22:27:01','2017-05-29 22:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2924,8,'2017-05-29 22:28:01','2017-05-29 22:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2925,8,'2017-05-29 22:29:01','2017-05-29 22:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2926,8,'2017-05-29 22:30:01','2017-05-29 22:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2927,8,'2017-05-29 22:31:01','2017-05-29 22:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2928,8,'2017-05-29 22:32:01','2017-05-29 22:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2929,8,'2017-05-29 22:33:01','2017-05-29 22:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2930,8,'2017-05-29 22:34:01','2017-05-29 22:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2931,8,'2017-05-29 22:35:01','2017-05-29 22:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2932,8,'2017-05-29 22:36:01','2017-05-29 22:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2933,8,'2017-05-29 22:37:01','2017-05-29 22:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2934,8,'2017-05-29 22:38:01','2017-05-29 22:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2935,8,'2017-05-29 22:39:01','2017-05-29 22:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2936,8,'2017-05-29 22:40:01','2017-05-29 22:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2937,8,'2017-05-29 22:41:01','2017-05-29 22:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2938,8,'2017-05-29 22:42:02','2017-05-29 22:42:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2939,8,'2017-05-29 22:43:01','2017-05-29 22:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2940,8,'2017-05-29 22:44:01','2017-05-29 22:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2941,8,'2017-05-29 22:45:01','2017-05-29 22:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2942,8,'2017-05-29 22:46:01','2017-05-29 22:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2943,8,'2017-05-29 22:47:01','2017-05-29 22:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2944,8,'2017-05-29 22:48:01','2017-05-29 22:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2945,8,'2017-05-29 22:49:01','2017-05-29 22:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2946,8,'2017-05-29 22:50:02','2017-05-29 22:50:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2947,8,'2017-05-29 22:51:01','2017-05-29 22:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2948,8,'2017-05-29 22:52:01','2017-05-29 22:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2949,8,'2017-05-29 22:53:01','2017-05-29 22:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2950,8,'2017-05-29 22:54:01','2017-05-29 22:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2951,8,'2017-05-29 22:55:02','2017-05-29 22:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2952,8,'2017-05-29 22:56:01','2017-05-29 22:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2953,8,'2017-05-29 22:57:01','2017-05-29 22:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2954,8,'2017-05-29 22:58:01','2017-05-29 22:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2955,8,'2017-05-29 22:59:01','2017-05-29 22:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2956,8,'2017-05-29 23:00:01','2017-05-29 23:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2957,8,'2017-05-29 23:01:01','2017-05-29 23:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2958,8,'2017-05-29 23:02:01','2017-05-29 23:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2959,8,'2017-05-29 23:03:01','2017-05-29 23:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2960,8,'2017-05-29 23:04:01','2017-05-29 23:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2961,8,'2017-05-29 23:05:01','2017-05-29 23:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2962,8,'2017-05-29 23:06:01','2017-05-29 23:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2963,8,'2017-05-29 23:07:01','2017-05-29 23:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2964,8,'2017-05-29 23:08:01','2017-05-29 23:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2965,8,'2017-05-29 23:09:01','2017-05-29 23:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2966,8,'2017-05-29 23:10:01','2017-05-29 23:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2967,8,'2017-05-29 23:11:01','2017-05-29 23:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2968,8,'2017-05-29 23:12:01','2017-05-29 23:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2969,8,'2017-05-29 23:13:01','2017-05-29 23:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2970,8,'2017-05-29 23:14:01','2017-05-29 23:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2971,8,'2017-05-29 23:15:01','2017-05-29 23:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2972,8,'2017-05-29 23:16:01','2017-05-29 23:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2973,8,'2017-05-29 23:17:01','2017-05-29 23:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2974,8,'2017-05-29 23:18:01','2017-05-29 23:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2975,8,'2017-05-29 23:19:01','2017-05-29 23:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2976,8,'2017-05-29 23:20:01','2017-05-29 23:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2977,8,'2017-05-29 23:21:01','2017-05-29 23:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2978,8,'2017-05-29 23:22:02','2017-05-29 23:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2979,8,'2017-05-29 23:23:01','2017-05-29 23:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2980,8,'2017-05-29 23:24:01','2017-05-29 23:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2981,8,'2017-05-29 23:25:01','2017-05-29 23:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2982,8,'2017-05-29 23:26:01','2017-05-29 23:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2983,8,'2017-05-29 23:27:01','2017-05-29 23:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2984,8,'2017-05-29 23:28:01','2017-05-29 23:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2985,8,'2017-05-29 23:29:01','2017-05-29 23:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2986,8,'2017-05-29 23:30:01','2017-05-29 23:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2987,8,'2017-05-29 23:31:01','2017-05-29 23:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2988,8,'2017-05-29 23:32:01','2017-05-29 23:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2989,8,'2017-05-29 23:33:01','2017-05-29 23:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2990,8,'2017-05-29 23:34:01','2017-05-29 23:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2991,8,'2017-05-29 23:35:01','2017-05-29 23:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2992,8,'2017-05-29 23:36:01','2017-05-29 23:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2993,8,'2017-05-29 23:37:01','2017-05-29 23:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2994,8,'2017-05-29 23:38:01','2017-05-29 23:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2995,8,'2017-05-29 23:39:01','2017-05-29 23:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2996,8,'2017-05-29 23:40:01','2017-05-29 23:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2997,8,'2017-05-29 23:41:01','2017-05-29 23:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2998,8,'2017-05-29 23:42:01','2017-05-29 23:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(2999,8,'2017-05-29 23:43:02','2017-05-29 23:43:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3000,8,'2017-05-29 23:44:01','2017-05-29 23:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3001,8,'2017-05-29 23:45:01','2017-05-29 23:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3002,8,'2017-05-29 23:46:02','2017-05-29 23:46:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3003,8,'2017-05-29 23:47:01','2017-05-29 23:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3004,8,'2017-05-29 23:48:01','2017-05-29 23:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3005,8,'2017-05-29 23:49:02','2017-05-29 23:49:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3006,8,'2017-05-29 23:50:01','2017-05-29 23:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3007,8,'2017-05-29 23:51:01','2017-05-29 23:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3008,8,'2017-05-29 23:52:02','2017-05-29 23:52:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3009,8,'2017-05-29 23:53:01','2017-05-29 23:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3010,8,'2017-05-29 23:54:01','2017-05-29 23:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3011,8,'2017-05-29 23:55:01','2017-05-29 23:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3012,8,'2017-05-29 23:56:01','2017-05-29 23:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3013,8,'2017-05-29 23:57:01','2017-05-29 23:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3014,8,'2017-05-29 23:58:01','2017-05-29 23:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3015,8,'2017-05-29 23:59:01','2017-05-29 23:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3016,8,'2017-05-30 00:00:01','2017-05-30 00:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3017,8,'2017-05-30 00:01:02','2017-05-30 00:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3018,8,'2017-05-30 00:02:01','2017-05-30 00:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3019,8,'2017-05-30 00:03:01','2017-05-30 00:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3020,8,'2017-05-30 00:04:01','2017-05-30 00:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3021,8,'2017-05-30 00:05:01','2017-05-30 00:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3022,8,'2017-05-30 00:06:01','2017-05-30 00:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3023,8,'2017-05-30 00:07:01','2017-05-30 00:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3024,8,'2017-05-30 00:08:01','2017-05-30 00:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3025,8,'2017-05-30 00:09:01','2017-05-30 00:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3026,8,'2017-05-30 00:10:01','2017-05-30 00:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3027,8,'2017-05-30 00:11:02','2017-05-30 00:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3028,8,'2017-05-30 00:12:01','2017-05-30 00:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3029,8,'2017-05-30 00:13:01','2017-05-30 00:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3030,8,'2017-05-30 00:14:01','2017-05-30 00:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3031,8,'2017-05-30 00:15:01','2017-05-30 00:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3032,8,'2017-05-30 00:16:02','2017-05-30 00:16:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3033,8,'2017-05-30 00:17:01','2017-05-30 00:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3034,8,'2017-05-30 00:18:01','2017-05-30 00:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3035,8,'2017-05-30 00:19:01','2017-05-30 00:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3036,8,'2017-05-30 00:20:01','2017-05-30 00:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3037,8,'2017-05-30 00:21:01','2017-05-30 00:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3038,8,'2017-05-30 00:22:01','2017-05-30 00:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3039,8,'2017-05-30 00:23:01','2017-05-30 00:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3040,8,'2017-05-30 00:24:01','2017-05-30 00:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3041,8,'2017-05-30 00:25:01','2017-05-30 00:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3042,8,'2017-05-30 00:26:01','2017-05-30 00:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3043,8,'2017-05-30 00:27:01','2017-05-30 00:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3044,8,'2017-05-30 00:28:01','2017-05-30 00:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3045,8,'2017-05-30 00:29:01','2017-05-30 00:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3046,8,'2017-05-30 00:30:01','2017-05-30 00:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3047,8,'2017-05-30 00:31:01','2017-05-30 00:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3048,8,'2017-05-30 00:32:01','2017-05-30 00:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3049,8,'2017-05-30 00:33:02','2017-05-30 00:33:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3050,8,'2017-05-30 00:34:01','2017-05-30 00:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3051,8,'2017-05-30 00:35:01','2017-05-30 00:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3052,8,'2017-05-30 00:36:01','2017-05-30 00:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3053,8,'2017-05-30 00:37:01','2017-05-30 00:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3054,8,'2017-05-30 00:38:01','2017-05-30 00:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3055,8,'2017-05-30 00:39:01','2017-05-30 00:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3056,8,'2017-05-30 00:40:01','2017-05-30 00:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3057,8,'2017-05-30 00:41:01','2017-05-30 00:41:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3058,8,'2017-05-30 00:42:01','2017-05-30 00:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3059,8,'2017-05-30 00:43:01','2017-05-30 00:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3060,8,'2017-05-30 00:44:01','2017-05-30 00:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3061,8,'2017-05-30 00:45:01','2017-05-30 00:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3062,8,'2017-05-30 00:46:01','2017-05-30 00:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3063,8,'2017-05-30 00:47:01','2017-05-30 00:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3064,8,'2017-05-30 00:48:01','2017-05-30 00:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3065,8,'2017-05-30 00:49:01','2017-05-30 00:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3066,8,'2017-05-30 00:50:01','2017-05-30 00:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3067,8,'2017-05-30 00:51:01','2017-05-30 00:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3068,8,'2017-05-30 00:52:01','2017-05-30 00:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3069,8,'2017-05-30 00:53:01','2017-05-30 00:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3070,8,'2017-05-30 00:54:01','2017-05-30 00:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3071,8,'2017-05-30 00:55:01','2017-05-30 00:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3072,8,'2017-05-30 00:56:01','2017-05-30 00:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3073,8,'2017-05-30 00:57:01','2017-05-30 00:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3074,8,'2017-05-30 00:58:01','2017-05-30 00:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3075,8,'2017-05-30 00:59:01','2017-05-30 00:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3076,8,'2017-05-30 01:00:02','2017-05-30 01:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3077,8,'2017-05-30 01:01:01','2017-05-30 01:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3078,8,'2017-05-30 01:02:02','2017-05-30 01:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3079,8,'2017-05-30 01:03:01','2017-05-30 01:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3080,8,'2017-05-30 01:04:01','2017-05-30 01:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3081,8,'2017-05-30 01:05:01','2017-05-30 01:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3082,8,'2017-05-30 01:06:01','2017-05-30 01:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3083,8,'2017-05-30 01:07:02','2017-05-30 01:07:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3084,8,'2017-05-30 01:08:01','2017-05-30 01:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3085,8,'2017-05-30 01:09:01','2017-05-30 01:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3086,8,'2017-05-30 01:10:01','2017-05-30 01:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3087,8,'2017-05-30 01:11:01','2017-05-30 01:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3088,8,'2017-05-30 01:12:01','2017-05-30 01:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3089,8,'2017-05-30 01:13:01','2017-05-30 01:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3090,8,'2017-05-30 01:14:02','2017-05-30 01:14:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3091,8,'2017-05-30 01:15:01','2017-05-30 01:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3092,8,'2017-05-30 01:16:01','2017-05-30 01:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3093,8,'2017-05-30 01:17:01','2017-05-30 01:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3094,8,'2017-05-30 01:18:01','2017-05-30 01:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3095,8,'2017-05-30 01:19:01','2017-05-30 01:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3096,8,'2017-05-30 01:20:01','2017-05-30 01:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3097,8,'2017-05-30 01:21:01','2017-05-30 01:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3098,8,'2017-05-30 01:22:01','2017-05-30 01:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3099,8,'2017-05-30 01:23:01','2017-05-30 01:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3100,8,'2017-05-30 01:24:01','2017-05-30 01:24:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3101,8,'2017-05-30 01:25:01','2017-05-30 01:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3102,8,'2017-05-30 01:26:01','2017-05-30 01:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3103,8,'2017-05-30 01:27:01','2017-05-30 01:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3104,8,'2017-05-30 01:28:01','2017-05-30 01:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3105,8,'2017-05-30 01:29:01','2017-05-30 01:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3106,8,'2017-05-30 01:30:02','2017-05-30 01:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3107,8,'2017-05-30 01:31:01','2017-05-30 01:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3108,8,'2017-05-30 01:32:01','2017-05-30 01:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3109,8,'2017-05-30 01:33:01','2017-05-30 01:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3110,8,'2017-05-30 01:34:02','2017-05-30 01:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3111,8,'2017-05-30 01:35:01','2017-05-30 01:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3112,8,'2017-05-30 01:36:01','2017-05-30 01:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3113,8,'2017-05-30 01:37:01','2017-05-30 01:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3114,8,'2017-05-30 01:38:01','2017-05-30 01:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3115,8,'2017-05-30 01:39:01','2017-05-30 01:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3116,8,'2017-05-30 01:40:01','2017-05-30 01:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3117,8,'2017-05-30 01:41:01','2017-05-30 01:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3118,8,'2017-05-30 01:42:02','2017-05-30 01:42:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3119,8,'2017-05-30 01:43:01','2017-05-30 01:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3120,8,'2017-05-30 01:44:01','2017-05-30 01:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3121,8,'2017-05-30 01:45:01','2017-05-30 01:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3122,8,'2017-05-30 01:46:02','2017-05-30 01:46:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3123,8,'2017-05-30 01:47:01','2017-05-30 01:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3124,8,'2017-05-30 01:48:01','2017-05-30 01:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3125,8,'2017-05-30 01:49:01','2017-05-30 01:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3126,8,'2017-05-30 01:50:01','2017-05-30 01:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3127,8,'2017-05-30 01:51:01','2017-05-30 01:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3128,8,'2017-05-30 01:52:01','2017-05-30 01:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3129,8,'2017-05-30 01:53:01','2017-05-30 01:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3130,8,'2017-05-30 01:54:01','2017-05-30 01:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3131,8,'2017-05-30 01:55:01','2017-05-30 01:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3132,8,'2017-05-30 01:56:01','2017-05-30 01:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3133,8,'2017-05-30 01:57:01','2017-05-30 01:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3134,8,'2017-05-30 01:58:01','2017-05-30 01:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3135,8,'2017-05-30 01:59:01','2017-05-30 01:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3136,8,'2017-05-30 02:00:01','2017-05-30 02:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3137,8,'2017-05-30 02:01:02','2017-05-30 02:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3138,8,'2017-05-30 02:02:01','2017-05-30 02:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3139,8,'2017-05-30 02:03:01','2017-05-30 02:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3140,8,'2017-05-30 02:04:01','2017-05-30 02:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3141,8,'2017-05-30 02:05:01','2017-05-30 02:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3142,8,'2017-05-30 02:06:02','2017-05-30 02:06:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3143,8,'2017-05-30 02:07:01','2017-05-30 02:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3144,8,'2017-05-30 02:08:01','2017-05-30 02:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3145,8,'2017-05-30 02:09:01','2017-05-30 02:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3146,8,'2017-05-30 02:10:01','2017-05-30 02:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3147,8,'2017-05-30 02:11:01','2017-05-30 02:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3148,8,'2017-05-30 02:12:02','2017-05-30 02:12:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3149,8,'2017-05-30 02:13:01','2017-05-30 02:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3150,8,'2017-05-30 02:14:01','2017-05-30 02:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3151,8,'2017-05-30 02:15:01','2017-05-30 02:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3152,8,'2017-05-30 02:16:01','2017-05-30 02:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3153,8,'2017-05-30 02:17:01','2017-05-30 02:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3154,8,'2017-05-30 02:18:01','2017-05-30 02:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3155,8,'2017-05-30 02:19:02','2017-05-30 02:19:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3156,8,'2017-05-30 02:20:01','2017-05-30 02:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3157,8,'2017-05-30 02:21:01','2017-05-30 02:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3158,8,'2017-05-30 02:22:01','2017-05-30 02:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3159,8,'2017-05-30 02:23:01','2017-05-30 02:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3160,8,'2017-05-30 02:24:01','2017-05-30 02:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3161,8,'2017-05-30 02:25:01','2017-05-30 02:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3162,8,'2017-05-30 02:26:01','2017-05-30 02:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3163,8,'2017-05-30 02:27:01','2017-05-30 02:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3164,8,'2017-05-30 02:28:01','2017-05-30 02:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3165,8,'2017-05-30 02:29:01','2017-05-30 02:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3166,8,'2017-05-30 02:30:01','2017-05-30 02:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3167,8,'2017-05-30 02:31:01','2017-05-30 02:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3168,8,'2017-05-30 02:32:01','2017-05-30 02:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3169,8,'2017-05-30 02:33:01','2017-05-30 02:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3170,8,'2017-05-30 02:34:01','2017-05-30 02:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3171,8,'2017-05-30 02:35:01','2017-05-30 02:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3172,8,'2017-05-30 02:36:01','2017-05-30 02:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3173,8,'2017-05-30 02:37:01','2017-05-30 02:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3174,8,'2017-05-30 02:38:01','2017-05-30 02:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3175,8,'2017-05-30 02:39:01','2017-05-30 02:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3176,8,'2017-05-30 02:40:01','2017-05-30 02:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3177,8,'2017-05-30 02:41:01','2017-05-30 02:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3178,8,'2017-05-30 02:42:01','2017-05-30 02:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3179,8,'2017-05-30 02:43:01','2017-05-30 02:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3180,8,'2017-05-30 02:44:01','2017-05-30 02:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3181,8,'2017-05-30 02:45:01','2017-05-30 02:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3182,8,'2017-05-30 02:46:01','2017-05-30 02:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3183,8,'2017-05-30 02:47:01','2017-05-30 02:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3184,8,'2017-05-30 02:48:01','2017-05-30 02:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3185,8,'2017-05-30 02:49:02','2017-05-30 02:49:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3186,8,'2017-05-30 02:50:01','2017-05-30 02:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3187,8,'2017-05-30 02:51:01','2017-05-30 02:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3188,8,'2017-05-30 02:52:01','2017-05-30 02:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3189,8,'2017-05-30 02:53:01','2017-05-30 02:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3190,8,'2017-05-30 02:54:01','2017-05-30 02:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3191,8,'2017-05-30 02:55:01','2017-05-30 02:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3192,8,'2017-05-30 02:56:01','2017-05-30 02:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3193,8,'2017-05-30 02:57:01','2017-05-30 02:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3194,8,'2017-05-30 02:58:01','2017-05-30 02:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3195,8,'2017-05-30 02:59:01','2017-05-30 02:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3196,8,'2017-05-30 03:00:01','2017-05-30 03:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3197,8,'2017-05-30 03:01:01','2017-05-30 03:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3198,8,'2017-05-30 03:02:01','2017-05-30 03:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3199,8,'2017-05-30 03:03:01','2017-05-30 03:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3200,8,'2017-05-30 03:04:01','2017-05-30 03:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3201,8,'2017-05-30 03:05:01','2017-05-30 03:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3202,8,'2017-05-30 03:06:01','2017-05-30 03:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3203,8,'2017-05-30 03:07:01','2017-05-30 03:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3204,8,'2017-05-30 03:08:01','2017-05-30 03:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3205,8,'2017-05-30 03:09:01','2017-05-30 03:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3206,8,'2017-05-30 03:10:01','2017-05-30 03:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3207,8,'2017-05-30 03:11:01','2017-05-30 03:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3208,8,'2017-05-30 03:12:01','2017-05-30 03:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3209,8,'2017-05-30 03:13:01','2017-05-30 03:13:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3210,8,'2017-05-30 03:14:01','2017-05-30 03:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3211,8,'2017-05-30 03:15:01','2017-05-30 03:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3212,8,'2017-05-30 03:16:01','2017-05-30 03:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3213,8,'2017-05-30 03:17:01','2017-05-30 03:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3214,8,'2017-05-30 03:18:01','2017-05-30 03:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3215,8,'2017-05-30 03:19:01','2017-05-30 03:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3216,8,'2017-05-30 03:20:01','2017-05-30 03:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3217,8,'2017-05-30 03:21:01','2017-05-30 03:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3218,8,'2017-05-30 03:22:01','2017-05-30 03:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3219,8,'2017-05-30 03:23:01','2017-05-30 03:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3220,8,'2017-05-30 03:24:01','2017-05-30 03:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3221,8,'2017-05-30 03:25:01','2017-05-30 03:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3222,8,'2017-05-30 03:26:01','2017-05-30 03:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3223,8,'2017-05-30 03:27:01','2017-05-30 03:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3224,8,'2017-05-30 03:28:01','2017-05-30 03:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3225,8,'2017-05-30 03:29:01','2017-05-30 03:29:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3226,8,'2017-05-30 03:30:01','2017-05-30 03:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3227,8,'2017-05-30 03:31:01','2017-05-30 03:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3228,8,'2017-05-30 03:32:01','2017-05-30 03:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3229,8,'2017-05-30 03:33:01','2017-05-30 03:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3230,8,'2017-05-30 03:34:01','2017-05-30 03:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3231,8,'2017-05-30 03:35:01','2017-05-30 03:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3232,8,'2017-05-30 03:36:01','2017-05-30 03:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3233,8,'2017-05-30 03:37:01','2017-05-30 03:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3234,8,'2017-05-30 03:38:01','2017-05-30 03:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3235,8,'2017-05-30 03:39:01','2017-05-30 03:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3236,8,'2017-05-30 03:40:01','2017-05-30 03:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3237,8,'2017-05-30 03:41:01','2017-05-30 03:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3238,8,'2017-05-30 03:42:01','2017-05-30 03:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3239,8,'2017-05-30 03:43:02','2017-05-30 03:43:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3240,8,'2017-05-30 03:44:01','2017-05-30 03:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3241,8,'2017-05-30 03:45:01','2017-05-30 03:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3242,8,'2017-05-30 03:46:01','2017-05-30 03:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3243,8,'2017-05-30 03:47:01','2017-05-30 03:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3244,8,'2017-05-30 03:48:01','2017-05-30 03:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3245,8,'2017-05-30 03:49:01','2017-05-30 03:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3246,8,'2017-05-30 03:50:02','2017-05-30 03:50:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3247,8,'2017-05-30 03:51:01','2017-05-30 03:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3248,8,'2017-05-30 03:52:01','2017-05-30 03:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3249,8,'2017-05-30 03:53:01','2017-05-30 03:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3250,8,'2017-05-30 03:54:01','2017-05-30 03:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3251,8,'2017-05-30 03:55:01','2017-05-30 03:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3252,8,'2017-05-30 03:56:01','2017-05-30 03:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3253,8,'2017-05-30 03:57:01','2017-05-30 03:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3254,8,'2017-05-30 03:58:01','2017-05-30 03:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3255,8,'2017-05-30 03:59:01','2017-05-30 03:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3256,8,'2017-05-30 04:00:02','2017-05-30 04:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3257,8,'2017-05-30 04:01:01','2017-05-30 04:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3258,8,'2017-05-30 04:02:01','2017-05-30 04:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3259,8,'2017-05-30 04:03:01','2017-05-30 04:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3260,8,'2017-05-30 04:04:01','2017-05-30 04:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3261,8,'2017-05-30 04:05:01','2017-05-30 04:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3262,8,'2017-05-30 04:06:01','2017-05-30 04:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3263,8,'2017-05-30 04:07:01','2017-05-30 04:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3264,8,'2017-05-30 04:08:01','2017-05-30 04:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3265,8,'2017-05-30 04:09:01','2017-05-30 04:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3266,8,'2017-05-30 04:10:01','2017-05-30 04:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3267,8,'2017-05-30 04:11:01','2017-05-30 04:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3268,8,'2017-05-30 04:12:01','2017-05-30 04:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3269,8,'2017-05-30 04:13:01','2017-05-30 04:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3270,8,'2017-05-30 04:14:01','2017-05-30 04:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3271,8,'2017-05-30 04:15:01','2017-05-30 04:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3272,8,'2017-05-30 04:16:01','2017-05-30 04:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3273,8,'2017-05-30 04:17:01','2017-05-30 04:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3274,8,'2017-05-30 04:18:02','2017-05-30 04:18:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3275,8,'2017-05-30 04:19:01','2017-05-30 04:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3276,8,'2017-05-30 04:20:01','2017-05-30 04:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3277,8,'2017-05-30 04:21:01','2017-05-30 04:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3278,8,'2017-05-30 04:22:02','2017-05-30 04:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3279,8,'2017-05-30 04:23:01','2017-05-30 04:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3280,8,'2017-05-30 04:24:01','2017-05-30 04:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3281,8,'2017-05-30 04:25:01','2017-05-30 04:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3282,8,'2017-05-30 04:26:01','2017-05-30 04:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3283,8,'2017-05-30 04:27:02','2017-05-30 04:27:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3284,8,'2017-05-30 04:28:01','2017-05-30 04:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3285,8,'2017-05-30 04:29:01','2017-05-30 04:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3286,8,'2017-05-30 04:30:01','2017-05-30 04:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3287,8,'2017-05-30 04:31:01','2017-05-30 04:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3288,8,'2017-05-30 04:32:01','2017-05-30 04:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3289,8,'2017-05-30 04:33:01','2017-05-30 04:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3290,8,'2017-05-30 04:34:01','2017-05-30 04:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3291,8,'2017-05-30 04:35:02','2017-05-30 04:35:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3292,8,'2017-05-30 04:36:01','2017-05-30 04:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3293,8,'2017-05-30 04:37:01','2017-05-30 04:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3294,8,'2017-05-30 04:38:01','2017-05-30 04:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3295,8,'2017-05-30 04:39:01','2017-05-30 04:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3296,8,'2017-05-30 04:40:01','2017-05-30 04:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3297,8,'2017-05-30 04:41:01','2017-05-30 04:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3298,8,'2017-05-30 04:42:01','2017-05-30 04:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3299,8,'2017-05-30 04:43:01','2017-05-30 04:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3300,8,'2017-05-30 04:44:01','2017-05-30 04:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3301,8,'2017-05-30 04:45:01','2017-05-30 04:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3302,8,'2017-05-30 04:46:01','2017-05-30 04:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3303,8,'2017-05-30 04:47:01','2017-05-30 04:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3304,8,'2017-05-30 04:48:01','2017-05-30 04:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3305,8,'2017-05-30 04:49:01','2017-05-30 04:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3306,8,'2017-05-30 04:50:01','2017-05-30 04:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3307,8,'2017-05-30 04:51:01','2017-05-30 04:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3308,8,'2017-05-30 04:52:02','2017-05-30 04:52:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3309,8,'2017-05-30 04:53:01','2017-05-30 04:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3310,8,'2017-05-30 04:54:01','2017-05-30 04:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3311,8,'2017-05-30 04:55:01','2017-05-30 04:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3312,8,'2017-05-30 04:56:01','2017-05-30 04:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3313,8,'2017-05-30 04:57:01','2017-05-30 04:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3314,8,'2017-05-30 04:58:01','2017-05-30 04:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3315,8,'2017-05-30 04:59:01','2017-05-30 04:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3316,8,'2017-05-30 05:00:01','2017-05-30 05:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3317,8,'2017-05-30 05:01:02','2017-05-30 05:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3318,8,'2017-05-30 05:02:01','2017-05-30 05:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3319,8,'2017-05-30 05:03:01','2017-05-30 05:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3320,8,'2017-05-30 05:04:01','2017-05-30 05:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3321,8,'2017-05-30 05:05:02','2017-05-30 05:05:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3322,8,'2017-05-30 05:06:01','2017-05-30 05:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3323,8,'2017-05-30 05:07:01','2017-05-30 05:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3324,8,'2017-05-30 05:08:01','2017-05-30 05:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3325,8,'2017-05-30 05:09:01','2017-05-30 05:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3326,8,'2017-05-30 05:10:01','2017-05-30 05:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3327,8,'2017-05-30 05:11:01','2017-05-30 05:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3328,8,'2017-05-30 05:12:01','2017-05-30 05:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3329,8,'2017-05-30 05:13:01','2017-05-30 05:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3330,8,'2017-05-30 05:14:01','2017-05-30 05:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3331,8,'2017-05-30 05:15:01','2017-05-30 05:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3332,8,'2017-05-30 05:16:01','2017-05-30 05:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3333,8,'2017-05-30 05:17:01','2017-05-30 05:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3334,8,'2017-05-30 05:18:01','2017-05-30 05:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3335,8,'2017-05-30 05:19:01','2017-05-30 05:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3336,8,'2017-05-30 05:20:01','2017-05-30 05:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3337,8,'2017-05-30 05:21:01','2017-05-30 05:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3338,8,'2017-05-30 05:22:01','2017-05-30 05:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3339,8,'2017-05-30 05:23:01','2017-05-30 05:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3340,8,'2017-05-30 05:24:01','2017-05-30 05:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3341,8,'2017-05-30 05:25:01','2017-05-30 05:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3342,8,'2017-05-30 05:26:01','2017-05-30 05:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3343,8,'2017-05-30 05:27:01','2017-05-30 05:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3344,8,'2017-05-30 05:28:01','2017-05-30 05:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3345,8,'2017-05-30 05:29:01','2017-05-30 05:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3346,8,'2017-05-30 05:30:01','2017-05-30 05:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3347,8,'2017-05-30 05:31:01','2017-05-30 05:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3348,8,'2017-05-30 05:32:01','2017-05-30 05:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3349,8,'2017-05-30 05:33:01','2017-05-30 05:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3350,8,'2017-05-30 05:34:01','2017-05-30 05:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3351,8,'2017-05-30 05:35:01','2017-05-30 05:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3352,8,'2017-05-30 05:36:01','2017-05-30 05:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3353,8,'2017-05-30 05:37:02','2017-05-30 05:37:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3354,8,'2017-05-30 05:38:01','2017-05-30 05:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3355,8,'2017-05-30 05:39:01','2017-05-30 05:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3356,8,'2017-05-30 05:40:01','2017-05-30 05:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3357,8,'2017-05-30 05:41:01','2017-05-30 05:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3358,8,'2017-05-30 05:42:02','2017-05-30 05:42:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3359,8,'2017-05-30 05:43:01','2017-05-30 05:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3360,8,'2017-05-30 05:44:01','2017-05-30 05:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3361,8,'2017-05-30 05:45:01','2017-05-30 05:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3362,8,'2017-05-30 05:46:02','2017-05-30 05:46:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3363,8,'2017-05-30 05:47:01','2017-05-30 05:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3364,8,'2017-05-30 05:48:01','2017-05-30 05:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3365,8,'2017-05-30 05:49:01','2017-05-30 05:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3366,8,'2017-05-30 05:50:01','2017-05-30 05:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3367,8,'2017-05-30 05:51:01','2017-05-30 05:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3368,8,'2017-05-30 05:52:01','2017-05-30 05:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3369,8,'2017-05-30 05:53:02','2017-05-30 05:53:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3370,8,'2017-05-30 05:54:01','2017-05-30 05:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3371,8,'2017-05-30 05:55:01','2017-05-30 05:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3372,8,'2017-05-30 05:56:01','2017-05-30 05:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3373,8,'2017-05-30 05:57:01','2017-05-30 05:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3374,8,'2017-05-30 05:58:01','2017-05-30 05:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3375,8,'2017-05-30 05:59:01','2017-05-30 05:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3376,8,'2017-05-30 06:00:01','2017-05-30 06:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3377,8,'2017-05-30 06:01:02','2017-05-30 06:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3378,8,'2017-05-30 06:02:01','2017-05-30 06:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3379,8,'2017-05-30 06:03:01','2017-05-30 06:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3380,8,'2017-05-30 06:04:01','2017-05-30 06:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3381,8,'2017-05-30 06:05:01','2017-05-30 06:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3382,8,'2017-05-30 06:06:01','2017-05-30 06:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3383,8,'2017-05-30 06:07:01','2017-05-30 06:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3384,8,'2017-05-30 06:08:01','2017-05-30 06:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3385,8,'2017-05-30 06:09:01','2017-05-30 06:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3386,8,'2017-05-30 06:10:01','2017-05-30 06:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3387,8,'2017-05-30 06:11:01','2017-05-30 06:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3388,8,'2017-05-30 06:12:01','2017-05-30 06:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3389,8,'2017-05-30 06:13:01','2017-05-30 06:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3390,8,'2017-05-30 06:14:01','2017-05-30 06:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3391,8,'2017-05-30 06:15:02','2017-05-30 06:15:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3392,8,'2017-05-30 06:16:01','2017-05-30 06:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3393,8,'2017-05-30 06:17:01','2017-05-30 06:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3394,8,'2017-05-30 06:18:01','2017-05-30 06:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3395,8,'2017-05-30 06:19:01','2017-05-30 06:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3396,8,'2017-05-30 06:20:01','2017-05-30 06:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3397,8,'2017-05-30 06:21:01','2017-05-30 06:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3398,8,'2017-05-30 06:22:01','2017-05-30 06:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3399,8,'2017-05-30 06:23:01','2017-05-30 06:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3400,8,'2017-05-30 06:24:01','2017-05-30 06:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3401,8,'2017-05-30 06:25:01','2017-05-30 06:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3402,8,'2017-05-30 06:26:01','2017-05-30 06:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3403,8,'2017-05-30 06:27:01','2017-05-30 06:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3404,8,'2017-05-30 06:28:01','2017-05-30 06:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3405,8,'2017-05-30 06:29:01','2017-05-30 06:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3406,8,'2017-05-30 06:30:01','2017-05-30 06:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3407,8,'2017-05-30 06:31:01','2017-05-30 06:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3408,8,'2017-05-30 06:32:01','2017-05-30 06:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3409,8,'2017-05-30 06:33:01','2017-05-30 06:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3410,8,'2017-05-30 06:34:01','2017-05-30 06:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3411,8,'2017-05-30 06:35:01','2017-05-30 06:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3412,8,'2017-05-30 06:36:01','2017-05-30 06:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3413,8,'2017-05-30 06:37:01','2017-05-30 06:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3414,8,'2017-05-30 06:38:01','2017-05-30 06:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3415,8,'2017-05-30 06:39:01','2017-05-30 06:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3416,8,'2017-05-30 06:40:02','2017-05-30 06:40:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3417,8,'2017-05-30 06:41:01','2017-05-30 06:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3418,8,'2017-05-30 06:42:01','2017-05-30 06:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3419,8,'2017-05-30 06:43:01','2017-05-30 06:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3420,8,'2017-05-30 06:44:01','2017-05-30 06:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3421,8,'2017-05-30 06:45:01','2017-05-30 06:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3422,8,'2017-05-30 06:46:01','2017-05-30 06:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3423,8,'2017-05-30 06:47:01','2017-05-30 06:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3424,8,'2017-05-30 06:48:01','2017-05-30 06:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3425,8,'2017-05-30 06:49:01','2017-05-30 06:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3426,8,'2017-05-30 06:50:01','2017-05-30 06:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3427,8,'2017-05-30 06:51:02','2017-05-30 06:51:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3428,8,'2017-05-30 06:52:01','2017-05-30 06:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3429,8,'2017-05-30 06:53:01','2017-05-30 06:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3430,8,'2017-05-30 06:54:01','2017-05-30 06:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3431,8,'2017-05-30 06:55:01','2017-05-30 06:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3432,8,'2017-05-30 06:56:01','2017-05-30 06:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3433,8,'2017-05-30 06:57:01','2017-05-30 06:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3434,8,'2017-05-30 06:58:01','2017-05-30 06:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3435,8,'2017-05-30 06:59:01','2017-05-30 06:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3436,8,'2017-05-30 07:00:01','2017-05-30 07:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3437,8,'2017-05-30 07:01:01','2017-05-30 07:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3438,8,'2017-05-30 07:02:01','2017-05-30 07:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3439,8,'2017-05-30 07:03:01','2017-05-30 07:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3440,8,'2017-05-30 07:04:01','2017-05-30 07:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3441,8,'2017-05-30 07:05:01','2017-05-30 07:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3442,8,'2017-05-30 07:06:01','2017-05-30 07:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3443,8,'2017-05-30 07:07:01','2017-05-30 07:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3444,8,'2017-05-30 07:08:01','2017-05-30 07:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3445,8,'2017-05-30 07:09:01','2017-05-30 07:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3446,8,'2017-05-30 07:10:01','2017-05-30 07:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3447,8,'2017-05-30 07:11:01','2017-05-30 07:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3448,8,'2017-05-30 07:12:01','2017-05-30 07:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3449,8,'2017-05-30 07:13:01','2017-05-30 07:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3450,8,'2017-05-30 07:14:01','2017-05-30 07:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3451,8,'2017-05-30 07:15:02','2017-05-30 07:15:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3452,8,'2017-05-30 07:16:01','2017-05-30 07:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3453,8,'2017-05-30 07:17:01','2017-05-30 07:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3454,8,'2017-05-30 07:18:02','2017-05-30 07:18:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3455,8,'2017-05-30 07:19:01','2017-05-30 07:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3456,8,'2017-05-30 07:20:01','2017-05-30 07:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3457,8,'2017-05-30 07:21:01','2017-05-30 07:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3458,8,'2017-05-30 07:22:01','2017-05-30 07:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3459,8,'2017-05-30 07:23:01','2017-05-30 07:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3460,8,'2017-05-30 07:24:01','2017-05-30 07:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3461,8,'2017-05-30 07:25:01','2017-05-30 07:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3462,8,'2017-05-30 07:26:01','2017-05-30 07:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3463,8,'2017-05-30 07:27:01','2017-05-30 07:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3464,8,'2017-05-30 07:28:01','2017-05-30 07:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3465,8,'2017-05-30 07:29:01','2017-05-30 07:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3466,8,'2017-05-30 07:30:01','2017-05-30 07:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3467,8,'2017-05-30 07:31:01','2017-05-30 07:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3468,8,'2017-05-30 07:32:02','2017-05-30 07:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3469,8,'2017-05-30 07:33:01','2017-05-30 07:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3470,8,'2017-05-30 07:34:01','2017-05-30 07:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3471,8,'2017-05-30 07:35:02','2017-05-30 07:35:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3472,8,'2017-05-30 07:36:01','2017-05-30 07:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3473,8,'2017-05-30 07:37:01','2017-05-30 07:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3474,8,'2017-05-30 07:38:01','2017-05-30 07:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3475,8,'2017-05-30 07:39:01','2017-05-30 07:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3476,8,'2017-05-30 07:40:01','2017-05-30 07:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3477,8,'2017-05-30 07:41:01','2017-05-30 07:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3478,8,'2017-05-30 07:42:01','2017-05-30 07:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3479,8,'2017-05-30 07:43:01','2017-05-30 07:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3480,8,'2017-05-30 07:44:01','2017-05-30 07:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3481,8,'2017-05-30 07:45:01','2017-05-30 07:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3482,8,'2017-05-30 07:46:01','2017-05-30 07:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3483,8,'2017-05-30 07:47:01','2017-05-30 07:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3484,8,'2017-05-30 07:48:01','2017-05-30 07:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3485,8,'2017-05-30 07:49:01','2017-05-30 07:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3486,8,'2017-05-30 07:50:01','2017-05-30 07:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3487,8,'2017-05-30 07:51:01','2017-05-30 07:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3488,8,'2017-05-30 07:52:01','2017-05-30 07:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3489,8,'2017-05-30 07:53:01','2017-05-30 07:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3490,8,'2017-05-30 07:54:01','2017-05-30 07:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3491,8,'2017-05-30 07:55:01','2017-05-30 07:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3492,8,'2017-05-30 07:56:01','2017-05-30 07:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3493,8,'2017-05-30 07:57:01','2017-05-30 07:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3494,8,'2017-05-30 07:58:01','2017-05-30 07:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3495,8,'2017-05-30 07:59:01','2017-05-30 07:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3496,8,'2017-05-30 08:00:01','2017-05-30 08:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3497,8,'2017-05-30 08:01:01','2017-05-30 08:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3498,8,'2017-05-30 08:02:01','2017-05-30 08:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3499,8,'2017-05-30 08:03:01','2017-05-30 08:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3500,8,'2017-05-30 08:04:01','2017-05-30 08:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3501,8,'2017-05-30 08:05:01','2017-05-30 08:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3502,8,'2017-05-30 08:06:01','2017-05-30 08:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3503,8,'2017-05-30 08:07:02','2017-05-30 08:07:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3504,8,'2017-05-30 08:08:01','2017-05-30 08:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3505,8,'2017-05-30 08:09:02','2017-05-30 08:09:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3506,8,'2017-05-30 08:10:01','2017-05-30 08:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3507,8,'2017-05-30 08:11:01','2017-05-30 08:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3508,8,'2017-05-30 08:12:01','2017-05-30 08:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3509,8,'2017-05-30 08:13:01','2017-05-30 08:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3510,8,'2017-05-30 08:14:01','2017-05-30 08:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3511,8,'2017-05-30 08:15:01','2017-05-30 08:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3512,8,'2017-05-30 08:16:01','2017-05-30 08:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3513,8,'2017-05-30 08:17:01','2017-05-30 08:17:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3514,8,'2017-05-30 08:18:01','2017-05-30 08:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3515,8,'2017-05-30 08:19:01','2017-05-30 08:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3516,8,'2017-05-30 08:20:01','2017-05-30 08:20:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3517,8,'2017-05-30 08:21:01','2017-05-30 08:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3518,8,'2017-05-30 08:22:01','2017-05-30 08:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3519,8,'2017-05-30 08:23:01','2017-05-30 08:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3520,8,'2017-05-30 08:24:01','2017-05-30 08:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3521,8,'2017-05-30 08:25:01','2017-05-30 08:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3522,8,'2017-05-30 08:26:01','2017-05-30 08:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3523,8,'2017-05-30 08:27:01','2017-05-30 08:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3524,8,'2017-05-30 08:28:01','2017-05-30 08:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3525,8,'2017-05-30 08:29:01','2017-05-30 08:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3526,8,'2017-05-30 08:30:01','2017-05-30 08:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3527,8,'2017-05-30 08:31:01','2017-05-30 08:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3528,8,'2017-05-30 08:32:01','2017-05-30 08:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3529,8,'2017-05-30 08:33:02','2017-05-30 08:33:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3530,8,'2017-05-30 08:34:01','2017-05-30 08:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3531,8,'2017-05-30 08:35:02','2017-05-30 08:35:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3532,8,'2017-05-30 08:36:01','2017-05-30 08:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3533,8,'2017-05-30 08:37:01','2017-05-30 08:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3534,8,'2017-05-30 08:38:01','2017-05-30 08:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3535,8,'2017-05-30 08:39:01','2017-05-30 08:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3536,8,'2017-05-30 08:40:01','2017-05-30 08:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3537,8,'2017-05-30 08:41:01','2017-05-30 08:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3538,8,'2017-05-30 08:42:01','2017-05-30 08:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3539,8,'2017-05-30 08:43:01','2017-05-30 08:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3540,8,'2017-05-30 08:44:01','2017-05-30 08:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3541,8,'2017-05-30 08:45:01','2017-05-30 08:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3542,8,'2017-05-30 08:46:01','2017-05-30 08:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3543,8,'2017-05-30 08:47:01','2017-05-30 08:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3544,8,'2017-05-30 08:48:01','2017-05-30 08:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3545,8,'2017-05-30 08:49:01','2017-05-30 08:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3546,8,'2017-05-30 08:50:01','2017-05-30 08:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3547,8,'2017-05-30 08:51:01','2017-05-30 08:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3548,8,'2017-05-30 08:52:01','2017-05-30 08:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3549,8,'2017-05-30 08:53:01','2017-05-30 08:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3550,8,'2017-05-30 08:54:01','2017-05-30 08:54:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3551,8,'2017-05-30 08:55:01','2017-05-30 08:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3552,8,'2017-05-30 08:56:01','2017-05-30 08:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3553,8,'2017-05-30 08:57:01','2017-05-30 08:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3554,8,'2017-05-30 08:58:01','2017-05-30 08:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3555,8,'2017-05-30 08:59:01','2017-05-30 08:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3556,8,'2017-05-30 09:00:02','2017-05-30 09:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3557,8,'2017-05-30 09:01:01','2017-05-30 09:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3558,8,'2017-05-30 09:02:01','2017-05-30 09:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3559,8,'2017-05-30 09:03:01','2017-05-30 09:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3560,8,'2017-05-30 09:04:01','2017-05-30 09:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3561,8,'2017-05-30 09:05:01','2017-05-30 09:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3562,8,'2017-05-30 09:06:01','2017-05-30 09:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3563,8,'2017-05-30 09:07:01','2017-05-30 09:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3564,8,'2017-05-30 09:08:01','2017-05-30 09:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3565,8,'2017-05-30 09:09:01','2017-05-30 09:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3566,8,'2017-05-30 09:10:01','2017-05-30 09:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3567,8,'2017-05-30 09:11:01','2017-05-30 09:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3568,8,'2017-05-30 09:12:01','2017-05-30 09:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3569,8,'2017-05-30 09:13:01','2017-05-30 09:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3570,8,'2017-05-30 09:14:01','2017-05-30 09:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3571,8,'2017-05-30 09:15:01','2017-05-30 09:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3572,8,'2017-05-30 09:16:01','2017-05-30 09:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3573,8,'2017-05-30 09:17:01','2017-05-30 09:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3574,8,'2017-05-30 09:18:01','2017-05-30 09:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3575,8,'2017-05-30 09:19:01','2017-05-30 09:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3576,8,'2017-05-30 09:20:01','2017-05-30 09:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3577,8,'2017-05-30 09:21:02','2017-05-30 09:21:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3578,8,'2017-05-30 09:22:01','2017-05-30 09:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3579,8,'2017-05-30 09:23:02','2017-05-30 09:23:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3580,8,'2017-05-30 09:24:01','2017-05-30 09:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3581,8,'2017-05-30 09:25:01','2017-05-30 09:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3582,8,'2017-05-30 09:26:01','2017-05-30 09:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3583,8,'2017-05-30 09:27:01','2017-05-30 09:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3584,8,'2017-05-30 09:28:01','2017-05-30 09:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3585,8,'2017-05-30 09:29:01','2017-05-30 09:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3586,8,'2017-05-30 09:30:01','2017-05-30 09:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3587,8,'2017-05-30 09:31:01','2017-05-30 09:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3588,8,'2017-05-30 09:32:01','2017-05-30 09:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3589,8,'2017-05-30 09:33:01','2017-05-30 09:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3590,8,'2017-05-30 09:34:01','2017-05-30 09:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3591,8,'2017-05-30 09:35:01','2017-05-30 09:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3592,8,'2017-05-30 09:36:01','2017-05-30 09:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3593,8,'2017-05-30 09:37:01','2017-05-30 09:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3594,8,'2017-05-30 09:38:02','2017-05-30 09:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3595,8,'2017-05-30 09:39:01','2017-05-30 09:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3596,8,'2017-05-30 09:40:01','2017-05-30 09:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3597,8,'2017-05-30 09:41:01','2017-05-30 09:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3598,8,'2017-05-30 09:42:01','2017-05-30 09:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3599,8,'2017-05-30 09:43:01','2017-05-30 09:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3600,8,'2017-05-30 09:44:01','2017-05-30 09:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3601,8,'2017-05-30 09:45:01','2017-05-30 09:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3602,8,'2017-05-30 09:46:01','2017-05-30 09:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3603,8,'2017-05-30 09:47:01','2017-05-30 09:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3604,8,'2017-05-30 09:48:01','2017-05-30 09:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3605,8,'2017-05-30 09:49:01','2017-05-30 09:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3606,8,'2017-05-30 09:50:01','2017-05-30 09:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3607,8,'2017-05-30 09:51:01','2017-05-30 09:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3608,8,'2017-05-30 09:52:01','2017-05-30 09:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3609,8,'2017-05-30 09:53:01','2017-05-30 09:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3610,8,'2017-05-30 09:54:01','2017-05-30 09:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3611,8,'2017-05-30 09:55:01','2017-05-30 09:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3612,8,'2017-05-30 09:56:01','2017-05-30 09:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3613,8,'2017-05-30 09:57:01','2017-05-30 09:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3614,8,'2017-05-30 09:58:01','2017-05-30 09:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3615,8,'2017-05-30 09:59:01','2017-05-30 09:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3616,8,'2017-05-30 10:00:02','2017-05-30 10:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3617,8,'2017-05-30 10:01:01','2017-05-30 10:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3618,8,'2017-05-30 10:02:01','2017-05-30 10:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3619,8,'2017-05-30 10:03:02','2017-05-30 10:03:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3620,8,'2017-05-30 10:04:01','2017-05-30 10:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3621,8,'2017-05-30 10:05:01','2017-05-30 10:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3622,8,'2017-05-30 10:06:01','2017-05-30 10:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3623,8,'2017-05-30 10:07:01','2017-05-30 10:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3624,8,'2017-05-30 10:08:01','2017-05-30 10:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3625,8,'2017-05-30 10:09:01','2017-05-30 10:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3626,8,'2017-05-30 10:10:01','2017-05-30 10:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3627,8,'2017-05-30 10:11:01','2017-05-30 10:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3628,8,'2017-05-30 10:12:01','2017-05-30 10:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3629,8,'2017-05-30 10:13:01','2017-05-30 10:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3630,8,'2017-05-30 10:14:01','2017-05-30 10:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3631,8,'2017-05-30 10:15:01','2017-05-30 10:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3632,8,'2017-05-30 10:16:01','2017-05-30 10:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3633,8,'2017-05-30 10:17:01','2017-05-30 10:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3634,8,'2017-05-30 10:18:02','2017-05-30 10:18:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3635,8,'2017-05-30 10:19:01','2017-05-30 10:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3636,8,'2017-05-30 10:20:01','2017-05-30 10:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3637,8,'2017-05-30 10:21:02','2017-05-30 10:21:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3638,8,'2017-05-30 10:22:01','2017-05-30 10:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3639,8,'2017-05-30 10:23:01','2017-05-30 10:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3640,8,'2017-05-30 10:24:01','2017-05-30 10:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3641,8,'2017-05-30 10:25:01','2017-05-30 10:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3642,8,'2017-05-30 10:26:01','2017-05-30 10:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3643,8,'2017-05-30 10:27:01','2017-05-30 10:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3644,8,'2017-05-30 10:28:01','2017-05-30 10:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3645,8,'2017-05-30 10:29:02','2017-05-30 10:29:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3646,8,'2017-05-30 10:30:01','2017-05-30 10:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3647,8,'2017-05-30 10:31:01','2017-05-30 10:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3648,8,'2017-05-30 10:32:02','2017-05-30 10:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3649,8,'2017-05-30 10:33:01','2017-05-30 10:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3650,8,'2017-05-30 10:34:01','2017-05-30 10:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3651,8,'2017-05-30 10:35:01','2017-05-30 10:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3652,8,'2017-05-30 10:36:01','2017-05-30 10:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3653,8,'2017-05-30 10:37:01','2017-05-30 10:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3654,8,'2017-05-30 10:38:01','2017-05-30 10:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3655,8,'2017-05-30 10:39:01','2017-05-30 10:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3656,8,'2017-05-30 10:40:01','2017-05-30 10:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3657,8,'2017-05-30 10:41:01','2017-05-30 10:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3658,8,'2017-05-30 10:42:01','2017-05-30 10:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3659,8,'2017-05-30 10:43:01','2017-05-30 10:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3660,8,'2017-05-30 10:44:01','2017-05-30 10:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3661,8,'2017-05-30 10:45:01','2017-05-30 10:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3662,8,'2017-05-30 10:46:01','2017-05-30 10:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3663,8,'2017-05-30 10:47:01','2017-05-30 10:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3664,8,'2017-05-30 10:48:01','2017-05-30 10:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3665,8,'2017-05-30 10:49:01','2017-05-30 10:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3666,8,'2017-05-30 10:50:01','2017-05-30 10:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3667,8,'2017-05-30 10:51:01','2017-05-30 10:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3668,8,'2017-05-30 10:52:01','2017-05-30 10:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3669,8,'2017-05-30 10:53:01','2017-05-30 10:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3670,8,'2017-05-30 10:54:01','2017-05-30 10:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3671,8,'2017-05-30 10:55:01','2017-05-30 10:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3672,8,'2017-05-30 10:56:01','2017-05-30 10:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3673,8,'2017-05-30 10:57:01','2017-05-30 10:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3674,8,'2017-05-30 10:58:01','2017-05-30 10:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3675,8,'2017-05-30 10:59:01','2017-05-30 10:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3676,8,'2017-05-30 11:00:01','2017-05-30 11:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3677,8,'2017-05-30 11:01:01','2017-05-30 11:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3678,8,'2017-05-30 11:02:01','2017-05-30 11:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3679,8,'2017-05-30 11:03:01','2017-05-30 11:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3680,8,'2017-05-30 11:04:01','2017-05-30 11:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3681,8,'2017-05-30 11:05:01','2017-05-30 11:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3682,8,'2017-05-30 11:06:01','2017-05-30 11:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3683,8,'2017-05-30 11:07:01','2017-05-30 11:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3684,8,'2017-05-30 11:08:01','2017-05-30 11:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3685,8,'2017-05-30 11:09:01','2017-05-30 11:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3686,8,'2017-05-30 11:10:01','2017-05-30 11:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3687,8,'2017-05-30 11:11:01','2017-05-30 11:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3688,8,'2017-05-30 11:12:01','2017-05-30 11:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3689,8,'2017-05-30 11:13:01','2017-05-30 11:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3690,8,'2017-05-30 11:14:01','2017-05-30 11:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3691,8,'2017-05-30 11:15:01','2017-05-30 11:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3692,8,'2017-05-30 11:16:02','2017-05-30 11:16:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3693,8,'2017-05-30 11:17:01','2017-05-30 11:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3694,8,'2017-05-30 11:18:01','2017-05-30 11:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3695,8,'2017-05-30 11:19:01','2017-05-30 11:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3696,8,'2017-05-30 11:20:01','2017-05-30 11:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3697,8,'2017-05-30 11:21:01','2017-05-30 11:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3698,8,'2017-05-30 11:22:01','2017-05-30 11:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3699,8,'2017-05-30 11:23:01','2017-05-30 11:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3700,8,'2017-05-30 11:24:01','2017-05-30 11:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3701,8,'2017-05-30 11:25:01','2017-05-30 11:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3702,8,'2017-05-30 11:26:01','2017-05-30 11:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3703,8,'2017-05-30 11:27:01','2017-05-30 11:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3704,8,'2017-05-30 11:28:01','2017-05-30 11:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3705,8,'2017-05-30 11:29:01','2017-05-30 11:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3706,8,'2017-05-30 11:30:01','2017-05-30 11:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3707,8,'2017-05-30 11:31:01','2017-05-30 11:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3708,8,'2017-05-30 11:32:01','2017-05-30 11:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3709,8,'2017-05-30 11:33:01','2017-05-30 11:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3710,8,'2017-05-30 11:34:01','2017-05-30 11:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3711,8,'2017-05-30 11:35:01','2017-05-30 11:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3712,8,'2017-05-30 11:36:01','2017-05-30 11:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3713,8,'2017-05-30 11:37:01','2017-05-30 11:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3714,8,'2017-05-30 11:38:01','2017-05-30 11:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3715,8,'2017-05-30 11:39:01','2017-05-30 11:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3716,8,'2017-05-30 11:40:01','2017-05-30 11:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3717,8,'2017-05-30 11:41:02','2017-05-30 11:41:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3718,8,'2017-05-30 11:42:01','2017-05-30 11:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3719,8,'2017-05-30 11:43:01','2017-05-30 11:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3720,8,'2017-05-30 11:44:01','2017-05-30 11:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3721,8,'2017-05-30 11:45:01','2017-05-30 11:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3722,8,'2017-05-30 11:46:01','2017-05-30 11:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3723,8,'2017-05-30 11:47:01','2017-05-30 11:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3724,8,'2017-05-30 11:48:01','2017-05-30 11:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3725,8,'2017-05-30 11:49:01','2017-05-30 11:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3726,8,'2017-05-30 11:50:01','2017-05-30 11:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3727,8,'2017-05-30 11:51:01','2017-05-30 11:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3728,8,'2017-05-30 11:52:01','2017-05-30 11:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3729,8,'2017-05-30 11:53:02','2017-05-30 11:53:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3730,8,'2017-05-30 11:54:01','2017-05-30 11:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3731,8,'2017-05-30 11:55:01','2017-05-30 11:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3732,8,'2017-05-30 11:56:01','2017-05-30 11:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3733,8,'2017-05-30 11:57:01','2017-05-30 11:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3734,8,'2017-05-30 11:58:02','2017-05-30 11:58:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3735,8,'2017-05-30 11:59:26','2017-05-30 11:59:26','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3736,8,'2017-05-30 12:00:08','2017-05-30 12:00:08','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3737,8,'2017-05-30 12:01:02','2017-05-30 12:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3738,8,'2017-05-30 12:02:04','2017-05-30 12:02:04','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3739,8,'2017-05-30 12:03:01','2017-05-30 12:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3740,8,'2017-05-30 12:04:01','2017-05-30 12:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3741,8,'2017-05-30 12:05:01','2017-05-30 12:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3742,8,'2017-05-30 12:06:01','2017-05-30 12:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3743,8,'2017-05-30 12:07:01','2017-05-30 12:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3744,8,'2017-05-30 12:08:02','2017-05-30 12:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3745,8,'2017-05-30 12:09:01','2017-05-30 12:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3746,8,'2017-05-30 12:10:01','2017-05-30 12:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3747,8,'2017-05-30 12:11:01','2017-05-30 12:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3748,8,'2017-05-30 12:12:01','2017-05-30 12:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3749,8,'2017-05-30 12:13:01','2017-05-30 12:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3750,8,'2017-05-30 12:14:01','2017-05-30 12:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3751,8,'2017-05-30 12:15:01','2017-05-30 12:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3752,8,'2017-05-30 12:16:01','2017-05-30 12:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3753,8,'2017-05-30 12:17:01','2017-05-30 12:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3754,8,'2017-05-30 12:18:01','2017-05-30 12:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3755,8,'2017-05-30 12:19:01','2017-05-30 12:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3756,8,'2017-05-30 12:20:01','2017-05-30 12:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3757,8,'2017-05-30 12:21:02','2017-05-30 12:21:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3758,8,'2017-05-30 12:22:01','2017-05-30 12:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3759,8,'2017-05-30 12:23:01','2017-05-30 12:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3760,8,'2017-05-30 12:24:01','2017-05-30 12:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3761,8,'2017-05-30 12:25:01','2017-05-30 12:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3762,8,'2017-05-30 12:26:01','2017-05-30 12:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3763,8,'2017-05-30 12:27:01','2017-05-30 12:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3764,8,'2017-05-30 12:28:01','2017-05-30 12:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3765,8,'2017-05-30 12:29:01','2017-05-30 12:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3766,8,'2017-05-30 12:30:01','2017-05-30 12:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3767,8,'2017-05-30 12:31:01','2017-05-30 12:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3768,8,'2017-05-30 12:32:01','2017-05-30 12:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3769,8,'2017-05-30 12:33:01','2017-05-30 12:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3770,8,'2017-05-30 12:34:01','2017-05-30 12:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3771,8,'2017-05-30 12:35:01','2017-05-30 12:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3772,8,'2017-05-30 12:36:01','2017-05-30 12:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3773,8,'2017-05-30 12:37:01','2017-05-30 12:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3774,8,'2017-05-30 12:38:01','2017-05-30 12:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3775,8,'2017-05-30 12:39:01','2017-05-30 12:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3776,8,'2017-05-30 12:40:01','2017-05-30 12:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3777,8,'2017-05-30 12:41:01','2017-05-30 12:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3778,8,'2017-05-30 12:42:01','2017-05-30 12:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3779,8,'2017-05-30 12:43:01','2017-05-30 12:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3780,8,'2017-05-30 12:44:01','2017-05-30 12:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3781,8,'2017-05-30 12:45:01','2017-05-30 12:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3782,8,'2017-05-30 12:46:01','2017-05-30 12:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3783,8,'2017-05-30 12:47:01','2017-05-30 12:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3784,8,'2017-05-30 12:48:01','2017-05-30 12:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3785,8,'2017-05-30 12:49:01','2017-05-30 12:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3786,8,'2017-05-30 12:50:01','2017-05-30 12:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3787,8,'2017-05-30 12:51:01','2017-05-30 12:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3788,8,'2017-05-30 12:52:01','2017-05-30 12:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3789,8,'2017-05-30 12:53:01','2017-05-30 12:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3790,8,'2017-05-30 12:54:01','2017-05-30 12:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3791,8,'2017-05-30 12:55:01','2017-05-30 12:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3792,8,'2017-05-30 12:56:01','2017-05-30 12:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3793,8,'2017-05-30 12:57:01','2017-05-30 12:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3794,8,'2017-05-30 12:58:01','2017-05-30 12:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3795,8,'2017-05-30 12:59:01','2017-05-30 12:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3796,8,'2017-05-30 13:00:01','2017-05-30 13:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3797,8,'2017-05-30 13:01:01','2017-05-30 13:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3798,8,'2017-05-30 13:02:01','2017-05-30 13:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3799,8,'2017-05-30 13:03:01','2017-05-30 13:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3800,8,'2017-05-30 13:04:01','2017-05-30 13:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3801,8,'2017-05-30 13:05:02','2017-05-30 13:05:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3802,8,'2017-05-30 13:06:01','2017-05-30 13:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3803,8,'2017-05-30 13:07:01','2017-05-30 13:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3804,8,'2017-05-30 13:08:01','2017-05-30 13:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3805,8,'2017-05-30 13:09:01','2017-05-30 13:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3806,8,'2017-05-30 13:10:01','2017-05-30 13:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3807,8,'2017-05-30 13:11:02','2017-05-30 13:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3808,8,'2017-05-30 13:12:01','2017-05-30 13:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3809,8,'2017-05-30 13:13:01','2017-05-30 13:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3810,8,'2017-05-30 13:14:01','2017-05-30 13:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3811,8,'2017-05-30 13:15:01','2017-05-30 13:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3812,8,'2017-05-30 13:16:01','2017-05-30 13:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3813,8,'2017-05-30 13:17:01','2017-05-30 13:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3814,8,'2017-05-30 13:18:01','2017-05-30 13:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3815,8,'2017-05-30 13:19:01','2017-05-30 13:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3816,8,'2017-05-30 13:20:01','2017-05-30 13:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3817,8,'2017-05-30 13:21:01','2017-05-30 13:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3818,8,'2017-05-30 13:22:01','2017-05-30 13:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3819,8,'2017-05-30 13:23:01','2017-05-30 13:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3820,8,'2017-05-30 13:24:01','2017-05-30 13:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3821,8,'2017-05-30 13:25:01','2017-05-30 13:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3822,8,'2017-05-30 13:26:01','2017-05-30 13:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3823,8,'2017-05-30 13:27:01','2017-05-30 13:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3824,8,'2017-05-30 13:28:01','2017-05-30 13:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3825,8,'2017-05-30 13:29:01','2017-05-30 13:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3826,8,'2017-05-30 13:30:01','2017-05-30 13:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3827,8,'2017-05-30 13:31:01','2017-05-30 13:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3828,8,'2017-05-30 13:32:01','2017-05-30 13:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3829,8,'2017-05-30 13:33:01','2017-05-30 13:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3830,8,'2017-05-30 13:34:02','2017-05-30 13:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3831,8,'2017-05-30 13:35:01','2017-05-30 13:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3832,8,'2017-05-30 13:36:01','2017-05-30 13:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3833,8,'2017-05-30 13:37:01','2017-05-30 13:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3834,8,'2017-05-30 13:38:02','2017-05-30 13:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3835,8,'2017-05-30 13:39:01','2017-05-30 13:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3836,8,'2017-05-30 13:40:01','2017-05-30 13:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3837,8,'2017-05-30 13:41:01','2017-05-30 13:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3838,8,'2017-05-30 13:42:01','2017-05-30 13:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3839,8,'2017-05-30 13:43:01','2017-05-30 13:43:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3840,8,'2017-05-30 13:44:01','2017-05-30 13:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3841,8,'2017-05-30 13:45:01','2017-05-30 13:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3842,8,'2017-05-30 13:46:01','2017-05-30 13:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3843,8,'2017-05-30 13:47:01','2017-05-30 13:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3844,8,'2017-05-30 13:48:01','2017-05-30 13:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3845,8,'2017-05-30 13:49:01','2017-05-30 13:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3846,8,'2017-05-30 13:50:01','2017-05-30 13:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3847,8,'2017-05-30 13:51:01','2017-05-30 13:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3848,8,'2017-05-30 13:52:01','2017-05-30 13:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3849,8,'2017-05-30 13:53:01','2017-05-30 13:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3850,8,'2017-05-30 13:54:01','2017-05-30 13:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3851,8,'2017-05-30 13:55:01','2017-05-30 13:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3852,8,'2017-05-30 13:56:01','2017-05-30 13:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3853,8,'2017-05-30 13:57:01','2017-05-30 13:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3854,8,'2017-05-30 13:58:01','2017-05-30 13:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3855,8,'2017-05-30 13:59:01','2017-05-30 13:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3856,8,'2017-05-30 14:00:01','2017-05-30 14:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3857,8,'2017-05-30 14:01:02','2017-05-30 14:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3858,8,'2017-05-30 14:02:01','2017-05-30 14:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3859,8,'2017-05-30 14:03:01','2017-05-30 14:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3860,8,'2017-05-30 14:04:01','2017-05-30 14:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3861,8,'2017-05-30 14:05:01','2017-05-30 14:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3862,8,'2017-05-30 14:06:01','2017-05-30 14:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3863,8,'2017-05-30 14:07:01','2017-05-30 14:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3864,8,'2017-05-30 14:08:02','2017-05-30 14:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3865,8,'2017-05-30 14:09:01','2017-05-30 14:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3866,8,'2017-05-30 14:10:01','2017-05-30 14:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3867,8,'2017-05-30 14:11:01','2017-05-30 14:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3868,8,'2017-05-30 14:12:01','2017-05-30 14:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3869,8,'2017-05-30 14:13:01','2017-05-30 14:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3870,8,'2017-05-30 14:14:01','2017-05-30 14:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3871,8,'2017-05-30 14:15:02','2017-05-30 14:15:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3872,8,'2017-05-30 14:16:01','2017-05-30 14:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3873,8,'2017-05-30 14:17:01','2017-05-30 14:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3874,8,'2017-05-30 14:18:01','2017-05-30 14:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3875,8,'2017-05-30 14:19:02','2017-05-30 14:19:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3876,8,'2017-05-30 14:20:01','2017-05-30 14:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3877,8,'2017-05-30 14:21:01','2017-05-30 14:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3878,8,'2017-05-30 14:22:01','2017-05-30 14:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3879,8,'2017-05-30 14:23:01','2017-05-30 14:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3880,8,'2017-05-30 14:24:01','2017-05-30 14:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3881,8,'2017-05-30 14:25:01','2017-05-30 14:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3882,8,'2017-05-30 14:26:01','2017-05-30 14:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3883,8,'2017-05-30 14:27:01','2017-05-30 14:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3884,8,'2017-05-30 14:28:01','2017-05-30 14:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3885,8,'2017-05-30 14:29:01','2017-05-30 14:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3886,8,'2017-05-30 14:30:01','2017-05-30 14:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3887,8,'2017-05-30 14:31:01','2017-05-30 14:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3888,8,'2017-05-30 14:32:01','2017-05-30 14:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3889,8,'2017-05-30 14:33:01','2017-05-30 14:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3890,8,'2017-05-30 14:34:02','2017-05-30 14:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3891,8,'2017-05-30 14:35:01','2017-05-30 14:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3892,8,'2017-05-30 14:36:01','2017-05-30 14:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3893,8,'2017-05-30 14:37:01','2017-05-30 14:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3894,8,'2017-05-30 14:38:02','2017-05-30 14:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3895,8,'2017-05-30 14:39:01','2017-05-30 14:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3896,8,'2017-05-30 14:40:01','2017-05-30 14:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3897,8,'2017-05-30 14:41:02','2017-05-30 14:41:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3898,8,'2017-05-30 14:42:01','2017-05-30 14:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3899,8,'2017-05-30 14:43:01','2017-05-30 14:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3900,8,'2017-05-30 14:44:01','2017-05-30 14:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3901,8,'2017-05-30 14:45:01','2017-05-30 14:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3902,8,'2017-05-30 14:46:01','2017-05-30 14:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3903,8,'2017-05-30 14:47:01','2017-05-30 14:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3904,8,'2017-05-30 14:48:02','2017-05-30 14:48:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3905,8,'2017-05-30 14:49:01','2017-05-30 14:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3906,8,'2017-05-30 14:50:01','2017-05-30 14:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3907,8,'2017-05-30 14:51:01','2017-05-30 14:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3908,8,'2017-05-30 14:52:02','2017-05-30 14:52:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3909,8,'2017-05-30 14:53:01','2017-05-30 14:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3910,8,'2017-05-30 14:54:01','2017-05-30 14:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3911,8,'2017-05-30 14:55:02','2017-05-30 14:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3912,8,'2017-05-30 14:56:01','2017-05-30 14:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3913,8,'2017-05-30 14:57:01','2017-05-30 14:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3914,8,'2017-05-30 14:58:01','2017-05-30 14:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3915,8,'2017-05-30 14:59:01','2017-05-30 14:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3916,8,'2017-05-30 15:00:01','2017-05-30 15:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3917,8,'2017-05-30 15:01:01','2017-05-30 15:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3918,8,'2017-05-30 15:02:01','2017-05-30 15:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3919,8,'2017-05-30 15:03:01','2017-05-30 15:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3920,8,'2017-05-30 15:04:01','2017-05-30 15:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3921,8,'2017-05-30 15:05:01','2017-05-30 15:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3922,8,'2017-05-30 15:06:01','2017-05-30 15:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3923,8,'2017-05-30 15:07:01','2017-05-30 15:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3924,8,'2017-05-30 15:08:01','2017-05-30 15:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3925,8,'2017-05-30 15:09:01','2017-05-30 15:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3926,8,'2017-05-30 15:10:01','2017-05-30 15:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3927,8,'2017-05-30 15:11:01','2017-05-30 15:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3928,8,'2017-05-30 15:12:01','2017-05-30 15:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3929,8,'2017-05-30 15:13:01','2017-05-30 15:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3930,8,'2017-05-30 15:14:01','2017-05-30 15:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3931,8,'2017-05-30 15:15:01','2017-05-30 15:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3932,8,'2017-05-30 15:16:01','2017-05-30 15:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3933,8,'2017-05-30 15:17:01','2017-05-30 15:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3934,8,'2017-05-30 15:18:01','2017-05-30 15:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3935,8,'2017-05-30 15:19:01','2017-05-30 15:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3936,8,'2017-05-30 15:20:02','2017-05-30 15:20:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3937,8,'2017-05-30 15:21:01','2017-05-30 15:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3938,8,'2017-05-30 15:22:01','2017-05-30 15:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3939,8,'2017-05-30 15:23:01','2017-05-30 15:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3940,8,'2017-05-30 15:24:01','2017-05-30 15:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3941,8,'2017-05-30 15:25:01','2017-05-30 15:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3942,8,'2017-05-30 15:26:01','2017-05-30 15:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3943,8,'2017-05-30 15:27:01','2017-05-30 15:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3944,8,'2017-05-30 15:28:01','2017-05-30 15:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3945,8,'2017-05-30 15:29:01','2017-05-30 15:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3946,8,'2017-05-30 15:30:02','2017-05-30 15:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3947,8,'2017-05-30 15:31:01','2017-05-30 15:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3948,8,'2017-05-30 15:32:01','2017-05-30 15:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3949,8,'2017-05-30 15:33:01','2017-05-30 15:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3950,8,'2017-05-30 15:34:01','2017-05-30 15:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3951,8,'2017-05-30 15:35:01','2017-05-30 15:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3952,8,'2017-05-30 15:36:01','2017-05-30 15:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3953,8,'2017-05-30 15:37:01','2017-05-30 15:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3954,8,'2017-05-30 15:38:01','2017-05-30 15:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3955,8,'2017-05-30 15:39:01','2017-05-30 15:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3956,8,'2017-05-30 15:40:01','2017-05-30 15:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3957,8,'2017-05-30 15:41:01','2017-05-30 15:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3958,8,'2017-05-30 15:42:01','2017-05-30 15:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3959,8,'2017-05-30 15:43:01','2017-05-30 15:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3960,8,'2017-05-30 15:44:01','2017-05-30 15:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3961,8,'2017-05-30 15:45:01','2017-05-30 15:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3962,8,'2017-05-30 15:46:01','2017-05-30 15:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3963,8,'2017-05-30 15:47:01','2017-05-30 15:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3964,8,'2017-05-30 15:48:01','2017-05-30 15:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3965,8,'2017-05-30 15:49:01','2017-05-30 15:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3966,8,'2017-05-30 15:50:01','2017-05-30 15:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3967,8,'2017-05-30 15:51:01','2017-05-30 15:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3968,8,'2017-05-30 15:52:01','2017-05-30 15:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3969,8,'2017-05-30 15:53:01','2017-05-30 15:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3970,8,'2017-05-30 15:54:01','2017-05-30 15:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3971,8,'2017-05-30 15:55:01','2017-05-30 15:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3972,8,'2017-05-30 15:56:01','2017-05-30 15:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3973,8,'2017-05-30 15:57:01','2017-05-30 15:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3974,8,'2017-05-30 15:58:01','2017-05-30 15:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3975,8,'2017-05-30 15:59:01','2017-05-30 15:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3976,8,'2017-05-30 16:00:01','2017-05-30 16:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3977,8,'2017-05-30 16:01:01','2017-05-30 16:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3978,8,'2017-05-30 16:02:01','2017-05-30 16:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3979,8,'2017-05-30 16:03:01','2017-05-30 16:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3980,8,'2017-05-30 16:04:01','2017-05-30 16:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3981,8,'2017-05-30 16:05:01','2017-05-30 16:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3982,8,'2017-05-30 16:06:01','2017-05-30 16:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3983,8,'2017-05-30 16:07:01','2017-05-30 16:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3984,8,'2017-05-30 16:08:01','2017-05-30 16:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3985,8,'2017-05-30 16:09:01','2017-05-30 16:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3986,8,'2017-05-30 16:10:01','2017-05-30 16:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3987,8,'2017-05-30 16:11:02','2017-05-30 16:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3988,8,'2017-05-30 16:12:01','2017-05-30 16:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3989,8,'2017-05-30 16:13:01','2017-05-30 16:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3990,8,'2017-05-30 16:14:01','2017-05-30 16:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3991,8,'2017-05-30 16:15:01','2017-05-30 16:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3992,8,'2017-05-30 16:16:01','2017-05-30 16:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3993,8,'2017-05-30 16:17:01','2017-05-30 16:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3994,8,'2017-05-30 16:18:02','2017-05-30 16:18:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3995,8,'2017-05-30 16:19:01','2017-05-30 16:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3996,8,'2017-05-30 16:20:01','2017-05-30 16:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3997,8,'2017-05-30 16:21:01','2017-05-30 16:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3998,8,'2017-05-30 16:22:01','2017-05-30 16:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(3999,8,'2017-05-30 16:23:01','2017-05-30 16:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4000,8,'2017-05-30 16:24:01','2017-05-30 16:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4001,8,'2017-05-30 16:25:01','2017-05-30 16:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4002,8,'2017-05-30 16:26:01','2017-05-30 16:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4003,8,'2017-05-30 16:27:11','2017-05-30 16:27:11','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4004,8,'2017-05-30 16:28:01','2017-05-30 16:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4005,8,'2017-05-30 16:29:01','2017-05-30 16:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4006,8,'2017-05-30 16:30:01','2017-05-30 16:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4007,8,'2017-05-30 16:31:01','2017-05-30 16:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4008,8,'2017-05-30 16:32:02','2017-05-30 16:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4009,8,'2017-05-30 16:33:01','2017-05-30 16:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4010,8,'2017-05-30 16:34:01','2017-05-30 16:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4011,8,'2017-05-30 16:35:01','2017-05-30 16:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4012,8,'2017-05-30 16:36:01','2017-05-30 16:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4013,8,'2017-05-30 16:37:01','2017-05-30 16:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4014,8,'2017-05-30 16:38:01','2017-05-30 16:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4015,8,'2017-05-30 16:39:01','2017-05-30 16:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4016,8,'2017-05-30 16:40:01','2017-05-30 16:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4017,8,'2017-05-30 16:41:01','2017-05-30 16:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4018,8,'2017-05-30 16:42:01','2017-05-30 16:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4019,8,'2017-05-30 16:43:01','2017-05-30 16:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4020,8,'2017-05-30 16:44:01','2017-05-30 16:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4021,8,'2017-05-30 16:45:01','2017-05-30 16:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4022,8,'2017-05-30 16:46:01','2017-05-30 16:46:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4023,8,'2017-05-30 16:47:01','2017-05-30 16:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4024,8,'2017-05-30 16:48:01','2017-05-30 16:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4025,8,'2017-05-30 16:49:01','2017-05-30 16:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4026,8,'2017-05-30 16:50:01','2017-05-30 16:50:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4027,8,'2017-05-30 16:51:01','2017-05-30 16:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4028,8,'2017-05-30 16:52:01','2017-05-30 16:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4029,8,'2017-05-30 16:53:01','2017-05-30 16:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4030,8,'2017-05-30 16:54:01','2017-05-30 16:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4031,8,'2017-05-30 16:55:01','2017-05-30 16:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4032,8,'2017-05-30 16:56:01','2017-05-30 16:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4033,8,'2017-05-30 16:57:01','2017-05-30 16:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4034,8,'2017-05-30 16:58:01','2017-05-30 16:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4035,8,'2017-05-30 16:59:01','2017-05-30 16:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4036,8,'2017-05-30 17:00:01','2017-05-30 17:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4037,8,'2017-05-30 17:01:02','2017-05-30 17:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4038,8,'2017-05-30 17:02:01','2017-05-30 17:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4039,8,'2017-05-30 17:03:01','2017-05-30 17:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4040,8,'2017-05-30 17:04:01','2017-05-30 17:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4041,8,'2017-05-30 17:05:01','2017-05-30 17:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4042,8,'2017-05-30 17:06:01','2017-05-30 17:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4043,8,'2017-05-30 17:07:01','2017-05-30 17:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4044,8,'2017-05-30 17:08:01','2017-05-30 17:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4045,8,'2017-05-30 17:09:01','2017-05-30 17:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4046,8,'2017-05-30 17:10:01','2017-05-30 17:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4047,8,'2017-05-30 17:11:01','2017-05-30 17:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4048,8,'2017-05-30 17:12:01','2017-05-30 17:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4049,8,'2017-05-30 17:13:01','2017-05-30 17:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4050,8,'2017-05-30 17:14:01','2017-05-30 17:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4051,8,'2017-05-30 17:15:01','2017-05-30 17:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4052,8,'2017-05-30 17:16:01','2017-05-30 17:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4053,8,'2017-05-30 17:17:01','2017-05-30 17:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4054,8,'2017-05-30 17:18:01','2017-05-30 17:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4055,8,'2017-05-30 17:19:01','2017-05-30 17:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4056,8,'2017-05-30 17:20:01','2017-05-30 17:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4057,8,'2017-05-30 17:21:01','2017-05-30 17:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4058,8,'2017-05-30 17:22:01','2017-05-30 17:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4059,8,'2017-05-30 17:23:01','2017-05-30 17:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4060,8,'2017-05-30 17:24:01','2017-05-30 17:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4061,8,'2017-05-30 17:25:01','2017-05-30 17:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4062,8,'2017-05-30 17:26:01','2017-05-30 17:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4063,8,'2017-05-30 17:27:01','2017-05-30 17:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4064,8,'2017-05-30 17:28:01','2017-05-30 17:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4065,8,'2017-05-30 17:29:01','2017-05-30 17:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4066,8,'2017-05-30 17:30:01','2017-05-30 17:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4067,8,'2017-05-30 17:31:01','2017-05-30 17:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4068,8,'2017-05-30 17:32:01','2017-05-30 17:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4069,8,'2017-05-30 17:33:02','2017-05-30 17:33:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4070,8,'2017-05-30 17:34:01','2017-05-30 17:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4071,8,'2017-05-30 17:35:01','2017-05-30 17:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4072,8,'2017-05-30 17:36:01','2017-05-30 17:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4073,8,'2017-05-30 17:37:01','2017-05-30 17:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4074,8,'2017-05-30 17:38:01','2017-05-30 17:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4075,8,'2017-05-30 17:39:01','2017-05-30 17:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4076,8,'2017-05-30 17:40:01','2017-05-30 17:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4077,8,'2017-05-30 17:41:01','2017-05-30 17:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4078,8,'2017-05-30 17:42:01','2017-05-30 17:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4079,8,'2017-05-30 17:43:01','2017-05-30 17:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4080,8,'2017-05-30 17:44:01','2017-05-30 17:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4081,8,'2017-05-30 17:45:01','2017-05-30 17:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4082,8,'2017-05-30 17:46:01','2017-05-30 17:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4083,8,'2017-05-30 17:47:01','2017-05-30 17:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4084,8,'2017-05-30 17:48:01','2017-05-30 17:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4085,8,'2017-05-30 17:49:01','2017-05-30 17:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4086,8,'2017-05-30 17:50:01','2017-05-30 17:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4087,8,'2017-05-30 17:51:01','2017-05-30 17:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4088,8,'2017-05-30 17:52:01','2017-05-30 17:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4089,8,'2017-05-30 17:53:01','2017-05-30 17:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4090,8,'2017-05-30 17:54:01','2017-05-30 17:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4091,8,'2017-05-30 17:55:01','2017-05-30 17:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4092,8,'2017-05-30 17:56:01','2017-05-30 17:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4093,8,'2017-05-30 17:57:01','2017-05-30 17:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4094,8,'2017-05-30 17:58:01','2017-05-30 17:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4095,8,'2017-05-30 17:59:01','2017-05-30 17:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4096,8,'2017-05-30 18:00:01','2017-05-30 18:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4097,8,'2017-05-30 18:01:01','2017-05-30 18:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4098,8,'2017-05-30 18:02:01','2017-05-30 18:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4099,8,'2017-05-30 18:03:01','2017-05-30 18:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4100,8,'2017-05-30 18:04:01','2017-05-30 18:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4101,8,'2017-05-30 18:05:01','2017-05-30 18:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4102,8,'2017-05-30 18:06:01','2017-05-30 18:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4103,8,'2017-05-30 18:07:01','2017-05-30 18:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4104,8,'2017-05-30 18:08:01','2017-05-30 18:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4105,8,'2017-05-30 18:09:01','2017-05-30 18:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4106,8,'2017-05-30 18:10:01','2017-05-30 18:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4107,8,'2017-05-30 18:11:01','2017-05-30 18:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4108,8,'2017-05-30 18:12:01','2017-05-30 18:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4109,8,'2017-05-30 18:13:01','2017-05-30 18:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4110,8,'2017-05-30 18:14:01','2017-05-30 18:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4111,8,'2017-05-30 18:15:01','2017-05-30 18:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4112,8,'2017-05-30 18:16:01','2017-05-30 18:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4113,8,'2017-05-30 18:17:01','2017-05-30 18:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4114,8,'2017-05-30 18:18:01','2017-05-30 18:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4115,8,'2017-05-30 18:19:01','2017-05-30 18:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4116,8,'2017-05-30 18:20:01','2017-05-30 18:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4117,8,'2017-05-30 18:21:01','2017-05-30 18:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4118,8,'2017-05-30 18:22:01','2017-05-30 18:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4119,8,'2017-05-30 18:23:01','2017-05-30 18:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4120,8,'2017-05-30 18:24:01','2017-05-30 18:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4121,8,'2017-05-30 18:25:01','2017-05-30 18:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4122,8,'2017-05-30 18:26:01','2017-05-30 18:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4123,8,'2017-05-30 18:27:01','2017-05-30 18:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4124,8,'2017-05-30 18:28:01','2017-05-30 18:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4125,8,'2017-05-30 18:29:01','2017-05-30 18:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4126,8,'2017-05-30 18:30:01','2017-05-30 18:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4127,8,'2017-05-30 18:31:01','2017-05-30 18:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4128,8,'2017-05-30 18:32:01','2017-05-30 18:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4129,8,'2017-05-30 18:33:01','2017-05-30 18:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4130,8,'2017-05-30 18:34:01','2017-05-30 18:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4131,8,'2017-05-30 18:35:01','2017-05-30 18:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4132,8,'2017-05-30 18:36:01','2017-05-30 18:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4133,8,'2017-05-30 18:37:02','2017-05-30 18:37:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4134,8,'2017-05-30 18:38:01','2017-05-30 18:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4135,8,'2017-05-30 18:39:01','2017-05-30 18:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4136,8,'2017-05-30 18:40:01','2017-05-30 18:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4137,8,'2017-05-30 18:41:01','2017-05-30 18:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4138,8,'2017-05-30 18:42:01','2017-05-30 18:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4139,8,'2017-05-30 18:43:01','2017-05-30 18:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4140,8,'2017-05-30 18:44:01','2017-05-30 18:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4141,8,'2017-05-30 18:45:01','2017-05-30 18:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4142,8,'2017-05-30 18:46:01','2017-05-30 18:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4143,8,'2017-05-30 18:47:02','2017-05-30 18:47:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4144,8,'2017-05-30 18:48:01','2017-05-30 18:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4145,8,'2017-05-30 18:49:01','2017-05-30 18:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4146,8,'2017-05-30 18:50:01','2017-05-30 18:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4147,8,'2017-05-30 18:51:01','2017-05-30 18:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4148,8,'2017-05-30 18:52:01','2017-05-30 18:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4149,8,'2017-05-30 18:53:02','2017-05-30 18:53:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4150,8,'2017-05-30 18:54:01','2017-05-30 18:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4151,8,'2017-05-30 18:55:01','2017-05-30 18:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4152,8,'2017-05-30 18:56:01','2017-05-30 18:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4153,8,'2017-05-30 18:57:01','2017-05-30 18:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4154,8,'2017-05-30 18:58:01','2017-05-30 18:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4155,8,'2017-05-30 18:59:01','2017-05-30 18:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4156,8,'2017-05-30 19:00:01','2017-05-30 19:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4157,8,'2017-05-30 19:01:01','2017-05-30 19:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4158,8,'2017-05-30 19:02:01','2017-05-30 19:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4159,8,'2017-05-30 19:03:02','2017-05-30 19:03:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4160,8,'2017-05-30 19:04:01','2017-05-30 19:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4161,8,'2017-05-30 19:05:01','2017-05-30 19:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4162,8,'2017-05-30 19:06:01','2017-05-30 19:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4163,8,'2017-05-30 19:07:01','2017-05-30 19:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4164,8,'2017-05-30 19:08:01','2017-05-30 19:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4165,8,'2017-05-30 19:09:01','2017-05-30 19:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4166,8,'2017-05-30 19:10:01','2017-05-30 19:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4167,8,'2017-05-30 19:11:01','2017-05-30 19:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4168,8,'2017-05-30 19:12:02','2017-05-30 19:12:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4169,8,'2017-05-30 19:13:01','2017-05-30 19:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4170,8,'2017-05-30 19:14:01','2017-05-30 19:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4171,8,'2017-05-30 19:15:01','2017-05-30 19:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4172,8,'2017-05-30 19:16:02','2017-05-30 19:16:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4173,8,'2017-05-30 19:17:01','2017-05-30 19:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4174,8,'2017-05-30 19:18:02','2017-05-30 19:18:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4175,8,'2017-05-30 19:19:01','2017-05-30 19:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4176,8,'2017-05-30 19:20:01','2017-05-30 19:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4177,8,'2017-05-30 19:21:01','2017-05-30 19:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4178,8,'2017-05-30 19:22:01','2017-05-30 19:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4179,8,'2017-05-30 19:23:01','2017-05-30 19:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4180,8,'2017-05-30 19:24:01','2017-05-30 19:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4181,8,'2017-05-30 19:25:01','2017-05-30 19:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4182,8,'2017-05-30 19:26:01','2017-05-30 19:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4183,8,'2017-05-30 19:27:01','2017-05-30 19:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4184,8,'2017-05-30 19:28:01','2017-05-30 19:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4185,8,'2017-05-30 19:29:01','2017-05-30 19:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4186,8,'2017-05-30 19:30:01','2017-05-30 19:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4187,8,'2017-05-30 19:31:01','2017-05-30 19:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4188,8,'2017-05-30 19:32:01','2017-05-30 19:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4189,8,'2017-05-30 19:33:01','2017-05-30 19:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4190,8,'2017-05-30 19:34:01','2017-05-30 19:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4191,8,'2017-05-30 19:35:01','2017-05-30 19:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4192,8,'2017-05-30 19:36:01','2017-05-30 19:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4193,8,'2017-05-30 19:37:01','2017-05-30 19:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4194,8,'2017-05-30 19:38:01','2017-05-30 19:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4195,8,'2017-05-30 19:39:01','2017-05-30 19:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4196,8,'2017-05-30 19:40:01','2017-05-30 19:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4197,8,'2017-05-30 19:41:01','2017-05-30 19:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4198,8,'2017-05-30 19:42:01','2017-05-30 19:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4199,8,'2017-05-30 19:43:01','2017-05-30 19:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4200,8,'2017-05-30 19:44:01','2017-05-30 19:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4201,8,'2017-05-30 19:45:01','2017-05-30 19:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4202,8,'2017-05-30 19:46:01','2017-05-30 19:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4203,8,'2017-05-30 19:47:01','2017-05-30 19:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4204,8,'2017-05-30 19:48:01','2017-05-30 19:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4205,8,'2017-05-30 19:49:01','2017-05-30 19:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4206,8,'2017-05-30 19:50:01','2017-05-30 19:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4207,8,'2017-05-30 19:51:01','2017-05-30 19:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4208,8,'2017-05-30 19:52:01','2017-05-30 19:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4209,8,'2017-05-30 19:53:01','2017-05-30 19:53:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4210,8,'2017-05-30 19:54:01','2017-05-30 19:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4211,8,'2017-05-30 19:55:01','2017-05-30 19:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4212,8,'2017-05-30 19:56:01','2017-05-30 19:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4213,8,'2017-05-30 19:57:01','2017-05-30 19:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4214,8,'2017-05-30 19:58:02','2017-05-30 19:58:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4215,8,'2017-05-30 19:59:01','2017-05-30 19:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4216,8,'2017-05-30 20:00:01','2017-05-30 20:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4217,8,'2017-05-30 20:01:01','2017-05-30 20:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4218,8,'2017-05-30 20:02:02','2017-05-30 20:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4219,8,'2017-05-30 20:03:01','2017-05-30 20:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4220,8,'2017-05-30 20:04:01','2017-05-30 20:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4221,8,'2017-05-30 20:05:01','2017-05-30 20:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4222,8,'2017-05-30 20:06:01','2017-05-30 20:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4223,8,'2017-05-30 20:07:01','2017-05-30 20:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4224,8,'2017-05-30 20:08:01','2017-05-30 20:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4225,8,'2017-05-30 20:09:01','2017-05-30 20:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4226,8,'2017-05-30 20:10:01','2017-05-30 20:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4227,8,'2017-05-30 20:11:01','2017-05-30 20:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4228,8,'2017-05-30 20:12:01','2017-05-30 20:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4229,8,'2017-05-30 20:13:01','2017-05-30 20:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4230,8,'2017-05-30 20:14:01','2017-05-30 20:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4231,8,'2017-05-30 20:15:01','2017-05-30 20:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4232,8,'2017-05-30 20:16:01','2017-05-30 20:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4233,8,'2017-05-30 20:17:01','2017-05-30 20:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4234,8,'2017-05-30 20:18:01','2017-05-30 20:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4235,8,'2017-05-30 20:19:01','2017-05-30 20:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4236,8,'2017-05-30 20:20:01','2017-05-30 20:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4237,8,'2017-05-30 20:21:01','2017-05-30 20:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4238,8,'2017-05-30 20:22:01','2017-05-30 20:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4239,8,'2017-05-30 20:23:01','2017-05-30 20:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4240,8,'2017-05-30 20:24:01','2017-05-30 20:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4241,8,'2017-05-30 20:25:01','2017-05-30 20:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4242,8,'2017-05-30 20:26:01','2017-05-30 20:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4243,8,'2017-05-30 20:27:01','2017-05-30 20:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4244,8,'2017-05-30 20:28:01','2017-05-30 20:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4245,8,'2017-05-30 20:29:01','2017-05-30 20:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4246,8,'2017-05-30 20:30:01','2017-05-30 20:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4247,8,'2017-05-30 20:31:01','2017-05-30 20:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4248,8,'2017-05-30 20:32:02','2017-05-30 20:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4249,8,'2017-05-30 20:33:01','2017-05-30 20:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4250,8,'2017-05-30 20:34:01','2017-05-30 20:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4251,8,'2017-05-30 20:35:01','2017-05-30 20:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4252,8,'2017-05-30 20:36:01','2017-05-30 20:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4253,8,'2017-05-30 20:37:02','2017-05-30 20:37:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4254,8,'2017-05-30 20:38:01','2017-05-30 20:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4255,8,'2017-05-30 20:39:01','2017-05-30 20:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4256,8,'2017-05-30 20:40:01','2017-05-30 20:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4257,8,'2017-05-30 20:41:01','2017-05-30 20:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4258,8,'2017-05-30 20:42:01','2017-05-30 20:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4259,8,'2017-05-30 20:43:01','2017-05-30 20:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4260,8,'2017-05-30 20:44:01','2017-05-30 20:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4261,8,'2017-05-30 20:45:01','2017-05-30 20:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4262,8,'2017-05-30 20:46:01','2017-05-30 20:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4263,8,'2017-05-30 20:47:01','2017-05-30 20:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4264,8,'2017-05-30 20:48:01','2017-05-30 20:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4265,8,'2017-05-30 20:49:01','2017-05-30 20:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4266,8,'2017-05-30 20:50:01','2017-05-30 20:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4267,8,'2017-05-30 20:51:01','2017-05-30 20:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4268,8,'2017-05-30 20:52:01','2017-05-30 20:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4269,8,'2017-05-30 20:53:01','2017-05-30 20:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4270,8,'2017-05-30 20:54:01','2017-05-30 20:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4271,8,'2017-05-30 20:55:01','2017-05-30 20:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4272,8,'2017-05-30 20:56:01','2017-05-30 20:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4273,8,'2017-05-30 20:57:01','2017-05-30 20:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4274,8,'2017-05-30 20:58:01','2017-05-30 20:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4275,8,'2017-05-30 20:59:01','2017-05-30 20:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4276,8,'2017-05-30 21:00:01','2017-05-30 21:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4277,8,'2017-05-30 21:01:01','2017-05-30 21:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4278,8,'2017-05-30 21:02:01','2017-05-30 21:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4279,8,'2017-05-30 21:03:01','2017-05-30 21:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4280,8,'2017-05-30 21:04:01','2017-05-30 21:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4281,8,'2017-05-30 21:05:01','2017-05-30 21:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4282,8,'2017-05-30 21:06:01','2017-05-30 21:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4283,8,'2017-05-30 21:07:01','2017-05-30 21:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4284,8,'2017-05-30 21:08:01','2017-05-30 21:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4285,8,'2017-05-30 21:09:01','2017-05-30 21:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4286,8,'2017-05-30 21:10:01','2017-05-30 21:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4287,8,'2017-05-30 21:11:01','2017-05-30 21:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4288,8,'2017-05-30 21:12:01','2017-05-30 21:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4289,8,'2017-05-30 21:13:01','2017-05-30 21:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4290,8,'2017-05-30 21:14:01','2017-05-30 21:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4291,8,'2017-05-30 21:15:01','2017-05-30 21:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4292,8,'2017-05-30 21:16:01','2017-05-30 21:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4293,8,'2017-05-30 21:17:01','2017-05-30 21:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4294,8,'2017-05-30 21:18:01','2017-05-30 21:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4295,8,'2017-05-30 21:19:01','2017-05-30 21:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4296,8,'2017-05-30 21:20:01','2017-05-30 21:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4297,8,'2017-05-30 21:21:01','2017-05-30 21:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4298,8,'2017-05-30 21:22:01','2017-05-30 21:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4299,8,'2017-05-30 21:23:01','2017-05-30 21:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4300,8,'2017-05-30 21:24:01','2017-05-30 21:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4301,8,'2017-05-30 21:25:01','2017-05-30 21:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4302,8,'2017-05-30 21:26:01','2017-05-30 21:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4303,8,'2017-05-30 21:27:01','2017-05-30 21:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4304,8,'2017-05-30 21:28:01','2017-05-30 21:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4305,8,'2017-05-30 21:29:01','2017-05-30 21:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4306,8,'2017-05-30 21:30:01','2017-05-30 21:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4307,8,'2017-05-30 21:31:01','2017-05-30 21:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4308,8,'2017-05-30 21:32:01','2017-05-30 21:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4309,8,'2017-05-30 21:33:01','2017-05-30 21:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4310,8,'2017-05-30 21:34:01','2017-05-30 21:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4311,8,'2017-05-30 21:35:01','2017-05-30 21:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4312,8,'2017-05-30 21:36:01','2017-05-30 21:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4313,8,'2017-05-30 21:37:01','2017-05-30 21:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4314,8,'2017-05-30 21:38:01','2017-05-30 21:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4315,8,'2017-05-30 21:39:01','2017-05-30 21:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4316,8,'2017-05-30 21:40:02','2017-05-30 21:40:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4317,8,'2017-05-30 21:41:01','2017-05-30 21:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4318,8,'2017-05-30 21:42:01','2017-05-30 21:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4319,8,'2017-05-30 21:43:01','2017-05-30 21:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4320,8,'2017-05-30 21:44:01','2017-05-30 21:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4321,8,'2017-05-30 21:45:01','2017-05-30 21:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4322,8,'2017-05-30 21:46:01','2017-05-30 21:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4323,8,'2017-05-30 21:47:01','2017-05-30 21:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4324,8,'2017-05-30 21:48:01','2017-05-30 21:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4325,8,'2017-05-30 21:49:01','2017-05-30 21:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4326,8,'2017-05-30 21:50:01','2017-05-30 21:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4327,8,'2017-05-30 21:51:01','2017-05-30 21:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4328,8,'2017-05-30 21:52:01','2017-05-30 21:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4329,8,'2017-05-30 21:53:01','2017-05-30 21:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4330,8,'2017-05-30 21:54:01','2017-05-30 21:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4331,8,'2017-05-30 21:55:01','2017-05-30 21:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4332,8,'2017-05-30 21:56:01','2017-05-30 21:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4333,8,'2017-05-30 21:57:01','2017-05-30 21:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4334,8,'2017-05-30 21:58:01','2017-05-30 21:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4335,8,'2017-05-30 21:59:01','2017-05-30 21:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4336,8,'2017-05-30 22:00:01','2017-05-30 22:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4337,8,'2017-05-30 22:01:01','2017-05-30 22:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4338,8,'2017-05-30 22:02:01','2017-05-30 22:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4339,8,'2017-05-30 22:03:01','2017-05-30 22:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4340,8,'2017-05-30 22:04:01','2017-05-30 22:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4341,8,'2017-05-30 22:05:01','2017-05-30 22:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4342,8,'2017-05-30 22:06:01','2017-05-30 22:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4343,8,'2017-05-30 22:07:01','2017-05-30 22:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4344,8,'2017-05-30 22:08:01','2017-05-30 22:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4345,8,'2017-05-30 22:09:01','2017-05-30 22:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4346,8,'2017-05-30 22:10:01','2017-05-30 22:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4347,8,'2017-05-30 22:11:01','2017-05-30 22:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4348,8,'2017-05-30 22:12:02','2017-05-30 22:12:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4349,8,'2017-05-30 22:13:02','2017-05-30 22:13:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4350,8,'2017-05-30 22:14:01','2017-05-30 22:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4351,8,'2017-05-30 22:15:01','2017-05-30 22:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4352,8,'2017-05-30 22:16:01','2017-05-30 22:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4353,8,'2017-05-30 22:17:01','2017-05-30 22:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4354,8,'2017-05-30 22:18:01','2017-05-30 22:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4355,8,'2017-05-30 22:19:01','2017-05-30 22:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4356,8,'2017-05-30 22:20:01','2017-05-30 22:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4357,8,'2017-05-30 22:21:01','2017-05-30 22:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4358,8,'2017-05-30 22:22:01','2017-05-30 22:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4359,8,'2017-05-30 22:23:01','2017-05-30 22:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4360,8,'2017-05-30 22:24:01','2017-05-30 22:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4361,8,'2017-05-30 22:25:01','2017-05-30 22:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4362,8,'2017-05-30 22:26:01','2017-05-30 22:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4363,8,'2017-05-30 22:27:02','2017-05-30 22:27:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4364,8,'2017-05-30 22:28:01','2017-05-30 22:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4365,8,'2017-05-30 22:29:01','2017-05-30 22:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4366,8,'2017-05-30 22:30:01','2017-05-30 22:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4367,8,'2017-05-30 22:31:01','2017-05-30 22:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4368,8,'2017-05-30 22:32:01','2017-05-30 22:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4369,8,'2017-05-30 22:33:01','2017-05-30 22:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4370,8,'2017-05-30 22:34:02','2017-05-30 22:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4371,8,'2017-05-30 22:35:01','2017-05-30 22:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4372,8,'2017-05-30 22:36:01','2017-05-30 22:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4373,8,'2017-05-30 22:37:01','2017-05-30 22:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4374,8,'2017-05-30 22:38:02','2017-05-30 22:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4375,8,'2017-05-30 22:39:01','2017-05-30 22:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4376,8,'2017-05-30 22:40:01','2017-05-30 22:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4377,8,'2017-05-30 22:41:01','2017-05-30 22:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4378,8,'2017-05-30 22:42:01','2017-05-30 22:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4379,8,'2017-05-30 22:43:01','2017-05-30 22:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4380,8,'2017-05-30 22:44:01','2017-05-30 22:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4381,8,'2017-05-30 22:45:01','2017-05-30 22:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4382,8,'2017-05-30 22:46:01','2017-05-30 22:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4383,8,'2017-05-30 22:47:01','2017-05-30 22:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4384,8,'2017-05-30 22:48:01','2017-05-30 22:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4385,8,'2017-05-30 22:49:01','2017-05-30 22:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4386,8,'2017-05-30 22:50:01','2017-05-30 22:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4387,8,'2017-05-30 22:51:01','2017-05-30 22:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4388,8,'2017-05-30 22:52:01','2017-05-30 22:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4389,8,'2017-05-30 22:53:01','2017-05-30 22:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4390,8,'2017-05-30 22:54:01','2017-05-30 22:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4391,8,'2017-05-30 22:55:01','2017-05-30 22:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4392,8,'2017-05-30 22:56:01','2017-05-30 22:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4393,8,'2017-05-30 22:57:02','2017-05-30 22:57:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4394,8,'2017-05-30 22:58:01','2017-05-30 22:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4395,8,'2017-05-30 22:59:01','2017-05-30 22:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4396,8,'2017-05-30 23:00:01','2017-05-30 23:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4397,8,'2017-05-30 23:01:01','2017-05-30 23:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4398,8,'2017-05-30 23:02:01','2017-05-30 23:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4399,8,'2017-05-30 23:03:01','2017-05-30 23:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4400,8,'2017-05-30 23:04:01','2017-05-30 23:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4401,8,'2017-05-30 23:05:01','2017-05-30 23:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4402,8,'2017-05-30 23:06:01','2017-05-30 23:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4403,8,'2017-05-30 23:07:01','2017-05-30 23:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4404,8,'2017-05-30 23:08:01','2017-05-30 23:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4405,8,'2017-05-30 23:09:01','2017-05-30 23:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4406,8,'2017-05-30 23:10:01','2017-05-30 23:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4407,8,'2017-05-30 23:11:01','2017-05-30 23:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4408,8,'2017-05-30 23:12:01','2017-05-30 23:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4409,8,'2017-05-30 23:13:01','2017-05-30 23:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4410,8,'2017-05-30 23:14:01','2017-05-30 23:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4411,8,'2017-05-30 23:15:01','2017-05-30 23:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4412,8,'2017-05-30 23:16:01','2017-05-30 23:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4413,8,'2017-05-30 23:17:01','2017-05-30 23:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4414,8,'2017-05-30 23:18:01','2017-05-30 23:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4415,8,'2017-05-30 23:19:01','2017-05-30 23:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4416,8,'2017-05-30 23:20:01','2017-05-30 23:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4417,8,'2017-05-30 23:21:01','2017-05-30 23:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4418,8,'2017-05-30 23:22:01','2017-05-30 23:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4419,8,'2017-05-30 23:23:01','2017-05-30 23:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4420,8,'2017-05-30 23:24:01','2017-05-30 23:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4421,8,'2017-05-30 23:25:01','2017-05-30 23:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4422,8,'2017-05-30 23:26:01','2017-05-30 23:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4423,8,'2017-05-30 23:27:01','2017-05-30 23:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4424,8,'2017-05-30 23:28:01','2017-05-30 23:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4425,8,'2017-05-30 23:29:01','2017-05-30 23:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4426,8,'2017-05-30 23:30:01','2017-05-30 23:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4427,8,'2017-05-30 23:31:01','2017-05-30 23:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4428,8,'2017-05-30 23:32:01','2017-05-30 23:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4429,8,'2017-05-30 23:33:01','2017-05-30 23:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4430,8,'2017-05-30 23:34:01','2017-05-30 23:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4431,8,'2017-05-30 23:35:01','2017-05-30 23:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4432,8,'2017-05-30 23:36:01','2017-05-30 23:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4433,8,'2017-05-30 23:37:01','2017-05-30 23:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4434,8,'2017-05-30 23:38:01','2017-05-30 23:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4435,8,'2017-05-30 23:39:01','2017-05-30 23:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4436,8,'2017-05-30 23:40:01','2017-05-30 23:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4437,8,'2017-05-30 23:41:01','2017-05-30 23:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4438,8,'2017-05-30 23:42:01','2017-05-30 23:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4439,8,'2017-05-30 23:43:01','2017-05-30 23:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4440,8,'2017-05-30 23:44:01','2017-05-30 23:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4441,8,'2017-05-30 23:45:01','2017-05-30 23:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4442,8,'2017-05-30 23:46:01','2017-05-30 23:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4443,8,'2017-05-30 23:47:01','2017-05-30 23:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4444,8,'2017-05-30 23:48:01','2017-05-30 23:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4445,8,'2017-05-30 23:49:01','2017-05-30 23:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4446,8,'2017-05-30 23:50:01','2017-05-30 23:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4447,8,'2017-05-30 23:51:01','2017-05-30 23:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4448,8,'2017-05-30 23:52:01','2017-05-30 23:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4449,8,'2017-05-30 23:53:01','2017-05-30 23:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4450,8,'2017-05-30 23:54:01','2017-05-30 23:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4451,8,'2017-05-30 23:55:01','2017-05-30 23:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4452,8,'2017-05-30 23:56:01','2017-05-30 23:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4453,8,'2017-05-30 23:57:01','2017-05-30 23:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4454,8,'2017-05-30 23:58:01','2017-05-30 23:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4455,8,'2017-05-30 23:59:01','2017-05-30 23:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4456,8,'2017-05-31 00:00:01','2017-05-31 00:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4457,8,'2017-05-31 00:01:01','2017-05-31 00:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4458,8,'2017-05-31 00:02:01','2017-05-31 00:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4459,8,'2017-05-31 00:03:01','2017-05-31 00:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4460,8,'2017-05-31 00:04:02','2017-05-31 00:04:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4461,8,'2017-05-31 00:05:01','2017-05-31 00:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4462,8,'2017-05-31 00:06:01','2017-05-31 00:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4463,8,'2017-05-31 00:07:01','2017-05-31 00:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4464,8,'2017-05-31 00:08:01','2017-05-31 00:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4465,8,'2017-05-31 00:09:01','2017-05-31 00:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4466,8,'2017-05-31 00:10:01','2017-05-31 00:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4467,8,'2017-05-31 00:11:01','2017-05-31 00:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4468,8,'2017-05-31 00:12:01','2017-05-31 00:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4469,8,'2017-05-31 00:13:01','2017-05-31 00:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4470,8,'2017-05-31 00:14:01','2017-05-31 00:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4471,8,'2017-05-31 00:15:01','2017-05-31 00:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4472,8,'2017-05-31 00:16:01','2017-05-31 00:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4473,8,'2017-05-31 00:17:01','2017-05-31 00:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4474,8,'2017-05-31 00:18:01','2017-05-31 00:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4475,8,'2017-05-31 00:19:01','2017-05-31 00:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4476,8,'2017-05-31 00:20:01','2017-05-31 00:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4477,8,'2017-05-31 00:21:01','2017-05-31 00:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4478,8,'2017-05-31 00:22:01','2017-05-31 00:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4479,8,'2017-05-31 00:23:01','2017-05-31 00:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4480,8,'2017-05-31 00:24:01','2017-05-31 00:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4481,8,'2017-05-31 00:25:01','2017-05-31 00:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4482,8,'2017-05-31 00:26:01','2017-05-31 00:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4483,8,'2017-05-31 00:27:01','2017-05-31 00:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4484,8,'2017-05-31 00:28:01','2017-05-31 00:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4485,8,'2017-05-31 00:29:02','2017-05-31 00:29:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4486,8,'2017-05-31 00:30:01','2017-05-31 00:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4487,8,'2017-05-31 00:31:01','2017-05-31 00:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4488,8,'2017-05-31 00:32:01','2017-05-31 00:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4489,8,'2017-05-31 00:33:01','2017-05-31 00:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4490,8,'2017-05-31 00:34:01','2017-05-31 00:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4491,8,'2017-05-31 00:35:01','2017-05-31 00:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4492,8,'2017-05-31 00:36:01','2017-05-31 00:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4493,8,'2017-05-31 00:37:01','2017-05-31 00:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4494,8,'2017-05-31 00:38:01','2017-05-31 00:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4495,8,'2017-05-31 00:39:01','2017-05-31 00:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4496,8,'2017-05-31 00:40:01','2017-05-31 00:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4497,8,'2017-05-31 00:41:01','2017-05-31 00:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4498,8,'2017-05-31 00:42:01','2017-05-31 00:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4499,8,'2017-05-31 00:43:01','2017-05-31 00:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4500,8,'2017-05-31 00:44:01','2017-05-31 00:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4501,8,'2017-05-31 00:45:02','2017-05-31 00:45:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4502,8,'2017-05-31 00:46:01','2017-05-31 00:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4503,8,'2017-05-31 00:47:01','2017-05-31 00:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4504,8,'2017-05-31 00:48:01','2017-05-31 00:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4505,8,'2017-05-31 00:49:01','2017-05-31 00:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4506,8,'2017-05-31 00:50:01','2017-05-31 00:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4507,8,'2017-05-31 00:51:01','2017-05-31 00:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4508,8,'2017-05-31 00:52:01','2017-05-31 00:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4509,8,'2017-05-31 00:53:01','2017-05-31 00:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4510,8,'2017-05-31 00:54:01','2017-05-31 00:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4511,8,'2017-05-31 00:55:01','2017-05-31 00:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4512,8,'2017-05-31 00:56:01','2017-05-31 00:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4513,8,'2017-05-31 00:57:01','2017-05-31 00:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4514,8,'2017-05-31 00:58:01','2017-05-31 00:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4515,8,'2017-05-31 00:59:01','2017-05-31 00:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4516,8,'2017-05-31 01:00:02','2017-05-31 01:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4517,8,'2017-05-31 01:01:01','2017-05-31 01:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4518,8,'2017-05-31 01:02:01','2017-05-31 01:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4519,8,'2017-05-31 01:03:01','2017-05-31 01:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4520,8,'2017-05-31 01:04:01','2017-05-31 01:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4521,8,'2017-05-31 01:05:01','2017-05-31 01:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4522,8,'2017-05-31 01:06:02','2017-05-31 01:06:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4523,8,'2017-05-31 01:07:01','2017-05-31 01:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4524,8,'2017-05-31 01:08:01','2017-05-31 01:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4525,8,'2017-05-31 01:09:01','2017-05-31 01:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4526,8,'2017-05-31 01:10:01','2017-05-31 01:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4527,8,'2017-05-31 01:11:01','2017-05-31 01:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4528,8,'2017-05-31 01:12:01','2017-05-31 01:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4529,8,'2017-05-31 01:13:02','2017-05-31 01:13:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4530,8,'2017-05-31 01:14:01','2017-05-31 01:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4531,8,'2017-05-31 01:15:01','2017-05-31 01:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4532,8,'2017-05-31 01:16:01','2017-05-31 01:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4533,8,'2017-05-31 01:17:01','2017-05-31 01:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4534,8,'2017-05-31 01:18:01','2017-05-31 01:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4535,8,'2017-05-31 01:19:01','2017-05-31 01:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4536,8,'2017-05-31 01:20:02','2017-05-31 01:20:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4537,8,'2017-05-31 01:21:01','2017-05-31 01:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4538,8,'2017-05-31 01:22:01','2017-05-31 01:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4539,8,'2017-05-31 01:23:01','2017-05-31 01:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4540,8,'2017-05-31 01:24:01','2017-05-31 01:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4541,8,'2017-05-31 01:25:01','2017-05-31 01:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4542,8,'2017-05-31 01:26:01','2017-05-31 01:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4543,8,'2017-05-31 01:27:01','2017-05-31 01:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4544,8,'2017-05-31 01:28:01','2017-05-31 01:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4545,8,'2017-05-31 01:29:01','2017-05-31 01:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4546,8,'2017-05-31 01:30:02','2017-05-31 01:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4547,8,'2017-05-31 01:31:01','2017-05-31 01:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4548,8,'2017-05-31 01:32:01','2017-05-31 01:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4549,8,'2017-05-31 01:33:01','2017-05-31 01:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4550,8,'2017-05-31 01:34:01','2017-05-31 01:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4551,8,'2017-05-31 01:35:01','2017-05-31 01:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4552,8,'2017-05-31 01:36:01','2017-05-31 01:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4553,8,'2017-05-31 01:37:01','2017-05-31 01:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4554,8,'2017-05-31 01:38:01','2017-05-31 01:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4555,8,'2017-05-31 01:39:01','2017-05-31 01:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4556,8,'2017-05-31 01:40:01','2017-05-31 01:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4557,8,'2017-05-31 01:41:01','2017-05-31 01:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4558,8,'2017-05-31 01:42:01','2017-05-31 01:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4559,8,'2017-05-31 01:43:01','2017-05-31 01:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4560,8,'2017-05-31 01:44:01','2017-05-31 01:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4561,8,'2017-05-31 01:45:01','2017-05-31 01:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4562,8,'2017-05-31 01:46:01','2017-05-31 01:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4563,8,'2017-05-31 01:47:01','2017-05-31 01:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4564,8,'2017-05-31 01:48:01','2017-05-31 01:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4565,8,'2017-05-31 01:49:01','2017-05-31 01:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4566,8,'2017-05-31 01:50:01','2017-05-31 01:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4567,8,'2017-05-31 01:51:02','2017-05-31 01:51:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4568,8,'2017-05-31 01:52:01','2017-05-31 01:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4569,8,'2017-05-31 01:53:01','2017-05-31 01:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4570,8,'2017-05-31 01:54:01','2017-05-31 01:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4571,8,'2017-05-31 01:55:02','2017-05-31 01:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4572,8,'2017-05-31 01:56:01','2017-05-31 01:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4573,8,'2017-05-31 01:57:01','2017-05-31 01:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4574,8,'2017-05-31 01:58:01','2017-05-31 01:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4575,8,'2017-05-31 01:59:01','2017-05-31 01:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4576,8,'2017-05-31 02:00:01','2017-05-31 02:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4577,8,'2017-05-31 02:01:01','2017-05-31 02:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4578,8,'2017-05-31 02:02:01','2017-05-31 02:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4579,8,'2017-05-31 02:03:01','2017-05-31 02:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4580,8,'2017-05-31 02:04:01','2017-05-31 02:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4581,8,'2017-05-31 02:05:01','2017-05-31 02:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4582,8,'2017-05-31 02:06:01','2017-05-31 02:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4583,8,'2017-05-31 02:07:01','2017-05-31 02:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4584,8,'2017-05-31 02:08:01','2017-05-31 02:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4585,8,'2017-05-31 02:09:01','2017-05-31 02:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4586,8,'2017-05-31 02:10:02','2017-05-31 02:10:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4587,8,'2017-05-31 02:11:01','2017-05-31 02:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4588,8,'2017-05-31 02:12:01','2017-05-31 02:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4589,8,'2017-05-31 02:13:01','2017-05-31 02:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4590,8,'2017-05-31 02:14:01','2017-05-31 02:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4591,8,'2017-05-31 02:15:01','2017-05-31 02:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4592,8,'2017-05-31 02:16:01','2017-05-31 02:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4593,8,'2017-05-31 02:17:01','2017-05-31 02:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4594,8,'2017-05-31 02:18:01','2017-05-31 02:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4595,8,'2017-05-31 02:19:01','2017-05-31 02:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4596,8,'2017-05-31 02:20:01','2017-05-31 02:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4597,8,'2017-05-31 02:21:01','2017-05-31 02:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4598,8,'2017-05-31 02:22:01','2017-05-31 02:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4599,8,'2017-05-31 02:23:01','2017-05-31 02:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4600,8,'2017-05-31 02:24:02','2017-05-31 02:24:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4601,8,'2017-05-31 02:25:01','2017-05-31 02:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4602,8,'2017-05-31 02:26:01','2017-05-31 02:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4603,8,'2017-05-31 02:27:01','2017-05-31 02:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4604,8,'2017-05-31 02:28:01','2017-05-31 02:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4605,8,'2017-05-31 02:29:01','2017-05-31 02:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4606,8,'2017-05-31 02:30:01','2017-05-31 02:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4607,8,'2017-05-31 02:31:01','2017-05-31 02:31:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4608,8,'2017-05-31 02:32:01','2017-05-31 02:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4609,8,'2017-05-31 02:33:01','2017-05-31 02:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4610,8,'2017-05-31 02:34:01','2017-05-31 02:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4611,8,'2017-05-31 02:35:01','2017-05-31 02:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4612,8,'2017-05-31 02:36:01','2017-05-31 02:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4613,8,'2017-05-31 02:37:01','2017-05-31 02:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4614,8,'2017-05-31 02:38:01','2017-05-31 02:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4615,8,'2017-05-31 02:39:02','2017-05-31 02:39:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4616,8,'2017-05-31 02:40:01','2017-05-31 02:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4617,8,'2017-05-31 02:41:01','2017-05-31 02:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4618,8,'2017-05-31 02:42:01','2017-05-31 02:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4619,8,'2017-05-31 02:43:01','2017-05-31 02:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4620,8,'2017-05-31 02:44:01','2017-05-31 02:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4621,8,'2017-05-31 02:45:01','2017-05-31 02:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4622,8,'2017-05-31 02:46:01','2017-05-31 02:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4623,8,'2017-05-31 02:47:01','2017-05-31 02:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4624,8,'2017-05-31 02:48:01','2017-05-31 02:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4625,8,'2017-05-31 02:49:01','2017-05-31 02:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4626,8,'2017-05-31 02:50:02','2017-05-31 02:50:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4627,8,'2017-05-31 02:51:01','2017-05-31 02:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4628,8,'2017-05-31 02:52:01','2017-05-31 02:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4629,8,'2017-05-31 02:53:01','2017-05-31 02:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4630,8,'2017-05-31 02:54:02','2017-05-31 02:54:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4631,8,'2017-05-31 02:55:01','2017-05-31 02:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4632,8,'2017-05-31 02:56:01','2017-05-31 02:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4633,8,'2017-05-31 02:57:01','2017-05-31 02:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4634,8,'2017-05-31 02:58:01','2017-05-31 02:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4635,8,'2017-05-31 02:59:01','2017-05-31 02:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4636,8,'2017-05-31 03:00:02','2017-05-31 03:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4637,8,'2017-05-31 03:01:01','2017-05-31 03:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4638,8,'2017-05-31 03:02:01','2017-05-31 03:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4639,8,'2017-05-31 03:03:01','2017-05-31 03:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4640,8,'2017-05-31 03:04:01','2017-05-31 03:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4641,8,'2017-05-31 03:05:01','2017-05-31 03:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4642,8,'2017-05-31 03:06:01','2017-05-31 03:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4643,8,'2017-05-31 03:07:01','2017-05-31 03:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4644,8,'2017-05-31 03:08:01','2017-05-31 03:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4645,8,'2017-05-31 03:09:01','2017-05-31 03:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4646,8,'2017-05-31 03:10:01','2017-05-31 03:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4647,8,'2017-05-31 03:11:01','2017-05-31 03:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4648,8,'2017-05-31 03:12:01','2017-05-31 03:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4649,8,'2017-05-31 03:13:01','2017-05-31 03:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4650,8,'2017-05-31 03:14:01','2017-05-31 03:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4651,8,'2017-05-31 03:15:01','2017-05-31 03:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4652,8,'2017-05-31 03:16:02','2017-05-31 03:16:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4653,8,'2017-05-31 03:17:01','2017-05-31 03:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4654,8,'2017-05-31 03:18:01','2017-05-31 03:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4655,8,'2017-05-31 03:19:01','2017-05-31 03:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4656,8,'2017-05-31 03:20:01','2017-05-31 03:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4657,8,'2017-05-31 03:21:02','2017-05-31 03:21:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4658,8,'2017-05-31 03:22:01','2017-05-31 03:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4659,8,'2017-05-31 03:23:01','2017-05-31 03:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4660,8,'2017-05-31 03:24:01','2017-05-31 03:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4661,8,'2017-05-31 03:25:01','2017-05-31 03:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4662,8,'2017-05-31 03:26:01','2017-05-31 03:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4663,8,'2017-05-31 03:27:01','2017-05-31 03:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4664,8,'2017-05-31 03:28:01','2017-05-31 03:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4665,8,'2017-05-31 03:29:01','2017-05-31 03:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4666,8,'2017-05-31 03:30:01','2017-05-31 03:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4667,8,'2017-05-31 03:31:01','2017-05-31 03:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4668,8,'2017-05-31 03:32:01','2017-05-31 03:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4669,8,'2017-05-31 03:33:01','2017-05-31 03:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4670,8,'2017-05-31 03:34:01','2017-05-31 03:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4671,8,'2017-05-31 03:35:01','2017-05-31 03:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4672,8,'2017-05-31 03:36:01','2017-05-31 03:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4673,8,'2017-05-31 03:37:01','2017-05-31 03:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4674,8,'2017-05-31 03:38:01','2017-05-31 03:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4675,8,'2017-05-31 03:39:01','2017-05-31 03:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4676,8,'2017-05-31 03:40:01','2017-05-31 03:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4677,8,'2017-05-31 03:41:02','2017-05-31 03:41:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4678,8,'2017-05-31 03:42:01','2017-05-31 03:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4679,8,'2017-05-31 03:43:01','2017-05-31 03:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4680,8,'2017-05-31 03:44:01','2017-05-31 03:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4681,8,'2017-05-31 03:45:01','2017-05-31 03:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4682,8,'2017-05-31 03:46:01','2017-05-31 03:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4683,8,'2017-05-31 03:47:01','2017-05-31 03:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4684,8,'2017-05-31 03:48:01','2017-05-31 03:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4685,8,'2017-05-31 03:49:01','2017-05-31 03:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4686,8,'2017-05-31 03:50:01','2017-05-31 03:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4687,8,'2017-05-31 03:51:01','2017-05-31 03:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4688,8,'2017-05-31 03:52:01','2017-05-31 03:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4689,8,'2017-05-31 03:53:01','2017-05-31 03:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4690,8,'2017-05-31 03:54:01','2017-05-31 03:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4691,8,'2017-05-31 03:55:01','2017-05-31 03:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4692,8,'2017-05-31 03:56:01','2017-05-31 03:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4693,8,'2017-05-31 03:57:01','2017-05-31 03:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4694,8,'2017-05-31 03:58:01','2017-05-31 03:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4695,8,'2017-05-31 03:59:01','2017-05-31 03:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4696,8,'2017-05-31 04:00:01','2017-05-31 04:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4697,8,'2017-05-31 04:01:01','2017-05-31 04:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4698,8,'2017-05-31 04:02:01','2017-05-31 04:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4699,8,'2017-05-31 04:03:02','2017-05-31 04:03:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4700,8,'2017-05-31 04:04:01','2017-05-31 04:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4701,8,'2017-05-31 04:05:01','2017-05-31 04:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4702,8,'2017-05-31 04:06:01','2017-05-31 04:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4703,8,'2017-05-31 04:07:01','2017-05-31 04:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4704,8,'2017-05-31 04:08:01','2017-05-31 04:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4705,8,'2017-05-31 04:09:01','2017-05-31 04:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4706,8,'2017-05-31 04:10:01','2017-05-31 04:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4707,8,'2017-05-31 04:11:01','2017-05-31 04:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4708,8,'2017-05-31 04:12:01','2017-05-31 04:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4709,8,'2017-05-31 04:13:01','2017-05-31 04:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4710,8,'2017-05-31 04:14:01','2017-05-31 04:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4711,8,'2017-05-31 04:15:01','2017-05-31 04:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4712,8,'2017-05-31 04:16:01','2017-05-31 04:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4713,8,'2017-05-31 04:17:01','2017-05-31 04:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4714,8,'2017-05-31 04:18:01','2017-05-31 04:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4715,8,'2017-05-31 04:19:01','2017-05-31 04:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4716,8,'2017-05-31 04:20:01','2017-05-31 04:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4717,8,'2017-05-31 04:21:01','2017-05-31 04:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4718,8,'2017-05-31 04:22:01','2017-05-31 04:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4719,8,'2017-05-31 04:23:02','2017-05-31 04:23:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4720,8,'2017-05-31 04:24:01','2017-05-31 04:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4721,8,'2017-05-31 04:25:01','2017-05-31 04:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4722,8,'2017-05-31 04:26:01','2017-05-31 04:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4723,8,'2017-05-31 04:27:01','2017-05-31 04:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4724,8,'2017-05-31 04:28:01','2017-05-31 04:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4725,8,'2017-05-31 04:29:01','2017-05-31 04:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4726,8,'2017-05-31 04:30:01','2017-05-31 04:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4727,8,'2017-05-31 04:31:02','2017-05-31 04:31:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4728,8,'2017-05-31 04:32:01','2017-05-31 04:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4729,8,'2017-05-31 04:33:01','2017-05-31 04:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4730,8,'2017-05-31 04:34:01','2017-05-31 04:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4731,8,'2017-05-31 04:35:01','2017-05-31 04:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4732,8,'2017-05-31 04:36:01','2017-05-31 04:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4733,8,'2017-05-31 04:37:01','2017-05-31 04:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4734,8,'2017-05-31 04:38:01','2017-05-31 04:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4735,8,'2017-05-31 04:39:01','2017-05-31 04:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4736,8,'2017-05-31 04:40:01','2017-05-31 04:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4737,8,'2017-05-31 04:41:01','2017-05-31 04:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4738,8,'2017-05-31 04:42:01','2017-05-31 04:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4739,8,'2017-05-31 04:43:01','2017-05-31 04:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4740,8,'2017-05-31 04:44:01','2017-05-31 04:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4741,8,'2017-05-31 04:45:01','2017-05-31 04:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4742,8,'2017-05-31 04:46:01','2017-05-31 04:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4743,8,'2017-05-31 04:47:01','2017-05-31 04:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4744,8,'2017-05-31 04:48:01','2017-05-31 04:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4745,8,'2017-05-31 04:49:01','2017-05-31 04:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4746,8,'2017-05-31 04:50:01','2017-05-31 04:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4747,8,'2017-05-31 04:51:01','2017-05-31 04:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4748,8,'2017-05-31 04:52:01','2017-05-31 04:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4749,8,'2017-05-31 04:53:01','2017-05-31 04:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4750,8,'2017-05-31 04:54:02','2017-05-31 04:54:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4751,8,'2017-05-31 04:55:01','2017-05-31 04:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4752,8,'2017-05-31 04:56:01','2017-05-31 04:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4753,8,'2017-05-31 04:57:01','2017-05-31 04:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4754,8,'2017-05-31 04:58:01','2017-05-31 04:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4755,8,'2017-05-31 04:59:02','2017-05-31 04:59:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4756,8,'2017-05-31 05:00:01','2017-05-31 05:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4757,8,'2017-05-31 05:01:01','2017-05-31 05:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4758,8,'2017-05-31 05:02:01','2017-05-31 05:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4759,8,'2017-05-31 05:03:02','2017-05-31 05:03:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4760,8,'2017-05-31 05:04:01','2017-05-31 05:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4761,8,'2017-05-31 05:05:01','2017-05-31 05:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4762,8,'2017-05-31 05:06:01','2017-05-31 05:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4763,8,'2017-05-31 05:07:01','2017-05-31 05:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4764,8,'2017-05-31 05:08:01','2017-05-31 05:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4765,8,'2017-05-31 05:09:01','2017-05-31 05:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4766,8,'2017-05-31 05:10:01','2017-05-31 05:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4767,8,'2017-05-31 05:11:01','2017-05-31 05:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4768,8,'2017-05-31 05:12:01','2017-05-31 05:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4769,8,'2017-05-31 05:13:01','2017-05-31 05:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4770,8,'2017-05-31 05:14:01','2017-05-31 05:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4771,8,'2017-05-31 05:15:01','2017-05-31 05:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4772,8,'2017-05-31 05:16:01','2017-05-31 05:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4773,8,'2017-05-31 05:17:01','2017-05-31 05:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4774,8,'2017-05-31 05:18:01','2017-05-31 05:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4775,8,'2017-05-31 05:19:01','2017-05-31 05:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4776,8,'2017-05-31 05:20:01','2017-05-31 05:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4777,8,'2017-05-31 05:21:01','2017-05-31 05:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4778,8,'2017-05-31 05:22:01','2017-05-31 05:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4779,8,'2017-05-31 05:23:01','2017-05-31 05:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4780,8,'2017-05-31 05:24:01','2017-05-31 05:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4781,8,'2017-05-31 05:25:01','2017-05-31 05:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4782,8,'2017-05-31 05:26:01','2017-05-31 05:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4783,8,'2017-05-31 05:27:01','2017-05-31 05:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4784,8,'2017-05-31 05:28:01','2017-05-31 05:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4785,8,'2017-05-31 05:29:01','2017-05-31 05:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4786,8,'2017-05-31 05:30:01','2017-05-31 05:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4787,8,'2017-05-31 05:31:01','2017-05-31 05:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4788,8,'2017-05-31 05:32:01','2017-05-31 05:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4789,8,'2017-05-31 05:33:01','2017-05-31 05:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4790,8,'2017-05-31 05:34:01','2017-05-31 05:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4791,8,'2017-05-31 05:35:01','2017-05-31 05:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4792,8,'2017-05-31 05:36:01','2017-05-31 05:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4793,8,'2017-05-31 05:37:01','2017-05-31 05:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4794,8,'2017-05-31 05:38:01','2017-05-31 05:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4795,8,'2017-05-31 05:39:01','2017-05-31 05:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4796,8,'2017-05-31 05:40:01','2017-05-31 05:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4797,8,'2017-05-31 05:41:01','2017-05-31 05:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4798,8,'2017-05-31 05:42:01','2017-05-31 05:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4799,8,'2017-05-31 05:43:01','2017-05-31 05:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4800,8,'2017-05-31 05:44:01','2017-05-31 05:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4801,8,'2017-05-31 05:45:01','2017-05-31 05:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4802,8,'2017-05-31 05:46:01','2017-05-31 05:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4803,8,'2017-05-31 05:47:01','2017-05-31 05:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4804,8,'2017-05-31 05:48:01','2017-05-31 05:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4805,8,'2017-05-31 05:49:01','2017-05-31 05:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4806,8,'2017-05-31 05:50:01','2017-05-31 05:50:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4807,8,'2017-05-31 05:51:01','2017-05-31 05:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4808,8,'2017-05-31 05:52:01','2017-05-31 05:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4809,8,'2017-05-31 05:53:01','2017-05-31 05:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4810,8,'2017-05-31 05:54:01','2017-05-31 05:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4811,8,'2017-05-31 05:55:01','2017-05-31 05:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4812,8,'2017-05-31 05:56:01','2017-05-31 05:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4813,8,'2017-05-31 05:57:01','2017-05-31 05:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4814,8,'2017-05-31 05:58:01','2017-05-31 05:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4815,8,'2017-05-31 05:59:01','2017-05-31 05:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4816,8,'2017-05-31 06:00:01','2017-05-31 06:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4817,8,'2017-05-31 06:01:01','2017-05-31 06:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4818,8,'2017-05-31 06:02:01','2017-05-31 06:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4819,8,'2017-05-31 06:03:01','2017-05-31 06:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4820,8,'2017-05-31 06:04:01','2017-05-31 06:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4821,8,'2017-05-31 06:05:01','2017-05-31 06:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4822,8,'2017-05-31 06:06:01','2017-05-31 06:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4823,8,'2017-05-31 06:07:01','2017-05-31 06:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4824,8,'2017-05-31 06:08:01','2017-05-31 06:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4825,8,'2017-05-31 06:09:01','2017-05-31 06:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4826,8,'2017-05-31 06:10:01','2017-05-31 06:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4827,8,'2017-05-31 06:11:01','2017-05-31 06:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4828,8,'2017-05-31 06:12:01','2017-05-31 06:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4829,8,'2017-05-31 06:13:01','2017-05-31 06:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4830,8,'2017-05-31 06:14:02','2017-05-31 06:14:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4831,8,'2017-05-31 06:15:01','2017-05-31 06:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4832,8,'2017-05-31 06:16:01','2017-05-31 06:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4833,8,'2017-05-31 06:17:01','2017-05-31 06:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4834,8,'2017-05-31 06:18:01','2017-05-31 06:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4835,8,'2017-05-31 06:19:01','2017-05-31 06:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4836,8,'2017-05-31 06:20:01','2017-05-31 06:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4837,8,'2017-05-31 06:21:01','2017-05-31 06:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4838,8,'2017-05-31 06:22:02','2017-05-31 06:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4839,8,'2017-05-31 06:23:01','2017-05-31 06:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4840,8,'2017-05-31 06:24:01','2017-05-31 06:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4841,8,'2017-05-31 06:25:01','2017-05-31 06:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4842,8,'2017-05-31 06:26:01','2017-05-31 06:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4843,8,'2017-05-31 06:27:01','2017-05-31 06:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4844,8,'2017-05-31 06:28:01','2017-05-31 06:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4845,8,'2017-05-31 06:29:01','2017-05-31 06:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4846,8,'2017-05-31 06:30:01','2017-05-31 06:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4847,8,'2017-05-31 06:31:02','2017-05-31 06:31:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4848,8,'2017-05-31 06:32:01','2017-05-31 06:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4849,8,'2017-05-31 06:33:01','2017-05-31 06:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4850,8,'2017-05-31 06:34:01','2017-05-31 06:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4851,8,'2017-05-31 06:35:01','2017-05-31 06:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4852,8,'2017-05-31 06:36:01','2017-05-31 06:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4853,8,'2017-05-31 06:37:01','2017-05-31 06:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4854,8,'2017-05-31 06:38:01','2017-05-31 06:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4855,8,'2017-05-31 06:39:01','2017-05-31 06:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4856,8,'2017-05-31 06:40:01','2017-05-31 06:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4857,8,'2017-05-31 06:41:01','2017-05-31 06:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4858,8,'2017-05-31 06:42:01','2017-05-31 06:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4859,8,'2017-05-31 06:43:01','2017-05-31 06:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4860,8,'2017-05-31 06:44:01','2017-05-31 06:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4861,8,'2017-05-31 06:45:01','2017-05-31 06:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4862,8,'2017-05-31 06:46:01','2017-05-31 06:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4863,8,'2017-05-31 06:47:01','2017-05-31 06:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4864,8,'2017-05-31 06:48:01','2017-05-31 06:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4865,8,'2017-05-31 06:49:01','2017-05-31 06:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4866,8,'2017-05-31 06:50:01','2017-05-31 06:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4867,8,'2017-05-31 06:51:01','2017-05-31 06:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4868,8,'2017-05-31 06:52:01','2017-05-31 06:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4869,8,'2017-05-31 06:53:01','2017-05-31 06:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4870,8,'2017-05-31 06:54:01','2017-05-31 06:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4871,8,'2017-05-31 06:55:01','2017-05-31 06:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4872,8,'2017-05-31 06:56:01','2017-05-31 06:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4873,8,'2017-05-31 06:57:01','2017-05-31 06:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4874,8,'2017-05-31 06:58:01','2017-05-31 06:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4875,8,'2017-05-31 06:59:01','2017-05-31 06:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4876,8,'2017-05-31 07:00:01','2017-05-31 07:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4877,8,'2017-05-31 07:01:01','2017-05-31 07:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4878,8,'2017-05-31 07:02:01','2017-05-31 07:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4879,8,'2017-05-31 07:03:01','2017-05-31 07:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4880,8,'2017-05-31 07:04:01','2017-05-31 07:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4881,8,'2017-05-31 07:05:01','2017-05-31 07:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4882,8,'2017-05-31 07:06:01','2017-05-31 07:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4883,8,'2017-05-31 07:07:01','2017-05-31 07:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4884,8,'2017-05-31 07:08:01','2017-05-31 07:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4885,8,'2017-05-31 07:09:01','2017-05-31 07:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4886,8,'2017-05-31 07:10:01','2017-05-31 07:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4887,8,'2017-05-31 07:11:01','2017-05-31 07:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4888,8,'2017-05-31 07:12:01','2017-05-31 07:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4889,8,'2017-05-31 07:13:01','2017-05-31 07:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4890,8,'2017-05-31 07:14:01','2017-05-31 07:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4891,8,'2017-05-31 07:15:01','2017-05-31 07:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4892,8,'2017-05-31 07:16:01','2017-05-31 07:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4893,8,'2017-05-31 07:17:01','2017-05-31 07:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4894,8,'2017-05-31 07:18:02','2017-05-31 07:18:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4895,8,'2017-05-31 07:19:01','2017-05-31 07:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4896,8,'2017-05-31 07:20:01','2017-05-31 07:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4897,8,'2017-05-31 07:21:01','2017-05-31 07:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4898,8,'2017-05-31 07:22:01','2017-05-31 07:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4899,8,'2017-05-31 07:23:01','2017-05-31 07:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4900,8,'2017-05-31 07:24:01','2017-05-31 07:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4901,8,'2017-05-31 07:25:01','2017-05-31 07:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4902,8,'2017-05-31 07:26:01','2017-05-31 07:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4903,8,'2017-05-31 07:27:01','2017-05-31 07:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4904,8,'2017-05-31 07:28:01','2017-05-31 07:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4905,8,'2017-05-31 07:29:01','2017-05-31 07:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4906,8,'2017-05-31 07:30:01','2017-05-31 07:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4907,8,'2017-05-31 07:31:01','2017-05-31 07:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4908,8,'2017-05-31 07:32:01','2017-05-31 07:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4909,8,'2017-05-31 07:33:01','2017-05-31 07:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4910,8,'2017-05-31 07:34:01','2017-05-31 07:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4911,8,'2017-05-31 07:35:01','2017-05-31 07:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4912,8,'2017-05-31 07:36:01','2017-05-31 07:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4913,8,'2017-05-31 07:37:01','2017-05-31 07:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4914,8,'2017-05-31 07:38:01','2017-05-31 07:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4915,8,'2017-05-31 07:39:01','2017-05-31 07:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4916,8,'2017-05-31 07:40:01','2017-05-31 07:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4917,8,'2017-05-31 07:41:01','2017-05-31 07:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4918,8,'2017-05-31 07:42:01','2017-05-31 07:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4919,8,'2017-05-31 07:43:01','2017-05-31 07:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4920,8,'2017-05-31 07:44:01','2017-05-31 07:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4921,8,'2017-05-31 07:45:01','2017-05-31 07:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4922,8,'2017-05-31 07:46:01','2017-05-31 07:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4923,8,'2017-05-31 07:47:01','2017-05-31 07:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4924,8,'2017-05-31 07:48:01','2017-05-31 07:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4925,8,'2017-05-31 07:49:01','2017-05-31 07:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4926,8,'2017-05-31 07:50:01','2017-05-31 07:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4927,8,'2017-05-31 07:51:01','2017-05-31 07:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4928,8,'2017-05-31 07:52:01','2017-05-31 07:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4929,8,'2017-05-31 07:53:01','2017-05-31 07:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4930,8,'2017-05-31 07:54:01','2017-05-31 07:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4931,8,'2017-05-31 07:55:01','2017-05-31 07:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4932,8,'2017-05-31 07:56:02','2017-05-31 07:56:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4933,8,'2017-05-31 07:57:01','2017-05-31 07:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4934,8,'2017-05-31 07:58:01','2017-05-31 07:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4935,8,'2017-05-31 07:59:01','2017-05-31 07:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4936,8,'2017-05-31 08:00:01','2017-05-31 08:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4937,8,'2017-05-31 08:01:01','2017-05-31 08:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4938,8,'2017-05-31 08:02:01','2017-05-31 08:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4939,8,'2017-05-31 08:03:01','2017-05-31 08:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4940,8,'2017-05-31 08:04:02','2017-05-31 08:04:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4941,8,'2017-05-31 08:05:01','2017-05-31 08:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4942,8,'2017-05-31 08:06:01','2017-05-31 08:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4943,8,'2017-05-31 08:07:01','2017-05-31 08:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4944,8,'2017-05-31 08:08:01','2017-05-31 08:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4945,8,'2017-05-31 08:09:01','2017-05-31 08:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4946,8,'2017-05-31 08:10:01','2017-05-31 08:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4947,8,'2017-05-31 08:11:01','2017-05-31 08:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4948,8,'2017-05-31 08:12:01','2017-05-31 08:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4949,8,'2017-05-31 08:13:01','2017-05-31 08:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4950,8,'2017-05-31 08:14:01','2017-05-31 08:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4951,8,'2017-05-31 08:15:01','2017-05-31 08:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4952,8,'2017-05-31 08:16:01','2017-05-31 08:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4953,8,'2017-05-31 08:17:01','2017-05-31 08:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4954,8,'2017-05-31 08:18:01','2017-05-31 08:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4955,8,'2017-05-31 08:19:01','2017-05-31 08:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4956,8,'2017-05-31 08:20:01','2017-05-31 08:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4957,8,'2017-05-31 08:21:01','2017-05-31 08:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4958,8,'2017-05-31 08:22:01','2017-05-31 08:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4959,8,'2017-05-31 08:23:01','2017-05-31 08:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4960,8,'2017-05-31 08:24:01','2017-05-31 08:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4961,8,'2017-05-31 08:25:01','2017-05-31 08:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4962,8,'2017-05-31 08:26:01','2017-05-31 08:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4963,8,'2017-05-31 08:27:01','2017-05-31 08:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4964,8,'2017-05-31 08:28:01','2017-05-31 08:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4965,8,'2017-05-31 08:29:01','2017-05-31 08:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4966,8,'2017-05-31 08:30:01','2017-05-31 08:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4967,8,'2017-05-31 08:31:01','2017-05-31 08:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4968,8,'2017-05-31 08:32:01','2017-05-31 08:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4969,8,'2017-05-31 08:33:01','2017-05-31 08:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4970,8,'2017-05-31 08:34:01','2017-05-31 08:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4971,8,'2017-05-31 08:35:01','2017-05-31 08:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4972,8,'2017-05-31 08:36:01','2017-05-31 08:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4973,8,'2017-05-31 08:37:01','2017-05-31 08:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4974,8,'2017-05-31 08:38:02','2017-05-31 08:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4975,8,'2017-05-31 08:39:01','2017-05-31 08:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4976,8,'2017-05-31 08:40:01','2017-05-31 08:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4977,8,'2017-05-31 08:41:01','2017-05-31 08:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4978,8,'2017-05-31 08:42:01','2017-05-31 08:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4979,8,'2017-05-31 08:43:01','2017-05-31 08:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4980,8,'2017-05-31 08:44:01','2017-05-31 08:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4981,8,'2017-05-31 08:45:01','2017-05-31 08:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4982,8,'2017-05-31 08:46:01','2017-05-31 08:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4983,8,'2017-05-31 08:47:01','2017-05-31 08:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4984,8,'2017-05-31 08:48:02','2017-05-31 08:48:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4985,8,'2017-05-31 08:49:01','2017-05-31 08:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4986,8,'2017-05-31 08:50:01','2017-05-31 08:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4987,8,'2017-05-31 08:51:02','2017-05-31 08:51:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4988,8,'2017-05-31 08:52:01','2017-05-31 08:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4989,8,'2017-05-31 08:53:01','2017-05-31 08:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4990,8,'2017-05-31 08:54:01','2017-05-31 08:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4991,8,'2017-05-31 08:55:01','2017-05-31 08:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4992,8,'2017-05-31 08:56:01','2017-05-31 08:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4993,8,'2017-05-31 08:57:01','2017-05-31 08:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4994,8,'2017-05-31 08:58:01','2017-05-31 08:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4995,8,'2017-05-31 08:59:01','2017-05-31 08:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4996,8,'2017-05-31 09:00:01','2017-05-31 09:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4997,8,'2017-05-31 09:01:01','2017-05-31 09:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4998,8,'2017-05-31 09:02:01','2017-05-31 09:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(4999,8,'2017-05-31 09:03:01','2017-05-31 09:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5000,8,'2017-05-31 09:04:01','2017-05-31 09:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5001,8,'2017-05-31 09:05:01','2017-05-31 09:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5002,8,'2017-05-31 09:06:01','2017-05-31 09:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5003,8,'2017-05-31 09:07:01','2017-05-31 09:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5004,8,'2017-05-31 09:08:01','2017-05-31 09:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5005,8,'2017-05-31 09:09:01','2017-05-31 09:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5006,8,'2017-05-31 09:10:01','2017-05-31 09:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5007,8,'2017-05-31 09:11:01','2017-05-31 09:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5008,8,'2017-05-31 09:12:01','2017-05-31 09:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5009,8,'2017-05-31 09:13:01','2017-05-31 09:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5010,8,'2017-05-31 09:14:01','2017-05-31 09:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5011,8,'2017-05-31 09:15:01','2017-05-31 09:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5012,8,'2017-05-31 09:16:01','2017-05-31 09:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5013,8,'2017-05-31 09:17:02','2017-05-31 09:17:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5014,8,'2017-05-31 09:18:01','2017-05-31 09:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5015,8,'2017-05-31 09:19:01','2017-05-31 09:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5016,8,'2017-05-31 09:20:01','2017-05-31 09:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5017,8,'2017-05-31 09:21:01','2017-05-31 09:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5018,8,'2017-05-31 09:22:01','2017-05-31 09:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5019,8,'2017-05-31 09:23:01','2017-05-31 09:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5020,8,'2017-05-31 09:24:01','2017-05-31 09:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5021,8,'2017-05-31 09:25:01','2017-05-31 09:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5022,8,'2017-05-31 09:26:01','2017-05-31 09:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5023,8,'2017-05-31 09:27:01','2017-05-31 09:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5024,8,'2017-05-31 09:28:01','2017-05-31 09:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5025,8,'2017-05-31 09:29:01','2017-05-31 09:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5026,8,'2017-05-31 09:30:01','2017-05-31 09:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5027,8,'2017-05-31 09:31:02','2017-05-31 09:31:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5028,8,'2017-05-31 09:32:01','2017-05-31 09:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5029,8,'2017-05-31 09:33:01','2017-05-31 09:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5030,8,'2017-05-31 09:34:02','2017-05-31 09:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5031,8,'2017-05-31 09:35:01','2017-05-31 09:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5032,8,'2017-05-31 09:36:01','2017-05-31 09:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5033,8,'2017-05-31 09:37:01','2017-05-31 09:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5034,8,'2017-05-31 09:38:01','2017-05-31 09:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5035,8,'2017-05-31 09:39:01','2017-05-31 09:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5036,8,'2017-05-31 09:40:01','2017-05-31 09:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5037,8,'2017-05-31 09:41:01','2017-05-31 09:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5038,8,'2017-05-31 09:42:01','2017-05-31 09:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5039,8,'2017-05-31 09:43:01','2017-05-31 09:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5040,8,'2017-05-31 09:44:01','2017-05-31 09:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5041,8,'2017-05-31 09:45:01','2017-05-31 09:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5042,8,'2017-05-31 09:46:01','2017-05-31 09:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5043,8,'2017-05-31 09:47:01','2017-05-31 09:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5044,8,'2017-05-31 09:48:01','2017-05-31 09:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5045,8,'2017-05-31 09:49:01','2017-05-31 09:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5046,8,'2017-05-31 09:50:01','2017-05-31 09:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5047,8,'2017-05-31 09:51:01','2017-05-31 09:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5048,8,'2017-05-31 09:52:01','2017-05-31 09:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5049,8,'2017-05-31 09:53:01','2017-05-31 09:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5050,8,'2017-05-31 09:54:01','2017-05-31 09:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5051,8,'2017-05-31 09:55:01','2017-05-31 09:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5052,8,'2017-05-31 09:56:02','2017-05-31 09:56:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5053,8,'2017-05-31 09:57:01','2017-05-31 09:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5054,8,'2017-05-31 09:58:01','2017-05-31 09:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5055,8,'2017-05-31 09:59:01','2017-05-31 09:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5056,8,'2017-05-31 10:00:01','2017-05-31 10:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5057,8,'2017-05-31 10:01:01','2017-05-31 10:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5058,8,'2017-05-31 10:02:01','2017-05-31 10:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5059,8,'2017-05-31 10:03:01','2017-05-31 10:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5060,8,'2017-05-31 10:04:01','2017-05-31 10:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5061,8,'2017-05-31 10:05:01','2017-05-31 10:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5062,8,'2017-05-31 10:06:01','2017-05-31 10:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5063,8,'2017-05-31 10:07:01','2017-05-31 10:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5064,8,'2017-05-31 10:08:01','2017-05-31 10:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5065,8,'2017-05-31 10:09:01','2017-05-31 10:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5066,8,'2017-05-31 10:10:01','2017-05-31 10:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5067,8,'2017-05-31 10:11:02','2017-05-31 10:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5068,8,'2017-05-31 10:12:01','2017-05-31 10:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5069,8,'2017-05-31 10:13:01','2017-05-31 10:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5070,8,'2017-05-31 10:14:01','2017-05-31 10:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5071,8,'2017-05-31 10:15:01','2017-05-31 10:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5072,8,'2017-05-31 10:16:01','2017-05-31 10:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5073,8,'2017-05-31 10:17:01','2017-05-31 10:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5074,8,'2017-05-31 10:18:01','2017-05-31 10:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5075,8,'2017-05-31 10:19:02','2017-05-31 10:19:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5076,8,'2017-05-31 10:20:01','2017-05-31 10:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5077,8,'2017-05-31 10:21:01','2017-05-31 10:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5078,8,'2017-05-31 10:22:01','2017-05-31 10:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5079,8,'2017-05-31 10:23:01','2017-05-31 10:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5080,8,'2017-05-31 10:24:01','2017-05-31 10:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5081,8,'2017-05-31 10:25:01','2017-05-31 10:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5082,8,'2017-05-31 10:26:01','2017-05-31 10:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5083,8,'2017-05-31 10:27:01','2017-05-31 10:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5084,8,'2017-05-31 10:28:01','2017-05-31 10:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5085,8,'2017-05-31 10:29:01','2017-05-31 10:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5086,8,'2017-05-31 10:30:01','2017-05-31 10:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5087,8,'2017-05-31 10:31:01','2017-05-31 10:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5088,8,'2017-05-31 10:32:01','2017-05-31 10:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5089,8,'2017-05-31 10:33:01','2017-05-31 10:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5090,8,'2017-05-31 10:34:01','2017-05-31 10:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5091,8,'2017-05-31 10:35:01','2017-05-31 10:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5092,8,'2017-05-31 10:36:01','2017-05-31 10:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5093,8,'2017-05-31 10:37:01','2017-05-31 10:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5094,8,'2017-05-31 10:38:02','2017-05-31 10:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5095,8,'2017-05-31 10:39:01','2017-05-31 10:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5096,8,'2017-05-31 10:40:01','2017-05-31 10:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5097,8,'2017-05-31 10:41:01','2017-05-31 10:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5098,8,'2017-05-31 10:42:01','2017-05-31 10:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5099,8,'2017-05-31 10:43:01','2017-05-31 10:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5100,8,'2017-05-31 10:44:01','2017-05-31 10:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5101,8,'2017-05-31 10:45:01','2017-05-31 10:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5102,8,'2017-05-31 10:46:01','2017-05-31 10:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5103,8,'2017-05-31 10:47:01','2017-05-31 10:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5104,8,'2017-05-31 10:48:01','2017-05-31 10:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5105,8,'2017-05-31 10:49:01','2017-05-31 10:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5106,8,'2017-05-31 10:50:01','2017-05-31 10:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5107,8,'2017-05-31 10:51:01','2017-05-31 10:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5108,8,'2017-05-31 10:52:01','2017-05-31 10:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5109,8,'2017-05-31 10:53:01','2017-05-31 10:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5110,8,'2017-05-31 10:54:01','2017-05-31 10:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5111,8,'2017-05-31 10:55:01','2017-05-31 10:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5112,8,'2017-05-31 10:56:01','2017-05-31 10:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5113,8,'2017-05-31 10:57:01','2017-05-31 10:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5114,8,'2017-05-31 10:58:01','2017-05-31 10:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5115,8,'2017-05-31 10:59:01','2017-05-31 10:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5116,8,'2017-05-31 11:00:01','2017-05-31 11:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5117,8,'2017-05-31 11:01:01','2017-05-31 11:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5118,8,'2017-05-31 11:02:01','2017-05-31 11:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5119,8,'2017-05-31 11:03:01','2017-05-31 11:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5120,8,'2017-05-31 11:04:01','2017-05-31 11:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5121,8,'2017-05-31 11:05:01','2017-05-31 11:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5122,8,'2017-05-31 11:06:01','2017-05-31 11:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5123,8,'2017-05-31 11:07:01','2017-05-31 11:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5124,8,'2017-05-31 11:08:01','2017-05-31 11:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5125,8,'2017-05-31 11:09:01','2017-05-31 11:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5126,8,'2017-05-31 11:10:01','2017-05-31 11:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5127,8,'2017-05-31 11:11:01','2017-05-31 11:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5128,8,'2017-05-31 11:12:01','2017-05-31 11:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5129,8,'2017-05-31 11:13:01','2017-05-31 11:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5130,8,'2017-05-31 11:14:01','2017-05-31 11:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5131,8,'2017-05-31 11:15:01','2017-05-31 11:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5132,8,'2017-05-31 11:16:01','2017-05-31 11:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5133,8,'2017-05-31 11:17:01','2017-05-31 11:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5134,8,'2017-05-31 11:18:01','2017-05-31 11:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5135,8,'2017-05-31 11:19:01','2017-05-31 11:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5136,8,'2017-05-31 11:20:01','2017-05-31 11:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5137,8,'2017-05-31 11:21:01','2017-05-31 11:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5138,8,'2017-05-31 11:22:01','2017-05-31 11:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5139,8,'2017-05-31 11:23:01','2017-05-31 11:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5140,8,'2017-05-31 11:24:01','2017-05-31 11:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5141,8,'2017-05-31 11:25:01','2017-05-31 11:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5142,8,'2017-05-31 11:26:01','2017-05-31 11:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5143,8,'2017-05-31 11:27:01','2017-05-31 11:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5144,8,'2017-05-31 11:28:01','2017-05-31 11:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5145,8,'2017-05-31 11:29:01','2017-05-31 11:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5146,8,'2017-05-31 11:30:01','2017-05-31 11:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5147,8,'2017-05-31 11:31:01','2017-05-31 11:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5148,8,'2017-05-31 11:32:01','2017-05-31 11:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5149,8,'2017-05-31 11:33:01','2017-05-31 11:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5150,8,'2017-05-31 11:34:01','2017-05-31 11:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5151,8,'2017-05-31 11:35:01','2017-05-31 11:35:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5152,8,'2017-05-31 11:36:01','2017-05-31 11:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5153,8,'2017-05-31 11:37:01','2017-05-31 11:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5154,8,'2017-05-31 11:38:01','2017-05-31 11:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5155,8,'2017-05-31 11:39:01','2017-05-31 11:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5156,8,'2017-05-31 11:40:01','2017-05-31 11:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5157,8,'2017-05-31 11:41:01','2017-05-31 11:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5158,8,'2017-05-31 11:42:01','2017-05-31 11:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5159,8,'2017-05-31 11:43:01','2017-05-31 11:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5160,8,'2017-05-31 11:44:01','2017-05-31 11:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5161,8,'2017-05-31 11:45:01','2017-05-31 11:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5162,8,'2017-05-31 11:46:01','2017-05-31 11:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5163,8,'2017-05-31 11:47:01','2017-05-31 11:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5164,8,'2017-05-31 11:48:01','2017-05-31 11:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5165,8,'2017-05-31 11:49:01','2017-05-31 11:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5166,8,'2017-05-31 11:50:01','2017-05-31 11:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5167,8,'2017-05-31 11:51:01','2017-05-31 11:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5168,8,'2017-05-31 11:52:01','2017-05-31 11:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5169,8,'2017-05-31 11:53:01','2017-05-31 11:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5170,8,'2017-05-31 11:54:02','2017-05-31 11:54:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5171,8,'2017-05-31 11:55:01','2017-05-31 11:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5172,8,'2017-05-31 11:56:01','2017-05-31 11:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5173,8,'2017-05-31 11:57:01','2017-05-31 11:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5174,8,'2017-05-31 11:58:01','2017-05-31 11:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5175,8,'2017-05-31 11:59:01','2017-05-31 11:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5176,8,'2017-05-31 12:00:02','2017-05-31 12:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5177,8,'2017-05-31 12:01:01','2017-05-31 12:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5178,8,'2017-05-31 12:02:01','2017-05-31 12:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5179,8,'2017-05-31 12:03:01','2017-05-31 12:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5180,8,'2017-05-31 12:04:02','2017-05-31 12:04:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5181,8,'2017-05-31 12:05:01','2017-05-31 12:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5182,8,'2017-05-31 12:06:01','2017-05-31 12:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5183,8,'2017-05-31 12:07:01','2017-05-31 12:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5184,8,'2017-05-31 12:08:01','2017-05-31 12:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5185,8,'2017-05-31 12:09:01','2017-05-31 12:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5186,8,'2017-05-31 12:10:01','2017-05-31 12:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5187,8,'2017-05-31 12:11:01','2017-05-31 12:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5188,8,'2017-05-31 12:12:01','2017-05-31 12:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5189,8,'2017-05-31 12:13:01','2017-05-31 12:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5190,8,'2017-05-31 12:14:02','2017-05-31 12:14:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5191,8,'2017-05-31 12:15:01','2017-05-31 12:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5192,8,'2017-05-31 12:16:01','2017-05-31 12:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5193,8,'2017-05-31 12:17:01','2017-05-31 12:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5194,8,'2017-05-31 12:18:01','2017-05-31 12:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5195,8,'2017-05-31 12:19:01','2017-05-31 12:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5196,8,'2017-05-31 12:20:01','2017-05-31 12:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5197,8,'2017-05-31 12:21:01','2017-05-31 12:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5198,8,'2017-05-31 12:22:02','2017-05-31 12:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5199,8,'2017-05-31 12:23:01','2017-05-31 12:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5200,8,'2017-05-31 12:24:01','2017-05-31 12:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5201,8,'2017-05-31 12:25:01','2017-05-31 12:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5202,8,'2017-05-31 12:26:01','2017-05-31 12:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5203,8,'2017-05-31 12:27:01','2017-05-31 12:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5204,8,'2017-05-31 12:28:01','2017-05-31 12:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5205,8,'2017-05-31 12:29:01','2017-05-31 12:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5206,8,'2017-05-31 12:30:01','2017-05-31 12:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5207,8,'2017-05-31 12:31:01','2017-05-31 12:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5208,8,'2017-05-31 12:32:01','2017-05-31 12:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5209,8,'2017-05-31 12:33:01','2017-05-31 12:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5210,8,'2017-05-31 12:34:01','2017-05-31 12:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5211,8,'2017-05-31 12:35:01','2017-05-31 12:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5212,8,'2017-05-31 12:36:01','2017-05-31 12:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5213,8,'2017-05-31 12:37:01','2017-05-31 12:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5214,8,'2017-05-31 12:38:01','2017-05-31 12:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5215,8,'2017-05-31 12:39:01','2017-05-31 12:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5216,8,'2017-05-31 12:40:01','2017-05-31 12:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5217,8,'2017-05-31 12:41:01','2017-05-31 12:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5218,8,'2017-05-31 12:42:01','2017-05-31 12:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5219,8,'2017-05-31 12:43:01','2017-05-31 12:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5220,8,'2017-05-31 12:44:01','2017-05-31 12:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5221,8,'2017-05-31 12:45:01','2017-05-31 12:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5222,8,'2017-05-31 12:46:01','2017-05-31 12:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5223,8,'2017-05-31 12:47:01','2017-05-31 12:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5224,8,'2017-05-31 12:48:02','2017-05-31 12:48:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5225,8,'2017-05-31 12:49:01','2017-05-31 12:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5226,8,'2017-05-31 12:50:01','2017-05-31 12:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5227,8,'2017-05-31 12:51:02','2017-05-31 12:51:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5228,8,'2017-05-31 12:52:01','2017-05-31 12:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5229,8,'2017-05-31 12:53:01','2017-05-31 12:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5230,8,'2017-05-31 12:54:01','2017-05-31 12:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5231,8,'2017-05-31 12:55:01','2017-05-31 12:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5232,8,'2017-05-31 12:56:01','2017-05-31 12:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5233,8,'2017-05-31 12:57:01','2017-05-31 12:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5234,8,'2017-05-31 12:58:01','2017-05-31 12:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5235,8,'2017-05-31 12:59:01','2017-05-31 12:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5236,8,'2017-05-31 13:00:01','2017-05-31 13:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5237,8,'2017-05-31 13:01:01','2017-05-31 13:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5238,8,'2017-05-31 13:02:01','2017-05-31 13:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5239,8,'2017-05-31 13:03:01','2017-05-31 13:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5240,8,'2017-05-31 13:04:01','2017-05-31 13:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5241,8,'2017-05-31 13:05:01','2017-05-31 13:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5242,8,'2017-05-31 13:06:01','2017-05-31 13:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5243,8,'2017-05-31 13:07:01','2017-05-31 13:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5244,8,'2017-05-31 13:08:01','2017-05-31 13:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5245,8,'2017-05-31 13:09:01','2017-05-31 13:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5246,8,'2017-05-31 13:10:01','2017-05-31 13:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5247,8,'2017-05-31 13:11:01','2017-05-31 13:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5248,8,'2017-05-31 13:12:01','2017-05-31 13:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5249,8,'2017-05-31 13:13:01','2017-05-31 13:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5250,8,'2017-05-31 13:14:01','2017-05-31 13:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5251,8,'2017-05-31 13:15:01','2017-05-31 13:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5252,8,'2017-05-31 13:16:01','2017-05-31 13:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5253,8,'2017-05-31 13:17:01','2017-05-31 13:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5254,8,'2017-05-31 13:18:01','2017-05-31 13:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5255,8,'2017-05-31 13:19:01','2017-05-31 13:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5256,8,'2017-05-31 13:20:01','2017-05-31 13:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5257,8,'2017-05-31 13:21:01','2017-05-31 13:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5258,8,'2017-05-31 13:22:02','2017-05-31 13:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5259,8,'2017-05-31 13:23:01','2017-05-31 13:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5260,8,'2017-05-31 13:24:01','2017-05-31 13:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5261,8,'2017-05-31 13:25:01','2017-05-31 13:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5262,8,'2017-05-31 13:26:01','2017-05-31 13:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5263,8,'2017-05-31 13:27:02','2017-05-31 13:27:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5264,8,'2017-05-31 13:28:01','2017-05-31 13:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5265,8,'2017-05-31 13:29:01','2017-05-31 13:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5266,8,'2017-05-31 13:30:02','2017-05-31 13:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5267,8,'2017-05-31 13:31:01','2017-05-31 13:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5268,8,'2017-05-31 13:32:01','2017-05-31 13:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5269,8,'2017-05-31 13:33:01','2017-05-31 13:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5270,8,'2017-05-31 13:34:01','2017-05-31 13:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5271,8,'2017-05-31 13:35:01','2017-05-31 13:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5272,8,'2017-05-31 13:36:01','2017-05-31 13:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5273,8,'2017-05-31 13:37:01','2017-05-31 13:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5274,8,'2017-05-31 13:38:01','2017-05-31 13:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5275,8,'2017-05-31 13:39:01','2017-05-31 13:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5276,8,'2017-05-31 13:40:01','2017-05-31 13:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5277,8,'2017-05-31 13:41:01','2017-05-31 13:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5278,8,'2017-05-31 13:42:01','2017-05-31 13:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5279,8,'2017-05-31 13:43:01','2017-05-31 13:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5280,8,'2017-05-31 13:44:01','2017-05-31 13:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5281,8,'2017-05-31 13:45:01','2017-05-31 13:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5282,8,'2017-05-31 13:46:01','2017-05-31 13:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5283,8,'2017-05-31 13:47:01','2017-05-31 13:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5284,8,'2017-05-31 13:48:01','2017-05-31 13:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5285,8,'2017-05-31 13:49:01','2017-05-31 13:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5286,8,'2017-05-31 13:50:01','2017-05-31 13:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5287,8,'2017-05-31 13:51:02','2017-05-31 13:51:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5288,8,'2017-05-31 13:52:01','2017-05-31 13:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5289,8,'2017-05-31 13:53:01','2017-05-31 13:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5290,8,'2017-05-31 13:54:01','2017-05-31 13:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5291,8,'2017-05-31 13:55:01','2017-05-31 13:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5292,8,'2017-05-31 13:56:01','2017-05-31 13:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5293,8,'2017-05-31 13:57:01','2017-05-31 13:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5294,8,'2017-05-31 13:58:01','2017-05-31 13:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5295,8,'2017-05-31 13:59:01','2017-05-31 13:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5296,8,'2017-05-31 14:00:01','2017-05-31 14:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5297,8,'2017-05-31 14:01:01','2017-05-31 14:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5298,8,'2017-05-31 14:02:01','2017-05-31 14:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5299,8,'2017-05-31 14:03:01','2017-05-31 14:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5300,8,'2017-05-31 14:04:01','2017-05-31 14:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5301,8,'2017-05-31 14:05:02','2017-05-31 14:05:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5302,8,'2017-05-31 14:06:01','2017-05-31 14:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5303,8,'2017-05-31 14:07:01','2017-05-31 14:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5304,8,'2017-05-31 14:08:01','2017-05-31 14:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5305,8,'2017-05-31 14:09:01','2017-05-31 14:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5306,8,'2017-05-31 14:10:01','2017-05-31 14:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5307,8,'2017-05-31 14:11:02','2017-05-31 14:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5308,8,'2017-05-31 14:12:01','2017-05-31 14:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5309,8,'2017-05-31 14:13:01','2017-05-31 14:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5310,8,'2017-05-31 14:14:01','2017-05-31 14:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5311,8,'2017-05-31 14:15:02','2017-05-31 14:15:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5312,8,'2017-05-31 14:16:01','2017-05-31 14:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5313,8,'2017-05-31 14:17:01','2017-05-31 14:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5314,8,'2017-05-31 14:18:01','2017-05-31 14:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5315,8,'2017-05-31 14:19:01','2017-05-31 14:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5316,8,'2017-05-31 14:20:01','2017-05-31 14:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5317,8,'2017-05-31 14:21:01','2017-05-31 14:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5318,8,'2017-05-31 14:22:01','2017-05-31 14:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5319,8,'2017-05-31 14:23:01','2017-05-31 14:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5320,8,'2017-05-31 14:24:01','2017-05-31 14:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5321,8,'2017-05-31 14:25:01','2017-05-31 14:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5322,8,'2017-05-31 14:26:01','2017-05-31 14:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5323,8,'2017-05-31 14:27:01','2017-05-31 14:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5324,8,'2017-05-31 14:28:02','2017-05-31 14:28:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5325,8,'2017-05-31 14:29:01','2017-05-31 14:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5326,8,'2017-05-31 14:30:01','2017-05-31 14:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5327,8,'2017-05-31 14:31:01','2017-05-31 14:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5328,8,'2017-05-31 14:32:01','2017-05-31 14:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5329,8,'2017-05-31 14:33:01','2017-05-31 14:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5330,8,'2017-05-31 14:34:01','2017-05-31 14:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5331,8,'2017-05-31 14:35:01','2017-05-31 14:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5332,8,'2017-05-31 14:36:01','2017-05-31 14:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5333,8,'2017-05-31 14:37:01','2017-05-31 14:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5334,8,'2017-05-31 14:38:01','2017-05-31 14:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5335,8,'2017-05-31 14:39:01','2017-05-31 14:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5336,8,'2017-05-31 14:40:01','2017-05-31 14:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5337,8,'2017-05-31 14:41:02','2017-05-31 14:41:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5338,8,'2017-05-31 14:42:01','2017-05-31 14:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5339,8,'2017-05-31 14:43:01','2017-05-31 14:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5340,8,'2017-05-31 14:44:01','2017-05-31 14:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5341,8,'2017-05-31 14:45:01','2017-05-31 14:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5342,8,'2017-05-31 14:46:01','2017-05-31 14:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5343,8,'2017-05-31 14:47:01','2017-05-31 14:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5344,8,'2017-05-31 14:48:01','2017-05-31 14:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5345,8,'2017-05-31 14:49:01','2017-05-31 14:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5346,8,'2017-05-31 14:50:01','2017-05-31 14:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5347,8,'2017-05-31 14:51:01','2017-05-31 14:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5348,8,'2017-05-31 14:52:01','2017-05-31 14:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5349,8,'2017-05-31 14:53:01','2017-05-31 14:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5350,8,'2017-05-31 14:54:01','2017-05-31 14:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5351,8,'2017-05-31 14:55:01','2017-05-31 14:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5352,8,'2017-05-31 14:56:01','2017-05-31 14:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5353,8,'2017-05-31 14:57:02','2017-05-31 14:57:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5354,8,'2017-05-31 14:58:01','2017-05-31 14:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5355,8,'2017-05-31 14:59:02','2017-05-31 14:59:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5356,8,'2017-05-31 15:00:01','2017-05-31 15:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5357,8,'2017-05-31 15:01:02','2017-05-31 15:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5358,8,'2017-05-31 15:02:01','2017-05-31 15:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5359,8,'2017-05-31 15:03:01','2017-05-31 15:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5360,8,'2017-05-31 15:04:01','2017-05-31 15:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5361,8,'2017-05-31 15:05:01','2017-05-31 15:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5362,8,'2017-05-31 15:06:02','2017-05-31 15:06:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5363,8,'2017-05-31 15:07:01','2017-05-31 15:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5364,8,'2017-05-31 15:08:01','2017-05-31 15:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5365,8,'2017-05-31 15:09:01','2017-05-31 15:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5366,8,'2017-05-31 15:10:01','2017-05-31 15:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5367,8,'2017-05-31 15:11:01','2017-05-31 15:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5368,8,'2017-05-31 15:12:01','2017-05-31 15:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5369,8,'2017-05-31 15:13:01','2017-05-31 15:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5370,8,'2017-05-31 15:14:01','2017-05-31 15:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5371,8,'2017-05-31 15:15:01','2017-05-31 15:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5372,8,'2017-05-31 15:16:01','2017-05-31 15:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5373,8,'2017-05-31 15:17:01','2017-05-31 15:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5374,8,'2017-05-31 15:18:01','2017-05-31 15:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5375,8,'2017-05-31 15:19:01','2017-05-31 15:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5376,8,'2017-05-31 15:20:01','2017-05-31 15:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5377,8,'2017-05-31 15:21:01','2017-05-31 15:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5378,8,'2017-05-31 15:22:01','2017-05-31 15:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5379,8,'2017-05-31 15:23:01','2017-05-31 15:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5380,8,'2017-05-31 15:24:01','2017-05-31 15:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5381,8,'2017-05-31 15:25:01','2017-05-31 15:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5382,8,'2017-05-31 15:26:02','2017-05-31 15:26:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5383,8,'2017-05-31 15:27:01','2017-05-31 15:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5384,8,'2017-05-31 15:28:01','2017-05-31 15:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5385,8,'2017-05-31 15:29:02','2017-05-31 15:29:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5386,8,'2017-05-31 15:30:01','2017-05-31 15:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5387,8,'2017-05-31 15:31:01','2017-05-31 15:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5388,8,'2017-05-31 15:32:01','2017-05-31 15:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5389,8,'2017-05-31 15:33:01','2017-05-31 15:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5390,8,'2017-05-31 15:34:01','2017-05-31 15:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5391,8,'2017-05-31 15:35:01','2017-05-31 15:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5392,8,'2017-05-31 15:36:01','2017-05-31 15:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5393,8,'2017-05-31 15:37:01','2017-05-31 15:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5394,8,'2017-05-31 15:38:01','2017-05-31 15:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5395,8,'2017-05-31 15:39:01','2017-05-31 15:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5396,8,'2017-05-31 15:40:02','2017-05-31 15:40:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5397,8,'2017-05-31 15:41:01','2017-05-31 15:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5398,8,'2017-05-31 15:42:02','2017-05-31 15:42:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5399,8,'2017-05-31 15:43:01','2017-05-31 15:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5400,8,'2017-05-31 15:44:01','2017-05-31 15:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5401,8,'2017-05-31 15:45:01','2017-05-31 15:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5402,8,'2017-05-31 15:46:01','2017-05-31 15:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5403,8,'2017-05-31 15:47:01','2017-05-31 15:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5404,8,'2017-05-31 15:48:01','2017-05-31 15:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5405,8,'2017-05-31 15:49:01','2017-05-31 15:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5406,8,'2017-05-31 15:50:02','2017-05-31 15:50:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5407,8,'2017-05-31 15:51:01','2017-05-31 15:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5408,8,'2017-05-31 15:52:01','2017-05-31 15:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5409,8,'2017-05-31 15:53:01','2017-05-31 15:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5410,8,'2017-05-31 15:54:01','2017-05-31 15:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5411,8,'2017-05-31 15:55:01','2017-05-31 15:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5412,8,'2017-05-31 15:56:01','2017-05-31 15:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5413,8,'2017-05-31 15:57:01','2017-05-31 15:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5414,8,'2017-05-31 15:58:01','2017-05-31 15:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5415,8,'2017-05-31 15:59:01','2017-05-31 15:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5416,8,'2017-05-31 16:00:01','2017-05-31 16:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5417,8,'2017-05-31 16:01:01','2017-05-31 16:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5418,8,'2017-05-31 16:02:01','2017-05-31 16:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5419,8,'2017-05-31 16:03:01','2017-05-31 16:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5420,8,'2017-05-31 16:04:01','2017-05-31 16:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5421,8,'2017-05-31 16:05:01','2017-05-31 16:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5422,8,'2017-05-31 16:06:01','2017-05-31 16:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5423,8,'2017-05-31 16:07:01','2017-05-31 16:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5424,8,'2017-05-31 16:08:01','2017-05-31 16:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5425,8,'2017-05-31 16:09:01','2017-05-31 16:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5426,8,'2017-05-31 16:10:01','2017-05-31 16:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5427,8,'2017-05-31 16:11:01','2017-05-31 16:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5428,8,'2017-05-31 16:12:01','2017-05-31 16:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5429,8,'2017-05-31 16:13:01','2017-05-31 16:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5430,8,'2017-05-31 16:14:02','2017-05-31 16:14:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5431,8,'2017-05-31 16:15:01','2017-05-31 16:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5432,8,'2017-05-31 16:16:01','2017-05-31 16:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5433,8,'2017-05-31 16:17:01','2017-05-31 16:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5434,8,'2017-05-31 16:18:01','2017-05-31 16:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5435,8,'2017-05-31 16:19:01','2017-05-31 16:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5436,8,'2017-05-31 16:20:01','2017-05-31 16:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5437,8,'2017-05-31 16:21:01','2017-05-31 16:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5438,8,'2017-05-31 16:22:01','2017-05-31 16:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5439,8,'2017-05-31 16:23:01','2017-05-31 16:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5440,8,'2017-05-31 16:24:01','2017-05-31 16:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5441,8,'2017-05-31 16:25:01','2017-05-31 16:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5442,8,'2017-05-31 16:26:01','2017-05-31 16:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5443,8,'2017-05-31 16:27:02','2017-05-31 16:27:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5444,8,'2017-05-31 16:28:01','2017-05-31 16:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5445,8,'2017-05-31 16:29:01','2017-05-31 16:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5446,8,'2017-05-31 16:30:01','2017-05-31 16:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5447,8,'2017-05-31 16:31:01','2017-05-31 16:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5448,8,'2017-05-31 16:32:01','2017-05-31 16:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5449,8,'2017-05-31 16:33:02','2017-05-31 16:33:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5450,8,'2017-05-31 16:34:01','2017-05-31 16:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5451,8,'2017-05-31 16:35:01','2017-05-31 16:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5452,8,'2017-05-31 16:36:01','2017-05-31 16:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5453,8,'2017-05-31 16:37:01','2017-05-31 16:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5454,8,'2017-05-31 16:38:01','2017-05-31 16:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5455,8,'2017-05-31 16:39:01','2017-05-31 16:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5456,8,'2017-05-31 16:40:02','2017-05-31 16:40:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5457,8,'2017-05-31 16:41:01','2017-05-31 16:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5458,8,'2017-05-31 16:42:01','2017-05-31 16:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5459,8,'2017-05-31 16:43:01','2017-05-31 16:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5460,8,'2017-05-31 16:44:01','2017-05-31 16:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5461,8,'2017-05-31 16:45:01','2017-05-31 16:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5462,8,'2017-05-31 16:46:01','2017-05-31 16:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5463,8,'2017-05-31 16:47:01','2017-05-31 16:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5464,8,'2017-05-31 16:48:01','2017-05-31 16:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5465,8,'2017-05-31 16:49:01','2017-05-31 16:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5466,8,'2017-05-31 16:50:01','2017-05-31 16:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5467,8,'2017-05-31 16:51:01','2017-05-31 16:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5468,8,'2017-05-31 16:52:01','2017-05-31 16:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5469,8,'2017-05-31 16:53:01','2017-05-31 16:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5470,8,'2017-05-31 16:54:01','2017-05-31 16:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5471,8,'2017-05-31 16:55:02','2017-05-31 16:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5472,8,'2017-05-31 16:56:01','2017-05-31 16:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5473,8,'2017-05-31 16:57:01','2017-05-31 16:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5474,8,'2017-05-31 16:58:01','2017-05-31 16:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5475,8,'2017-05-31 16:59:01','2017-05-31 16:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5476,8,'2017-05-31 17:00:01','2017-05-31 17:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5477,8,'2017-05-31 17:01:01','2017-05-31 17:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5478,8,'2017-05-31 17:02:01','2017-05-31 17:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5479,8,'2017-05-31 17:03:01','2017-05-31 17:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5480,8,'2017-05-31 17:04:01','2017-05-31 17:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5481,8,'2017-05-31 17:05:01','2017-05-31 17:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5482,8,'2017-05-31 17:06:01','2017-05-31 17:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5483,8,'2017-05-31 17:07:01','2017-05-31 17:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5484,8,'2017-05-31 17:08:01','2017-05-31 17:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5485,8,'2017-05-31 17:09:01','2017-05-31 17:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5486,8,'2017-05-31 17:10:01','2017-05-31 17:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5487,8,'2017-05-31 17:11:02','2017-05-31 17:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5488,8,'2017-05-31 17:12:01','2017-05-31 17:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5489,8,'2017-05-31 17:13:01','2017-05-31 17:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5490,8,'2017-05-31 17:14:01','2017-05-31 17:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5491,8,'2017-05-31 17:15:01','2017-05-31 17:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5492,8,'2017-05-31 17:16:01','2017-05-31 17:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5493,8,'2017-05-31 17:17:01','2017-05-31 17:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5494,8,'2017-05-31 17:18:01','2017-05-31 17:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5495,8,'2017-05-31 17:19:01','2017-05-31 17:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5496,8,'2017-05-31 17:20:01','2017-05-31 17:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5497,8,'2017-05-31 17:21:01','2017-05-31 17:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5498,8,'2017-05-31 17:22:01','2017-05-31 17:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5499,8,'2017-05-31 17:23:02','2017-05-31 17:23:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5500,8,'2017-05-31 17:24:01','2017-05-31 17:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5501,8,'2017-05-31 17:25:01','2017-05-31 17:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5502,8,'2017-05-31 17:26:01','2017-05-31 17:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5503,8,'2017-05-31 17:27:01','2017-05-31 17:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5504,8,'2017-05-31 17:28:01','2017-05-31 17:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5505,8,'2017-05-31 17:29:01','2017-05-31 17:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5506,8,'2017-05-31 17:30:01','2017-05-31 17:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5507,8,'2017-05-31 17:31:01','2017-05-31 17:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5508,8,'2017-05-31 17:32:02','2017-05-31 17:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5509,8,'2017-05-31 17:33:01','2017-05-31 17:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5510,8,'2017-05-31 17:34:01','2017-05-31 17:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5511,8,'2017-05-31 17:35:01','2017-05-31 17:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5512,8,'2017-05-31 17:36:01','2017-05-31 17:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5513,8,'2017-05-31 17:37:01','2017-05-31 17:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5514,8,'2017-05-31 17:38:01','2017-05-31 17:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5515,8,'2017-05-31 17:39:01','2017-05-31 17:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5516,8,'2017-05-31 17:40:01','2017-05-31 17:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5517,8,'2017-05-31 17:41:02','2017-05-31 17:41:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5518,8,'2017-05-31 17:42:01','2017-05-31 17:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5519,8,'2017-05-31 17:43:01','2017-05-31 17:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5520,8,'2017-05-31 17:44:01','2017-05-31 17:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5521,8,'2017-05-31 17:45:01','2017-05-31 17:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5522,8,'2017-05-31 17:46:01','2017-05-31 17:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5523,8,'2017-05-31 17:47:01','2017-05-31 17:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5524,8,'2017-05-31 17:48:01','2017-05-31 17:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5525,8,'2017-05-31 17:49:01','2017-05-31 17:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5526,8,'2017-05-31 17:50:01','2017-05-31 17:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5527,8,'2017-05-31 17:51:01','2017-05-31 17:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5528,8,'2017-05-31 17:52:01','2017-05-31 17:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5529,8,'2017-05-31 17:53:01','2017-05-31 17:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5530,8,'2017-05-31 17:54:01','2017-05-31 17:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5531,8,'2017-05-31 17:55:01','2017-05-31 17:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5532,8,'2017-05-31 17:56:01','2017-05-31 17:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5533,8,'2017-05-31 17:57:01','2017-05-31 17:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5534,8,'2017-05-31 17:58:01','2017-05-31 17:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5535,8,'2017-05-31 17:59:01','2017-05-31 17:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5536,8,'2017-05-31 18:00:01','2017-05-31 18:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5537,8,'2017-05-31 18:01:01','2017-05-31 18:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5538,8,'2017-05-31 18:02:01','2017-05-31 18:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5539,8,'2017-05-31 18:03:01','2017-05-31 18:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5540,8,'2017-05-31 18:04:01','2017-05-31 18:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5541,8,'2017-05-31 18:05:01','2017-05-31 18:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5542,8,'2017-05-31 18:06:01','2017-05-31 18:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5543,8,'2017-05-31 18:07:01','2017-05-31 18:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5544,8,'2017-05-31 18:08:01','2017-05-31 18:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5545,8,'2017-05-31 18:09:01','2017-05-31 18:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5546,8,'2017-05-31 18:10:01','2017-05-31 18:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5547,8,'2017-05-31 18:11:01','2017-05-31 18:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5548,8,'2017-05-31 18:12:01','2017-05-31 18:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5549,8,'2017-05-31 18:13:01','2017-05-31 18:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5550,8,'2017-05-31 18:14:01','2017-05-31 18:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5551,8,'2017-05-31 18:15:01','2017-05-31 18:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5552,8,'2017-05-31 18:16:01','2017-05-31 18:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5553,8,'2017-05-31 18:17:01','2017-05-31 18:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5554,8,'2017-05-31 18:18:01','2017-05-31 18:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5555,8,'2017-05-31 18:19:02','2017-05-31 18:19:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5556,8,'2017-05-31 18:20:01','2017-05-31 18:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5557,8,'2017-05-31 18:21:01','2017-05-31 18:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5558,8,'2017-05-31 18:22:01','2017-05-31 18:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5559,8,'2017-05-31 18:23:01','2017-05-31 18:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5560,8,'2017-05-31 18:24:01','2017-05-31 18:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5561,8,'2017-05-31 18:25:01','2017-05-31 18:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5562,8,'2017-05-31 18:26:01','2017-05-31 18:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5563,8,'2017-05-31 18:27:01','2017-05-31 18:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5564,8,'2017-05-31 18:28:01','2017-05-31 18:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5565,8,'2017-05-31 18:29:01','2017-05-31 18:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5566,8,'2017-05-31 18:30:02','2017-05-31 18:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5567,8,'2017-05-31 18:31:01','2017-05-31 18:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5568,8,'2017-05-31 18:32:01','2017-05-31 18:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5569,8,'2017-05-31 18:33:01','2017-05-31 18:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5570,8,'2017-05-31 18:34:01','2017-05-31 18:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5571,8,'2017-05-31 18:35:01','2017-05-31 18:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5572,8,'2017-05-31 18:36:01','2017-05-31 18:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5573,8,'2017-05-31 18:37:01','2017-05-31 18:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5574,8,'2017-05-31 18:38:01','2017-05-31 18:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5575,8,'2017-05-31 18:39:01','2017-05-31 18:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5576,8,'2017-05-31 18:40:01','2017-05-31 18:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5577,8,'2017-05-31 18:41:01','2017-05-31 18:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5578,8,'2017-05-31 18:42:01','2017-05-31 18:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5579,8,'2017-05-31 18:43:01','2017-05-31 18:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5580,8,'2017-05-31 18:44:01','2017-05-31 18:44:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5581,8,'2017-05-31 18:45:01','2017-05-31 18:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5582,8,'2017-05-31 18:46:01','2017-05-31 18:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5583,8,'2017-05-31 18:47:01','2017-05-31 18:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5584,8,'2017-05-31 18:48:01','2017-05-31 18:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5585,8,'2017-05-31 18:49:01','2017-05-31 18:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5586,8,'2017-05-31 18:50:01','2017-05-31 18:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5587,8,'2017-05-31 18:51:01','2017-05-31 18:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5588,8,'2017-05-31 18:52:01','2017-05-31 18:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5589,8,'2017-05-31 18:53:01','2017-05-31 18:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5590,8,'2017-05-31 18:54:01','2017-05-31 18:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5591,8,'2017-05-31 18:55:01','2017-05-31 18:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5592,8,'2017-05-31 18:56:01','2017-05-31 18:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5593,8,'2017-05-31 18:57:01','2017-05-31 18:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5594,8,'2017-05-31 18:58:01','2017-05-31 18:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5595,8,'2017-05-31 18:59:01','2017-05-31 18:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5596,8,'2017-05-31 19:00:01','2017-05-31 19:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5597,8,'2017-05-31 19:01:01','2017-05-31 19:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5598,8,'2017-05-31 19:02:01','2017-05-31 19:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5599,8,'2017-05-31 19:03:01','2017-05-31 19:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5600,8,'2017-05-31 19:04:01','2017-05-31 19:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5601,8,'2017-05-31 19:05:01','2017-05-31 19:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5602,8,'2017-05-31 19:06:01','2017-05-31 19:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5603,8,'2017-05-31 19:07:01','2017-05-31 19:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5604,8,'2017-05-31 19:08:01','2017-05-31 19:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5605,8,'2017-05-31 19:09:01','2017-05-31 19:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5606,8,'2017-05-31 19:10:01','2017-05-31 19:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5607,8,'2017-05-31 19:11:01','2017-05-31 19:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5608,8,'2017-05-31 19:12:01','2017-05-31 19:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5609,8,'2017-05-31 19:13:01','2017-05-31 19:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5610,8,'2017-05-31 19:14:01','2017-05-31 19:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5611,8,'2017-05-31 19:15:01','2017-05-31 19:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5612,8,'2017-05-31 19:16:01','2017-05-31 19:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5613,8,'2017-05-31 19:17:01','2017-05-31 19:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5614,8,'2017-05-31 19:18:01','2017-05-31 19:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5615,8,'2017-05-31 19:19:01','2017-05-31 19:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5616,8,'2017-05-31 19:20:01','2017-05-31 19:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5617,8,'2017-05-31 19:21:01','2017-05-31 19:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5618,8,'2017-05-31 19:22:01','2017-05-31 19:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5619,8,'2017-05-31 19:23:01','2017-05-31 19:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5620,8,'2017-05-31 19:24:01','2017-05-31 19:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5621,8,'2017-05-31 19:25:01','2017-05-31 19:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5622,8,'2017-05-31 19:26:01','2017-05-31 19:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5623,8,'2017-05-31 19:27:01','2017-05-31 19:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5624,8,'2017-05-31 19:28:01','2017-05-31 19:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5625,8,'2017-05-31 19:29:01','2017-05-31 19:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5626,8,'2017-05-31 19:30:01','2017-05-31 19:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5627,8,'2017-05-31 19:31:01','2017-05-31 19:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5628,8,'2017-05-31 19:32:01','2017-05-31 19:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5629,8,'2017-05-31 19:33:01','2017-05-31 19:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5630,8,'2017-05-31 19:34:01','2017-05-31 19:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5631,8,'2017-05-31 19:35:01','2017-05-31 19:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5632,8,'2017-05-31 19:36:01','2017-05-31 19:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5633,8,'2017-05-31 19:37:02','2017-05-31 19:37:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5634,8,'2017-05-31 19:38:01','2017-05-31 19:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5635,8,'2017-05-31 19:39:01','2017-05-31 19:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5636,8,'2017-05-31 19:40:01','2017-05-31 19:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5637,8,'2017-05-31 19:41:01','2017-05-31 19:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5638,8,'2017-05-31 19:42:01','2017-05-31 19:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5639,8,'2017-05-31 19:43:02','2017-05-31 19:43:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5640,8,'2017-05-31 19:44:01','2017-05-31 19:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5641,8,'2017-05-31 19:45:01','2017-05-31 19:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5642,8,'2017-05-31 19:46:01','2017-05-31 19:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5643,8,'2017-05-31 19:47:01','2017-05-31 19:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5644,8,'2017-05-31 19:48:01','2017-05-31 19:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5645,8,'2017-05-31 19:49:01','2017-05-31 19:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5646,8,'2017-05-31 19:50:01','2017-05-31 19:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5647,8,'2017-05-31 19:51:01','2017-05-31 19:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5648,8,'2017-05-31 19:52:01','2017-05-31 19:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5649,8,'2017-05-31 19:53:01','2017-05-31 19:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5650,8,'2017-05-31 19:54:01','2017-05-31 19:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5651,8,'2017-05-31 19:55:01','2017-05-31 19:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5652,8,'2017-05-31 19:56:01','2017-05-31 19:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5653,8,'2017-05-31 19:57:01','2017-05-31 19:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5654,8,'2017-05-31 19:58:01','2017-05-31 19:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5655,8,'2017-05-31 19:59:01','2017-05-31 19:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5656,8,'2017-05-31 20:00:01','2017-05-31 20:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5657,8,'2017-05-31 20:01:01','2017-05-31 20:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5658,8,'2017-05-31 20:02:01','2017-05-31 20:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5659,8,'2017-05-31 20:03:01','2017-05-31 20:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5660,8,'2017-05-31 20:04:01','2017-05-31 20:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5661,8,'2017-05-31 20:05:01','2017-05-31 20:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5662,8,'2017-05-31 20:06:01','2017-05-31 20:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5663,8,'2017-05-31 20:07:01','2017-05-31 20:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5664,8,'2017-05-31 20:08:01','2017-05-31 20:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5665,8,'2017-05-31 20:09:01','2017-05-31 20:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5666,8,'2017-05-31 20:10:02','2017-05-31 20:10:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5667,8,'2017-05-31 20:11:01','2017-05-31 20:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5668,8,'2017-05-31 20:12:01','2017-05-31 20:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5669,8,'2017-05-31 20:13:01','2017-05-31 20:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5670,8,'2017-05-31 20:14:01','2017-05-31 20:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5671,8,'2017-05-31 20:15:01','2017-05-31 20:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5672,8,'2017-05-31 20:16:01','2017-05-31 20:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5673,8,'2017-05-31 20:17:01','2017-05-31 20:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5674,8,'2017-05-31 20:18:01','2017-05-31 20:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5675,8,'2017-05-31 20:19:01','2017-05-31 20:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5676,8,'2017-05-31 20:20:02','2017-05-31 20:20:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5677,8,'2017-05-31 20:21:01','2017-05-31 20:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5678,8,'2017-05-31 20:22:02','2017-05-31 20:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5679,8,'2017-05-31 20:23:02','2017-05-31 20:23:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5680,8,'2017-05-31 20:24:01','2017-05-31 20:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5681,8,'2017-05-31 20:25:01','2017-05-31 20:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5682,8,'2017-05-31 20:26:01','2017-05-31 20:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5683,8,'2017-05-31 20:27:02','2017-05-31 20:27:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5684,8,'2017-05-31 20:28:01','2017-05-31 20:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5685,8,'2017-05-31 20:29:01','2017-05-31 20:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5686,8,'2017-05-31 20:30:01','2017-05-31 20:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5687,8,'2017-05-31 20:31:01','2017-05-31 20:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5688,8,'2017-05-31 20:32:01','2017-05-31 20:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5689,8,'2017-05-31 20:33:01','2017-05-31 20:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5690,8,'2017-05-31 20:34:01','2017-05-31 20:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5691,8,'2017-05-31 20:35:01','2017-05-31 20:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5692,8,'2017-05-31 20:36:01','2017-05-31 20:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5693,8,'2017-05-31 20:37:01','2017-05-31 20:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5694,8,'2017-05-31 20:38:01','2017-05-31 20:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5695,8,'2017-05-31 20:39:01','2017-05-31 20:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5696,8,'2017-05-31 20:40:02','2017-05-31 20:40:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5697,8,'2017-05-31 20:41:01','2017-05-31 20:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5698,8,'2017-05-31 20:42:01','2017-05-31 20:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5699,8,'2017-05-31 20:43:01','2017-05-31 20:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5700,8,'2017-05-31 20:44:01','2017-05-31 20:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5701,8,'2017-05-31 20:45:02','2017-05-31 20:45:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5702,8,'2017-05-31 20:46:01','2017-05-31 20:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5703,8,'2017-05-31 20:47:01','2017-05-31 20:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5704,8,'2017-05-31 20:48:01','2017-05-31 20:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5705,8,'2017-05-31 20:49:01','2017-05-31 20:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5706,8,'2017-05-31 20:50:01','2017-05-31 20:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5707,8,'2017-05-31 20:51:01','2017-05-31 20:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5708,8,'2017-05-31 20:52:01','2017-05-31 20:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5709,8,'2017-05-31 20:53:01','2017-05-31 20:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5710,8,'2017-05-31 20:54:01','2017-05-31 20:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5711,8,'2017-05-31 20:55:01','2017-05-31 20:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5712,8,'2017-05-31 20:56:01','2017-05-31 20:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5713,8,'2017-05-31 20:57:01','2017-05-31 20:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5714,8,'2017-05-31 20:58:01','2017-05-31 20:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5715,8,'2017-05-31 20:59:01','2017-05-31 20:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5716,8,'2017-05-31 21:00:01','2017-05-31 21:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5717,8,'2017-05-31 21:01:01','2017-05-31 21:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5718,8,'2017-05-31 21:02:01','2017-05-31 21:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5719,8,'2017-05-31 21:03:01','2017-05-31 21:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5720,8,'2017-05-31 21:04:02','2017-05-31 21:04:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5721,8,'2017-05-31 21:05:02','2017-05-31 21:05:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5722,8,'2017-05-31 21:06:01','2017-05-31 21:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5723,8,'2017-05-31 21:07:01','2017-05-31 21:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5724,8,'2017-05-31 21:08:01','2017-05-31 21:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5725,8,'2017-05-31 21:09:01','2017-05-31 21:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5726,8,'2017-05-31 21:10:01','2017-05-31 21:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5727,8,'2017-05-31 21:11:01','2017-05-31 21:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5728,8,'2017-05-31 21:12:01','2017-05-31 21:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5729,8,'2017-05-31 21:13:01','2017-05-31 21:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5730,8,'2017-05-31 21:14:01','2017-05-31 21:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5731,8,'2017-05-31 21:15:02','2017-05-31 21:15:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5732,8,'2017-05-31 21:16:01','2017-05-31 21:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5733,8,'2017-05-31 21:17:01','2017-05-31 21:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5734,8,'2017-05-31 21:18:02','2017-05-31 21:18:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5735,8,'2017-05-31 21:19:01','2017-05-31 21:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5736,8,'2017-05-31 21:20:01','2017-05-31 21:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5737,8,'2017-05-31 21:21:01','2017-05-31 21:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5738,8,'2017-05-31 21:22:01','2017-05-31 21:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5739,8,'2017-05-31 21:23:01','2017-05-31 21:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5740,8,'2017-05-31 21:24:01','2017-05-31 21:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5741,8,'2017-05-31 21:25:01','2017-05-31 21:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5742,8,'2017-05-31 21:26:01','2017-05-31 21:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5743,8,'2017-05-31 21:27:01','2017-05-31 21:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5744,8,'2017-05-31 21:28:01','2017-05-31 21:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5745,8,'2017-05-31 21:29:01','2017-05-31 21:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5746,8,'2017-05-31 21:30:01','2017-05-31 21:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5747,8,'2017-05-31 21:31:01','2017-05-31 21:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5748,8,'2017-05-31 21:32:01','2017-05-31 21:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5749,8,'2017-05-31 21:33:01','2017-05-31 21:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5750,8,'2017-05-31 21:34:01','2017-05-31 21:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5751,8,'2017-05-31 21:35:01','2017-05-31 21:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5752,8,'2017-05-31 21:36:01','2017-05-31 21:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5753,8,'2017-05-31 21:37:01','2017-05-31 21:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5754,8,'2017-05-31 21:38:01','2017-05-31 21:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5755,8,'2017-05-31 21:39:01','2017-05-31 21:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5756,8,'2017-05-31 21:40:01','2017-05-31 21:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5757,8,'2017-05-31 21:41:01','2017-05-31 21:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5758,8,'2017-05-31 21:42:01','2017-05-31 21:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5759,8,'2017-05-31 21:43:01','2017-05-31 21:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5760,8,'2017-05-31 21:44:01','2017-05-31 21:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5761,8,'2017-05-31 21:45:01','2017-05-31 21:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5762,8,'2017-05-31 21:46:01','2017-05-31 21:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5763,8,'2017-05-31 21:47:01','2017-05-31 21:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5764,8,'2017-05-31 21:48:02','2017-05-31 21:48:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5765,8,'2017-05-31 21:49:02','2017-05-31 21:49:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5766,8,'2017-05-31 21:50:01','2017-05-31 21:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5767,8,'2017-05-31 21:51:01','2017-05-31 21:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5768,8,'2017-05-31 21:52:01','2017-05-31 21:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5769,8,'2017-05-31 21:53:01','2017-05-31 21:53:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5770,8,'2017-05-31 21:54:01','2017-05-31 21:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5771,8,'2017-05-31 21:55:01','2017-05-31 21:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5772,8,'2017-05-31 21:56:01','2017-05-31 21:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5773,8,'2017-05-31 21:57:01','2017-05-31 21:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5774,8,'2017-05-31 21:58:01','2017-05-31 21:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5775,8,'2017-05-31 21:59:01','2017-05-31 21:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5776,8,'2017-05-31 22:00:01','2017-05-31 22:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5777,8,'2017-05-31 22:01:01','2017-05-31 22:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5778,8,'2017-05-31 22:02:01','2017-05-31 22:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5779,8,'2017-05-31 22:03:01','2017-05-31 22:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5780,8,'2017-05-31 22:04:01','2017-05-31 22:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5781,8,'2017-05-31 22:05:01','2017-05-31 22:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5782,8,'2017-05-31 22:06:01','2017-05-31 22:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5783,8,'2017-05-31 22:07:01','2017-05-31 22:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5784,8,'2017-05-31 22:08:01','2017-05-31 22:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5785,8,'2017-05-31 22:09:01','2017-05-31 22:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5786,8,'2017-05-31 22:10:01','2017-05-31 22:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5787,8,'2017-05-31 22:11:01','2017-05-31 22:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5788,8,'2017-05-31 22:12:01','2017-05-31 22:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5789,8,'2017-05-31 22:13:01','2017-05-31 22:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5790,8,'2017-05-31 22:14:01','2017-05-31 22:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5791,8,'2017-05-31 22:15:01','2017-05-31 22:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5792,8,'2017-05-31 22:16:01','2017-05-31 22:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5793,8,'2017-05-31 22:17:01','2017-05-31 22:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5794,8,'2017-05-31 22:18:01','2017-05-31 22:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5795,8,'2017-05-31 22:19:01','2017-05-31 22:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5796,8,'2017-05-31 22:20:01','2017-05-31 22:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5797,8,'2017-05-31 22:21:01','2017-05-31 22:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5798,8,'2017-05-31 22:22:01','2017-05-31 22:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5799,8,'2017-05-31 22:23:01','2017-05-31 22:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5800,8,'2017-05-31 22:24:01','2017-05-31 22:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5801,8,'2017-05-31 22:25:01','2017-05-31 22:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5802,8,'2017-05-31 22:26:01','2017-05-31 22:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5803,8,'2017-05-31 22:27:01','2017-05-31 22:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5804,8,'2017-05-31 22:28:01','2017-05-31 22:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5805,8,'2017-05-31 22:29:01','2017-05-31 22:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5806,8,'2017-05-31 22:30:01','2017-05-31 22:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5807,8,'2017-05-31 22:31:01','2017-05-31 22:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5808,8,'2017-05-31 22:32:01','2017-05-31 22:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5809,8,'2017-05-31 22:33:01','2017-05-31 22:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5810,8,'2017-05-31 22:34:01','2017-05-31 22:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5811,8,'2017-05-31 22:35:01','2017-05-31 22:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5812,8,'2017-05-31 22:36:01','2017-05-31 22:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5813,8,'2017-05-31 22:37:01','2017-05-31 22:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5814,8,'2017-05-31 22:38:01','2017-05-31 22:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5815,8,'2017-05-31 22:39:01','2017-05-31 22:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5816,8,'2017-05-31 22:40:01','2017-05-31 22:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5817,8,'2017-05-31 22:41:01','2017-05-31 22:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5818,8,'2017-05-31 22:42:01','2017-05-31 22:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5819,8,'2017-05-31 22:43:01','2017-05-31 22:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5820,8,'2017-05-31 22:44:01','2017-05-31 22:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5821,8,'2017-05-31 22:45:01','2017-05-31 22:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5822,8,'2017-05-31 22:46:01','2017-05-31 22:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5823,8,'2017-05-31 22:47:01','2017-05-31 22:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5824,8,'2017-05-31 22:48:01','2017-05-31 22:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5825,8,'2017-05-31 22:49:01','2017-05-31 22:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5826,8,'2017-05-31 22:50:01','2017-05-31 22:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5827,8,'2017-05-31 22:51:01','2017-05-31 22:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5828,8,'2017-05-31 22:52:01','2017-05-31 22:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5829,8,'2017-05-31 22:53:01','2017-05-31 22:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5830,8,'2017-05-31 22:54:01','2017-05-31 22:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5831,8,'2017-05-31 22:55:01','2017-05-31 22:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5832,8,'2017-05-31 22:56:01','2017-05-31 22:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5833,8,'2017-05-31 22:57:01','2017-05-31 22:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5834,8,'2017-05-31 22:58:02','2017-05-31 22:58:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5835,8,'2017-05-31 22:59:01','2017-05-31 22:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5836,8,'2017-05-31 23:00:01','2017-05-31 23:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5837,8,'2017-05-31 23:01:01','2017-05-31 23:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5838,8,'2017-05-31 23:02:01','2017-05-31 23:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5839,8,'2017-05-31 23:03:01','2017-05-31 23:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5840,8,'2017-05-31 23:04:02','2017-05-31 23:04:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5841,8,'2017-05-31 23:05:01','2017-05-31 23:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5842,8,'2017-05-31 23:06:01','2017-05-31 23:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5843,8,'2017-05-31 23:07:01','2017-05-31 23:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5844,8,'2017-05-31 23:08:02','2017-05-31 23:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5845,8,'2017-05-31 23:09:01','2017-05-31 23:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5846,8,'2017-05-31 23:10:01','2017-05-31 23:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5847,8,'2017-05-31 23:11:01','2017-05-31 23:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5848,8,'2017-05-31 23:12:01','2017-05-31 23:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5849,8,'2017-05-31 23:13:01','2017-05-31 23:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5850,8,'2017-05-31 23:14:01','2017-05-31 23:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5851,8,'2017-05-31 23:15:02','2017-05-31 23:15:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5852,8,'2017-05-31 23:16:01','2017-05-31 23:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5853,8,'2017-05-31 23:17:01','2017-05-31 23:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5854,8,'2017-05-31 23:18:01','2017-05-31 23:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5855,8,'2017-05-31 23:19:01','2017-05-31 23:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5856,8,'2017-05-31 23:20:01','2017-05-31 23:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5857,8,'2017-05-31 23:21:01','2017-05-31 23:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5858,8,'2017-05-31 23:22:02','2017-05-31 23:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5859,8,'2017-05-31 23:23:01','2017-05-31 23:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5860,8,'2017-05-31 23:24:01','2017-05-31 23:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5861,8,'2017-05-31 23:25:01','2017-05-31 23:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5862,8,'2017-05-31 23:26:01','2017-05-31 23:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5863,8,'2017-05-31 23:27:01','2017-05-31 23:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5864,8,'2017-05-31 23:28:01','2017-05-31 23:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5865,8,'2017-05-31 23:29:01','2017-05-31 23:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5866,8,'2017-05-31 23:30:01','2017-05-31 23:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5867,8,'2017-05-31 23:31:02','2017-05-31 23:31:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5868,8,'2017-05-31 23:32:01','2017-05-31 23:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5869,8,'2017-05-31 23:33:01','2017-05-31 23:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5870,8,'2017-05-31 23:34:01','2017-05-31 23:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5871,8,'2017-05-31 23:35:01','2017-05-31 23:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5872,8,'2017-05-31 23:36:01','2017-05-31 23:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5873,8,'2017-05-31 23:37:01','2017-05-31 23:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5874,8,'2017-05-31 23:38:01','2017-05-31 23:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5875,8,'2017-05-31 23:39:01','2017-05-31 23:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5876,8,'2017-05-31 23:40:01','2017-05-31 23:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5877,8,'2017-05-31 23:41:01','2017-05-31 23:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5878,8,'2017-05-31 23:42:01','2017-05-31 23:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5879,8,'2017-05-31 23:43:01','2017-05-31 23:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5880,8,'2017-05-31 23:44:01','2017-05-31 23:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5881,8,'2017-05-31 23:45:01','2017-05-31 23:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5882,8,'2017-05-31 23:46:01','2017-05-31 23:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5883,8,'2017-05-31 23:47:01','2017-05-31 23:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5884,8,'2017-05-31 23:48:01','2017-05-31 23:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5885,8,'2017-05-31 23:49:01','2017-05-31 23:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5886,8,'2017-05-31 23:50:01','2017-05-31 23:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5887,8,'2017-05-31 23:51:01','2017-05-31 23:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5888,8,'2017-05-31 23:52:01','2017-05-31 23:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5889,8,'2017-05-31 23:53:01','2017-05-31 23:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5890,8,'2017-05-31 23:54:01','2017-05-31 23:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5891,8,'2017-05-31 23:55:01','2017-05-31 23:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5892,8,'2017-05-31 23:56:02','2017-05-31 23:56:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5893,8,'2017-05-31 23:57:01','2017-05-31 23:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5894,8,'2017-05-31 23:58:01','2017-05-31 23:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5895,8,'2017-05-31 23:59:01','2017-05-31 23:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5896,8,'2017-06-01 00:00:01','2017-06-01 00:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5897,8,'2017-06-01 00:01:01','2017-06-01 00:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5898,8,'2017-06-01 00:02:01','2017-06-01 00:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5899,8,'2017-06-01 00:03:01','2017-06-01 00:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5900,8,'2017-06-01 00:04:01','2017-06-01 00:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5901,8,'2017-06-01 00:05:02','2017-06-01 00:05:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5902,8,'2017-06-01 00:06:01','2017-06-01 00:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5903,8,'2017-06-01 00:07:01','2017-06-01 00:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5904,8,'2017-06-01 00:08:02','2017-06-01 00:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5905,8,'2017-06-01 00:09:01','2017-06-01 00:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5906,8,'2017-06-01 00:10:01','2017-06-01 00:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5907,8,'2017-06-01 00:11:01','2017-06-01 00:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5908,8,'2017-06-01 00:12:01','2017-06-01 00:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5909,8,'2017-06-01 00:13:01','2017-06-01 00:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5910,8,'2017-06-01 00:14:01','2017-06-01 00:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5911,8,'2017-06-01 00:15:01','2017-06-01 00:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5912,8,'2017-06-01 00:16:01','2017-06-01 00:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5913,8,'2017-06-01 00:17:01','2017-06-01 00:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5914,8,'2017-06-01 00:18:01','2017-06-01 00:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5915,8,'2017-06-01 00:19:01','2017-06-01 00:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5916,8,'2017-06-01 00:20:01','2017-06-01 00:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5917,8,'2017-06-01 00:21:01','2017-06-01 00:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5918,8,'2017-06-01 00:22:01','2017-06-01 00:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5919,8,'2017-06-01 00:23:01','2017-06-01 00:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5920,8,'2017-06-01 00:24:01','2017-06-01 00:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5921,8,'2017-06-01 00:25:01','2017-06-01 00:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5922,8,'2017-06-01 00:26:01','2017-06-01 00:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5923,8,'2017-06-01 00:27:01','2017-06-01 00:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5924,8,'2017-06-01 00:28:01','2017-06-01 00:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5925,8,'2017-06-01 00:29:01','2017-06-01 00:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5926,8,'2017-06-01 00:30:01','2017-06-01 00:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5927,8,'2017-06-01 00:31:01','2017-06-01 00:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5928,8,'2017-06-01 00:32:02','2017-06-01 00:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5929,8,'2017-06-01 00:33:01','2017-06-01 00:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5930,8,'2017-06-01 00:34:01','2017-06-01 00:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5931,8,'2017-06-01 00:35:02','2017-06-01 00:35:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5932,8,'2017-06-01 00:36:01','2017-06-01 00:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5933,8,'2017-06-01 00:37:01','2017-06-01 00:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5934,8,'2017-06-01 00:38:01','2017-06-01 00:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5935,8,'2017-06-01 00:39:01','2017-06-01 00:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5936,8,'2017-06-01 00:40:01','2017-06-01 00:40:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5937,8,'2017-06-01 00:41:01','2017-06-01 00:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5938,8,'2017-06-01 00:42:01','2017-06-01 00:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5939,8,'2017-06-01 00:43:01','2017-06-01 00:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5940,8,'2017-06-01 00:44:01','2017-06-01 00:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5941,8,'2017-06-01 00:45:01','2017-06-01 00:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5942,8,'2017-06-01 00:46:01','2017-06-01 00:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5943,8,'2017-06-01 00:47:01','2017-06-01 00:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5944,8,'2017-06-01 00:48:01','2017-06-01 00:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5945,8,'2017-06-01 00:49:01','2017-06-01 00:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5946,8,'2017-06-01 00:50:01','2017-06-01 00:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5947,8,'2017-06-01 00:51:01','2017-06-01 00:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5948,8,'2017-06-01 00:52:01','2017-06-01 00:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5949,8,'2017-06-01 00:53:01','2017-06-01 00:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5950,8,'2017-06-01 00:54:01','2017-06-01 00:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5951,8,'2017-06-01 00:55:01','2017-06-01 00:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5952,8,'2017-06-01 00:56:01','2017-06-01 00:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5953,8,'2017-06-01 00:57:01','2017-06-01 00:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5954,8,'2017-06-01 00:58:01','2017-06-01 00:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5955,8,'2017-06-01 00:59:01','2017-06-01 00:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5956,8,'2017-06-01 01:00:01','2017-06-01 01:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5957,8,'2017-06-01 01:01:02','2017-06-01 01:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5958,8,'2017-06-01 01:02:02','2017-06-01 01:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5959,8,'2017-06-01 01:03:01','2017-06-01 01:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5960,8,'2017-06-01 01:04:01','2017-06-01 01:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5961,8,'2017-06-01 01:05:01','2017-06-01 01:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5962,8,'2017-06-01 01:06:01','2017-06-01 01:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5963,8,'2017-06-01 01:07:01','2017-06-01 01:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5964,8,'2017-06-01 01:08:01','2017-06-01 01:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5965,8,'2017-06-01 01:09:01','2017-06-01 01:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5966,8,'2017-06-01 01:10:01','2017-06-01 01:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5967,8,'2017-06-01 01:11:01','2017-06-01 01:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5968,8,'2017-06-01 01:12:02','2017-06-01 01:12:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5969,8,'2017-06-01 01:13:01','2017-06-01 01:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5970,8,'2017-06-01 01:14:01','2017-06-01 01:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5971,8,'2017-06-01 01:15:01','2017-06-01 01:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5972,8,'2017-06-01 01:16:01','2017-06-01 01:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5973,8,'2017-06-01 01:17:01','2017-06-01 01:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5974,8,'2017-06-01 01:18:01','2017-06-01 01:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5975,8,'2017-06-01 01:19:01','2017-06-01 01:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5976,8,'2017-06-01 01:20:01','2017-06-01 01:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5977,8,'2017-06-01 01:21:01','2017-06-01 01:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5978,8,'2017-06-01 01:22:01','2017-06-01 01:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5979,8,'2017-06-01 01:23:01','2017-06-01 01:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5980,8,'2017-06-01 01:24:01','2017-06-01 01:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5981,8,'2017-06-01 01:25:02','2017-06-01 01:25:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5982,8,'2017-06-01 01:26:01','2017-06-01 01:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5983,8,'2017-06-01 01:27:01','2017-06-01 01:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5984,8,'2017-06-01 01:28:01','2017-06-01 01:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5985,8,'2017-06-01 01:29:01','2017-06-01 01:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5986,8,'2017-06-01 01:30:01','2017-06-01 01:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5987,8,'2017-06-01 01:31:01','2017-06-01 01:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5988,8,'2017-06-01 01:32:01','2017-06-01 01:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5989,8,'2017-06-01 01:33:01','2017-06-01 01:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5990,8,'2017-06-01 01:34:01','2017-06-01 01:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5991,8,'2017-06-01 01:35:01','2017-06-01 01:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5992,8,'2017-06-01 01:36:02','2017-06-01 01:36:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5993,8,'2017-06-01 01:37:01','2017-06-01 01:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5994,8,'2017-06-01 01:38:01','2017-06-01 01:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5995,8,'2017-06-01 01:39:01','2017-06-01 01:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5996,8,'2017-06-01 01:40:01','2017-06-01 01:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5997,8,'2017-06-01 01:41:01','2017-06-01 01:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5998,8,'2017-06-01 01:42:01','2017-06-01 01:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(5999,8,'2017-06-01 01:43:01','2017-06-01 01:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6000,8,'2017-06-01 01:44:01','2017-06-01 01:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6001,8,'2017-06-01 01:45:01','2017-06-01 01:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6002,8,'2017-06-01 01:46:01','2017-06-01 01:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6003,8,'2017-06-01 01:47:01','2017-06-01 01:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6004,8,'2017-06-01 01:48:02','2017-06-01 01:48:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6005,8,'2017-06-01 01:49:01','2017-06-01 01:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6006,8,'2017-06-01 01:50:01','2017-06-01 01:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6007,8,'2017-06-01 01:51:01','2017-06-01 01:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6008,8,'2017-06-01 01:52:01','2017-06-01 01:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6009,8,'2017-06-01 01:53:01','2017-06-01 01:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6010,8,'2017-06-01 01:54:01','2017-06-01 01:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6011,8,'2017-06-01 01:55:01','2017-06-01 01:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6012,8,'2017-06-01 01:56:01','2017-06-01 01:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6013,8,'2017-06-01 01:57:01','2017-06-01 01:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6014,8,'2017-06-01 01:58:01','2017-06-01 01:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6015,8,'2017-06-01 01:59:01','2017-06-01 01:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6016,8,'2017-06-01 02:00:01','2017-06-01 02:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6017,8,'2017-06-01 02:01:01','2017-06-01 02:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6018,8,'2017-06-01 02:02:01','2017-06-01 02:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6019,8,'2017-06-01 02:03:01','2017-06-01 02:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6020,8,'2017-06-01 02:04:01','2017-06-01 02:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6021,8,'2017-06-01 02:05:01','2017-06-01 02:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6022,8,'2017-06-01 02:06:01','2017-06-01 02:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6023,8,'2017-06-01 02:07:01','2017-06-01 02:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6024,8,'2017-06-01 02:08:01','2017-06-01 02:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6025,8,'2017-06-01 02:09:01','2017-06-01 02:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6026,8,'2017-06-01 02:10:01','2017-06-01 02:10:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6027,8,'2017-06-01 02:11:01','2017-06-01 02:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6028,8,'2017-06-01 02:12:01','2017-06-01 02:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6029,8,'2017-06-01 02:13:01','2017-06-01 02:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6030,8,'2017-06-01 02:14:01','2017-06-01 02:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6031,8,'2017-06-01 02:15:01','2017-06-01 02:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6032,8,'2017-06-01 02:16:01','2017-06-01 02:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6033,8,'2017-06-01 02:17:01','2017-06-01 02:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6034,8,'2017-06-01 02:18:01','2017-06-01 02:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6035,8,'2017-06-01 02:19:01','2017-06-01 02:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6036,8,'2017-06-01 02:20:01','2017-06-01 02:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6037,8,'2017-06-01 02:21:01','2017-06-01 02:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6038,8,'2017-06-01 02:22:01','2017-06-01 02:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6039,8,'2017-06-01 02:23:01','2017-06-01 02:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6040,8,'2017-06-01 02:24:01','2017-06-01 02:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6041,8,'2017-06-01 02:25:01','2017-06-01 02:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6042,8,'2017-06-01 02:26:01','2017-06-01 02:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6043,8,'2017-06-01 02:27:01','2017-06-01 02:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6044,8,'2017-06-01 02:28:01','2017-06-01 02:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6045,8,'2017-06-01 02:29:01','2017-06-01 02:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6046,8,'2017-06-01 02:30:01','2017-06-01 02:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6047,8,'2017-06-01 02:31:01','2017-06-01 02:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6048,8,'2017-06-01 02:32:01','2017-06-01 02:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6049,8,'2017-06-01 02:33:01','2017-06-01 02:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6050,8,'2017-06-01 02:34:01','2017-06-01 02:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6051,8,'2017-06-01 02:35:01','2017-06-01 02:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6052,8,'2017-06-01 02:36:01','2017-06-01 02:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6053,8,'2017-06-01 02:37:01','2017-06-01 02:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6054,8,'2017-06-01 02:38:01','2017-06-01 02:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6055,8,'2017-06-01 02:39:01','2017-06-01 02:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6056,8,'2017-06-01 02:40:01','2017-06-01 02:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6057,8,'2017-06-01 02:41:01','2017-06-01 02:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6058,8,'2017-06-01 02:42:01','2017-06-01 02:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6059,8,'2017-06-01 02:43:01','2017-06-01 02:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6060,8,'2017-06-01 02:44:01','2017-06-01 02:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6061,8,'2017-06-01 02:45:01','2017-06-01 02:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6062,8,'2017-06-01 02:46:01','2017-06-01 02:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6063,8,'2017-06-01 02:47:01','2017-06-01 02:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6064,8,'2017-06-01 02:48:01','2017-06-01 02:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6065,8,'2017-06-01 02:49:01','2017-06-01 02:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6066,8,'2017-06-01 02:50:01','2017-06-01 02:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6067,8,'2017-06-01 02:51:01','2017-06-01 02:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6068,8,'2017-06-01 02:52:01','2017-06-01 02:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6069,8,'2017-06-01 02:53:01','2017-06-01 02:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6070,8,'2017-06-01 02:54:01','2017-06-01 02:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6071,8,'2017-06-01 02:55:01','2017-06-01 02:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6072,8,'2017-06-01 02:56:01','2017-06-01 02:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6073,8,'2017-06-01 02:57:01','2017-06-01 02:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6074,8,'2017-06-01 02:58:01','2017-06-01 02:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6075,8,'2017-06-01 02:59:01','2017-06-01 02:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6076,8,'2017-06-01 03:00:02','2017-06-01 03:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6077,8,'2017-06-01 03:01:01','2017-06-01 03:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6078,8,'2017-06-01 03:02:01','2017-06-01 03:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6079,8,'2017-06-01 03:03:01','2017-06-01 03:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6080,8,'2017-06-01 03:04:01','2017-06-01 03:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6081,8,'2017-06-01 03:05:01','2017-06-01 03:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6082,8,'2017-06-01 03:06:01','2017-06-01 03:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6083,8,'2017-06-01 03:07:01','2017-06-01 03:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6084,8,'2017-06-01 03:08:01','2017-06-01 03:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6085,8,'2017-06-01 03:09:01','2017-06-01 03:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6086,8,'2017-06-01 03:10:01','2017-06-01 03:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6087,8,'2017-06-01 03:11:01','2017-06-01 03:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6088,8,'2017-06-01 03:12:01','2017-06-01 03:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6089,8,'2017-06-01 03:13:01','2017-06-01 03:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6090,8,'2017-06-01 03:14:01','2017-06-01 03:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6091,8,'2017-06-01 03:15:01','2017-06-01 03:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6092,8,'2017-06-01 03:16:01','2017-06-01 03:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6093,8,'2017-06-01 03:17:01','2017-06-01 03:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6094,8,'2017-06-01 03:18:01','2017-06-01 03:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6095,8,'2017-06-01 03:19:01','2017-06-01 03:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6096,8,'2017-06-01 03:20:01','2017-06-01 03:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6097,8,'2017-06-01 03:21:01','2017-06-01 03:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6098,8,'2017-06-01 03:22:01','2017-06-01 03:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6099,8,'2017-06-01 03:23:01','2017-06-01 03:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6100,8,'2017-06-01 03:24:01','2017-06-01 03:24:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6101,8,'2017-06-01 03:25:01','2017-06-01 03:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6102,8,'2017-06-01 03:26:01','2017-06-01 03:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6103,8,'2017-06-01 03:27:01','2017-06-01 03:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6104,8,'2017-06-01 03:28:01','2017-06-01 03:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6105,8,'2017-06-01 03:29:01','2017-06-01 03:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6106,8,'2017-06-01 03:30:01','2017-06-01 03:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6107,8,'2017-06-01 03:31:02','2017-06-01 03:31:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6108,8,'2017-06-01 03:32:01','2017-06-01 03:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6109,8,'2017-06-01 03:33:01','2017-06-01 03:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6110,8,'2017-06-01 03:34:02','2017-06-01 03:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6111,8,'2017-06-01 03:35:01','2017-06-01 03:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6112,8,'2017-06-01 03:36:02','2017-06-01 03:36:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6113,8,'2017-06-01 03:37:01','2017-06-01 03:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6114,8,'2017-06-01 03:38:01','2017-06-01 03:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6115,8,'2017-06-01 03:39:02','2017-06-01 03:39:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6116,8,'2017-06-01 03:40:01','2017-06-01 03:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6117,8,'2017-06-01 03:41:01','2017-06-01 03:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6118,8,'2017-06-01 03:42:01','2017-06-01 03:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6119,8,'2017-06-01 03:43:01','2017-06-01 03:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6120,8,'2017-06-01 03:44:01','2017-06-01 03:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6121,8,'2017-06-01 03:45:01','2017-06-01 03:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6122,8,'2017-06-01 03:46:01','2017-06-01 03:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6123,8,'2017-06-01 03:47:01','2017-06-01 03:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6124,8,'2017-06-01 03:48:01','2017-06-01 03:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6125,8,'2017-06-01 03:49:01','2017-06-01 03:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6126,8,'2017-06-01 03:50:01','2017-06-01 03:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6127,8,'2017-06-01 03:51:01','2017-06-01 03:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6128,8,'2017-06-01 03:52:01','2017-06-01 03:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6129,8,'2017-06-01 03:53:01','2017-06-01 03:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6130,8,'2017-06-01 03:54:01','2017-06-01 03:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6131,8,'2017-06-01 03:55:01','2017-06-01 03:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6132,8,'2017-06-01 03:56:01','2017-06-01 03:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6133,8,'2017-06-01 03:57:01','2017-06-01 03:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6134,8,'2017-06-01 03:58:01','2017-06-01 03:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6135,8,'2017-06-01 03:59:01','2017-06-01 03:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6136,8,'2017-06-01 04:00:01','2017-06-01 04:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6137,8,'2017-06-01 04:01:01','2017-06-01 04:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6138,8,'2017-06-01 04:02:01','2017-06-01 04:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6139,8,'2017-06-01 04:03:01','2017-06-01 04:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6140,8,'2017-06-01 04:04:01','2017-06-01 04:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6141,8,'2017-06-01 04:05:01','2017-06-01 04:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6142,8,'2017-06-01 04:06:01','2017-06-01 04:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6143,8,'2017-06-01 04:07:01','2017-06-01 04:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6144,8,'2017-06-01 04:08:01','2017-06-01 04:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6145,8,'2017-06-01 04:09:01','2017-06-01 04:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6146,8,'2017-06-01 04:10:01','2017-06-01 04:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6147,8,'2017-06-01 04:11:01','2017-06-01 04:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6148,8,'2017-06-01 04:12:01','2017-06-01 04:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6149,8,'2017-06-01 04:13:01','2017-06-01 04:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6150,8,'2017-06-01 04:14:01','2017-06-01 04:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6151,8,'2017-06-01 04:15:01','2017-06-01 04:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6152,8,'2017-06-01 04:16:01','2017-06-01 04:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6153,8,'2017-06-01 04:17:01','2017-06-01 04:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6154,8,'2017-06-01 04:18:01','2017-06-01 04:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6155,8,'2017-06-01 04:19:01','2017-06-01 04:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6156,8,'2017-06-01 04:20:01','2017-06-01 04:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6157,8,'2017-06-01 04:21:01','2017-06-01 04:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6158,8,'2017-06-01 04:22:01','2017-06-01 04:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6159,8,'2017-06-01 04:23:01','2017-06-01 04:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6160,8,'2017-06-01 04:24:01','2017-06-01 04:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6161,8,'2017-06-01 04:25:01','2017-06-01 04:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6162,8,'2017-06-01 04:26:01','2017-06-01 04:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6163,8,'2017-06-01 04:27:01','2017-06-01 04:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6164,8,'2017-06-01 04:28:01','2017-06-01 04:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6165,8,'2017-06-01 04:29:02','2017-06-01 04:29:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6166,8,'2017-06-01 04:30:01','2017-06-01 04:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6167,8,'2017-06-01 04:31:01','2017-06-01 04:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6168,8,'2017-06-01 04:32:01','2017-06-01 04:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6169,8,'2017-06-01 04:33:01','2017-06-01 04:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6170,8,'2017-06-01 04:34:01','2017-06-01 04:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6171,8,'2017-06-01 04:35:01','2017-06-01 04:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6172,8,'2017-06-01 04:36:01','2017-06-01 04:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6173,8,'2017-06-01 04:37:01','2017-06-01 04:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6174,8,'2017-06-01 04:38:01','2017-06-01 04:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6175,8,'2017-06-01 04:39:01','2017-06-01 04:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6176,8,'2017-06-01 04:40:01','2017-06-01 04:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6177,8,'2017-06-01 04:41:01','2017-06-01 04:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6178,8,'2017-06-01 04:42:01','2017-06-01 04:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6179,8,'2017-06-01 04:43:01','2017-06-01 04:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6180,8,'2017-06-01 04:44:01','2017-06-01 04:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6181,8,'2017-06-01 04:45:01','2017-06-01 04:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6182,8,'2017-06-01 04:46:01','2017-06-01 04:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6183,8,'2017-06-01 04:47:02','2017-06-01 04:47:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6184,8,'2017-06-01 04:48:01','2017-06-01 04:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6185,8,'2017-06-01 04:49:01','2017-06-01 04:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6186,8,'2017-06-01 04:50:01','2017-06-01 04:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6187,8,'2017-06-01 04:51:01','2017-06-01 04:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6188,8,'2017-06-01 04:52:01','2017-06-01 04:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6189,8,'2017-06-01 04:53:01','2017-06-01 04:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6190,8,'2017-06-01 04:54:01','2017-06-01 04:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6191,8,'2017-06-01 04:55:01','2017-06-01 04:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6192,8,'2017-06-01 04:56:01','2017-06-01 04:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6193,8,'2017-06-01 04:57:01','2017-06-01 04:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6194,8,'2017-06-01 04:58:01','2017-06-01 04:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6195,8,'2017-06-01 04:59:01','2017-06-01 04:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6196,8,'2017-06-01 05:00:01','2017-06-01 05:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6197,8,'2017-06-01 05:01:01','2017-06-01 05:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6198,8,'2017-06-01 05:02:01','2017-06-01 05:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6199,8,'2017-06-01 05:03:01','2017-06-01 05:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6200,8,'2017-06-01 05:04:01','2017-06-01 05:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6201,8,'2017-06-01 05:05:01','2017-06-01 05:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6202,8,'2017-06-01 05:06:01','2017-06-01 05:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6203,8,'2017-06-01 05:07:01','2017-06-01 05:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6204,8,'2017-06-01 05:08:01','2017-06-01 05:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6205,8,'2017-06-01 05:09:01','2017-06-01 05:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6206,8,'2017-06-01 05:10:02','2017-06-01 05:10:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6207,8,'2017-06-01 05:11:01','2017-06-01 05:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6208,8,'2017-06-01 05:12:01','2017-06-01 05:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6209,8,'2017-06-01 05:13:02','2017-06-01 05:13:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6210,8,'2017-06-01 05:14:01','2017-06-01 05:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6211,8,'2017-06-01 05:15:01','2017-06-01 05:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6212,8,'2017-06-01 05:16:01','2017-06-01 05:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6213,8,'2017-06-01 05:17:02','2017-06-01 05:17:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6214,8,'2017-06-01 05:18:01','2017-06-01 05:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6215,8,'2017-06-01 05:19:01','2017-06-01 05:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6216,8,'2017-06-01 05:20:01','2017-06-01 05:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6217,8,'2017-06-01 05:21:01','2017-06-01 05:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6218,8,'2017-06-01 05:22:01','2017-06-01 05:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6219,8,'2017-06-01 05:23:01','2017-06-01 05:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6220,8,'2017-06-01 05:24:01','2017-06-01 05:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6221,8,'2017-06-01 05:25:01','2017-06-01 05:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6222,8,'2017-06-01 05:26:01','2017-06-01 05:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6223,8,'2017-06-01 05:27:01','2017-06-01 05:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6224,8,'2017-06-01 05:28:01','2017-06-01 05:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6225,8,'2017-06-01 05:29:01','2017-06-01 05:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6226,8,'2017-06-01 05:30:01','2017-06-01 05:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6227,8,'2017-06-01 05:31:01','2017-06-01 05:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6228,8,'2017-06-01 05:32:01','2017-06-01 05:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6229,8,'2017-06-01 05:33:01','2017-06-01 05:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6230,8,'2017-06-01 05:34:02','2017-06-01 05:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6231,8,'2017-06-01 05:35:01','2017-06-01 05:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6232,8,'2017-06-01 05:36:01','2017-06-01 05:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6233,8,'2017-06-01 05:37:01','2017-06-01 05:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6234,8,'2017-06-01 05:38:01','2017-06-01 05:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6235,8,'2017-06-01 05:39:01','2017-06-01 05:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6236,8,'2017-06-01 05:40:01','2017-06-01 05:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6237,8,'2017-06-01 05:41:01','2017-06-01 05:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6238,8,'2017-06-01 05:42:01','2017-06-01 05:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6239,8,'2017-06-01 05:43:01','2017-06-01 05:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6240,8,'2017-06-01 05:44:01','2017-06-01 05:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6241,8,'2017-06-01 05:45:01','2017-06-01 05:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6242,8,'2017-06-01 05:46:01','2017-06-01 05:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6243,8,'2017-06-01 05:47:01','2017-06-01 05:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6244,8,'2017-06-01 05:48:01','2017-06-01 05:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6245,8,'2017-06-01 05:49:01','2017-06-01 05:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6246,8,'2017-06-01 05:50:01','2017-06-01 05:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6247,8,'2017-06-01 05:51:02','2017-06-01 05:51:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6248,8,'2017-06-01 05:52:01','2017-06-01 05:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6249,8,'2017-06-01 05:53:01','2017-06-01 05:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6250,8,'2017-06-01 05:54:01','2017-06-01 05:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6251,8,'2017-06-01 05:55:01','2017-06-01 05:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6252,8,'2017-06-01 05:56:01','2017-06-01 05:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6253,8,'2017-06-01 05:57:01','2017-06-01 05:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6254,8,'2017-06-01 05:58:01','2017-06-01 05:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6255,8,'2017-06-01 05:59:01','2017-06-01 05:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6256,8,'2017-06-01 06:00:01','2017-06-01 06:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6257,8,'2017-06-01 06:01:01','2017-06-01 06:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6258,8,'2017-06-01 06:02:01','2017-06-01 06:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6259,8,'2017-06-01 06:03:01','2017-06-01 06:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6260,8,'2017-06-01 06:04:01','2017-06-01 06:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6261,8,'2017-06-01 06:05:01','2017-06-01 06:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6262,8,'2017-06-01 06:06:01','2017-06-01 06:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6263,8,'2017-06-01 06:07:01','2017-06-01 06:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6264,8,'2017-06-01 06:08:02','2017-06-01 06:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6265,8,'2017-06-01 06:09:01','2017-06-01 06:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6266,8,'2017-06-01 06:10:01','2017-06-01 06:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6267,8,'2017-06-01 06:11:01','2017-06-01 06:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6268,8,'2017-06-01 06:12:01','2017-06-01 06:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6269,8,'2017-06-01 06:13:01','2017-06-01 06:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6270,8,'2017-06-01 06:14:01','2017-06-01 06:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6271,8,'2017-06-01 06:15:01','2017-06-01 06:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6272,8,'2017-06-01 06:16:01','2017-06-01 06:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6273,8,'2017-06-01 06:17:01','2017-06-01 06:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6274,8,'2017-06-01 06:18:01','2017-06-01 06:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6275,8,'2017-06-01 06:19:01','2017-06-01 06:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6276,8,'2017-06-01 06:20:01','2017-06-01 06:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6277,8,'2017-06-01 06:21:01','2017-06-01 06:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6278,8,'2017-06-01 06:22:01','2017-06-01 06:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6279,8,'2017-06-01 06:23:01','2017-06-01 06:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6280,8,'2017-06-01 06:24:01','2017-06-01 06:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6281,8,'2017-06-01 06:25:01','2017-06-01 06:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6282,8,'2017-06-01 06:26:01','2017-06-01 06:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6283,8,'2017-06-01 06:27:01','2017-06-01 06:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6284,8,'2017-06-01 06:28:01','2017-06-01 06:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6285,8,'2017-06-01 06:29:01','2017-06-01 06:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6286,8,'2017-06-01 06:30:01','2017-06-01 06:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6287,8,'2017-06-01 06:31:01','2017-06-01 06:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6288,8,'2017-06-01 06:32:02','2017-06-01 06:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6289,8,'2017-06-01 06:33:01','2017-06-01 06:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6290,8,'2017-06-01 06:34:01','2017-06-01 06:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6291,8,'2017-06-01 06:35:01','2017-06-01 06:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6292,8,'2017-06-01 06:36:01','2017-06-01 06:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6293,8,'2017-06-01 06:37:01','2017-06-01 06:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6294,8,'2017-06-01 06:38:01','2017-06-01 06:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6295,8,'2017-06-01 06:39:01','2017-06-01 06:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6296,8,'2017-06-01 06:40:01','2017-06-01 06:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6297,8,'2017-06-01 06:41:01','2017-06-01 06:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6298,8,'2017-06-01 06:42:02','2017-06-01 06:42:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6299,8,'2017-06-01 06:43:01','2017-06-01 06:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6300,8,'2017-06-01 06:44:01','2017-06-01 06:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6301,8,'2017-06-01 06:45:01','2017-06-01 06:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6302,8,'2017-06-01 06:46:01','2017-06-01 06:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6303,8,'2017-06-01 06:47:01','2017-06-01 06:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6304,8,'2017-06-01 06:48:01','2017-06-01 06:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6305,8,'2017-06-01 06:49:01','2017-06-01 06:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6306,8,'2017-06-01 06:50:01','2017-06-01 06:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6307,8,'2017-06-01 06:51:01','2017-06-01 06:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6308,8,'2017-06-01 06:52:01','2017-06-01 06:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6309,8,'2017-06-01 06:53:01','2017-06-01 06:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6310,8,'2017-06-01 06:54:01','2017-06-01 06:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6311,8,'2017-06-01 06:55:01','2017-06-01 06:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6312,8,'2017-06-01 06:56:01','2017-06-01 06:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6313,8,'2017-06-01 06:57:02','2017-06-01 06:57:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6314,8,'2017-06-01 06:58:01','2017-06-01 06:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6315,8,'2017-06-01 06:59:01','2017-06-01 06:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6316,8,'2017-06-01 07:00:01','2017-06-01 07:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6317,8,'2017-06-01 07:01:01','2017-06-01 07:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6318,8,'2017-06-01 07:02:01','2017-06-01 07:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6319,8,'2017-06-01 07:03:01','2017-06-01 07:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6320,8,'2017-06-01 07:04:01','2017-06-01 07:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6321,8,'2017-06-01 07:06:02','2017-06-01 07:06:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6322,8,'2017-06-01 07:07:02','2017-06-01 07:07:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6323,8,'2017-06-01 07:08:01','2017-06-01 07:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6324,8,'2017-06-01 07:09:01','2017-06-01 07:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6325,8,'2017-06-01 07:10:01','2017-06-01 07:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6326,8,'2017-06-01 07:11:01','2017-06-01 07:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6327,8,'2017-06-01 07:12:02','2017-06-01 07:12:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6328,8,'2017-06-01 07:13:01','2017-06-01 07:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6329,8,'2017-06-01 07:14:01','2017-06-01 07:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6330,8,'2017-06-01 07:15:01','2017-06-01 07:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6331,8,'2017-06-01 07:16:01','2017-06-01 07:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6332,8,'2017-06-01 07:17:01','2017-06-01 07:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6333,8,'2017-06-01 07:18:01','2017-06-01 07:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6334,8,'2017-06-01 07:19:01','2017-06-01 07:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6335,8,'2017-06-01 07:20:01','2017-06-01 07:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6336,8,'2017-06-01 07:21:01','2017-06-01 07:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6337,8,'2017-06-01 07:22:01','2017-06-01 07:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6338,8,'2017-06-01 07:23:01','2017-06-01 07:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6339,8,'2017-06-01 07:24:01','2017-06-01 07:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6340,8,'2017-06-01 07:25:01','2017-06-01 07:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6341,8,'2017-06-01 07:26:01','2017-06-01 07:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6342,8,'2017-06-01 07:27:01','2017-06-01 07:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6343,8,'2017-06-01 07:28:01','2017-06-01 07:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6344,8,'2017-06-01 07:29:01','2017-06-01 07:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6345,8,'2017-06-01 07:30:01','2017-06-01 07:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6346,8,'2017-06-01 07:31:01','2017-06-01 07:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6347,8,'2017-06-01 07:32:01','2017-06-01 07:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6348,8,'2017-06-01 07:33:01','2017-06-01 07:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6349,8,'2017-06-01 07:34:01','2017-06-01 07:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6350,8,'2017-06-01 07:35:01','2017-06-01 07:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6351,8,'2017-06-01 07:36:01','2017-06-01 07:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6352,8,'2017-06-01 07:37:01','2017-06-01 07:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6353,8,'2017-06-01 07:38:01','2017-06-01 07:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6354,8,'2017-06-01 07:39:01','2017-06-01 07:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6355,8,'2017-06-01 07:40:01','2017-06-01 07:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6356,8,'2017-06-01 07:41:02','2017-06-01 07:41:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6357,8,'2017-06-01 07:42:01','2017-06-01 07:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6358,8,'2017-06-01 07:43:01','2017-06-01 07:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6359,8,'2017-06-01 07:44:01','2017-06-01 07:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6360,8,'2017-06-01 07:45:01','2017-06-01 07:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6361,8,'2017-06-01 07:46:01','2017-06-01 07:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6362,8,'2017-06-01 07:47:01','2017-06-01 07:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6363,8,'2017-06-01 07:48:01','2017-06-01 07:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6364,8,'2017-06-01 07:49:01','2017-06-01 07:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6365,8,'2017-06-01 07:50:01','2017-06-01 07:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6366,8,'2017-06-01 07:51:01','2017-06-01 07:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6367,8,'2017-06-01 07:52:01','2017-06-01 07:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6368,8,'2017-06-01 07:53:02','2017-06-01 07:53:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6369,8,'2017-06-01 07:54:01','2017-06-01 07:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6370,8,'2017-06-01 07:55:01','2017-06-01 07:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6371,8,'2017-06-01 07:56:01','2017-06-01 07:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6372,8,'2017-06-01 07:57:01','2017-06-01 07:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6373,8,'2017-06-01 07:58:01','2017-06-01 07:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6374,8,'2017-06-01 07:59:01','2017-06-01 07:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6375,8,'2017-06-01 08:00:01','2017-06-01 08:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6376,8,'2017-06-01 08:01:01','2017-06-01 08:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6377,8,'2017-06-01 08:02:01','2017-06-01 08:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6378,8,'2017-06-01 08:03:01','2017-06-01 08:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6379,8,'2017-06-01 08:04:01','2017-06-01 08:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6380,8,'2017-06-01 08:05:01','2017-06-01 08:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6381,8,'2017-06-01 08:06:01','2017-06-01 08:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6382,8,'2017-06-01 08:07:01','2017-06-01 08:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6383,8,'2017-06-01 08:08:01','2017-06-01 08:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6384,8,'2017-06-01 08:09:01','2017-06-01 08:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6385,8,'2017-06-01 08:10:01','2017-06-01 08:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6386,8,'2017-06-01 08:11:01','2017-06-01 08:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6387,8,'2017-06-01 08:12:01','2017-06-01 08:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6388,8,'2017-06-01 08:13:02','2017-06-01 08:13:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6389,8,'2017-06-01 08:14:01','2017-06-01 08:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6390,8,'2017-06-01 08:15:01','2017-06-01 08:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6391,8,'2017-06-01 08:16:01','2017-06-01 08:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6392,8,'2017-06-01 08:17:01','2017-06-01 08:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6393,8,'2017-06-01 08:18:01','2017-06-01 08:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6394,8,'2017-06-01 08:19:01','2017-06-01 08:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6395,8,'2017-06-01 08:20:01','2017-06-01 08:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6396,8,'2017-06-01 08:21:01','2017-06-01 08:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6397,8,'2017-06-01 08:22:01','2017-06-01 08:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6398,8,'2017-06-01 08:23:01','2017-06-01 08:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6399,8,'2017-06-01 08:24:02','2017-06-01 08:24:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6400,8,'2017-06-01 08:25:01','2017-06-01 08:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6401,8,'2017-06-01 08:26:01','2017-06-01 08:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6402,8,'2017-06-01 08:27:01','2017-06-01 08:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6403,8,'2017-06-01 08:28:01','2017-06-01 08:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6404,8,'2017-06-01 08:29:01','2017-06-01 08:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6405,8,'2017-06-01 08:30:01','2017-06-01 08:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6406,8,'2017-06-01 08:31:01','2017-06-01 08:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6407,8,'2017-06-01 08:32:01','2017-06-01 08:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6408,8,'2017-06-01 08:33:01','2017-06-01 08:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6409,8,'2017-06-01 08:34:01','2017-06-01 08:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6410,8,'2017-06-01 08:35:01','2017-06-01 08:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6411,8,'2017-06-01 08:36:01','2017-06-01 08:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6412,8,'2017-06-01 08:37:01','2017-06-01 08:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6413,8,'2017-06-01 08:38:01','2017-06-01 08:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6414,8,'2017-06-01 08:39:01','2017-06-01 08:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6415,8,'2017-06-01 08:40:01','2017-06-01 08:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6416,8,'2017-06-01 08:41:01','2017-06-01 08:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6417,8,'2017-06-01 08:42:01','2017-06-01 08:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6418,8,'2017-06-01 08:43:01','2017-06-01 08:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6419,8,'2017-06-01 08:44:01','2017-06-01 08:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6420,8,'2017-06-01 08:45:01','2017-06-01 08:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6421,8,'2017-06-01 08:46:01','2017-06-01 08:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6422,8,'2017-06-01 08:47:02','2017-06-01 08:47:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6423,8,'2017-06-01 08:48:01','2017-06-01 08:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6424,8,'2017-06-01 08:49:01','2017-06-01 08:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6425,8,'2017-06-01 08:50:02','2017-06-01 08:50:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6426,8,'2017-06-01 08:51:01','2017-06-01 08:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6427,8,'2017-06-01 08:52:01','2017-06-01 08:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6428,8,'2017-06-01 08:53:02','2017-06-01 08:53:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6429,8,'2017-06-01 08:54:01','2017-06-01 08:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6430,8,'2017-06-01 08:55:01','2017-06-01 08:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6431,8,'2017-06-01 08:56:02','2017-06-01 08:56:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6432,8,'2017-06-01 08:57:01','2017-06-01 08:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6433,8,'2017-06-01 08:58:01','2017-06-01 08:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6434,8,'2017-06-01 08:59:01','2017-06-01 08:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6435,8,'2017-06-01 09:00:01','2017-06-01 09:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6436,8,'2017-06-01 09:01:01','2017-06-01 09:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6437,8,'2017-06-01 09:02:01','2017-06-01 09:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6438,8,'2017-06-01 09:03:01','2017-06-01 09:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6439,8,'2017-06-01 09:04:01','2017-06-01 09:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6440,8,'2017-06-01 09:05:01','2017-06-01 09:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6441,8,'2017-06-01 09:06:01','2017-06-01 09:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6442,8,'2017-06-01 09:07:01','2017-06-01 09:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6443,8,'2017-06-01 09:08:01','2017-06-01 09:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6444,8,'2017-06-01 09:09:01','2017-06-01 09:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6445,8,'2017-06-01 09:10:01','2017-06-01 09:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6446,8,'2017-06-01 09:11:02','2017-06-01 09:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6447,8,'2017-06-01 09:12:01','2017-06-01 09:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6448,8,'2017-06-01 09:13:01','2017-06-01 09:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6449,8,'2017-06-01 09:14:02','2017-06-01 09:14:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6450,8,'2017-06-01 09:15:01','2017-06-01 09:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6451,8,'2017-06-01 09:16:01','2017-06-01 09:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6452,8,'2017-06-01 09:17:01','2017-06-01 09:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6453,8,'2017-06-01 09:18:01','2017-06-01 09:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6454,8,'2017-06-01 09:19:01','2017-06-01 09:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6455,8,'2017-06-01 09:20:01','2017-06-01 09:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6456,8,'2017-06-01 09:21:01','2017-06-01 09:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6457,8,'2017-06-01 09:22:01','2017-06-01 09:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6458,8,'2017-06-01 09:23:01','2017-06-01 09:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6459,8,'2017-06-01 09:24:02','2017-06-01 09:24:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6460,8,'2017-06-01 09:25:01','2017-06-01 09:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6461,8,'2017-06-01 09:26:01','2017-06-01 09:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6462,8,'2017-06-01 09:27:01','2017-06-01 09:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6463,8,'2017-06-01 09:28:01','2017-06-01 09:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6464,8,'2017-06-01 09:29:01','2017-06-01 09:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6465,8,'2017-06-01 09:30:01','2017-06-01 09:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6466,8,'2017-06-01 09:31:01','2017-06-01 09:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6467,8,'2017-06-01 09:32:01','2017-06-01 09:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6468,8,'2017-06-01 09:33:01','2017-06-01 09:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6469,8,'2017-06-01 09:34:01','2017-06-01 09:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6470,8,'2017-06-01 09:35:01','2017-06-01 09:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6471,8,'2017-06-01 09:36:01','2017-06-01 09:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6472,8,'2017-06-01 09:37:01','2017-06-01 09:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6473,8,'2017-06-01 09:38:01','2017-06-01 09:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6474,8,'2017-06-01 09:39:01','2017-06-01 09:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6475,8,'2017-06-01 09:40:01','2017-06-01 09:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6476,8,'2017-06-01 09:41:01','2017-06-01 09:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6477,8,'2017-06-01 09:42:01','2017-06-01 09:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6478,8,'2017-06-01 09:43:02','2017-06-01 09:43:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6479,8,'2017-06-01 09:44:01','2017-06-01 09:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6480,8,'2017-06-01 09:45:01','2017-06-01 09:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6481,8,'2017-06-01 09:46:02','2017-06-01 09:46:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6482,8,'2017-06-01 09:47:01','2017-06-01 09:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6483,8,'2017-06-01 09:48:01','2017-06-01 09:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6484,8,'2017-06-01 09:49:02','2017-06-01 09:49:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6485,8,'2017-06-01 09:50:01','2017-06-01 09:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6486,8,'2017-06-01 09:51:01','2017-06-01 09:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6487,8,'2017-06-01 09:52:01','2017-06-01 09:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6488,8,'2017-06-01 09:53:01','2017-06-01 09:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6489,8,'2017-06-01 09:54:01','2017-06-01 09:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6490,8,'2017-06-01 09:55:01','2017-06-01 09:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6491,8,'2017-06-01 09:56:01','2017-06-01 09:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6492,8,'2017-06-01 09:57:01','2017-06-01 09:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6493,8,'2017-06-01 09:58:01','2017-06-01 09:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6494,8,'2017-06-01 09:59:01','2017-06-01 09:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6495,8,'2017-06-01 10:00:01','2017-06-01 10:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6496,8,'2017-06-01 10:01:01','2017-06-01 10:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6497,8,'2017-06-01 10:02:01','2017-06-01 10:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6498,8,'2017-06-01 10:03:01','2017-06-01 10:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6499,8,'2017-06-01 10:04:01','2017-06-01 10:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6500,8,'2017-06-01 10:05:01','2017-06-01 10:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6501,8,'2017-06-01 10:06:01','2017-06-01 10:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6502,8,'2017-06-01 10:07:01','2017-06-01 10:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6503,8,'2017-06-01 10:08:01','2017-06-01 10:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6504,8,'2017-06-01 10:09:01','2017-06-01 10:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6505,8,'2017-06-01 10:10:01','2017-06-01 10:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6506,8,'2017-06-01 10:11:01','2017-06-01 10:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6507,8,'2017-06-01 10:12:01','2017-06-01 10:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6508,8,'2017-06-01 10:13:01','2017-06-01 10:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6509,8,'2017-06-01 10:14:01','2017-06-01 10:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6510,8,'2017-06-01 10:15:01','2017-06-01 10:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6511,8,'2017-06-01 10:16:01','2017-06-01 10:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6512,8,'2017-06-01 10:17:01','2017-06-01 10:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6513,8,'2017-06-01 10:18:01','2017-06-01 10:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6514,8,'2017-06-01 10:19:01','2017-06-01 10:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6515,8,'2017-06-01 10:20:01','2017-06-01 10:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6516,8,'2017-06-01 10:21:01','2017-06-01 10:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6517,8,'2017-06-01 10:22:01','2017-06-01 10:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6518,8,'2017-06-01 10:23:01','2017-06-01 10:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6519,8,'2017-06-01 10:24:01','2017-06-01 10:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6520,8,'2017-06-01 10:25:01','2017-06-01 10:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6521,8,'2017-06-01 10:26:01','2017-06-01 10:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6522,8,'2017-06-01 10:27:01','2017-06-01 10:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6523,8,'2017-06-01 10:28:01','2017-06-01 10:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6524,8,'2017-06-01 10:29:01','2017-06-01 10:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6525,8,'2017-06-01 10:30:01','2017-06-01 10:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6526,8,'2017-06-01 10:31:01','2017-06-01 10:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6527,8,'2017-06-01 10:32:01','2017-06-01 10:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6528,8,'2017-06-01 10:33:01','2017-06-01 10:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6529,8,'2017-06-01 10:34:01','2017-06-01 10:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6530,8,'2017-06-01 10:35:01','2017-06-01 10:35:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6531,8,'2017-06-01 10:36:01','2017-06-01 10:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6532,8,'2017-06-01 10:37:01','2017-06-01 10:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6533,8,'2017-06-01 10:38:02','2017-06-01 10:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6534,8,'2017-06-01 10:39:01','2017-06-01 10:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6535,8,'2017-06-01 10:40:01','2017-06-01 10:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6536,8,'2017-06-01 10:41:01','2017-06-01 10:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6537,8,'2017-06-01 10:42:01','2017-06-01 10:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6538,8,'2017-06-01 10:43:01','2017-06-01 10:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6539,8,'2017-06-01 10:44:01','2017-06-01 10:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6540,8,'2017-06-01 10:45:01','2017-06-01 10:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6541,8,'2017-06-01 10:46:01','2017-06-01 10:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6542,8,'2017-06-01 10:47:01','2017-06-01 10:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6543,8,'2017-06-01 10:48:01','2017-06-01 10:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6544,8,'2017-06-01 10:49:01','2017-06-01 10:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6545,8,'2017-06-01 10:50:01','2017-06-01 10:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6546,8,'2017-06-01 10:51:02','2017-06-01 10:51:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6547,8,'2017-06-01 10:52:01','2017-06-01 10:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6548,8,'2017-06-01 10:53:01','2017-06-01 10:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6549,8,'2017-06-01 10:54:01','2017-06-01 10:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6550,8,'2017-06-01 10:55:01','2017-06-01 10:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6551,8,'2017-06-01 10:56:01','2017-06-01 10:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6552,8,'2017-06-01 10:57:01','2017-06-01 10:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6553,8,'2017-06-01 10:58:01','2017-06-01 10:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6554,8,'2017-06-01 10:59:01','2017-06-01 10:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6555,8,'2017-06-01 11:00:02','2017-06-01 11:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6556,8,'2017-06-01 11:01:01','2017-06-01 11:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6557,8,'2017-06-01 11:02:01','2017-06-01 11:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6558,8,'2017-06-01 11:03:01','2017-06-01 11:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6559,8,'2017-06-01 11:04:01','2017-06-01 11:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6560,8,'2017-06-01 11:05:01','2017-06-01 11:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6561,8,'2017-06-01 11:06:01','2017-06-01 11:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6562,8,'2017-06-01 11:07:01','2017-06-01 11:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6563,8,'2017-06-01 11:08:01','2017-06-01 11:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6564,8,'2017-06-01 11:09:02','2017-06-01 11:09:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6565,8,'2017-06-01 11:10:01','2017-06-01 11:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6566,8,'2017-06-01 11:11:01','2017-06-01 11:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6567,8,'2017-06-01 11:12:01','2017-06-01 11:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6568,8,'2017-06-01 11:13:01','2017-06-01 11:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6569,8,'2017-06-01 11:14:02','2017-06-01 11:14:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6570,8,'2017-06-01 11:15:01','2017-06-01 11:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6571,8,'2017-06-01 11:16:01','2017-06-01 11:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6572,8,'2017-06-01 11:17:02','2017-06-01 11:17:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6573,8,'2017-06-01 11:18:01','2017-06-01 11:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6574,8,'2017-06-01 11:19:01','2017-06-01 11:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6575,8,'2017-06-01 11:20:02','2017-06-01 11:20:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6576,8,'2017-06-01 11:21:01','2017-06-01 11:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6577,8,'2017-06-01 11:22:01','2017-06-01 11:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6578,8,'2017-06-01 11:23:01','2017-06-01 11:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6579,8,'2017-06-01 11:24:01','2017-06-01 11:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6580,8,'2017-06-01 11:25:02','2017-06-01 11:25:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6581,8,'2017-06-01 11:26:01','2017-06-01 11:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6582,8,'2017-06-01 11:27:01','2017-06-01 11:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6583,8,'2017-06-01 11:28:01','2017-06-01 11:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6584,8,'2017-06-01 11:29:01','2017-06-01 11:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6585,8,'2017-06-01 11:30:02','2017-06-01 11:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6586,8,'2017-06-01 11:31:01','2017-06-01 11:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6587,8,'2017-06-01 11:32:01','2017-06-01 11:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6588,8,'2017-06-01 11:33:01','2017-06-01 11:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6589,8,'2017-06-01 11:34:01','2017-06-01 11:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6590,8,'2017-06-01 11:35:01','2017-06-01 11:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6591,8,'2017-06-01 11:36:01','2017-06-01 11:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6592,8,'2017-06-01 11:37:01','2017-06-01 11:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6593,8,'2017-06-01 11:38:01','2017-06-01 11:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6594,8,'2017-06-01 11:39:01','2017-06-01 11:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6595,8,'2017-06-01 11:40:01','2017-06-01 11:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6596,8,'2017-06-01 11:41:01','2017-06-01 11:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6597,8,'2017-06-01 11:42:01','2017-06-01 11:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6598,8,'2017-06-01 11:43:01','2017-06-01 11:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6599,8,'2017-06-01 11:44:01','2017-06-01 11:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6600,8,'2017-06-01 11:45:01','2017-06-01 11:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6601,8,'2017-06-01 11:46:01','2017-06-01 11:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6602,8,'2017-06-01 11:47:01','2017-06-01 11:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6603,8,'2017-06-01 11:48:01','2017-06-01 11:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6604,8,'2017-06-01 11:49:01','2017-06-01 11:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6605,8,'2017-06-01 11:50:01','2017-06-01 11:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6606,8,'2017-06-01 11:51:01','2017-06-01 11:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6607,8,'2017-06-01 11:52:01','2017-06-01 11:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6608,8,'2017-06-01 11:53:02','2017-06-01 11:53:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6609,8,'2017-06-01 11:54:01','2017-06-01 11:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6610,8,'2017-06-01 11:55:01','2017-06-01 11:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6611,8,'2017-06-01 11:56:01','2017-06-01 11:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6612,8,'2017-06-01 11:57:02','2017-06-01 11:57:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6613,8,'2017-06-01 11:58:01','2017-06-01 11:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6614,8,'2017-06-01 11:59:01','2017-06-01 11:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6615,8,'2017-06-01 12:00:02','2017-06-01 12:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6616,8,'2017-06-01 12:01:01','2017-06-01 12:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6617,8,'2017-06-01 12:02:02','2017-06-01 12:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6618,8,'2017-06-01 12:03:01','2017-06-01 12:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6619,8,'2017-06-01 12:04:01','2017-06-01 12:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6620,8,'2017-06-01 12:05:01','2017-06-01 12:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6621,8,'2017-06-01 12:06:01','2017-06-01 12:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6622,8,'2017-06-01 12:07:01','2017-06-01 12:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6623,8,'2017-06-01 12:08:01','2017-06-01 12:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6624,8,'2017-06-01 12:09:01','2017-06-01 12:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6625,8,'2017-06-01 12:10:01','2017-06-01 12:10:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6626,8,'2017-06-01 12:11:01','2017-06-01 12:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6627,8,'2017-06-01 12:12:01','2017-06-01 12:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6628,8,'2017-06-01 12:13:01','2017-06-01 12:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6629,8,'2017-06-01 12:14:01','2017-06-01 12:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6630,8,'2017-06-01 12:15:01','2017-06-01 12:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6631,8,'2017-06-01 12:16:01','2017-06-01 12:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6632,8,'2017-06-01 12:17:01','2017-06-01 12:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6633,8,'2017-06-01 12:18:01','2017-06-01 12:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6634,8,'2017-06-01 12:19:01','2017-06-01 12:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6635,8,'2017-06-01 12:20:01','2017-06-01 12:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6636,8,'2017-06-01 12:21:01','2017-06-01 12:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6637,8,'2017-06-01 12:22:01','2017-06-01 12:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6638,8,'2017-06-01 12:23:01','2017-06-01 12:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6639,8,'2017-06-01 12:24:01','2017-06-01 12:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6640,8,'2017-06-01 12:25:01','2017-06-01 12:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6641,8,'2017-06-01 12:26:01','2017-06-01 12:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6642,8,'2017-06-01 12:27:01','2017-06-01 12:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6643,8,'2017-06-01 12:28:01','2017-06-01 12:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6644,8,'2017-06-01 12:29:01','2017-06-01 12:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6645,8,'2017-06-01 12:30:01','2017-06-01 12:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6646,8,'2017-06-01 12:31:01','2017-06-01 12:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6647,8,'2017-06-01 12:32:01','2017-06-01 12:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6648,8,'2017-06-01 12:33:01','2017-06-01 12:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6649,8,'2017-06-01 12:34:01','2017-06-01 12:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6650,8,'2017-06-01 12:35:02','2017-06-01 12:35:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6651,8,'2017-06-01 12:36:01','2017-06-01 12:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6652,8,'2017-06-01 12:37:01','2017-06-01 12:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6653,8,'2017-06-01 12:38:01','2017-06-01 12:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6654,8,'2017-06-01 12:39:01','2017-06-01 12:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6655,8,'2017-06-01 12:40:01','2017-06-01 12:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6656,8,'2017-06-01 12:41:01','2017-06-01 12:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6657,8,'2017-06-01 12:42:01','2017-06-01 12:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6658,8,'2017-06-01 12:43:01','2017-06-01 12:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6659,8,'2017-06-01 12:44:01','2017-06-01 12:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6660,8,'2017-06-01 12:45:01','2017-06-01 12:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6661,8,'2017-06-01 12:46:01','2017-06-01 12:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6662,8,'2017-06-01 12:47:01','2017-06-01 12:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6663,8,'2017-06-01 12:48:01','2017-06-01 12:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6664,8,'2017-06-01 12:49:01','2017-06-01 12:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6665,8,'2017-06-01 12:50:02','2017-06-01 12:50:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6666,8,'2017-06-01 12:51:01','2017-06-01 12:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6667,8,'2017-06-01 12:52:01','2017-06-01 12:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6668,8,'2017-06-01 12:53:01','2017-06-01 12:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6669,8,'2017-06-01 12:54:01','2017-06-01 12:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6670,8,'2017-06-01 12:55:01','2017-06-01 12:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6671,8,'2017-06-01 12:56:01','2017-06-01 12:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6672,8,'2017-06-01 12:57:01','2017-06-01 12:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6673,8,'2017-06-01 12:58:01','2017-06-01 12:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6674,8,'2017-06-01 12:59:01','2017-06-01 12:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6675,8,'2017-06-01 13:00:01','2017-06-01 13:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6676,8,'2017-06-01 13:01:01','2017-06-01 13:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6677,8,'2017-06-01 13:02:01','2017-06-01 13:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6678,8,'2017-06-01 13:03:01','2017-06-01 13:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6679,8,'2017-06-01 13:04:01','2017-06-01 13:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6680,8,'2017-06-01 13:05:01','2017-06-01 13:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6681,8,'2017-06-01 13:06:01','2017-06-01 13:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6682,8,'2017-06-01 13:07:01','2017-06-01 13:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6683,8,'2017-06-01 13:08:01','2017-06-01 13:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6684,8,'2017-06-01 13:09:01','2017-06-01 13:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6685,8,'2017-06-01 13:10:01','2017-06-01 13:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6686,8,'2017-06-01 13:11:01','2017-06-01 13:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6687,8,'2017-06-01 13:12:01','2017-06-01 13:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6688,8,'2017-06-01 13:13:01','2017-06-01 13:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6689,8,'2017-06-01 13:14:01','2017-06-01 13:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6690,8,'2017-06-01 13:15:01','2017-06-01 13:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6691,8,'2017-06-01 13:16:01','2017-06-01 13:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6692,8,'2017-06-01 13:17:02','2017-06-01 13:17:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6693,8,'2017-06-01 13:18:01','2017-06-01 13:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6694,8,'2017-06-01 13:19:01','2017-06-01 13:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6695,8,'2017-06-01 13:20:02','2017-06-01 13:20:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6696,8,'2017-06-01 13:21:01','2017-06-01 13:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6697,8,'2017-06-01 13:22:01','2017-06-01 13:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6698,8,'2017-06-01 13:23:01','2017-06-01 13:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6699,8,'2017-06-01 13:24:01','2017-06-01 13:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6700,8,'2017-06-01 13:25:01','2017-06-01 13:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6701,8,'2017-06-01 13:26:01','2017-06-01 13:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6702,8,'2017-06-01 13:27:02','2017-06-01 13:27:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6703,8,'2017-06-01 13:28:01','2017-06-01 13:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6704,8,'2017-06-01 13:29:01','2017-06-01 13:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6705,8,'2017-06-01 13:30:01','2017-06-01 13:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6706,8,'2017-06-01 13:31:01','2017-06-01 13:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6707,8,'2017-06-01 13:32:02','2017-06-01 13:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6708,8,'2017-06-01 13:33:01','2017-06-01 13:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6709,8,'2017-06-01 13:34:01','2017-06-01 13:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6710,8,'2017-06-01 13:35:01','2017-06-01 13:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6711,8,'2017-06-01 13:36:01','2017-06-01 13:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6712,8,'2017-06-01 13:37:01','2017-06-01 13:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6713,8,'2017-06-01 13:38:01','2017-06-01 13:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6714,8,'2017-06-01 13:39:01','2017-06-01 13:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6715,8,'2017-06-01 13:40:01','2017-06-01 13:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6716,8,'2017-06-01 13:41:01','2017-06-01 13:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6717,8,'2017-06-01 13:42:01','2017-06-01 13:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6718,8,'2017-06-01 13:43:01','2017-06-01 13:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6719,8,'2017-06-01 13:44:01','2017-06-01 13:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6720,8,'2017-06-01 13:45:01','2017-06-01 13:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6721,8,'2017-06-01 13:46:01','2017-06-01 13:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6722,8,'2017-06-01 13:47:01','2017-06-01 13:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6723,8,'2017-06-01 13:48:01','2017-06-01 13:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6724,8,'2017-06-01 13:49:01','2017-06-01 13:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6725,8,'2017-06-01 13:50:01','2017-06-01 13:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6726,8,'2017-06-01 13:51:01','2017-06-01 13:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6727,8,'2017-06-01 13:52:01','2017-06-01 13:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6728,8,'2017-06-01 13:53:01','2017-06-01 13:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6729,8,'2017-06-01 13:54:01','2017-06-01 13:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6730,8,'2017-06-01 13:55:02','2017-06-01 13:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6731,8,'2017-06-01 13:56:01','2017-06-01 13:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6732,8,'2017-06-01 13:57:01','2017-06-01 13:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6733,8,'2017-06-01 13:58:01','2017-06-01 13:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6734,8,'2017-06-01 13:59:01','2017-06-01 13:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6735,8,'2017-06-01 14:00:01','2017-06-01 14:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6736,8,'2017-06-01 14:01:01','2017-06-01 14:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6737,8,'2017-06-01 14:02:01','2017-06-01 14:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6738,8,'2017-06-01 14:03:01','2017-06-01 14:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6739,8,'2017-06-01 14:04:01','2017-06-01 14:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6740,8,'2017-06-01 14:05:01','2017-06-01 14:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6741,8,'2017-06-01 14:06:02','2017-06-01 14:06:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6742,8,'2017-06-01 14:07:01','2017-06-01 14:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6743,8,'2017-06-01 14:08:01','2017-06-01 14:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6744,8,'2017-06-01 14:09:01','2017-06-01 14:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6745,8,'2017-06-01 14:10:02','2017-06-01 14:10:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6746,8,'2017-06-01 14:11:01','2017-06-01 14:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6747,8,'2017-06-01 14:12:01','2017-06-01 14:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6748,8,'2017-06-01 14:13:01','2017-06-01 14:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6749,8,'2017-06-01 14:14:02','2017-06-01 14:14:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6750,8,'2017-06-01 14:15:01','2017-06-01 14:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6751,8,'2017-06-01 14:16:01','2017-06-01 14:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6752,8,'2017-06-01 14:17:01','2017-06-01 14:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6753,8,'2017-06-01 14:18:01','2017-06-01 14:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6754,8,'2017-06-01 14:19:01','2017-06-01 14:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6755,8,'2017-06-01 14:20:01','2017-06-01 14:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6756,8,'2017-06-01 14:21:01','2017-06-01 14:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6757,8,'2017-06-01 14:22:01','2017-06-01 14:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6758,8,'2017-06-01 14:23:01','2017-06-01 14:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6759,8,'2017-06-01 14:24:01','2017-06-01 14:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6760,8,'2017-06-01 14:25:02','2017-06-01 14:25:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6761,8,'2017-06-01 14:26:01','2017-06-01 14:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6762,8,'2017-06-01 14:27:01','2017-06-01 14:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6763,8,'2017-06-01 14:28:01','2017-06-01 14:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6764,8,'2017-06-01 14:29:01','2017-06-01 14:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6765,8,'2017-06-01 14:30:01','2017-06-01 14:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6766,8,'2017-06-01 14:31:01','2017-06-01 14:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6767,8,'2017-06-01 14:32:01','2017-06-01 14:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6768,8,'2017-06-01 14:33:01','2017-06-01 14:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6769,8,'2017-06-01 14:34:01','2017-06-01 14:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6770,8,'2017-06-01 14:35:01','2017-06-01 14:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6771,8,'2017-06-01 14:36:02','2017-06-01 14:36:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6772,8,'2017-06-01 14:37:01','2017-06-01 14:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6773,8,'2017-06-01 14:38:01','2017-06-01 14:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6774,8,'2017-06-01 14:39:01','2017-06-01 14:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6775,8,'2017-06-01 14:40:01','2017-06-01 14:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6776,8,'2017-06-01 14:41:01','2017-06-01 14:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6777,8,'2017-06-01 14:42:01','2017-06-01 14:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6778,8,'2017-06-01 14:43:01','2017-06-01 14:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6779,8,'2017-06-01 14:44:01','2017-06-01 14:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6780,8,'2017-06-01 14:45:01','2017-06-01 14:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6781,8,'2017-06-01 14:46:01','2017-06-01 14:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6782,8,'2017-06-01 14:47:01','2017-06-01 14:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6783,8,'2017-06-01 14:48:01','2017-06-01 14:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6784,8,'2017-06-01 14:49:01','2017-06-01 14:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6785,8,'2017-06-01 14:50:01','2017-06-01 14:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6786,8,'2017-06-01 14:51:01','2017-06-01 14:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6787,8,'2017-06-01 14:52:02','2017-06-01 14:52:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6788,8,'2017-06-01 14:53:01','2017-06-01 14:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6789,8,'2017-06-01 14:54:01','2017-06-01 14:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6790,8,'2017-06-01 14:55:01','2017-06-01 14:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6791,8,'2017-06-01 14:56:01','2017-06-01 14:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6792,8,'2017-06-01 14:57:01','2017-06-01 14:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6793,8,'2017-06-01 14:58:01','2017-06-01 14:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6794,8,'2017-06-01 14:59:01','2017-06-01 14:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6795,8,'2017-06-01 15:00:01','2017-06-01 15:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6796,8,'2017-06-01 15:01:01','2017-06-01 15:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6797,8,'2017-06-01 15:02:01','2017-06-01 15:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6798,8,'2017-06-01 15:03:01','2017-06-01 15:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6799,8,'2017-06-01 15:04:01','2017-06-01 15:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6800,8,'2017-06-01 15:05:01','2017-06-01 15:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6801,8,'2017-06-01 15:06:01','2017-06-01 15:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6802,8,'2017-06-01 15:07:01','2017-06-01 15:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6803,8,'2017-06-01 15:08:01','2017-06-01 15:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6804,8,'2017-06-01 15:09:01','2017-06-01 15:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6805,8,'2017-06-01 15:10:02','2017-06-01 15:10:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6806,8,'2017-06-01 15:11:01','2017-06-01 15:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6807,8,'2017-06-01 15:12:01','2017-06-01 15:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6808,8,'2017-06-01 15:13:01','2017-06-01 15:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6809,8,'2017-06-01 15:14:01','2017-06-01 15:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6810,8,'2017-06-01 15:15:01','2017-06-01 15:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6811,8,'2017-06-01 15:16:01','2017-06-01 15:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6812,8,'2017-06-01 15:17:01','2017-06-01 15:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6813,8,'2017-06-01 15:18:01','2017-06-01 15:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6814,8,'2017-06-01 15:19:01','2017-06-01 15:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6815,8,'2017-06-01 15:20:01','2017-06-01 15:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6816,8,'2017-06-01 15:21:01','2017-06-01 15:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6817,8,'2017-06-01 15:22:01','2017-06-01 15:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6818,8,'2017-06-01 15:23:01','2017-06-01 15:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6819,8,'2017-06-01 15:24:01','2017-06-01 15:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6820,8,'2017-06-01 15:25:01','2017-06-01 15:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6821,8,'2017-06-01 15:26:01','2017-06-01 15:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6822,8,'2017-06-01 15:27:02','2017-06-01 15:27:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6823,8,'2017-06-01 15:28:01','2017-06-01 15:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6824,8,'2017-06-01 15:29:01','2017-06-01 15:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6825,8,'2017-06-01 15:30:01','2017-06-01 15:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6826,8,'2017-06-01 15:31:01','2017-06-01 15:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6827,8,'2017-06-01 15:32:02','2017-06-01 15:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6828,8,'2017-06-01 15:33:01','2017-06-01 15:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6829,8,'2017-06-01 15:34:01','2017-06-01 15:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6830,8,'2017-06-01 15:35:01','2017-06-01 15:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6831,8,'2017-06-01 15:36:01','2017-06-01 15:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6832,8,'2017-06-01 15:37:01','2017-06-01 15:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6833,8,'2017-06-01 15:38:01','2017-06-01 15:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6834,8,'2017-06-01 15:39:01','2017-06-01 15:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6835,8,'2017-06-01 15:40:01','2017-06-01 15:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6836,8,'2017-06-01 15:41:01','2017-06-01 15:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6837,8,'2017-06-01 15:42:01','2017-06-01 15:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6838,8,'2017-06-01 15:43:01','2017-06-01 15:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6839,8,'2017-06-01 15:44:01','2017-06-01 15:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6840,8,'2017-06-01 15:45:01','2017-06-01 15:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6841,8,'2017-06-01 15:46:01','2017-06-01 15:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6842,8,'2017-06-01 15:47:01','2017-06-01 15:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6843,8,'2017-06-01 15:48:01','2017-06-01 15:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6844,8,'2017-06-01 15:49:01','2017-06-01 15:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6845,8,'2017-06-01 15:50:01','2017-06-01 15:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6846,8,'2017-06-01 15:51:01','2017-06-01 15:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6847,8,'2017-06-01 15:52:01','2017-06-01 15:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6848,8,'2017-06-01 15:53:01','2017-06-01 15:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6849,8,'2017-06-01 15:54:01','2017-06-01 15:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6850,8,'2017-06-01 15:55:01','2017-06-01 15:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6851,8,'2017-06-01 15:56:01','2017-06-01 15:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6852,8,'2017-06-01 15:57:01','2017-06-01 15:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6853,8,'2017-06-01 15:58:01','2017-06-01 15:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6854,8,'2017-06-01 15:59:01','2017-06-01 15:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6855,8,'2017-06-01 16:00:01','2017-06-01 16:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6856,8,'2017-06-01 16:01:01','2017-06-01 16:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6857,8,'2017-06-01 16:02:01','2017-06-01 16:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6858,8,'2017-06-01 16:03:01','2017-06-01 16:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6859,8,'2017-06-01 16:04:01','2017-06-01 16:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6860,8,'2017-06-01 16:05:01','2017-06-01 16:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6861,8,'2017-06-01 16:06:01','2017-06-01 16:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6862,8,'2017-06-01 16:07:01','2017-06-01 16:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6863,8,'2017-06-01 16:08:01','2017-06-01 16:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6864,8,'2017-06-01 16:09:01','2017-06-01 16:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6865,8,'2017-06-01 16:10:01','2017-06-01 16:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6866,8,'2017-06-01 16:11:01','2017-06-01 16:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6867,8,'2017-06-01 16:12:01','2017-06-01 16:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6868,8,'2017-06-01 16:13:01','2017-06-01 16:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6869,8,'2017-06-01 16:14:01','2017-06-01 16:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6870,8,'2017-06-01 16:15:01','2017-06-01 16:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6871,8,'2017-06-01 16:16:01','2017-06-01 16:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6872,8,'2017-06-01 16:17:01','2017-06-01 16:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6873,8,'2017-06-01 16:18:01','2017-06-01 16:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6874,8,'2017-06-01 16:19:01','2017-06-01 16:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6875,8,'2017-06-01 16:20:01','2017-06-01 16:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6876,8,'2017-06-01 16:21:01','2017-06-01 16:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6877,8,'2017-06-01 16:22:01','2017-06-01 16:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6878,8,'2017-06-01 16:23:01','2017-06-01 16:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6879,8,'2017-06-01 16:24:02','2017-06-01 16:24:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6880,8,'2017-06-01 16:25:01','2017-06-01 16:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6881,8,'2017-06-01 16:26:01','2017-06-01 16:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6882,8,'2017-06-01 16:27:01','2017-06-01 16:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6883,8,'2017-06-01 16:28:01','2017-06-01 16:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6884,8,'2017-06-01 16:29:01','2017-06-01 16:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6885,8,'2017-06-01 16:30:01','2017-06-01 16:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6886,8,'2017-06-01 16:31:01','2017-06-01 16:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6887,8,'2017-06-01 16:32:01','2017-06-01 16:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6888,8,'2017-06-01 16:33:01','2017-06-01 16:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6889,8,'2017-06-01 16:34:01','2017-06-01 16:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6890,8,'2017-06-01 16:35:01','2017-06-01 16:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6891,8,'2017-06-01 16:36:01','2017-06-01 16:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6892,8,'2017-06-01 16:37:01','2017-06-01 16:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6893,8,'2017-06-01 16:38:01','2017-06-01 16:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6894,8,'2017-06-01 16:39:01','2017-06-01 16:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6895,8,'2017-06-01 16:40:01','2017-06-01 16:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6896,8,'2017-06-01 16:41:01','2017-06-01 16:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6897,8,'2017-06-01 16:42:01','2017-06-01 16:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6898,8,'2017-06-01 16:43:01','2017-06-01 16:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6899,8,'2017-06-01 16:44:01','2017-06-01 16:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6900,8,'2017-06-01 16:45:01','2017-06-01 16:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6901,8,'2017-06-01 16:46:02','2017-06-01 16:46:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6902,8,'2017-06-01 16:47:01','2017-06-01 16:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6903,8,'2017-06-01 16:48:01','2017-06-01 16:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6904,8,'2017-06-01 16:49:01','2017-06-01 16:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6905,8,'2017-06-01 16:50:01','2017-06-01 16:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6906,8,'2017-06-01 16:51:01','2017-06-01 16:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6907,8,'2017-06-01 16:52:01','2017-06-01 16:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6908,8,'2017-06-01 16:53:01','2017-06-01 16:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6909,8,'2017-06-01 16:54:01','2017-06-01 16:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6910,8,'2017-06-01 16:55:01','2017-06-01 16:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6911,8,'2017-06-01 16:56:01','2017-06-01 16:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6912,8,'2017-06-01 16:57:01','2017-06-01 16:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6913,8,'2017-06-01 16:58:01','2017-06-01 16:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6914,8,'2017-06-01 16:59:01','2017-06-01 16:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6915,8,'2017-06-01 17:00:02','2017-06-01 17:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6916,8,'2017-06-01 17:01:01','2017-06-01 17:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6917,8,'2017-06-01 17:02:01','2017-06-01 17:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6918,8,'2017-06-01 17:03:01','2017-06-01 17:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6919,8,'2017-06-01 17:04:01','2017-06-01 17:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6920,8,'2017-06-01 17:05:01','2017-06-01 17:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6921,8,'2017-06-01 17:06:01','2017-06-01 17:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6922,8,'2017-06-01 17:07:01','2017-06-01 17:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6923,8,'2017-06-01 17:08:01','2017-06-01 17:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6924,8,'2017-06-01 17:09:01','2017-06-01 17:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6925,8,'2017-06-01 17:10:01','2017-06-01 17:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6926,8,'2017-06-01 17:11:01','2017-06-01 17:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6927,8,'2017-06-01 17:12:01','2017-06-01 17:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6928,8,'2017-06-01 17:13:01','2017-06-01 17:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6929,8,'2017-06-01 17:14:01','2017-06-01 17:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6930,8,'2017-06-01 17:15:01','2017-06-01 17:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6931,8,'2017-06-01 17:16:01','2017-06-01 17:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6932,8,'2017-06-01 17:17:01','2017-06-01 17:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6933,8,'2017-06-01 17:18:01','2017-06-01 17:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6934,8,'2017-06-01 17:19:01','2017-06-01 17:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6935,8,'2017-06-01 17:20:01','2017-06-01 17:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6936,8,'2017-06-01 17:21:01','2017-06-01 17:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6937,8,'2017-06-01 17:22:01','2017-06-01 17:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6938,8,'2017-06-01 17:23:01','2017-06-01 17:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6939,8,'2017-06-01 17:24:01','2017-06-01 17:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6940,8,'2017-06-01 17:25:01','2017-06-01 17:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6941,8,'2017-06-01 17:26:01','2017-06-01 17:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6942,8,'2017-06-01 17:27:01','2017-06-01 17:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6943,8,'2017-06-01 17:28:01','2017-06-01 17:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6944,8,'2017-06-01 17:29:01','2017-06-01 17:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6945,8,'2017-06-01 17:30:01','2017-06-01 17:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6946,8,'2017-06-01 17:31:01','2017-06-01 17:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6947,8,'2017-06-01 17:32:01','2017-06-01 17:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6948,8,'2017-06-01 17:33:01','2017-06-01 17:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6949,8,'2017-06-01 17:34:01','2017-06-01 17:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6950,8,'2017-06-01 17:35:01','2017-06-01 17:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6951,8,'2017-06-01 17:36:01','2017-06-01 17:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6952,8,'2017-06-01 17:37:01','2017-06-01 17:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6953,8,'2017-06-01 17:38:01','2017-06-01 17:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6954,8,'2017-06-01 17:39:02','2017-06-01 17:39:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6955,8,'2017-06-01 17:40:01','2017-06-01 17:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6956,8,'2017-06-01 17:41:01','2017-06-01 17:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6957,8,'2017-06-01 17:42:01','2017-06-01 17:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6958,8,'2017-06-01 17:43:02','2017-06-01 17:43:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6959,8,'2017-06-01 17:44:01','2017-06-01 17:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6960,8,'2017-06-01 17:45:01','2017-06-01 17:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6961,8,'2017-06-01 17:46:01','2017-06-01 17:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6962,8,'2017-06-01 17:47:01','2017-06-01 17:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6963,8,'2017-06-01 17:48:01','2017-06-01 17:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6964,8,'2017-06-01 17:49:01','2017-06-01 17:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6965,8,'2017-06-01 17:50:01','2017-06-01 17:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6966,8,'2017-06-01 17:51:01','2017-06-01 17:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6967,8,'2017-06-01 17:52:01','2017-06-01 17:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6968,8,'2017-06-01 17:53:01','2017-06-01 17:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6969,8,'2017-06-01 17:54:01','2017-06-01 17:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6970,8,'2017-06-01 17:55:02','2017-06-01 17:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6971,8,'2017-06-01 17:56:01','2017-06-01 17:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6972,8,'2017-06-01 17:57:01','2017-06-01 17:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6973,8,'2017-06-01 17:58:01','2017-06-01 17:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6974,8,'2017-06-01 17:59:01','2017-06-01 17:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6975,8,'2017-06-01 18:00:01','2017-06-01 18:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6976,8,'2017-06-01 18:01:02','2017-06-01 18:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6977,8,'2017-06-01 18:02:01','2017-06-01 18:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6978,8,'2017-06-01 18:03:01','2017-06-01 18:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6979,8,'2017-06-01 18:04:01','2017-06-01 18:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6980,8,'2017-06-01 18:05:01','2017-06-01 18:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6981,8,'2017-06-01 18:06:01','2017-06-01 18:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6982,8,'2017-06-01 18:07:01','2017-06-01 18:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6983,8,'2017-06-01 18:08:01','2017-06-01 18:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6984,8,'2017-06-01 18:09:01','2017-06-01 18:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6985,8,'2017-06-01 18:10:01','2017-06-01 18:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6986,8,'2017-06-01 18:11:01','2017-06-01 18:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6987,8,'2017-06-01 18:12:01','2017-06-01 18:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6988,8,'2017-06-01 18:13:01','2017-06-01 18:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6989,8,'2017-06-01 18:14:01','2017-06-01 18:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6990,8,'2017-06-01 18:15:01','2017-06-01 18:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6991,8,'2017-06-01 18:16:01','2017-06-01 18:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6992,8,'2017-06-01 18:17:01','2017-06-01 18:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6993,8,'2017-06-01 18:18:01','2017-06-01 18:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6994,8,'2017-06-01 18:19:01','2017-06-01 18:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6995,8,'2017-06-01 18:20:01','2017-06-01 18:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6996,8,'2017-06-01 18:21:01','2017-06-01 18:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6997,8,'2017-06-01 18:22:01','2017-06-01 18:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6998,8,'2017-06-01 18:23:01','2017-06-01 18:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(6999,8,'2017-06-01 18:24:01','2017-06-01 18:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7000,8,'2017-06-01 18:25:01','2017-06-01 18:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7001,8,'2017-06-01 18:26:01','2017-06-01 18:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7002,8,'2017-06-01 18:27:01','2017-06-01 18:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7003,8,'2017-06-01 18:28:01','2017-06-01 18:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7004,8,'2017-06-01 18:29:01','2017-06-01 18:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7005,8,'2017-06-01 18:30:02','2017-06-01 18:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7006,8,'2017-06-01 18:31:01','2017-06-01 18:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7007,8,'2017-06-01 18:32:01','2017-06-01 18:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7008,8,'2017-06-01 18:33:01','2017-06-01 18:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7009,8,'2017-06-01 18:34:02','2017-06-01 18:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7010,8,'2017-06-01 18:35:01','2017-06-01 18:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7011,8,'2017-06-01 18:36:01','2017-06-01 18:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7012,8,'2017-06-01 18:37:01','2017-06-01 18:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7013,8,'2017-06-01 18:38:01','2017-06-01 18:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7014,8,'2017-06-01 18:39:01','2017-06-01 18:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7015,8,'2017-06-01 18:40:01','2017-06-01 18:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7016,8,'2017-06-01 18:41:01','2017-06-01 18:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7017,8,'2017-06-01 18:42:01','2017-06-01 18:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7018,8,'2017-06-01 18:43:01','2017-06-01 18:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7019,8,'2017-06-01 18:44:01','2017-06-01 18:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7020,8,'2017-06-01 18:45:01','2017-06-01 18:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7021,8,'2017-06-01 18:46:01','2017-06-01 18:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7022,8,'2017-06-01 18:47:01','2017-06-01 18:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7023,8,'2017-06-01 18:48:01','2017-06-01 18:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7024,8,'2017-06-01 18:49:01','2017-06-01 18:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7025,8,'2017-06-01 18:50:01','2017-06-01 18:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7026,8,'2017-06-01 18:51:01','2017-06-01 18:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7027,8,'2017-06-01 18:52:01','2017-06-01 18:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7028,8,'2017-06-01 18:53:01','2017-06-01 18:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7029,8,'2017-06-01 18:54:01','2017-06-01 18:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7030,8,'2017-06-01 18:55:01','2017-06-01 18:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7031,8,'2017-06-01 18:56:01','2017-06-01 18:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7032,8,'2017-06-01 18:57:02','2017-06-01 18:57:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7033,8,'2017-06-01 18:58:01','2017-06-01 18:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7034,8,'2017-06-01 18:59:01','2017-06-01 18:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7035,8,'2017-06-01 19:00:01','2017-06-01 19:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7036,8,'2017-06-01 19:01:01','2017-06-01 19:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7037,8,'2017-06-01 19:02:01','2017-06-01 19:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7038,8,'2017-06-01 19:03:01','2017-06-01 19:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7039,8,'2017-06-01 19:04:01','2017-06-01 19:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7040,8,'2017-06-01 19:05:01','2017-06-01 19:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7041,8,'2017-06-01 19:06:01','2017-06-01 19:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7042,8,'2017-06-01 19:07:01','2017-06-01 19:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7043,8,'2017-06-01 19:08:01','2017-06-01 19:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7044,8,'2017-06-01 19:09:01','2017-06-01 19:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7045,8,'2017-06-01 19:10:01','2017-06-01 19:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7046,8,'2017-06-01 19:11:01','2017-06-01 19:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7047,8,'2017-06-01 19:12:02','2017-06-01 19:12:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7048,8,'2017-06-01 19:13:01','2017-06-01 19:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7049,8,'2017-06-01 19:14:01','2017-06-01 19:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7050,8,'2017-06-01 19:15:01','2017-06-01 19:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7051,8,'2017-06-01 19:16:01','2017-06-01 19:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7052,8,'2017-06-01 19:17:01','2017-06-01 19:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7053,8,'2017-06-01 19:18:01','2017-06-01 19:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7054,8,'2017-06-01 19:19:01','2017-06-01 19:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7055,8,'2017-06-01 19:20:02','2017-06-01 19:20:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7056,8,'2017-06-01 19:21:01','2017-06-01 19:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7057,8,'2017-06-01 19:22:01','2017-06-01 19:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7058,8,'2017-06-01 19:23:01','2017-06-01 19:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7059,8,'2017-06-01 19:24:01','2017-06-01 19:24:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7060,8,'2017-06-01 19:25:01','2017-06-01 19:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7061,8,'2017-06-01 19:26:01','2017-06-01 19:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7062,8,'2017-06-01 19:27:01','2017-06-01 19:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7063,8,'2017-06-01 19:28:02','2017-06-01 19:28:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7064,8,'2017-06-01 19:29:01','2017-06-01 19:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7065,8,'2017-06-01 19:30:01','2017-06-01 19:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7066,8,'2017-06-01 19:31:01','2017-06-01 19:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7067,8,'2017-06-01 19:32:01','2017-06-01 19:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7068,8,'2017-06-01 19:33:01','2017-06-01 19:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7069,8,'2017-06-01 19:34:01','2017-06-01 19:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7070,8,'2017-06-01 19:35:01','2017-06-01 19:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7071,8,'2017-06-01 19:36:01','2017-06-01 19:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7072,8,'2017-06-01 19:37:01','2017-06-01 19:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7073,8,'2017-06-01 19:38:01','2017-06-01 19:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7074,8,'2017-06-01 19:39:01','2017-06-01 19:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7075,8,'2017-06-01 19:40:01','2017-06-01 19:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7076,8,'2017-06-01 19:41:01','2017-06-01 19:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7077,8,'2017-06-01 19:42:01','2017-06-01 19:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7078,8,'2017-06-01 19:43:01','2017-06-01 19:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7079,8,'2017-06-01 19:44:01','2017-06-01 19:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7080,8,'2017-06-01 19:45:01','2017-06-01 19:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7081,8,'2017-06-01 19:46:01','2017-06-01 19:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7082,8,'2017-06-01 19:47:01','2017-06-01 19:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7083,8,'2017-06-01 19:48:01','2017-06-01 19:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7084,8,'2017-06-01 19:49:01','2017-06-01 19:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7085,8,'2017-06-01 19:50:01','2017-06-01 19:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7086,8,'2017-06-01 19:51:01','2017-06-01 19:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7087,8,'2017-06-01 19:52:01','2017-06-01 19:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7088,8,'2017-06-01 19:53:01','2017-06-01 19:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7089,8,'2017-06-01 19:54:01','2017-06-01 19:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7090,8,'2017-06-01 19:55:01','2017-06-01 19:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7091,8,'2017-06-01 19:56:01','2017-06-01 19:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7092,8,'2017-06-01 19:57:01','2017-06-01 19:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7093,8,'2017-06-01 19:58:01','2017-06-01 19:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7094,8,'2017-06-01 19:59:01','2017-06-01 19:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7095,8,'2017-06-01 20:00:01','2017-06-01 20:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7096,8,'2017-06-01 20:01:01','2017-06-01 20:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7097,8,'2017-06-01 20:02:01','2017-06-01 20:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7098,8,'2017-06-01 20:03:01','2017-06-01 20:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7099,8,'2017-06-01 20:04:02','2017-06-01 20:04:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7100,8,'2017-06-01 20:05:01','2017-06-01 20:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7101,8,'2017-06-01 20:06:01','2017-06-01 20:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7102,8,'2017-06-01 20:07:01','2017-06-01 20:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7103,8,'2017-06-01 20:08:01','2017-06-01 20:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7104,8,'2017-06-01 20:09:01','2017-06-01 20:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7105,8,'2017-06-01 20:10:01','2017-06-01 20:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7106,8,'2017-06-01 20:11:01','2017-06-01 20:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7107,8,'2017-06-01 20:12:01','2017-06-01 20:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7108,8,'2017-06-01 20:13:01','2017-06-01 20:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7109,8,'2017-06-01 20:14:01','2017-06-01 20:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7110,8,'2017-06-01 20:15:01','2017-06-01 20:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7111,8,'2017-06-01 20:16:01','2017-06-01 20:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7112,8,'2017-06-01 20:17:01','2017-06-01 20:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7113,8,'2017-06-01 20:18:01','2017-06-01 20:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7114,8,'2017-06-01 20:19:01','2017-06-01 20:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7115,8,'2017-06-01 20:20:01','2017-06-01 20:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7116,8,'2017-06-01 20:21:01','2017-06-01 20:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7117,8,'2017-06-01 20:22:01','2017-06-01 20:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7118,8,'2017-06-01 20:23:01','2017-06-01 20:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7119,8,'2017-06-01 20:24:01','2017-06-01 20:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7120,8,'2017-06-01 20:25:01','2017-06-01 20:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7121,8,'2017-06-01 20:26:01','2017-06-01 20:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7122,8,'2017-06-01 20:27:01','2017-06-01 20:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7123,8,'2017-06-01 20:28:01','2017-06-01 20:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7124,8,'2017-06-01 20:29:01','2017-06-01 20:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7125,8,'2017-06-01 20:30:01','2017-06-01 20:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7126,8,'2017-06-01 20:31:01','2017-06-01 20:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7127,8,'2017-06-01 20:32:01','2017-06-01 20:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7128,8,'2017-06-01 20:33:02','2017-06-01 20:33:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7129,8,'2017-06-01 20:34:01','2017-06-01 20:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7130,8,'2017-06-01 20:35:01','2017-06-01 20:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7131,8,'2017-06-01 20:36:01','2017-06-01 20:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7132,8,'2017-06-01 20:37:01','2017-06-01 20:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7133,8,'2017-06-01 20:38:01','2017-06-01 20:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7134,8,'2017-06-01 20:39:01','2017-06-01 20:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7135,8,'2017-06-01 20:40:01','2017-06-01 20:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7136,8,'2017-06-01 20:41:01','2017-06-01 20:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7137,8,'2017-06-01 20:42:01','2017-06-01 20:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7138,8,'2017-06-01 20:43:01','2017-06-01 20:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7139,8,'2017-06-01 20:44:01','2017-06-01 20:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7140,8,'2017-06-01 20:45:01','2017-06-01 20:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7141,8,'2017-06-01 20:46:01','2017-06-01 20:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7142,8,'2017-06-01 20:47:01','2017-06-01 20:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7143,8,'2017-06-01 20:48:01','2017-06-01 20:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7144,8,'2017-06-01 20:49:01','2017-06-01 20:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7145,8,'2017-06-01 20:50:01','2017-06-01 20:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7146,8,'2017-06-01 20:51:01','2017-06-01 20:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7147,8,'2017-06-01 20:52:01','2017-06-01 20:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7148,8,'2017-06-01 20:53:01','2017-06-01 20:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7149,8,'2017-06-01 20:54:01','2017-06-01 20:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7150,8,'2017-06-01 20:55:01','2017-06-01 20:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7151,8,'2017-06-01 20:56:01','2017-06-01 20:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7152,8,'2017-06-01 20:57:01','2017-06-01 20:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7153,8,'2017-06-01 20:58:01','2017-06-01 20:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7154,8,'2017-06-01 20:59:01','2017-06-01 20:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7155,8,'2017-06-01 21:00:01','2017-06-01 21:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7156,8,'2017-06-01 21:01:01','2017-06-01 21:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7157,8,'2017-06-01 21:02:01','2017-06-01 21:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7158,8,'2017-06-01 21:03:01','2017-06-01 21:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7159,8,'2017-06-01 21:04:01','2017-06-01 21:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7160,8,'2017-06-01 21:05:01','2017-06-01 21:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7161,8,'2017-06-01 21:06:01','2017-06-01 21:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7162,8,'2017-06-01 21:07:01','2017-06-01 21:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7163,8,'2017-06-01 21:08:01','2017-06-01 21:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7164,8,'2017-06-01 21:09:01','2017-06-01 21:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7165,8,'2017-06-01 21:10:01','2017-06-01 21:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7166,8,'2017-06-01 21:11:01','2017-06-01 21:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7167,8,'2017-06-01 21:12:01','2017-06-01 21:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7168,8,'2017-06-01 21:13:01','2017-06-01 21:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7169,8,'2017-06-01 21:14:01','2017-06-01 21:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7170,8,'2017-06-01 21:15:01','2017-06-01 21:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7171,8,'2017-06-01 21:16:01','2017-06-01 21:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7172,8,'2017-06-01 21:17:01','2017-06-01 21:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7173,8,'2017-06-01 21:18:01','2017-06-01 21:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7174,8,'2017-06-01 21:19:02','2017-06-01 21:19:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7175,8,'2017-06-01 21:20:01','2017-06-01 21:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7176,8,'2017-06-01 21:21:01','2017-06-01 21:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7177,8,'2017-06-01 21:22:01','2017-06-01 21:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7178,8,'2017-06-01 21:23:01','2017-06-01 21:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7179,8,'2017-06-01 21:24:01','2017-06-01 21:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7180,8,'2017-06-01 21:25:01','2017-06-01 21:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7181,8,'2017-06-01 21:26:01','2017-06-01 21:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7182,8,'2017-06-01 21:27:01','2017-06-01 21:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7183,8,'2017-06-01 21:28:01','2017-06-01 21:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7184,8,'2017-06-01 21:29:02','2017-06-01 21:29:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7185,8,'2017-06-01 21:30:01','2017-06-01 21:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7186,8,'2017-06-01 21:31:01','2017-06-01 21:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7187,8,'2017-06-01 21:32:01','2017-06-01 21:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7188,8,'2017-06-01 21:33:01','2017-06-01 21:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7189,8,'2017-06-01 21:34:01','2017-06-01 21:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7190,8,'2017-06-01 21:35:01','2017-06-01 21:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7191,8,'2017-06-01 21:36:01','2017-06-01 21:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7192,8,'2017-06-01 21:37:01','2017-06-01 21:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7193,8,'2017-06-01 21:38:01','2017-06-01 21:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7194,8,'2017-06-01 21:39:01','2017-06-01 21:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7195,8,'2017-06-01 21:40:01','2017-06-01 21:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7196,8,'2017-06-01 21:41:01','2017-06-01 21:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7197,8,'2017-06-01 21:42:01','2017-06-01 21:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7198,8,'2017-06-01 21:43:01','2017-06-01 21:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7199,8,'2017-06-01 21:44:01','2017-06-01 21:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7200,8,'2017-06-01 21:45:01','2017-06-01 21:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7201,8,'2017-06-01 21:46:01','2017-06-01 21:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7202,8,'2017-06-01 21:47:01','2017-06-01 21:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7203,8,'2017-06-01 21:48:01','2017-06-01 21:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7204,8,'2017-06-01 21:49:01','2017-06-01 21:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7205,8,'2017-06-01 21:50:01','2017-06-01 21:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7206,8,'2017-06-01 21:51:01','2017-06-01 21:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7207,8,'2017-06-01 21:52:01','2017-06-01 21:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7208,8,'2017-06-01 21:53:01','2017-06-01 21:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7209,8,'2017-06-01 21:54:01','2017-06-01 21:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7210,8,'2017-06-01 21:55:01','2017-06-01 21:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7211,8,'2017-06-01 21:56:01','2017-06-01 21:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7212,8,'2017-06-01 21:57:01','2017-06-01 21:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7213,8,'2017-06-01 21:58:01','2017-06-01 21:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7214,8,'2017-06-01 21:59:01','2017-06-01 21:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7215,8,'2017-06-01 22:00:01','2017-06-01 22:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7216,8,'2017-06-01 22:01:02','2017-06-01 22:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7217,8,'2017-06-01 22:02:01','2017-06-01 22:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7218,8,'2017-06-01 22:03:01','2017-06-01 22:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7219,8,'2017-06-01 22:04:01','2017-06-01 22:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7220,8,'2017-06-01 22:05:01','2017-06-01 22:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7221,8,'2017-06-01 22:06:01','2017-06-01 22:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7222,8,'2017-06-01 22:07:01','2017-06-01 22:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7223,8,'2017-06-01 22:08:01','2017-06-01 22:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7224,8,'2017-06-01 22:09:01','2017-06-01 22:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7225,8,'2017-06-01 22:10:01','2017-06-01 22:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7226,8,'2017-06-01 22:11:01','2017-06-01 22:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7227,8,'2017-06-01 22:12:01','2017-06-01 22:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7228,8,'2017-06-01 22:13:01','2017-06-01 22:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7229,8,'2017-06-01 22:14:01','2017-06-01 22:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7230,8,'2017-06-01 22:15:01','2017-06-01 22:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7231,8,'2017-06-01 22:16:01','2017-06-01 22:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7232,8,'2017-06-01 22:17:01','2017-06-01 22:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7233,8,'2017-06-01 22:18:01','2017-06-01 22:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7234,8,'2017-06-01 22:19:01','2017-06-01 22:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7235,8,'2017-06-01 22:20:01','2017-06-01 22:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7236,8,'2017-06-01 22:21:01','2017-06-01 22:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7237,8,'2017-06-01 22:22:01','2017-06-01 22:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7238,8,'2017-06-01 22:23:01','2017-06-01 22:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7239,8,'2017-06-01 22:24:01','2017-06-01 22:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7240,8,'2017-06-01 22:25:01','2017-06-01 22:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7241,8,'2017-06-01 22:26:02','2017-06-01 22:26:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7242,8,'2017-06-01 22:27:01','2017-06-01 22:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7243,8,'2017-06-01 22:28:01','2017-06-01 22:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7244,8,'2017-06-01 22:29:01','2017-06-01 22:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7245,8,'2017-06-01 22:30:01','2017-06-01 22:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7246,8,'2017-06-01 22:31:02','2017-06-01 22:31:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7247,8,'2017-06-01 22:32:01','2017-06-01 22:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7248,8,'2017-06-01 22:33:01','2017-06-01 22:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7249,8,'2017-06-01 22:34:01','2017-06-01 22:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7250,8,'2017-06-01 22:35:01','2017-06-01 22:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7251,8,'2017-06-01 22:36:01','2017-06-01 22:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7252,8,'2017-06-01 22:37:01','2017-06-01 22:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7253,8,'2017-06-01 22:38:01','2017-06-01 22:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7254,8,'2017-06-01 22:39:01','2017-06-01 22:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7255,8,'2017-06-01 22:40:01','2017-06-01 22:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7256,8,'2017-06-01 22:41:01','2017-06-01 22:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7257,8,'2017-06-01 22:42:01','2017-06-01 22:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7258,8,'2017-06-01 22:43:01','2017-06-01 22:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7259,8,'2017-06-01 22:44:01','2017-06-01 22:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7260,8,'2017-06-01 22:45:01','2017-06-01 22:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7261,8,'2017-06-01 22:46:01','2017-06-01 22:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7262,8,'2017-06-01 22:47:01','2017-06-01 22:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7263,8,'2017-06-01 22:48:01','2017-06-01 22:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7264,8,'2017-06-01 22:49:01','2017-06-01 22:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7265,8,'2017-06-01 22:50:01','2017-06-01 22:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7266,8,'2017-06-01 22:51:01','2017-06-01 22:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7267,8,'2017-06-01 22:52:01','2017-06-01 22:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7268,8,'2017-06-01 22:53:02','2017-06-01 22:53:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7269,8,'2017-06-01 22:54:01','2017-06-01 22:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7270,8,'2017-06-01 22:55:01','2017-06-01 22:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7271,8,'2017-06-01 22:56:01','2017-06-01 22:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7272,8,'2017-06-01 22:57:01','2017-06-01 22:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7273,8,'2017-06-01 22:58:01','2017-06-01 22:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7274,8,'2017-06-01 22:59:01','2017-06-01 22:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7275,8,'2017-06-01 23:00:02','2017-06-01 23:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7276,8,'2017-06-01 23:01:01','2017-06-01 23:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7277,8,'2017-06-01 23:02:01','2017-06-01 23:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7278,8,'2017-06-01 23:03:01','2017-06-01 23:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7279,8,'2017-06-01 23:04:01','2017-06-01 23:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7280,8,'2017-06-01 23:05:01','2017-06-01 23:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7281,8,'2017-06-01 23:06:01','2017-06-01 23:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7282,8,'2017-06-01 23:07:01','2017-06-01 23:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7283,8,'2017-06-01 23:08:01','2017-06-01 23:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7284,8,'2017-06-01 23:09:01','2017-06-01 23:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7285,8,'2017-06-01 23:10:01','2017-06-01 23:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7286,8,'2017-06-01 23:11:01','2017-06-01 23:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7287,8,'2017-06-01 23:12:01','2017-06-01 23:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7288,8,'2017-06-01 23:13:01','2017-06-01 23:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7289,8,'2017-06-01 23:14:01','2017-06-01 23:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7290,8,'2017-06-01 23:15:01','2017-06-01 23:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7291,8,'2017-06-01 23:16:01','2017-06-01 23:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7292,8,'2017-06-01 23:17:01','2017-06-01 23:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7293,8,'2017-06-01 23:18:02','2017-06-01 23:18:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7294,8,'2017-06-01 23:19:01','2017-06-01 23:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7295,8,'2017-06-01 23:20:01','2017-06-01 23:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7296,8,'2017-06-01 23:21:01','2017-06-01 23:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7297,8,'2017-06-01 23:22:01','2017-06-01 23:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7298,8,'2017-06-01 23:23:01','2017-06-01 23:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7299,8,'2017-06-01 23:24:01','2017-06-01 23:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7300,8,'2017-06-01 23:25:01','2017-06-01 23:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7301,8,'2017-06-01 23:26:01','2017-06-01 23:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7302,8,'2017-06-01 23:27:01','2017-06-01 23:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7303,8,'2017-06-01 23:28:02','2017-06-01 23:28:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7304,8,'2017-06-01 23:29:01','2017-06-01 23:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7305,8,'2017-06-01 23:30:01','2017-06-01 23:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7306,8,'2017-06-01 23:31:01','2017-06-01 23:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7307,8,'2017-06-01 23:32:01','2017-06-01 23:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7308,8,'2017-06-01 23:33:01','2017-06-01 23:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7309,8,'2017-06-01 23:34:01','2017-06-01 23:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7310,8,'2017-06-01 23:35:02','2017-06-01 23:35:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7311,8,'2017-06-01 23:36:01','2017-06-01 23:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7312,8,'2017-06-01 23:37:01','2017-06-01 23:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7313,8,'2017-06-01 23:38:01','2017-06-01 23:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7314,8,'2017-06-01 23:39:01','2017-06-01 23:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7315,8,'2017-06-01 23:40:02','2017-06-01 23:40:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7316,8,'2017-06-01 23:41:01','2017-06-01 23:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7317,8,'2017-06-01 23:42:01','2017-06-01 23:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7318,8,'2017-06-01 23:43:01','2017-06-01 23:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7319,8,'2017-06-01 23:44:01','2017-06-01 23:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7320,8,'2017-06-01 23:45:01','2017-06-01 23:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7321,8,'2017-06-01 23:46:01','2017-06-01 23:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7322,8,'2017-06-01 23:47:01','2017-06-01 23:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7323,8,'2017-06-01 23:48:01','2017-06-01 23:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7324,8,'2017-06-01 23:49:01','2017-06-01 23:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7325,8,'2017-06-01 23:50:01','2017-06-01 23:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7326,8,'2017-06-01 23:51:01','2017-06-01 23:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7327,8,'2017-06-01 23:52:01','2017-06-01 23:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7328,8,'2017-06-01 23:53:01','2017-06-01 23:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7329,8,'2017-06-01 23:54:01','2017-06-01 23:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7330,8,'2017-06-01 23:55:01','2017-06-01 23:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7331,8,'2017-06-01 23:56:01','2017-06-01 23:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7332,8,'2017-06-01 23:57:01','2017-06-01 23:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7333,8,'2017-06-01 23:58:01','2017-06-01 23:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7334,8,'2017-06-01 23:59:01','2017-06-01 23:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7335,8,'2017-06-02 00:00:01','2017-06-02 00:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7336,8,'2017-06-02 00:01:01','2017-06-02 00:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7337,8,'2017-06-02 00:02:01','2017-06-02 00:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7338,8,'2017-06-02 00:03:01','2017-06-02 00:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7339,8,'2017-06-02 00:04:01','2017-06-02 00:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7340,8,'2017-06-02 00:05:01','2017-06-02 00:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7341,8,'2017-06-02 00:06:02','2017-06-02 00:06:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7342,8,'2017-06-02 00:07:01','2017-06-02 00:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7343,8,'2017-06-02 00:08:01','2017-06-02 00:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7344,8,'2017-06-02 00:09:01','2017-06-02 00:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7345,8,'2017-06-02 00:10:01','2017-06-02 00:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7346,8,'2017-06-02 00:11:01','2017-06-02 00:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7347,8,'2017-06-02 00:12:01','2017-06-02 00:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7348,8,'2017-06-02 00:13:01','2017-06-02 00:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7349,8,'2017-06-02 00:14:01','2017-06-02 00:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7350,8,'2017-06-02 00:15:01','2017-06-02 00:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7351,8,'2017-06-02 00:16:01','2017-06-02 00:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7352,8,'2017-06-02 00:17:01','2017-06-02 00:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7353,8,'2017-06-02 00:18:01','2017-06-02 00:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7354,8,'2017-06-02 00:19:01','2017-06-02 00:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7355,8,'2017-06-02 00:20:01','2017-06-02 00:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7356,8,'2017-06-02 00:21:01','2017-06-02 00:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7357,8,'2017-06-02 00:22:01','2017-06-02 00:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7358,8,'2017-06-02 00:23:01','2017-06-02 00:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7359,8,'2017-06-02 00:24:01','2017-06-02 00:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7360,8,'2017-06-02 00:25:01','2017-06-02 00:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7361,8,'2017-06-02 00:26:01','2017-06-02 00:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7362,8,'2017-06-02 00:27:01','2017-06-02 00:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7363,8,'2017-06-02 00:28:01','2017-06-02 00:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7364,8,'2017-06-02 00:29:01','2017-06-02 00:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7365,8,'2017-06-02 00:30:01','2017-06-02 00:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7366,8,'2017-06-02 00:31:01','2017-06-02 00:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7367,8,'2017-06-02 00:32:01','2017-06-02 00:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7368,8,'2017-06-02 00:33:01','2017-06-02 00:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7369,8,'2017-06-02 00:34:01','2017-06-02 00:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7370,8,'2017-06-02 00:35:01','2017-06-02 00:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7371,8,'2017-06-02 00:36:01','2017-06-02 00:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7372,8,'2017-06-02 00:37:01','2017-06-02 00:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7373,8,'2017-06-02 00:38:01','2017-06-02 00:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7374,8,'2017-06-02 00:39:01','2017-06-02 00:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7375,8,'2017-06-02 00:40:01','2017-06-02 00:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7376,8,'2017-06-02 00:41:01','2017-06-02 00:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7377,8,'2017-06-02 00:42:01','2017-06-02 00:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7378,8,'2017-06-02 00:43:01','2017-06-02 00:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7379,8,'2017-06-02 00:44:01','2017-06-02 00:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7380,8,'2017-06-02 00:45:01','2017-06-02 00:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7381,8,'2017-06-02 00:46:01','2017-06-02 00:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7382,8,'2017-06-02 00:47:01','2017-06-02 00:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7383,8,'2017-06-02 00:48:01','2017-06-02 00:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7384,8,'2017-06-02 00:49:01','2017-06-02 00:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7385,8,'2017-06-02 00:50:01','2017-06-02 00:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7386,8,'2017-06-02 00:51:01','2017-06-02 00:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7387,8,'2017-06-02 00:52:01','2017-06-02 00:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7388,8,'2017-06-02 00:53:01','2017-06-02 00:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7389,8,'2017-06-02 00:54:01','2017-06-02 00:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7390,8,'2017-06-02 00:55:01','2017-06-02 00:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7391,8,'2017-06-02 00:56:01','2017-06-02 00:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7392,8,'2017-06-02 00:57:01','2017-06-02 00:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7393,8,'2017-06-02 00:58:01','2017-06-02 00:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7394,8,'2017-06-02 00:59:01','2017-06-02 00:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7395,8,'2017-06-02 01:00:01','2017-06-02 01:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7396,8,'2017-06-02 01:01:01','2017-06-02 01:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7397,8,'2017-06-02 01:02:01','2017-06-02 01:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7398,8,'2017-06-02 01:03:02','2017-06-02 01:03:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7399,8,'2017-06-02 01:04:01','2017-06-02 01:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7400,8,'2017-06-02 01:05:01','2017-06-02 01:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7401,8,'2017-06-02 01:06:01','2017-06-02 01:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7402,8,'2017-06-02 01:07:01','2017-06-02 01:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7403,8,'2017-06-02 01:08:01','2017-06-02 01:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7404,8,'2017-06-02 01:09:01','2017-06-02 01:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7405,8,'2017-06-02 01:10:01','2017-06-02 01:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7406,8,'2017-06-02 01:11:01','2017-06-02 01:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7407,8,'2017-06-02 01:12:01','2017-06-02 01:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7408,8,'2017-06-02 01:13:01','2017-06-02 01:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7409,8,'2017-06-02 01:14:01','2017-06-02 01:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7410,8,'2017-06-02 01:15:01','2017-06-02 01:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7411,8,'2017-06-02 01:16:01','2017-06-02 01:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7412,8,'2017-06-02 01:17:01','2017-06-02 01:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7413,8,'2017-06-02 01:18:01','2017-06-02 01:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7414,8,'2017-06-02 01:19:01','2017-06-02 01:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7415,8,'2017-06-02 01:20:01','2017-06-02 01:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7416,8,'2017-06-02 01:21:01','2017-06-02 01:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7417,8,'2017-06-02 01:22:02','2017-06-02 01:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7418,8,'2017-06-02 01:23:01','2017-06-02 01:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7419,8,'2017-06-02 01:24:01','2017-06-02 01:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7420,8,'2017-06-02 01:25:01','2017-06-02 01:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7421,8,'2017-06-02 01:26:01','2017-06-02 01:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7422,8,'2017-06-02 01:27:01','2017-06-02 01:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7423,8,'2017-06-02 01:28:02','2017-06-02 01:28:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7424,8,'2017-06-02 01:29:01','2017-06-02 01:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7425,8,'2017-06-02 01:30:01','2017-06-02 01:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7426,8,'2017-06-02 01:31:02','2017-06-02 01:31:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7427,8,'2017-06-02 01:32:01','2017-06-02 01:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7428,8,'2017-06-02 01:33:01','2017-06-02 01:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7429,8,'2017-06-02 01:34:01','2017-06-02 01:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7430,8,'2017-06-02 01:35:01','2017-06-02 01:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7431,8,'2017-06-02 01:36:01','2017-06-02 01:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7432,8,'2017-06-02 01:37:01','2017-06-02 01:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7433,8,'2017-06-02 01:38:01','2017-06-02 01:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7434,8,'2017-06-02 01:39:01','2017-06-02 01:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7435,8,'2017-06-02 01:40:01','2017-06-02 01:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7436,8,'2017-06-02 01:41:01','2017-06-02 01:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7437,8,'2017-06-02 01:42:01','2017-06-02 01:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7438,8,'2017-06-02 01:43:01','2017-06-02 01:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7439,8,'2017-06-02 01:44:01','2017-06-02 01:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7440,8,'2017-06-02 01:45:01','2017-06-02 01:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7441,8,'2017-06-02 01:46:01','2017-06-02 01:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7442,8,'2017-06-02 01:47:01','2017-06-02 01:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7443,8,'2017-06-02 01:48:01','2017-06-02 01:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7444,8,'2017-06-02 01:49:01','2017-06-02 01:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7445,8,'2017-06-02 01:50:01','2017-06-02 01:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7446,8,'2017-06-02 01:51:01','2017-06-02 01:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7447,8,'2017-06-02 01:52:01','2017-06-02 01:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7448,8,'2017-06-02 01:53:01','2017-06-02 01:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7449,8,'2017-06-02 01:54:01','2017-06-02 01:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7450,8,'2017-06-02 01:55:01','2017-06-02 01:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7451,8,'2017-06-02 01:56:01','2017-06-02 01:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7452,8,'2017-06-02 01:57:01','2017-06-02 01:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7453,8,'2017-06-02 01:58:01','2017-06-02 01:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7454,8,'2017-06-02 01:59:02','2017-06-02 01:59:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7455,8,'2017-06-02 02:00:01','2017-06-02 02:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7456,8,'2017-06-02 02:01:01','2017-06-02 02:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7457,8,'2017-06-02 02:02:01','2017-06-02 02:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7458,8,'2017-06-02 02:03:01','2017-06-02 02:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7459,8,'2017-06-02 02:04:01','2017-06-02 02:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7460,8,'2017-06-02 02:05:01','2017-06-02 02:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7461,8,'2017-06-02 02:06:01','2017-06-02 02:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7462,8,'2017-06-02 02:07:01','2017-06-02 02:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7463,8,'2017-06-02 02:08:01','2017-06-02 02:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7464,8,'2017-06-02 02:09:01','2017-06-02 02:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7465,8,'2017-06-02 02:10:01','2017-06-02 02:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7466,8,'2017-06-02 02:11:01','2017-06-02 02:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7467,8,'2017-06-02 02:12:01','2017-06-02 02:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7468,8,'2017-06-02 02:13:01','2017-06-02 02:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7469,8,'2017-06-02 02:14:01','2017-06-02 02:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7470,8,'2017-06-02 02:15:01','2017-06-02 02:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7471,8,'2017-06-02 02:16:01','2017-06-02 02:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7472,8,'2017-06-02 02:17:01','2017-06-02 02:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7473,8,'2017-06-02 02:18:01','2017-06-02 02:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7474,8,'2017-06-02 02:19:01','2017-06-02 02:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7475,8,'2017-06-02 02:20:01','2017-06-02 02:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7476,8,'2017-06-02 02:21:01','2017-06-02 02:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7477,8,'2017-06-02 02:22:01','2017-06-02 02:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7478,8,'2017-06-02 02:23:01','2017-06-02 02:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7479,8,'2017-06-02 02:24:01','2017-06-02 02:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7480,8,'2017-06-02 02:25:01','2017-06-02 02:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7481,8,'2017-06-02 02:26:01','2017-06-02 02:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7482,8,'2017-06-02 02:27:01','2017-06-02 02:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7483,8,'2017-06-02 02:28:01','2017-06-02 02:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7484,8,'2017-06-02 02:29:01','2017-06-02 02:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7485,8,'2017-06-02 02:30:01','2017-06-02 02:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7486,8,'2017-06-02 02:31:01','2017-06-02 02:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7487,8,'2017-06-02 02:32:01','2017-06-02 02:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7488,8,'2017-06-02 02:33:01','2017-06-02 02:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7489,8,'2017-06-02 02:34:01','2017-06-02 02:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7490,8,'2017-06-02 02:35:01','2017-06-02 02:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7491,8,'2017-06-02 02:36:01','2017-06-02 02:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7492,8,'2017-06-02 02:37:01','2017-06-02 02:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7493,8,'2017-06-02 02:38:01','2017-06-02 02:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7494,8,'2017-06-02 02:39:01','2017-06-02 02:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7495,8,'2017-06-02 02:40:01','2017-06-02 02:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7496,8,'2017-06-02 02:41:01','2017-06-02 02:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7497,8,'2017-06-02 02:42:01','2017-06-02 02:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7498,8,'2017-06-02 02:43:01','2017-06-02 02:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7499,8,'2017-06-02 02:44:01','2017-06-02 02:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7500,8,'2017-06-02 02:45:02','2017-06-02 02:45:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7501,8,'2017-06-02 02:46:01','2017-06-02 02:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7502,8,'2017-06-02 02:47:01','2017-06-02 02:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7503,8,'2017-06-02 02:48:01','2017-06-02 02:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7504,8,'2017-06-02 02:49:01','2017-06-02 02:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7505,8,'2017-06-02 02:50:01','2017-06-02 02:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7506,8,'2017-06-02 02:51:01','2017-06-02 02:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7507,8,'2017-06-02 02:52:01','2017-06-02 02:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7508,8,'2017-06-02 02:53:01','2017-06-02 02:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7509,8,'2017-06-02 02:54:01','2017-06-02 02:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7510,8,'2017-06-02 02:55:01','2017-06-02 02:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7511,8,'2017-06-02 02:56:01','2017-06-02 02:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7512,8,'2017-06-02 02:57:01','2017-06-02 02:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7513,8,'2017-06-02 02:58:01','2017-06-02 02:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7514,8,'2017-06-02 02:59:01','2017-06-02 02:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7515,8,'2017-06-02 03:00:01','2017-06-02 03:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7516,8,'2017-06-02 03:01:01','2017-06-02 03:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7517,8,'2017-06-02 03:02:01','2017-06-02 03:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7518,8,'2017-06-02 03:03:01','2017-06-02 03:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7519,8,'2017-06-02 03:04:01','2017-06-02 03:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7520,8,'2017-06-02 03:05:01','2017-06-02 03:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7521,8,'2017-06-02 03:06:01','2017-06-02 03:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7522,8,'2017-06-02 03:07:02','2017-06-02 03:07:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7523,8,'2017-06-02 03:08:01','2017-06-02 03:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7524,8,'2017-06-02 03:09:01','2017-06-02 03:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7525,8,'2017-06-02 03:10:01','2017-06-02 03:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7526,8,'2017-06-02 03:11:01','2017-06-02 03:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7527,8,'2017-06-02 03:12:01','2017-06-02 03:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7528,8,'2017-06-02 03:13:01','2017-06-02 03:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7529,8,'2017-06-02 03:14:01','2017-06-02 03:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7530,8,'2017-06-02 03:15:01','2017-06-02 03:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7531,8,'2017-06-02 03:16:01','2017-06-02 03:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7532,8,'2017-06-02 03:17:01','2017-06-02 03:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7533,8,'2017-06-02 03:18:01','2017-06-02 03:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7534,8,'2017-06-02 03:19:01','2017-06-02 03:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7535,8,'2017-06-02 03:20:01','2017-06-02 03:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7536,8,'2017-06-02 03:21:02','2017-06-02 03:21:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7537,8,'2017-06-02 03:22:01','2017-06-02 03:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7538,8,'2017-06-02 03:23:01','2017-06-02 03:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7539,8,'2017-06-02 03:24:01','2017-06-02 03:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7540,8,'2017-06-02 03:25:01','2017-06-02 03:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7541,8,'2017-06-02 03:26:01','2017-06-02 03:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7542,8,'2017-06-02 03:27:01','2017-06-02 03:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7543,8,'2017-06-02 03:28:01','2017-06-02 03:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7544,8,'2017-06-02 03:29:01','2017-06-02 03:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7545,8,'2017-06-02 03:30:01','2017-06-02 03:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7546,8,'2017-06-02 03:31:01','2017-06-02 03:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7547,8,'2017-06-02 03:32:01','2017-06-02 03:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7548,8,'2017-06-02 03:33:01','2017-06-02 03:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7549,8,'2017-06-02 03:34:01','2017-06-02 03:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7550,8,'2017-06-02 03:35:01','2017-06-02 03:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7551,8,'2017-06-02 03:36:01','2017-06-02 03:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7552,8,'2017-06-02 03:37:01','2017-06-02 03:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7553,8,'2017-06-02 03:38:01','2017-06-02 03:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7554,8,'2017-06-02 03:39:02','2017-06-02 03:39:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7555,8,'2017-06-02 03:40:01','2017-06-02 03:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7556,8,'2017-06-02 03:41:01','2017-06-02 03:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7557,8,'2017-06-02 03:42:01','2017-06-02 03:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7558,8,'2017-06-02 03:43:02','2017-06-02 03:43:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7559,8,'2017-06-02 03:44:01','2017-06-02 03:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7560,8,'2017-06-02 03:45:01','2017-06-02 03:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7561,8,'2017-06-02 03:46:01','2017-06-02 03:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7562,8,'2017-06-02 03:47:01','2017-06-02 03:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7563,8,'2017-06-02 03:48:01','2017-06-02 03:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7564,8,'2017-06-02 03:49:01','2017-06-02 03:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7565,8,'2017-06-02 03:50:01','2017-06-02 03:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7566,8,'2017-06-02 03:51:01','2017-06-02 03:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7567,8,'2017-06-02 03:52:01','2017-06-02 03:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7568,8,'2017-06-02 03:53:01','2017-06-02 03:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7569,8,'2017-06-02 03:54:01','2017-06-02 03:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7570,8,'2017-06-02 03:55:01','2017-06-02 03:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7571,8,'2017-06-02 03:56:01','2017-06-02 03:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7572,8,'2017-06-02 03:57:01','2017-06-02 03:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7573,8,'2017-06-02 03:58:01','2017-06-02 03:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7574,8,'2017-06-02 03:59:01','2017-06-02 03:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7575,8,'2017-06-02 04:00:01','2017-06-02 04:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7576,8,'2017-06-02 04:01:01','2017-06-02 04:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7577,8,'2017-06-02 04:02:01','2017-06-02 04:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7578,8,'2017-06-02 04:03:02','2017-06-02 04:03:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7579,8,'2017-06-02 04:04:01','2017-06-02 04:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7580,8,'2017-06-02 04:05:01','2017-06-02 04:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7581,8,'2017-06-02 04:06:01','2017-06-02 04:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7582,8,'2017-06-02 04:07:01','2017-06-02 04:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7583,8,'2017-06-02 04:08:01','2017-06-02 04:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7584,8,'2017-06-02 04:09:01','2017-06-02 04:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7585,8,'2017-06-02 04:10:01','2017-06-02 04:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7586,8,'2017-06-02 04:11:01','2017-06-02 04:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7587,8,'2017-06-02 04:12:01','2017-06-02 04:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7588,8,'2017-06-02 04:13:01','2017-06-02 04:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7589,8,'2017-06-02 04:14:01','2017-06-02 04:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7590,8,'2017-06-02 04:15:01','2017-06-02 04:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7591,8,'2017-06-02 04:16:01','2017-06-02 04:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7592,8,'2017-06-02 04:17:01','2017-06-02 04:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7593,8,'2017-06-02 04:18:01','2017-06-02 04:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7594,8,'2017-06-02 04:19:01','2017-06-02 04:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7595,8,'2017-06-02 04:20:01','2017-06-02 04:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7596,8,'2017-06-02 04:21:02','2017-06-02 04:21:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7597,8,'2017-06-02 04:22:01','2017-06-02 04:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7598,8,'2017-06-02 04:23:01','2017-06-02 04:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7599,8,'2017-06-02 04:24:01','2017-06-02 04:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7600,8,'2017-06-02 04:25:01','2017-06-02 04:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7601,8,'2017-06-02 04:26:01','2017-06-02 04:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7602,8,'2017-06-02 04:27:01','2017-06-02 04:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7603,8,'2017-06-02 04:28:01','2017-06-02 04:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7604,8,'2017-06-02 04:29:01','2017-06-02 04:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7605,8,'2017-06-02 04:30:02','2017-06-02 04:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7606,8,'2017-06-02 04:31:01','2017-06-02 04:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7607,8,'2017-06-02 04:32:01','2017-06-02 04:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7608,8,'2017-06-02 04:33:01','2017-06-02 04:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7609,8,'2017-06-02 04:34:01','2017-06-02 04:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7610,8,'2017-06-02 04:35:01','2017-06-02 04:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7611,8,'2017-06-02 04:36:01','2017-06-02 04:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7612,8,'2017-06-02 04:37:01','2017-06-02 04:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7613,8,'2017-06-02 04:38:02','2017-06-02 04:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7614,8,'2017-06-02 04:39:01','2017-06-02 04:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7615,8,'2017-06-02 04:40:01','2017-06-02 04:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7616,8,'2017-06-02 04:41:01','2017-06-02 04:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7617,8,'2017-06-02 04:42:01','2017-06-02 04:42:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7618,8,'2017-06-02 04:43:01','2017-06-02 04:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7619,8,'2017-06-02 04:44:01','2017-06-02 04:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7620,8,'2017-06-02 04:45:01','2017-06-02 04:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7621,8,'2017-06-02 04:46:01','2017-06-02 04:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7622,8,'2017-06-02 04:47:01','2017-06-02 04:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7623,8,'2017-06-02 04:48:01','2017-06-02 04:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7624,8,'2017-06-02 04:49:01','2017-06-02 04:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7625,8,'2017-06-02 04:50:01','2017-06-02 04:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7626,8,'2017-06-02 04:51:01','2017-06-02 04:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7627,8,'2017-06-02 04:52:02','2017-06-02 04:52:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7628,8,'2017-06-02 04:53:01','2017-06-02 04:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7629,8,'2017-06-02 04:54:01','2017-06-02 04:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7630,8,'2017-06-02 04:55:01','2017-06-02 04:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7631,8,'2017-06-02 04:56:01','2017-06-02 04:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7632,8,'2017-06-02 04:57:01','2017-06-02 04:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7633,8,'2017-06-02 04:58:01','2017-06-02 04:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7634,8,'2017-06-02 04:59:01','2017-06-02 04:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7635,8,'2017-06-02 05:00:01','2017-06-02 05:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7636,8,'2017-06-02 05:01:01','2017-06-02 05:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7637,8,'2017-06-02 05:02:01','2017-06-02 05:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7638,8,'2017-06-02 05:03:01','2017-06-02 05:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7639,8,'2017-06-02 05:04:01','2017-06-02 05:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7640,8,'2017-06-02 05:05:01','2017-06-02 05:05:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7641,8,'2017-06-02 05:06:01','2017-06-02 05:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7642,8,'2017-06-02 05:07:01','2017-06-02 05:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7643,8,'2017-06-02 05:08:01','2017-06-02 05:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7644,8,'2017-06-02 05:09:01','2017-06-02 05:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7645,8,'2017-06-02 05:10:01','2017-06-02 05:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7646,8,'2017-06-02 05:11:01','2017-06-02 05:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7647,8,'2017-06-02 05:12:01','2017-06-02 05:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7648,8,'2017-06-02 05:13:01','2017-06-02 05:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7649,8,'2017-06-02 05:14:01','2017-06-02 05:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7650,8,'2017-06-02 05:15:01','2017-06-02 05:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7651,8,'2017-06-02 05:16:01','2017-06-02 05:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7652,8,'2017-06-02 05:17:01','2017-06-02 05:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7653,8,'2017-06-02 05:18:01','2017-06-02 05:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7654,8,'2017-06-02 05:19:01','2017-06-02 05:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7655,8,'2017-06-02 05:20:01','2017-06-02 05:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7656,8,'2017-06-02 05:21:01','2017-06-02 05:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7657,8,'2017-06-02 05:22:01','2017-06-02 05:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7658,8,'2017-06-02 05:23:01','2017-06-02 05:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7659,8,'2017-06-02 05:24:01','2017-06-02 05:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7660,8,'2017-06-02 05:25:01','2017-06-02 05:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7661,8,'2017-06-02 05:26:02','2017-06-02 05:26:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7662,8,'2017-06-02 05:27:01','2017-06-02 05:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7663,8,'2017-06-02 05:28:01','2017-06-02 05:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7664,8,'2017-06-02 05:29:01','2017-06-02 05:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7665,8,'2017-06-02 05:30:01','2017-06-02 05:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7666,8,'2017-06-02 05:31:02','2017-06-02 05:31:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7667,8,'2017-06-02 05:32:01','2017-06-02 05:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7668,8,'2017-06-02 05:33:01','2017-06-02 05:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7669,8,'2017-06-02 05:34:01','2017-06-02 05:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7670,8,'2017-06-02 05:35:02','2017-06-02 05:35:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7671,8,'2017-06-02 05:36:01','2017-06-02 05:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7672,8,'2017-06-02 05:37:01','2017-06-02 05:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7673,8,'2017-06-02 05:38:01','2017-06-02 05:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7674,8,'2017-06-02 05:39:02','2017-06-02 05:39:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7675,8,'2017-06-02 05:40:01','2017-06-02 05:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7676,8,'2017-06-02 05:41:01','2017-06-02 05:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7677,8,'2017-06-02 05:42:01','2017-06-02 05:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7678,8,'2017-06-02 05:43:01','2017-06-02 05:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7679,8,'2017-06-02 05:44:01','2017-06-02 05:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7680,8,'2017-06-02 05:45:01','2017-06-02 05:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7681,8,'2017-06-02 05:46:01','2017-06-02 05:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7682,8,'2017-06-02 05:47:01','2017-06-02 05:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7683,8,'2017-06-02 05:48:01','2017-06-02 05:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7684,8,'2017-06-02 05:49:01','2017-06-02 05:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7685,8,'2017-06-02 05:50:01','2017-06-02 05:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7686,8,'2017-06-02 05:51:01','2017-06-02 05:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7687,8,'2017-06-02 05:52:01','2017-06-02 05:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7688,8,'2017-06-02 05:53:01','2017-06-02 05:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7689,8,'2017-06-02 05:54:02','2017-06-02 05:54:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7690,8,'2017-06-02 05:55:01','2017-06-02 05:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7691,8,'2017-06-02 05:56:01','2017-06-02 05:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7692,8,'2017-06-02 05:57:01','2017-06-02 05:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7693,8,'2017-06-02 05:58:01','2017-06-02 05:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7694,8,'2017-06-02 05:59:01','2017-06-02 05:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7695,8,'2017-06-02 06:00:01','2017-06-02 06:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7696,8,'2017-06-02 06:01:01','2017-06-02 06:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7697,8,'2017-06-02 06:02:01','2017-06-02 06:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7698,8,'2017-06-02 06:03:01','2017-06-02 06:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7699,8,'2017-06-02 06:04:01','2017-06-02 06:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7700,8,'2017-06-02 06:05:01','2017-06-02 06:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7701,8,'2017-06-02 06:06:01','2017-06-02 06:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7702,8,'2017-06-02 06:07:01','2017-06-02 06:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7703,8,'2017-06-02 06:08:01','2017-06-02 06:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7704,8,'2017-06-02 06:09:01','2017-06-02 06:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7705,8,'2017-06-02 06:10:01','2017-06-02 06:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7706,8,'2017-06-02 06:11:01','2017-06-02 06:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7707,8,'2017-06-02 06:12:01','2017-06-02 06:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7708,8,'2017-06-02 06:13:01','2017-06-02 06:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7709,8,'2017-06-02 06:14:01','2017-06-02 06:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7710,8,'2017-06-02 06:15:01','2017-06-02 06:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7711,8,'2017-06-02 06:16:01','2017-06-02 06:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7712,8,'2017-06-02 06:17:02','2017-06-02 06:17:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7713,8,'2017-06-02 06:18:01','2017-06-02 06:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7714,8,'2017-06-02 06:19:01','2017-06-02 06:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7715,8,'2017-06-02 06:20:01','2017-06-02 06:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7716,8,'2017-06-02 06:21:01','2017-06-02 06:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7717,8,'2017-06-02 06:22:01','2017-06-02 06:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7718,8,'2017-06-02 06:23:01','2017-06-02 06:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7719,8,'2017-06-02 06:24:01','2017-06-02 06:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7720,8,'2017-06-02 06:25:01','2017-06-02 06:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7721,8,'2017-06-02 06:26:01','2017-06-02 06:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7722,8,'2017-06-02 06:27:01','2017-06-02 06:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7723,8,'2017-06-02 06:28:01','2017-06-02 06:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7724,8,'2017-06-02 06:29:01','2017-06-02 06:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7725,8,'2017-06-02 06:30:01','2017-06-02 06:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7726,8,'2017-06-02 06:31:01','2017-06-02 06:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7727,8,'2017-06-02 06:32:01','2017-06-02 06:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7728,8,'2017-06-02 06:33:02','2017-06-02 06:33:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7729,8,'2017-06-02 06:34:01','2017-06-02 06:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7730,8,'2017-06-02 06:35:01','2017-06-02 06:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7731,8,'2017-06-02 06:36:01','2017-06-02 06:36:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7732,8,'2017-06-02 06:37:01','2017-06-02 06:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7733,8,'2017-06-02 06:38:01','2017-06-02 06:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7734,8,'2017-06-02 06:39:01','2017-06-02 06:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7735,8,'2017-06-02 06:40:01','2017-06-02 06:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7736,8,'2017-06-02 06:41:01','2017-06-02 06:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7737,8,'2017-06-02 06:42:01','2017-06-02 06:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7738,8,'2017-06-02 06:43:01','2017-06-02 06:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7739,8,'2017-06-02 06:44:01','2017-06-02 06:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7740,8,'2017-06-02 06:45:01','2017-06-02 06:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7741,8,'2017-06-02 06:46:02','2017-06-02 06:46:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7742,8,'2017-06-02 06:47:01','2017-06-02 06:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7743,8,'2017-06-02 06:48:01','2017-06-02 06:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7744,8,'2017-06-02 06:49:01','2017-06-02 06:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7745,8,'2017-06-02 06:50:01','2017-06-02 06:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7746,8,'2017-06-02 06:51:01','2017-06-02 06:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7747,8,'2017-06-02 06:52:01','2017-06-02 06:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7748,8,'2017-06-02 06:53:01','2017-06-02 06:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7749,8,'2017-06-02 06:54:02','2017-06-02 06:54:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7750,8,'2017-06-02 06:55:01','2017-06-02 06:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7751,8,'2017-06-02 06:56:01','2017-06-02 06:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7752,8,'2017-06-02 06:57:01','2017-06-02 06:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7753,8,'2017-06-02 06:58:01','2017-06-02 06:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7754,8,'2017-06-02 06:59:01','2017-06-02 06:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7755,8,'2017-06-02 07:00:01','2017-06-02 07:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7756,8,'2017-06-02 07:01:01','2017-06-02 07:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7757,8,'2017-06-02 07:02:01','2017-06-02 07:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7758,8,'2017-06-02 07:03:01','2017-06-02 07:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7759,8,'2017-06-02 07:04:01','2017-06-02 07:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7760,8,'2017-06-02 07:05:01','2017-06-02 07:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7761,8,'2017-06-02 07:06:02','2017-06-02 07:06:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7762,8,'2017-06-02 07:07:01','2017-06-02 07:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7763,8,'2017-06-02 07:08:01','2017-06-02 07:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7764,8,'2017-06-02 07:09:01','2017-06-02 07:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7765,8,'2017-06-02 07:10:01','2017-06-02 07:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7766,8,'2017-06-02 07:11:01','2017-06-02 07:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7767,8,'2017-06-02 07:12:01','2017-06-02 07:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7768,8,'2017-06-02 07:13:01','2017-06-02 07:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7769,8,'2017-06-02 07:14:01','2017-06-02 07:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7770,8,'2017-06-02 07:15:01','2017-06-02 07:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7771,8,'2017-06-02 07:16:01','2017-06-02 07:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7772,8,'2017-06-02 07:17:01','2017-06-02 07:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7773,8,'2017-06-02 07:18:01','2017-06-02 07:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7774,8,'2017-06-02 07:19:01','2017-06-02 07:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7775,8,'2017-06-02 07:20:01','2017-06-02 07:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7776,8,'2017-06-02 07:21:01','2017-06-02 07:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7777,8,'2017-06-02 07:22:01','2017-06-02 07:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7778,8,'2017-06-02 07:23:01','2017-06-02 07:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7779,8,'2017-06-02 07:24:01','2017-06-02 07:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7780,8,'2017-06-02 07:25:01','2017-06-02 07:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7781,8,'2017-06-02 07:26:01','2017-06-02 07:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7782,8,'2017-06-02 07:27:01','2017-06-02 07:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7783,8,'2017-06-02 07:28:01','2017-06-02 07:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7784,8,'2017-06-02 07:29:01','2017-06-02 07:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7785,8,'2017-06-02 07:30:01','2017-06-02 07:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7786,8,'2017-06-02 07:31:01','2017-06-02 07:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7787,8,'2017-06-02 07:32:01','2017-06-02 07:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7788,8,'2017-06-02 07:33:01','2017-06-02 07:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7789,8,'2017-06-02 07:34:01','2017-06-02 07:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7790,8,'2017-06-02 07:35:02','2017-06-02 07:35:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7791,8,'2017-06-02 07:36:01','2017-06-02 07:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7792,8,'2017-06-02 07:37:01','2017-06-02 07:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7793,8,'2017-06-02 07:38:01','2017-06-02 07:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7794,8,'2017-06-02 07:39:01','2017-06-02 07:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7795,8,'2017-06-02 07:40:01','2017-06-02 07:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7796,8,'2017-06-02 07:41:01','2017-06-02 07:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7797,8,'2017-06-02 07:42:01','2017-06-02 07:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7798,8,'2017-06-02 07:43:01','2017-06-02 07:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7799,8,'2017-06-02 07:44:01','2017-06-02 07:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7800,8,'2017-06-02 07:45:01','2017-06-02 07:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7801,8,'2017-06-02 07:46:01','2017-06-02 07:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7802,8,'2017-06-02 07:47:01','2017-06-02 07:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7803,8,'2017-06-02 07:48:01','2017-06-02 07:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7804,8,'2017-06-02 07:49:01','2017-06-02 07:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7805,8,'2017-06-02 07:50:01','2017-06-02 07:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7806,8,'2017-06-02 07:51:01','2017-06-02 07:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7807,8,'2017-06-02 07:52:01','2017-06-02 07:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7808,8,'2017-06-02 07:53:01','2017-06-02 07:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7809,8,'2017-06-02 07:54:01','2017-06-02 07:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7810,8,'2017-06-02 07:55:01','2017-06-02 07:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7811,8,'2017-06-02 07:56:01','2017-06-02 07:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7812,8,'2017-06-02 07:57:01','2017-06-02 07:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7813,8,'2017-06-02 07:58:01','2017-06-02 07:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7814,8,'2017-06-02 07:59:01','2017-06-02 07:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7815,8,'2017-06-02 08:00:01','2017-06-02 08:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7816,8,'2017-06-02 08:01:01','2017-06-02 08:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7817,8,'2017-06-02 08:02:01','2017-06-02 08:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7818,8,'2017-06-02 08:03:01','2017-06-02 08:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7819,8,'2017-06-02 08:04:01','2017-06-02 08:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7820,8,'2017-06-02 08:05:01','2017-06-02 08:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7821,8,'2017-06-02 08:06:01','2017-06-02 08:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7822,8,'2017-06-02 08:07:01','2017-06-02 08:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7823,8,'2017-06-02 08:08:01','2017-06-02 08:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7824,8,'2017-06-02 08:09:01','2017-06-02 08:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7825,8,'2017-06-02 08:10:01','2017-06-02 08:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7826,8,'2017-06-02 08:11:01','2017-06-02 08:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7827,8,'2017-06-02 08:12:01','2017-06-02 08:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7828,8,'2017-06-02 08:13:01','2017-06-02 08:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7829,8,'2017-06-02 08:14:02','2017-06-02 08:14:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7830,8,'2017-06-02 08:15:01','2017-06-02 08:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7831,8,'2017-06-02 08:16:01','2017-06-02 08:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7832,8,'2017-06-02 08:17:02','2017-06-02 08:17:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7833,8,'2017-06-02 08:18:01','2017-06-02 08:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7834,8,'2017-06-02 08:19:01','2017-06-02 08:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7835,8,'2017-06-02 08:20:02','2017-06-02 08:20:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7836,8,'2017-06-02 08:21:01','2017-06-02 08:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7837,8,'2017-06-02 08:22:01','2017-06-02 08:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7838,8,'2017-06-02 08:23:01','2017-06-02 08:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7839,8,'2017-06-02 08:24:01','2017-06-02 08:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7840,8,'2017-06-02 08:25:01','2017-06-02 08:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7841,8,'2017-06-02 08:26:01','2017-06-02 08:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7842,8,'2017-06-02 08:27:01','2017-06-02 08:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7843,8,'2017-06-02 08:28:02','2017-06-02 08:28:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7844,8,'2017-06-02 08:29:01','2017-06-02 08:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7845,8,'2017-06-02 08:30:01','2017-06-02 08:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7846,8,'2017-06-02 08:31:01','2017-06-02 08:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7847,8,'2017-06-02 08:32:01','2017-06-02 08:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7848,8,'2017-06-02 08:33:02','2017-06-02 08:33:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7849,8,'2017-06-02 08:34:01','2017-06-02 08:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7850,8,'2017-06-02 08:35:01','2017-06-02 08:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7851,8,'2017-06-02 08:36:01','2017-06-02 08:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7852,8,'2017-06-02 08:37:01','2017-06-02 08:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7853,8,'2017-06-02 08:38:01','2017-06-02 08:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7854,8,'2017-06-02 08:39:01','2017-06-02 08:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7855,8,'2017-06-02 08:40:02','2017-06-02 08:40:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7856,8,'2017-06-02 08:41:01','2017-06-02 08:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7857,8,'2017-06-02 08:42:01','2017-06-02 08:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7858,8,'2017-06-02 08:43:01','2017-06-02 08:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7859,8,'2017-06-02 08:44:01','2017-06-02 08:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7860,8,'2017-06-02 08:45:01','2017-06-02 08:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7861,8,'2017-06-02 08:46:01','2017-06-02 08:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7862,8,'2017-06-02 08:47:01','2017-06-02 08:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7863,8,'2017-06-02 08:48:01','2017-06-02 08:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7864,8,'2017-06-02 08:49:01','2017-06-02 08:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7865,8,'2017-06-02 08:50:01','2017-06-02 08:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7866,8,'2017-06-02 08:51:01','2017-06-02 08:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7867,8,'2017-06-02 08:52:01','2017-06-02 08:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7868,8,'2017-06-02 08:53:01','2017-06-02 08:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7869,8,'2017-06-02 08:54:01','2017-06-02 08:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7870,8,'2017-06-02 08:55:01','2017-06-02 08:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7871,8,'2017-06-02 08:56:01','2017-06-02 08:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7872,8,'2017-06-02 08:57:01','2017-06-02 08:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7873,8,'2017-06-02 08:58:01','2017-06-02 08:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7874,8,'2017-06-02 08:59:01','2017-06-02 08:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7875,8,'2017-06-02 09:00:01','2017-06-02 09:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7876,8,'2017-06-02 09:01:01','2017-06-02 09:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7877,8,'2017-06-02 09:02:01','2017-06-02 09:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7878,8,'2017-06-02 09:03:01','2017-06-02 09:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7879,8,'2017-06-02 09:04:01','2017-06-02 09:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7880,8,'2017-06-02 09:05:02','2017-06-02 09:05:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7881,8,'2017-06-02 09:06:01','2017-06-02 09:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7882,8,'2017-06-02 09:07:01','2017-06-02 09:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7883,8,'2017-06-02 09:08:01','2017-06-02 09:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7884,8,'2017-06-02 09:09:01','2017-06-02 09:09:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7885,8,'2017-06-02 09:10:01','2017-06-02 09:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7886,8,'2017-06-02 09:11:01','2017-06-02 09:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7887,8,'2017-06-02 09:12:01','2017-06-02 09:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7888,8,'2017-06-02 09:13:01','2017-06-02 09:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7889,8,'2017-06-02 09:14:01','2017-06-02 09:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7890,8,'2017-06-02 09:15:01','2017-06-02 09:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7891,8,'2017-06-02 09:16:01','2017-06-02 09:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7892,8,'2017-06-02 09:17:01','2017-06-02 09:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7893,8,'2017-06-02 09:18:01','2017-06-02 09:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7894,8,'2017-06-02 09:19:01','2017-06-02 09:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7895,8,'2017-06-02 09:20:01','2017-06-02 09:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7896,8,'2017-06-02 09:21:01','2017-06-02 09:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7897,8,'2017-06-02 09:22:01','2017-06-02 09:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7898,8,'2017-06-02 09:23:02','2017-06-02 09:23:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7899,8,'2017-06-02 09:24:01','2017-06-02 09:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7900,8,'2017-06-02 09:25:01','2017-06-02 09:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7901,8,'2017-06-02 09:26:01','2017-06-02 09:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7902,8,'2017-06-02 09:27:01','2017-06-02 09:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7903,8,'2017-06-02 09:28:01','2017-06-02 09:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7904,8,'2017-06-02 09:29:01','2017-06-02 09:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7905,8,'2017-06-02 09:30:01','2017-06-02 09:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7906,8,'2017-06-02 09:31:01','2017-06-02 09:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7907,8,'2017-06-02 09:32:01','2017-06-02 09:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7908,8,'2017-06-02 09:33:01','2017-06-02 09:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7909,8,'2017-06-02 09:34:01','2017-06-02 09:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7910,8,'2017-06-02 09:35:01','2017-06-02 09:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7911,8,'2017-06-02 09:36:01','2017-06-02 09:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7912,8,'2017-06-02 09:37:01','2017-06-02 09:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7913,8,'2017-06-02 09:38:01','2017-06-02 09:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7914,8,'2017-06-02 09:39:01','2017-06-02 09:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7915,8,'2017-06-02 09:40:01','2017-06-02 09:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7916,8,'2017-06-02 09:41:02','2017-06-02 09:41:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7917,8,'2017-06-02 09:42:01','2017-06-02 09:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7918,8,'2017-06-02 09:43:01','2017-06-02 09:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7919,8,'2017-06-02 09:44:01','2017-06-02 09:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7920,8,'2017-06-02 09:45:01','2017-06-02 09:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7921,8,'2017-06-02 09:46:01','2017-06-02 09:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7922,8,'2017-06-02 09:47:01','2017-06-02 09:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7923,8,'2017-06-02 09:48:01','2017-06-02 09:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7924,8,'2017-06-02 09:49:01','2017-06-02 09:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7925,8,'2017-06-02 09:50:01','2017-06-02 09:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7926,8,'2017-06-02 09:51:01','2017-06-02 09:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7927,8,'2017-06-02 09:52:01','2017-06-02 09:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7928,8,'2017-06-02 09:53:01','2017-06-02 09:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7929,8,'2017-06-02 09:54:02','2017-06-02 09:54:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7930,8,'2017-06-02 09:55:01','2017-06-02 09:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7931,8,'2017-06-02 09:56:01','2017-06-02 09:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7932,8,'2017-06-02 09:57:01','2017-06-02 09:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7933,8,'2017-06-02 09:58:01','2017-06-02 09:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7934,8,'2017-06-02 09:59:01','2017-06-02 09:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7935,8,'2017-06-02 10:00:01','2017-06-02 10:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7936,8,'2017-06-02 10:01:01','2017-06-02 10:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7937,8,'2017-06-02 10:02:01','2017-06-02 10:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7938,8,'2017-06-02 10:03:01','2017-06-02 10:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7939,8,'2017-06-02 10:04:01','2017-06-02 10:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7940,8,'2017-06-02 10:05:01','2017-06-02 10:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7941,8,'2017-06-02 10:06:01','2017-06-02 10:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7942,8,'2017-06-02 10:07:01','2017-06-02 10:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7943,8,'2017-06-02 10:08:01','2017-06-02 10:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7944,8,'2017-06-02 10:09:01','2017-06-02 10:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7945,8,'2017-06-02 10:10:02','2017-06-02 10:10:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7946,8,'2017-06-02 10:11:01','2017-06-02 10:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7947,8,'2017-06-02 10:12:01','2017-06-02 10:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7948,8,'2017-06-02 10:13:01','2017-06-02 10:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7949,8,'2017-06-02 10:14:01','2017-06-02 10:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7950,8,'2017-06-02 10:15:01','2017-06-02 10:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7951,8,'2017-06-02 10:16:01','2017-06-02 10:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7952,8,'2017-06-02 10:17:01','2017-06-02 10:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7953,8,'2017-06-02 10:18:01','2017-06-02 10:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7954,8,'2017-06-02 10:19:01','2017-06-02 10:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7955,8,'2017-06-02 10:20:01','2017-06-02 10:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7956,8,'2017-06-02 10:21:01','2017-06-02 10:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7957,8,'2017-06-02 10:22:01','2017-06-02 10:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7958,8,'2017-06-02 10:23:01','2017-06-02 10:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7959,8,'2017-06-02 10:24:01','2017-06-02 10:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7960,8,'2017-06-02 10:25:01','2017-06-02 10:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7961,8,'2017-06-02 10:26:01','2017-06-02 10:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7962,8,'2017-06-02 10:27:01','2017-06-02 10:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7963,8,'2017-06-02 10:28:01','2017-06-02 10:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7964,8,'2017-06-02 10:29:01','2017-06-02 10:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7965,8,'2017-06-02 10:30:01','2017-06-02 10:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7966,8,'2017-06-02 10:31:01','2017-06-02 10:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7967,8,'2017-06-02 10:32:01','2017-06-02 10:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7968,8,'2017-06-02 10:33:01','2017-06-02 10:33:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7969,8,'2017-06-02 10:34:01','2017-06-02 10:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7970,8,'2017-06-02 10:35:01','2017-06-02 10:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7971,8,'2017-06-02 10:36:01','2017-06-02 10:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7972,8,'2017-06-02 10:37:01','2017-06-02 10:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7973,8,'2017-06-02 10:38:01','2017-06-02 10:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7974,8,'2017-06-02 10:39:01','2017-06-02 10:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7975,8,'2017-06-02 10:40:01','2017-06-02 10:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7976,8,'2017-06-02 10:41:01','2017-06-02 10:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7977,8,'2017-06-02 10:42:01','2017-06-02 10:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7978,8,'2017-06-02 10:43:01','2017-06-02 10:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7979,8,'2017-06-02 10:44:01','2017-06-02 10:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7980,8,'2017-06-02 10:45:01','2017-06-02 10:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7981,8,'2017-06-02 10:46:01','2017-06-02 10:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7982,8,'2017-06-02 10:47:01','2017-06-02 10:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7983,8,'2017-06-02 10:48:01','2017-06-02 10:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7984,8,'2017-06-02 10:49:01','2017-06-02 10:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7985,8,'2017-06-02 10:50:01','2017-06-02 10:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7986,8,'2017-06-02 10:51:01','2017-06-02 10:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7987,8,'2017-06-02 10:52:02','2017-06-02 10:52:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7988,8,'2017-06-02 10:53:01','2017-06-02 10:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7989,8,'2017-06-02 10:54:01','2017-06-02 10:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7990,8,'2017-06-02 10:55:01','2017-06-02 10:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7991,8,'2017-06-02 10:56:01','2017-06-02 10:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7992,8,'2017-06-02 10:57:01','2017-06-02 10:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7993,8,'2017-06-02 10:58:01','2017-06-02 10:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7994,8,'2017-06-02 10:59:01','2017-06-02 10:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7995,8,'2017-06-02 11:00:01','2017-06-02 11:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7996,8,'2017-06-02 11:01:01','2017-06-02 11:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7997,8,'2017-06-02 11:02:01','2017-06-02 11:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7998,8,'2017-06-02 11:03:01','2017-06-02 11:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(7999,8,'2017-06-02 11:04:01','2017-06-02 11:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8000,8,'2017-06-02 11:05:01','2017-06-02 11:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8001,8,'2017-06-02 11:06:01','2017-06-02 11:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8002,8,'2017-06-02 11:07:01','2017-06-02 11:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8003,8,'2017-06-02 11:08:01','2017-06-02 11:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8004,8,'2017-06-02 11:09:01','2017-06-02 11:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8005,8,'2017-06-02 11:10:01','2017-06-02 11:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8006,8,'2017-06-02 11:11:01','2017-06-02 11:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8007,8,'2017-06-02 11:12:01','2017-06-02 11:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8008,8,'2017-06-02 11:13:01','2017-06-02 11:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8009,8,'2017-06-02 11:14:01','2017-06-02 11:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8010,8,'2017-06-02 11:15:01','2017-06-02 11:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8011,8,'2017-06-02 11:16:01','2017-06-02 11:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8012,8,'2017-06-02 11:17:01','2017-06-02 11:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8013,8,'2017-06-02 11:18:01','2017-06-02 11:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8014,8,'2017-06-02 11:19:01','2017-06-02 11:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8015,8,'2017-06-02 11:20:01','2017-06-02 11:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8016,8,'2017-06-02 11:21:01','2017-06-02 11:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8017,8,'2017-06-02 11:22:01','2017-06-02 11:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8018,8,'2017-06-02 11:23:01','2017-06-02 11:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8019,8,'2017-06-02 11:24:01','2017-06-02 11:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8020,8,'2017-06-02 11:25:01','2017-06-02 11:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8021,8,'2017-06-02 11:26:01','2017-06-02 11:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8022,8,'2017-06-02 11:27:01','2017-06-02 11:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8023,8,'2017-06-02 11:28:01','2017-06-02 11:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8024,8,'2017-06-02 11:29:01','2017-06-02 11:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8025,8,'2017-06-02 11:30:01','2017-06-02 11:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8026,8,'2017-06-02 11:31:01','2017-06-02 11:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8027,8,'2017-06-02 11:32:02','2017-06-02 11:32:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8028,8,'2017-06-02 11:33:01','2017-06-02 11:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8029,8,'2017-06-02 11:34:01','2017-06-02 11:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8030,8,'2017-06-02 11:35:01','2017-06-02 11:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8031,8,'2017-06-02 11:36:01','2017-06-02 11:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8032,8,'2017-06-02 11:37:01','2017-06-02 11:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8033,8,'2017-06-02 11:38:02','2017-06-02 11:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8034,8,'2017-06-02 11:39:01','2017-06-02 11:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8035,8,'2017-06-02 11:40:01','2017-06-02 11:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8036,8,'2017-06-02 11:41:01','2017-06-02 11:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8037,8,'2017-06-02 11:42:01','2017-06-02 11:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8038,8,'2017-06-02 11:43:01','2017-06-02 11:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8039,8,'2017-06-02 11:44:01','2017-06-02 11:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8040,8,'2017-06-02 11:45:01','2017-06-02 11:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8041,8,'2017-06-02 11:46:01','2017-06-02 11:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8042,8,'2017-06-02 11:47:01','2017-06-02 11:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8043,8,'2017-06-02 11:48:01','2017-06-02 11:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8044,8,'2017-06-02 11:49:01','2017-06-02 11:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8045,8,'2017-06-02 11:50:01','2017-06-02 11:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8046,8,'2017-06-02 11:51:01','2017-06-02 11:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8047,8,'2017-06-02 11:52:01','2017-06-02 11:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8048,8,'2017-06-02 11:53:01','2017-06-02 11:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8049,8,'2017-06-02 11:54:01','2017-06-02 11:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8050,8,'2017-06-02 11:55:02','2017-06-02 11:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8051,8,'2017-06-02 11:56:01','2017-06-02 11:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8052,8,'2017-06-02 11:57:01','2017-06-02 11:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8053,8,'2017-06-02 11:58:01','2017-06-02 11:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8054,8,'2017-06-02 11:59:01','2017-06-02 11:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8055,8,'2017-06-02 12:00:01','2017-06-02 12:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8056,8,'2017-06-02 12:01:01','2017-06-02 12:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8057,8,'2017-06-02 12:02:01','2017-06-02 12:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8058,8,'2017-06-02 12:03:01','2017-06-02 12:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8059,8,'2017-06-02 12:04:01','2017-06-02 12:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8060,8,'2017-06-02 12:05:01','2017-06-02 12:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8061,8,'2017-06-02 12:06:01','2017-06-02 12:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8062,8,'2017-06-02 12:07:01','2017-06-02 12:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8063,8,'2017-06-02 12:08:01','2017-06-02 12:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8064,8,'2017-06-02 12:09:02','2017-06-02 12:09:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8065,8,'2017-06-02 12:10:01','2017-06-02 12:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8066,8,'2017-06-02 12:11:01','2017-06-02 12:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8067,8,'2017-06-02 12:12:01','2017-06-02 12:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8068,8,'2017-06-02 12:13:01','2017-06-02 12:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8069,8,'2017-06-02 12:14:01','2017-06-02 12:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8070,8,'2017-06-02 12:15:01','2017-06-02 12:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8071,8,'2017-06-02 12:16:01','2017-06-02 12:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8072,8,'2017-06-02 12:17:01','2017-06-02 12:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8073,8,'2017-06-02 12:18:01','2017-06-02 12:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8074,8,'2017-06-02 12:19:01','2017-06-02 12:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8075,8,'2017-06-02 12:20:01','2017-06-02 12:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8076,8,'2017-06-02 12:21:01','2017-06-02 12:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8077,8,'2017-06-02 12:22:01','2017-06-02 12:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8078,8,'2017-06-02 12:23:01','2017-06-02 12:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8079,8,'2017-06-02 12:24:01','2017-06-02 12:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8080,8,'2017-06-02 12:25:01','2017-06-02 12:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8081,8,'2017-06-02 12:26:01','2017-06-02 12:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8082,8,'2017-06-02 12:27:01','2017-06-02 12:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8083,8,'2017-06-02 12:28:01','2017-06-02 12:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8084,8,'2017-06-02 12:29:01','2017-06-02 12:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8085,8,'2017-06-02 12:30:01','2017-06-02 12:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8086,8,'2017-06-02 12:31:01','2017-06-02 12:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8087,8,'2017-06-02 12:32:01','2017-06-02 12:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8088,8,'2017-06-02 12:33:01','2017-06-02 12:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8089,8,'2017-06-02 12:34:02','2017-06-02 12:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8090,8,'2017-06-02 12:35:01','2017-06-02 12:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8091,8,'2017-06-02 12:36:01','2017-06-02 12:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8092,8,'2017-06-02 12:37:01','2017-06-02 12:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8093,8,'2017-06-02 12:38:02','2017-06-02 12:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8094,8,'2017-06-02 12:39:01','2017-06-02 12:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8095,8,'2017-06-02 12:40:01','2017-06-02 12:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8096,8,'2017-06-02 12:41:01','2017-06-02 12:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8097,8,'2017-06-02 12:42:01','2017-06-02 12:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8098,8,'2017-06-02 12:43:01','2017-06-02 12:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8099,8,'2017-06-02 12:44:01','2017-06-02 12:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8100,8,'2017-06-02 12:45:01','2017-06-02 12:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8101,8,'2017-06-02 12:46:01','2017-06-02 12:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8102,8,'2017-06-02 12:47:01','2017-06-02 12:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8103,8,'2017-06-02 12:48:01','2017-06-02 12:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8104,8,'2017-06-02 12:49:01','2017-06-02 12:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8105,8,'2017-06-02 12:50:01','2017-06-02 12:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8106,8,'2017-06-02 12:51:01','2017-06-02 12:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8107,8,'2017-06-02 12:52:02','2017-06-02 12:52:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8108,8,'2017-06-02 12:53:01','2017-06-02 12:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8109,8,'2017-06-02 12:54:01','2017-06-02 12:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8110,8,'2017-06-02 12:55:01','2017-06-02 12:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8111,8,'2017-06-02 12:56:01','2017-06-02 12:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8112,8,'2017-06-02 12:57:01','2017-06-02 12:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8113,8,'2017-06-02 12:58:01','2017-06-02 12:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8114,8,'2017-06-02 12:59:01','2017-06-02 12:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8115,8,'2017-06-02 13:00:01','2017-06-02 13:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8116,8,'2017-06-02 13:01:01','2017-06-02 13:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8117,8,'2017-06-02 13:02:01','2017-06-02 13:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8118,8,'2017-06-02 13:03:01','2017-06-02 13:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8119,8,'2017-06-02 13:04:01','2017-06-02 13:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8120,8,'2017-06-02 13:05:01','2017-06-02 13:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8121,8,'2017-06-02 13:06:01','2017-06-02 13:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8122,8,'2017-06-02 13:07:01','2017-06-02 13:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8123,8,'2017-06-02 13:08:02','2017-06-02 13:08:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8124,8,'2017-06-02 13:09:01','2017-06-02 13:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8125,8,'2017-06-02 13:10:01','2017-06-02 13:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8126,8,'2017-06-02 13:11:01','2017-06-02 13:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8127,8,'2017-06-02 13:12:02','2017-06-02 13:12:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8128,8,'2017-06-02 13:13:01','2017-06-02 13:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8129,8,'2017-06-02 13:14:01','2017-06-02 13:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8130,8,'2017-06-02 13:15:01','2017-06-02 13:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8131,8,'2017-06-02 13:16:02','2017-06-02 13:16:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8132,8,'2017-06-02 13:17:01','2017-06-02 13:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8133,8,'2017-06-02 13:18:01','2017-06-02 13:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8134,8,'2017-06-02 13:19:02','2017-06-02 13:19:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8135,8,'2017-06-02 13:20:01','2017-06-02 13:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8136,8,'2017-06-02 13:21:01','2017-06-02 13:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8137,8,'2017-06-02 13:22:02','2017-06-02 13:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8138,8,'2017-06-02 13:23:01','2017-06-02 13:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8139,8,'2017-06-02 13:24:01','2017-06-02 13:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8140,8,'2017-06-02 13:25:01','2017-06-02 13:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8141,8,'2017-06-02 13:26:01','2017-06-02 13:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8142,8,'2017-06-02 13:27:01','2017-06-02 13:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8143,8,'2017-06-02 13:28:01','2017-06-02 13:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8144,8,'2017-06-02 13:29:01','2017-06-02 13:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8145,8,'2017-06-02 13:30:01','2017-06-02 13:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8146,8,'2017-06-02 13:31:01','2017-06-02 13:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8147,8,'2017-06-02 13:32:01','2017-06-02 13:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8148,8,'2017-06-02 13:33:01','2017-06-02 13:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8149,8,'2017-06-02 13:34:01','2017-06-02 13:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8150,8,'2017-06-02 13:35:01','2017-06-02 13:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8151,8,'2017-06-02 13:36:01','2017-06-02 13:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8152,8,'2017-06-02 13:37:01','2017-06-02 13:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8153,8,'2017-06-02 13:38:01','2017-06-02 13:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8154,8,'2017-06-02 13:39:01','2017-06-02 13:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8155,8,'2017-06-02 13:40:01','2017-06-02 13:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8156,8,'2017-06-02 13:41:01','2017-06-02 13:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8157,8,'2017-06-02 13:42:02','2017-06-02 13:42:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8158,8,'2017-06-02 13:43:01','2017-06-02 13:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8159,8,'2017-06-02 13:44:01','2017-06-02 13:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8160,8,'2017-06-02 13:45:01','2017-06-02 13:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8161,8,'2017-06-02 13:46:01','2017-06-02 13:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8162,8,'2017-06-02 13:47:01','2017-06-02 13:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8163,8,'2017-06-02 13:48:01','2017-06-02 13:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8164,8,'2017-06-02 13:49:01','2017-06-02 13:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8165,8,'2017-06-02 13:50:01','2017-06-02 13:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8166,8,'2017-06-02 13:51:01','2017-06-02 13:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8167,8,'2017-06-02 13:52:01','2017-06-02 13:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8168,8,'2017-06-02 13:53:01','2017-06-02 13:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8169,8,'2017-06-02 13:54:01','2017-06-02 13:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8170,8,'2017-06-02 13:55:01','2017-06-02 13:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8171,8,'2017-06-02 13:56:01','2017-06-02 13:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8172,8,'2017-06-02 13:57:02','2017-06-02 13:57:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8173,8,'2017-06-02 13:58:01','2017-06-02 13:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8174,8,'2017-06-02 13:59:01','2017-06-02 13:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8175,8,'2017-06-02 14:00:01','2017-06-02 14:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8176,8,'2017-06-02 14:01:01','2017-06-02 14:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8177,8,'2017-06-02 14:02:01','2017-06-02 14:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8178,8,'2017-06-02 14:03:01','2017-06-02 14:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8179,8,'2017-06-02 14:04:01','2017-06-02 14:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8180,8,'2017-06-02 14:05:01','2017-06-02 14:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8181,8,'2017-06-02 14:06:01','2017-06-02 14:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8182,8,'2017-06-02 14:07:01','2017-06-02 14:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8183,8,'2017-06-02 14:08:01','2017-06-02 14:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8184,8,'2017-06-02 14:09:01','2017-06-02 14:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8185,8,'2017-06-02 14:10:01','2017-06-02 14:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8186,8,'2017-06-02 14:11:01','2017-06-02 14:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8187,8,'2017-06-02 14:12:01','2017-06-02 14:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8188,8,'2017-06-02 14:13:01','2017-06-02 14:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8189,8,'2017-06-02 14:14:01','2017-06-02 14:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8190,8,'2017-06-02 14:15:01','2017-06-02 14:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8191,8,'2017-06-02 14:16:01','2017-06-02 14:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8192,8,'2017-06-02 14:17:01','2017-06-02 14:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8193,8,'2017-06-02 14:18:01','2017-06-02 14:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8194,8,'2017-06-02 14:19:01','2017-06-02 14:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8195,8,'2017-06-02 14:20:01','2017-06-02 14:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8196,8,'2017-06-02 14:21:01','2017-06-02 14:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8197,8,'2017-06-02 14:22:01','2017-06-02 14:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8198,8,'2017-06-02 14:23:01','2017-06-02 14:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8199,8,'2017-06-02 14:24:02','2017-06-02 14:24:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8200,8,'2017-06-02 14:25:01','2017-06-02 14:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8201,8,'2017-06-02 14:26:01','2017-06-02 14:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8202,8,'2017-06-02 14:27:01','2017-06-02 14:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8203,8,'2017-06-02 14:28:01','2017-06-02 14:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8204,8,'2017-06-02 14:29:01','2017-06-02 14:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8205,8,'2017-06-02 14:30:01','2017-06-02 14:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8206,8,'2017-06-02 14:31:01','2017-06-02 14:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8207,8,'2017-06-02 14:32:01','2017-06-02 14:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8208,8,'2017-06-02 14:33:01','2017-06-02 14:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8209,8,'2017-06-02 14:34:01','2017-06-02 14:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8210,8,'2017-06-02 14:35:01','2017-06-02 14:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8211,8,'2017-06-02 14:36:01','2017-06-02 14:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8212,8,'2017-06-02 14:37:01','2017-06-02 14:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8213,8,'2017-06-02 14:38:01','2017-06-02 14:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8214,8,'2017-06-02 14:39:01','2017-06-02 14:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8215,8,'2017-06-02 14:40:01','2017-06-02 14:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8216,8,'2017-06-02 14:41:02','2017-06-02 14:41:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8217,8,'2017-06-02 14:42:01','2017-06-02 14:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8218,8,'2017-06-02 14:43:01','2017-06-02 14:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8219,8,'2017-06-02 14:44:01','2017-06-02 14:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8220,8,'2017-06-02 14:45:01','2017-06-02 14:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8221,8,'2017-06-02 14:46:01','2017-06-02 14:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8222,8,'2017-06-02 14:47:01','2017-06-02 14:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8223,8,'2017-06-02 14:48:01','2017-06-02 14:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8224,8,'2017-06-02 14:49:01','2017-06-02 14:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8225,8,'2017-06-02 14:50:01','2017-06-02 14:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8226,8,'2017-06-02 14:51:01','2017-06-02 14:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8227,8,'2017-06-02 14:52:01','2017-06-02 14:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8228,8,'2017-06-02 14:53:02','2017-06-02 14:53:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8229,8,'2017-06-02 14:54:01','2017-06-02 14:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8230,8,'2017-06-02 14:55:01','2017-06-02 14:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8231,8,'2017-06-02 14:56:01','2017-06-02 14:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8232,8,'2017-06-02 14:57:01','2017-06-02 14:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8233,8,'2017-06-02 14:58:02','2017-06-02 14:58:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8234,8,'2017-06-02 14:59:01','2017-06-02 14:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8235,8,'2017-06-02 15:00:01','2017-06-02 15:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8236,8,'2017-06-02 15:01:01','2017-06-02 15:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8237,8,'2017-06-02 15:02:01','2017-06-02 15:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8238,8,'2017-06-02 15:03:01','2017-06-02 15:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8239,8,'2017-06-02 15:04:01','2017-06-02 15:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8240,8,'2017-06-02 15:05:01','2017-06-02 15:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8241,8,'2017-06-02 15:06:01','2017-06-02 15:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8242,8,'2017-06-02 15:07:01','2017-06-02 15:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8243,8,'2017-06-02 15:08:01','2017-06-02 15:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8244,8,'2017-06-02 15:09:01','2017-06-02 15:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8245,8,'2017-06-02 15:10:01','2017-06-02 15:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8246,8,'2017-06-02 15:11:01','2017-06-02 15:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8247,8,'2017-06-02 15:12:01','2017-06-02 15:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8248,8,'2017-06-02 15:13:01','2017-06-02 15:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8249,8,'2017-06-02 15:14:01','2017-06-02 15:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8250,8,'2017-06-02 15:15:01','2017-06-02 15:15:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8251,8,'2017-06-02 15:16:01','2017-06-02 15:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8252,8,'2017-06-02 15:17:01','2017-06-02 15:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8253,8,'2017-06-02 15:18:01','2017-06-02 15:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8254,8,'2017-06-02 15:19:01','2017-06-02 15:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8255,8,'2017-06-02 15:20:01','2017-06-02 15:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8256,8,'2017-06-02 15:21:01','2017-06-02 15:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8257,8,'2017-06-02 15:22:01','2017-06-02 15:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8258,8,'2017-06-02 15:23:01','2017-06-02 15:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8259,8,'2017-06-02 15:24:01','2017-06-02 15:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8260,8,'2017-06-02 15:25:01','2017-06-02 15:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8261,8,'2017-06-02 15:26:01','2017-06-02 15:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8262,8,'2017-06-02 15:27:02','2017-06-02 15:27:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8263,8,'2017-06-02 15:28:01','2017-06-02 15:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8264,8,'2017-06-02 15:29:01','2017-06-02 15:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8265,8,'2017-06-02 15:30:01','2017-06-02 15:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8266,8,'2017-06-02 15:31:01','2017-06-02 15:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8267,8,'2017-06-02 15:32:01','2017-06-02 15:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8268,8,'2017-06-02 15:33:01','2017-06-02 15:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8269,8,'2017-06-02 15:34:01','2017-06-02 15:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8270,8,'2017-06-02 15:35:01','2017-06-02 15:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8271,8,'2017-06-02 15:36:01','2017-06-02 15:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8272,8,'2017-06-02 15:37:01','2017-06-02 15:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8273,8,'2017-06-02 15:38:01','2017-06-02 15:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8274,8,'2017-06-02 15:39:01','2017-06-02 15:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8275,8,'2017-06-02 15:40:01','2017-06-02 15:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8276,8,'2017-06-02 15:41:01','2017-06-02 15:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8277,8,'2017-06-02 15:42:01','2017-06-02 15:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8278,8,'2017-06-02 15:43:01','2017-06-02 15:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8279,8,'2017-06-02 15:44:02','2017-06-02 15:44:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8280,8,'2017-06-02 15:45:01','2017-06-02 15:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8281,8,'2017-06-02 15:46:01','2017-06-02 15:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8282,8,'2017-06-02 15:47:01','2017-06-02 15:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8283,8,'2017-06-02 15:48:01','2017-06-02 15:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8284,8,'2017-06-02 15:49:01','2017-06-02 15:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8285,8,'2017-06-02 15:50:01','2017-06-02 15:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8286,8,'2017-06-02 15:51:01','2017-06-02 15:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8287,8,'2017-06-02 15:52:01','2017-06-02 15:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8288,8,'2017-06-02 15:53:01','2017-06-02 15:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8289,8,'2017-06-02 15:54:01','2017-06-02 15:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8290,8,'2017-06-02 15:55:01','2017-06-02 15:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8291,8,'2017-06-02 15:56:01','2017-06-02 15:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8292,8,'2017-06-02 15:57:01','2017-06-02 15:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8293,8,'2017-06-02 15:58:01','2017-06-02 15:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8294,8,'2017-06-02 15:59:01','2017-06-02 15:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8295,8,'2017-06-02 16:00:01','2017-06-02 16:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8296,8,'2017-06-02 16:01:01','2017-06-02 16:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8297,8,'2017-06-02 16:02:01','2017-06-02 16:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8298,8,'2017-06-02 16:03:01','2017-06-02 16:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8299,8,'2017-06-02 16:04:01','2017-06-02 16:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8300,8,'2017-06-02 16:05:02','2017-06-02 16:05:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8301,8,'2017-06-02 16:06:01','2017-06-02 16:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8302,8,'2017-06-02 16:07:01','2017-06-02 16:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8303,8,'2017-06-02 16:08:01','2017-06-02 16:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8304,8,'2017-06-02 16:09:01','2017-06-02 16:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8305,8,'2017-06-02 16:10:01','2017-06-02 16:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8306,8,'2017-06-02 16:11:01','2017-06-02 16:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8307,8,'2017-06-02 16:12:01','2017-06-02 16:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8308,8,'2017-06-02 16:13:01','2017-06-02 16:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8309,8,'2017-06-02 16:14:01','2017-06-02 16:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8310,8,'2017-06-02 16:15:01','2017-06-02 16:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8311,8,'2017-06-02 16:16:01','2017-06-02 16:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8312,8,'2017-06-02 16:17:01','2017-06-02 16:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8313,8,'2017-06-02 16:18:01','2017-06-02 16:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8314,8,'2017-06-02 16:19:01','2017-06-02 16:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8315,8,'2017-06-02 16:20:01','2017-06-02 16:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8316,8,'2017-06-02 16:21:01','2017-06-02 16:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8317,8,'2017-06-02 16:22:01','2017-06-02 16:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8318,8,'2017-06-02 16:23:01','2017-06-02 16:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8319,8,'2017-06-02 16:24:01','2017-06-02 16:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8320,8,'2017-06-02 16:25:01','2017-06-02 16:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8321,8,'2017-06-02 16:26:01','2017-06-02 16:26:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8322,8,'2017-06-02 16:27:01','2017-06-02 16:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8323,8,'2017-06-02 16:28:01','2017-06-02 16:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8324,8,'2017-06-02 16:29:01','2017-06-02 16:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8325,8,'2017-06-02 16:30:02','2017-06-02 16:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8326,8,'2017-06-02 16:31:01','2017-06-02 16:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8327,8,'2017-06-02 16:32:01','2017-06-02 16:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8328,8,'2017-06-02 16:33:01','2017-06-02 16:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8329,8,'2017-06-02 16:34:01','2017-06-02 16:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8330,8,'2017-06-02 16:35:01','2017-06-02 16:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8331,8,'2017-06-02 16:36:01','2017-06-02 16:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8332,8,'2017-06-02 16:37:01','2017-06-02 16:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8333,8,'2017-06-02 16:38:02','2017-06-02 16:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8334,8,'2017-06-02 16:39:01','2017-06-02 16:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8335,8,'2017-06-02 16:40:01','2017-06-02 16:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8336,8,'2017-06-02 16:41:01','2017-06-02 16:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8337,8,'2017-06-02 16:42:01','2017-06-02 16:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8338,8,'2017-06-02 16:43:01','2017-06-02 16:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8339,8,'2017-06-02 16:44:01','2017-06-02 16:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8340,8,'2017-06-02 16:45:01','2017-06-02 16:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8341,8,'2017-06-02 16:46:01','2017-06-02 16:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8342,8,'2017-06-02 16:47:01','2017-06-02 16:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8343,8,'2017-06-02 16:48:01','2017-06-02 16:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8344,8,'2017-06-02 16:49:01','2017-06-02 16:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8345,8,'2017-06-02 16:50:01','2017-06-02 16:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8346,8,'2017-06-02 16:51:01','2017-06-02 16:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8347,8,'2017-06-02 16:52:01','2017-06-02 16:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8348,8,'2017-06-02 16:53:01','2017-06-02 16:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8349,8,'2017-06-02 16:54:01','2017-06-02 16:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8350,8,'2017-06-02 16:55:01','2017-06-02 16:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8351,8,'2017-06-02 16:56:01','2017-06-02 16:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8352,8,'2017-06-02 16:57:01','2017-06-02 16:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8353,8,'2017-06-02 16:58:01','2017-06-02 16:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8354,8,'2017-06-02 16:59:01','2017-06-02 16:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8355,8,'2017-06-02 17:00:01','2017-06-02 17:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8356,8,'2017-06-02 17:01:01','2017-06-02 17:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8357,8,'2017-06-02 17:02:01','2017-06-02 17:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8358,8,'2017-06-02 17:03:01','2017-06-02 17:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8359,8,'2017-06-02 17:04:01','2017-06-02 17:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8360,8,'2017-06-02 17:05:01','2017-06-02 17:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8361,8,'2017-06-02 17:06:01','2017-06-02 17:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8362,8,'2017-06-02 17:07:01','2017-06-02 17:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8363,8,'2017-06-02 17:08:01','2017-06-02 17:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8364,8,'2017-06-02 17:09:01','2017-06-02 17:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8365,8,'2017-06-02 17:10:01','2017-06-02 17:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8366,8,'2017-06-02 17:11:01','2017-06-02 17:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8367,8,'2017-06-02 17:12:01','2017-06-02 17:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8368,8,'2017-06-02 17:13:01','2017-06-02 17:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8369,8,'2017-06-02 17:14:01','2017-06-02 17:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8370,8,'2017-06-02 17:15:01','2017-06-02 17:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8371,8,'2017-06-02 17:16:01','2017-06-02 17:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8372,8,'2017-06-02 17:17:01','2017-06-02 17:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8373,8,'2017-06-02 17:18:01','2017-06-02 17:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8374,8,'2017-06-02 17:19:01','2017-06-02 17:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8375,8,'2017-06-02 17:20:01','2017-06-02 17:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8376,8,'2017-06-02 17:21:01','2017-06-02 17:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8377,8,'2017-06-02 17:22:01','2017-06-02 17:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8378,8,'2017-06-02 17:23:01','2017-06-02 17:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8379,8,'2017-06-02 17:24:01','2017-06-02 17:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8380,8,'2017-06-02 17:25:01','2017-06-02 17:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8381,8,'2017-06-02 17:26:01','2017-06-02 17:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8382,8,'2017-06-02 17:27:01','2017-06-02 17:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8383,8,'2017-06-02 17:28:01','2017-06-02 17:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8384,8,'2017-06-02 17:29:01','2017-06-02 17:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8385,8,'2017-06-02 17:30:01','2017-06-02 17:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8386,8,'2017-06-02 17:31:01','2017-06-02 17:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8387,8,'2017-06-02 17:32:01','2017-06-02 17:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8388,8,'2017-06-02 17:33:01','2017-06-02 17:33:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8389,8,'2017-06-02 17:34:01','2017-06-02 17:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8390,8,'2017-06-02 17:35:01','2017-06-02 17:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8391,8,'2017-06-02 17:36:01','2017-06-02 17:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8392,8,'2017-06-02 17:37:01','2017-06-02 17:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8393,8,'2017-06-02 17:38:01','2017-06-02 17:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8394,8,'2017-06-02 17:39:01','2017-06-02 17:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8395,8,'2017-06-02 17:40:01','2017-06-02 17:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8396,8,'2017-06-02 17:41:01','2017-06-02 17:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8397,8,'2017-06-02 17:42:01','2017-06-02 17:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8398,8,'2017-06-02 17:43:02','2017-06-02 17:43:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8399,8,'2017-06-02 17:44:01','2017-06-02 17:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8400,8,'2017-06-02 17:45:01','2017-06-02 17:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8401,8,'2017-06-02 17:46:01','2017-06-02 17:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8402,8,'2017-06-02 17:47:02','2017-06-02 17:47:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8403,8,'2017-06-02 17:48:01','2017-06-02 17:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8404,8,'2017-06-02 17:49:01','2017-06-02 17:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8405,8,'2017-06-02 17:50:01','2017-06-02 17:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8406,8,'2017-06-02 17:51:01','2017-06-02 17:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8407,8,'2017-06-02 17:52:01','2017-06-02 17:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8408,8,'2017-06-02 17:53:01','2017-06-02 17:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8409,8,'2017-06-02 17:54:01','2017-06-02 17:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8410,8,'2017-06-02 17:55:02','2017-06-02 17:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8411,8,'2017-06-02 17:56:01','2017-06-02 17:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8412,8,'2017-06-02 17:57:01','2017-06-02 17:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8413,8,'2017-06-02 17:58:01','2017-06-02 17:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8414,8,'2017-06-02 17:59:01','2017-06-02 17:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8415,8,'2017-06-02 18:00:01','2017-06-02 18:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8416,8,'2017-06-02 18:01:01','2017-06-02 18:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8417,8,'2017-06-02 18:02:02','2017-06-02 18:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8418,8,'2017-06-02 18:03:01','2017-06-02 18:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8419,8,'2017-06-02 18:04:01','2017-06-02 18:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8420,8,'2017-06-02 18:05:01','2017-06-02 18:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8421,8,'2017-06-02 18:06:01','2017-06-02 18:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8422,8,'2017-06-02 18:07:01','2017-06-02 18:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8423,8,'2017-06-02 18:08:01','2017-06-02 18:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8424,8,'2017-06-02 18:09:01','2017-06-02 18:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8425,8,'2017-06-02 18:10:01','2017-06-02 18:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8426,8,'2017-06-02 18:11:01','2017-06-02 18:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8427,8,'2017-06-02 18:12:01','2017-06-02 18:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8428,8,'2017-06-02 18:13:01','2017-06-02 18:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8429,8,'2017-06-02 18:14:01','2017-06-02 18:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8430,8,'2017-06-02 18:15:01','2017-06-02 18:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8431,8,'2017-06-02 18:16:01','2017-06-02 18:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8432,8,'2017-06-02 18:17:02','2017-06-02 18:17:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8433,8,'2017-06-02 18:18:01','2017-06-02 18:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8434,8,'2017-06-02 18:19:01','2017-06-02 18:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8435,8,'2017-06-02 18:20:01','2017-06-02 18:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8436,8,'2017-06-02 18:21:01','2017-06-02 18:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8437,8,'2017-06-02 18:22:02','2017-06-02 18:22:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8438,8,'2017-06-02 18:23:01','2017-06-02 18:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8439,8,'2017-06-02 18:24:01','2017-06-02 18:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8440,8,'2017-06-02 18:25:01','2017-06-02 18:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8441,8,'2017-06-02 18:26:01','2017-06-02 18:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8442,8,'2017-06-02 18:27:01','2017-06-02 18:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8443,8,'2017-06-02 18:28:01','2017-06-02 18:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8444,8,'2017-06-02 18:29:01','2017-06-02 18:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8445,8,'2017-06-02 18:30:01','2017-06-02 18:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8446,8,'2017-06-02 18:31:01','2017-06-02 18:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8447,8,'2017-06-02 18:32:01','2017-06-02 18:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8448,8,'2017-06-02 18:33:01','2017-06-02 18:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8449,8,'2017-06-02 18:34:02','2017-06-02 18:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8450,8,'2017-06-02 18:35:01','2017-06-02 18:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8451,8,'2017-06-02 18:36:01','2017-06-02 18:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8452,8,'2017-06-02 18:37:01','2017-06-02 18:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8453,8,'2017-06-02 18:38:02','2017-06-02 18:38:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8454,8,'2017-06-02 18:39:01','2017-06-02 18:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8455,8,'2017-06-02 18:40:01','2017-06-02 18:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8456,8,'2017-06-02 18:41:01','2017-06-02 18:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8457,8,'2017-06-02 18:42:01','2017-06-02 18:42:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8458,8,'2017-06-02 18:43:01','2017-06-02 18:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8459,8,'2017-06-02 18:44:01','2017-06-02 18:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8460,8,'2017-06-02 18:45:01','2017-06-02 18:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8461,8,'2017-06-02 18:46:01','2017-06-02 18:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8462,8,'2017-06-02 18:47:01','2017-06-02 18:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8463,8,'2017-06-02 18:48:01','2017-06-02 18:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8464,8,'2017-06-02 18:49:01','2017-06-02 18:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8465,8,'2017-06-02 18:50:01','2017-06-02 18:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8466,8,'2017-06-02 18:51:01','2017-06-02 18:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8467,8,'2017-06-02 18:52:01','2017-06-02 18:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8468,8,'2017-06-02 18:53:01','2017-06-02 18:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8469,8,'2017-06-02 18:54:01','2017-06-02 18:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8470,8,'2017-06-02 18:55:02','2017-06-02 18:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8471,8,'2017-06-02 18:56:01','2017-06-02 18:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8472,8,'2017-06-02 18:57:01','2017-06-02 18:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8473,8,'2017-06-02 18:58:01','2017-06-02 18:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8474,8,'2017-06-02 18:59:01','2017-06-02 18:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8475,8,'2017-06-02 19:00:01','2017-06-02 19:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8476,8,'2017-06-02 19:01:01','2017-06-02 19:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8477,8,'2017-06-02 19:02:01','2017-06-02 19:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8478,8,'2017-06-02 19:03:01','2017-06-02 19:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8479,8,'2017-06-02 19:04:01','2017-06-02 19:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8480,8,'2017-06-02 19:05:01','2017-06-02 19:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8481,8,'2017-06-02 19:06:01','2017-06-02 19:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8482,8,'2017-06-02 19:07:01','2017-06-02 19:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8483,8,'2017-06-02 19:08:01','2017-06-02 19:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8484,8,'2017-06-02 19:09:01','2017-06-02 19:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8485,8,'2017-06-02 19:10:01','2017-06-02 19:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8486,8,'2017-06-02 19:11:01','2017-06-02 19:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8487,8,'2017-06-02 19:12:02','2017-06-02 19:12:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8488,8,'2017-06-02 19:13:01','2017-06-02 19:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8489,8,'2017-06-02 19:14:01','2017-06-02 19:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8490,8,'2017-06-02 19:15:01','2017-06-02 19:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8491,8,'2017-06-02 19:16:01','2017-06-02 19:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8492,8,'2017-06-02 19:17:01','2017-06-02 19:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8493,8,'2017-06-02 19:18:01','2017-06-02 19:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8494,8,'2017-06-02 19:19:02','2017-06-02 19:19:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8495,8,'2017-06-02 19:20:01','2017-06-02 19:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8496,8,'2017-06-02 19:21:01','2017-06-02 19:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8497,8,'2017-06-02 19:22:01','2017-06-02 19:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8498,8,'2017-06-02 19:23:01','2017-06-02 19:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8499,8,'2017-06-02 19:24:01','2017-06-02 19:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8500,8,'2017-06-02 19:25:01','2017-06-02 19:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8501,8,'2017-06-02 19:26:02','2017-06-02 19:26:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8502,8,'2017-06-02 19:27:01','2017-06-02 19:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8503,8,'2017-06-02 19:28:01','2017-06-02 19:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8504,8,'2017-06-02 19:29:01','2017-06-02 19:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8505,8,'2017-06-02 19:30:02','2017-06-02 19:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8506,8,'2017-06-02 19:31:01','2017-06-02 19:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8507,8,'2017-06-02 19:32:01','2017-06-02 19:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8508,8,'2017-06-02 19:33:01','2017-06-02 19:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8509,8,'2017-06-02 19:34:01','2017-06-02 19:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8510,8,'2017-06-02 19:35:02','2017-06-02 19:35:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8511,8,'2017-06-02 19:36:01','2017-06-02 19:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8512,8,'2017-06-02 19:37:01','2017-06-02 19:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8513,8,'2017-06-02 19:38:01','2017-06-02 19:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8514,8,'2017-06-02 19:39:01','2017-06-02 19:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8515,8,'2017-06-02 19:40:01','2017-06-02 19:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8516,8,'2017-06-02 19:41:01','2017-06-02 19:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8517,8,'2017-06-02 19:42:01','2017-06-02 19:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8518,8,'2017-06-02 19:43:01','2017-06-02 19:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8519,8,'2017-06-02 19:44:01','2017-06-02 19:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8520,8,'2017-06-02 19:45:02','2017-06-02 19:45:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8521,8,'2017-06-02 19:46:01','2017-06-02 19:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8522,8,'2017-06-02 19:47:01','2017-06-02 19:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8523,8,'2017-06-02 19:48:01','2017-06-02 19:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8524,8,'2017-06-02 19:49:01','2017-06-02 19:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8525,8,'2017-06-02 19:50:01','2017-06-02 19:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8526,8,'2017-06-02 19:51:01','2017-06-02 19:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8527,8,'2017-06-02 19:52:02','2017-06-02 19:52:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8528,8,'2017-06-02 19:53:01','2017-06-02 19:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8529,8,'2017-06-02 19:54:01','2017-06-02 19:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8530,8,'2017-06-02 19:55:01','2017-06-02 19:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8531,8,'2017-06-02 19:56:01','2017-06-02 19:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8532,8,'2017-06-02 19:57:01','2017-06-02 19:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8533,8,'2017-06-02 19:58:01','2017-06-02 19:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8534,8,'2017-06-02 19:59:01','2017-06-02 19:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8535,8,'2017-06-02 20:00:01','2017-06-02 20:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8536,8,'2017-06-02 20:01:01','2017-06-02 20:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8537,8,'2017-06-02 20:02:01','2017-06-02 20:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8538,8,'2017-06-02 20:03:01','2017-06-02 20:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8539,8,'2017-06-02 20:04:01','2017-06-02 20:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8540,8,'2017-06-02 20:05:01','2017-06-02 20:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8541,8,'2017-06-02 20:06:01','2017-06-02 20:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8542,8,'2017-06-02 20:07:01','2017-06-02 20:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8543,8,'2017-06-02 20:08:01','2017-06-02 20:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8544,8,'2017-06-02 20:09:01','2017-06-02 20:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8545,8,'2017-06-02 20:10:02','2017-06-02 20:10:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8546,8,'2017-06-02 20:11:01','2017-06-02 20:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8547,8,'2017-06-02 20:12:01','2017-06-02 20:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8548,8,'2017-06-02 20:13:01','2017-06-02 20:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8549,8,'2017-06-02 20:14:01','2017-06-02 20:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8550,8,'2017-06-02 20:15:01','2017-06-02 20:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8551,8,'2017-06-02 20:16:01','2017-06-02 20:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8552,8,'2017-06-02 20:17:01','2017-06-02 20:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8553,8,'2017-06-02 20:18:01','2017-06-02 20:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8554,8,'2017-06-02 20:19:01','2017-06-02 20:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8555,8,'2017-06-02 20:20:01','2017-06-02 20:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8556,8,'2017-06-02 20:21:02','2017-06-02 20:21:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8557,8,'2017-06-02 20:22:01','2017-06-02 20:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8558,8,'2017-06-02 20:23:01','2017-06-02 20:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8559,8,'2017-06-02 20:24:01','2017-06-02 20:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8560,8,'2017-06-02 20:25:01','2017-06-02 20:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8561,8,'2017-06-02 20:26:01','2017-06-02 20:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8562,8,'2017-06-02 20:27:01','2017-06-02 20:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8563,8,'2017-06-02 20:28:01','2017-06-02 20:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8564,8,'2017-06-02 20:29:01','2017-06-02 20:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8565,8,'2017-06-02 20:30:01','2017-06-02 20:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8566,8,'2017-06-02 20:31:01','2017-06-02 20:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8567,8,'2017-06-02 20:32:01','2017-06-02 20:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8568,8,'2017-06-02 20:33:01','2017-06-02 20:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8569,8,'2017-06-02 20:34:01','2017-06-02 20:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8570,8,'2017-06-02 20:35:01','2017-06-02 20:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8571,8,'2017-06-02 20:36:01','2017-06-02 20:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8572,8,'2017-06-02 20:37:01','2017-06-02 20:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8573,8,'2017-06-02 20:38:01','2017-06-02 20:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8574,8,'2017-06-02 20:39:01','2017-06-02 20:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8575,8,'2017-06-02 20:40:01','2017-06-02 20:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8576,8,'2017-06-02 20:41:01','2017-06-02 20:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8577,8,'2017-06-02 20:42:01','2017-06-02 20:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8578,8,'2017-06-02 20:43:01','2017-06-02 20:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8579,8,'2017-06-02 20:44:01','2017-06-02 20:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8580,8,'2017-06-02 20:45:01','2017-06-02 20:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8581,8,'2017-06-02 20:46:01','2017-06-02 20:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8582,8,'2017-06-02 20:47:01','2017-06-02 20:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8583,8,'2017-06-02 20:48:01','2017-06-02 20:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8584,8,'2017-06-02 20:49:01','2017-06-02 20:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8585,8,'2017-06-02 20:50:01','2017-06-02 20:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8586,8,'2017-06-02 20:51:01','2017-06-02 20:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8587,8,'2017-06-02 20:52:01','2017-06-02 20:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8588,8,'2017-06-02 20:53:01','2017-06-02 20:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8589,8,'2017-06-02 20:54:02','2017-06-02 20:54:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8590,8,'2017-06-02 20:55:01','2017-06-02 20:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8591,8,'2017-06-02 20:56:01','2017-06-02 20:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8592,8,'2017-06-02 20:57:01','2017-06-02 20:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8593,8,'2017-06-02 20:58:01','2017-06-02 20:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8594,8,'2017-06-02 20:59:01','2017-06-02 20:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8595,8,'2017-06-02 21:00:01','2017-06-02 21:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8596,8,'2017-06-02 21:01:01','2017-06-02 21:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8597,8,'2017-06-02 21:02:01','2017-06-02 21:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8598,8,'2017-06-02 21:03:01','2017-06-02 21:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8599,8,'2017-06-02 21:04:01','2017-06-02 21:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8600,8,'2017-06-02 21:05:01','2017-06-02 21:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8601,8,'2017-06-02 21:06:01','2017-06-02 21:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8602,8,'2017-06-02 21:07:01','2017-06-02 21:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8603,8,'2017-06-02 21:08:01','2017-06-02 21:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8604,8,'2017-06-02 21:09:01','2017-06-02 21:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8605,8,'2017-06-02 21:10:01','2017-06-02 21:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8606,8,'2017-06-02 21:11:01','2017-06-02 21:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8607,8,'2017-06-02 21:12:01','2017-06-02 21:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8608,8,'2017-06-02 21:13:02','2017-06-02 21:13:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8609,8,'2017-06-02 21:14:01','2017-06-02 21:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8610,8,'2017-06-02 21:15:01','2017-06-02 21:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8611,8,'2017-06-02 21:16:01','2017-06-02 21:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8612,8,'2017-06-02 21:17:02','2017-06-02 21:17:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8613,8,'2017-06-02 21:18:01','2017-06-02 21:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8614,8,'2017-06-02 21:19:01','2017-06-02 21:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8615,8,'2017-06-02 21:20:01','2017-06-02 21:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8616,8,'2017-06-02 21:21:01','2017-06-02 21:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8617,8,'2017-06-02 21:22:01','2017-06-02 21:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8618,8,'2017-06-02 21:23:01','2017-06-02 21:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8619,8,'2017-06-02 21:24:01','2017-06-02 21:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8620,8,'2017-06-02 21:25:01','2017-06-02 21:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8621,8,'2017-06-02 21:26:01','2017-06-02 21:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8622,8,'2017-06-02 21:27:01','2017-06-02 21:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8623,8,'2017-06-02 21:28:01','2017-06-02 21:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8624,8,'2017-06-02 21:29:01','2017-06-02 21:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8625,8,'2017-06-02 21:30:01','2017-06-02 21:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8626,8,'2017-06-02 21:31:02','2017-06-02 21:31:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8627,8,'2017-06-02 21:32:01','2017-06-02 21:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8628,8,'2017-06-02 21:33:01','2017-06-02 21:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8629,8,'2017-06-02 21:34:01','2017-06-02 21:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8630,8,'2017-06-02 21:35:01','2017-06-02 21:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8631,8,'2017-06-02 21:36:01','2017-06-02 21:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8632,8,'2017-06-02 21:37:01','2017-06-02 21:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8633,8,'2017-06-02 21:38:01','2017-06-02 21:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8634,8,'2017-06-02 21:39:01','2017-06-02 21:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8635,8,'2017-06-02 21:40:01','2017-06-02 21:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8636,8,'2017-06-02 21:41:01','2017-06-02 21:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8637,8,'2017-06-02 21:42:01','2017-06-02 21:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8638,8,'2017-06-02 21:43:01','2017-06-02 21:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8639,8,'2017-06-02 21:44:01','2017-06-02 21:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8640,8,'2017-06-02 21:45:01','2017-06-02 21:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8641,8,'2017-06-02 21:46:01','2017-06-02 21:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8642,8,'2017-06-02 21:47:01','2017-06-02 21:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8643,8,'2017-06-02 21:48:01','2017-06-02 21:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8644,8,'2017-06-02 21:49:01','2017-06-02 21:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8645,8,'2017-06-02 21:50:01','2017-06-02 21:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8646,8,'2017-06-02 21:51:01','2017-06-02 21:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8647,8,'2017-06-02 21:52:01','2017-06-02 21:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8648,8,'2017-06-02 21:53:01','2017-06-02 21:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8649,8,'2017-06-02 21:54:01','2017-06-02 21:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8650,8,'2017-06-02 21:55:01','2017-06-02 21:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8651,8,'2017-06-02 21:56:02','2017-06-02 21:56:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8652,8,'2017-06-02 21:57:01','2017-06-02 21:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8653,8,'2017-06-02 21:58:01','2017-06-02 21:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8654,8,'2017-06-02 21:59:01','2017-06-02 21:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8655,8,'2017-06-02 22:00:01','2017-06-02 22:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8656,8,'2017-06-02 22:01:01','2017-06-02 22:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8657,8,'2017-06-02 22:02:02','2017-06-02 22:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8658,8,'2017-06-02 22:03:01','2017-06-02 22:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8659,8,'2017-06-02 22:04:01','2017-06-02 22:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8660,8,'2017-06-02 22:05:01','2017-06-02 22:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8661,8,'2017-06-02 22:06:01','2017-06-02 22:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8662,8,'2017-06-02 22:07:01','2017-06-02 22:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8663,8,'2017-06-02 22:08:01','2017-06-02 22:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8664,8,'2017-06-02 22:09:01','2017-06-02 22:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8665,8,'2017-06-02 22:10:01','2017-06-02 22:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8666,8,'2017-06-02 22:11:01','2017-06-02 22:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8667,8,'2017-06-02 22:12:01','2017-06-02 22:12:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8668,8,'2017-06-02 22:13:01','2017-06-02 22:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8669,8,'2017-06-02 22:14:01','2017-06-02 22:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8670,8,'2017-06-02 22:15:01','2017-06-02 22:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8671,8,'2017-06-02 22:16:01','2017-06-02 22:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8672,8,'2017-06-02 22:17:01','2017-06-02 22:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8673,8,'2017-06-02 22:18:01','2017-06-02 22:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8674,8,'2017-06-02 22:19:01','2017-06-02 22:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8675,8,'2017-06-02 22:20:01','2017-06-02 22:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8676,8,'2017-06-02 22:21:01','2017-06-02 22:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8677,8,'2017-06-02 22:22:01','2017-06-02 22:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8678,8,'2017-06-02 22:23:01','2017-06-02 22:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8679,8,'2017-06-02 22:24:01','2017-06-02 22:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8680,8,'2017-06-02 22:25:01','2017-06-02 22:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8681,8,'2017-06-02 22:26:01','2017-06-02 22:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8682,8,'2017-06-02 22:27:01','2017-06-02 22:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8683,8,'2017-06-02 22:28:01','2017-06-02 22:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8684,8,'2017-06-02 22:29:01','2017-06-02 22:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8685,8,'2017-06-02 22:30:01','2017-06-02 22:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8686,8,'2017-06-02 22:31:02','2017-06-02 22:31:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8687,8,'2017-06-02 22:32:01','2017-06-02 22:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8688,8,'2017-06-02 22:33:01','2017-06-02 22:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8689,8,'2017-06-02 22:34:01','2017-06-02 22:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8690,8,'2017-06-02 22:35:01','2017-06-02 22:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8691,8,'2017-06-02 22:36:01','2017-06-02 22:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8692,8,'2017-06-02 22:37:01','2017-06-02 22:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8693,8,'2017-06-02 22:38:01','2017-06-02 22:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8694,8,'2017-06-02 22:39:01','2017-06-02 22:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8695,8,'2017-06-02 22:40:01','2017-06-02 22:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8696,8,'2017-06-02 22:41:01','2017-06-02 22:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8697,8,'2017-06-02 22:42:01','2017-06-02 22:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8698,8,'2017-06-02 22:43:01','2017-06-02 22:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8699,8,'2017-06-02 22:44:02','2017-06-02 22:44:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8700,8,'2017-06-02 22:45:01','2017-06-02 22:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8701,8,'2017-06-02 22:46:01','2017-06-02 22:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8702,8,'2017-06-02 22:47:01','2017-06-02 22:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8703,8,'2017-06-02 22:48:01','2017-06-02 22:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8704,8,'2017-06-02 22:49:01','2017-06-02 22:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8705,8,'2017-06-02 22:50:01','2017-06-02 22:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8706,8,'2017-06-02 22:51:01','2017-06-02 22:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8707,8,'2017-06-02 22:52:01','2017-06-02 22:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8708,8,'2017-06-02 22:53:01','2017-06-02 22:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8709,8,'2017-06-02 22:54:01','2017-06-02 22:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8710,8,'2017-06-02 22:55:02','2017-06-02 22:55:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8711,8,'2017-06-02 22:56:01','2017-06-02 22:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8712,8,'2017-06-02 22:57:01','2017-06-02 22:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8713,8,'2017-06-02 22:58:01','2017-06-02 22:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8714,8,'2017-06-02 22:59:01','2017-06-02 22:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8715,8,'2017-06-02 23:00:01','2017-06-02 23:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8716,8,'2017-06-02 23:01:01','2017-06-02 23:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8717,8,'2017-06-02 23:02:02','2017-06-02 23:02:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8718,8,'2017-06-02 23:03:01','2017-06-02 23:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8719,8,'2017-06-02 23:04:01','2017-06-02 23:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8720,8,'2017-06-02 23:05:01','2017-06-02 23:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8721,8,'2017-06-02 23:06:01','2017-06-02 23:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8722,8,'2017-06-02 23:07:01','2017-06-02 23:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8723,8,'2017-06-02 23:08:01','2017-06-02 23:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8724,8,'2017-06-02 23:09:01','2017-06-02 23:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8725,8,'2017-06-02 23:10:01','2017-06-02 23:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8726,8,'2017-06-02 23:11:01','2017-06-02 23:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8727,8,'2017-06-02 23:12:01','2017-06-02 23:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8728,8,'2017-06-02 23:13:01','2017-06-02 23:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8729,8,'2017-06-02 23:14:01','2017-06-02 23:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8730,8,'2017-06-02 23:15:01','2017-06-02 23:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8731,8,'2017-06-02 23:16:01','2017-06-02 23:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8732,8,'2017-06-02 23:17:01','2017-06-02 23:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8733,8,'2017-06-02 23:18:01','2017-06-02 23:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8734,8,'2017-06-02 23:19:01','2017-06-02 23:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8735,8,'2017-06-02 23:20:01','2017-06-02 23:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8736,8,'2017-06-02 23:21:01','2017-06-02 23:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8737,8,'2017-06-02 23:22:01','2017-06-02 23:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8738,8,'2017-06-02 23:23:01','2017-06-02 23:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8739,8,'2017-06-02 23:24:01','2017-06-02 23:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8740,8,'2017-06-02 23:25:01','2017-06-02 23:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8741,8,'2017-06-02 23:26:01','2017-06-02 23:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8742,8,'2017-06-02 23:27:02','2017-06-02 23:27:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8743,8,'2017-06-02 23:28:01','2017-06-02 23:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8744,8,'2017-06-02 23:29:01','2017-06-02 23:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8745,8,'2017-06-02 23:30:01','2017-06-02 23:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8746,8,'2017-06-02 23:31:01','2017-06-02 23:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8747,8,'2017-06-02 23:32:01','2017-06-02 23:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8748,8,'2017-06-02 23:33:01','2017-06-02 23:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8749,8,'2017-06-02 23:34:01','2017-06-02 23:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8750,8,'2017-06-02 23:35:01','2017-06-02 23:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8751,8,'2017-06-02 23:36:01','2017-06-02 23:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8752,8,'2017-06-02 23:37:01','2017-06-02 23:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8753,8,'2017-06-02 23:38:01','2017-06-02 23:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8754,8,'2017-06-02 23:39:01','2017-06-02 23:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8755,8,'2017-06-02 23:40:01','2017-06-02 23:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8756,8,'2017-06-02 23:41:01','2017-06-02 23:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8757,8,'2017-06-02 23:42:01','2017-06-02 23:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8758,8,'2017-06-02 23:43:01','2017-06-02 23:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8759,8,'2017-06-02 23:44:01','2017-06-02 23:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8760,8,'2017-06-02 23:45:01','2017-06-02 23:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8761,8,'2017-06-02 23:46:02','2017-06-02 23:46:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8762,8,'2017-06-02 23:47:01','2017-06-02 23:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8763,8,'2017-06-02 23:48:01','2017-06-02 23:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8764,8,'2017-06-02 23:49:01','2017-06-02 23:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8765,8,'2017-06-02 23:50:01','2017-06-02 23:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8766,8,'2017-06-02 23:51:01','2017-06-02 23:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8767,8,'2017-06-02 23:52:01','2017-06-02 23:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8768,8,'2017-06-02 23:53:01','2017-06-02 23:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8769,8,'2017-06-02 23:54:01','2017-06-02 23:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8770,8,'2017-06-02 23:55:01','2017-06-02 23:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8771,8,'2017-06-02 23:56:01','2017-06-02 23:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8772,8,'2017-06-02 23:57:01','2017-06-02 23:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8773,8,'2017-06-02 23:58:01','2017-06-02 23:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8774,8,'2017-06-02 23:59:01','2017-06-02 23:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8775,8,'2017-06-03 00:00:01','2017-06-03 00:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8776,8,'2017-06-03 00:01:01','2017-06-03 00:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8777,8,'2017-06-03 00:02:01','2017-06-03 00:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8778,8,'2017-06-03 00:03:01','2017-06-03 00:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8779,8,'2017-06-03 00:04:01','2017-06-03 00:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8780,8,'2017-06-03 00:05:01','2017-06-03 00:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8781,8,'2017-06-03 00:06:01','2017-06-03 00:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8782,8,'2017-06-03 00:07:02','2017-06-03 00:07:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8783,8,'2017-06-03 00:08:01','2017-06-03 00:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8784,8,'2017-06-03 00:09:01','2017-06-03 00:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8785,8,'2017-06-03 00:10:01','2017-06-03 00:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8786,8,'2017-06-03 00:11:01','2017-06-03 00:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8787,8,'2017-06-03 00:12:01','2017-06-03 00:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8788,8,'2017-06-03 00:13:01','2017-06-03 00:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8789,8,'2017-06-03 00:14:01','2017-06-03 00:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8790,8,'2017-06-03 00:15:01','2017-06-03 00:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8791,8,'2017-06-03 00:16:01','2017-06-03 00:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8792,8,'2017-06-03 00:17:01','2017-06-03 00:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8793,8,'2017-06-03 00:18:01','2017-06-03 00:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8794,8,'2017-06-03 00:19:01','2017-06-03 00:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8795,8,'2017-06-03 00:20:01','2017-06-03 00:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8796,8,'2017-06-03 00:21:01','2017-06-03 00:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8797,8,'2017-06-03 00:22:01','2017-06-03 00:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8798,8,'2017-06-03 00:23:01','2017-06-03 00:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8799,8,'2017-06-03 00:24:01','2017-06-03 00:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8800,8,'2017-06-03 00:25:01','2017-06-03 00:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8801,8,'2017-06-03 00:26:01','2017-06-03 00:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8802,8,'2017-06-03 00:27:01','2017-06-03 00:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8803,8,'2017-06-03 00:28:01','2017-06-03 00:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8804,8,'2017-06-03 00:29:02','2017-06-03 00:29:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8805,8,'2017-06-03 00:30:01','2017-06-03 00:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8806,8,'2017-06-03 00:31:01','2017-06-03 00:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8807,8,'2017-06-03 00:32:01','2017-06-03 00:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8808,8,'2017-06-03 00:33:02','2017-06-03 00:33:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8809,8,'2017-06-03 00:34:01','2017-06-03 00:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8810,8,'2017-06-03 00:35:01','2017-06-03 00:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8811,8,'2017-06-03 00:36:01','2017-06-03 00:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8812,8,'2017-06-03 00:37:01','2017-06-03 00:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8813,8,'2017-06-03 00:38:01','2017-06-03 00:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8814,8,'2017-06-03 00:39:01','2017-06-03 00:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8815,8,'2017-06-03 00:40:01','2017-06-03 00:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8816,8,'2017-06-03 00:41:01','2017-06-03 00:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8817,8,'2017-06-03 00:42:01','2017-06-03 00:42:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8818,8,'2017-06-03 00:43:01','2017-06-03 00:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8819,8,'2017-06-03 00:44:01','2017-06-03 00:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8820,8,'2017-06-03 00:45:01','2017-06-03 00:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8821,8,'2017-06-03 00:46:01','2017-06-03 00:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8822,8,'2017-06-03 00:47:01','2017-06-03 00:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8823,8,'2017-06-03 00:48:01','2017-06-03 00:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8824,8,'2017-06-03 00:49:01','2017-06-03 00:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8825,8,'2017-06-03 00:50:01','2017-06-03 00:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8826,8,'2017-06-03 00:51:01','2017-06-03 00:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8827,8,'2017-06-03 00:52:01','2017-06-03 00:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8828,8,'2017-06-03 00:53:01','2017-06-03 00:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8829,8,'2017-06-03 00:54:01','2017-06-03 00:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8830,8,'2017-06-03 00:55:01','2017-06-03 00:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8831,8,'2017-06-03 00:56:01','2017-06-03 00:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8832,8,'2017-06-03 00:57:01','2017-06-03 00:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8833,8,'2017-06-03 00:58:01','2017-06-03 00:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8834,8,'2017-06-03 00:59:01','2017-06-03 00:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8835,8,'2017-06-03 01:00:01','2017-06-03 01:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8836,8,'2017-06-03 01:01:01','2017-06-03 01:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8837,8,'2017-06-03 01:02:01','2017-06-03 01:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8838,8,'2017-06-03 01:03:01','2017-06-03 01:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8839,8,'2017-06-03 01:04:01','2017-06-03 01:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8840,8,'2017-06-03 01:05:01','2017-06-03 01:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8841,8,'2017-06-03 01:06:01','2017-06-03 01:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8842,8,'2017-06-03 01:07:01','2017-06-03 01:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8843,8,'2017-06-03 01:08:01','2017-06-03 01:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8844,8,'2017-06-03 01:09:01','2017-06-03 01:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8845,8,'2017-06-03 01:10:01','2017-06-03 01:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8846,8,'2017-06-03 01:11:01','2017-06-03 01:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8847,8,'2017-06-03 01:12:02','2017-06-03 01:12:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8848,8,'2017-06-03 01:13:01','2017-06-03 01:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8849,8,'2017-06-03 01:14:01','2017-06-03 01:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8850,8,'2017-06-03 01:15:01','2017-06-03 01:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8851,8,'2017-06-03 01:16:01','2017-06-03 01:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8852,8,'2017-06-03 01:17:01','2017-06-03 01:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8853,8,'2017-06-03 01:18:01','2017-06-03 01:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8854,8,'2017-06-03 01:19:01','2017-06-03 01:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8855,8,'2017-06-03 01:20:01','2017-06-03 01:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8856,8,'2017-06-03 01:21:01','2017-06-03 01:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8857,8,'2017-06-03 01:22:01','2017-06-03 01:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8858,8,'2017-06-03 01:23:01','2017-06-03 01:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8859,8,'2017-06-03 01:24:01','2017-06-03 01:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8860,8,'2017-06-03 01:25:01','2017-06-03 01:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8861,8,'2017-06-03 01:26:01','2017-06-03 01:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8862,8,'2017-06-03 01:27:01','2017-06-03 01:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8863,8,'2017-06-03 01:28:01','2017-06-03 01:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8864,8,'2017-06-03 01:29:01','2017-06-03 01:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8865,8,'2017-06-03 01:30:02','2017-06-03 01:30:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8866,8,'2017-06-03 01:31:01','2017-06-03 01:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8867,8,'2017-06-03 01:32:01','2017-06-03 01:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8868,8,'2017-06-03 01:33:01','2017-06-03 01:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8869,8,'2017-06-03 01:34:01','2017-06-03 01:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8870,8,'2017-06-03 01:35:02','2017-06-03 01:35:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8871,8,'2017-06-03 01:36:01','2017-06-03 01:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8872,8,'2017-06-03 01:37:01','2017-06-03 01:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8873,8,'2017-06-03 01:38:01','2017-06-03 01:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8874,8,'2017-06-03 01:39:01','2017-06-03 01:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8875,8,'2017-06-03 01:40:01','2017-06-03 01:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8876,8,'2017-06-03 01:41:02','2017-06-03 01:41:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8877,8,'2017-06-03 01:42:01','2017-06-03 01:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8878,8,'2017-06-03 01:43:01','2017-06-03 01:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8879,8,'2017-06-03 01:44:01','2017-06-03 01:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8880,8,'2017-06-03 01:45:01','2017-06-03 01:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8881,8,'2017-06-03 01:46:01','2017-06-03 01:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8882,8,'2017-06-03 01:47:01','2017-06-03 01:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8883,8,'2017-06-03 01:48:01','2017-06-03 01:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8884,8,'2017-06-03 01:49:01','2017-06-03 01:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8885,8,'2017-06-03 01:50:01','2017-06-03 01:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8886,8,'2017-06-03 01:51:01','2017-06-03 01:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8887,8,'2017-06-03 01:52:02','2017-06-03 01:52:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8888,8,'2017-06-03 01:53:01','2017-06-03 01:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8889,8,'2017-06-03 01:54:01','2017-06-03 01:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8890,8,'2017-06-03 01:55:01','2017-06-03 01:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8891,8,'2017-06-03 01:56:01','2017-06-03 01:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8892,8,'2017-06-03 01:57:01','2017-06-03 01:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8893,8,'2017-06-03 01:58:01','2017-06-03 01:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8894,8,'2017-06-03 01:59:01','2017-06-03 01:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8895,8,'2017-06-03 02:00:02','2017-06-03 02:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8896,8,'2017-06-03 02:01:01','2017-06-03 02:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8897,8,'2017-06-03 02:02:01','2017-06-03 02:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8898,8,'2017-06-03 02:03:01','2017-06-03 02:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8899,8,'2017-06-03 02:04:01','2017-06-03 02:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8900,8,'2017-06-03 02:05:01','2017-06-03 02:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8901,8,'2017-06-03 02:06:01','2017-06-03 02:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8902,8,'2017-06-03 02:07:01','2017-06-03 02:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8903,8,'2017-06-03 02:08:01','2017-06-03 02:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8904,8,'2017-06-03 02:09:02','2017-06-03 02:09:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8905,8,'2017-06-03 02:10:01','2017-06-03 02:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8906,8,'2017-06-03 02:11:01','2017-06-03 02:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8907,8,'2017-06-03 02:12:01','2017-06-03 02:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8908,8,'2017-06-03 02:13:02','2017-06-03 02:13:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8909,8,'2017-06-03 02:14:01','2017-06-03 02:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8910,8,'2017-06-03 02:15:01','2017-06-03 02:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8911,8,'2017-06-03 02:16:01','2017-06-03 02:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8912,8,'2017-06-03 02:17:01','2017-06-03 02:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8913,8,'2017-06-03 02:18:01','2017-06-03 02:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8914,8,'2017-06-03 02:19:01','2017-06-03 02:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8915,8,'2017-06-03 02:20:01','2017-06-03 02:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8916,8,'2017-06-03 02:21:01','2017-06-03 02:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8917,8,'2017-06-03 02:22:01','2017-06-03 02:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8918,8,'2017-06-03 02:23:01','2017-06-03 02:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8919,8,'2017-06-03 02:24:01','2017-06-03 02:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8920,8,'2017-06-03 02:25:02','2017-06-03 02:25:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8921,8,'2017-06-03 02:26:01','2017-06-03 02:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8922,8,'2017-06-03 02:27:01','2017-06-03 02:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8923,8,'2017-06-03 02:28:01','2017-06-03 02:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8924,8,'2017-06-03 02:29:01','2017-06-03 02:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8925,8,'2017-06-03 02:30:01','2017-06-03 02:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8926,8,'2017-06-03 02:31:01','2017-06-03 02:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8927,8,'2017-06-03 02:32:01','2017-06-03 02:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8928,8,'2017-06-03 02:33:01','2017-06-03 02:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8929,8,'2017-06-03 02:34:02','2017-06-03 02:34:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8930,8,'2017-06-03 02:35:01','2017-06-03 02:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8931,8,'2017-06-03 02:36:01','2017-06-03 02:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8932,8,'2017-06-03 02:37:01','2017-06-03 02:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8933,8,'2017-06-03 02:38:01','2017-06-03 02:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8934,8,'2017-06-03 02:39:01','2017-06-03 02:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8935,8,'2017-06-03 02:40:01','2017-06-03 02:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8936,8,'2017-06-03 02:41:01','2017-06-03 02:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8937,8,'2017-06-03 02:42:01','2017-06-03 02:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8938,8,'2017-06-03 02:43:01','2017-06-03 02:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8939,8,'2017-06-03 02:44:01','2017-06-03 02:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8940,8,'2017-06-03 02:45:01','2017-06-03 02:45:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8941,8,'2017-06-03 02:46:01','2017-06-03 02:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8942,8,'2017-06-03 02:47:01','2017-06-03 02:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8943,8,'2017-06-03 02:48:01','2017-06-03 02:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8944,8,'2017-06-03 02:49:01','2017-06-03 02:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8945,8,'2017-06-03 02:50:01','2017-06-03 02:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8946,8,'2017-06-03 02:51:01','2017-06-03 02:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8947,8,'2017-06-03 02:52:01','2017-06-03 02:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8948,8,'2017-06-03 02:53:01','2017-06-03 02:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8949,8,'2017-06-03 02:54:01','2017-06-03 02:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8950,8,'2017-06-03 02:55:01','2017-06-03 02:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8951,8,'2017-06-03 02:56:01','2017-06-03 02:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8952,8,'2017-06-03 02:57:01','2017-06-03 02:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8953,8,'2017-06-03 02:58:01','2017-06-03 02:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8954,8,'2017-06-03 02:59:01','2017-06-03 02:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8955,8,'2017-06-03 03:00:02','2017-06-03 03:00:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8956,8,'2017-06-03 03:01:01','2017-06-03 03:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8957,8,'2017-06-03 03:02:01','2017-06-03 03:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8958,8,'2017-06-03 03:03:01','2017-06-03 03:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8959,8,'2017-06-03 03:04:01','2017-06-03 03:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8960,8,'2017-06-03 03:05:01','2017-06-03 03:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8961,8,'2017-06-03 03:06:01','2017-06-03 03:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8962,8,'2017-06-03 03:07:01','2017-06-03 03:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8963,8,'2017-06-03 03:08:01','2017-06-03 03:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8964,8,'2017-06-03 03:09:01','2017-06-03 03:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8965,8,'2017-06-03 03:10:01','2017-06-03 03:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8966,8,'2017-06-03 03:11:02','2017-06-03 03:11:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8967,8,'2017-06-03 03:12:01','2017-06-03 03:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8968,8,'2017-06-03 03:13:01','2017-06-03 03:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8969,8,'2017-06-03 03:14:01','2017-06-03 03:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8970,8,'2017-06-03 03:15:01','2017-06-03 03:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8971,8,'2017-06-03 03:16:01','2017-06-03 03:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8972,8,'2017-06-03 03:17:01','2017-06-03 03:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8973,8,'2017-06-03 03:18:01','2017-06-03 03:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8974,8,'2017-06-03 03:19:01','2017-06-03 03:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8975,8,'2017-06-03 03:20:01','2017-06-03 03:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8976,8,'2017-06-03 03:21:01','2017-06-03 03:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8977,8,'2017-06-03 03:22:01','2017-06-03 03:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8978,8,'2017-06-03 03:23:01','2017-06-03 03:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8979,8,'2017-06-03 03:24:01','2017-06-03 03:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8980,8,'2017-06-03 03:25:01','2017-06-03 03:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8981,8,'2017-06-03 03:26:01','2017-06-03 03:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8982,8,'2017-06-03 03:27:01','2017-06-03 03:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8983,8,'2017-06-03 03:28:01','2017-06-03 03:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8984,8,'2017-06-03 03:29:01','2017-06-03 03:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8985,8,'2017-06-03 03:30:01','2017-06-03 03:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8986,8,'2017-06-03 03:31:01','2017-06-03 03:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8987,8,'2017-06-03 03:32:01','2017-06-03 03:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8988,8,'2017-06-03 03:33:01','2017-06-03 03:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8989,8,'2017-06-03 03:34:01','2017-06-03 03:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8990,8,'2017-06-03 03:35:01','2017-06-03 03:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8991,8,'2017-06-03 03:36:01','2017-06-03 03:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8992,8,'2017-06-03 03:37:01','2017-06-03 03:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8993,8,'2017-06-03 03:38:01','2017-06-03 03:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8994,8,'2017-06-03 03:39:01','2017-06-03 03:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8995,8,'2017-06-03 03:40:01','2017-06-03 03:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8996,8,'2017-06-03 03:41:01','2017-06-03 03:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8997,8,'2017-06-03 03:42:01','2017-06-03 03:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8998,8,'2017-06-03 03:43:01','2017-06-03 03:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(8999,8,'2017-06-03 03:44:01','2017-06-03 03:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9000,8,'2017-06-03 03:45:01','2017-06-03 03:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9001,8,'2017-06-03 03:46:01','2017-06-03 03:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9002,8,'2017-06-03 03:47:01','2017-06-03 03:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9003,8,'2017-06-03 03:48:01','2017-06-03 03:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9004,8,'2017-06-03 03:49:02','2017-06-03 03:49:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9005,8,'2017-06-03 03:50:01','2017-06-03 03:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9006,8,'2017-06-03 03:51:01','2017-06-03 03:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9007,8,'2017-06-03 03:52:01','2017-06-03 03:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9008,8,'2017-06-03 03:53:01','2017-06-03 03:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9009,8,'2017-06-03 03:54:01','2017-06-03 03:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9010,8,'2017-06-03 03:55:01','2017-06-03 03:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9011,8,'2017-06-03 03:56:01','2017-06-03 03:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9012,8,'2017-06-03 03:57:01','2017-06-03 03:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9013,8,'2017-06-03 03:58:01','2017-06-03 03:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9014,8,'2017-06-03 03:59:01','2017-06-03 03:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9015,8,'2017-06-03 04:00:01','2017-06-03 04:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9016,8,'2017-06-03 04:01:02','2017-06-03 04:01:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9017,8,'2017-06-03 04:02:01','2017-06-03 04:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9018,8,'2017-06-03 04:03:01','2017-06-03 04:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9019,8,'2017-06-03 04:04:01','2017-06-03 04:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9020,8,'2017-06-03 04:05:01','2017-06-03 04:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9021,8,'2017-06-03 04:06:01','2017-06-03 04:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9022,8,'2017-06-03 04:07:02','2017-06-03 04:07:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9023,8,'2017-06-03 04:08:01','2017-06-03 04:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9024,8,'2017-06-03 04:09:01','2017-06-03 04:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9025,8,'2017-06-03 04:10:01','2017-06-03 04:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9026,8,'2017-06-03 04:11:01','2017-06-03 04:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9027,8,'2017-06-03 04:12:01','2017-06-03 04:12:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9028,8,'2017-06-03 04:13:01','2017-06-03 04:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9029,8,'2017-06-03 04:14:01','2017-06-03 04:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9030,8,'2017-06-03 04:15:01','2017-06-03 04:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9031,8,'2017-06-03 04:16:01','2017-06-03 04:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9032,8,'2017-06-03 04:17:01','2017-06-03 04:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9033,8,'2017-06-03 04:18:01','2017-06-03 04:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9034,8,'2017-06-03 04:19:01','2017-06-03 04:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9035,8,'2017-06-03 04:20:01','2017-06-03 04:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9036,8,'2017-06-03 04:21:01','2017-06-03 04:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9037,8,'2017-06-03 04:22:01','2017-06-03 04:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9038,8,'2017-06-03 04:23:01','2017-06-03 04:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9039,8,'2017-06-03 04:24:01','2017-06-03 04:24:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9040,8,'2017-06-03 04:25:01','2017-06-03 04:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9041,8,'2017-06-03 04:26:02','2017-06-03 04:26:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9042,8,'2017-06-03 04:27:01','2017-06-03 04:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9043,8,'2017-06-03 04:28:01','2017-06-03 04:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9044,8,'2017-06-03 04:29:01','2017-06-03 04:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9045,8,'2017-06-03 04:30:01','2017-06-03 04:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9046,8,'2017-06-03 04:31:01','2017-06-03 04:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9047,8,'2017-06-03 04:32:01','2017-06-03 04:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9048,8,'2017-06-03 04:33:02','2017-06-03 04:33:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9049,8,'2017-06-03 04:34:01','2017-06-03 04:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9050,8,'2017-06-03 04:35:01','2017-06-03 04:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9051,8,'2017-06-03 04:36:01','2017-06-03 04:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9052,8,'2017-06-03 04:37:01','2017-06-03 04:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9053,8,'2017-06-03 04:38:01','2017-06-03 04:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9054,8,'2017-06-03 04:39:01','2017-06-03 04:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9055,8,'2017-06-03 04:40:01','2017-06-03 04:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9056,8,'2017-06-03 04:41:01','2017-06-03 04:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9057,8,'2017-06-03 04:42:01','2017-06-03 04:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9058,8,'2017-06-03 04:43:01','2017-06-03 04:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9059,8,'2017-06-03 04:44:01','2017-06-03 04:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9060,8,'2017-06-03 04:45:01','2017-06-03 04:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9061,8,'2017-06-03 04:46:01','2017-06-03 04:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9062,8,'2017-06-03 04:47:02','2017-06-03 04:47:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9063,8,'2017-06-03 04:48:01','2017-06-03 04:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9064,8,'2017-06-03 04:49:01','2017-06-03 04:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9065,8,'2017-06-03 04:50:01','2017-06-03 04:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9066,8,'2017-06-03 04:51:01','2017-06-03 04:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9067,8,'2017-06-03 04:52:01','2017-06-03 04:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9068,8,'2017-06-03 04:53:01','2017-06-03 04:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9069,8,'2017-06-03 04:54:01','2017-06-03 04:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9070,8,'2017-06-03 04:55:01','2017-06-03 04:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9071,8,'2017-06-03 04:56:02','2017-06-03 04:56:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9072,8,'2017-06-03 04:57:01','2017-06-03 04:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9073,8,'2017-06-03 04:58:01','2017-06-03 04:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9074,8,'2017-06-03 04:59:01','2017-06-03 04:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9075,8,'2017-06-03 05:00:01','2017-06-03 05:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9076,8,'2017-06-03 05:01:01','2017-06-03 05:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9077,8,'2017-06-03 05:02:01','2017-06-03 05:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9078,8,'2017-06-03 05:03:01','2017-06-03 05:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9079,8,'2017-06-03 05:04:01','2017-06-03 05:04:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9080,8,'2017-06-03 05:05:01','2017-06-03 05:05:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9081,8,'2017-06-03 05:06:01','2017-06-03 05:06:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9082,8,'2017-06-03 05:07:01','2017-06-03 05:07:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9083,8,'2017-06-03 05:08:01','2017-06-03 05:08:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9084,8,'2017-06-03 05:09:01','2017-06-03 05:09:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9085,8,'2017-06-03 05:10:01','2017-06-03 05:10:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9086,8,'2017-06-03 05:11:01','2017-06-03 05:11:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9087,8,'2017-06-03 05:12:01','2017-06-03 05:12:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9088,8,'2017-06-03 05:13:01','2017-06-03 05:13:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9089,8,'2017-06-03 05:14:01','2017-06-03 05:14:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9090,8,'2017-06-03 05:15:01','2017-06-03 05:15:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9091,8,'2017-06-03 05:16:01','2017-06-03 05:16:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9092,8,'2017-06-03 05:17:01','2017-06-03 05:17:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9093,8,'2017-06-03 05:18:01','2017-06-03 05:18:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9094,8,'2017-06-03 05:19:01','2017-06-03 05:19:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9095,8,'2017-06-03 05:20:01','2017-06-03 05:20:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9096,8,'2017-06-03 05:21:01','2017-06-03 05:21:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9097,8,'2017-06-03 05:22:01','2017-06-03 05:22:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9098,8,'2017-06-03 05:23:01','2017-06-03 05:23:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9099,8,'2017-06-03 05:24:02','2017-06-03 05:24:02','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9100,8,'2017-06-03 05:25:01','2017-06-03 05:25:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9101,8,'2017-06-03 05:26:01','2017-06-03 05:26:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9102,8,'2017-06-03 05:27:01','2017-06-03 05:27:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9103,8,'2017-06-03 05:28:01','2017-06-03 05:28:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9104,8,'2017-06-03 05:29:01','2017-06-03 05:29:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9105,8,'2017-06-03 05:30:01','2017-06-03 05:30:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9106,8,'2017-06-03 05:31:01','2017-06-03 05:31:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9107,8,'2017-06-03 05:32:01','2017-06-03 05:32:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9108,8,'2017-06-03 05:33:01','2017-06-03 05:33:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9109,8,'2017-06-03 05:34:01','2017-06-03 05:34:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9110,8,'2017-06-03 05:35:01','2017-06-03 05:35:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9111,8,'2017-06-03 05:36:01','2017-06-03 05:36:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9112,8,'2017-06-03 05:37:01','2017-06-03 05:37:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9113,8,'2017-06-03 05:38:01','2017-06-03 05:38:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9114,8,'2017-06-03 05:39:01','2017-06-03 05:39:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9115,8,'2017-06-03 05:40:01','2017-06-03 05:40:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9116,8,'2017-06-03 05:41:01','2017-06-03 05:41:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9117,8,'2017-06-03 05:42:01','2017-06-03 05:42:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9118,8,'2017-06-03 05:43:01','2017-06-03 05:43:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9119,8,'2017-06-03 05:44:01','2017-06-03 05:44:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9120,8,'2017-06-03 05:45:01','2017-06-03 05:45:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9121,8,'2017-06-03 05:46:01','2017-06-03 05:46:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9122,8,'2017-06-03 05:47:01','2017-06-03 05:47:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9123,8,'2017-06-03 05:48:01','2017-06-03 05:48:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9124,8,'2017-06-03 05:49:01','2017-06-03 05:49:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9125,8,'2017-06-03 05:50:01','2017-06-03 05:50:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9126,8,'2017-06-03 05:51:01','2017-06-03 05:51:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9127,8,'2017-06-03 05:52:01','2017-06-03 05:52:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9128,8,'2017-06-03 05:53:01','2017-06-03 05:53:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9129,8,'2017-06-03 05:54:01','2017-06-03 05:54:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9130,8,'2017-06-03 05:55:01','2017-06-03 05:55:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9131,8,'2017-06-03 05:56:01','2017-06-03 05:56:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9132,8,'2017-06-03 05:57:01','2017-06-03 05:57:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9133,8,'2017-06-03 05:58:01','2017-06-03 05:58:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9134,8,'2017-06-03 05:59:01','2017-06-03 05:59:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9135,8,'2017-06-03 06:00:01','2017-06-03 06:00:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9136,8,'2017-06-03 06:01:01','2017-06-03 06:01:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9137,8,'2017-06-03 06:02:01','2017-06-03 06:02:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9138,8,'2017-06-03 06:03:01','2017-06-03 06:03:01','finished','p3plcpnl0500.prod.phx3.secureserver.net',''),(9139,8,'2017-06-03 06:04:01','2017-06-03 06:04:01','finished','p3plcpnl0500.prod.phx3.secu