<?php

class pluginMediaconverter extends Plugin
{

    public $config = null;

    public function __construct()
    {
        // get the plugin config
        include(DOC_ROOT.'/plugins/mediaconverter/_plugin_config.inc.php');

        // load config into the object
        $this->config = $pluginConfig;
        $this->cachePath = CACHE_DIRECTORY_ROOT . '/plugins/mediaconverter/';
    }

    public function getPluginDetails()
    {
        return $this->config;
    }
    
    public function uninstall()
    {
        // setup database
        $db = Database::getDatabase();

        // remove plugin specific tables
        $sQL = 'DROP TABLE plugin_mediaconverter_queue';
        $db->query($sQL);
        
        $sQL = 'DROP TABLE plugin_mediaconverter_watermark';
        $db->query($sQL);

        return parent::uninstall();
    }
    
    public function deleteMediaCache($fileId)
    {
        // get cache path
        $cacheFilePath = $this->cachePath . $fileId . '/';

        // queue for delete
        $serverId = file::getDefaultLocalServerId();
        if ($serverId)
        {
            // get all file listing
            $files = coreFunctions::getDirectoryListing($cacheFilePath);
            if (COUNT($files))
            {
                foreach ($files AS $file)
                {
                    fileAction::queueDeleteFile($serverId, $file, $fileId);
                }
            }

            // add folder aswell
            fileAction::queueDeleteFile($serverId, $cacheFilePath, $fileId);
        }
    }

}