<?php

require_once('../../../core/includes/master.inc.php');
require_once('../bp_options.php');
require_once('../bp_lib.php');

// load plugin details
$pluginConfig   = pluginHelper::pluginSpecificConfiguration('bitpay');
$pluginSettings = $pluginConfig['data']['plugin_settings'];
$apiKey         = '';
if (strlen($pluginSettings))
{
    $pluginSettingsArr = json_decode($pluginSettings, true);
    $apiKey            = $pluginSettingsArr['api_key'];
}

if (!isset($_REQUEST['days']))
{
    redirect(WEB_ROOT . '/index.html');
}

if (strlen($apiKey) == 0)
{
    redirect(WEB_ROOT . '/index.html');
}

// require login
if (!isset($_REQUEST['i']))
{
    $Auth->requireUser(WEB_ROOT.'/login.'.SITE_CONFIG_PAGE_EXTENSION);
    $userId    = $Auth->id;
    $username  = $Auth->username;
    $userEmail = $Auth->email;
}
else
{
    $user = UserPeer::loadUserByIdentifier($_REQUEST['i']);
    if (!$user)
    {
        die('User not found!');
    }

    $userId    = $user->id;
    $username  = $user->username;
    $userEmail = $user->email;
}

$days = (int) (trim($_REQUEST['days']));

$fileId = null;
if (isset($_REQUEST['f']))
{
    $file = file::loadByShortUrl($_REQUEST['f']);
    if ($file)
    {
        $fileId = $file->id;
    }
}

// create order entry
$orderHash = MD5(time() . $userId);
$amount    = number_format(constant('SITE_CONFIG_COST_FOR_' . $days . '_DAYS_PREMIUM'), 2);
$order     = OrderPeer::create($userId, $orderHash, $days, $amount, $fileId);
if ($order)
{
    // redirect to the payment gateway
    $desc = $days . ' days extension for ' . $username;

    // create invoice
    $posData = array($amount, $orderHash);
    $options = array(
        'apiKey'            => $apiKey,
        'notificationURL'   => PLUGIN_WEB_ROOT . '/bitpay/site/_payment_ipn.php',
        'transactionSpeed'  => 'low',
        'fullNotifications' => false,
        'itemDesc'          => $desc,
        'currency'          => 'USD',
        'redirectURL'       => WEB_ROOT . '/payment_complete.' . SITE_CONFIG_PAGE_EXTENSION,
        'buyerEmail'        => $userEmail,
    );

    $invoice = bpCreateInvoice(NULL, $amount, $posData, $options);
    if (isset($invoice['error']))
    {
        print 'Error creating BitPay invoice: '.$invoice['error']['message'];
        die;
    }

    // save bitpay invoice id in a file named after the ecwid invoice id
    //file_put_contents($_POST['x_invoice_num'].'.inv', $invoice['id']);
    // redirect to bitpay
    redirect($invoice['url']);
}