<?php

// global includes
require_once('../../../core/includes/master.inc.php');

// load plugin details
$pluginConfig   = pluginHelper::pluginSpecificConfiguration('stripe');
$pluginSettings = $pluginConfig['data']['plugin_settings'];
$settingsArr    = json_decode($pluginSettings, true);

// get token
$user_id         = (int)$_REQUEST['user_id'];

// check auth
if($user_id != $Auth->id)
{
    // redirect back to payment failed page
    redirect(WEB_ROOT . '/upgrade.' . SITE_CONFIG_PAGE_EXTENSION);
}

// load subscriptions for user
$subs = $db->getRows('SELECT * FROM plugin_stripe_subscription WHERE user_id = '.$user_id);
if(COUNT($subs) == 0)
{
    // redirect back to payment failed page
    coreFunctions::redirect(WEB_ROOT . '/upgrade.' . SITE_CONFIG_PAGE_EXTENSION);
}

// validate token with stripe
require_once('./lib/Stripe.php');
Stripe::setApiKey($settingsArr['secret_key']); // secret key

foreach($subs AS $sub)
{
    $customer = Stripe_Customer::retrieve($sub['stripe_customer_id']);
    if($customer)
    {
        $rs = $customer->subscriptions->retrieve($sub['stripe_subscription_id'])->cancel();
        if (!$rs)
        {
            die('Error: Could not cancel subscription.');
        }
        
        // clear database entry
        $db->query('DELETE FROM plugin_stripe_subscription WHERE user_id = '.$user_id.' AND id = '.(int)$sub['id'].' LIMIT 1');
    }
}

// redirect to confirmation page
coreFunctions::redirect(PLUGIN_WEB_ROOT . '/stripe/site/cancel_subscription_confirm.' . SITE_CONFIG_PAGE_EXTENSION);