<?php
$days = array(7, 30, 90, 180, 365);
?>
<div class="row pricing-table">
		<!--FREE DAYS-->
		<div class="col-price-5ths col-xs-6">
            <div class="panel panel-success">
                <div class="panel-heading">
                    <h3 class="text-center"><strong>FREE</strong><br/> User</h3>
                </div>
                <div class="panel-body text-center">
                    <p class="lead total-price" style="font-size:40px"><strong>0<?php echo SITE_CONFIG_COST_CURRENCY_SYMBOL; ?></strong></p>
                    <p class="lead price-per-day" style="font-size:16px"><?php echo SITE_CONFIG_COST_CURRENCY_SYMBOL; ?><?php echo number_format(str_replace(",", "", constant('SITE_CONFIG_COST_FOR_' . $day . '_DAYS_PREMIUM')) / $day, 2); ?> <?php echo UCWords(t('upgrade_boxes_per_day', 'per day')); ?></p>
                </div>
                <ul class="list-group list-group-flush text-center">
					<li class="list-group-item"><i class="fa fa-hdd-o"></i> 2GB storage</li>
					<li class="list-group-item"><i class="fa fa-tachometer"></i>Regular Speed</li>
                    <li class="list-group-item"><i class="fa fa-magnet"></i> 1 Active Torrent</li>
                    <li class="list-group-item"><i class="fa fa-eye-slash"></i> <?php echo UCWords(t('safe_and_anonymous', '100% Safe & Anonymous')); ?></li>
                    <li class="list-group-item payment-method"><a class="btn btn-default btn-lg" href="<?php echo coreFunctions::getCoreSitePath(); ?>/register.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="fa fa-check"></i>&nbsp; Register</a></li>
                </ul>
                
            </div>
        </div>
    <?php foreach ($days AS $k => $day): ?>
        <div class="col-price-5ths col-xs-6">
            <div class="panel panel-success">
                <div class="panel-heading">
                    <h3 class="text-center"><strong><?php echo $day; ?> <?php echo UCWords(t('days', 'days')); ?></strong><br/><?php echo UCWords(t('premium', 'premium')); ?></h3>
                </div>
                <div class="panel-body text-center">
                    <p class="lead total-price" style="font-size:40px"><strong><?php echo SITE_CONFIG_COST_CURRENCY_SYMBOL; ?><?php echo number_format(str_replace(",", "", constant('SITE_CONFIG_COST_FOR_' . $day . '_DAYS_PREMIUM')), 2); ?></strong></p>
                    <p class="lead price-per-day" style="font-size:16px"><?php echo SITE_CONFIG_COST_CURRENCY_SYMBOL; ?><?php echo number_format(str_replace(",", "", constant('SITE_CONFIG_COST_FOR_' . $day . '_DAYS_PREMIUM')) / $day, 2); ?> <?php echo UCWords(t('upgrade_boxes_per_day', 'per day')); ?></p>
                </div>
                <ul class="list-group list-group-flush text-center">
					<li class="list-group-item"><i class="fa fa-hdd-o"></i> 100GB Storage</li>
					<li class="list-group-item"><i class="fa fa-tachometer"></i>Unlimited Speed</li>
                    <li class="list-group-item"><i class="fa fa-magnet"></i> 25 Active Torrents</li>
                    <li class="list-group-item"><i class="fa fa-eye-slash"></i><i class="fa fa-lock"></i>100% Safe, Secure & Anonymous</li>
                    <li class="list-group-item payment-method"><?php echo UCWords(t('select_payment_method', 'Select Payment Method:')); ?></li>
                </ul>
                <div class="panel-footer">
                    <?php
                    pluginHelper::outputPaymentLinks($day);
                    ?>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>